/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.EscapeProcessor;
import interbase.interclient.IBException;
import interbase.interclient.Statement;
import java.sql.BatchUpdateException;
import java.sql.DriverManager;
import java.sql.SQLException;

abstract class BatchSql {
    private int numberBatched = 0;
    private int batchArraySize = 0;
    private EscapeProcessor escapeProcessor;
    private boolean expressProcessorEnabled;
    protected Statement stmt_;

    BatchSql(Statement statement, EscapeProcessor escapeProcessor) {
        this.escapeProcessor = escapeProcessor;
        this.expressProcessorEnabled = true;
        this.stmt_ = statement;
    }

    BatchSql() {
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    void setNumberBatched(int n) {
        this.numberBatched = n;
    }

    int getNumberBatched() {
        return this.numberBatched;
    }

    void incNumberBatched() {
        ++this.numberBatched;
    }

    void setEscapeProcessorEnabled(boolean bl) {
        this.expressProcessorEnabled = bl;
    }

    String doEscape(String string) throws SQLException {
        String string2 = null;
        if (this.expressProcessorEnabled) {
            string2 = this.escapeProcessor.doEscapeProcessing(string, this.stmt_.connection_.getAttachmentSQLDialect());
        }
        return string2;
    }

    abstract void addBatch(String var1) throws SQLException;

    void checkForSize(long l) throws SQLException {
        this.batchArraySize = (int)((long)this.batchArraySize + l);
        if (this.batchArraySize >= 65534) {
            this.batchArraySize = (int)((long)this.batchArraySize - l);
            throw new IBException(225544008L);
        }
    }

    void clear() {
        if (this.numberBatched != 0) {
            this.batchArraySize = 0;
            this.numberBatched = 0;
        }
    }

    int[] executeBatch() throws BatchUpdateException {
        this.println("executeBatch: Batch size: " + this.numberBatched, this);
        if (this.numberBatched == 0) {
            int[] nArray = new int[]{};
            return nArray;
        }
        int[] nArray = new int[this.numberBatched];
        return nArray;
    }

    final void println(String string, BatchSql batchSql) {
        DriverManager.println("  \"  :  \"  :" + string + " [" + batchSql + "]");
    }
}

