/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BatchSql;
import interbase.interclient.EscapeProcessor;
import interbase.interclient.Statement;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;

class BatchSqlBelow15
extends BatchSql {
    private ArrayList batchArray = null;

    BatchSqlBelow15(Statement statement, EscapeProcessor escapeProcessor) {
        super(statement, escapeProcessor);
        this.println("Created batchBelow15", this);
    }

    protected void finalize() throws Throwable {
        this.clear();
        super.finalize();
    }

    void addBatch(String string) throws SQLException {
        String string2 = super.doEscape(string);
        this.checkForSize(string2.length());
        if (this.batchArray == null) {
            this.batchArray = new ArrayList();
        }
        this.batchArray.add(string2);
        super.incNumberBatched();
    }

    int[] executeBatch() throws BatchUpdateException {
        int[] nArray = super.executeBatch();
        int n = 0;
        try {
            for (n = 0; n < this.getNumberBatched(); ++n) {
                nArray[n] = this.stmt_.executeUpdate(this.batchArray.get(n).toString());
            }
        }
        catch (SQLException sQLException) {
            int[] nArray2 = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray2[i] = nArray[i];
            }
            throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray2);
        }
        return nArray;
    }

    void clear() {
        if (this.batchArray != null) {
            this.batchArray.clear();
            this.batchArray = null;
        }
        super.clear();
    }
}

