/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.IBException;
import interbase.interclient.IscBlobHandle;
import interbase.interclient.Statement;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

class BlobInput {
    long blobId = 0L;
    static final int binary = 0;
    private static final int BUF_SIZE = 4096;
    private IBException sqlWarnings_;

    BlobInput(Statement statement, InputStream inputStream, int n) throws SQLException {
        IscBlobHandle iscBlobHandle = statement.connection_.ibase_.getNewIscBlobHandle();
        try {
            statement.connection_.setTransaction();
            statement.connection_.ibase_.iscCreateBlob2(statement.connection_.db_, statement.connection_.tra_, iscBlobHandle, null, this.sqlWarnings_);
            byte[] byArray = new byte[4096];
            try {
                while (n > 0) {
                    int n2 = inputStream.read(byArray, 0, n < 4096 ? n : 4096);
                    if (n2 < 4096) {
                        byte[] byArray2 = new byte[n2];
                        System.arraycopy(byArray, 0, byArray2, 0, n2);
                        statement.connection_.ibase_.iscPutSegment(iscBlobHandle, byArray2, this.sqlWarnings_);
                    } else {
                        statement.connection_.ibase_.iscPutSegment(iscBlobHandle, byArray, this.sqlWarnings_);
                    }
                    n -= n2;
                }
                statement.connection_.ibase_.iscCloseBlob(iscBlobHandle, this.sqlWarnings_);
                this.blobId = iscBlobHandle.getBlobId();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        }
        catch (IBException iBException) {
            throw new SQLException(iBException.getMessage());
        }
    }

    private ByteArrayOutputStream setBlobBinaryStream(InputStream inputStream, int n) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        byte[] byArray = new byte[4096];
        try {
            while (n > 0) {
                int n2 = inputStream.read(byArray, 0, n < 4096 ? n : 4096);
                byteArrayOutputStream.write(byArray, 0, n2);
                n -= n2;
            }
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
        return byteArrayOutputStream;
    }
}

