/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import java.util.Vector;

final class BufferCache {
    private static final int minBufferLength__ = 1024;
    private static final int minCharBufferLength__ = 256;
    private static int maxMemoryCached__ = 500000;
    private static int maxMemoryCachedPerConnection__ = 500000;
    private int numConnections_ = 1;
    private int memoryCached_ = 0;
    private Vector cachedBuffers_ = new Vector(12, 12);
    private Vector cachedCharBuffers_ = new Vector(12, 12);

    BufferCache() {
    }

    synchronized void incrementConnectionCount() {
        ++this.numConnections_;
        maxMemoryCached__ += maxMemoryCachedPerConnection__;
    }

    synchronized void decrementConnectionCount() {
        --this.numConnections_;
        maxMemoryCached__ -= maxMemoryCachedPerConnection__;
    }

    synchronized byte[] takeBuffer(int n) {
        for (int i = 0; i < this.cachedBuffers_.size(); ++i) {
            byte[] byArray = (byte[])this.cachedBuffers_.elementAt(i);
            if (byArray.length < n) continue;
            this.cachedBuffers_.removeElementAt(i);
            this.memoryCached_ -= byArray.length;
            return byArray;
        }
        return new byte[Math.max(n, 1024)];
    }

    synchronized void returnBuffer(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        boolean bl = false;
        this.memoryCached_ += byArray.length;
        for (int i = 0; i < this.cachedBuffers_.size(); ++i) {
            if (((byte[])this.cachedBuffers_.elementAt(i)).length <= byArray.length) continue;
            this.cachedBuffers_.insertElementAt(byArray, i);
            bl = true;
            break;
        }
        if (!bl) {
            this.cachedBuffers_.addElement(byArray);
        }
    }

    synchronized char[] takeCharBuffer(int n) {
        for (int i = 0; i < this.cachedCharBuffers_.size(); ++i) {
            char[] cArray = (char[])this.cachedCharBuffers_.elementAt(i);
            if (cArray.length < n) continue;
            this.cachedCharBuffers_.removeElementAt(i);
            return cArray;
        }
        return new char[Math.max(n, 256)];
    }

    synchronized void returnCharBuffer(char[] cArray) {
        if (cArray == null) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < this.cachedCharBuffers_.size(); ++i) {
            if (((char[])this.cachedCharBuffers_.elementAt(i)).length <= cArray.length) continue;
            this.cachedCharBuffers_.insertElementAt(cArray, i);
            bl = true;
            break;
        }
        if (!bl) {
            this.cachedCharBuffers_.addElement(cArray);
        }
    }
}

