/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.ErrorKey;
import interbase.interclient.UnsupportedCharacterSetException;
import java.util.Hashtable;

public final class CharacterEncodings {
    public static final String NONE = "NONE";
    public static final String _8859_1 = "8859_1";
    public static final String _8859_2 = "8859_2";
    public static final String _8859_15 = "8859_15";
    public static final String _KOI8_R = "KOI8_R";
    public static final String Big5 = "Big5";
    public static final String Cp1250 = "Cp1250";
    public static final String Cp1251 = "Cp1251";
    public static final String Cp1252 = "Cp1252";
    public static final String Cp1253 = "Cp1253";
    public static final String Cp1254 = "Cp1254";
    public static final String Cp437 = "Cp437";
    public static final String Cp850 = "Cp850";
    public static final String Cp852 = "Cp852";
    public static final String Cp857 = "Cp857";
    public static final String Cp860 = "Cp860";
    public static final String Cp861 = "Cp861";
    public static final String Cp863 = "Cp863";
    public static final String Cp865 = "Cp865";
    public static final String EUCJIS = "EUCJIS";
    public static final String GB2312 = "GB2312";
    public static final String KSC5601 = "KSC5601";
    public static final String SJIS = "SJIS";
    public static final String UnicodeFSS = "UTF8";
    public static final String UTF8 = "UTF8";
    public static final String UTF16LE = "UnicodeLittleUnmarked";
    public static final String UTF16BE = "UnicodeBigUnmarked";
    public static final String DYNAMIC = "DYNAMIC";
    private static final String[] supportedEncodings__ = new String[]{"NONE", "UTF8", "8859_1", "8859_2", "8859_15", "Big5", "Cp1250", "Cp1251", "Cp1252", "Cp1253", "Cp1254", "Cp437", "Cp850", "Cp852", "Cp857", "Cp860", "Cp861", "Cp863", "Cp865", "EUCJIS", "GB2312", "KSC5601", "KOI8_R", "SJIS", "UnicodeLittleUnmarked", "UnicodeBigUnmarked", "UTF8"};
    private static Hashtable ianaToIBCharNameTable__ = new Hashtable();

    CharacterEncodings() {
    }

    static final String getCharacterSetName(int n) {
        switch (n) {
            case 2: {
                return Cp437;
            }
            case 59: {
                return "UTF8";
            }
            case 3: {
                return "UTF8";
            }
            case 5: {
                return SJIS;
            }
            case 6: {
                return EUCJIS;
            }
            case 10: {
                return Cp437;
            }
            case 11: {
                return Cp850;
            }
            case 12: {
                return Cp865;
            }
            case 13: {
                return Cp860;
            }
            case 14: {
                return Cp863;
            }
            case 21: {
                return _8859_1;
            }
            case 22: {
                return _8859_2;
            }
            case 39: {
                return _8859_15;
            }
            case 44: {
                return KSC5601;
            }
            case 45: {
                return Cp852;
            }
            case 46: {
                return Cp857;
            }
            case 47: {
                return Cp861;
            }
            case 51: {
                return Cp1250;
            }
            case 52: {
                return Cp1251;
            }
            case 53: {
                return Cp1252;
            }
            case 54: {
                return Cp1253;
            }
            case 55: {
                return Cp1254;
            }
            case 58: {
                return _KOI8_R;
            }
            case 50: {
                return null;
            }
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 19: {
                return null;
            }
        }
        return null;
    }

    public static String getInterBaseCharacterSetName(String string) throws UnsupportedCharacterSetException {
        String string2 = (String)ianaToIBCharNameTable__.get(string);
        if (string2 == null) {
            throw new UnsupportedCharacterSetException(ErrorKey.unsupportedCharacterSet__0__, string);
        }
        return string2;
    }

    public static String[] getSupportedEncodings() {
        return supportedEncodings__;
    }

    static boolean isOneByteCharSet(int n) {
        return IBCharacterSets.isOneByteCharSet(n);
    }

    static boolean isTwoByteCharSet(int n) {
        return IBCharacterSets.isTwoByteCharSet(n);
    }

    static boolean isThreeByteCharSet(int n) {
        return IBCharacterSets.isThreeByteCharSet(n);
    }

    static boolean isFourByteCharSet(int n) {
        return IBCharacterSets.isFourByteCharSet(n);
    }

    static {
        ianaToIBCharNameTable__.put(NONE, NONE);
        ianaToIBCharNameTable__.put(_8859_1, "ISO8859_1");
        ianaToIBCharNameTable__.put(_8859_2, "ISO8859_2");
        ianaToIBCharNameTable__.put(_8859_15, "ISO8859_15");
        ianaToIBCharNameTable__.put(Cp1250, "WIN1250");
        ianaToIBCharNameTable__.put(Cp1251, "WIN1251");
        ianaToIBCharNameTable__.put(Cp1252, "WIN1252");
        ianaToIBCharNameTable__.put(Cp1253, "WIN1253");
        ianaToIBCharNameTable__.put(Cp1254, "WIN1254");
        ianaToIBCharNameTable__.put(Cp437, "DOS437");
        ianaToIBCharNameTable__.put(Cp850, "DOS850");
        ianaToIBCharNameTable__.put(Cp852, "DOS852");
        ianaToIBCharNameTable__.put(Cp857, "DOS857");
        ianaToIBCharNameTable__.put(Cp860, "DOS860");
        ianaToIBCharNameTable__.put(Cp861, "DOS861");
        ianaToIBCharNameTable__.put(Cp863, "DOS863");
        ianaToIBCharNameTable__.put(Cp865, "DOS865");
        ianaToIBCharNameTable__.put(EUCJIS, "EUCJ_0208");
        ianaToIBCharNameTable__.put(GB2312, "GB_2312");
        ianaToIBCharNameTable__.put(KSC5601, "KSC_5601");
        ianaToIBCharNameTable__.put(_KOI8_R, "KOI8R");
        ianaToIBCharNameTable__.put(SJIS, "SJIS_0208");
        ianaToIBCharNameTable__.put("UTF8", "UTF8");
        ianaToIBCharNameTable__.put(UTF16BE, "UNICODE_BE");
        ianaToIBCharNameTable__.put(UTF16LE, "UNICODE_LE");
        ianaToIBCharNameTable__.put("UTF8", "UNICODE_FSS");
    }

    private static final class IBCharacterSets {
        private IBCharacterSets() {
        }

        static boolean isOneByteCharSet(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 19: 
                case 21: 
                case 22: 
                case 39: 
                case 45: 
                case 46: 
                case 47: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 58: 
                case 127: {
                    return true;
                }
            }
            return false;
        }

        static boolean isTwoByteCharSet(int n) {
            switch (n) {
                case 5: 
                case 6: 
                case 44: {
                    return true;
                }
            }
            return false;
        }

        static boolean isThreeByteCharSet(int n) {
            return n == 3;
        }

        static boolean isFourByteCharSet(int n) {
            switch (n) {
                case 8: 
                case 59: 
                case 64: {
                    return true;
                }
            }
            return false;
        }
    }
}

