/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.CallableStatement;
import interbase.interclient.CharacterEncodings;
import interbase.interclient.DatabaseMetaData;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.EscapeProcessor;
import interbase.interclient.IBConnectionRequestInfo;
import interbase.interclient.IBException;
import interbase.interclient.IBSavepoint;
import interbase.interclient.Ibase;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.IscDbHandle;
import interbase.interclient.IscTrHandle;
import interbase.interclient.PreparedStatement;
import interbase.interclient.ResultSet;
import interbase.interclient.SQLDialectException;
import interbase.interclient.Statement;
import interbase.interclient.URLSyntaxException;
import interbase.interclient.UnlicensedComponentException;
import interbase.interclient.UnsupportedCharacterSetException;
import interbase.interclient.Utils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;

public final class Connection
implements java.sql.Connection {
    String database_;
    String serverName_;
    int port_;
    Properties properties_;
    boolean open_ = true;
    private boolean retaining_ = false;
    boolean transactionStartedOnServer_ = false;
    DatabaseMetaData databaseMetaData_;
    Vector openStatements_;
    Vector openPreparedStatements_;
    private Vector openSavepoints;
    private int savepointId = 0;
    private IBException sqlWarnings_ = null;
    ByteToCharConverter btc_;
    CharToByteConverter ctb_;
    IBConnectionRequestInfo ibCri = new IBConnectionRequestInfo();
    final Ibase ibase_ = new Ibase();
    IscDbHandle db_;
    IscTrHandle tra_;
    IscTrHandle traDdl_ = null;
    private TransactionProperties mainTraProps = null;
    private TransactionProperties ddlTraProps = null;
    Set tpb_ = new HashSet();
    private int resultType_ = 1003;
    int resultSetConcurrency_ = 1007;
    String ianaCharacterEncoding_;
    boolean charsetWasNone;
    private boolean createDatabase_;
    private static final String defaultEncoding__ = "8859_1";
    public static final int TRANSACTION_NONE = 0;
    public static final int TRANSACTION_READ_UNCOMMITTED = 1;
    public static final int TRANSACTION_READ_COMMITTED = 2;
    public static final int TRANSACTION_REPEATABLE_READ = 4;
    public static final int TRANSACTION_SERIALIZABLE = 8;
    public static final int TRANSACTION_SNAPSHOT = 8;
    public static final int TRANSACTION_SNAPSHOT_TABLE_STABILITY = 16;
    public static final int LOCK_RESOLUTION_WAIT = 0;
    public static final int LOCK_RESOLUTION_NO_WAIT = 1;
    public static final int IGNORE_UNCOMMITTED_RECORD_VERSIONS_ON_READ = 1;
    public static final int RECOGNIZE_UNCOMMITTED_RECORD_VERSIONS_ON_READ = 0;
    public static final int TABLELOCK_SHARED_WRITE = 0;
    public static final int TABLELOCK_SHARED_READ = 1;
    public static final int TABLELOCK_PROTECTED_WRITE = 2;
    public static final int TABLELOCK_PROTECTED_READ = 4;

    private void tokenizeProperties(Properties properties, String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "?=");
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                properties.setProperty(string2, string3);
            }
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new URLSyntaxException(ErrorKey.urlSyntax__bad_server_suffix_0__, string);
        }
    }

    Connection(int n, String string, int n2, String string2, Properties properties) throws SQLException {
        int n3 = string2.indexOf(63);
        String string3 = null;
        if (n3 != -1) {
            string3 = string2.substring(n3, string2.length());
            string2 = string2.substring(0, n3);
            this.tokenizeProperties(properties, string3);
        }
        this.serverName_ = string;
        this.port_ = n2;
        this.database_ = string2;
        this.properties_ = (Properties)properties.clone();
        this.println("CONNECT{8.1.1}: server:" + string + " database:" + string2 + " port:" + n2 + " socket time out:" + n, this);
        if (this.properties_ == null) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__connection_properties__null__);
        }
        this.addRequiredPropertiesAndSetConverters();
        this.openStatements_ = new Vector();
        this.openPreparedStatements_ = new Vector();
        this.connect(n);
    }

    private void addRequiredPropertiesAndSetConverters() throws SQLDialectException, SQLDialectException, InvalidArgumentException, IBException {
        if (this.properties_ == null || this.properties_.getProperty("user") == null || this.properties_.getProperty("password") == null || this.properties_.getProperty("user").equals("") || this.properties_.getProperty("password").equals("")) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__connection_properties__no_user_or_password__);
        }
        String string = this.properties_.getProperty("sqlDialect");
        try {
            int n;
            if (string != null && (n = Integer.parseInt(string)) < 0) {
                throw new SQLDialectException(ErrorKey.invalidArgument__connection_properties__sql_dialect__, string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLDialectException(ErrorKey.invalidArgument__connection_properties__sql_dialect__, string);
        }
        this.ianaCharacterEncoding_ = (String)this.properties_.get("charSet");
        if (this.ianaCharacterEncoding_ == null || this.ianaCharacterEncoding_.equals("NONE")) {
            this.ianaCharacterEncoding_ = defaultEncoding__;
            this.properties_.put("charSet", "NONE");
            this.charsetWasNone = true;
        } else {
            this.charsetWasNone = false;
        }
        Boolean bl = null;
        bl = new Boolean(this.properties_.getProperty("create"));
        this.createDatabase_ = bl != false;
        String string2 = this.properties_.getProperty("logWriterFile");
        if (string2 != null) {
            try {
                DriverManager.setLogWriter(new PrintWriter(new FileOutputStream(string2)));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IBException(225544010, string2);
            }
        }
    }

    void checkForClosedConnection() throws SQLException {
        if (!this.open_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__connection_closed__);
        }
    }

    private void connect(int n) throws SQLException {
        try {
            this.btc_ = ByteToCharConverter.getConverter((String)this.ianaCharacterEncoding_);
            this.ctb_ = CharToByteConverter.getConverter((String)this.ianaCharacterEncoding_);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharacterSetException(ErrorKey.unsupportedCharacterSet__0__, this.ianaCharacterEncoding_);
        }
        Date date = new Date();
        try {
            this.databaseMetaData_ = new DatabaseMetaData(this);
            this.remote_ATTACH_DATABASE(n);
            this.mainTraProps = new TransactionProperties();
        }
        catch (IBException iBException) {
            throw new SQLException(iBException.getMessage());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
    }

    static int setConnectionRequestInfo(Properties properties, IBConnectionRequestInfo iBConnectionRequestInfo) throws SQLException {
        int n = 0;
        int n2 = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++n;
        }
        Enumeration<?> enumeration2 = properties.propertyNames();
        while (enumeration2.hasMoreElements()) {
            String string = (String)enumeration2.nextElement();
            if (string.equals("user")) {
                iBConnectionRequestInfo.setUser(properties.getProperty(string).toUpperCase());
                continue;
            }
            if (string.equals("password")) {
                iBConnectionRequestInfo.setPassword((String)properties.get("password"));
                continue;
            }
            if (string.equals("roleName")) {
                iBConnectionRequestInfo.setProperty(60, properties.getProperty(string).toUpperCase());
                continue;
            }
            if (string.equals("charSet")) {
                iBConnectionRequestInfo.setProperty(48, CharacterEncodings.getInterBaseCharacterSetName(properties.getProperty(string)));
                continue;
            }
            if (string.equalsIgnoreCase("sqlDialect")) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(properties.getProperty(string));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = (Integer)properties.get(string);
                }
                if (n3 < 0) {
                    n3 = 1;
                } else if (n3 > 3) {
                    n3 = 3;
                }
                iBConnectionRequestInfo.setProperty(63, n3);
                continue;
            }
            if (string.equals("portNumber")) {
                try {
                    n2 = Integer.parseInt(properties.getProperty(string));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = (Integer)properties.get(string);
                }
                continue;
            }
            if (string.equals("interBaseLicense")) {
                iBConnectionRequestInfo.setProperty(18, properties.getProperty(string));
                continue;
            }
            if (string.equals("sweepOnConnect")) {
                if (!properties.getProperty(string).toLowerCase().equals("true")) continue;
                iBConnectionRequestInfo.setProperty(10, 1);
                continue;
            }
            if (!string.equals("suggestedCachePages")) continue;
            int n4 = Integer.parseInt(properties.getProperty(string));
            if (n4 > 255) {
                n4 = 255;
            }
            if (n4 == 0) continue;
            iBConnectionRequestInfo.setProperty(5, n4);
        }
        return n2;
    }

    private void remote_ATTACH_DATABASE(int n) throws SQLException, IBException {
        try {
            int n2;
            this.db_ = this.charsetWasNone ? this.ibase_.getNewIscDbHandle(null) : this.ibase_.getNewIscDbHandle(this.ianaCharacterEncoding_);
            int n3 = Connection.setConnectionRequestInfo(this.properties_, this.ibCri);
            if (n3 != 0) {
                this.port_ = n3;
            }
            this.databaseMetaData_.userName_ = this.ibCri.getUser();
            byte[] byArray = this.ibCri.getProperty(63);
            this.databaseMetaData_.attachmentSQLDialect_ = byArray != null ? byArray[0] : 0;
            try {
                this.println("Attach database", this);
                this.ibase_.iscAttachDatabase(this.database_, this.serverName_, this.port_, n, this.db_, this.ibCri.getDpb(), this.sqlWarnings_);
            }
            catch (IBException iBException) {
                if (!this.createDatabase_) {
                    throw iBException;
                }
                this.println("Create database", this);
                this.ibase_.iscCreateDatabase(this.database_, this.serverName_, this.port_, n, this.db_, this.ibCri.getDpb(), this.sqlWarnings_);
            }
            byte[] byArray2 = new byte[]{12, 32, 33, 14, 21, 13, 62, 63, 71, 1};
            byte[] byArray3 = this.ibase_.iscDatabaseInfo(this.db_, byArray2, 1024, this.sqlWarnings_);
            if (byArray3[0] == 3 || byArray3[0] == 2) {
                // empty if block
            }
            int n4 = 0;
            while (byArray3[n4] != 1) {
                int n5;
                n2 = Ibase.iscVaxInteger(byArray3, n4 + 1, 2);
                if (12 == byArray3[n4]) {
                    try {
                        n5 = Ibase.iscVaxInteger(byArray3, n4 + 4, 1);
                        this.databaseMetaData_.databaseProductVersion_ = new String(byArray3, n4 + 3 + 3 + n5, n2 - 3 - n5, defaultEncoding__);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new SQLException("unsupported encoding ");
                    }
                } else if (32 == byArray3[n4]) {
                    this.databaseMetaData_.odsMajorVersion_ = Ibase.iscVaxInteger(byArray3, n4 + 3, n2);
                } else if (33 == byArray3[n4]) {
                    this.databaseMetaData_.odsMinorVersion_ = Ibase.iscVaxInteger(byArray3, n4 + 3, n2);
                } else if (14 == byArray3[n4]) {
                    this.databaseMetaData_.pageSize_ = Ibase.iscVaxInteger(byArray3, n4 + 3, n2);
                } else if (21 == byArray3[n4]) {
                    this.databaseMetaData_.pageAllocation_ = Ibase.iscVaxInteger(byArray3, n4 + 3, n2);
                } else if (13 == byArray3[n4]) {
                    this.databaseMetaData_.ibMajorVersion_ = byArray3[n4 + 3 + 1];
                } else if (62 == byArray3[n4]) {
                    this.databaseMetaData_.databaseSQLDialect_ = Ibase.iscVaxInteger(byArray3, n4 + 3, n2);
                } else if (63 == byArray3[n4]) {
                    n5 = Ibase.iscVaxInteger(byArray3, n4 + 3, n2);
                    this.databaseMetaData_.databaseReadOnly_ = n5 > 0;
                } else if (71 == byArray3[n4]) {
                    this.databaseMetaData_.ibMinorVersion_ = byArray3[n4 + 3 + 1];
                }
                n4 = n4 + 3 + n2;
            }
            if (this.databaseMetaData_.odsMajorVersion_ < 10) {
                this.databaseMetaData_.databaseReadOnly_ = false;
                this.databaseMetaData_.attachmentSQLDialect_ = this.databaseMetaData_.databaseSQLDialect_ = 1;
            } else {
                byte[] byArray4 = this.ibCri.getProperty(63);
                this.databaseMetaData_.attachmentSQLDialect_ = byArray4 != null ? ((n2 = Ibase.iscVaxInteger(byArray4, 0, 4)) > 3 || n2 < 1 ? this.databaseMetaData_.databaseSQLDialect_ : n2) : this.databaseMetaData_.databaseSQLDialect_;
            }
            if (!this.isCompatibleIBVersion(this.databaseMetaData_.databaseProductVersion_)) {
                throw new UnlicensedComponentException(ErrorKey.unlicensedComponent__incompatible_ibversion_0__, (Object)this.databaseMetaData_.databaseProductVersion_);
            }
        }
        catch (IBException iBException) {
            throw new SQLException(iBException.toString(), ErrorKey.getIBSQLState(), iBException.getErrorCode());
        }
    }

    private boolean isCompatibleIBVersion(String string) {
        return this.databaseMetaData_.ibMajorVersion_ >= 7;
    }

    protected void finalize() throws Throwable {
        if (this.open_) {
            this.close();
        }
        super.finalize();
    }

    public synchronized java.sql.Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(this.getAttachmentSQLDialect(), string, 1003, 1007);
    }

    protected java.sql.PreparedStatement prepareStatement(int n, String string) throws SQLException {
        return this.prepareStatement(this.getAttachmentSQLDialect(), string, 1003, 1007);
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            return this.prepareCall(string, n, n2);
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        EscapeProcessor escapeProcessor = new EscapeProcessor();
        return escapeProcessor.doEscapeProcessing(string, this.getAttachmentSQLDialect());
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkForClosedConnection();
        this.mainTraProps.setEnableAutoCommit(bl);
        if (!this.transactionStartedOnServer_) {
            return;
        }
        this.remote_COMMIT(false);
        this.local_CloseResultSets(this.openStatements_);
        this.local_CloseResultSets(this.openPreparedStatements_);
        this.transactionStartedOnServer_ = false;
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        return this.mainTraProps.isEnableAutoCommit();
    }

    private void local_CloseStatements(Vector vector) throws SQLException {
        while (vector.size() != 0) {
            ((Statement)vector.lastElement()).local_Close();
        }
    }

    private void local_CloseResultSets(Vector vector) throws SQLException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ResultSet resultSet = ((Statement)enumeration.nextElement()).resultSet_;
            if (resultSet == null) continue;
            resultSet.local_Close();
        }
    }

    private void closeResultSets(Vector vector) throws SQLException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Statement statement = (Statement)enumeration.nextElement();
            if (statement.resultSet_ == null) continue;
            statement.resultSet_.close();
            statement.resultSet_ = null;
            statement.resultSetStack_ = null;
        }
    }

    void local_Close() throws SQLException {
        this.local_CloseStatements(this.openStatements_);
        this.local_CloseStatements(this.openPreparedStatements_);
        this.open_ = false;
        Object var1_1 = null;
        Object var2_2 = null;
    }

    public synchronized void commit() throws SQLException {
        this.checkForClosedConnection();
        if (this.getAutoCommit()) {
            return;
        }
        if (!this.transactionStartedOnServer_) {
            return;
        }
        if (this.traDdl_ != null) {
            this.remoteCommitDdl(false);
        }
        this.remote_COMMIT(this.retaining_);
        this.clearSavepoints();
    }

    private void clearSavepoints() throws IBException, SQLException {
        if (this.openSavepoints != null) {
            this.openSavepoints.removeAllElements();
            this.openSavepoints = null;
        }
    }

    void remoteCommitDdl(boolean bl) throws SQLException {
        if (this.traDdl_ != null) {
            if (bl) {
                this.ibase_.iscCommitRetaining(this.traDdl_, this.sqlWarnings_);
            } else {
                this.ibase_.iscCommitTransaction(this.traDdl_, this.sqlWarnings_);
                this.traDdl_ = null;
            }
        }
    }

    void remoteRollbackDdl(boolean bl) throws SQLException {
        if (this.traDdl_ != null) {
            if (bl) {
                this.ibase_.iscRollbackRetaining(this.traDdl_, this.sqlWarnings_);
            } else {
                this.ibase_.iscRollbackTransaction(this.traDdl_, this.sqlWarnings_);
                this.traDdl_ = null;
            }
        }
    }

    void remote_COMMIT(boolean bl) throws SQLException {
        if (this.tra_ == null) {
            this.transactionStartedOnServer_ = false;
            this.tra_ = null;
            return;
        }
        try {
            this.closeResultSets(this.openStatements_);
            this.closeResultSets(this.openPreparedStatements_);
            if (!bl) {
                this.ibase_.iscCommitTransaction(this.tra_, this.sqlWarnings_);
                this.transactionStartedOnServer_ = false;
                this.tra_ = null;
            } else {
                this.ibase_.iscCommitRetaining(this.tra_, this.sqlWarnings_);
            }
        }
        catch (IBException iBException) {
            throw new SQLException(iBException.toString());
        }
    }

    public synchronized void rollback() throws SQLException {
        this.checkForClosedConnection();
        if (this.getAutoCommit()) {
            return;
        }
        if (!this.transactionStartedOnServer_) {
            return;
        }
        if (this.traDdl_ != null) {
            this.remoteRollbackDdl(false);
        }
        this.remote_ROLLBACK(this.retaining_);
        this.clearSavepoints();
    }

    public synchronized void rollbackRetaining() throws SQLException {
        this.checkForClosedConnection();
        if (this.getAutoCommit()) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__commit_or_rollback_under_autocommit__);
        }
        if (!this.transactionStartedOnServer_) {
            return;
        }
        this.remote_ROLLBACK(true);
    }

    void remote_ROLLBACK(boolean bl) throws SQLException {
        if (this.tra_ == null) {
            this.transactionStartedOnServer_ = false;
            return;
        }
        try {
            this.closeResultSets(this.openStatements_);
            this.closeResultSets(this.openPreparedStatements_);
            if (!bl) {
                this.ibase_.iscRollbackTransaction(this.tra_, this.sqlWarnings_);
                this.transactionStartedOnServer_ = false;
                this.tra_ = null;
            } else {
                this.ibase_.iscRollbackRetaining(this.tra_, this.sqlWarnings_);
            }
        }
        catch (IBException iBException) {
            throw new SQLException(iBException.toString());
        }
    }

    public synchronized void close() throws SQLException {
        this.println("CLOSE", this);
        if (!this.open_) {
            return;
        }
        SQLException sQLException = null;
        try {
            if (this.transactionStartedOnServer_ && this.tra_ != null) {
                this.ibase_.iscRollbackTransaction(this.tra_, this.sqlWarnings_);
                this.tra_ = null;
                this.transactionStartedOnServer_ = false;
            }
            if (this.traDdl_ != null) {
                this.remoteRollbackDdl(false);
            }
            this.remote_DETACH_DATABASE();
        }
        catch (IBException iBException) {
            SQLException sQLException2 = new SQLException(iBException.getMessage());
            sQLException = Utils.accumulateSQLExceptions(sQLException, sQLException2);
        }
        catch (SQLException sQLException3) {
            sQLException = Utils.accumulateSQLExceptions(sQLException, sQLException3);
        }
        this.local_Close();
        if (sQLException != null) {
            throw sQLException;
        }
    }

    private void remote_DETACH_DATABASE() throws SQLException, IBException {
        this.ibase_.iscDetachDatabase(this.db_, this.sqlWarnings_);
        this.db_ = null;
    }

    public synchronized boolean isClosed() throws SQLException {
        return !this.open_;
    }

    public synchronized java.sql.DatabaseMetaData getMetaData() throws SQLException {
        return this.databaseMetaData_;
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkForClosedConnection();
        if (this.transactionStartedOnServer_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__transaction_in_progress__);
        }
        this.mainTraProps.setReadOnly(bl);
    }

    public synchronized boolean isReadOnly() throws SQLException {
        return this.mainTraProps.isReadOnly();
    }

    public void setCatalog(String string) throws SQLException {
    }

    public synchronized String getCatalog() throws SQLException {
        return null;
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.mainTraProps.setIsolation(n);
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        return this.mainTraProps.getIsolation();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        if (this.sqlWarnings_ != null) {
            return new SQLWarning(this.sqlWarnings_.getMessage());
        }
        return null;
    }

    public synchronized void clearWarnings() throws SQLException {
        this.sqlWarnings_ = null;
    }

    void setTransaction() throws SQLException {
        try {
            if (!this.transactionStartedOnServer_ && this.tra_ == null) {
                this.tra_ = new IscTrHandle();
                this.mainTraProps.setTransactionConfigData();
                this.ibase_.iscStartTransaction(this.tra_, this.db_, this.tpb_, this.sqlWarnings_);
                this.transactionStartedOnServer_ = true;
            }
        }
        catch (IBException iBException) {
            throw new SQLException(iBException.toString());
        }
    }

    void setDdlTransaction() throws SQLException {
        try {
            if (this.traDdl_ == null) {
                this.traDdl_ = new IscTrHandle();
                if (this.ddlTraProps == null) {
                    this.ddlTraProps = new TransactionProperties(false, 2, true, 0, false);
                }
                this.ddlTraProps.setTransactionConfigData();
                this.ibase_.iscStartTransaction(this.traDdl_, this.db_, this.tpb_, this.sqlWarnings_);
            }
        }
        catch (IBException iBException) {
            throw new SQLException(iBException.toString());
        }
    }

    public synchronized java.sql.Statement createStatement(int n, int n2) throws SQLException {
        this.checkForClosedConnection();
        if (n == 1005 || n2 != 1007) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__invalid_conccurency_scrolling__);
        }
        this.println("createStatement", this);
        this.resultType_ = n;
        this.resultSetConcurrency_ = n2;
        Statement statement = new Statement(this);
        this.openStatements_.addElement(statement);
        statement.resultSetType_ = n;
        return statement;
    }

    public synchronized java.sql.Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            return this.createStatement(n, n2);
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(this.getAttachmentSQLDialect(), string, n, n2);
    }

    protected java.sql.PreparedStatement prepareStatement(int n, String string, int n2, int n3) throws SQLException {
        if (n2 != 1005 && n3 == 1007) {
            this.resultType_ = n2;
            this.resultSetConcurrency_ = n3;
            this.println("prepareStatement sql:" + string, this);
            this.checkForClosedConnection();
            PreparedStatement preparedStatement = new PreparedStatement(this, string, n);
            this.openPreparedStatements_.addElement(preparedStatement);
            return preparedStatement;
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__invalid_conccurency_scrolling__);
    }

    public synchronized java.sql.PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            return this.prepareStatement(string, n, n2);
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (n != 1005 && n2 == 1007) {
            this.resultType_ = n;
            this.resultSetConcurrency_ = n2;
            this.println("prepareCall sql:" + string, this);
            this.checkForClosedConnection();
            CallableStatement callableStatement = new CallableStatement(this, string);
            this.openPreparedStatements_.addElement(callableStatement);
            return callableStatement;
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__invalid_conccurency_scrolling__);
    }

    public synchronized Map getTypeMap() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setLockResolution(int n) throws SQLException {
        this.mainTraProps.setLockResolution(n);
    }

    public synchronized int getLockResolution() throws SQLException {
        return this.mainTraProps.getLockResolution();
    }

    public synchronized void setVersionAcknowledgement(int n) throws SQLException {
        this.checkForClosedConnection();
        if (this.transactionStartedOnServer_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__transaction_in_progress__);
        }
        if (n == 1) {
            this.mainTraProps.setEnableRecVersion(true);
        } else if (n == 0) {
            this.mainTraProps.setEnableRecVersion(false);
        } else {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__version_acknowledgement_mode__);
        }
    }

    public synchronized int getVersionAcknowledgement() throws SQLException {
        if (this.mainTraProps.isEnableRecVersion()) {
            return 1;
        }
        return 0;
    }

    public synchronized void setTableLock(String string, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized int getTableLock(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized void commitRetain() throws SQLException {
        this.checkForClosedConnection();
        if (this.mainTraProps.isEnableAutoCommit()) {
            return;
        }
        if (!this.transactionStartedOnServer_) {
            return;
        }
        this.remote_COMMIT(true);
        this.closeResultSets(this.openStatements_);
        this.closeResultSets(this.openPreparedStatements_);
    }

    public synchronized int getTransactionId() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized boolean inTransaction() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized int getAttachmentSQLDialect() throws SQLException {
        return this.databaseMetaData_.attachmentSQLDialect_;
    }

    public synchronized void setCommitMode(boolean bl) {
        this.retaining_ = bl;
    }

    final void println(String string, Connection connection) {
        DriverManager.println("  \"  :" + string + " [" + connection + "]");
    }

    public synchronized void setHoldability(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getHoldability() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        this.setTransaction();
        if (this.getAutoCommit()) {
            throw new IBException(225544004);
        }
        Savepoint savepoint = IBSavepoint.setSavepoint(++this.savepointId, this);
        if (this.openSavepoints == null) {
            this.openSavepoints = new Vector();
        }
        this.openSavepoints.addElement(savepoint);
        return savepoint;
    }

    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        this.setTransaction();
        if (this.getAutoCommit()) {
            throw new IBException(225544004);
        }
        Savepoint savepoint = IBSavepoint.setSavepoint(string, this);
        if (this.openSavepoints == null) {
            this.openSavepoints = new Vector();
        }
        this.openSavepoints.addElement(savepoint);
        return savepoint;
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        ((IBSavepoint)savepoint).rollbackSavepoint();
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            ((IBSavepoint)savepoint).closeSavepoint();
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            this.openSavepoints.remove(savepoint);
        }
    }

    private class TransactionProperties {
        private boolean readOnly_;
        private int isolation_;
        private boolean enableRecVersion_;
        private int lockResolution_;
        private boolean enableAutoCommit_;

        TransactionProperties() {
            this.readOnly_ = false;
            this.isolation_ = 8;
            this.enableRecVersion_ = true;
            this.lockResolution_ = 0;
            this.enableAutoCommit_ = true;
        }

        TransactionProperties(boolean bl, int n, boolean bl2, int n2, boolean bl3) {
            this.readOnly_ = bl;
            this.isolation_ = n;
            this.enableRecVersion_ = bl2;
            this.lockResolution_ = n2;
            this.enableAutoCommit_ = bl3;
        }

        private boolean isEnableAutoCommit() {
            return this.enableAutoCommit_;
        }

        private int getLockResolution() {
            return this.lockResolution_;
        }

        private boolean isEnableRecVersion() {
            return this.enableRecVersion_;
        }

        private int getIsolation() {
            return this.isolation_;
        }

        private boolean isReadOnly() {
            return this.readOnly_;
        }

        private void setEnableAutoCommit(boolean bl) {
            this.enableAutoCommit_ = bl;
        }

        private void setLockResolution(int n) throws SQLException {
            Connection.this.checkForClosedConnection();
            if (Connection.this.transactionStartedOnServer_) {
                throw new InvalidOperationException(ErrorKey.invalidOperation__transaction_in_progress__);
            }
            switch (n) {
                case 0: 
                case 1: {
                    this.lockResolution_ = n;
                    break;
                }
                default: {
                    throw new InvalidArgumentException(ErrorKey.invalidArgument__lock_resolution__);
                }
            }
        }

        private void setEnableRecVersion(boolean bl) {
            this.enableRecVersion_ = bl;
        }

        private void setIsolation(int n) throws SQLException {
            Connection.this.checkForClosedConnection();
            if (this.enableAutoCommit_) {
                Connection.this.remote_COMMIT(false);
            }
            if (Connection.this.transactionStartedOnServer_) {
                throw new InvalidOperationException(ErrorKey.invalidOperation__transaction_in_progress__);
            }
            switch (n) {
                case 2: 
                case 4: 
                case 8: 
                case 16: {
                    this.isolation_ = n;
                    break;
                }
                case 1: {
                    throw new DriverNotCapableException(ErrorKey.driverNotCapable__isolation__);
                }
                default: {
                    throw new InvalidArgumentException(ErrorKey.invalidArgument__isolation_0__, (Object)String.valueOf(n));
                }
            }
        }

        private void setReadOnly(boolean bl) {
            this.readOnly_ = bl;
        }

        private void setTransactionConfigData() {
            Connection.this.tpb_.clear();
            if (this.readOnly_) {
                Connection.this.tpb_.add(new Integer(8));
            } else {
                Connection.this.tpb_.add(new Integer(9));
            }
            if (this.enableAutoCommit_) {
                Connection.this.tpb_.add(new Integer(16));
                Connection.this.tpb_.add(new Integer(15));
                Connection.this.tpb_.add(new Integer(17));
            } else {
                switch (this.isolation_) {
                    case 2: {
                        Connection.this.tpb_.add(new Integer(15));
                        break;
                    }
                    case 4: 
                    case 8: {
                        Connection.this.tpb_.add(new Integer(2));
                        break;
                    }
                    case 16: {
                        Connection.this.tpb_.add(new Integer(1));
                        break;
                    }
                }
                if (this.enableRecVersion_) {
                    Connection.this.tpb_.add(new Integer(17));
                } else {
                    Connection.this.tpb_.add(new Integer(18));
                }
            }
            if (this.lockResolution_ == 0) {
                Connection.this.tpb_.add(new Integer(6));
            } else {
                Connection.this.tpb_.add(new Integer(7));
            }
        }
    }
}

