/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Connection;
import interbase.interclient.DatabaseStatistics;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.Globals;
import interbase.interclient.IBTypes;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.PreparedStatement;
import interbase.interclient.ResultSet;
import interbase.interclient.SQLException;
import interbase.interclient.Statement;
import interbase.interclient.XSQLDA;
import interbase.interclient.XSQLVAR;
import java.util.ArrayList;
import java.util.Date;

public final class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private Connection connection_;
    private PreparedStatement pstmt_;
    private ResultSet rs_;
    String userName_ = null;
    String databaseProductVersion_ = null;
    int ibMajorVersion_;
    int ibMinorVersion_ = -1;
    int odsMajorVersion_;
    int odsMinorVersion_;
    int pageSize_;
    int pageAllocation_;
    int databaseSQLDialect_;
    boolean databaseReadOnly_;
    int attachmentSQLDialect_;
    private static final String TABLE = "TABLE";
    private static final String SYSTEM_TABLE = "SYSTEM TABLE";
    private static final String VIEW = "VIEW";
    private static final String SPACES = "                               ";
    private static final String UNION = "UNION ";
    public static final String[] ALL_TYPES = new String[]{"SYSTEM TABLE", "TABLE", "VIEW"};
    private static final String GET_ALL_TABLES_SYSTEM = "select  cast(RDB$RELATION_NAME as VARCHAR(31)) as TABLE_NAME, cast('SYSTEM TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null ";
    private static final String GET_ALL_TABLES_TABLE = " select  cast(RDB$RELATION_NAME as VARCHAR(31)) as TABLE_NAME, cast('TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null ";
    private static final String GET_ALL_TABLES_VIEW = " select  cast(RDB$RELATION_NAME as VARCHAR(31)) as TABLE_NAME, cast('VIEW' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where RDB$VIEW_SOURCE is not null";
    private static final String GET_EXACT_TABLES_SYSTEM = "select  cast(RDB$RELATION_NAME as VARCHAR(31)) as TABLE_NAME, cast('SYSTEM TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where  RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null and ? = RDB$RELATION_NAME ";
    private static final String GET_EXACT_TABLES_TABLE = " select  cast(RDB$RELATION_NAME as varchar(31)) as TABLE_NAME, cast('TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null and ? = RDB$RELATION_NAME ";
    private static final String GET_EXACT_TABLES_VIEW = " select  cast(RDB$RELATION_NAME as varchar(31)) as TABLE_NAME, cast('VIEW' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where RDB$VIEW_SOURCE is not null and ? = RDB$RELATION_NAME";
    private static final String GET_WILD_TABLES_SYSTEM = "select  cast(RDB$RELATION_NAME as VARCHAR(31)) as TABLE_NAME, cast('SYSTEM TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where RDB$SYSTEM_FLAG = 1 and RDB$VIEW_SOURCE is null and RDB$RELATION_NAME || '                               ' like ? escape '\\' ";
    private static final String GET_WILD_TABLES_TABLE = " select  cast(RDB$RELATION_NAME as VARCHAR(31)) as TABLE_NAME, cast('TABLE' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where RDB$SYSTEM_FLAG = 0 and RDB$VIEW_SOURCE is null and RDB$RELATION_NAME || '                               ' like ? escape '\\'";
    private static final String GET_WILD_TABLES_VIEW = " select  cast(RDB$RELATION_NAME as VARCHAR(31)) as TABLE_NAME, cast('VIEW' as varchar(31)) as TABLE_TYPE, RDB$DESCRIPTION as REMARKS, RDB$OWNER_NAME as OWNER_NAME from RDB$RELATIONS where RDB$VIEW_SOURCE is not null and RDB$RELATION_NAME || '                               ' like ? escape '\\' ";
    private static final String ALL_PROCS_CALLABLE = "select P.RDB$PROCEDURE_NAME from RDB$PROCEDURES P where not exists ( select UP.RDB$RELATION_NAME from RDB$USER_PRIVILEGES UP where (UP.RDB$USER = ? or UP.RDB$USER = 'PUBLIC') and UP.RDB$RELATION_NAME = P.RDB$PROCEDURE_NAME and UP.RDB$OBJECT_TYPE = 5 and UP.RDB$PRIVILEGE = 'X' )";
    private static final String ALL_TABLES_SELECTABLE = "select REL.RDB$RELATION_NAME from RDB$RELATIONS REL where (REL.RDB$SYSTEM_FLAG = 0) and  not exists (  select UP.RDB$RELATION_NAME from  RDB$USER_PRIVILEGES UP  where UP.RDB$OBJECT_TYPE = 0 and UP.RDB$USER_TYPE = 8 and UP.RDB$RELATION_NAME = REL.RDB$RELATION_NAME and  (RDB$USER = ? or RDB$USER = 'PUBLIC') and (RDB$PRIVILEGE IN ('S',  'A')))";
    private static final String GET_PROCEDURES_START = "select  RDB$PROCEDURE_NAME as PROCEDURE_NAME, RDB$DESCRIPTION as REMARKS, RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE,RDB$OWNER_NAME from RDB$PROCEDURES where ";
    private static final String GET_PROCEDURES_END = "1 = 1 order by 1";
    private final String numericFunctions = "SIN, COS, TAN ";
    private static final String stringFunctions = "LENGTH, SUBSTRING, CONCAT, LCASE, LTRIM, CHAR, ASCII, USER, UCASE, LTRIM RTRIM ";
    public static final int procedureResultUnknown = 0;
    public static final int procedureNoResult = 1;
    public static final int procedureReturnsResult = 2;
    private static final String GET_PROCEDURE_COLUMNS_START = "select PROC.RDB$PROCEDURE_NAME as PROCEDURE_NAME, PROCPARA.RDB$PARAMETER_NAME as COLUMN_NAME, PROCPARA.RDB$PARAMETER_TYPE as COLUMN_TYPE, FIELD.RDB$FIELD_TYPE AS FIELD_TYPE,  FIELD.RDB$FIELD_SUB_TYPE AS FIELD_SUB_TYPE,  FIELD.RDB$FIELD_PRECISION as FIELD_PRECISION, FIELD.RDB$FIELD_SCALE as FIELD_SCALE, FIELD.RDB$FIELD_LENGTH as FIELD_LENGTH, FIELD.RDB$NULL_FLAG as NULLABLE, PROCPARA.RDB$DESCRIPTION as REMARKS from RDB$PROCEDURES PROC, RDB$PROCEDURE_PARAMETERS PROCPARA, RDB$FIELDS FIELD where ";
    private static final String GET_PROCEDURE_COLUMNS_END = " PROC.RDB$PROCEDURE_NAME = PROCPARA.RDB$PROCEDURE_NAME and PROCPARA.RDB$FIELD_SOURCE = FIELD.RDB$FIELD_NAME order by PROC.RDB$PROCEDURE_NAME, PROCPARA.RDB$PARAMETER_TYPE desc, PROCPARA.RDB$PARAMETER_NUMBER ";
    public static final int procedureColumnUnknown = 0;
    public static final int procedureColumnIn = 1;
    public static final int procedureColumnInOut = 2;
    public static final int procedureColumnOut = 4;
    public static final int procedureColumnReturn = 5;
    public static final int procedureColumnResult = 3;
    public static final int procedureNoNulls = 0;
    public static final int procedureNullable = 1;
    public static final int procedureNullableUnknown = 2;
    private static final String GET_COLUMNS_START = "select  RF.RDB$RELATION_NAME as RELATION_NAME, RF.RDB$FIELD_NAME as FIELD_NAME, F.RDB$FIELD_TYPE as FIELD_TYPE, F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE, F.RDB$FIELD_PRECISION as FIELD_PRECISION, F.RDB$FIELD_SCALE as FIELD_SCALE, F.RDB$FIELD_LENGTH as FIELD_LENGTH, RF.RDB$DESCRIPTION, RF.RDB$DEFAULT_SOURCE, RF.RDB$FIELD_POSITION as FIELD_POSITION,  RF.RDB$NULL_FLAG as NULL_FLAG from RDB$RELATION_FIELDS RF, RDB$FIELDS F where ";
    public static final String GET_COLUMNS_END = " RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME order by 1, 10";
    public static final int columnNoNulls = 0;
    public static final int columnNullable = 1;
    public static final int columnNullableUnknown = 2;
    private static final String GET_COLUMN_PRIVILEGES_START = "select RF.RDB$RELATION_NAME as TABLE_NAME, RF.RDB$FIELD_NAME as COLUMN_NAME, UP.RDB$GRANTOR as GRANTOR, UP.RDB$USER as GRANTEE, UP.RDB$PRIVILEGE as PRIVILEGE, UP.RDB$GRANT_OPTION as IS_GRANTABLE from RDB$RELATION_FIELDS RF, RDB$FIELDS F, RDB$USER_PRIVILEGES UP where RF.RDB$RELATION_NAME = UP.RDB$RELATION_NAME and RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME  and (UP.RDB$FIELD_NAME is null or UP.RDB$FIELD_NAME = RF.RDB$FIELD_NAME) and UP.RDB$RELATION_NAME = ? and ((";
    private static final String GET_COLUMN_PRIVILEGES_END = " UP.RDB$OBJECT_TYPE = 0) or (RF.RDB$FIELD_NAME is null and UP.RDB$OBJECT_TYPE = 0)) order by 3 ";
    private static final String GET_TABLE_PRIVILEGES_START = "select null as TABLE_CAT,  null as TABLE_SCHEM, RDB$RELATION_NAME as TABLE_NAME, RDB$GRANTOR as GRANTOR,  RDB$USER as GRANTEE,  RDB$PRIVILEGE as PRIVILEGE,  RDB$GRANT_OPTION as IS_GRANTABLE from RDB$USER_PRIVILEGES where ";
    private static final String GET_TABLE_PRIVILEGES_END = " RDB$OBJECT_TYPE = 0 and RDB$FIELD_NAME is null order by 1, 4";
    private static final String GET_BEST_ROW_IDENT = "select RF.RDB$FIELD_NAME, F.RDB$FIELD_TYPE, F.RDB$FIELD_SUB_TYPE, F.RDB$FIELD_SCALE, F.RDB$FIELD_LENGTH  from RDB$RELATION_CONSTRAINTS RC, RDB$INDEX_SEGMENTS ISGMT, RDB$RELATION_FIELDS RF,RDB$FIELDS F where RC.RDB$RELATION_NAME = ? and RC.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY' and ISGMT.RDB$INDEX_NAME = RC.RDB$INDEX_NAME and RF.RDB$FIELD_NAME = ISGMT.RDB$FIELD_NAME and RF.RDB$RELATION_NAME = RC.RDB$RELATION_NAME and F.RDB$FIELD_NAME = RF.RDB$FIELD_SOURCE union all select RF.RDB$FIELD_NAME,F.RDB$FIELD_TYPE,F.RDB$FIELD_SUB_TYPE, F.RDB$FIELD_SCALE,F.RDB$FIELD_LENGTH from RDB$INDICES IND,RDB$INDEX_SEGMENTS ISGMT, RDB$RELATION_FIELDS RF,RDB$FIELDS F where not exists  (select * from RDB$RELATION_CONSTRAINTS where RDB$RELATION_NAME = ? and RDB$CONSTRAINT_TYPE = 'PRIMARY KEY') and IND.RDB$INDEX_NAME in (select max(RDB$INDEX_NAME) from RDB$INDICES where RDB$RELATION_NAME = ? and RDB$UNIQUE_FLAG   = 1) and ISGMT.RDB$INDEX_NAME = IND.RDB$INDEX_NAME and RF.RDB$FIELD_NAME = ISGMT.RDB$FIELD_NAME and RF.RDB$RELATION_NAME =  IND.RDB$RELATION_NAME and  F.RDB$FIELD_NAME = RF.RDB$FIELD_SOURCE order by 1";
    public static final int bestRowTemporary = 0;
    public static final int bestRowTransaction = 1;
    public static final int bestRowSession = 2;
    public static final int bestRowUnknown = 0;
    public static final int bestRowNotPseudo = 1;
    public static final int bestRowPseudo = 2;
    private static final String GET_VERSION_COLUMN = "select RF.RDB$FIELD_NAME, F.RDB$FIELD_TYPE, F.RDB$FIELD_SUB_TYPE, F.RDB$FIELD_SCALE, F.RDB$FIELD_LENGTH, F.RDB$CHARACTER_LENGTH  from  RDB$FIELDS F, RDB$RELATION_FIELDS RF  where 0 = 1 and  RF.RDB$RELATION_NAME = ? and RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME and F.RDB$COMPUTED_BLR IS NOT NULL";
    public static final int versionColumnUnknown = 0;
    public static final int versionColumnNotPseudo = 1;
    public static final int versionColumnPseudo = 2;
    private static final String GET_PRIMARY_KEYS_START = "select null as TABLE_CAT, null as TABLE_SCHEM, RC.RDB$RELATION_NAME as TABLE_NAME, ISGMT.RDB$FIELD_NAME as COLUMN_NAME, CAST ((ISGMT.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ, RC.RDB$CONSTRAINT_NAME as PK_NAME from RDB$RELATION_CONSTRAINTS RC, RDB$INDEX_SEGMENTS ISGMT where ";
    private static final String GET_PRIMARY_KEYS_END = "RC.RDB$INDEX_NAME = ISGMT.RDB$INDEX_NAME and RC.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY' order by ISGMT.RDB$FIELD_NAME ";
    private static final String GET_IMPORTED_KEYS_START = "select PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,PRC.RDB$UPDATE_RULE as UPDATE_RULE  ,PRC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS FRC  ,RDB$REF_CONSTRAINTS PRC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
    private static final String GET_IMPORTED_KEYS_END = " FK.RDB$CONSTRAINT_TYPE = 'FOREIGN KEY' and FK.RDB$CONSTRAINT_NAME = FRC.RDB$CONSTRAINT_NAME and FRC.RDB$CONST_NAME_UQ = PK.RDB$CONSTRAINT_NAME and PK.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY' and PK.RDB$INDEX_NAME = ISP.RDB$INDEX_NAME and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME   and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  and PRC.RDB$CONSTRAINT_NAME = FK.RDB$CONSTRAINT_NAME  order by 1,5";
    public static final int importedKeyCascade = 0;
    public static final int importedKeyRestrict = 1;
    public static final int importedKeySetNull = 2;
    public static final int importedKeyNoAction = 3;
    public static final int importedNoAction = 3;
    public static final int importedKeySetDefault = 4;
    public static final int importedKeyInitiallyDeferred = 5;
    public static final int importedKeyInitiallyImmediate = 6;
    public static final int importedKeyNotDeferrable = 7;
    private static final String GET_EXPORTED_KEYS_START = "select PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME  ,FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,FRC.RDB$UPDATE_RULE as UPDATE_RULE  ,FRC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS FRC  ,RDB$REF_CONSTRAINTS PRC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
    private static final String GET_EXPORTED_KEYS_END = " PK.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY' and FRC.RDB$CONST_NAME_UQ = PK.RDB$CONSTRAINT_NAME and  FK.RDB$CONSTRAINT_NAME = FRC.RDB$CONSTRAINT_NAME and FK.RDB$CONSTRAINT_TYPE = 'FOREIGN KEY' and PK.RDB$INDEX_NAME = ISP.RDB$INDEX_NAME and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME   and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION  and PRC.RDB$CONSTRAINT_NAME = FK.RDB$CONSTRAINT_NAME order by 3,5";
    private static final String GET_CROSS_KEYS_START = "select PK.RDB$RELATION_NAME as PKTABLE_NAME  ,ISP.RDB$FIELD_NAME as PKCOLUMN_NAME , FK.RDB$RELATION_NAME as FKTABLE_NAME  ,ISF.RDB$FIELD_NAME as FKCOLUMN_NAME  ,CAST ((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ  ,RC.RDB$UPDATE_RULE as UPDATE_RULE  ,RC.RDB$DELETE_RULE as DELETE_RULE  ,PK.RDB$CONSTRAINT_NAME as PK_NAME  ,FK.RDB$CONSTRAINT_NAME as FK_NAME  from  RDB$RELATION_CONSTRAINTS PK  ,RDB$RELATION_CONSTRAINTS FK  ,RDB$REF_CONSTRAINTS RC  ,RDB$INDEX_SEGMENTS ISP  ,RDB$INDEX_SEGMENTS ISF  WHERE ";
    private static final String GET_CROSS_KEYS_END = " FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME  and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ  and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME  and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME  and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION order by 3,5";
    private static final Short shortZero = new Short(0);
    private static final Short CASESENSITIVE = new Short(1);
    private static final Short CASEINSENSITIVE = new Short(0);
    private static final Short UNSIGNED = new Short(1);
    private static final Short SIGNED = new Short(0);
    private static final Short FIXEDSCALE = new Short(1);
    private static final Short VARIABLESCALE = new Short(0);
    private static final Short NOTAUTOINC = new Short(0);
    private static final Short PREDNONE = new Short(0);
    private static final Short PREDBASIC = new Short(2);
    private static final Short SEARCHABLE = new Short(3);
    private static final Short NULLABLE = new Short(1);
    private static final Integer BINARY = new Integer(2);
    private static final Integer DECIMAL = new Integer(10);
    public static final int typeNoNulls = 0;
    public static final int typeNullable = 1;
    public static final int typeNullableUnknown = 2;
    public static final int typePredNone = 0;
    public static final int typePredChar = 1;
    public static final int typePredBasic = 2;
    public static final int typeSearchable = 3;
    private static final String GET_INDEX_INFO_START = "select ind.RDB$RELATION_NAME AS TABLE_NAME  ,ind.RDB$UNIQUE_FLAG AS NON_UNIQUE  ,ind.RDB$INDEX_NAME as INDEX_NAME  ,ise.rdb$field_position as ORDINAL_POSITION  ,ise.rdb$field_name as COLUMN_NAME  ,ind.rdb$index_type as ASC_OR_DESC  ,COUNT (DISTINCT P.RDB$PAGE_NUMBER) as IN_PAGES  from rdb$indices ind, rdb$index_segments ise,RDB$PAGES P, RDB$RELATIONS R  where ind.rdb$index_name = ise.rdb$index_name  and ind.rdb$relation_name = ?   AND P.RDB$RELATION_ID = R.RDB$RELATION_ID  AND R.RDB$RELATION_NAME = IND.RDB$RELATION_NAME  AND (P.RDB$PAGE_TYPE = 7 OR P.RDB$PAGE_TYPE = 6) ";
    private static final String GET_INDEX_INFO_END = " group by IND.RDB$INDEX_NAME, IND.RDB$RELATION_NAME,  IND.RDB$UNIQUE_FLAG, ISE.RDB$FIELD_POSITION, ISE.RDB$FIELD_NAME,  IND.RDB$INDEX_TYPE, IND.RDB$SEGMENT_COUNT  order by 2, 3, 4";
    public static final short tableIndexStatistic = 0;
    public static final short tableIndexClustered = 1;
    public static final short tableIndexHashed = 2;
    public static final short tableIndexOther = 3;
    short attributeNoNulls = 0;
    short attributeNullable = 1;
    short attributeNullableUnknown = (short)2;
    int sqlStateXOpen = 1;
    int sqlStateSQL99 = 2;

    DatabaseMetaData(Connection connection) {
        this.connection_ = connection;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.rs_ != null) {
            try {
                this.rs_.local_Close();
            }
            catch (java.sql.SQLException sQLException) {
            }
            finally {
                this.rs_ = null;
            }
        }
    }

    void checkForClosedConnection() throws java.sql.SQLException {
        if (!this.connection_.open_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__connection_closed__);
        }
    }

    public synchronized boolean allProceduresAreCallable() throws java.sql.SQLException {
        this.checkForClosedConnection();
        if (this.userName_.equals("SYSDBA")) {
            return true;
        }
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, ALL_PROCS_CALLABLE);
        this.pstmt_.setString(1, this.userName_);
        this.rs_ = (ResultSet)this.pstmt_.executeQuery();
        boolean bl = !this.rs_.next();
        this.rs_.close();
        return bl;
    }

    public synchronized boolean allTablesAreSelectable() throws java.sql.SQLException {
        this.checkForClosedConnection();
        if (this.userName_.equals("SYSDBA")) {
            return true;
        }
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, ALL_TABLES_SELECTABLE);
        this.pstmt_.setString(1, this.userName_);
        this.rs_ = (ResultSet)this.pstmt_.executeQuery();
        boolean bl = !this.rs_.next();
        this.rs_.close();
        return bl;
    }

    public String getURL() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "jdbc:interbase://" + this.connection_.serverName_ + "/" + this.connection_.database_;
    }

    public String getUserName() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.userName_;
    }

    public boolean isReadOnly() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.databaseReadOnly_;
    }

    public boolean nullsAreSortedHigh() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean nullsAreSortedLow() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean nullsAreSortedAtStart() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean nullsAreSortedAtEnd() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public String getDatabaseProductName() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return Globals.getResource("96");
    }

    public String getDatabaseProductVersion() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.databaseProductVersion_;
    }

    public int getDatabaseSQLDialect() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.databaseSQLDialect_;
    }

    public String getDriverName() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return Globals.getResource("94");
    }

    public String getDriverVersion() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "8.1.1 for JRE 1.3, JRE 1.4 and J2SE 5 with InterBase 2007 SP2 (8.1), 2007 (8.0) and 7.5";
    }

    public java.sql.ResultSet getDomains() {
        return null;
    }

    public int getDriverMajorVersion() {
        return 8;
    }

    public int getDriverMinorVersion() {
        return 1;
    }

    public boolean usesLocalFiles() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean usesLocalFilePerTable() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMixedCaseIdentifiers() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean storesUpperCaseIdentifiers() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean storesLowerCaseIdentifiers() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean storesMixedCaseIdentifiers() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.odsMajorVersion_ >= 10 && (this.databaseSQLDialect_ >= 3 || this.attachmentSQLDialect_ >= 2);
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.odsMajorVersion_ >= 10 && (this.databaseSQLDialect_ >= 3 || this.attachmentSQLDialect_ >= 2);
    }

    public String getIdentifierQuoteString() throws java.sql.SQLException {
        this.checkForClosedConnection();
        if (this.odsMajorVersion_ < 10 || this.databaseSQLDialect_ < 3 && this.attachmentSQLDialect_ < 2) {
            return " ";
        }
        return "\"";
    }

    public String getSQLKeywords() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "ACTIVE,AFTER,ASCENDING,BASE_NAME,BEFORE,BLOB,BOOLEAN,CACHE,CHECK_POINT_LENGTH,COMPUTED,CONDITIONAL,CONTAINING,CSTRING,DATABASE,RDB$DB_KEY,DEBUG,DESCENDING,DO,ENTRY_POINT,EXIT,FILE,FILTER,FUNCTION,GDSCODE,GENERATOR,GEN_ID,GROUP_COMMIT_WAIT_TIME,IF,INACTIVE,INPUT_TYPE,INDEX,LOGFILE,LOG_BUFFER_SIZE,MANUAL,MAXIMUM_SEGMENT,MERGE,MESSAGE,MODULE_NAME,NCHAR,NUM_LOG_BUFFERS,OUTPUT_TYPE,OVERFLOW,PAGE,PAGES,PAGE_SIZE,PARAMETER,PASSWORD,PLAN,POST_EVENT,PROTECTED,RAW_PARTITIONS,RESERV,RESERVING,RETAIN,RETURNING_VALUES,RETURNS,SEGMENT,SHADOW,SHARED,SINGULAR,SNAPSHOT,SORT,STABILITY,STARTS,STARTING,STATISTICS,SUB_TYPE,SUSPEND,TRIGGER,VARIABLE,RECORD_VERSION,WAIT,WHILE,WORK";
    }

    public String getNumericFunctions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public String getStringFunctions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return stringFunctions;
    }

    public String getSystemFunctions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public String getTimeDateFunctions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public String getSearchStringEscape() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "\\";
    }

    public String getExtraNameCharacters() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "$";
    }

    public boolean supportsAlterTableWithAddColumn() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsAlterTableWithDropColumn() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsColumnAliasing() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsConvert() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsConvert(int n, int n2) throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsTableCorrelationNames() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsDifferentTableCorrelationNames() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsOrderByUnrelated() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsGroupBy() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsGroupByUnrelated() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsGroupByBeyondSelect() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsLikeEscapeClause() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsMultipleResultSets() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMultipleTransactions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsNonNullableColumns() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsCoreSQLGrammar() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsExtendedSQLGrammar() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsANSI92EntryLevelSQL() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsANSI92IntermediateSQL() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsANSI92FullSQL() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsIntegrityEnhancementFacility() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsOuterJoins() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsFullOuterJoins() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsLimitedOuterJoins() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public String getSchemaTerm() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public String getProcedureTerm() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "PROCEDURE";
    }

    public String getCatalogTerm() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public boolean isCatalogAtStart() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public String getCatalogSeparator() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return "";
    }

    public boolean supportsSchemasInDataManipulation() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsSchemasInProcedureCalls() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsSchemasInTableDefinitions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsSchemasInIndexDefinitions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInDataManipulation() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInProcedureCalls() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInTableDefinitions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsPositionedDelete() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsPositionedUpdate() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSelectForUpdate() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsStoredProcedures() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInComparisons() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInExists() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInIns() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsUnion() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsUnionAll() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public int getMaxBinaryLiteralLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 0;
    }

    public int getMaxCharLiteralLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 1024;
    }

    public int getMaxColumnNameLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 68;
    }

    public int getMaxColumnsInGroupBy() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 16;
    }

    public int getMaxColumnsInIndex() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 16;
    }

    public int getMaxColumnsInOrderBy() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 16;
    }

    public int getMaxColumnsInSelect() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return Short.MAX_VALUE;
    }

    public int getMaxColumnsInTable() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return Short.MAX_VALUE;
    }

    public int getMaxConnections() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 0;
    }

    public int getMaxCursorNameLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 68;
    }

    public int getMaxIndexLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 198;
    }

    public int getMaxSchemaNameLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 0;
    }

    public int getMaxProcedureNameLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 27;
    }

    public int getMaxCatalogNameLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 0;
    }

    public int getMaxRowSize() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 32664;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public int getMaxStatementLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 640;
    }

    public int getMaxStatements() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 0;
    }

    public int getMaxTableNameLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 68;
    }

    public int getMaxTablesInSelect() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 16;
    }

    public int getMaxUserNameLength() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 68;
    }

    public int getDefaultTransactionIsolation() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return 8;
    }

    public boolean supportsTransactions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int n) throws java.sql.SQLException {
        this.checkForClosedConnection();
        switch (n) {
            case 2: 
            case 4: 
            case 8: 
            case 16: {
                return true;
            }
            case 0: 
            case 1: {
                return false;
            }
        }
        throw new InvalidArgumentException(ErrorKey.invalidArgument__isolation_0__, (Object)String.valueOf(n));
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return false;
    }

    private void systemTableQueryPreamble(String string, String string2) throws java.sql.SQLException {
    }

    private boolean exactMatch(String string) {
        int n;
        if (string == null) {
            return true;
        }
        int n2 = 0;
        while ((n = string.indexOf(37, n2)) < string.length() && n != -1) {
            if (n == 0 || string.charAt(n - 1) != '\\') {
                return false;
            }
            n2 = ++n;
        }
        return true;
    }

    public String stripEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    public synchronized java.sql.ResultSet getProcedures(String string, String string2, String string3) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        SqlPattern sqlPattern = new SqlPattern("RDB$PROCEDURE_NAME", string3);
        String string4 = GET_PROCEDURES_START + sqlPattern.getClause() + GET_PROCEDURES_END;
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, string4);
        if (!"%".equals(string3) && !"".equals(string3)) {
            this.pstmt_.setString(1, sqlPattern.getPattern());
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[9];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "PROCEDURE_CAT";
        xSQLVARArray[0].relname = "RDB$PROCEDURES";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "PROCEDURE_SCHEM";
        xSQLVARArray[1].relname = "RDB$PROCEDURES";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "PROCEDURE_NAME";
        xSQLVARArray[2].relname = "RDB$PROCEDURES";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 601;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "reserved";
        xSQLVARArray[3].relname = "RDB$PROCEDURES";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 601;
        xSQLVARArray[4].sqllen = 68;
        xSQLVARArray[4].sqlind = 0;
        xSQLVARArray[4].sqlname = "reserved";
        xSQLVARArray[4].relname = "RDB$PROCEDURES";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 601;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = 0;
        xSQLVARArray[5].sqlname = "reserved";
        xSQLVARArray[5].relname = "RDB$PROCEDURES";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 601;
        xSQLVARArray[6].sqllen = 68;
        xSQLVARArray[6].sqlind = 0;
        xSQLVARArray[6].sqlname = "REMARKS";
        xSQLVARArray[6].relname = "RDB$PROCEDURES";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 500;
        xSQLVARArray[7].sqlname = "PROCEDURE_TYPE";
        xSQLVARArray[7].relname = "RDB$PROCEDURES";
        xSQLVARArray[8] = new XSQLVAR();
        xSQLVARArray[8].sqltype = 600;
        xSQLVARArray[8].sqllen = 68;
        xSQLVARArray[8].sqlind = 0;
        xSQLVARArray[8].sqlname = "PROCEDURE_OWNER";
        xSQLVARArray[8].relname = "RDB$PROCEDURES";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[]{null, null, resultSet.getString("PROCEDURE_NAME").trim(), null, null, null, new String(""), new Short(resultSet.getShort("PROCEDURE_TYPE") > 0 ? (short)2 : 1), resultSet.getString("RDB$OWNER_NAME")};
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 9);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        SqlPattern sqlPattern = new SqlPattern("PROC.RDB$PROCEDURE_NAME", string3);
        SqlPattern sqlPattern2 = new SqlPattern("PROCPARA.RDB$PARAMETER_NAME", string4);
        String string5 = GET_PROCEDURE_COLUMNS_START + sqlPattern.getClause() + sqlPattern2.getClause() + GET_PROCEDURE_COLUMNS_END;
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, string5);
        int n = 1;
        if (string3 != null && !"%".equals(string3) && !"".equals(string3)) {
            this.pstmt_.setString(n, sqlPattern.getPattern());
            ++n;
        }
        if (string4 != null && !"%".equals(string4) && !"".equals(string4)) {
            this.pstmt_.setString(n, sqlPattern2.getPattern());
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[13];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "PROCEDURE_CAT";
        xSQLVARArray[0].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "PROCEDURE_SCHEM";
        xSQLVARArray[1].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "PROCEDURE_NAME";
        xSQLVARArray[2].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "COLUMN_NAME";
        xSQLVARArray[3].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 500;
        xSQLVARArray[4].sqlname = "COLUMN_TYPE";
        xSQLVARArray[4].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 500;
        xSQLVARArray[5].sqlname = "DATA_TYPE";
        xSQLVARArray[5].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 600;
        xSQLVARArray[6].sqllen = 68;
        xSQLVARArray[6].sqlind = 0;
        xSQLVARArray[6].sqlname = "TYPE_NAME";
        xSQLVARArray[6].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 496;
        xSQLVARArray[7].sqlname = "PRECISION";
        xSQLVARArray[7].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[8] = new XSQLVAR();
        xSQLVARArray[8].sqltype = 496;
        xSQLVARArray[8].sqlname = "LENGTH";
        xSQLVARArray[8].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[9] = new XSQLVAR();
        xSQLVARArray[9].sqltype = 500;
        xSQLVARArray[9].sqlname = "SCALE";
        xSQLVARArray[9].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[10] = new XSQLVAR();
        xSQLVARArray[10].sqltype = 500;
        xSQLVARArray[10].sqlname = "RADIX";
        xSQLVARArray[10].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[11] = new XSQLVAR();
        xSQLVARArray[11].sqltype = 500;
        xSQLVARArray[11].sqlname = "NULLABLE";
        xSQLVARArray[11].relname = "RDB$PROCCOLUMNINFO";
        xSQLVARArray[12] = new XSQLVAR();
        xSQLVARArray[12].sqltype = 601;
        xSQLVARArray[12].sqllen = 68;
        xSQLVARArray[12].sqlind = 0;
        xSQLVARArray[12].sqlname = "REMARKS";
        xSQLVARArray[12].relname = "RDB$PROCCOLUMNINFO";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[18];
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[2] = resultSet.getString("PROCEDURE_NAME").trim();
            objectArray[3] = resultSet.getString("COLUMN_NAME").trim();
            objectArray[4] = new Short(resultSet.getShort("COLUMN_TYPE") > 0 ? (short)3 : 1);
            short s = resultSet.getShort("FIELD_TYPE");
            short s2 = resultSet.getShort("FIELD_SUB_TYPE");
            short s3 = resultSet.getShort("FIELD_SCALE");
            int n2 = IBTypes.getDataType(s, s2, s3);
            objectArray[5] = new Short((short)n2);
            int n3 = IBTypes.getIBType(s, s2, s3);
            objectArray[6] = IBTypes.getIBTypeName(n3);
            short s4 = resultSet.getShort("FIELD_LENGTH");
            objectArray[7] = new Integer(resultSet.getInt("FIELD_PRECISION"));
            objectArray[8] = new Integer(s4);
            objectArray[9] = new Short((short)Math.abs(s3));
            objectArray[10] = new Short(IBTypes.getRadix(n2));
            objectArray[11] = new Short(resultSet.getShort("NULLABLE") == 1 ? (short)0 : 1);
            String string6 = resultSet.getString("REMARKS");
            objectArray[12] = string6 == null ? new String("") : string6;
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 13);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string4 = string3 == null ? new String("%") : new String(this.systemTableValue(string3));
        if (stringArray == null) {
            bl = true;
            bl2 = true;
            bl3 = true;
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (TABLE.equals(stringArray[i])) {
                    bl2 = true;
                    continue;
                }
                if (SYSTEM_TABLE.equals(stringArray[i])) {
                    bl3 = true;
                    continue;
                }
                if (!VIEW.equals(stringArray[i])) continue;
                bl = true;
            }
        }
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl4 = false;
        boolean bl5 = true;
        int n = 0;
        if ("%".equals(string4) || "".equals(string4)) {
            if (bl3) {
                stringBuffer.append(GET_ALL_TABLES_SYSTEM);
                bl5 = false;
            }
            if (bl2) {
                stringBuffer.append(bl5 ? "" : UNION);
                stringBuffer.append(GET_ALL_TABLES_TABLE);
                bl5 = false;
            }
            if (bl) {
                stringBuffer.append(bl5 ? "" : UNION);
                stringBuffer.append(GET_ALL_TABLES_VIEW);
            }
            bl4 = true;
        } else if (this.exactMatch(string4)) {
            string4 = this.systemTableValue(this.stripEscape(string4));
            if (bl3) {
                stringBuffer.append(GET_EXACT_TABLES_SYSTEM);
                bl5 = false;
                ++n;
            }
            if (bl2) {
                stringBuffer.append(bl5 ? "" : UNION);
                stringBuffer.append(GET_EXACT_TABLES_TABLE);
                bl5 = false;
                ++n;
            }
            if (bl) {
                stringBuffer.append(bl5 ? "" : UNION);
                stringBuffer.append(GET_EXACT_TABLES_VIEW);
                ++n;
            }
        } else {
            string4 = this.systemTableValue(string4) + SPACES + "%";
            if (bl3) {
                stringBuffer.append(GET_WILD_TABLES_SYSTEM);
                bl5 = false;
                ++n;
            }
            if (bl2) {
                stringBuffer.append(bl5 ? "" : UNION);
                stringBuffer.append(GET_WILD_TABLES_TABLE);
                bl5 = false;
                ++n;
            }
            if (bl) {
                stringBuffer.append(bl5 ? "" : UNION);
                stringBuffer.append(GET_WILD_TABLES_VIEW);
                ++n;
            }
        }
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, stringBuffer.toString());
        if (!bl4) {
            for (int i = 0; i < n; ++i) {
                this.pstmt_.setString(i + 1, string4);
            }
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[6];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TABLE_CAT";
        xSQLVARArray[0].relname = "RDB$TABLEINFO";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "TABLE_SCHEM";
        xSQLVARArray[1].relname = "RDB$TABLEINFO";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "TABLE_NAME";
        xSQLVARArray[2].relname = "RDB$TABLEINFO";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "TABLE_TYPE";
        xSQLVARArray[3].relname = "RDB$TABLEINFO";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 601;
        xSQLVARArray[4].sqllen = 68;
        xSQLVARArray[4].sqlind = 0;
        xSQLVARArray[4].sqlname = "REMARKS";
        xSQLVARArray[4].relname = "RDB$TABLEINFO";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 600;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = 0;
        xSQLVARArray[5].sqlname = "TABLE_OWNER";
        xSQLVARArray[5].relname = "RDB$TABLEINFO";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[]{null, null, resultSet.getString("TABLE_NAME").trim(), resultSet.getString("TABLE_TYPE").trim(), new String(""), resultSet.getString("OWNER_NAME").trim()};
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 6);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public java.sql.ResultSet getSchemas() throws java.sql.SQLException {
        this.checkForClosedConnection();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[]{new XSQLVAR()};
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TABLE_SCHEM";
        xSQLVARArray[0].relname = "RDB$TABLESCHEM";
        ArrayList arrayList = new ArrayList(0);
        this.setCannedResult(xSQLVARArray, arrayList, 1);
        return this.rs_;
    }

    public java.sql.ResultSet getCatalogs() throws java.sql.SQLException {
        this.checkForClosedConnection();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[]{new XSQLVAR()};
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TABLE_CAT";
        xSQLVARArray[0].relname = "RDB$TABLECAT";
        ArrayList arrayList = new ArrayList(0);
        this.setCannedResult(xSQLVARArray, arrayList, 1);
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getTableTypes() throws java.sql.SQLException {
        this.checkForClosedConnection();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[]{new XSQLVAR()};
        xSQLVARArray[0].sqltype = 600;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TABLE_TYPE";
        xSQLVARArray[0].relname = "RDB$TABLETYPES";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(ALL_TYPES.length);
        for (int i = 0; i < ALL_TYPES.length; ++i) {
            arrayList.add(new Object[]{ALL_TYPES[i]});
        }
        this.setCannedResult(xSQLVARArray, arrayList, 1);
        return this.rs_;
    }

    private void setCannedResult(XSQLVAR[] xSQLVARArray, ArrayList arrayList, int n) throws java.sql.SQLException {
        Statement statement = new Statement(this.connection_);
        statement.setCannedRows(arrayList);
        XSQLDA xSQLDA = new XSQLDA(n, xSQLVARArray);
        this.rs_ = new ResultSet(statement, false, n, xSQLDA, 1003);
        this.rs_.setResultSetMetaData(xSQLDA, true);
    }

    public synchronized java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        SqlPattern sqlPattern = new SqlPattern("RF.RDB$FIELD_NAME", string4);
        SqlPattern sqlPattern2 = new SqlPattern("RF.RDB$RELATION_NAME", string3);
        String string5 = GET_COLUMNS_START + sqlPattern2.getClause() + sqlPattern.getClause() + GET_COLUMNS_END;
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, string5);
        int n = 1;
        if (string3 != null && !"%".equals(string3) && !"".equals(string3)) {
            this.pstmt_.setString(n, sqlPattern2.getPattern());
            ++n;
        }
        if (string4 != null && !"%".equals(string4) && !"".equals(string4)) {
            this.pstmt_.setString(n, sqlPattern.getPattern());
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[18];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TABLE_CAT";
        xSQLVARArray[0].relname = "COLUMNINFO";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "TABLE_SCHEM";
        xSQLVARArray[1].relname = "COLUMNINFO";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "TABLE_NAME";
        xSQLVARArray[2].relname = "COLUMNINFO";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "COLUMN_NAME";
        xSQLVARArray[3].relname = "COLUMNINFO";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 500;
        xSQLVARArray[4].sqlname = "DATA_TYPE";
        xSQLVARArray[4].relname = "COLUMNINFO";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 600;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = 0;
        xSQLVARArray[5].sqlname = "TYPE_NAME";
        xSQLVARArray[5].relname = "COLUMNINFO";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 496;
        xSQLVARArray[6].sqlname = "COLUMN_SIZE";
        xSQLVARArray[6].relname = "COLUMNINFO";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 497;
        xSQLVARArray[7].sqlname = "BUFFER_LENGTH";
        xSQLVARArray[7].relname = "COLUMNINFO";
        xSQLVARArray[8] = new XSQLVAR();
        xSQLVARArray[8].sqltype = 496;
        xSQLVARArray[8].sqlname = "DECIMAL_DIGITS";
        xSQLVARArray[8].relname = "COLUMNINFO";
        xSQLVARArray[9] = new XSQLVAR();
        xSQLVARArray[9].sqltype = 496;
        xSQLVARArray[9].sqlname = "NUM_PREC_RADIX";
        xSQLVARArray[9].relname = "COLUMNINFO";
        xSQLVARArray[10] = new XSQLVAR();
        xSQLVARArray[10].sqltype = 496;
        xSQLVARArray[10].sqlname = "NULLABLE";
        xSQLVARArray[10].relname = "COLUMNINFO";
        xSQLVARArray[11] = new XSQLVAR();
        xSQLVARArray[11].sqltype = 601;
        xSQLVARArray[11].sqllen = 68;
        xSQLVARArray[11].sqlind = 0;
        xSQLVARArray[11].sqlname = "REMARKS";
        xSQLVARArray[11].relname = "COLUMNINFO";
        xSQLVARArray[12] = new XSQLVAR();
        xSQLVARArray[12].sqltype = 601;
        xSQLVARArray[12].sqllen = 68;
        xSQLVARArray[12].sqlind = 0;
        xSQLVARArray[12].sqlname = "COLUMN_DEF";
        xSQLVARArray[12].relname = "COLUMNINFO";
        xSQLVARArray[13] = new XSQLVAR();
        xSQLVARArray[13].sqltype = 497;
        xSQLVARArray[13].sqlname = "SQL_DATA_TYPE";
        xSQLVARArray[13].relname = "COLUMNINFO";
        xSQLVARArray[14] = new XSQLVAR();
        xSQLVARArray[14].sqltype = 497;
        xSQLVARArray[14].sqlname = "SQL_DATETIME_SUB";
        xSQLVARArray[14].relname = "COLUMNINFO";
        xSQLVARArray[15] = new XSQLVAR();
        xSQLVARArray[15].sqltype = 496;
        xSQLVARArray[15].sqlname = "CHAR_OCTET_LENGTH";
        xSQLVARArray[15].relname = "COLUMNINFO";
        xSQLVARArray[16] = new XSQLVAR();
        xSQLVARArray[16].sqltype = 496;
        xSQLVARArray[16].sqlname = "ORDINAL_POSITION";
        xSQLVARArray[16].relname = "COLUMNINFO";
        xSQLVARArray[17] = new XSQLVAR();
        xSQLVARArray[17].sqltype = 600;
        xSQLVARArray[17].sqllen = 3;
        xSQLVARArray[17].sqlind = 0;
        xSQLVARArray[17].sqlname = "IS_NULLABLE";
        xSQLVARArray[17].relname = "COLUMNINFO";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[18];
            objectArray[0] = null;
            objectArray[1] = null;
            objectArray[2] = resultSet.getString("RELATION_NAME").trim();
            objectArray[3] = resultSet.getString("FIELD_NAME").trim();
            short s = resultSet.getShort("FIELD_TYPE");
            short s2 = resultSet.getShort("FIELD_SUB_TYPE");
            short s3 = resultSet.getShort("FIELD_SCALE");
            int n2 = IBTypes.getDataType(s, s2, s3);
            objectArray[4] = new Short((short)n2);
            int n3 = IBTypes.getIBType(s, s2, s3);
            objectArray[5] = IBTypes.getIBTypeName(n3);
            short s4 = resultSet.getShort("FIELD_LENGTH");
            objectArray[6] = new Integer(IBTypes.getColumnSize(n3, s4));
            objectArray[7] = new Integer(0);
            objectArray[8] = new Integer(Math.abs(s3));
            objectArray[9] = new Integer(IBTypes.getRadix(n2));
            short s5 = resultSet.getShort("NULL_FLAG");
            objectArray[10] = s5 == 1 ? new Integer(0) : new Integer(1);
            objectArray[11] = null;
            objectArray[12] = null;
            objectArray[13] = null;
            objectArray[14] = null;
            objectArray[15] = new Integer(s4);
            objectArray[16] = new Integer(resultSet.getShort("FIELD_POSITION") + 1);
            objectArray[17] = s5 == 1 ? "NO" : "YES";
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 18);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        SqlPattern sqlPattern = new SqlPattern("RF.RDB$FIELD_NAME", string4);
        String string5 = GET_COLUMN_PRIVILEGES_START + sqlPattern.getClause() + GET_COLUMN_PRIVILEGES_END;
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, string5);
        if (string3 == null || "".equals(string3)) {
            string3 = new String("%");
        }
        this.pstmt_.setString(1, string3);
        if (string4 != null && !"%".equals(string4) && !"".equals(string4)) {
            this.pstmt_.setString(2, sqlPattern.getPattern());
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[8];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TABLE_CAT";
        xSQLVARArray[0].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "TABLE_SCHEM";
        xSQLVARArray[1].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "TABLE_NAME";
        xSQLVARArray[2].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "COLUMN_NAME";
        xSQLVARArray[3].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 601;
        xSQLVARArray[4].sqllen = 68;
        xSQLVARArray[4].sqlind = 0;
        xSQLVARArray[4].sqlname = "GRANTOR";
        xSQLVARArray[4].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 600;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = 0;
        xSQLVARArray[5].sqlname = "GRANTEE";
        xSQLVARArray[5].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 600;
        xSQLVARArray[6].sqllen = 68;
        xSQLVARArray[6].sqlind = 0;
        xSQLVARArray[6].sqlname = "PRIVILEGE";
        xSQLVARArray[6].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 601;
        xSQLVARArray[7].sqllen = 68;
        xSQLVARArray[7].sqlind = 0;
        xSQLVARArray[7].sqlname = "IS_GRANTABLE";
        xSQLVARArray[7].relname = "RDB$COLUMNPRIV";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[]{null, null, resultSet.getString("TABLE_NAME").trim(), resultSet.getString("COLUMN_NAME").trim(), resultSet.getString("GRANTOR").trim(), resultSet.getString("GRANTEE").trim(), this.mapPrivilegeLiterals(resultSet.getString("PRIVILEGE").trim()), new String(resultSet.getShort("IS_GRANTABLE") == 1 ? "YES" : "NO")};
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 8);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    private String mapPrivilegeLiterals(String string) throws java.sql.SQLException {
        if ("I".equals(string)) {
            return new String("INSERT");
        }
        if ("S".equals(string)) {
            return new String("SELECT");
        }
        if ("U".equals(string)) {
            return new String("UPDATE");
        }
        if ("D".equals(string)) {
            return new String("DELETE");
        }
        if ("R".equals(string)) {
            return new String("REFERENCES");
        }
        return null;
    }

    public synchronized java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        SqlPattern sqlPattern = new SqlPattern("RDB$RELATION_NAME", string3);
        String string4 = GET_TABLE_PRIVILEGES_START + sqlPattern.getClause() + GET_TABLE_PRIVILEGES_END;
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, string4);
        if (!"%".equals(string3) && !"".equals(string3)) {
            this.pstmt_.setString(1, sqlPattern.getPattern());
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[7];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TABLE_CAT";
        xSQLVARArray[0].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "TABLE_SCHEM";
        xSQLVARArray[1].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "TABLE_NAME";
        xSQLVARArray[2].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 601;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "GRANTOR";
        xSQLVARArray[3].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 600;
        xSQLVARArray[4].sqllen = 68;
        xSQLVARArray[4].sqlind = 0;
        xSQLVARArray[4].sqlname = "GRANTEE";
        xSQLVARArray[4].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 600;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = 0;
        xSQLVARArray[5].sqlname = "PRIVILEGE";
        xSQLVARArray[5].relname = "RDB$COLUMNPRIV";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 600;
        xSQLVARArray[6].sqllen = 68;
        xSQLVARArray[6].sqlind = 0;
        xSQLVARArray[6].sqlname = "IS_GRANTABLE";
        xSQLVARArray[6].relname = "RDB$COLUMNPRIV";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[]{null, null, resultSet.getString("TABLE_NAME").trim(), resultSet.getString("GRANTOR").trim(), resultSet.getString("GRANTEE").trim(), this.mapPrivilegeLiterals(resultSet.getString("PRIVILEGE").trim()), new String(resultSet.getShort("IS_GRANTABLE") == 1 ? "YES" : "NO")};
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 7);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        String string4 = string3.toUpperCase();
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, GET_BEST_ROW_IDENT);
        for (int i = 0; i < 3; ++i) {
            this.pstmt_.setString(i + 1, string4);
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[8];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 500;
        xSQLVARArray[0].sqlname = "SCOPE";
        xSQLVARArray[0].relname = "RDB$BEST_ROW";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 600;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = 0;
        xSQLVARArray[1].sqlname = "COLUMN_NAME";
        xSQLVARArray[1].relname = "RDB$BEST_ROW";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 500;
        xSQLVARArray[2].sqlname = "DATA_TYPE";
        xSQLVARArray[2].relname = "RDB$BEST_ROW";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "TYPE_NAME";
        xSQLVARArray[3].relname = "RDB$BEST_ROW";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 496;
        xSQLVARArray[4].sqlname = "COLUMN_SIZE";
        xSQLVARArray[4].relname = "RDB$BEST_ROW";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 496;
        xSQLVARArray[5].sqlname = "BUFFER_LENGTH";
        xSQLVARArray[5].relname = "RDB$BEST_ROW";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 500;
        xSQLVARArray[6].sqlname = "DECIMAL_DIGITS";
        xSQLVARArray[6].relname = "RDB$BEST_ROW";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 500;
        xSQLVARArray[7].sqlname = "PSEUDO_COLUMN";
        xSQLVARArray[7].relname = "RDB$BEST_ROW";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[8];
            objectArray[0] = new Short(2);
            objectArray[1] = resultSet.getString(1).trim();
            int n2 = IBTypes.getIBType(resultSet.getShort(2), resultSet.getShort(3), resultSet.getShort(4));
            objectArray[2] = new Short((short)IBTypes.getSQLType(n2));
            objectArray[3] = IBTypes.getIBTypeName(n2);
            objectArray[4] = new Integer(IBTypes.getColumnSize(n2, resultSet.getInt(5)));
            objectArray[5] = objectArray[4];
            objectArray[6] = new Short((short)Math.abs(resultSet.getInt(4)));
            objectArray[7] = new Short(0);
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 8);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        String string4 = string3.toUpperCase();
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, GET_VERSION_COLUMN);
        this.pstmt_.setString(1, string4);
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[8];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 500;
        xSQLVARArray[0].sqlname = "SCOPE";
        xSQLVARArray[0].relname = "RDB$VERSIONCOL";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 600;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = 0;
        xSQLVARArray[1].sqlname = "COLUMN_NAME";
        xSQLVARArray[1].relname = "RDB$VERSIONCOL";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 500;
        xSQLVARArray[2].sqlname = "DATA_TYPE";
        xSQLVARArray[2].relname = "RDB$VERSIONCOL";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = -1;
        xSQLVARArray[3].sqlname = "TYPE_NAME";
        xSQLVARArray[3].relname = "RDB$VERSIONCOL";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 496;
        xSQLVARArray[4].sqlname = "COLUMN_SIZE";
        xSQLVARArray[4].relname = "RDB$VERSIONCOL";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 496;
        xSQLVARArray[5].sqlname = "BUFFER_LENGTH";
        xSQLVARArray[5].relname = "RDB$VERSIONCOL";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 500;
        xSQLVARArray[6].sqlname = "DECIMAL_DIGITS";
        xSQLVARArray[6].relname = "RDB$VERSIONCOL";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 500;
        xSQLVARArray[7].sqlname = "PSEUDO_COLUMN";
        xSQLVARArray[7].relname = "RDB$VERSIONCOL";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[8];
            objectArray[0] = new Short(0);
            objectArray[1] = resultSet.getString(1).trim();
            int n = IBTypes.getIBType(resultSet.getShort(2), resultSet.getShort(3), resultSet.getShort(4));
            objectArray[2] = new Short((short)IBTypes.getSQLType(n));
            objectArray[3] = IBTypes.getIBTypeName(n);
            objectArray[4] = new Integer(IBTypes.getColumnSize(n, resultSet.getInt(5)));
            objectArray[5] = objectArray[4];
            objectArray[6] = new Short((short)Math.abs(resultSet.getInt(4)));
            objectArray[7] = new Short(0);
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 8);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        SqlPattern sqlPattern = new SqlPattern("RC.RDB$RELATION_NAME", string3);
        String string4 = GET_PRIMARY_KEYS_START + sqlPattern.getClause() + GET_PRIMARY_KEYS_END;
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, string4);
        if (!"%".equals(string3) && !"".equals(string3)) {
            this.pstmt_.setString(1, sqlPattern.getPattern());
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[6];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TABLE_CAT";
        xSQLVARArray[0].relname = "RDB$COLUMNINFO";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "TABLE_SCHEM";
        xSQLVARArray[1].relname = "RDB$COLUMNINFO";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "TABLE_NAME";
        xSQLVARArray[2].relname = "RDB$COLUMNINFO";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "COLUMN_NAME";
        xSQLVARArray[3].relname = "RDB$COLUMNINFO";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 500;
        xSQLVARArray[4].sqlname = "KEY_SEQ";
        xSQLVARArray[4].relname = "RDB$COLUMNINFO";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 601;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = 0;
        xSQLVARArray[5].sqlname = "PK_NAME";
        xSQLVARArray[5].relname = "RDB$COLUMNINFO";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[]{null, null, resultSet.getString("TABLE_NAME").trim(), resultSet.getString("COLUMN_NAME").trim(), new Short(resultSet.getShort("KEY_SEQ")), resultSet.getString("PK_NAME").trim()};
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 6);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        SqlPattern sqlPattern = new SqlPattern("FK.RDB$RELATION_NAME", string3);
        String string4 = GET_IMPORTED_KEYS_START + sqlPattern.getClause() + GET_IMPORTED_KEYS_END;
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, string4);
        if (!"%".equals(string3) && !"".equals(string3)) {
            this.pstmt_.setString(1, sqlPattern.getPattern());
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[14];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "PKTABLE_CAT";
        xSQLVARArray[0].relname = "COLUMNINFO";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "PKTABLE_SCHEM";
        xSQLVARArray[1].relname = "COLUMNINFO";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "PKTABLE_NAME";
        xSQLVARArray[2].relname = "COLUMNINFO";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "PKCOLUMN_NAME";
        xSQLVARArray[3].relname = "COLUMNINFO";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 601;
        xSQLVARArray[4].sqllen = 68;
        xSQLVARArray[4].sqlind = -1;
        xSQLVARArray[4].sqlname = "FKTABLE_CAT";
        xSQLVARArray[4].relname = "COLUMNINFO";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 601;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = -1;
        xSQLVARArray[5].sqlname = "FKTABLE_SCHEM";
        xSQLVARArray[5].relname = "COLUMNINFO";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 600;
        xSQLVARArray[6].sqllen = 68;
        xSQLVARArray[6].sqlind = 0;
        xSQLVARArray[6].sqlname = "FKTABLE_NAME";
        xSQLVARArray[6].relname = "COLUMNINFO";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 600;
        xSQLVARArray[7].sqllen = 68;
        xSQLVARArray[7].sqlind = 0;
        xSQLVARArray[7].sqlname = "FKCOLUMN_NAME";
        xSQLVARArray[7].relname = "COLUMNINFO";
        xSQLVARArray[8] = new XSQLVAR();
        xSQLVARArray[8].sqltype = 500;
        xSQLVARArray[8].sqlname = "KEY_SEQ";
        xSQLVARArray[8].relname = "COLUMNINFO";
        xSQLVARArray[9] = new XSQLVAR();
        xSQLVARArray[9].sqltype = 500;
        xSQLVARArray[9].sqlname = "UPDATE_RULE";
        xSQLVARArray[9].relname = "COLUMNINFO";
        xSQLVARArray[10] = new XSQLVAR();
        xSQLVARArray[10].sqltype = 500;
        xSQLVARArray[10].sqlname = "DELETE_RULE";
        xSQLVARArray[10].relname = "COLUMNINFO";
        xSQLVARArray[11] = new XSQLVAR();
        xSQLVARArray[11].sqltype = 601;
        xSQLVARArray[11].sqllen = 68;
        xSQLVARArray[11].sqlind = 0;
        xSQLVARArray[11].sqlname = "FK_NAME";
        xSQLVARArray[11].relname = "COLUMNINFO";
        xSQLVARArray[12] = new XSQLVAR();
        xSQLVARArray[12].sqltype = 601;
        xSQLVARArray[12].sqllen = 68;
        xSQLVARArray[12].sqlind = 0;
        xSQLVARArray[12].sqlname = "PK_NAME";
        xSQLVARArray[12].relname = "COLUMNINFO";
        xSQLVARArray[13] = new XSQLVAR();
        xSQLVARArray[13].sqltype = 500;
        xSQLVARArray[13].sqlname = "DEFERRABILITY";
        xSQLVARArray[13].relname = "COLUMNINFO";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[]{null, null, resultSet.getString("PKTABLE_NAME").trim(), resultSet.getString("PKCOLUMN_NAME").trim(), null, null, resultSet.getString("FKTABLE_NAME").trim(), resultSet.getString("FKCOLUMN_NAME").trim(), new Short(resultSet.getShort("KEY_SEQ")), new Short(this.mapRefConstraints(resultSet.getString("UPDATE_RULE"))), new Short(this.mapRefConstraints(resultSet.getString("DELETE_RULE"))), resultSet.getString("FK_NAME").trim(), resultSet.getString("PK_NAME").trim(), new Short(0)};
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 14);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    private short mapRefConstraints(String string) {
        if ("RESTRICT".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("CASCADE".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("SET NULL".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("NO ACTION".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("SET DEFAULT".equalsIgnoreCase(string)) {
            return 4;
        }
        return 1;
    }

    public synchronized java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        SqlPattern sqlPattern = new SqlPattern("PK.RDB$RELATION_NAME", string3);
        String string4 = GET_EXPORTED_KEYS_START + sqlPattern.getClause() + GET_EXPORTED_KEYS_END;
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, string4);
        if (!"%".equals(string3) && !"".equals(string3)) {
            this.pstmt_.setString(1, sqlPattern.getPattern());
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[14];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "PKTABLE_CAT";
        xSQLVARArray[0].relname = "COLUMNINFO";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "PKTABLE_SCHEM";
        xSQLVARArray[1].relname = "COLUMNINFO";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "PKTABLE_NAME";
        xSQLVARArray[2].relname = "COLUMNINFO";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "PKCOLUMN_NAME";
        xSQLVARArray[3].relname = "COLUMNINFO";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 601;
        xSQLVARArray[4].sqllen = 68;
        xSQLVARArray[4].sqlind = -1;
        xSQLVARArray[4].sqlname = "FKTABLE_CAT";
        xSQLVARArray[4].relname = "COLUMNINFO";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 601;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = -1;
        xSQLVARArray[5].sqlname = "FKTABLE_SCHEM";
        xSQLVARArray[5].relname = "COLUMNINFO";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 600;
        xSQLVARArray[6].sqllen = 68;
        xSQLVARArray[6].sqlind = 0;
        xSQLVARArray[6].sqlname = "FKTABLE_NAME";
        xSQLVARArray[6].relname = "COLUMNINFO";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 600;
        xSQLVARArray[7].sqllen = 68;
        xSQLVARArray[7].sqlind = 0;
        xSQLVARArray[7].sqlname = "FKCOLUMN_NAME";
        xSQLVARArray[7].relname = "COLUMNINFO";
        xSQLVARArray[8] = new XSQLVAR();
        xSQLVARArray[8].sqltype = 500;
        xSQLVARArray[8].sqlname = "KEY_SEQ";
        xSQLVARArray[8].relname = "COLUMNINFO";
        xSQLVARArray[9] = new XSQLVAR();
        xSQLVARArray[9].sqltype = 500;
        xSQLVARArray[9].sqlname = "UPDATE_RULE";
        xSQLVARArray[9].relname = "COLUMNINFO";
        xSQLVARArray[10] = new XSQLVAR();
        xSQLVARArray[10].sqltype = 500;
        xSQLVARArray[10].sqlname = "DELETE_RULE";
        xSQLVARArray[10].relname = "COLUMNINFO";
        xSQLVARArray[11] = new XSQLVAR();
        xSQLVARArray[11].sqltype = 601;
        xSQLVARArray[11].sqllen = 68;
        xSQLVARArray[11].sqlind = 0;
        xSQLVARArray[11].sqlname = "FK_NAME";
        xSQLVARArray[11].relname = "COLUMNINFO";
        xSQLVARArray[12] = new XSQLVAR();
        xSQLVARArray[12].sqltype = 601;
        xSQLVARArray[12].sqllen = 68;
        xSQLVARArray[12].sqlind = 0;
        xSQLVARArray[12].sqlname = "PK_NAME";
        xSQLVARArray[12].relname = "COLUMNINFO";
        xSQLVARArray[13] = new XSQLVAR();
        xSQLVARArray[13].sqltype = 500;
        xSQLVARArray[13].sqlname = "DEFERRABILITY";
        xSQLVARArray[13].relname = "COLUMNINFO";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[]{null, null, resultSet.getString("PKTABLE_NAME").trim(), resultSet.getString("PKCOLUMN_NAME").trim(), null, null, resultSet.getString("FKTABLE_NAME").trim(), resultSet.getString("FKCOLUMN_NAME").trim(), new Short(resultSet.getShort("KEY_SEQ")), new Short(this.mapRefConstraints(resultSet.getString("UPDATE_RULE"))), new Short(this.mapRefConstraints(resultSet.getString("DELETE_RULE"))), resultSet.getString("FK_NAME"), resultSet.getString("PK_NAME"), new Short(0)};
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 14);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        this.systemTableQueryPreamble(string4, string5);
        SqlPattern sqlPattern = new SqlPattern("PK.RDB$RELATION_NAME", string3);
        SqlPattern sqlPattern2 = new SqlPattern("FK.RDB$RELATION_NAME", string6);
        String string7 = GET_CROSS_KEYS_START + sqlPattern.getClause() + sqlPattern2.getClause() + GET_CROSS_KEYS_END;
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, string7);
        int n = 1;
        if (!"%".equals(string3) && !"".equals(string3)) {
            this.pstmt_.setString(n, sqlPattern.getPattern());
            ++n;
        }
        if (!"%".equals(string6) && !"".equals(string6)) {
            this.pstmt_.setString(n, sqlPattern2.getPattern());
        }
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[14];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "PKTABLE_CAT";
        xSQLVARArray[0].relname = "COLUMNINFO";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "PKTABLE_SCHEM";
        xSQLVARArray[1].relname = "COLUMNINFO";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "PKTABLE_NAME";
        xSQLVARArray[2].relname = "COLUMNINFO";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "PKCOLUMN_NAME";
        xSQLVARArray[3].relname = "COLUMNINFO";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 601;
        xSQLVARArray[4].sqllen = 68;
        xSQLVARArray[4].sqlind = -1;
        xSQLVARArray[4].sqlname = "FKTABLE_CAT";
        xSQLVARArray[4].relname = "COLUMNINFO";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 601;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = -1;
        xSQLVARArray[5].sqlname = "FKTABLE_SCHEM";
        xSQLVARArray[5].relname = "COLUMNINFO";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 600;
        xSQLVARArray[6].sqllen = 68;
        xSQLVARArray[6].sqlind = 0;
        xSQLVARArray[6].sqlname = "FKTABLE_NAME";
        xSQLVARArray[6].relname = "COLUMNINFO";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 600;
        xSQLVARArray[7].sqllen = 68;
        xSQLVARArray[7].sqlind = 0;
        xSQLVARArray[7].sqlname = "FKCOLUMN_NAME";
        xSQLVARArray[7].relname = "COLUMNINFO";
        xSQLVARArray[8] = new XSQLVAR();
        xSQLVARArray[8].sqltype = 500;
        xSQLVARArray[8].sqlname = "KEY_SEQ";
        xSQLVARArray[8].relname = "COLUMNINFO";
        xSQLVARArray[9] = new XSQLVAR();
        xSQLVARArray[9].sqltype = 500;
        xSQLVARArray[9].sqlname = "UPDATE_RULE";
        xSQLVARArray[9].relname = "COLUMNINFO";
        xSQLVARArray[10] = new XSQLVAR();
        xSQLVARArray[10].sqltype = 500;
        xSQLVARArray[10].sqlname = "DELETE_RULE";
        xSQLVARArray[10].relname = "COLUMNINFO";
        xSQLVARArray[11] = new XSQLVAR();
        xSQLVARArray[11].sqltype = 601;
        xSQLVARArray[11].sqllen = 68;
        xSQLVARArray[11].sqlind = 0;
        xSQLVARArray[11].sqlname = "FK_NAME";
        xSQLVARArray[11].relname = "COLUMNINFO";
        xSQLVARArray[12] = new XSQLVAR();
        xSQLVARArray[12].sqltype = 601;
        xSQLVARArray[12].sqllen = 68;
        xSQLVARArray[12].sqlind = 0;
        xSQLVARArray[12].sqlname = "PK_NAME";
        xSQLVARArray[12].relname = "COLUMNINFO";
        xSQLVARArray[13] = new XSQLVAR();
        xSQLVARArray[13].sqltype = 500;
        xSQLVARArray[13].sqlname = "DEFERRABILITY";
        xSQLVARArray[13].relname = "COLUMNINFO";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[]{null, null, resultSet.getString("PKTABLE_NAME").trim(), resultSet.getString("PKCOLUMN_NAME").trim(), null, null, resultSet.getString("FKTABLE_NAME").trim(), resultSet.getString("FKCOLUMN_NAME").trim(), new Short(resultSet.getShort("KEY_SEQ")), new Short(this.mapRefConstraints(resultSet.getString("UPDATE_RULE"))), new Short(this.mapRefConstraints(resultSet.getString("DELETE_RULE"))), resultSet.getString("FK_NAME"), resultSet.getString("PK_NAME"), new Short(0)};
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 14);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    private Short createShort(int n) throws java.sql.SQLException {
        if (n > Short.MAX_VALUE) {
            throw new java.sql.SQLException("Cannot convert integer to short.");
        }
        return new Short((short)n);
    }

    public synchronized java.sql.ResultSet getTypeInfo() throws java.sql.SQLException {
        this.checkForClosedConnection();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[18];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 600;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = 0;
        xSQLVARArray[0].sqlname = "TYPE_NAME";
        xSQLVARArray[0].relname = "RDB$TYPEINFO";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 500;
        xSQLVARArray[1].sqlname = "DATA_TYPE";
        xSQLVARArray[1].relname = "RDB$TYPEINFO";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 496;
        xSQLVARArray[2].sqlname = "PRECISION";
        xSQLVARArray[2].relname = "RDB$TYPEINFO";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 1;
        xSQLVARArray[3].sqlind = -1;
        xSQLVARArray[3].sqlname = "LITERAL_PREFIX";
        xSQLVARArray[3].relname = "RDB$TYPEINFO";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 600;
        xSQLVARArray[4].sqllen = 1;
        xSQLVARArray[4].sqlind = -1;
        xSQLVARArray[4].sqlname = "LITERAL_SUFFIX";
        xSQLVARArray[4].relname = "RDB$TYPEINFO";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 600;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = -1;
        xSQLVARArray[5].sqlname = "CREATE_PARAMS";
        xSQLVARArray[5].relname = "RDB$TYPEINFO";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 500;
        xSQLVARArray[6].sqlname = "NULLABLE";
        xSQLVARArray[6].relname = "RDB$TYPEINFO";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 500;
        xSQLVARArray[7].sqlname = "CASE_SENSITIVE";
        xSQLVARArray[7].relname = "RDB$TYPEINFO";
        xSQLVARArray[8] = new XSQLVAR();
        xSQLVARArray[8].sqltype = 500;
        xSQLVARArray[8].sqlname = "SEARCHABLE";
        xSQLVARArray[8].relname = "RDB$TYPEINFO";
        xSQLVARArray[9] = new XSQLVAR();
        xSQLVARArray[9].sqltype = 500;
        xSQLVARArray[9].sqlname = "UNSIGNED_ATTRIBUTE";
        xSQLVARArray[9].relname = "RDB$TYPEINFO";
        xSQLVARArray[10] = new XSQLVAR();
        xSQLVARArray[10].sqltype = 500;
        xSQLVARArray[10].sqlname = "FIXED_PREC_SCALE";
        xSQLVARArray[10].relname = "RDB$TYPEINFO";
        xSQLVARArray[11] = new XSQLVAR();
        xSQLVARArray[11].sqltype = 500;
        xSQLVARArray[11].sqlname = "AUTO_INCREMENT";
        xSQLVARArray[11].relname = "RDB$TYPEINFO";
        xSQLVARArray[12] = new XSQLVAR();
        xSQLVARArray[12].sqltype = 600;
        xSQLVARArray[12].sqllen = 68;
        xSQLVARArray[12].sqlind = -1;
        xSQLVARArray[12].sqlname = "LOCAL_TYPE_NAME";
        xSQLVARArray[12].relname = "RDB$TYPEINFO";
        xSQLVARArray[13] = new XSQLVAR();
        xSQLVARArray[13].sqltype = 500;
        xSQLVARArray[13].sqlname = "MINIMUM_SCALE";
        xSQLVARArray[13].relname = "RDB$TYPEINFO";
        xSQLVARArray[14] = new XSQLVAR();
        xSQLVARArray[14].sqltype = 500;
        xSQLVARArray[14].sqlname = "MAXIMUM_SCALE";
        xSQLVARArray[14].relname = "RDB$TYPEINFO";
        xSQLVARArray[15] = new XSQLVAR();
        xSQLVARArray[15].sqltype = 496;
        xSQLVARArray[15].sqlname = "SQL_DATA_TYPE";
        xSQLVARArray[15].relname = "RDB$TYPEINFO";
        xSQLVARArray[16] = new XSQLVAR();
        xSQLVARArray[16].sqltype = 496;
        xSQLVARArray[16].sqlname = "SQL_DATETIME_SUB";
        xSQLVARArray[16].relname = "RDB$TYPEINFO";
        xSQLVARArray[17] = new XSQLVAR();
        xSQLVARArray[17].sqltype = 496;
        xSQLVARArray[17].sqlname = "NUM_PREC_RADIX";
        xSQLVARArray[17].relname = "RDB$TYPEINFO";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        arrayList.add(new Object[]{"SMALLINT", this.createShort(-7), new Integer(5), null, null, null, NULLABLE, CASEINSENSITIVE, PREDBASIC, SIGNED, FIXEDSCALE, NOTAUTOINC, "SMALLINT", shortZero, shortZero, new Integer(500), null, DECIMAL});
        arrayList.add(new Object[]{"SMALLINT", new Short(-6), new Integer(5), null, null, null, NULLABLE, CASEINSENSITIVE, PREDBASIC, SIGNED, FIXEDSCALE, NOTAUTOINC, "SMALLINT", shortZero, shortZero, new Integer(500), null, DECIMAL});
        arrayList.add(new Object[]{"NUMERIC", this.createShort(-5), new Integer(18), null, null, null, NULLABLE, CASEINSENSITIVE, PREDBASIC, SIGNED, FIXEDSCALE, NOTAUTOINC, "NUMERIC", shortZero, shortZero, new Integer(580), null, DECIMAL});
        arrayList.add(new Object[]{"BLOB", this.createShort(-4), new Integer(0), null, null, "SUB_TYPE 0", NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "BLOB", shortZero, shortZero, new Integer(520), null, DECIMAL});
        arrayList.add(new Object[]{"BLOB", this.createShort(-3), new Integer(0), null, null, "SUB_TYPE 0", NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "BLOB", shortZero, shortZero, new Integer(520), null, DECIMAL});
        arrayList.add(new Object[]{"BLOB", this.createShort(-2), new Integer(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "BLOB", shortZero, shortZero, new Integer(520), null, DECIMAL});
        arrayList.add(new Object[]{"BLOB", this.createShort(-1), new Integer(0), null, null, "SUB_TYPE 1", NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "BLOB", shortZero, shortZero, new Integer(520), null, DECIMAL});
        arrayList.add(new Object[]{"CHAR", this.createShort(1), new Integer(0), "'", "'", null, NULLABLE, CASESENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "CHAR", shortZero, shortZero, new Integer(452), null, DECIMAL});
        arrayList.add(new Object[]{"NUMERIC", this.createShort(2), new Integer(18), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, "NUMERIC", shortZero, this.createShort(18), new Integer(580), null, DECIMAL});
        arrayList.add(new Object[]{"DECIMAL", this.createShort(3), new Integer(18), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, DECIMAL, shortZero, this.createShort(18), new Integer(580), null, DECIMAL});
        arrayList.add(new Object[]{"INTEGER", this.createShort(4), new Integer(32), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, "INTEGER", shortZero, shortZero, new Integer(496), null, DECIMAL});
        arrayList.add(new Object[]{"SMALLINT", this.createShort(5), new Integer(16), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, "SMALLINT", shortZero, shortZero, new Integer(500), null, DECIMAL});
        arrayList.add(new Object[]{"FLOAT", this.createShort(6), new Integer(7), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, "FLOAT", this.createShort(0), this.createShort(7), new Integer(482), null, DECIMAL});
        arrayList.add(new Object[]{"DOUBLE PRECISION", this.createShort(8), new Integer(15), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, "DOUBLE PRECISION", this.createShort(0), this.createShort(15), new Integer(480), null, DECIMAL});
        arrayList.add(new Object[]{"VARCHAR", this.createShort(12), new Integer(0), "'", "'", null, NULLABLE, CASESENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "VARCHAR", shortZero, shortZero, new Integer(448), null, DECIMAL});
        arrayList.add(new Object[]{"DATE", this.createShort(91), new Integer(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "DATE", shortZero, shortZero, new Integer(570), null, DECIMAL});
        arrayList.add(new Object[]{"TIME", this.createShort(92), new Integer(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "TIME", shortZero, shortZero, new Integer(560), null, DECIMAL});
        arrayList.add(new Object[]{"TIMESTAMP", this.createShort(93), new Integer(0), null, null, null, NULLABLE, CASEINSENSITIVE, SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "TIMESTAMP", shortZero, shortZero, new Integer(510), null, DECIMAL});
        arrayList.add(new Object[]{"BLOB", this.createShort(2004), new Integer(0), null, null, null, NULLABLE, CASESENSITIVE, PREDNONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, "BLOB", shortZero, shortZero, new Integer(520), null, DECIMAL});
        this.setCannedResult(xSQLVARArray, arrayList, 18);
        return this.rs_;
    }

    public synchronized java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws java.sql.SQLException {
        this.checkForClosedConnection();
        this.systemTableQueryPreamble(string, string2);
        StringBuffer stringBuffer = new StringBuffer(GET_INDEX_INFO_START);
        if (bl) {
            stringBuffer.append("and ind.RDB$UNIQUE_FLAG = 1 ");
        }
        stringBuffer.append(GET_INDEX_INFO_END);
        this.pstmt_ = (PreparedStatement)this.connection_.prepareStatement(3, stringBuffer.toString());
        String string4 = "".equals(string3) ? "%" : string3;
        this.pstmt_.setString(1, string4);
        ResultSet resultSet = (ResultSet)this.pstmt_.executeQuery();
        XSQLVAR[] xSQLVARArray = new XSQLVAR[13];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TABLE_CAT";
        xSQLVARArray[0].relname = "INDEXINFO";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "TABLE_SCHEM";
        xSQLVARArray[1].relname = "INDEXINFO";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "TABLE_NAME";
        xSQLVARArray[2].relname = "INDEXINFO";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 500;
        xSQLVARArray[3].sqlname = "NON_UNIQUE";
        xSQLVARArray[3].relname = "INDEXINFO";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 601;
        xSQLVARArray[4].sqllen = 68;
        xSQLVARArray[4].sqlind = -1;
        xSQLVARArray[4].sqlname = "INDEX_QUALIFIER";
        xSQLVARArray[4].relname = "INDEXINFO";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 600;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = -1;
        xSQLVARArray[5].sqlname = "INDEX_NAME";
        xSQLVARArray[5].relname = "INDEXINFO";
        xSQLVARArray[6] = new XSQLVAR();
        xSQLVARArray[6].sqltype = 500;
        xSQLVARArray[6].sqlname = "TYPE";
        xSQLVARArray[6].relname = "INDEXINFO";
        xSQLVARArray[7] = new XSQLVAR();
        xSQLVARArray[7].sqltype = 500;
        xSQLVARArray[7].sqlname = "ORDINAL_POSITION";
        xSQLVARArray[7].relname = "INDEXINFO";
        xSQLVARArray[8] = new XSQLVAR();
        xSQLVARArray[8].sqltype = 600;
        xSQLVARArray[8].sqllen = 68;
        xSQLVARArray[8].sqlind = 0;
        xSQLVARArray[8].sqlname = "COLUMN_NAME";
        xSQLVARArray[8].relname = "INDEXINFO";
        xSQLVARArray[9] = new XSQLVAR();
        xSQLVARArray[9].sqltype = 600;
        xSQLVARArray[9].sqllen = 1;
        xSQLVARArray[9].sqlind = -1;
        xSQLVARArray[9].sqlname = "ASC_OR_DESC";
        xSQLVARArray[9].relname = "INDEXINFO";
        xSQLVARArray[10] = new XSQLVAR();
        xSQLVARArray[10].sqltype = 496;
        xSQLVARArray[10].sqlname = "CARDINALITY";
        xSQLVARArray[10].relname = "INDEXINFO";
        xSQLVARArray[11] = new XSQLVAR();
        xSQLVARArray[11].sqltype = 496;
        xSQLVARArray[11].sqlname = "PAGES";
        xSQLVARArray[11].relname = "INDEXINFO";
        xSQLVARArray[12] = new XSQLVAR();
        xSQLVARArray[12].sqltype = 601;
        xSQLVARArray[12].sqllen = 68;
        xSQLVARArray[12].sqlind = -1;
        xSQLVARArray[12].sqlname = "FILTER_CONDITION";
        xSQLVARArray[12].relname = "INDEXINFO";
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        while (resultSet.next()) {
            Object[] objectArray = new Object[]{null, null, resultSet.getString("TABLE_NAME").trim(), new Short((short)(resultSet.getShort("NON_UNIQUE") != 1 ? 1 : 0)), null, resultSet.getString("INDEX_NAME").trim(), new Short(3), new Short((short)(resultSet.getShort("ORDINAL_POSITION") + 1)), resultSet.getString("COLUMN_NAME").trim(), new String(resultSet.getShort("ASC_OR_DESC") == 0 ? "A" : "D"), new Integer(0), new Integer(resultSet.getInt("IN_PAGES")), null};
            arrayList.add(objectArray);
        }
        this.setCannedResult(xSQLVARArray, arrayList, 13);
        resultSet.close();
        this.pstmt_.close();
        return this.rs_;
    }

    public synchronized boolean supportsResultSetType(int n) throws java.sql.SQLException {
        return n == 1003;
    }

    public synchronized boolean supportsResultSetConcurrency(int n, int n2) throws java.sql.SQLException {
        return (n == 1003 || n == 1004) && n2 == 1007;
    }

    public synchronized boolean ownUpdatesAreVisible(int n) throws java.sql.SQLException {
        return false;
    }

    public synchronized boolean ownDeletesAreVisible(int n) throws java.sql.SQLException {
        return false;
    }

    public synchronized boolean ownInsertsAreVisible(int n) throws java.sql.SQLException {
        return false;
    }

    public synchronized boolean othersUpdatesAreVisible(int n) throws java.sql.SQLException {
        return false;
    }

    public synchronized boolean othersDeletesAreVisible(int n) throws java.sql.SQLException {
        return false;
    }

    public synchronized boolean othersInsertsAreVisible(int n) throws java.sql.SQLException {
        return false;
    }

    public synchronized boolean updatesAreDetected(int n) throws java.sql.SQLException {
        return false;
    }

    public synchronized boolean deletesAreDetected(int n) throws java.sql.SQLException {
        return false;
    }

    public synchronized boolean insertsAreDetected(int n) throws java.sql.SQLException {
        return false;
    }

    public synchronized boolean supportsBatchUpdates() throws java.sql.SQLException {
        return true;
    }

    public synchronized java.sql.ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws java.sql.SQLException {
        XSQLVAR[] xSQLVARArray = new XSQLVAR[6];
        xSQLVARArray[0] = new XSQLVAR();
        xSQLVARArray[0].sqltype = 601;
        xSQLVARArray[0].sqllen = 68;
        xSQLVARArray[0].sqlind = -1;
        xSQLVARArray[0].sqlname = "TYPE_CAT";
        xSQLVARArray[0].relname = "";
        xSQLVARArray[1] = new XSQLVAR();
        xSQLVARArray[1].sqltype = 601;
        xSQLVARArray[1].sqllen = 68;
        xSQLVARArray[1].sqlind = -1;
        xSQLVARArray[1].sqlname = "TYPE_SCHEM";
        xSQLVARArray[1].relname = "";
        xSQLVARArray[2] = new XSQLVAR();
        xSQLVARArray[2].sqltype = 600;
        xSQLVARArray[2].sqllen = 68;
        xSQLVARArray[2].sqlind = 0;
        xSQLVARArray[2].sqlname = "TYPE_NAME";
        xSQLVARArray[2].relname = "";
        xSQLVARArray[3] = new XSQLVAR();
        xSQLVARArray[3].sqltype = 600;
        xSQLVARArray[3].sqllen = 68;
        xSQLVARArray[3].sqlind = 0;
        xSQLVARArray[3].sqlname = "CLASS_NAME";
        xSQLVARArray[3].relname = "";
        xSQLVARArray[4] = new XSQLVAR();
        xSQLVARArray[4].sqltype = 500;
        xSQLVARArray[4].sqlname = "DATA_TYPE";
        xSQLVARArray[4].relname = "";
        xSQLVARArray[5] = new XSQLVAR();
        xSQLVARArray[5].sqltype = 601;
        xSQLVARArray[5].sqllen = 68;
        xSQLVARArray[5].sqlind = 0;
        xSQLVARArray[5].sqlname = "REMARKS";
        xSQLVARArray[5].relname = "";
        ArrayList arrayList = new ArrayList(0);
        this.setCannedResult(xSQLVARArray, arrayList, 6);
        return this.rs_;
    }

    public synchronized java.sql.Connection getConnection() throws java.sql.SQLException {
        return this.connection_;
    }

    public Date getDriverExpirationDate() {
        return Globals.interclientExpirationDate__;
    }

    public int getDatabaseMajorVersion() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.ibMajorVersion_;
    }

    public int getODSMajorVersion() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.odsMajorVersion_;
    }

    public int getODSMinorVersion() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.odsMinorVersion_;
    }

    public synchronized int getActualCachePagesInUse() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized int getPersistentDatabaseCachePages() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public int getPageAllocation() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.pageAllocation_;
    }

    public int getPageSize() throws java.sql.SQLException {
        this.checkForClosedConnection();
        return this.pageSize_;
    }

    public synchronized boolean getSweepInterval() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized boolean isDatabaseReadWrite() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized boolean reservingSpaceForVersioning() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized boolean usingSynchronousWrites() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized DatabaseStatistics getStatistics() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String[] getUsersConnected() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    public synchronized String getUDFs() throws java.sql.SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    private String systemTableValue(String string) {
        if (string.length() > 2 && string.startsWith("\"") && string.endsWith("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    public synchronized boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public synchronized boolean supportsNamedParameters() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public synchronized boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public synchronized java.sql.ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean supportsResultSetHoldability(int n) throws SQLException {
        return false;
    }

    public synchronized int getResultSetHoldability() throws SQLException {
        if (this.rs_ != null) {
            return 2;
        }
        return 2;
    }

    public synchronized int getDatabaseMinorVersion() throws SQLException {
        return this.ibMinorVersion_;
    }

    public synchronized int getJDBCMajorVersion() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getJDBCMinorVersion() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getSQLStateType() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean locatorsUpdateCopy() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    private class SqlPattern {
        private String clause = "";
        private String pattern;

        public SqlPattern(String string, String string2) {
            if (string2 == null) {
                return;
            }
            if ("%".equals(string2) || "".equals(string2)) {
                return;
            }
            if (DatabaseMetaData.this.exactMatch(string2)) {
                this.pattern = DatabaseMetaData.this.systemTableValue(DatabaseMetaData.this.stripEscape(string2));
                this.clause = string + " = ? and ";
            } else {
                this.pattern = DatabaseMetaData.this.systemTableValue(string2);
                this.clause = string + " || '" + DatabaseMetaData.SPACES + "' like ? escape '\\' and ";
            }
        }

        public String getClause() {
            return this.clause;
        }

        public String getPattern() {
            return this.pattern;
        }
    }
}

