/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.ErrorKey;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Properties;

class IBException
extends SQLException {
    protected int type;
    protected int intParam;
    protected String strParam;
    protected IBException next;
    private static final String MESSAGES = "isc_error_msg";
    private static Properties messages = new Properties();
    private static boolean initialized = false;
    static /* synthetic */ Class class$interbase$interclient$IBException;

    protected String getParam() {
        if (this.type == 5 || this.type == 2) {
            return this.strParam;
        }
        if (this.type == 4) {
            return "" + this.intParam;
        }
        return "";
    }

    int getIntParam() {
        return this.intParam;
    }

    IBException(int n, int n2) {
        this.type = n;
        this.intParam = n2;
    }

    IBException(long l, String string) {
        this.type = (int)l;
        this.strParam = string;
    }

    IBException(int n, String string) {
        this.type = n;
        this.strParam = string;
    }

    IBException(int n) {
        this.intParam = n;
        this.type = 1;
    }

    IBException(long l) {
        this.intParam = (int)l;
        this.type = 1;
    }

    IBException(String string) {
        super(string);
        this.type = 2;
    }

    protected void finalize() throws Throwable {
        this.next = null;
        this.strParam = null;
        super.finalize();
    }

    public int getErrorCode() {
        return this.getIbErrorCode();
    }

    int getIbErrorCode() {
        return this.intParam;
    }

    void setNext(IBException iBException) {
        this.next = iBException;
    }

    IBException getNext() {
        return this.next;
    }

    public String getMessage() {
        String string;
        IBException iBException = this.next;
        if (this.type == 1 || this.type == 18) {
            IBMessage iBMessage = IBException.getMessage(this.intParam);
            int n = iBMessage.getParamCount();
            for (int i = 0; i < n && iBException != null; ++i) {
                iBMessage.setParameter(i, iBException.getParam());
                iBException = iBException.next;
            }
            string = iBMessage.toString();
        } else {
            string = super.getMessage();
        }
        if (iBException != null) {
            string = string + "\n" + iBException.getMessage();
            iBException = iBException.next;
        }
        return string;
    }

    public String getSQLState() {
        return ErrorKey.getIBSQLState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Properties properties = messages;
        synchronized (properties) {
            if (initialized) {
                return;
            }
            try {
                String string = "isc_error_msg.properties";
                InputStream inputStream = (class$interbase$interclient$IBException == null ? (class$interbase$interclient$IBException = IBException.class$("interbase.interclient.IBException")) : class$interbase$interclient$IBException).getResourceAsStream(string);
                if (messages == null) {
                    messages = new Properties();
                }
                messages.load(inputStream);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                initialized = true;
            }
        }
    }

    static IBMessage getMessage(int n) {
        if (!initialized) {
            IBException.init();
        }
        return new IBMessage(messages.getProperty("" + n, "Message for error code " + n + " not found in resource file."));
    }

    SQLException getSQLExceptionFromIBE() {
        return new SQLException(this.getMessage(), this.getSQLState(), this.getIbErrorCode());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class IBMessage {
        private String template;
        private String[] params;

        public IBMessage(String string) {
            this.template = "[interclient][interbase]" + string;
            this.params = new String[this.getParamCount()];
        }

        protected void finalize() throws Throwable {
            this.params = null;
            this.template = null;
            super.finalize();
        }

        int getParamCount() {
            int n = 0;
            for (int i = 0; i < this.template.length(); ++i) {
                if (this.template.charAt(i) != '{') continue;
                ++n;
            }
            return n;
        }

        void setParameter(int n, String string) {
            if (n < this.params.length) {
                this.params[n] = string;
            }
        }

        public String toString() {
            String string = this.template;
            for (int i = 0; i < this.params.length; ++i) {
                String string2 = "{" + i + "}";
                int n = string.indexOf(string2);
                if (n <= 0 || n >= string.length()) continue;
                String string3 = string.substring(0, n);
                string3 = string3 + (this.params[i] == null ? "" : this.params[i]);
                string = string3 = string3 + string.substring(n + string2.length());
            }
            return string;
        }
    }
}

