/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Connection;
import interbase.interclient.IBException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;

public final class IBSavepoint
implements Savepoint {
    private int savepointId;
    private String savepointName;
    private boolean named;
    private boolean opened;
    private Connection connection;
    private SQLWarning sqlWarning;
    private static String autoString = "IC_AUTO";

    IBSavepoint(String string, Connection connection) throws IBException, SQLException {
        this.savepointName = string;
        this.named = true;
        this.connection = connection;
        this.createSavepoint();
    }

    IBSavepoint(int n, Connection connection) throws IBException, SQLException {
        Integer n2 = new Integer(n);
        if (n < 0) {
            throw new IBException(225544003);
        }
        this.savepointName = autoString + n2.toString();
        this.connection = connection;
        this.named = false;
        this.createSavepoint();
    }

    protected void finalize() throws Throwable {
        this.savepointName = null;
        this.connection = null;
        this.sqlWarning = null;
        super.finalize();
    }

    synchronized void closeSavepoint() throws IBException, SQLException {
        if (this.opened) {
            IBException iBException = null;
            this.connection.ibase_.iscReleaseSavepoint(this.savepointName, this.connection.db_, this.connection.tra_, iBException);
            this.opened = false;
            this.setSQLWarnings(iBException);
        }
    }

    private synchronized void createSavepoint() throws IBException, SQLException {
        IBException iBException = null;
        this.opened = true;
        this.connection.ibase_.iscStartSavepoint(this.savepointName, this.connection.db_, this.connection.tra_, iBException);
        this.setSQLWarnings(iBException);
    }

    synchronized void rollbackSavepoint() throws IBException, SQLException {
        if (this.opened) {
            IBException iBException = null;
            this.connection.ibase_.iscRollbackSavepoint(this.savepointName, this.connection.db_, this.connection.tra_, iBException);
            this.setSQLWarnings(iBException);
        }
    }

    public int getSavepointId() throws IBException {
        if (!this.named) {
            return this.savepointId;
        }
        throw new IBException(225544001);
    }

    public String getSavepointName() throws IBException {
        if (this.named) {
            return this.savepointName;
        }
        throw new IBException(225544002);
    }

    private void setSQLWarnings(IBException iBException) {
        if (iBException != null) {
            IBException iBException2;
            if (this.sqlWarning == null) {
                this.sqlWarning = new SQLWarning(iBException.getMessage(), "", iBException.getIbErrorCode());
            } else {
                this.sqlWarning.setNextWarning(new SQLWarning(iBException.getMessage(), "", iBException.getIbErrorCode()));
            }
            while ((iBException2 = iBException.getNext()) != null) {
                this.sqlWarning.setNextWarning(new SQLWarning(iBException2.getMessage(), "", iBException2.getIbErrorCode()));
            }
        }
    }

    static Savepoint setSavepoint(String string, Connection connection) throws IBException, SQLException {
        return new IBSavepoint(string, connection);
    }

    static Savepoint setSavepoint(int n, Connection connection) throws IBException, SQLException {
        return new IBSavepoint(n, connection);
    }
}

