/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.XdrEnabled;
import interbase.interclient.XdrInputStream;
import interbase.interclient.XdrOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

class IBStruct
implements XdrEnabled,
Serializable {
    int structType;
    byte[] structContains;
    IBStruct nextStruct;

    IBStruct(int n, byte[] byArray) {
        this.structType = n;
        this.structContains = byArray;
    }

    IBStruct(IBStruct iBStruct) {
        this.structType = iBStruct.structType;
        this.structContains = iBStruct.structContains;
        if (iBStruct.nextStruct != null) {
            this.nextStruct = new IBStruct(iBStruct.nextStruct);
        }
    }

    void append(IBStruct iBStruct) {
        IBStruct iBStruct2 = iBStruct;
        if (this.structType == iBStruct2.structType) {
            this.structContains = iBStruct2.structContains;
        } else if (this.nextStruct == null) {
            this.nextStruct = iBStruct2;
        } else {
            this.nextStruct.append(iBStruct);
        }
    }

    byte[] find(int n) {
        if (n == this.structType) {
            return this.structContains;
        }
        if (this.nextStruct == null) {
            return null;
        }
        return this.nextStruct.find(n);
    }

    public int getSize() {
        if (this.nextStruct == null) {
            return this.structContains.length + 2;
        }
        return this.structContains.length + 2 + this.nextStruct.getSize();
    }

    public void write(XdrOutputStream xdrOutputStream) throws IOException {
        xdrOutputStream.write(this.structType);
        xdrOutputStream.write(this.structContains.length);
        xdrOutputStream.write(this.structContains);
        if (this.nextStruct != null) {
            this.nextStruct.write(xdrOutputStream);
        }
    }

    public void read(XdrInputStream xdrInputStream, int n) {
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof IBStruct)) {
            return false;
        }
        IBStruct iBStruct = (IBStruct)object;
        if (this.structType != iBStruct.structType || !Arrays.equals(this.structContains, iBStruct.structContains)) {
            return false;
        }
        if (this.nextStruct != null) {
            return this.nextStruct.equals(iBStruct.nextStruct);
        }
        return iBStruct.nextStruct == null;
    }

    public int hashCode() {
        int n = this.structType;
        for (int i = 0; i < this.structContains.length; ++i) {
            n ^= this.structContains[i] << 8 * (i % 4);
        }
        if (this.nextStruct != null) {
            n ^= this.nextStruct.hashCode();
        }
        return n;
    }
}

