/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Array;
import interbase.interclient.ArrayDescriptor;
import interbase.interclient.CharacterEncodings;
import interbase.interclient.CommunicationException;
import interbase.interclient.ErrorKey;
import interbase.interclient.IBException;
import interbase.interclient.IBStruct;
import interbase.interclient.IBTimestamp;
import interbase.interclient.IscBlobHandle;
import interbase.interclient.IscDbHandle;
import interbase.interclient.IscStmtHandle;
import interbase.interclient.IscTrHandle;
import interbase.interclient.SQLException;
import interbase.interclient.Utils;
import interbase.interclient.XSQLDA;
import interbase.interclient.XSQLVAR;
import interbase.interclient.XdrInputStream;
import interbase.interclient.XdrOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Set;

class Ibase {
    private DbAttachInfo dbai = null;
    static String jdkVersion = null;

    Ibase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscCreateDatabase(String string, String string2, int n, int n2, IscDbHandle iscDbHandle, IBStruct iBStruct, IBException iBException) throws IBException, SQLException {
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            this.dbai = new DbAttachInfo(string2, n, string, n2);
            try {
                this.connect(iscDbHandle, this.dbai);
            }
            catch (IOException iOException) {
                this.disconnect(iscDbHandle);
                throw new IBException(335544721L);
            }
            try {
                iscDbHandle.out.writeInt(20);
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.writeStringAndNull(this.dbai.getFileNameSlash());
                iscDbHandle.out.writeTyped(1, iBStruct);
                iscDbHandle.out.flush();
                try {
                    Response response = this.receiveResponse(iscDbHandle, iBException);
                    iscDbHandle.setRdb_id(response.resp_object);
                    this.dbai.setPartnerPort(response.resp_blob_id);
                    iscDbHandle.socket.setSoTimeout(0);
                }
                catch (IBException iBException2) {
                    this.disconnect(iscDbHandle);
                    throw iBException2;
                }
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscAttachDatabase(String string, String string2, int n, int n2, IscDbHandle iscDbHandle, IBStruct iBStruct, IBException iBException) throws IBException, SQLException {
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            this.dbai = new DbAttachInfo(string2, n, string, n2);
            try {
                try {
                    this.connect(iscDbHandle, this.dbai);
                }
                catch (IOException iOException) {
                    this.disconnect(iscDbHandle);
                    throw new IBException(335544721L);
                }
                iscDbHandle.out.writeInt(19);
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.writeStringAndNull(this.dbai.getFileNameSlash());
                iscDbHandle.out.writeTyped(1, iBStruct);
                iscDbHandle.out.flush();
                try {
                    Response response = this.receiveResponse(iscDbHandle, iBException);
                    iscDbHandle.setRdb_id(response.resp_object);
                    this.dbai.setPartnerPort(response.resp_blob_id);
                    iscDbHandle.socket.setSoTimeout(0);
                }
                catch (IBException iBException2) {
                    this.disconnect(iscDbHandle);
                    throw iBException2;
                }
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    byte[] iscDatabaseInfo(IscDbHandle iscDbHandle, byte[] byArray, int n, IBException iBException) throws IBException, SQLException {
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(40);
                iscDbHandle.out.writeInt(iscDbHandle.getRdb_id());
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.writeBuffer(byArray, byArray.length);
                iscDbHandle.out.writeInt(n);
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
                return response.resp_data;
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscDetachDatabase(IscDbHandle iscDbHandle, IBException iBException) throws IBException, SQLException {
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(21);
                iscDbHandle.out.writeInt(iscDbHandle.getRdb_id());
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
                this.disconnect(iscDbHandle);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscDropDatabase(IscDbHandle iscDbHandle, IBException iBException) throws IBException, SQLException {
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(81);
                iscDbHandle.out.writeInt(iscDbHandle.getRdb_id());
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscStartTransaction(IscTrHandle iscTrHandle, IscDbHandle iscDbHandle, Set set, IBException iBException) throws IBException, SQLException {
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            if (iscTrHandle.getState() != 0) {
                throw new IBException(335544468L);
            }
            iscTrHandle.setState(1);
            try {
                iscDbHandle.out.writeInt(29);
                iscDbHandle.out.writeInt(iscDbHandle.getRdb_id());
                iscDbHandle.out.writeSet(3, set);
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
                iscTrHandle.rtr_id = response.resp_object;
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            iscTrHandle.rtr_rdb = iscDbHandle;
            iscTrHandle.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscCommitTransaction(IscTrHandle iscTrHandle, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle;
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle = iscTrHandle.rtr_rdb;
        synchronized (iscDbHandle2) {
            iscTrHandle.setState(5);
            try {
                iscDbHandle.out.writeInt(30);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            iscTrHandle.setState(0);
            iscTrHandle.rtr_rdb = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscCommitRetaining(IscTrHandle iscTrHandle, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle;
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle = iscTrHandle.rtr_rdb;
        synchronized (iscDbHandle2) {
            iscTrHandle.setState(5);
            try {
                iscDbHandle.out.writeInt(50);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            iscTrHandle.setState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscPrepareTransaction(IscTrHandle iscTrHandle, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle;
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle = iscTrHandle.rtr_rdb;
        synchronized (iscDbHandle2) {
            if (iscTrHandle.getState() != 2) {
                throw new IBException(335544468L);
            }
            iscTrHandle.setState(3);
            try {
                iscDbHandle.out.writeInt(32);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            iscTrHandle.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscPrepareTransaction2(IscTrHandle iscTrHandle, byte[] byArray, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle;
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle = iscTrHandle.rtr_rdb;
        synchronized (iscDbHandle2) {
            if (iscTrHandle.getState() != 2) {
                throw new IBException(335544468L);
            }
            iscTrHandle.setState(3);
            try {
                iscDbHandle.out.writeInt(51);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.writeBuffer(byArray, byArray.length);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            iscTrHandle.setState(4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscRollbackTransaction(IscTrHandle iscTrHandle, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle;
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle = iscTrHandle.rtr_rdb;
        synchronized (iscDbHandle2) {
            if (iscTrHandle.getState() != 2 && iscTrHandle.getState() != 4) {
                throw new IBException(335544468L);
            }
            iscTrHandle.setState(6);
            try {
                iscDbHandle.out.writeInt(31);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            iscTrHandle.setState(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscRollbackRetaining(IscTrHandle iscTrHandle, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle;
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle = iscTrHandle.rtr_rdb;
        synchronized (iscDbHandle2) {
            if (iscTrHandle.getState() != 2 && iscTrHandle.getState() != 4) {
                throw new IBException(335544468L);
            }
            iscTrHandle.setState(6);
            try {
                iscDbHandle.out.writeInt(86);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            iscTrHandle.setState(2);
            iscTrHandle.rtr_rdb = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscDsqlAllocateStatement(IscDbHandle iscDbHandle, IscStmtHandle iscStmtHandle, IBException iBException) throws IBException, SQLException {
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        if (iscStmtHandle == null) {
            throw new IBException(335544327L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(62);
                iscDbHandle.out.writeInt(iscDbHandle.getRdb_id());
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
                iscStmtHandle.rsr_id = response.resp_object;
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
            iscStmtHandle.iscDbHandle = iscDbHandle;
            iscStmtHandle.allRowsFetched = false;
        }
    }

    void iscDsqlAllocStatement2(IscDbHandle iscDbHandle, IscStmtHandle iscStmtHandle) throws IBException, SQLException {
        throw new IBException(335544378L);
    }

    XSQLDA iscDsqlDescribe(IscStmtHandle iscStmtHandle, int n, IBException iBException) throws IBException, SQLException {
        byte[] byArray = iscStmtHandle.getMinorDatabaseVersion() < 0 ? new byte[]{4, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 8} : new byte[]{4, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 25, 8};
        byte[] byArray2 = this.iscDsqlSqlInfo(iscStmtHandle, byArray.length, byArray, 1024, iBException);
        return this.parseSqlInfo(iscStmtHandle, byArray2, byArray, iBException);
    }

    void iscDsqlDescribeBind(IscStmtHandle iscStmtHandle, IBException iBException) throws IBException, SQLException {
        byte[] byArray = iscStmtHandle.getMinorDatabaseVersion() < 0 ? new byte[]{5, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 8} : new byte[]{5, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 25, 8};
        byte[] byArray2 = this.iscDsqlSqlInfo(iscStmtHandle, byArray.length, byArray, 1024, iBException);
        iscStmtHandle.in_sqlda = this.parseSqlInfo(iscStmtHandle, byArray2, byArray, iBException);
    }

    void iscDsqlExecute(IscTrHandle iscTrHandle, IscStmtHandle iscStmtHandle, XSQLDA xSQLDA, IBException iBException) throws IBException, SQLException {
        this.iscDsqlExecute2(iscTrHandle, iscStmtHandle, xSQLDA, null, iBException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscDsqlExecute2(IscTrHandle iscTrHandle, IscStmtHandle iscStmtHandle, XSQLDA xSQLDA, XSQLDA xSQLDA2, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle = iscStmtHandle.iscDbHandle;
        iscStmtHandle.clearRows();
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                if (!this.isSQLDataOK(xSQLDA)) {
                    throw new IBException(335544713L);
                }
                iscDbHandle.out.writeInt(xSQLDA2 == null ? 63 : 76);
                iscDbHandle.out.writeInt(iscStmtHandle.rsr_id);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                this.writeBLRBatch(iscDbHandle, 1, xSQLDA);
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.writeInt(xSQLDA == null ? 0 : 1);
                if (xSQLDA != null) {
                    this.writeSQLData(iscDbHandle, xSQLDA);
                }
                if (xSQLDA2 != null) {
                    this.writeBLRBatch(iscDbHandle, 1, xSQLDA2);
                    iscDbHandle.out.writeInt(0);
                }
                iscDbHandle.out.flush();
                if (this.nextOperation(iscDbHandle) == 78) {
                    iscStmtHandle.rows.add(this.receiveSqlResponse(iscDbHandle, xSQLDA2));
                    iscStmtHandle.allRowsFetched = true;
                    iscStmtHandle.singletonResult = true;
                } else {
                    iscStmtHandle.singletonResult = false;
                }
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    void iscDsqlExecuteImmediate(IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, String string, int n, XSQLDA xSQLDA, IBException iBException) throws IBException, SQLException {
        this.iscDsqlExecImmed2(iscDbHandle, iscTrHandle, string, n, xSQLDA, null, iBException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscDsqlExecImmed2(IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, String string, int n, XSQLDA xSQLDA, XSQLDA xSQLDA2, IBException iBException) throws IBException, SQLException {
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                if (!this.isSQLDataOK(xSQLDA)) {
                    throw new IBException(335544713L);
                }
                if (xSQLDA == null && xSQLDA2 == null) {
                    iscDbHandle.out.writeInt(64);
                } else {
                    iscDbHandle.out.writeInt(75);
                    this.writeBLRBatch(iscDbHandle, 1, xSQLDA);
                    iscDbHandle.out.writeInt(0);
                    iscDbHandle.out.writeInt(xSQLDA == null ? 0 : 1);
                    if (xSQLDA != null) {
                        this.writeSQLData(iscDbHandle, xSQLDA);
                    }
                    this.writeBLRBatch(iscDbHandle, 1, xSQLDA2);
                    iscDbHandle.out.writeInt(0);
                }
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.writeInt(n);
                iscDbHandle.out.writeString(string, iscDbHandle.charSetToUse_);
                iscDbHandle.out.writeString("");
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.flush();
                if (this.nextOperation(iscDbHandle) == 78) {
                    this.receiveSqlResponse(iscDbHandle, xSQLDA2);
                }
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscDsqlBatchExecute(IscTrHandle iscTrHandle, IscStmtHandle iscStmtHandle, ArrayList arrayList, int[] nArray, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle;
        if (arrayList == null) {
            return;
        }
        if (iscStmtHandle == null) {
            throw new IBException(0x14000004L);
        }
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle = iscStmtHandle.iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                int n = arrayList.size();
                XSQLDA xSQLDA = iscStmtHandle.getInSqlda();
                if (xSQLDA == null) {
                    throw new IBException(335544713L);
                }
                iscDbHandle.out.writeInt(93);
                iscDbHandle.out.writeInt(iscStmtHandle.rsr_id);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                this.writeBLRBatch(iscDbHandle, arrayList.size(), xSQLDA);
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.writeInt(xSQLDA == null ? 0 : 1);
                if (xSQLDA != null) {
                    this.writeSQLBatchData(iscStmtHandle, arrayList);
                }
                iscDbHandle.out.writeInt(n);
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
                for (int i = 0; i < n; ++i) {
                    nArray[i] = Ibase.iscVaxInteger(response.resp_data, i * 4, 4);
                }
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscDsqlBatchExecuteImmed(IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, int n, ByteArrayOutputStream byteArrayOutputStream, int[] nArray, IBException iBException) throws IBException, SQLException {
        if (byteArrayOutputStream == null) {
            return;
        }
        int n2 = nArray.length;
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        if (this.dbai.getNegotiatedProtocol() < 14) {
            return;
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(92);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.writeInt(n);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (byArray.length > 65534) {
                    throw new IBException(225544008L);
                }
                iscDbHandle.out.writeBuffer(byArray, byArray.length);
                iscDbHandle.out.writeString("");
                iscDbHandle.out.writeInt(n2);
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = Ibase.iscVaxInteger(response.resp_data, i * 4, 4);
                }
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean iscDsqlFetch(IscStmtHandle iscStmtHandle, int n, XSQLDA xSQLDA, IBException iBException, int n2) throws IBException, SQLException {
        if (iscStmtHandle == null) {
            throw new IBException(335544327L);
        }
        if (xSQLDA == null) {
            throw new IBException(335544583L);
        }
        if (!iscStmtHandle.allRowsFetched) {
            IscDbHandle iscDbHandle;
            IscDbHandle iscDbHandle2 = iscDbHandle = iscStmtHandle.iscDbHandle;
            synchronized (iscDbHandle2) {
                try {
                    iscDbHandle.out.writeInt(65);
                    iscDbHandle.out.writeInt(iscStmtHandle.rsr_id);
                    this.writeBLRBatch(iscDbHandle, 1, xSQLDA);
                    iscDbHandle.out.writeInt(0);
                    if (n2 <= 0) {
                        iscDbHandle.out.writeInt(200);
                    } else {
                        iscDbHandle.out.writeInt(n2);
                    }
                    iscDbHandle.out.flush();
                    if (this.nextOperation(iscDbHandle) == 66) {
                        int n3;
                        boolean bl;
                        int n4 = 0;
                        int n5 = 0;
                        do {
                            if ((n3 = this.readOperation(iscDbHandle)) == 66) {
                                n4 = iscDbHandle.in.readInt();
                                n5 = iscDbHandle.in.readInt();
                                if (n5 > 0 && n4 == 0) {
                                    iscStmtHandle.rows.add(this.readSQLData(iscDbHandle, xSQLDA));
                                    bl = true;
                                    continue;
                                }
                                bl = false;
                                continue;
                            }
                            bl = false;
                        } while (bl);
                        if (n3 == 9) {
                            this.receiveResponseAfterOp(iscDbHandle, iBException);
                        }
                        if (n4 == 100) {
                            iscStmtHandle.allRowsFetched = true;
                        }
                    } else {
                        this.receiveResponse(iscDbHandle, iBException);
                    }
                }
                catch (IOException iOException) {
                    throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
                }
            }
        }
        return iscStmtHandle.rows.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscDsqlFreeStatement(IscStmtHandle iscStmtHandle, int n, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle = iscStmtHandle.iscDbHandle;
        if (iscStmtHandle == null) {
            throw new IBException(335544327L);
        }
        if (iscStmtHandle.singletonResult && n == 1) {
            return;
        }
        if (n == 4) {
            if (this.dbai != null) {
                try {
                    IscDbHandle iscDbHandle2 = this.makePartner();
                    iscDbHandle2.out.writeInt(67);
                    iscDbHandle2.out.writeInt(iscStmtHandle.rsr_id);
                    iscDbHandle2.out.writeInt(n);
                    iscDbHandle2.out.flush();
                    this.receiveResponse(iscDbHandle2, iBException);
                    iscDbHandle2.out.close();
                    iscDbHandle2.socket.close();
                }
                catch (IOException iOException) {
                    throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
                }
            }
            return;
        }
        IscDbHandle iscDbHandle3 = iscDbHandle;
        synchronized (iscDbHandle3) {
            try {
                iscDbHandle.out.writeInt(67);
                iscDbHandle.out.writeInt(iscStmtHandle.rsr_id);
                iscDbHandle.out.writeInt(n);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
                if (n == 2) {
                    iscStmtHandle.in_sqlda = null;
                    iscStmtHandle.out_sqlda = null;
                }
                iscStmtHandle.clearRows();
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    XSQLDA iscDsqlPrepare(IscTrHandle iscTrHandle, IscStmtHandle iscStmtHandle, String string, int n, IBException iBException) throws IBException, SQLException {
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        if (iscStmtHandle == null) {
            throw new IBException(335544327L);
        }
        IscDbHandle iscDbHandle = iscStmtHandle.iscDbHandle;
        iscStmtHandle.in_sqlda = null;
        iscStmtHandle.out_sqlda = null;
        byte[] byArray = new byte[]{4, 7, 9, 11, 12, 13, 14, 16, 17, 18, 19, 25, 8};
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(68);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.writeInt(iscStmtHandle.rsr_id);
                iscDbHandle.out.writeInt(n);
                iscDbHandle.out.writeString(string, iscDbHandle.charSetToUse_);
                iscDbHandle.out.writeBuffer(byArray, byArray.length);
                iscDbHandle.out.writeInt(1024);
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
                if (this.dbai.getNegotiatedProtocol() > 11) {
                    iscStmtHandle.setStmtType(response.resp_object);
                }
                iscStmtHandle.out_sqlda = this.parseSqlInfo(iscStmtHandle, response.resp_data, byArray, iBException);
                return iscStmtHandle.out_sqlda;
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscDsqlSetCursorName(IscStmtHandle iscStmtHandle, String string, int n, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle = iscStmtHandle.iscDbHandle;
        if (iscStmtHandle == null) {
            throw new IBException(335544327L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(69);
                iscDbHandle.out.writeInt(iscStmtHandle.rsr_id);
                byte[] byArray = new byte[string.length() + 1];
                System.arraycopy(string.getBytes(), 0, byArray, 0, string.length());
                byArray[string.length()] = 0;
                iscDbHandle.out.writeBuffer(byArray, byArray.length);
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    byte[] iscDsqlSqlInfo(IscStmtHandle iscStmtHandle, int n, byte[] byArray, int n2, IBException iBException) throws SQLException, IBException {
        IscDbHandle iscDbHandle;
        IscDbHandle iscDbHandle2 = iscDbHandle = iscStmtHandle.iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(70);
                iscDbHandle.out.writeInt(iscStmtHandle.rsr_id);
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.writeBuffer(byArray, n);
                iscDbHandle.out.writeInt(n2);
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
                return response.resp_data;
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    private IscDbHandle makePartner() throws IOException, SQLException, IBException {
        IscDbHandle iscDbHandle = new IscDbHandle();
        this.connect_partner(iscDbHandle, this.dbai);
        iscDbHandle.out = new XdrOutputStream(new BufferedOutputStream(iscDbHandle.socket.getOutputStream()));
        iscDbHandle.in = new XdrInputStream(new BufferedInputStream(iscDbHandle.socket.getInputStream()));
        iscDbHandle.out.writeInt(54);
        iscDbHandle.out.writeInt(2);
        iscDbHandle.out.writeInt(0);
        iscDbHandle.out.writeInt((int)this.dbai.getPartnerPort());
        iscDbHandle.out.flush();
        return iscDbHandle;
    }

    static int iscVaxInteger(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (--n2 >= 0) {
            n4 += (byArray[n5++] & 0xFF) << n3;
            n3 += 8;
        }
        return n4;
    }

    static int iscReadInt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n + n2 - 1;
        while (--n2 >= 0) {
            n3 += (byArray[n5--] & 0xFF) << n4;
            n4 += 8;
        }
        return n3;
    }

    void iscCreateBlob2(IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, IscBlobHandle iscBlobHandle, IBStruct iBStruct, IBException iBException) throws IBException, SQLException {
        this.openOrCreateBlob(iscDbHandle, iscTrHandle, iscBlobHandle, iBStruct, iBStruct == null ? 34 : 57, iBException);
        iscBlobHandle.rbl_flags |= 8;
    }

    void iscOpenBlob2(IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, IscBlobHandle iscBlobHandle, IBStruct iBStruct, IBException iBException) throws IBException, SQLException {
        this.openOrCreateBlob(iscDbHandle, iscTrHandle, iscBlobHandle, iBStruct, iBStruct == null ? 35 : 56, iBException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openOrCreateBlob(IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, IscBlobHandle iscBlobHandle, IBStruct iBStruct, int n, IBException iBException) throws IBException, SQLException {
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        if (iscBlobHandle == null) {
            throw new IBException(335544328L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(n);
                if (iBStruct != null) {
                    iscDbHandle.out.writeTyped(1, iBStruct);
                }
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.writeLong(iscBlobHandle.blob_id);
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
                iscBlobHandle.db = iscDbHandle;
                iscBlobHandle.tr = iscTrHandle;
                iscBlobHandle.rbl_id = response.resp_object;
                iscBlobHandle.blob_id = response.resp_blob_id;
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    byte[] iscGetSegment(IscBlobHandle iscBlobHandle, int n, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle = iscBlobHandle.db;
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(36);
                iscDbHandle.out.writeInt(iscBlobHandle.rbl_id);
                iscDbHandle.out.writeInt(Math.min(n + 2, Short.MAX_VALUE));
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
                iscBlobHandle.rbl_flags &= 0xFFFFFFFD;
                if (response.resp_object == 1) {
                    iscBlobHandle.rbl_flags |= 2;
                } else if (response.resp_object == 2) {
                    iscBlobHandle.rbl_flags |= 4;
                }
                byte[] byArray = response.resp_data;
                if (byArray.length == 0) {
                    return byArray;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (n3 < byArray.length) {
                    n2 = Ibase.iscVaxInteger(byArray, n3, 2);
                    System.arraycopy(byArray, n3 += 2, byArray, n4, n2);
                    n3 += n2;
                    n4 += n2;
                }
                byte[] byArray2 = new byte[n4];
                System.arraycopy(byArray, 0, byArray2, 0, n4);
                return byArray2;
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void iscPutSegment(IscBlobHandle iscBlobHandle, byte[] byArray, IBException iBException) throws IBException, SQLException {
        IscBlobHandle iscBlobHandle2 = iscBlobHandle;
        IscDbHandle iscDbHandle = iscBlobHandle2.db;
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(44);
                iscDbHandle.out.writeInt(iscBlobHandle2.rbl_id);
                iscDbHandle.out.writeBlobBuffer(byArray);
                iscDbHandle.out.flush();
                Response response = this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    void iscCloseBlob(IscBlobHandle iscBlobHandle, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle = iscBlobHandle.db;
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        IscTrHandle iscTrHandle = iscBlobHandle.tr;
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        this.releaseObject(iscDbHandle, 39, iscBlobHandle.rbl_id, iBException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object IscGetSlice(int[] nArray, ArrayDescriptor arrayDescriptor, IscDbHandle iscDbHandle, IscTrHandle iscTrHandle) throws IBException, SQLException {
        Object var5_5 = null;
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        if (arrayDescriptor == null) {
            throw new IBException(0x14000004L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(36);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
        return var5_5;
    }

    void iscStartSavepoint(String string, IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, IBException iBException) throws IBException, SQLException {
        this.writeSavepoint(90, string, iscDbHandle, iscTrHandle, iBException);
    }

    void iscReleaseSavepoint(String string, IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, IBException iBException) throws IBException, SQLException {
        this.writeSavepoint(88, string, iscDbHandle, iscTrHandle, iBException);
    }

    void iscRollbackSavepoint(String string, IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, IBException iBException) throws IBException, SQLException {
        this.writeSavepoint(89, string, iscDbHandle, iscTrHandle, iBException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSavepoint(int n, String string, IscDbHandle iscDbHandle, IscTrHandle iscTrHandle, IBException iBException) throws IBException, SQLException {
        if (iscDbHandle == null) {
            throw new IBException(0x14000004L);
        }
        if (iscTrHandle == null) {
            throw new IBException(335544332L);
        }
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(n);
                iscDbHandle.out.writeInt(iscTrHandle.rtr_id);
                iscDbHandle.out.writeStringAndNull(string);
                iscDbHandle.out.writeInt(0);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    DbAttachInfo getDbai() {
        return this.dbai;
    }

    IscDbHandle getNewIscDbHandle(String string) {
        return new IscDbHandle(string);
    }

    IscTrHandle getNewIscTrHandle() {
        return new IscTrHandle();
    }

    IscStmtHandle getNewIscStmtHandle(int n, int n2) {
        return new IscStmtHandle(n, n2);
    }

    IscBlobHandle getNewIscBlobHandle() {
        return new IscBlobHandle();
    }

    private void connect_partner(IscDbHandle iscDbHandle, DbAttachInfo dbAttachInfo) throws SQLException {
        try {
            iscDbHandle.socket = new Socket(dbAttachInfo.getServer(), dbAttachInfo.getPort());
            iscDbHandle.socket.setTcpNoDelay(true);
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_connect_01__, dbAttachInfo.getServer(), Utils.getMessage(iOException));
        }
    }

    private void connect(IscDbHandle iscDbHandle, DbAttachInfo dbAttachInfo) throws IBException, IOException {
        boolean bl;
        do {
            this.sendIbConnect(iscDbHandle, dbAttachInfo);
            int n = this.readOperation(iscDbHandle);
            if (3 == n) {
                dbAttachInfo.setNegotiatedProtocol(iscDbHandle.in.readInt());
                dbAttachInfo.setNegotiatedArchitecture(iscDbHandle.in.readInt());
                iscDbHandle.in.readInt();
                bl = true;
                continue;
            }
            if (91 == n) {
                bl = false;
                dbAttachInfo.setPort(iscDbHandle.in.readInt());
                this.disconnect(iscDbHandle);
                continue;
            }
            this.disconnect(iscDbHandle);
            bl = true;
            throw new IBException(335544421L);
        } while (!bl);
    }

    private void sendIbConnect(IscDbHandle iscDbHandle, DbAttachInfo dbAttachInfo) throws IBException, IOException {
        try {
            iscDbHandle.socket = new Socket(dbAttachInfo.getServer(), dbAttachInfo.getPort());
        }
        catch (IOException iOException) {
            IBException iBException = new IBException(335544721L);
            iBException.setNext(new IBException(2, dbAttachInfo.getServer() + ":" + dbAttachInfo.getPort()));
            iBException.setNext(new IBException(2, iOException.toString()));
            iBException.setNextException(new java.sql.SQLException(iOException.toString()));
            throw iBException;
        }
        iscDbHandle.socket.setTcpNoDelay(true);
        if (dbAttachInfo.timeOut_ != 0) {
            iscDbHandle.socket.setSoTimeout(dbAttachInfo.timeOut_);
        }
        if (jdkVersion == null) {
            jdkVersion = System.getProperty("java.version");
        }
        if (!jdkVersion.startsWith("1.2") && !jdkVersion.startsWith("1.1")) {
            iscDbHandle.socket.setKeepAlive(true);
        }
        iscDbHandle.out = new XdrOutputStream(new BufferedOutputStream(iscDbHandle.socket.getOutputStream()));
        iscDbHandle.in = new XdrInputStream(new BufferedInputStream(iscDbHandle.socket.getInputStream()));
        String string = System.getProperty("user.name");
        String string2 = InetAddress.getLocalHost().getHostName();
        byte[] byArray = new byte[200];
        int n = 0;
        byArray[n++] = 1;
        byArray[n++] = (byte)string.length();
        System.arraycopy(string.getBytes(), 0, byArray, n, string.length());
        n += string.length();
        byArray[n++] = 4;
        byArray[n++] = (byte)string2.length();
        System.arraycopy(string2.getBytes(), 0, byArray, n, string2.length());
        n += string2.length();
        byArray[n++] = 6;
        byArray[n++] = 0;
        iscDbHandle.out.writeInt(1);
        iscDbHandle.out.writeInt(19);
        iscDbHandle.out.writeInt(2);
        iscDbHandle.out.writeInt(1);
        iscDbHandle.out.writeStringAndNull(dbAttachInfo.getFileNameSlash());
        iscDbHandle.out.writeInt(3);
        iscDbHandle.out.writeBuffer(byArray, n);
        iscDbHandle.out.writeInt(13);
        iscDbHandle.out.writeInt(1);
        iscDbHandle.out.writeInt(2);
        iscDbHandle.out.writeInt(3);
        iscDbHandle.out.writeInt(2);
        iscDbHandle.out.writeInt(14);
        iscDbHandle.out.writeInt(1);
        iscDbHandle.out.writeInt(2);
        iscDbHandle.out.writeInt(3);
        iscDbHandle.out.writeInt(3);
        iscDbHandle.out.writeInt(15);
        iscDbHandle.out.writeInt(1);
        iscDbHandle.out.writeInt(2);
        iscDbHandle.out.writeInt(3);
        iscDbHandle.out.writeInt(4);
        iscDbHandle.out.flush();
    }

    private void disconnect(IscDbHandle iscDbHandle) {
        if (iscDbHandle != null) {
            try {
                if (iscDbHandle.out != null) {
                    iscDbHandle.out.close();
                    iscDbHandle.out = null;
                }
                if (iscDbHandle.in != null) {
                    iscDbHandle.in.close();
                    iscDbHandle.in = null;
                }
                iscDbHandle.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Object[] receiveSqlResponse(IscDbHandle iscDbHandle, XSQLDA xSQLDA) throws IBException, SQLException {
        try {
            if (this.readOperation(iscDbHandle) == 78) {
                int n = iscDbHandle.in.readInt();
                if (n > 0) {
                    return this.readSQLData(iscDbHandle, xSQLDA);
                }
                return null;
            }
            throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__);
        }
        catch (IOException iOException) {
            throw new IBException(335544726L, iOException.toString());
        }
    }

    private Response receiveResponseAfterOp(IscDbHandle iscDbHandle, IBException iBException) throws IBException {
        try {
            Response response = new Response();
            response.resp_object = iscDbHandle.in.readInt();
            response.resp_blob_id = iscDbHandle.in.readLong();
            response.resp_data = iscDbHandle.in.readBuffer();
            this.readStatusVector(iscDbHandle, iBException);
            return response;
        }
        catch (IOException iOException) {
            throw new IBException(335544726L, iOException.toString());
        }
    }

    private Response receiveResponse(IscDbHandle iscDbHandle, IBException iBException) throws IBException {
        try {
            int n = this.readOperation(iscDbHandle);
            if (n == 9) {
                return this.receiveResponseAfterOp(iscDbHandle, iBException);
            }
            return null;
        }
        catch (IOException iOException) {
            throw new IBException(335544726L, iOException.toString());
        }
    }

    private int nextOperation(IscDbHandle iscDbHandle) throws IOException {
        do {
            iscDbHandle.op = iscDbHandle.in.readInt();
        } while (iscDbHandle.op == 71);
        return iscDbHandle.op;
    }

    private int readOperation(IscDbHandle iscDbHandle) throws IOException {
        int n = iscDbHandle.op >= 0 ? iscDbHandle.op : this.nextOperation(iscDbHandle);
        iscDbHandle.op = -1;
        return n;
    }

    private void readStatusVector(IscDbHandle iscDbHandle, IBException iBException) throws IBException {
        try {
            IBException iBException2 = null;
            IBException iBException3 = null;
            iBException = null;
            boolean bl = false;
            block6: while (true) {
                int n = iscDbHandle.in.readInt();
                switch (n) {
                    case 0: {
                        if (iBException2 != null) {
                            if (bl) {
                                throw iBException2;
                            }
                            iBException = iBException2;
                        }
                        return;
                    }
                    case 2: 
                    case 5: {
                        IBException iBException4 = new IBException(n, iscDbHandle.in.readString());
                        if (iBException2 == null) {
                            iBException2 = iBException4;
                            iBException3 = iBException4;
                            continue block6;
                        }
                        iBException3.setNext(iBException4);
                        iBException3 = iBException4;
                        continue block6;
                    }
                }
                int n2 = iscDbHandle.in.readInt();
                if (n2 == 0) continue;
                if (n == 1) {
                    bl = true;
                }
                IBException iBException5 = new IBException(n, n2);
                if (iBException2 == null) {
                    iBException2 = iBException5;
                    iBException3 = iBException5;
                    continue;
                }
                iBException3.setNext(iBException5);
                iBException3 = iBException5;
            }
        }
        catch (IOException iOException) {
            throw new IBException(335544721L, iOException.toString());
        }
    }

    private void writeBLRBatch(IscDbHandle iscDbHandle, int n, XSQLDA xSQLDA) throws IBException, SQLException {
        int n2 = 0;
        byte[] byArray = null;
        if (xSQLDA != null) {
            int n3;
            int n4;
            n2 = 8;
            int n5 = 0;
            int n6 = 0;
            for (n4 = 0; n4 < xSQLDA.sqld; ++n4) {
                n3 = xSQLDA.sqlvar[n4].sqltype & 0xFFFFFFFE;
                n6 = n3 == 448 || n3 == 452 ? (n6 += 3) : (n3 == 500 || n3 == 496 || n3 == 580 || n3 == 550 || n3 == 520 || n3 == 540 || n3 == 590 ? (n6 += 2) : ++n6);
                n6 += 2;
                n5 += 2;
            }
            n5 *= n;
            byArray = new byte[n2 += n * n6];
            n4 = 0;
            byArray[n4++] = 5;
            byArray[n4++] = 2;
            byArray[n4++] = 4;
            byArray[n4++] = 0;
            byArray[n4++] = (byte)(n5 & 0xFF);
            byArray[n4++] = (byte)(n5 >> 8);
            for (n3 = 0; n3 < n; ++n3) {
                for (int i = 0; i < xSQLDA.sqld; ++i) {
                    int n7 = xSQLDA.sqlvar[i].sqltype & 0xFFFFFFFE;
                    int n8 = xSQLDA.sqlvar[i].sqllen;
                    if (n7 == 448) {
                        byArray[n4++] = 37;
                        byArray[n4++] = (byte)(n8 & 0xFF);
                        byArray[n4++] = (byte)(n8 >> 8);
                    } else if (n7 == 452) {
                        byArray[n4++] = 14;
                        byArray[n4++] = (byte)(n8 & 0xFF);
                        byArray[n4++] = (byte)(n8 >> 8);
                    } else if (n7 == 480) {
                        byArray[n4++] = 27;
                    } else if (n7 == 482) {
                        byArray[n4++] = 10;
                    } else if (n7 == 530) {
                        byArray[n4++] = 11;
                    } else if (n7 == 570) {
                        byArray[n4++] = 12;
                    } else if (n7 == 560) {
                        byArray[n4++] = 13;
                    } else if (n7 == 510) {
                        byArray[n4++] = 35;
                    } else if (n7 == 520) {
                        byArray[n4++] = 9;
                        byArray[n4++] = 0;
                    } else if (n7 == 540) {
                        byArray[n4++] = 9;
                        byArray[n4++] = 0;
                    } else if (n7 == 496) {
                        byArray[n4++] = 8;
                        byArray[n4++] = (byte)xSQLDA.sqlvar[i].sqlscale;
                    } else if (n7 == 500) {
                        byArray[n4++] = 7;
                        byArray[n4++] = (byte)xSQLDA.sqlvar[i].sqlscale;
                    } else if (n7 == 590) {
                        byArray[n4++] = 17;
                        byArray[n4++] = (byte)xSQLDA.sqlvar[i].sqlscale;
                    } else if (n7 == 580) {
                        byArray[n4++] = 16;
                        byArray[n4++] = (byte)xSQLDA.sqlvar[i].sqlscale;
                    } else if (n7 == 550) {
                        byArray[n4++] = 9;
                        byArray[n4++] = (byte)xSQLDA.sqlvar[i].sqlscale;
                    } else {
                        throw new IBException(335544713L);
                    }
                    byArray[n4++] = 7;
                    byArray[n4++] = 0;
                }
            }
            byArray[n4++] = -1;
            byArray[n4++] = 76;
        }
        try {
            iscDbHandle.out.writeBuffer(byArray, n2);
        }
        catch (IOException iOException) {
            throw new IBException(335544727L);
        }
    }

    private boolean isSQLDataOK(XSQLDA xSQLDA) {
        if (xSQLDA != null) {
            for (int i = 0; i < xSQLDA.sqld; ++i) {
                if (xSQLDA.sqlvar[i].sqlind == -1 || xSQLDA.sqlvar[i].sqldata != null) continue;
                return false;
            }
        }
        return true;
    }

    private void writeSQLBatchData(IscStmtHandle iscStmtHandle, ArrayList arrayList) throws IBException, SQLException {
        XSQLDA xSQLDA = iscStmtHandle.getInSqlda();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object[] objectArray = (Object[])arrayList.get(i);
            this.setInputParameters(objectArray, objectArray.length, xSQLDA);
            for (int j = 0; j < xSQLDA.sqld; ++j) {
                this.writeSQLDatum(iscStmtHandle.iscDbHandle, xSQLDA.sqlvar[j]);
            }
        }
    }

    private void writeSQLData(IscDbHandle iscDbHandle, XSQLDA xSQLDA) throws IBException, SQLException {
        for (int i = 0; i < xSQLDA.sqld; ++i) {
            this.writeSQLDatum(iscDbHandle, xSQLDA.sqlvar[i]);
        }
    }

    private void writeSQLDatum(IscDbHandle iscDbHandle, XSQLVAR xSQLVAR) throws IBException, SQLException {
        this.fixNull(xSQLVAR);
        try {
            Object object = xSQLVAR.sqldata;
            switch (xSQLVAR.sqltype & 0xFFFFFFFE) {
                case 452: {
                    String string = this.getCharSetToUse(iscDbHandle.charSetToUse_, xSQLVAR);
                    byte[] byArray = object instanceof String ? this.fillString((String)object, xSQLVAR.sqllen, string) : this.fillString(object.toString(), xSQLVAR.sqllen, string);
                    iscDbHandle.out.writeOpaque(byArray, byArray.length);
                    break;
                }
                case 448: {
                    byte[] byArray;
                    String string = this.getCharSetToUse(iscDbHandle.charSetToUse_, xSQLVAR);
                    byte[] byArray2 = ((String)object).getBytes(string);
                    int n = Math.min(byArray2.length, xSQLVAR.sqllen);
                    iscDbHandle.out.writeInt(n);
                    if (n < byArray2.length) {
                        byArray = new byte[n];
                        for (int i = 0; i < n; ++i) {
                            byArray[i] = byArray2[i];
                        }
                    } else {
                        byArray = byArray2;
                    }
                    iscDbHandle.out.writeOpaque(byArray, byArray.length);
                    break;
                }
                case 500: {
                    iscDbHandle.out.writeInt(((Short)object).shortValue());
                    break;
                }
                case 590: {
                    iscDbHandle.out.writeInt(((Short)object).shortValue());
                    break;
                }
                case 496: {
                    iscDbHandle.out.writeInt((Integer)object);
                    break;
                }
                case 482: {
                    iscDbHandle.out.writeFloat(((Float)object).floatValue());
                    break;
                }
                case 480: {
                    iscDbHandle.out.writeDouble((Double)object);
                    break;
                }
                case 510: {
                    if (object instanceof IBTimestamp) {
                        iscDbHandle.out.writeInt(((IBTimestamp)object).getEncodedYearMonthDay());
                        iscDbHandle.out.writeInt(((IBTimestamp)object).getEncodedHourMinuteSecond());
                        break;
                    }
                    iscDbHandle.out.writeInt(this.encodeDate((Timestamp)object));
                    iscDbHandle.out.writeInt(this.encodeTime((Timestamp)object));
                    break;
                }
                case 520: {
                    iscDbHandle.out.writeLong((Long)object);
                    break;
                }
                case 540: {
                    iscDbHandle.out.writeLong((Long)object);
                    break;
                }
                case 550: {
                    iscDbHandle.out.writeLong((Long)object);
                    break;
                }
                case 560: {
                    IBTimestamp iBTimestamp = new IBTimestamp();
                    if (object.getClass().isInstance(iBTimestamp)) {
                        iscDbHandle.out.writeInt(((IBTimestamp)object).getEncodedHourMinuteSecond());
                        break;
                    }
                    iscDbHandle.out.writeInt(this.encodeTime((Time)object));
                    break;
                }
                case 570: {
                    IBTimestamp iBTimestamp = new IBTimestamp();
                    if (object.getClass().isInstance(iBTimestamp)) {
                        iscDbHandle.out.writeInt(((IBTimestamp)object).getEncodedYearMonthDay());
                        break;
                    }
                    iscDbHandle.out.writeInt(this.encodeDate((Date)object));
                    break;
                }
                case 580: {
                    iscDbHandle.out.writeLong((Long)object);
                    break;
                }
                default: {
                    System.out.println("Unknown sql data type: " + xSQLVAR.sqltype);
                }
            }
            iscDbHandle.out.writeInt(xSQLVAR.sqlind);
        }
        catch (IOException iOException) {
            throw new IBException(335544727L);
        }
    }

    private String getCharSetToUse(String string, XSQLVAR xSQLVAR) {
        String string2 = string;
        if (string2 != null) {
            return string2;
        }
        string2 = CharacterEncodings.getCharacterSetName(xSQLVAR.sqlsubtype % 128);
        if (string2 != null) {
            return string2;
        }
        return "8859_1";
    }

    private void fixNull(XSQLVAR xSQLVAR) {
        if (xSQLVAR.sqlind == -1 && xSQLVAR.sqldata == null) {
            switch (xSQLVAR.sqltype & 0xFFFFFFFE) {
                case 452: {
                    xSQLVAR.sqldata = new byte[xSQLVAR.sqllen];
                    break;
                }
                case 448: {
                    byte[] byArray = new byte[]{};
                    xSQLVAR.sqldata = new String(byArray);
                    break;
                }
                case 500: 
                case 590: {
                    xSQLVAR.sqldata = new Short(0);
                    break;
                }
                case 496: {
                    xSQLVAR.sqldata = new Integer(0);
                    break;
                }
                case 482: {
                    xSQLVAR.sqldata = new Float(0.0f);
                    break;
                }
                case 480: {
                    xSQLVAR.sqldata = new Double(0.0);
                    break;
                }
                case 510: {
                    xSQLVAR.sqldata = new Timestamp(0L);
                    break;
                }
                case 520: 
                case 540: 
                case 550: 
                case 580: {
                    xSQLVAR.sqldata = new Long(0L);
                    break;
                }
                case 560: {
                    xSQLVAR.sqldata = new Time(0L);
                    break;
                }
                case 570: {
                    xSQLVAR.sqldata = new Date(0L);
                    break;
                }
                default: {
                    System.out.println("Unknown sql data type: " + xSQLVAR.sqltype);
                }
            }
        }
    }

    private byte[] fillString(String string, int n, String string2) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        if (byArray.length < n) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.ensureCapacity(n);
            stringBuffer.append(string);
            for (int i = 0; i < n - byArray.length; ++i) {
                stringBuffer.append(' ');
            }
            byArray = stringBuffer.toString().getBytes(string2);
        } else if (byArray.length > n) {
            byte[] byArray2 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray2[i] = byArray[i];
            }
            return byArray2;
        }
        return byArray;
    }

    private int encodeTime(java.util.Date date) {
        IBTimestamp iBTimestamp = new IBTimestamp(date);
        return iBTimestamp.getEncodedHourMinuteSecond();
    }

    private int encodeDate(java.util.Date date) {
        IBTimestamp iBTimestamp = new IBTimestamp(date);
        return iBTimestamp.getEncodedYearMonthDay();
    }

    void setInputParameters(Object[] objectArray, int n, XSQLDA xSQLDA) throws SQLException {
        if (n != xSQLDA.sqld) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] instanceof Array) {
                Array array = (Array)objectArray[i];
                array.putArraySlice();
                xSQLDA.sqlvar[i].sqldata = new Long(array.id_);
            } else {
                xSQLDA.sqlvar[i].sqldata = objectArray[i];
            }
            if (objectArray[i] != null) continue;
            xSQLDA.sqlvar[i].sqlind = -1;
        }
    }

    private Object[] readSQLData(IscDbHandle iscDbHandle, XSQLDA xSQLDA) throws IBException, SQLException {
        Object[] objectArray = new Object[xSQLDA.sqld];
        for (int i = 0; i < xSQLDA.sqld; ++i) {
            objectArray[i] = this.readSQLDatum(iscDbHandle, xSQLDA.sqlvar[i]);
        }
        return objectArray;
    }

    private Object readSQLDatum(IscDbHandle iscDbHandle, XSQLVAR xSQLVAR) throws IBException, SQLException {
        try {
            Object object;
            switch (xSQLVAR.sqltype & 0xFFFFFFFE) {
                case 452: {
                    xSQLVAR.sqldata = iscDbHandle.in.readOpaque(xSQLVAR.sqllen);
                    break;
                }
                case 448: {
                    xSQLVAR.sqldata = iscDbHandle.in.readOpaque(iscDbHandle.in.readInt());
                    break;
                }
                case 500: 
                case 590: {
                    xSQLVAR.sqldata = new Short((short)iscDbHandle.in.readInt());
                    break;
                }
                case 496: {
                    xSQLVAR.sqldata = new Integer(iscDbHandle.in.readInt());
                    break;
                }
                case 482: {
                    xSQLVAR.sqldata = new Float(iscDbHandle.in.readFloat());
                    break;
                }
                case 480: {
                    xSQLVAR.sqldata = new Double(iscDbHandle.in.readDouble());
                    break;
                }
                case 510: {
                    object = new int[]{iscDbHandle.in.readInt(), iscDbHandle.in.readInt()};
                    IBTimestamp iBTimestamp = new IBTimestamp(2, (int[])object);
                    xSQLVAR.sqldata = new Timestamp(iBTimestamp.getTimeInMillis());
                    ((Timestamp)xSQLVAR.sqldata).setNanos(iBTimestamp.getNanos());
                    break;
                }
                case 520: {
                    xSQLVAR.sqldata = new Long(iscDbHandle.in.readLong());
                    break;
                }
                case 540: {
                    xSQLVAR.sqldata = new Long(iscDbHandle.in.readLong());
                    break;
                }
                case 550: {
                    xSQLVAR.sqldata = new Long(iscDbHandle.in.readLong());
                    break;
                }
                case 560: {
                    xSQLVAR.sqldata = this.decodeTime(iscDbHandle.in.readInt());
                    break;
                }
                case 570: {
                    xSQLVAR.sqldata = this.decodeDate(iscDbHandle.in.readInt());
                    break;
                }
                case 580: {
                    xSQLVAR.sqldata = new Long(iscDbHandle.in.readLong());
                }
            }
            xSQLVAR.sqlind = iscDbHandle.in.readInt();
            if (xSQLVAR.sqlind == 0) {
                return xSQLVAR.sqldata;
            }
            if (xSQLVAR.sqlind == -1) {
                return null;
            }
            object = new IBException(225544005);
            object.setNext(new IBException(4, xSQLVAR.sqlind));
            throw object;
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    private Time decodeTime(int n) {
        IBTimestamp iBTimestamp = null;
        iBTimestamp = new IBTimestamp(1, n);
        return new Time(iBTimestamp.getJustTime());
    }

    private Date decodeDate(int n) {
        IBTimestamp iBTimestamp = null;
        iBTimestamp = new IBTimestamp(0, n);
        return new Date(iBTimestamp.getJustDate());
    }

    private XSQLDA parseSqlInfo(IscStmtHandle iscStmtHandle, byte[] byArray, byte[] byArray2, IBException iBException) throws IBException, SQLException {
        XSQLDA xSQLDA = new XSQLDA();
        int n = 0;
        while ((n = this.parseTruncSqlInfo(byArray, xSQLDA, n)) > 0) {
            byte[] byArray3 = new byte[4 + byArray2.length];
            byArray3[0] = 20;
            byArray3[1] = 2;
            byArray3[2] = (byte)(--n & 0xFF);
            byArray3[3] = (byte)(n >> 8);
            System.arraycopy(byArray2, 0, byArray3, 4, byArray2.length);
            byArray = this.iscDsqlSqlInfo(iscStmtHandle, byArray3.length, byArray3, byArray.length, iBException);
        }
        return xSQLDA;
    }

    private int parseTruncSqlInfo(byte[] byArray, XSQLDA xSQLDA, int n) throws IBException {
        int n2 = 0;
        int n3 = Ibase.iscVaxInteger(byArray, 2, 2);
        int n4 = Ibase.iscVaxInteger(byArray, 4, n3);
        int n5 = 4 + n3;
        if (xSQLDA.sqlvar == null) {
            xSQLDA.sqld = xSQLDA.sqln = n4;
            xSQLDA.sqlvar = new XSQLVAR[xSQLDA.sqln];
        }
        while (byArray[n5] != 1) {
            byte by;
            block14: while ((by = byArray[n5++]) != 8) {
                switch (by) {
                    case 9: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        n2 = Ibase.iscVaxInteger(byArray, n5 += 2, n3);
                        n5 += n3;
                        xSQLDA.sqlvar[n2 - 1] = new XSQLVAR();
                        continue block14;
                    }
                    case 11: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        xSQLDA.sqlvar[n2 - 1].sqltype = Ibase.iscVaxInteger(byArray, n5 += 2, n3);
                        n5 += n3;
                        continue block14;
                    }
                    case 12: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        xSQLDA.sqlvar[n2 - 1].sqlsubtype = Ibase.iscVaxInteger(byArray, n5 += 2, n3);
                        n5 += n3;
                        continue block14;
                    }
                    case 13: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        xSQLDA.sqlvar[n2 - 1].sqlscale = Ibase.iscVaxInteger(byArray, n5 += 2, n3);
                        n5 += n3;
                        continue block14;
                    }
                    case 14: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        xSQLDA.sqlvar[n2 - 1].sqllen = Ibase.iscVaxInteger(byArray, n5 += 2, n3);
                        n5 += n3;
                        continue block14;
                    }
                    case 16: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        xSQLDA.sqlvar[n2 - 1].sqlname = new String(byArray, n5 += 2, n3);
                        n5 += n3;
                        continue block14;
                    }
                    case 17: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        xSQLDA.sqlvar[n2 - 1].relname = new String(byArray, n5 += 2, n3);
                        n5 += n3;
                        continue block14;
                    }
                    case 18: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        xSQLDA.sqlvar[n2 - 1].ownname = new String(byArray, n5 += 2, n3);
                        n5 += n3;
                        continue block14;
                    }
                    case 19: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        xSQLDA.sqlvar[n2 - 1].aliasname = new String(byArray, n5 += 2, n3);
                        n5 += n3;
                        continue block14;
                    }
                    case 25: {
                        n3 = Ibase.iscVaxInteger(byArray, n5, 2);
                        xSQLDA.sqlvar[n2 - 1].sqlPrecision = Ibase.iscVaxInteger(byArray, n5 += 2, n3);
                        n5 += n3;
                        continue block14;
                    }
                    case 2: {
                        return n;
                    }
                }
                throw new IBException(335544583L);
            }
            n = n2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseObject(IscDbHandle iscDbHandle, int n, int n2, IBException iBException) throws IBException, SQLException {
        IscDbHandle iscDbHandle2 = iscDbHandle;
        synchronized (iscDbHandle2) {
            try {
                iscDbHandle.out.writeInt(n);
                iscDbHandle.out.writeInt(n2);
                iscDbHandle.out.flush();
                this.receiveResponse(iscDbHandle, iBException);
            }
            catch (IOException iOException) {
                throw new CommunicationException(ErrorKey.communication__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
            }
        }
    }

    static IBStruct newStructlet(int n, String string) {
        return new IBStruct(n, string.getBytes());
    }

    static IBStruct newStructlet(int n) {
        return new IBStruct(n, new byte[0]);
    }

    static IBStruct newStructlet(int n, int n2) {
        return new IBStruct(n, new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24)});
    }

    static IBStruct newStructlet(int n, byte[] byArray) {
        return new IBStruct(n, byArray);
    }

    static IBStruct cloneStructlet(IBStruct iBStruct) {
        if (iBStruct == null) {
            return null;
        }
        return new IBStruct(iBStruct);
    }

    private static class Response {
        int resp_object;
        long resp_blob_id;
        byte[] resp_data;

        private Response() {
        }
    }

    static class DbAttachInfo {
        private String server;
        private int port = 3050;
        private String fileName;
        private String fileNameSlash;
        private int timeOut_;
        private long partnerPort = 0L;
        private int negotiatedProtocol;
        private int negotiatedArchitecture;

        DbAttachInfo(String string) throws java.sql.SQLException {
            if (string == null) {
                IBException iBException = new IBException(225544007);
                throw iBException.getSQLExceptionFromIBE();
            }
            int n = (string = string.trim()).indexOf(58);
            if (n == 0 || n == string.length() - 1) {
                IBException iBException = new IBException(335544323L);
                iBException.setNext(new IBException(2, string));
                throw iBException.getSQLExceptionFromIBE();
            }
            if (n > 0) {
                this.server = string.substring(0, n);
                this.fileName = string.substring(n + 1);
                n = this.server.indexOf(47);
                if (n == 0 || n == this.server.length() - 1) {
                    IBException iBException = new IBException(335544323L);
                    iBException.setNext(new IBException(2, this.server));
                    throw iBException.getSQLExceptionFromIBE();
                }
                if (n > 0) {
                    this.port = Integer.parseInt(this.server.substring(n + 1));
                    this.server = this.server.substring(0, n);
                }
            }
        }

        DbAttachInfo(String string, int n, String string2, int n2) {
            this.server = string;
            this.port = n;
            this.fileName = string2;
            this.fileNameSlash = this.fileName.replace('\\', '/');
            this.timeOut_ = n2;
        }

        String getServer() {
            return this.server;
        }

        int getPort() {
            return this.port;
        }

        void setPort(int n) {
            this.port = n;
        }

        String getFileName() {
            return this.fileName;
        }

        String getFileNameSlash() {
            return this.fileNameSlash;
        }

        long getPartnerPort() {
            return this.partnerPort;
        }

        void setPartnerPort(long l) {
            this.partnerPort = l;
        }

        void setNegotiatedProtocol(int n) {
            this.negotiatedProtocol = n;
        }

        int getNegotiatedProtocol() {
            return this.negotiatedProtocol;
        }

        void setNegotiatedArchitecture(int n) {
            this.negotiatedArchitecture = n;
        }

        int getNegotiatedArchitecture() {
            return this.negotiatedArchitecture;
        }
    }
}

