/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.IBTypes;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.ParameterIndexOutOfBoundsException;
import interbase.interclient.PreparedStatement;
import java.sql.SQLException;

public final class ParameterMetaData {
    PreparedStatement preparedStatement_;

    ParameterMetaData(PreparedStatement preparedStatement) {
        this.preparedStatement_ = preparedStatement;
    }

    public int getParameterCount() throws SQLException {
        return this.preparedStatement_.inputCols_;
    }

    public int getParameterType(int n) throws SQLException {
        try {
            return IBTypes.getSQLType(this.preparedStatement_.inputTypes_[n - 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    public String getParameterTypeName(int n) throws SQLException {
        try {
            return IBTypes.getIBTypeName(this.preparedStatement_.inputTypes_[n - 1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    public int getPrecision(int n) throws SQLException {
        try {
            switch (this.preparedStatement_.inputTypes_[n - 1]) {
                case 8: 
                case 9: 
                case 20: {
                    return this.preparedStatement_.inputCharLengths_[n - 1];
                }
                case 14: {
                    if (this.preparedStatement_.arrayDescriptors_[n - 1] != null) {
                        return this.preparedStatement_.arrayDescriptors_[n - 1].elementPrecision_;
                    }
                    throw new DriverNotCapableException(ErrorKey.driverNotCapable__input_array_metadata__);
                }
            }
            return this.preparedStatement_.inputPrecisions_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    public int getScale(int n) throws SQLException {
        try {
            switch (this.preparedStatement_.inputTypes_[n - 1]) {
                case 8: 
                case 9: 
                case 20: {
                    return 0;
                }
                case 14: {
                    if (this.preparedStatement_.arrayDescriptors_[n - 1] != null) {
                        return this.preparedStatement_.arrayDescriptors_[n - 1].elementScale_;
                    }
                    throw new DriverNotCapableException(ErrorKey.driverNotCapable__input_array_metadata__);
                }
            }
            return this.preparedStatement_.inputScales_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    public int isNullable(int n) throws SQLException {
        try {
            if (this.preparedStatement_.inputNullables_[n - 1]) {
                return 1;
            }
            return 0;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    public int getArrayBaseType(int n) throws SQLException {
        try {
            if (this.preparedStatement_.inputTypes_[n - 1] != 14) {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__not_array_parameter__);
            }
            if (this.preparedStatement_.arrayDescriptors_[n - 1] != null) {
                return IBTypes.getSQLType(this.preparedStatement_.arrayDescriptors_[n - 1].elementDataType_);
            }
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__input_array_metadata__);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    public int[][] getArrayDimensions(int n) throws SQLException {
        try {
            if (this.preparedStatement_.inputTypes_[n - 1] != 14) {
                throw new InvalidArgumentException(ErrorKey.invalidArgument__not_array_parameter__);
            }
            if (this.preparedStatement_.arrayDescriptors_[n - 1] != null) {
                return this.preparedStatement_.arrayDescriptors_[n - 1].getDimensions();
            }
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__input_array_metadata__);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }
}

