/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.Connection;
import interbase.interclient.DataSourceProperties;
import interbase.interclient.SQLException;
import java.io.PrintWriter;
import java.sql.DriverManager;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;

public class PooledConnection
implements javax.sql.PooledConnection,
XAConnection {
    private transient ConnectionEventListener[] listeners;
    private transient PrintWriter logWriter;
    private transient boolean closing;
    private transient ConnectionEvent event;
    private transient java.sql.Connection physCon;
    private transient Connection bCon;
    private transient Connection delegateCon;
    private transient DataSourceProperties props;
    private transient int maxStatements;

    PooledConnection() {
    }

    PooledConnection(java.sql.Connection connection, DataSourceProperties dataSourceProperties) {
        this.props = dataSourceProperties;
        this.physCon = connection;
        if (connection instanceof Connection) {
            this.bCon = (Connection)connection;
        }
        this.event = new ConnectionEvent(this);
        this.logWriter = dataSourceProperties.logWriter_;
    }

    public synchronized java.sql.Connection getConnection() throws java.sql.SQLException {
        if (this.logWriter != null || DriverManager.getLogWriter() != null) {
            this.println("PooledConnection.getConnection()", this);
        }
        return this.physCon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws java.sql.SQLException {
        if (!this.closing) {
            try {
                this.closing = true;
                if (this.physCon != null) {
                    this.physCon.close();
                }
                this.physCon = null;
                this.delegateCon = null;
                this.listeners = null;
            }
            finally {
                this.closing = false;
            }
        }
    }

    final synchronized void returnToPool() throws SQLException {
        ConnectionEventListener[] connectionEventListenerArray = this.listeners;
        for (int i = 0; i < connectionEventListenerArray.length; ++i) {
            ConnectionEventListener connectionEventListener = connectionEventListenerArray[i];
            if (connectionEventListener == null) continue;
            connectionEventListener.connectionClosed(this.event);
        }
        this.delegateCon = null;
    }

    public synchronized void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.addListener(connectionEventListener);
    }

    public synchronized void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.listeners != null) {
            this.removeListener(connectionEventListener);
        }
    }

    public XAResource getXAResource() throws java.sql.SQLException {
        this.getConnection();
        if (this.logWriter != null || DriverManager.getLogWriter() != null) {
            this.println("PooledConnection.getXAResource()", this);
        }
        return null;
    }

    private final void addListener(ConnectionEventListener connectionEventListener) {
        if (this.listeners == null) {
            this.listeners = new ConnectionEventListener[1];
            this.listeners[0] = connectionEventListener;
        } else {
            int n;
            for (n = 0; n < this.listeners.length; ++n) {
                if (this.listeners[n] != null) continue;
                this.listeners[n] = connectionEventListener;
                return;
            }
            n = this.listeners.length;
            ConnectionEventListener[] connectionEventListenerArray = new ConnectionEventListener[n + 1];
            System.arraycopy(this.listeners, 0, connectionEventListenerArray, 0, n);
            connectionEventListenerArray[n] = connectionEventListener;
            this.listeners = connectionEventListenerArray;
        }
    }

    private final void removeListener(ConnectionEventListener connectionEventListener) {
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] != connectionEventListener) continue;
            this.listeners[i] = null;
            return;
        }
    }

    final void println(String string, Object object) {
        if (this.logWriter != null) {
            this.logWriter.println("  \"  :" + string + " [" + object + "]");
            this.logWriter.flush();
        }
        DriverManager.println("  \"  :" + string + " [" + object + "]");
    }
}

