/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.ArrayDescriptor;
import interbase.interclient.BlobInput;
import interbase.interclient.BugCheckException;
import interbase.interclient.CommunicationException;
import interbase.interclient.Connection;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.EscapeProcessor;
import interbase.interclient.Globals;
import interbase.interclient.IBException;
import interbase.interclient.IBParameterMetaData;
import interbase.interclient.IBTimestamp;
import interbase.interclient.IBTypes;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.IscTrHandle;
import interbase.interclient.ParameterConversionException;
import interbase.interclient.ParameterIndexOutOfBoundsException;
import interbase.interclient.ParameterMetaData;
import interbase.interclient.ResultSet;
import interbase.interclient.Statement;
import interbase.interclient.Utils;
import interbase.interclient.XSQLDA;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    String sql_;
    private boolean isEscapedProcedureCall_ = false;
    int inputCols_;
    boolean[] inputNullables_;
    int[] inputTypes_;
    int[] inputPrecisions_;
    int[] inputScales_;
    int[] inputCharSets_;
    int[] inputCharLengths_;
    ArrayDescriptor[] arrayDescriptors_;
    char[] cbuf_;
    byte[] encodingBuf_;
    java.sql.ParameterMetaData parameterMetaData_ = null;
    ParameterMetaData ibParameterMetaData = null;
    Object[] inputs_;
    private static final BigDecimal bdMaxShortValue = new BigDecimal(32767.0);
    private static final BigDecimal bdMinShortValue = new BigDecimal(-32768.0);
    private static final BigDecimal bdMaxIntValue = new BigDecimal(2.147483647E9);
    private static final BigDecimal bdMinIntValue = new BigDecimal(-2.147483648E9);
    private static final BigDecimal bdMaxFloatValue = new BigDecimal(3.4028234663852886E38);
    private static final BigDecimal bdMinFloatValue = new BigDecimal(-3.4028234663852886E38);
    private static final BigDecimal bdMaxDoubleValue = new BigDecimal(Double.MAX_VALUE);
    private static final BigDecimal bdMinDoubleValue = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal bdMaxLongValue = new BigDecimal(9.223372036854776E18);
    private static final BigDecimal bdMinLongValue = new BigDecimal(-9.223372036854776E18);
    static final String selectPrepend = "Select * from ";
    static final String executePrepend = "Execute Procedure ";
    private ArrayList batchInputs_ = null;

    void local_Close() throws SQLException {
        if (this.resultSet_ != null) {
            this.resultSet_.local_Close();
        }
        this.resultSet_ = null;
        this.resultSetStack_ = null;
        this.openOnClient_ = false;
        this.openOnServer_ = false;
        this.connection_.openPreparedStatements_.removeElement(this);
        this.arrayDescriptors_ = null;
        this.batchInputs_ = null;
        Globals.cache__.returnBuffer(this.encodingBuf_);
        Globals.cache__.returnCharBuffer(this.cbuf_);
        this.inputCharLengths_ = null;
        this.inputCharSets_ = null;
        this.inputNullables_ = null;
        this.inputPrecisions_ = null;
        this.inputTypes_ = null;
        this.inputScales_ = null;
        this.inputPrecisions_ = null;
        this.inputs_ = null;
    }

    PreparedStatement(Connection connection, String string, int n) throws SQLException {
        super(connection);
        this.checkForEmptySQL(string);
        if (this.escapeProcessingEnabled_) {
            EscapeProcessor escapeProcessor = new EscapeProcessor();
            this.sql_ = escapeProcessor.doEscapeProcessing(string, n);
            this.isEscapedProcedureCall_ = escapeProcessor.isEscapedProcedureCall();
        } else {
            this.sql_ = string;
        }
        this.remote_PREPARE_STATEMENT();
        this.inputs_ = new Object[this.inputCols_];
    }

    void setInputMetaData(XSQLDA xSQLDA, int n) throws SQLException {
        for (int i = 0; i < n; ++i) {
            this.inputNullables_[i] = (xSQLDA.sqlvar[i].sqltype & 1) == 1;
            this.inputTypes_[i] = IBTypes.getResultTypes(xSQLDA.sqlvar[i].sqltype, xSQLDA.sqlvar[i]);
            this.inputScales_[i] = Math.abs(xSQLDA.sqlvar[i].sqlscale);
            this.inputCharSets_[i] = xSQLDA.sqlvar[i].sqlsubtype % 128;
            this.inputCharLengths_[i] = IBTypes.getCharacterLength(xSQLDA.sqlvar[i]);
            if (this.inputTypes_[i] != 14) continue;
            this.arrayDescriptors_[i] = new ArrayDescriptor(this.connection_, xSQLDA.sqlvar[i].relname, xSQLDA.sqlvar[i].sqlname);
        }
    }

    private void remote_PREPARE_STATEMENT() throws SQLException {
        XSQLDA xSQLDA = null;
        try {
            IscTrHandle iscTrHandle;
            super.allocateStatement();
            if (super.isDdlStatement(this.sql_)) {
                this.connection_.setDdlTransaction();
                iscTrHandle = this.connection_.traDdl_;
            } else {
                this.connection_.setTransaction();
                iscTrHandle = this.connection_.tra_;
            }
            this.sqlWarningsCleared_ = false;
            if (!this.isEscapedProcedureCall_) {
                xSQLDA = this.connection_.ibase_.iscDsqlPrepare(iscTrHandle, this.stmtHandle_, this.sql_, this.connection_.getAttachmentSQLDialect(), this.sqlWarnings_);
            } else {
                try {
                    xSQLDA = this.connection_.ibase_.iscDsqlPrepare(iscTrHandle, this.stmtHandle_, selectPrepend + this.sql_, this.connection_.getAttachmentSQLDialect(), this.sqlWarnings_);
                }
                catch (IBException iBException) {
                    if ((long)iBException.getIntParam() == 335544569L) {
                        xSQLDA = this.connection_.ibase_.iscDsqlPrepare(iscTrHandle, this.stmtHandle_, executePrepend + this.sql_, this.connection_.getAttachmentSQLDialect(), this.sqlWarnings_);
                    }
                    throw new SQLException(iBException.getMessage());
                }
            }
            this.resultSet_ = new ResultSet(this, false, this.stmtHandle_.getOutSqlda().sqld, this.stmtHandle_.getOutSqlda(), this.resultSetType_);
            this.sqlWarningsCleared_ = false;
            this.connection_.ibase_.iscDsqlDescribeBind(this.stmtHandle_, this.sqlWarnings_);
            this.inputCols_ = this.stmtHandle_.in_sqlda.sqld;
            this.inputNullables_ = new boolean[this.inputCols_];
            this.inputTypes_ = new int[this.inputCols_];
            this.inputPrecisions_ = new int[this.inputCols_];
            this.inputScales_ = new int[this.inputCols_];
            this.inputCharSets_ = new int[this.inputCols_];
            this.inputCharLengths_ = new int[this.inputCols_];
            this.arrayDescriptors_ = new ArrayDescriptor[this.inputCols_];
            this.setInputMetaData(this.stmtHandle_.in_sqlda, this.inputCols_);
            this.allocateEncodingBufs();
        }
        catch (IBException iBException) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
                this.resultSet_ = null;
                this.resultSetStack_ = null;
            }
            throw new SQLException(iBException.getMessage());
        }
        catch (SQLException sQLException) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
                this.resultSet_ = null;
                this.resultSetStack_ = null;
            }
            throw sQLException;
        }
    }

    synchronized void allocateEncodingBufs() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.inputCols_; ++i) {
            if (this.inputPrecisions_[i] > n) {
                n = this.inputPrecisions_[i];
            }
            if (this.inputCharLengths_[i] <= n2) continue;
            n2 = this.inputCharLengths_[i];
        }
        this.encodingBuf_ = Globals.cache__.takeBuffer(n + 1);
        this.cbuf_ = Globals.cache__.takeCharBuffer(n2);
    }

    public synchronized java.sql.ResultSet executeQuery() throws SQLException {
        this.println("executeQuery:", this);
        this.checkForClosedStatement();
        this.clearWarnings();
        if (this.stmtHandle_.getOutSqlda().sqld <= 0) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__execute_query_on_an_update_statement__);
        }
        if (this.resultSet_ != null) {
            this.resultSet_.close();
            this.resultSet_ = null;
            this.resultSetStack_ = null;
        }
        this.updateCountStack_ = null;
        this.remote_EXECUTE_PREPARED_QUERY_STATEMENT();
        this.resultSetStack_ = this.resultSet_;
        return this.resultSet_;
    }

    private void remote_EXECUTE_PREPARED_QUERY_STATEMENT() throws SQLException {
        this.connection_.ibase_.setInputParameters(this.inputs_, this.inputCols_, this.stmtHandle_.getInSqlda());
        this.remote_EXECUTE_QUERY_STATEMENT(null, true);
    }

    public synchronized int executeUpdate() throws SQLException {
        this.println("executeUpdate:", this);
        return this.executeUpdate(this.inputs_);
    }

    private synchronized int executeUpdate(Object[] objectArray) throws SQLException {
        this.checkForClosedStatement();
        this.clearWarnings();
        if (this.resultSet_ != null) {
            this.resultSet_.close();
            this.resultSet_ = null;
            this.resultSetStack_ = null;
        }
        this.updateCountStack_ = null;
        int n = this.remote_EXECUTE_PREPARED_UPDATE_STATEMENT(objectArray);
        this.resultSetStack_ = null;
        return n;
    }

    public synchronized void clearBatch() throws SQLException {
        this.println("clearBatch:", this);
        if (this.batchInputs_ != null) {
            this.batchInputs_.clear();
            this.batchInputs_ = null;
        }
    }

    public synchronized int[] executeBatch() throws BatchUpdateException, SQLException {
        this.println("executeBatch:", this);
        this.checkForClosedStatement();
        this.clearWarnings();
        int[] nArray = new int[]{};
        if (this.batchInputs_ != null) {
            int n;
            int n2 = this.batchInputs_.size();
            nArray = new int[n2];
            try {
                if (this.connection_.ibase_.getDbai().getNegotiatedProtocol() > 14) {
                    this.connection_.ibase_.iscDsqlBatchExecute(this.connection_.tra_, this.stmtHandle_, this.batchInputs_, nArray, this.sqlWarnings_);
                } else {
                    for (n = 0; n < n2; ++n) {
                        nArray[n] = this.executeUpdate((Object[])this.batchInputs_.get(n));
                    }
                }
            }
            catch (SQLException sQLException) {
                int[] nArray2 = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray2[i] = nArray[i];
                }
                throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), nArray2);
            }
        }
        return nArray;
    }

    private int remote_EXECUTE_PREPARED_UPDATE_STATEMENT(Object[] objectArray) throws SQLException {
        this.allocateStatement();
        this.connection_.ibase_.setInputParameters(objectArray, this.inputCols_, this.stmtHandle_.getInSqlda());
        return this.remote_EXECUTE_UPDATE_STATEMENT(null, true);
    }

    public synchronized void setNull(int n, int n2) throws SQLException {
        this.setNull(n);
    }

    private void setNull(int n) throws SQLException {
        this.checkForClosedStatement();
        try {
            this.inputs_[n - 1] = null;
            this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = -1;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    private int getParameterIBType(int n) throws SQLException {
        try {
            return this.inputTypes_[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ParameterIndexOutOfBoundsException(ErrorKey.parameterIndexOutOfBounds__0__, n);
        }
    }

    public synchronized void setBoolean(int n, boolean bl) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        switch (n2) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = String.valueOf(bl);
                if (((String)this.inputs_[n - 1]).length() <= this.inputCharLengths_[n - 1]) break;
                throw new DataTruncation(n, true, false, ((String)this.inputs_[n - 1]).length(), this.inputCharLengths_[n - 1]);
            }
            default: {
                if (bl) {
                    this.setInt(n, 1);
                    break;
                }
                this.setInt(n, 0);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setByte(int n, byte by) throws SQLException {
        this.checkForClosedStatement();
        this.setInt(n, by);
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setShort(int n, short s) throws SQLException {
        this.setInt(n, s);
    }

    public synchronized void setInt(int n, int n2) throws SQLException {
        this.checkForClosedStatement();
        int n3 = this.getParameterIBType(n);
        BigDecimal bigDecimal = null;
        switch (n3) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                Integer n4 = new Integer(n2);
                bigDecimal = new BigDecimal(n4.toString());
                bigDecimal = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal = bigDecimal.setScale(0, 5);
            }
        }
        switch (n3) {
            case 7: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(n2));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 21: {
                if (n2 > 1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(n2));
                }
            }
            case 1: {
                if (n2 > Short.MAX_VALUE || n2 < Short.MIN_VALUE) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(n2));
                }
                this.inputs_[n - 1] = new Short((short)n2);
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(n2));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 2: {
                this.inputs_[n - 1] = new Integer(n2);
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal.compareTo(bdMaxLongValue) == 1 || bigDecimal.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(n2));
                }
                this.inputs_[n - 1] = new Long(bigDecimal.longValue());
                break;
            }
            case 4: 
            case 5: {
                this.inputs_[n - 1] = new Double(n2);
                break;
            }
            case 3: {
                this.inputs_[n - 1] = new Float(n2);
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = String.valueOf(n2);
                if (((String)this.inputs_[n - 1]).length() <= this.inputCharLengths_[n - 1]) break;
                throw new DataTruncation(n, true, false, ((String)this.inputs_[n - 1]).length(), this.inputCharLengths_[n - 1]);
            }
            case 10: {
                this.inputs_[n - 1] = new Long(this.setBlobString(String.valueOf(n2)));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setLong(int n, long l) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        BigDecimal bigDecimal = null;
        switch (n2) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                Long l2 = new Long(l);
                bigDecimal = new BigDecimal(l2.toString());
                bigDecimal = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal = bigDecimal.setScale(0, 5);
            }
        }
        switch (n2) {
            case 7: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 21: {
                if (l > 1L) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
            }
            case 1: {
                if (l > 32767L || l < -32768L) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Short((short)l);
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 2: {
                if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Integer((int)l);
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal.compareTo(bdMaxLongValue) == 1 || bigDecimal.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(l));
                }
                this.inputs_[n - 1] = new Long(bigDecimal.longValue());
                break;
            }
            case 4: 
            case 5: {
                this.inputs_[n - 1] = new Double(l);
                break;
            }
            case 3: {
                this.inputs_[n - 1] = new Float(l);
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = String.valueOf(l);
                if (((String)this.inputs_[n - 1]).length() <= this.inputCharLengths_[n - 1]) break;
                throw new DataTruncation(n, true, false, ((String)this.inputs_[n - 1]).length(), this.inputCharLengths_[n - 1]);
            }
            case 10: {
                this.inputs_[n - 1] = new Long(this.setBlobString(String.valueOf(l)));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setFloat(int n, float f) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        BigDecimal bigDecimal = null;
        switch (n2) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                Float f2 = new Float(f);
                bigDecimal = new BigDecimal(f2.toString());
                bigDecimal = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal = bigDecimal.setScale(0, 5);
            }
        }
        switch (n2) {
            case 7: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 1: {
                if (f > 32767.0f || f < -32768.0f) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Short((short)f);
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 2: {
                if (f > 2.1474836E9f || f < -2.1474836E9f) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Integer((int)f);
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal.compareTo(bdMaxLongValue) == 1 || bigDecimal.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(f));
                }
                this.inputs_[n - 1] = new Long(bigDecimal.longValue());
                break;
            }
            case 4: 
            case 5: {
                this.inputs_[n - 1] = new Double(f);
                break;
            }
            case 3: {
                this.inputs_[n - 1] = new Float(f);
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = String.valueOf(f);
                if (((String)this.inputs_[n - 1]).length() <= this.inputCharLengths_[n - 1]) break;
                throw new DataTruncation(n, true, false, ((String)this.inputs_[n - 1]).length(), this.inputCharLengths_[n - 1]);
            }
            case 10: {
                this.inputs_[n - 1] = new Long(this.setBlobString(String.valueOf(f)));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setDouble(int n, double d) throws SQLException {
        this.checkForClosedStatement();
        int n2 = this.getParameterIBType(n);
        BigDecimal bigDecimal = null;
        switch (n2) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                bigDecimal = new BigDecimal(d);
                if (this.inputScales_[n - 1] == 0) break;
                bigDecimal = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal = bigDecimal.setScale(0, 5);
            }
        }
        switch (n2) {
            case 7: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 1: {
                if (d > 32767.0 || d < -32768.0) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Short((short)d);
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 2: {
                if (d > 2.147483647E9 || d < -2.147483648E9) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Integer((int)d);
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal.compareTo(bdMaxLongValue) == 1 || bigDecimal.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Long(bigDecimal.longValue());
                break;
            }
            case 4: 
            case 5: {
                this.inputs_[n - 1] = new Double(d);
                break;
            }
            case 3: {
                if (d > 3.4028234663852886E38 || d < -3.4028234663852886E38) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(d));
                }
                this.inputs_[n - 1] = new Float((float)d);
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = String.valueOf(d);
                if (((String)this.inputs_[n - 1]).length() <= this.inputCharLengths_[n - 1]) break;
                throw new DataTruncation(n, true, false, ((String)this.inputs_[n - 1]).length(), this.inputCharLengths_[n - 1]);
            }
            case 10: {
                this.inputs_[n - 1] = new Long(this.setBlobString(String.valueOf(d)));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.checkForClosedStatement();
        if (bigDecimal == null) {
            this.setNull(n);
            return;
        }
        int n2 = this.getParameterIBType(n);
        BigDecimal bigDecimal2 = null;
        switch (n2) {
            case 6: 
            case 7: 
            case 17: 
            case 18: 
            case 19: {
                bigDecimal2 = bigDecimal.movePointRight(this.inputScales_[n - 1]);
                bigDecimal2 = bigDecimal2.setScale(0, 5);
            }
        }
        switch (n2) {
            case 7: {
                if (bigDecimal2.compareTo(bdMaxShortValue) == 1 || bigDecimal2.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Short(bigDecimal2.shortValue());
                break;
            }
            case 1: {
                if (bigDecimal.compareTo(bdMaxShortValue) == 1 || bigDecimal.compareTo(bdMinShortValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Short(bigDecimal.shortValue());
                break;
            }
            case 6: 
            case 19: {
                if (bigDecimal2.compareTo(bdMaxIntValue) == 1 || bigDecimal2.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal2.intValue());
                break;
            }
            case 2: {
                if (bigDecimal.compareTo(bdMaxIntValue) == 1 || bigDecimal.compareTo(bdMinIntValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Integer(bigDecimal.intValue());
                break;
            }
            case 17: 
            case 18: {
                if (bigDecimal2.compareTo(bdMaxLongValue) == 1 || bigDecimal2.compareTo(bdMinLongValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Long(bigDecimal2.longValue());
                break;
            }
            case 4: 
            case 5: {
                if (bigDecimal.compareTo(bdMaxDoubleValue) == 1 || bigDecimal.compareTo(bdMinDoubleValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Double(bigDecimal.doubleValue());
                break;
            }
            case 3: {
                if (bigDecimal.compareTo(bdMaxFloatValue) == 1 || bigDecimal.compareTo(bdMinFloatValue) == -1) {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)String.valueOf(bigDecimal));
                }
                this.inputs_[n - 1] = new Float(bigDecimal.floatValue());
                break;
            }
            case 8: 
            case 9: {
                this.inputs_[n - 1] = bigDecimal.toString();
                if (((String)this.inputs_[n - 1]).length() <= this.inputCharLengths_[n - 1]) break;
                throw new DataTruncation(n, true, false, ((String)this.inputs_[n - 1]).length(), this.inputCharLengths_[n - 1]);
            }
            case 10: {
                this.inputs_[n - 1] = new Long(this.setBlobString(bigDecimal.toString()));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_number_on_binary_blob__);
            }
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 21: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setString(int n, String string) throws SQLException {
        this.checkForClosedStatement();
        if (string == null) {
            this.setNull(n);
            return;
        }
        int n2 = this.getParameterIBType(n);
        try {
            switch (n2) {
                case 1: 
                case 2: 
                case 21: {
                    this.setInt(n, Integer.parseInt(string));
                    break;
                }
                case 6: 
                case 7: {
                    this.setBigDecimal(n, new BigDecimal(string));
                    break;
                }
                case 4: 
                case 5: {
                    this.inputs_[n - 1] = new Double(string);
                    break;
                }
                case 3: {
                    this.inputs_[n - 1] = new Float(string);
                    break;
                }
                case 8: 
                case 9: {
                    this.inputs_[n - 1] = string;
                    if (string.getBytes().length <= this.inputCharLengths_[n - 1]) break;
                    throw new DataTruncation(n, true, false, string.length(), this.inputCharLengths_[n - 1]);
                }
                case 14: {
                    throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
                }
                case 10: 
                case 12: {
                    this.inputs_[n - 1] = new Long(this.setBlobString(string));
                    break;
                }
                case 11: {
                    try {
                        this.setTimestamp(n, Timestamp.valueOf(string));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)string);
                    }
                }
                case 17: 
                case 18: 
                case 19: {
                    this.setBigDecimal(n, new BigDecimal(string));
                    break;
                }
                case 15: {
                    try {
                        this.setDate(n, Date.valueOf(string));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)string);
                    }
                }
                case 16: {
                    try {
                        this.setTime(n, Time.valueOf(string));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)string);
                    }
                }
            }
            this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterConversionException(ErrorKey.parameterConversion__instance_conversion_0__, (Object)string);
        }
    }

    public synchronized void setBytes(int n, byte[] byArray) throws SQLException {
        this.checkForClosedStatement();
        if (byArray == null) {
            this.setNull(n);
            return;
        }
        int n2 = this.getParameterIBType(n);
        switch (n2) {
            case 8: 
            case 9: {
                if (byArray.length > this.inputCharLengths_[n - 1]) {
                    throw new DataTruncation(n, true, false, byArray.length, this.inputCharLengths_[n - 1]);
                }
                this.inputs_[n - 1] = byArray;
                break;
            }
            case 10: 
            case 12: {
                this.inputs_[n - 1] = new Long(new BlobInput((Statement)this, (InputStream)new ByteArrayInputStream((byte[])byArray), (int)byArray.length).blobId);
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setDate(int n, Date date) throws SQLException {
        this.checkForClosedStatement();
        if (date == null) {
            this.setNull(n);
            return;
        }
        int n2 = this.getParameterIBType(n);
        switch (n2) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = date.toString();
                if (((String)this.inputs_[n - 1]).length() <= this.inputCharLengths_[n - 1]) break;
                throw new DataTruncation(n, true, false, ((String)this.inputs_[n - 1]).length(), this.inputCharLengths_[n - 1]);
            }
            case 10: {
                this.inputs_[n - 1] = new Long(this.setBlobString(date.toString()));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_date_on_binary_blob__);
            }
            case 11: 
            case 15: {
                this.inputs_[n - 1] = new IBTimestamp(date);
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setTime(int n, Time time) throws SQLException {
        this.checkForClosedStatement();
        if (time == null) {
            this.setNull(n);
            return;
        }
        int n2 = this.getParameterIBType(n);
        switch (n2) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = time.toString();
                if (((String)this.inputs_[n - 1]).length() <= this.inputCharLengths_[n - 1]) break;
                throw new DataTruncation(n, true, false, ((String)this.inputs_[n - 1]).length(), this.inputCharLengths_[n - 1]);
            }
            case 10: {
                this.inputs_[n - 1] = new Long(this.setBlobString(time.toString()));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_date_on_binary_blob__);
            }
            case 11: 
            case 16: {
                this.inputs_[n - 1] = new IBTimestamp(time);
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.checkForClosedStatement();
        if (timestamp == null) {
            this.setNull(n);
            return;
        }
        int n2 = this.getParameterIBType(n);
        switch (n2) {
            case 8: 
            case 9: {
                this.inputs_[n - 1] = timestamp.toString();
                if (((String)this.inputs_[n - 1]).length() <= this.inputCharLengths_[n - 1]) break;
                throw new DataTruncation(n, true, false, ((String)this.inputs_[n - 1]).length(), this.inputCharLengths_[n - 1]);
            }
            case 10: {
                this.inputs_[n - 1] = new Long(this.setBlobString(timestamp.toString()));
                break;
            }
            case 12: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__set_date_on_binary_blob__);
            }
            case 11: {
                this.inputs_[n - 1] = new IBTimestamp(timestamp);
                break;
            }
            case 15: {
                this.inputs_[n - 1] = new IBTimestamp(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate(), 0, 0, 0, 0);
                break;
            }
            case 16: {
                this.inputs_[n - 1] = new IBTimestamp(0, 0, 1, timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds(), timestamp.getNanos());
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    byte[] getBytesFromInputStream(InputStream inputStream, int n) throws SQLException {
        try {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
            }
            return byArray;
        }
        catch (IOException iOException) {
            throw new CommunicationException(ErrorKey.communication__user_stream__io_exception_on_read_0__, (Object)Utils.getMessage(iOException));
        }
    }

    String getStringFromAsciiInputStream(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = this.getBytesFromInputStream(inputStream, n);
        return new String(byArray);
    }

    String getStringFromUnicodeInputStream(InputStream inputStream, int n) throws SQLException {
        byte[] byArray = this.getBytesFromInputStream(inputStream, n);
        char[] cArray = new char[n / 2];
        int n2 = 0;
        for (int i = 0; i < n / 2; ++i) {
            int n3 = (byArray[n2++] & 0xFF) << 8;
            int n4 = (byArray[n2++] & 0xFF) << 0;
            cArray[i] = (char)(n3 + n4);
        }
        return new String(cArray);
    }

    public synchronized void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkForClosedStatement();
        if (inputStream == null) {
            this.setNull(n);
            return;
        }
        int n3 = this.getParameterIBType(n);
        switch (n3) {
            case 8: 
            case 9: {
                if (n2 > this.inputCharLengths_[n - 1]) {
                    throw new DataTruncation(n, true, false, n2, this.inputCharLengths_[n - 1]);
                }
                this.inputs_[n - 1] = this.getStringFromAsciiInputStream(inputStream, n2);
                break;
            }
            case 10: 
            case 12: {
                this.inputs_[n - 1] = new Long(new BlobInput((Statement)this, (InputStream)inputStream, (int)n2).blobId);
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkForClosedStatement();
        if (inputStream == null) {
            this.setNull(n);
            return;
        }
        int n3 = this.getParameterIBType(n);
        if (n2 % 2 != 0) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__setUnicodeStream_odd_bytes__);
        }
        switch (n3) {
            case 8: 
            case 9: {
                if (n2 > this.inputCharLengths_[n - 1]) {
                    throw new DataTruncation(n, true, false, n2, this.inputCharLengths_[n - 1]);
                }
                this.inputs_[n - 1] = this.getStringFromUnicodeInputStream(inputStream, n2);
                break;
            }
            case 10: 
            case 12: {
                this.inputs_[n - 1] = new Integer((int)new BlobInput((Statement)this, (InputStream)inputStream, (int)n2).blobId);
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.checkForClosedStatement();
        if (inputStream == null) {
            this.setNull(n);
            return;
        }
        int n3 = this.getParameterIBType(n);
        switch (n3) {
            case 8: 
            case 9: {
                if (n2 > this.inputCharLengths_[n - 1]) {
                    throw new DataTruncation(n, true, false, n2, this.inputCharLengths_[n - 1]);
                }
                this.inputs_[n - 1] = this.getBytesFromInputStream(inputStream, n2);
                break;
            }
            case 10: 
            case 12: {
                this.inputs_[n - 1] = new Long(new BlobInput((Statement)this, (InputStream)inputStream, (int)n2).blobId);
                break;
            }
            default: {
                throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
            }
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    private long setBlobString(String string) throws SQLException {
        if (string == null) {
            return 0L;
        }
        try {
            byte[] byArray = string.getBytes(this.connection_.ctb_.getCharacterEncoding());
            return new BlobInput((Statement)this, (InputStream)new ByteArrayInputStream((byte[])byArray), (int)byArray.length).blobId;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BugCheckException(ErrorKey.bugCheck__0__, 128);
        }
    }

    public synchronized void clearParameters() throws SQLException {
        this.println("clearParameters:", this);
        this.checkForClosedStatement();
        for (int i = 0; i < this.inputCols_; ++i) {
            this.inputs_[i] = null;
        }
    }

    public synchronized void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.setObject(n, object);
    }

    public synchronized void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object);
    }

    public synchronized void setObject(int n, Object object) throws SQLException {
        this.checkForClosedStatement();
        if (object == null) {
            this.setNull(n);
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
        } else if (object instanceof Byte) {
            this.setByte(n, (Byte)object);
        } else if (object instanceof Short) {
            this.setShort(n, (Short)object);
        } else if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
        } else if (object instanceof Long) {
            this.setLong(n, (Long)object);
        } else if (object instanceof Double) {
            this.setDouble(n, (Double)object);
        } else if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
        } else if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
        } else if (object instanceof String) {
            this.setString(n, (String)object);
        } else if (object instanceof byte[] && this.getParameterIBType(n) != 14) {
            this.setBytes(n, (byte[])object);
        } else if (object instanceof Date) {
            this.setDate(n, (Date)object);
        } else if (object instanceof Time) {
            this.setTime(n, (Time)object);
        } else if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
        } else if (object instanceof Array) {
            this.setArray(n, (Array)object);
        } else if (object.getClass().isArray()) {
            this.setJavaArray(n, object);
        } else {
            if (object instanceof InputStream) {
                throw new ParameterConversionException(ErrorKey.parameterConversion__set_object_on_stream__);
            }
            throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
        }
        this.stmtHandle_.getInSqlda().sqlvar[n - 1].sqlind = 0;
    }

    public synchronized boolean execute() throws SQLException {
        this.println("execute:", this);
        this.checkForClosedStatement();
        this.clearWarnings();
        if (this.resultSet_ != null) {
            this.resultSet_.close();
            this.resultSet_ = null;
            this.resultSetStack_ = null;
        }
        this.updateCountStack_ = null;
        this.remote_EXECUTE_PREPARED_STATEMENT();
        this.resultSetStack_ = this.resultSet_;
        return this.resultSet_ != null;
    }

    private void remote_EXECUTE_PREPARED_STATEMENT() throws SQLException {
        this.allocateStatement();
        this.connection_.ibase_.setInputParameters(this.inputs_, this.inputCols_, this.stmtHandle_.getInSqlda());
        this.remote_EXECUTE_STATEMENT(null, true);
    }

    public synchronized void addBatch() throws SQLException {
        this.println("addBatch:", this);
        if (this.batchInputs_ == null) {
            this.batchInputs_ = new ArrayList();
        }
        Object[] objectArray = new Object[this.inputs_.length];
        for (int i = 0; i < this.inputs_.length; ++i) {
            objectArray[i] = this.inputs_[i];
        }
        this.batchInputs_.add(objectArray);
    }

    public synchronized void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.checkForClosedStatement();
        if (reader == null) {
            this.setNull(n);
            return;
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setRef(int n, Ref ref) throws SQLException {
        this.checkForClosedStatement();
        if (ref == null) {
            this.setNull(n);
            return;
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setBlob(int n, Blob blob) throws SQLException {
        this.checkForClosedStatement();
        if (blob == null) {
            this.setNull(n);
            return;
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setClob(int n, Clob clob) throws SQLException {
        this.checkForClosedStatement();
        if (clob == null) {
            this.setNull(n);
            return;
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void setArray(int n, Array array) throws SQLException {
        this.setJavaArray(n, array.getArray());
    }

    private synchronized void setJavaArray(int n, Object object) throws SQLException {
        this.checkForClosedStatement();
        if (object == null) {
            this.setNull(n);
            return;
        }
        int n2 = this.getParameterIBType(n);
        if (n2 == 14) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
        }
        throw new ParameterConversionException(ErrorKey.parameterConversion__type_conversion__);
    }

    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        this.checkForClosedStatement();
        if (this.resultSet_ == null) {
            return null;
        }
        return this.resultSet_.getMetaData();
    }

    public synchronized void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.checkForClosedStatement();
        if (date == null) {
            this.setNull(n);
            return;
        }
        if (calendar == null) {
            this.setDate(n, date);
        } else {
            calendar.setTime(date);
            this.setDate(n, new Date(calendar.getTime().getTime()));
        }
    }

    public synchronized void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (time == null) {
            this.setNull(n);
            return;
        }
        if (calendar == null) {
            this.setTime(n, time);
        } else {
            calendar.setTime(time);
            this.setTime(n, new Time(calendar.getTime().getTime()));
        }
    }

    public synchronized void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (calendar == null) {
            this.setTimestamp(n, timestamp);
        } else if (timestamp == null) {
            this.setTimestamp(n, new Timestamp(calendar.getTime().getTime()));
        } else {
            long l = timestamp.getTime() - (long)calendar.getTimeZone().getRawOffset();
            this.setTimestamp(n, new Timestamp(l));
        }
    }

    public synchronized void setNull(int n, int n2, String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkForClosedStatement();
        if (this.parameterMetaData_ == null) {
            this.parameterMetaData_ = IBParameterMetaData.setParameterMetaData(this);
        }
        return this.parameterMetaData_;
    }

    public ParameterMetaData getIBParameterMetaData() throws SQLException {
        if (this.ibParameterMetaData == null) {
            this.ibParameterMetaData = new ParameterMetaData(this);
        }
        return this.ibParameterMetaData;
    }

    public synchronized ResultSetMetaData getResultSetMetaData() throws SQLException {
        return this.getMetaData();
    }

    public synchronized void prepareArray(int n, String string, String string2) throws SQLException {
        if (this.getParameterIBType(n) != 14) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__not_array_parameter__);
        }
    }

    public synchronized void setURL(int n, URL uRL) throws SQLException {
        this.checkForClosedStatement();
        if (uRL == null) {
            this.setNull(n);
            return;
        }
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }
}

