/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import com.inprise.sql.SQLAdapter;
import interbase.interclient.Adaptor;
import interbase.interclient.Array;
import interbase.interclient.ArrayDescriptor;
import interbase.interclient.BlobOutput;
import interbase.interclient.BugCheckException;
import interbase.interclient.ByteToUnicodeConverterStream;
import interbase.interclient.CharacterEncodings;
import interbase.interclient.ColumnConversionException;
import interbase.interclient.ColumnIndexOutOfBoundsException;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.Globals;
import interbase.interclient.IBException;
import interbase.interclient.IBTimestamp;
import interbase.interclient.IBTypes;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.ResultSetMetaData;
import interbase.interclient.Statement;
import interbase.interclient.UnsupportedCharacterEncodingException;
import interbase.interclient.XSQLDA;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public final class ResultSet
implements java.sql.ResultSet,
Adaptor,
borland.jdbc.SQLAdapter,
SQLAdapter {
    int numRows_;
    private ResultSetMetaData resultSetMetaData_;
    Statement statement_;
    Hashtable columnNameToIndexCache_ = null;
    private IBException sqlWarnings_;
    private static final int WAS_NULL__ = 1;
    private static final int WAS_NOT_NULL__ = 2;
    private static final int WAS_NULL_UNSET__ = 0;
    private int wasNull_ = 0;
    int resultCols_;
    int[] resultTypes_;
    int[] resultScales_;
    ArrayDescriptor[] arrayDescriptors_;
    char[] cbuf_;
    private boolean openOnClient_ = true;
    boolean openOnServer_;
    boolean validCursorPosition_ = false;
    private boolean adaptToRightTrimString_ = false;
    private boolean adaptToSingleInstanceTime_ = false;
    private IBTimestamp adaptableIBTimestamp_ = null;
    private Date adaptableDate_ = null;
    private Time adaptableTime_ = null;
    private Timestamp adaptableTimestamp_ = null;
    XSQLDA xsqlda_ = null;
    private long numberOfRowsFetched_ = 0L;
    private long currentPosition_ = 0L;
    private boolean fetched_ = false;
    private int resultSetType_ = 1003;
    public static final int FETCH_FORWARD = 1000;
    public static final int FETCH_REVERSE = 1001;
    public static final int FETCH_UNKNOWN = 1002;
    public static final int TYPE_FORWARD_ONLY = 1003;
    public static final int TYPE_SCROLL_INSENSITIVE = 1004;
    public static final int TYPE_SCROLL_SENSITIVE = 1005;
    public static final int CONCUR_READ_ONLY = 1007;
    public static final int CONCUR_UPDATABLE = 1008;
    static final int HOLD_CURSORS_OVER_COMMIT = 1;
    static final int CLOSE_CURSORS_AT_COMMIT = 2;

    ResultSet(Statement statement, int n, boolean bl) {
        this.resultCols_ = n;
        this.resultTypes_ = new int[this.resultCols_];
        this.resultScales_ = new int[this.resultCols_];
        this.arrayDescriptors_ = new ArrayDescriptor[this.resultCols_];
        this.statement_ = statement;
        this.openOnServer_ = bl;
        this.resultSetType_ = 1003;
    }

    ResultSet(Statement statement, boolean bl, int n, XSQLDA xSQLDA, int n2) throws SQLException {
        this.resultCols_ = n;
        this.resultTypes_ = new int[this.resultCols_];
        this.resultScales_ = new int[this.resultCols_];
        this.arrayDescriptors_ = new ArrayDescriptor[this.resultCols_];
        this.statement_ = statement;
        this.openOnServer_ = bl;
        this.xsqlda_ = xSQLDA;
        this.numRows_ = xSQLDA.sqld;
        this.setResultSetMetaData(xSQLDA, false);
        this.resultSetType_ = n2;
    }

    protected void finalize() throws Throwable {
        if (this.openOnServer_) {
            this.close();
        }
        super.finalize();
    }

    public synchronized boolean next() throws SQLException {
        this.checkForClosedCursor();
        this.clearWarnings();
        this.validCursorPosition_ = this.getNextCursorPosition();
        return this.validCursorPosition_;
    }

    private boolean getNextCursorPosition() throws SQLException {
        if (this.fetched_) {
            if (this.numberOfRowsFetched_ == this.currentPosition_) {
                if (this.statement_.stmtHandle_.isAllRowsFetched()) {
                    this.statement_.cancelable = false;
                    return false;
                }
                this.remote_FETCH_ROWS();
                this.numberOfRowsFetched_ = this.statement_.stmtHandle_.rows.size();
                this.fetched_ = true;
                if (this.numberOfRowsFetched_ > 0L) {
                    ++this.currentPosition_;
                    return true;
                }
                this.statement_.cancelable = false;
                return false;
            }
            ++this.currentPosition_;
            return true;
        }
        boolean bl = false;
        do {
            this.remote_FETCH_ROWS();
            if (this.resultSetType_ != 1003 && !this.statement_.stmtHandle_.isAllRowsFetched()) continue;
            bl = true;
        } while (!bl);
        this.numberOfRowsFetched_ = this.statement_.stmtHandle_.rows.size();
        this.fetched_ = true;
        if (this.numberOfRowsFetched_ > 0L) {
            ++this.currentPosition_;
            return true;
        }
        this.statement_.cancelable = false;
        return false;
    }

    void remote_FETCH_ROWS() throws SQLException {
        if (!this.openOnServer_) {
            return;
        }
        try {
            if (!this.statement_.stmtHandle_.isSingletonResult() && this.resultSetType_ == 1003) {
                this.statement_.stmtHandle_.clearRows();
                this.currentPosition_ = 0L;
            }
            boolean bl = this.statement_.connection_.ibase_.iscDsqlFetch(this.statement_.stmtHandle_, this.statement_.stmtHandle_.getOutSqlda().version, this.statement_.stmtHandle_.getOutSqlda(), this.sqlWarnings_, this.statement_.getFetchSize());
        }
        catch (IBException iBException) {
            this.fetched_ = false;
            this.validCursorPosition_ = false;
            throw new SQLException(iBException.getMessage());
        }
    }

    void checkForClosedCursor() throws SQLException {
        if (!this.openOnClient_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__result_set_closed__);
        }
    }

    short getRowData_short(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return (Short)objectArray[n];
    }

    int getRowData_int(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return (Integer)objectArray[n];
    }

    long getRowData_long(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return (Long)objectArray[n];
    }

    float getRowData_float(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return ((Float)objectArray[n]).floatValue();
    }

    double getRowData_double(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return (Double)objectArray[n];
    }

    Timestamp getRowData_timestampId(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return (Timestamp)objectArray[n];
    }

    Date getRowData_sqldate(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return (Date)objectArray[n];
    }

    Time getRowData_sqltime(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return (Time)objectArray[n];
    }

    long getRowData_blobId(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return (Long)objectArray[n];
    }

    long getRowData_arrayId(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__extension_not_yet_supported__);
    }

    String getRowData_char(int n) throws SQLException {
        return this.getRowData_varchar(n);
    }

    String getRowData_varchar(int n) throws SQLException {
        String string;
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        String string2 = CharacterEncodings.getCharacterSetName(this.xsqlda_.sqlvar[n].sqlsubtype % 128);
        if (!this.statement_.connection_.charsetWasNone || this.statement_.connection_.charsetWasNone && string2 == null) {
            try {
                string = new String((byte[])objectArray[n], this.statement_.connection_.ianaCharacterEncoding_);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new UnsupportedCharacterEncodingException(ErrorKey.unsupportedCharacterEncoding__0__, this.statement_.connection_.ianaCharacterEncoding_);
            }
        }
        try {
            string = new String((byte[])objectArray[n], string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new UnsupportedCharacterEncodingException(ErrorKey.unsupportedCharacterEncoding__0__, string2);
        }
        return string;
    }

    String getRowData_varchar_string(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return new String(objectArray[n].toString());
    }

    byte[] getRowData_bytes(int n) throws SQLException {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return (byte[])objectArray[n];
    }

    void local_Close() throws SQLException {
        this.openOnClient_ = false;
        Globals.cache__.returnCharBuffer(this.cbuf_);
        this.cbuf_ = null;
        this.numberOfRowsFetched_ = 0L;
        this.currentPosition_ = 0L;
        if (this.columnNameToIndexCache_ != null) {
            this.columnNameToIndexCache_.clear();
            this.columnNameToIndexCache_ = null;
        }
        this.xsqlda_ = null;
        this.markMetaDataNull();
        if (this.resultSetMetaData_ != null) {
            this.resultSetMetaData_ = null;
        }
        this.statement_ = null;
        this.sqlWarnings_ = null;
    }

    private void markMetaDataNull() {
        this.resultTypes_ = null;
        this.resultScales_ = null;
        this.arrayDescriptors_ = null;
    }

    public synchronized void close() throws SQLException {
        if (this.openOnServer_) {
            this.remote_CLOSE_CURSOR();
        }
        this.openOnServer_ = false;
        this.local_Close();
        if (this.statement_ != null) {
            this.statement_.resultSet_ = null;
        }
    }

    synchronized void remote_CLOSE_CURSOR() throws SQLException {
        if (!this.statement_.stmtHandle_.isSingletonResult()) {
            try {
                this.statement_.connection_.ibase_.iscDsqlFreeStatement(this.statement_.stmtHandle_, 1, this.sqlWarnings_);
                this.statement_.cancelable = false;
            }
            catch (IBException iBException) {
                throw new SQLException(iBException.toString());
            }
        } else {
            return;
        }
    }

    void checkForValidCursorPosition() throws SQLException {
        if (!this.validCursorPosition_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__read_at_invalid_cursor_position__);
        }
    }

    public synchronized boolean wasNull() throws SQLException {
        this.checkForClosedCursor();
        if (this.wasNull_ == 0) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__was_null_with_no_data_retrieved__);
        }
        return this.wasNull_ == 1;
    }

    public synchronized String getString(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        try {
            switch (this.resultTypes_[n - 1]) {
                case 8: {
                    return this.getRowData_char(n - 1);
                }
                case 9: {
                    return this.getRowData_varchar(n - 1);
                }
                case 20: {
                    return this.getRowData_varchar_string(n - 1);
                }
                case 14: {
                    return "";
                }
                case 10: 
                case 12: {
                    long l = this.getRowData_blobId(n - 1);
                    BlobOutput blobOutput = new BlobOutput(this.statement_, l, this.statement_.connection_.btc_);
                    return blobOutput.getString();
                }
                case 1: 
                case 21: {
                    return String.valueOf(this.getRowData_short(n - 1));
                }
                case 2: {
                    return String.valueOf(this.getRowData_int(n - 1));
                }
                case 3: {
                    return String.valueOf(this.getRowData_float(n - 1));
                }
                case 4: {
                    return String.valueOf(this.getRowData_double(n - 1));
                }
                case 5: 
                case 6: 
                case 7: {
                    return this.getBigDecimal(n, this.resultScales_[n - 1]).toString();
                }
                case 11: {
                    return this.getTimestamp(n).toString();
                }
                case 15: {
                    return this.getDate(n).toString();
                }
                case 16: {
                    return this.getTime(n).toString();
                }
                case 17: 
                case 18: 
                case 19: {
                    return this.getBigDecimal(n, this.resultScales_[n - 1]).toString();
                }
            }
            throw new BugCheckException(ErrorKey.bugCheck__0__, 114);
        }
        catch (IOException iOException) {
            throw new SQLException(iOException.toString());
        }
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        return this.getInt(n) != 0;
    }

    public synchronized byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public synchronized short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public synchronized int getInt(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return 0;
        }
        switch (this.resultTypes_[n - 1]) {
            case 1: 
            case 21: {
                return this.getRowData_short(n - 1);
            }
            case 2: {
                return this.getRowData_int(n - 1);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).intValue();
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).intValue();
            }
            case 4: 
            case 5: {
                return (int)this.getRowData_double(n - 1);
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).intValue();
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).intValue();
            }
            case 3: {
                return (int)this.getRowData_float(n - 1);
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                String string = this.getString(n);
                try {
                    return Integer.parseInt(string.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized long getLong(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return 0L;
        }
        switch (this.resultTypes_[n - 1]) {
            case 4: 
            case 5: {
                return (long)this.getRowData_double(n - 1);
            }
            case 1: 
            case 21: {
                return this.getRowData_short(n - 1);
            }
            case 2: {
                return this.getRowData_int(n - 1);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).longValue();
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).longValue();
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).longValue();
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).longValue();
            }
            case 3: {
                return (long)this.getRowData_float(n - 1);
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                String string = this.getString(n);
                try {
                    return Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized float getFloat(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return 0.0f;
        }
        switch (this.resultTypes_[n - 1]) {
            case 3: {
                return this.getRowData_float(n - 1);
            }
            case 4: 
            case 5: {
                return (float)this.getRowData_double(n - 1);
            }
            case 2: {
                return this.getRowData_int(n - 1);
            }
            case 1: {
                return this.getRowData_short(n - 1);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).floatValue();
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).floatValue();
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).floatValue();
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).floatValue();
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                String string = this.getString(n);
                try {
                    return Float.valueOf(string).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized double getDouble(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return 0.0;
        }
        switch (this.resultTypes_[n - 1]) {
            case 4: 
            case 5: {
                return this.getRowData_double(n - 1);
            }
            case 1: {
                return this.getRowData_short(n - 1);
            }
            case 2: {
                return this.getRowData_int(n - 1);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).doubleValue();
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).doubleValue();
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).doubleValue();
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).doubleValue();
            }
            case 3: {
                return this.getRowData_float(n - 1);
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                String string = this.getString(n);
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 1: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), n2);
            }
            case 2: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), n2);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).setScale(n2, 6);
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).setScale(n2, 6);
            }
            case 4: 
            case 5: {
                return new BigDecimal(this.getRowData_double(n - 1)).setScale(n2, 6);
            }
            case 3: {
                return new BigDecimal(this.getRowData_float(n - 1)).setScale(n2, 6);
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).setScale(n2, 6);
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).setScale(n2, 6);
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                String string = this.getString(n);
                try {
                    return new BigDecimal(string).setScale(n2, 6);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        try {
            switch (this.resultTypes_[n - 1]) {
                case 10: 
                case 12: {
                    long l = this.getRowData_blobId(n - 1);
                    BlobOutput blobOutput = new BlobOutput(this.statement_, l, this.statement_.connection_.btc_);
                    return blobOutput.getBytes();
                }
                case 8: 
                case 9: {
                    return this.getRowData_bytes(n - 1);
                }
            }
            throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public synchronized Date getDate(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 11: {
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableDate_.setTime(this.getRowData_timestampId(n - 1).getTime());
                    return this.adaptableDate_;
                }
                Date date = new Date(this.getRowData_timestampId(n - 1).getTime());
                return date;
            }
            case 15: {
                return this.getRowData_sqldate(n - 1);
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                String string = this.getString(n);
                try {
                    return Date.valueOf(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_date_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized Time getTime(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 11: {
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableTime_.setTime(this.getRowData_timestampId(n - 1).getTime());
                    return this.adaptableTime_;
                }
                Time time = new Time(this.getRowData_timestampId(n - 1).getTime());
                return time;
            }
            case 16: {
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableTime_.setTime(this.getRowData_sqltime(n - 1).getTime());
                    return this.adaptableTime_;
                }
                Time time = new Time(this.getRowData_sqltime(n - 1).getTime());
                return time;
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                String string = this.getString(n);
                try {
                    return Time.valueOf(string.trim());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_date_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 11: {
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableTimestamp_ = (Timestamp)this.getRowData_timestampId(n - 1).clone();
                    return this.adaptableTimestamp_;
                }
                Timestamp timestamp = (Timestamp)this.getRowData_timestampId(n - 1).clone();
                return timestamp;
            }
            case 15: {
                int n2 = this.getRowData_int(n - 1);
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableIBTimestamp_.setDateTime(0, n2);
                    this.adaptableTimestamp_.setTime(this.adaptableIBTimestamp_.getTimeInMillis());
                    this.adaptableTimestamp_.setNanos(this.adaptableIBTimestamp_.getNanos());
                    return this.adaptableTimestamp_;
                }
                IBTimestamp iBTimestamp = new IBTimestamp(0, n2);
                Timestamp timestamp = new Timestamp(iBTimestamp.getTimeInMillis());
                timestamp.setNanos(iBTimestamp.getNanos());
                return timestamp;
            }
            case 16: {
                if (this.adaptToSingleInstanceTime_) {
                    this.adaptableTimestamp_.setTime(this.getRowData_sqltime(n - 1).getTime());
                    return this.adaptableTimestamp_;
                }
                Timestamp timestamp = new Timestamp(this.getRowData_sqltime(n - 1).getTime());
                return timestamp;
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                String string = this.getString(n);
                try {
                    return Timestamp.valueOf(string.trim());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_date_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 10: 
            case 12: {
                long l = this.getRowData_blobId(n - 1);
                BlobOutput blobOutput = new BlobOutput(this.statement_, l, this.statement_.connection_.btc_);
                return blobOutput.getInputStream();
            }
            case 8: 
            case 9: {
                return new ByteArrayInputStream(this.getRowData_bytes(n - 1));
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 10: 
            case 12: {
                long l = this.getRowData_blobId(n - 1);
                BlobOutput blobOutput = new BlobOutput(this.statement_, l, this.statement_.connection_.btc_);
                return blobOutput.getUnicodeInputStream();
            }
            case 8: {
                return new ByteToUnicodeConverterStream(this.getRowData_char(n - 1));
            }
            case 9: {
                return new ByteToUnicodeConverterStream(this.getRowData_varchar(n - 1));
            }
            case 20: {
                return new ByteToUnicodeConverterStream(this.getRowData_varchar_string(n - 1));
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 10: 
            case 12: {
                long l = this.getRowData_blobId(n - 1);
                BlobOutput blobOutput = new BlobOutput(this.statement_, l, this.statement_.connection_.btc_);
                return blobOutput.getInputStream();
            }
            case 8: 
            case 9: {
                return new ByteArrayInputStream(this.getRowData_bytes(n - 1));
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public synchronized BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public synchronized InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public synchronized InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public synchronized InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        return new SQLWarning(this.sqlWarnings_.getMessage());
    }

    public synchronized void clearWarnings() throws SQLException {
        this.sqlWarnings_ = null;
    }

    public synchronized String getCursorName() throws SQLException {
        return this.statement_.cursorName_;
    }

    public synchronized java.sql.ResultSetMetaData getMetaData() throws SQLException {
        this.checkForClosedCursor();
        if (this.resultSetMetaData_ == null) {
            this.resultSetMetaData_ = new ResultSetMetaData(this);
        }
        return this.resultSetMetaData_;
    }

    public synchronized Object getObject(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                return this.getString(n);
            }
            case 12: {
                return this.getBytes(n);
            }
            case 14: {
                return this.getArray(n);
            }
            case 11: {
                return this.getTimestamp(n);
            }
            case 5: 
            case 6: 
            case 7: {
                return this.getBigDecimal(n, this.resultScales_[n - 1]);
            }
            case 17: 
            case 18: 
            case 19: {
                return this.getBigDecimal(n, this.resultScales_[n - 1]);
            }
            case 15: {
                return this.getDate(n);
            }
            case 16: {
                return this.getTime(n);
            }
            case 4: {
                return new Double(this.getDouble(n));
            }
            case 3: {
                return new Float(this.getFloat(n));
            }
            case 1: {
                return new Integer(this.getShort(n));
            }
            case 21: {
                if (this.getShort(n) == 0) {
                    return new Boolean(false);
                }
                return new Boolean(true);
            }
            case 2: {
                return new Integer(this.getInt(n));
            }
        }
        throw new BugCheckException(ErrorKey.bugCheck__0__, 115);
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public synchronized int findColumn(String string) throws SQLException {
        this.checkForClosedCursor();
        if (this.columnNameToIndexCache_ == null) {
            this.columnNameToIndexCache_ = new Hashtable();
        } else {
            Integer n = (Integer)this.columnNameToIndexCache_.get(string);
            if (n != null) {
                return n;
            }
        }
        for (int i = 0; i < this.resultCols_; ++i) {
            boolean bl = false;
            int n = string.length() - 1;
            if ('\"' == string.charAt(0) && '\"' == string.charAt(n)) {
                if (this.xsqlda_.sqlvar[i].sqlname.equals(string.substring(1, n)) || this.xsqlda_.sqlvar[i].aliasname != null && this.xsqlda_.sqlvar[i].aliasname.equals(string.substring(1, n))) {
                    bl = true;
                }
            } else if (this.xsqlda_.sqlvar[i].sqlname.equalsIgnoreCase(string) || this.xsqlda_.sqlvar[i].aliasname != null && this.xsqlda_.sqlvar[i].aliasname.equalsIgnoreCase(string)) {
                bl = true;
            }
            if (!bl) continue;
            this.columnNameToIndexCache_.put(string, new Integer(i + 1));
            return i + 1;
        }
        throw new InvalidArgumentException(ErrorKey.invalidArgument__column_name_0__, (Object)string);
    }

    void setResultSetMetaData(XSQLDA xSQLDA, boolean bl) throws SQLException {
        for (int i = 0; i < this.resultCols_; ++i) {
            if (bl) {
                xSQLDA.sqlvar[i].aliasname = xSQLDA.sqlvar[i].sqlname;
            }
            this.resultTypes_[i] = IBTypes.getResultTypes(xSQLDA.sqlvar[i].sqltype, xSQLDA.sqlvar[i]);
            this.resultScales_[i] = Math.abs(xSQLDA.sqlvar[i].sqlscale);
            if (this.resultTypes_[i] != 14) continue;
            this.arrayDescriptors_[i] = new ArrayDescriptor(this.statement_.connection_, xSQLDA.sqlvar[i].relname, xSQLDA.sqlvar[i].sqlname);
        }
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Reader getCharacterStream(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 1: 
            case 21: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]);
            }
            case 2: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]);
            }
            case 6: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).setScale(this.resultScales_[n - 1], 6);
            }
            case 7: {
                return BigDecimal.valueOf(this.getRowData_short(n - 1), this.resultScales_[n - 1]).setScale(this.resultScales_[n - 1], 6);
            }
            case 4: 
            case 5: {
                return new BigDecimal(this.getRowData_double(n - 1)).setScale(this.resultScales_[n - 1], 6);
            }
            case 3: {
                return new BigDecimal(this.getRowData_float(n - 1)).setScale(this.resultScales_[n - 1], 6);
            }
            case 19: {
                return BigDecimal.valueOf(this.getRowData_int(n - 1), this.resultScales_[n - 1]).setScale(this.resultScales_[n - 1], 6);
            }
            case 17: 
            case 18: {
                return BigDecimal.valueOf(this.getRowData_long(n - 1), this.resultScales_[n - 1]).setScale(this.resultScales_[n - 1], 6);
            }
            case 8: 
            case 9: 
            case 10: 
            case 20: {
                String string = this.getString(n);
                try {
                    return new BigDecimal(string).setScale(this.resultScales_[n - 1], 6);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ColumnConversionException(ErrorKey.columnConversion__instance_conversion_0__, (Object)string);
                }
            }
            case 12: {
                throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__get_number_on_binary_blob__);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (this.fetched_ && this.statement_.stmtHandle_.rows != null) {
            return this.currentPosition_ == 0L;
        }
        throw new DriverNotCapableException(ErrorKey.invalidOperation__result_set_closed__);
    }

    public synchronized boolean isAfterLast() throws SQLException {
        if (this.getType() == 1003) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (this.fetched_ && this.statement_.stmtHandle_.rows != null) {
            return this.currentPosition_ == (long)(this.statement_.stmtHandle_.rows.size() + 1);
        }
        throw new DriverNotCapableException(ErrorKey.invalidOperation__result_set_closed__);
    }

    public synchronized boolean isFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (this.fetched_ && this.statement_.stmtHandle_.rows != null) {
            if (this.currentPosition_ == 1L) {
                this.validCursorPosition_ = true;
                return true;
            }
            return false;
        }
        throw new DriverNotCapableException(ErrorKey.invalidOperation__result_set_closed__);
    }

    public synchronized boolean isLast() throws SQLException {
        if (this.getType() == 1003) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (this.fetched_ && this.statement_.stmtHandle_.rows != null) {
            if (this.currentPosition_ == (long)this.statement_.stmtHandle_.rows.size()) {
                this.validCursorPosition_ = true;
                return true;
            }
            return false;
        }
        throw new DriverNotCapableException(ErrorKey.invalidOperation__result_set_closed__);
    }

    public synchronized void beforeFirst() throws SQLException {
        if (this.getType() == 1003) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (this.fetched_ && this.statement_.stmtHandle_.rows != null) {
            this.currentPosition_ = 0L;
            this.validCursorPosition_ = false;
        }
    }

    public synchronized void afterLast() throws SQLException {
        if (this.getType() == 1003) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (this.fetched_ && this.statement_.stmtHandle_.rows != null) {
            this.currentPosition_ = this.statement_.stmtHandle_.rows.size() + 1;
            this.validCursorPosition_ = false;
        }
    }

    public synchronized boolean first() throws SQLException {
        if (this.getType() == 1003) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (this.fetched_ && this.statement_.stmtHandle_.rows != null) {
            this.currentPosition_ = 1L;
            this.validCursorPosition_ = true;
            return true;
        }
        this.validCursorPosition_ = false;
        return false;
    }

    public synchronized boolean last() throws SQLException {
        if (this.getType() == 1003) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (this.fetched_ && this.statement_.stmtHandle_.rows != null) {
            this.currentPosition_ = this.statement_.stmtHandle_.rows.size();
            this.validCursorPosition_ = true;
            return true;
        }
        this.validCursorPosition_ = false;
        return false;
    }

    public synchronized int getRow() throws SQLException {
        if (this.fetched_) {
            return (int)this.currentPosition_;
        }
        return 0;
    }

    public synchronized boolean absolute(int n) throws SQLException {
        if (this.getType() == 1003) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (this.fetched_) {
            if (n > 0) {
                this.currentPosition_ = n <= this.statement_.stmtHandle_.rows.size() ? (long)n : (long)(n + 1);
            } else if (n < 0) {
                this.currentPosition_ = this.statement_.stmtHandle_.rows.size() - n;
                if (this.currentPosition_ < 0L) {
                    this.currentPosition_ = 0L;
                    this.validCursorPosition_ = false;
                    return false;
                }
            } else {
                this.currentPosition_ = 0L;
                this.validCursorPosition_ = false;
                return false;
            }
            this.validCursorPosition_ = true;
            return true;
        }
        return false;
    }

    public synchronized boolean relative(int n) throws SQLException {
        if (this.getType() == 1003 || !this.fetched_) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        long l = this.currentPosition_ + (long)n;
        if (l >= (long)this.statement_.stmtHandle_.rows.size()) {
            this.afterLast();
            return false;
        }
        if (this.currentPosition_ <= 1L) {
            this.beforeFirst();
            return false;
        }
        this.currentPosition_ = l;
        this.validCursorPosition_ = true;
        return true;
    }

    public synchronized boolean previous() throws SQLException {
        if (this.getType() == 1003 || !this.fetched_) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
        if (!this.fetched_ || this.currentPosition_ <= 1L) {
            this.validCursorPosition_ = false;
            return false;
        }
        --this.currentPosition_;
        this.validCursorPosition_ = true;
        return true;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__scrolling_not_supported__);
        }
    }

    public synchronized int getFetchDirection() throws SQLException {
        return 1000;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.statement_.setFetchSize(n);
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.statement_.getFetchSize();
    }

    public synchronized int getType() throws SQLException {
        return this.resultSetType_;
    }

    public synchronized int getConcurrency() throws SQLException {
        return 1007;
    }

    public synchronized boolean rowUpdated() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__scrolling_not_supported__);
    }

    public synchronized boolean rowInserted() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__scrolling_not_supported__);
    }

    public synchronized boolean rowDeleted() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__scrolling_not_supported__);
    }

    public synchronized void updateNull(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBoolean(int n, boolean bl) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateByte(int n, byte by) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateShort(int n, short s) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateInt(int n, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateLong(int n, long l) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateFloat(int n, float f) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateDouble(int n, double d) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateDate(int n, Date date) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateTime(int n, Time time) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateObject(int n, Object object, int n2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateNull(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBoolean(String string, boolean bl) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateByte(String string, byte by) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateShort(String string, short s) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateInt(String string, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateLong(String string, long l) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateFloat(String string, float f) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateDouble(String string, double d) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateString(String string, String string2) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateDate(String string, Date date) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateTime(String string, Time time) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateObject(String string, Object object, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateObject(String string, Object object) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void insertRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void deleteRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void refreshRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void moveToInsertRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.Statement getStatement() throws SQLException {
        return this.statement_;
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Ref getRef(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.Array getArray(int n) throws SQLException {
        if (this.isNullPreamble(n)) {
            return null;
        }
        switch (this.resultTypes_[n - 1]) {
            case 14: {
                return new Array(this.getRowData_arrayId(n - 1), this.arrayDescriptors_[n - 1], this.statement_.connection_);
            }
        }
        throw new ColumnConversionException(ErrorKey.columnConversion__type_conversion__);
    }

    public synchronized Object getObject(String string, Map map) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Ref getRef(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Blob getBlob(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized Clob getClob(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (calendar == null) {
            return date;
        }
        calendar.setTime(date);
        return new Date(calendar.getTime().getTime());
    }

    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (calendar == null) {
            return time;
        }
        calendar.setTime(time);
        return new Time(calendar.getTime().getTime());
    }

    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = this.getTimestamp(n);
        if (calendar == null) {
            return timestamp;
        }
        long l = timestamp.getTime() + (long)calendar.getTimeZone().getRawOffset();
        return new Timestamp(l);
    }

    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public synchronized boolean isNull(int n) throws SQLException {
        this.checkForClosedCursor();
        this.checkForValidCursorPosition();
        try {
            return this.isNullType(n - 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    public synchronized boolean adapt(int n, Object object) throws SQLException {
        switch (n) {
            case 1: {
                this.adaptToRightTrimString_ = true;
                return true;
            }
            case 2: {
                this.adaptToSingleInstanceTime_ = true;
                this.adaptableIBTimestamp_ = new IBTimestamp(0, 0, 1);
                this.adaptableDate_ = new Date(0L);
                this.adaptableTime_ = new Time(0L);
                this.adaptableTimestamp_ = new Timestamp(0L);
                return true;
            }
        }
        return false;
    }

    public synchronized void revert(int n) throws SQLException {
        switch (n) {
            case 1: {
                this.adaptToRightTrimString_ = false;
                break;
            }
            case 2: {
                this.adaptToSingleInstanceTime_ = false;
                break;
            }
        }
    }

    private synchronized boolean isNullPreamble(int n) throws SQLException {
        this.checkForClosedCursor();
        this.checkForValidCursorPosition();
        try {
            if (this.isNullType(n - 1)) {
                this.wasNull_ = 1;
                return true;
            }
            this.wasNull_ = 2;
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ColumnIndexOutOfBoundsException(ErrorKey.columnIndexOutOfBounds__0__, n);
        }
    }

    private boolean isNullType(int n) {
        Object[] objectArray = (Object[])this.statement_.stmtHandle_.rows.get((int)(this.currentPosition_ - 1L));
        return objectArray[n] == null;
    }

    public synchronized URL getURL(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized URL getURL(String string) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateRef(int n, Ref ref) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateRef(String string, Ref ref) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBlob(int n, Blob blob) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateBlob(String string, Blob blob) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateClob(int n, Clob clob) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateClob(String string, Clob clob) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateArray(int n, java.sql.Array array) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized void updateArray(String string, java.sql.Array array) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }
}

