/*
 * Decompiled with CFR 0.152.
 */
package interbase.interclient;

import interbase.interclient.BatchSql;
import interbase.interclient.BatchSqlAbove14;
import interbase.interclient.BatchSqlBelow15;
import interbase.interclient.Connection;
import interbase.interclient.DriverNotCapableException;
import interbase.interclient.ErrorKey;
import interbase.interclient.EscapeProcessor;
import interbase.interclient.IBException;
import interbase.interclient.Ibase;
import interbase.interclient.InvalidArgumentException;
import interbase.interclient.InvalidOperationException;
import interbase.interclient.IscStmtHandle;
import interbase.interclient.IscTrHandle;
import interbase.interclient.ResultSet;
import interbase.interclient.XSQLDA;
import java.io.ByteArrayOutputStream;
import java.sql.BatchUpdateException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;

public class Statement
implements java.sql.Statement {
    int statementRef_ = 0;
    Connection connection_;
    ResultSet resultSet_ = null;
    Integer updateCountStack_ = null;
    ResultSet resultSetStack_ = null;
    boolean openOnClient_ = true;
    boolean openOnServer_ = false;
    int timeout_ = 0;
    int maxRows_ = 0;
    int maxFieldSize_ = 0;
    private int fetchSize_ = 200;
    boolean cancelable = false;
    private boolean isDdl_ = false;
    IBException sqlWarnings_ = null;
    protected boolean sqlWarningsCleared_ = false;
    String cursorName_;
    IscStmtHandle stmtHandle_ = null;
    int resultSetType_ = 1003;
    boolean escapeProcessingEnabled_ = true;
    BatchSql batchSql = null;
    EscapeProcessor escapeProcessor = new EscapeProcessor();
    private boolean cursorNameSet_ = false;
    int CLOSE_CURRENT_RESULT = 1;
    int KEEP_CURRENT_RESULT = 2;
    int CLOSE_ALL_RESULTS = 3;
    int SUCCESS_NO_INFO = -2;
    int EXECUTE_FAILED = -3;
    int RETURN_GENERATED_KEYS = 1;
    int NO_GENERATED_KEYS = 2;

    Statement(Connection connection) {
        this.connection_ = connection;
        this.cursorName_ = "";
    }

    void setCannedRows(ArrayList arrayList) {
        this.stmtHandle_ = new IscStmtHandle(arrayList, this.connection_.databaseMetaData_.ibMajorVersion_, this.connection_.databaseMetaData_.ibMinorVersion_);
    }

    void checkForClosedStatement() throws SQLException {
        if (!this.openOnClient_) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__statement_closed__);
        }
    }

    void checkForEmptySQL(String string) throws SQLException {
        if (string == null || "".equals(string)) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__sql_empty_or_null__);
        }
    }

    protected void finalize() throws Throwable {
        this.println("finalize:", this);
        if (this.openOnServer_) {
            this.close();
        }
        super.finalize();
    }

    public synchronized java.sql.ResultSet executeQuery(String string) throws SQLException {
        this.println("executeQuery: " + string, this);
        this.checkForClosedStatement();
        this.clearWarnings();
        if (this.resultSet_ != null) {
            this.resultSet_.close();
            this.resultSet_ = null;
            this.resultSetStack_ = null;
        }
        this.updateCountStack_ = null;
        this.checkForEmptySQL(string);
        if (this.escapeProcessingEnabled_) {
            EscapeProcessor escapeProcessor = new EscapeProcessor();
            string = escapeProcessor.doEscapeProcessing(string, this.connection_.getAttachmentSQLDialect());
        }
        this.remote_EXECUTE_QUERY_STATEMENT(string, false);
        this.openOnServer_ = true;
        this.resultSetStack_ = this.resultSet_;
        return this.resultSet_;
    }

    protected void allocateStatement() {
        try {
            if (this.stmtHandle_ == null) {
                if (this.resultSet_ != null) {
                    this.resultSet_.close();
                    this.resultSet_ = null;
                    this.resultSetStack_ = null;
                }
                this.stmtHandle_ = this.connection_.ibase_.getNewIscStmtHandle(this.connection_.databaseMetaData_.ibMajorVersion_, this.connection_.databaseMetaData_.ibMinorVersion_);
                this.sqlWarningsCleared_ = false;
                this.connection_.ibase_.iscDsqlAllocateStatement(this.connection_.db_, this.stmtHandle_, this.sqlWarnings_);
                this.println("allocated statement:", this);
                this.openOnServer_ = true;
            } else if (this.stmtHandle_.out_sqlda != null && this.stmtHandle_.out_sqlda.sqld > 0 && this.resultSet_ != null) {
                this.resultSet_.close();
                this.resultSet_ = null;
                this.resultSetStack_ = null;
                this.stmtHandle_.clearRows();
                this.stmtHandle_.clearSqlda();
                this.println("reuse statement:", this);
            } else if (this.cursorNameSet_) {
                this.connection_.ibase_.iscDsqlFreeStatement(this.stmtHandle_, 1, this.sqlWarnings_);
                this.cursorNameSet_ = false;
                this.println("close cursor:", this);
            }
            if (!"".equals(this.cursorName_)) {
                this.cursorNameSet_ = true;
                this.connection_.ibase_.iscDsqlSetCursorName(this.stmtHandle_, this.cursorName_, 0, this.sqlWarnings_);
                this.println("set cursor name: " + this.cursorName_, this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized IscStmtHandle getStmtHandle() {
        return this.stmtHandle_;
    }

    protected void remote_EXECUTE_QUERY_STATEMENT(String string, boolean bl) throws SQLException {
        try {
            XSQLDA xSQLDA;
            this.connection_.setTransaction();
            if (bl) {
                xSQLDA = this.stmtHandle_.getOutSqlda();
            } else {
                this.allocateStatement();
                xSQLDA = this.connection_.ibase_.iscDsqlPrepare(this.connection_.tra_, this.stmtHandle_, string, this.connection_.getAttachmentSQLDialect(), this.sqlWarnings_);
            }
            if (xSQLDA == null || xSQLDA.sqld <= 0) {
                if (this.resultSet_ != null) {
                    this.resultSet_.close();
                }
                throw new InvalidOperationException(ErrorKey.invalidOperation__execute_query_on_an_update_statement__);
            }
            this.run_execute_query(xSQLDA);
        }
        catch (IBException iBException) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
            }
            this.resultSet_ = null;
            this.resultSetStack_ = null;
            this.cancelable = false;
            throw new SQLException(iBException.getMessage(), iBException.getSQLState(), iBException.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
            }
            this.resultSet_ = null;
            this.resultSetStack_ = null;
            this.cancelable = false;
            throw sQLException;
        }
    }

    private void run_execute_query(XSQLDA xSQLDA) throws SQLException, IBException {
        this.cancelable = true;
        this.sqlWarningsCleared_ = false;
        if (this.stmtHandle_.getStmtType() == 8) {
            this.connection_.ibase_.iscDsqlExecute2(this.connection_.tra_, this.stmtHandle_, this.stmtHandle_.getInSqlda(), xSQLDA, this.sqlWarnings_);
        } else {
            this.connection_.ibase_.iscDsqlExecute(this.connection_.tra_, this.stmtHandle_, this.stmtHandle_.getInSqlda(), this.sqlWarnings_);
        }
        xSQLDA = this.stmtHandle_.getOutSqlda();
        if (this.stmtHandle_.getOutSqlda().sqld > 0) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
            }
            this.resultSet_ = new ResultSet(this, true, xSQLDA.sqld, xSQLDA, this.resultSetType_);
        }
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        this.println("executeUpdate: " + string, this);
        this.checkForClosedStatement();
        this.clearWarnings();
        if (this.resultSet_ != null) {
            this.resultSet_.close();
            this.resultSet_ = null;
            this.resultSetStack_ = null;
        }
        this.updateCountStack_ = null;
        this.checkForEmptySQL(string);
        if (this.escapeProcessingEnabled_) {
            EscapeProcessor escapeProcessor = new EscapeProcessor();
            string = escapeProcessor.doEscapeProcessing(string, this.connection_.getAttachmentSQLDialect());
        }
        int n = this.remote_EXECUTE_UPDATE_STATEMENT(string, false);
        this.openOnServer_ = true;
        this.resultSetStack_ = null;
        this.println("return from executeUpdate: " + n, this);
        return n;
    }

    public synchronized void executeBatchUpdate(ByteArrayOutputStream byteArrayOutputStream, int n, int[] nArray) throws SQLException {
        this.println("executeBatchUpdate: " + byteArrayOutputStream, this);
        this.checkForClosedStatement();
        this.clearWarnings();
        this.updateCountStack_ = null;
        this.connection_.setTransaction();
        this.connection_.ibase_.iscDsqlBatchExecuteImmed(this.connection_.db_, this.connection_.tra_, this.connection_.getAttachmentSQLDialect(), byteArrayOutputStream, nArray, this.sqlWarnings_);
        this.openOnServer_ = true;
        this.resultSetStack_ = null;
        this.println("return from executeUpdate: " + nArray, this);
        for (int i = 0; i < n; ++i) {
            this.println("update count returned" + nArray[i], this);
        }
    }

    private boolean checkCommitRollback(String string) throws SQLException {
        if ("COMMIT".equalsIgnoreCase(string)) {
            if (!this.connection_.getAutoCommit()) {
                this.connection_.commit();
            }
            return true;
        }
        if ("ROLLBACK".equalsIgnoreCase(string)) {
            if (!this.connection_.getAutoCommit()) {
                this.connection_.rollback();
            }
            return true;
        }
        return false;
    }

    protected int remote_EXECUTE_UPDATE_STATEMENT(String string, boolean bl) throws SQLException {
        try {
            XSQLDA xSQLDA;
            IscTrHandle iscTrHandle;
            if (this.checkCommitRollback(string)) {
                return 0;
            }
            if (!bl) {
                if (this.doDllStatement(string)) {
                    return 0;
                }
                this.connection_.setTransaction();
                iscTrHandle = this.connection_.tra_;
            } else if (this.isDdl_) {
                this.connection_.setDdlTransaction();
                iscTrHandle = this.connection_.traDdl_;
            } else {
                this.connection_.setTransaction();
                iscTrHandle = this.connection_.tra_;
            }
            if (bl) {
                xSQLDA = this.stmtHandle_.getOutSqlda();
            } else {
                this.allocateStatement();
                xSQLDA = this.connection_.ibase_.iscDsqlPrepare(iscTrHandle, this.stmtHandle_, string, this.connection_.getAttachmentSQLDialect(), this.sqlWarnings_);
            }
            if (xSQLDA.sqld > 0) {
                if (this.resultSet_ != null) {
                    this.resultSet_.close();
                    this.resultSet_ = null;
                    this.resultSetStack_ = null;
                }
                throw new InvalidArgumentException(ErrorKey.invalidOperation__execute_update_on_an_select_statement__);
            }
            return this.run_execute_update(xSQLDA, iscTrHandle);
        }
        catch (IBException iBException) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
            }
            this.resultSet_ = null;
            this.resultSetStack_ = null;
            throw new SQLException(iBException.getMessage(), iBException.getSQLState(), iBException.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
            }
            this.resultSet_ = null;
            this.resultSetStack_ = null;
            throw sQLException;
        }
    }

    private boolean doDllStatement(String string) throws IBException, SQLException {
        return false;
    }

    protected boolean isDdlStatement(String string) {
        this.isDdl_ = false;
        return false;
    }

    private int run_execute_update(XSQLDA xSQLDA, IscTrHandle iscTrHandle) throws SQLException {
        this.cancelable = true;
        this.sqlWarningsCleared_ = false;
        this.connection_.ibase_.iscDsqlExecute2(iscTrHandle, this.stmtHandle_, this.stmtHandle_.getInSqlda(), this.stmtHandle_.getOutSqlda(), this.sqlWarnings_);
        xSQLDA = this.stmtHandle_.getOutSqlda();
        if (xSQLDA.sqld > 0) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
                this.resultSet_ = null;
                this.resultSetStack_ = null;
            }
            throw new InvalidArgumentException(ErrorKey.invalidOperation__execute_update_on_an_select_statement__);
        }
        if (this.stmtHandle_.getStmtType() == 5) {
            if (this.isDdl_) {
                this.connection_.remoteCommitDdl(true);
            } else {
                this.connection_.remote_COMMIT(true);
            }
            boolean bl = false;
            return 0;
        }
        byte[] byArray = new byte[]{23, 1};
        this.sqlWarningsCleared_ = false;
        SqlInfo sqlInfo = new SqlInfo(this.connection_.ibase_.iscDsqlSqlInfo(this.stmtHandle_, byArray.length, byArray, 128, this.sqlWarnings_), this.connection_.ibase_);
        int n = sqlInfo.getTotalChangesCount();
        if (this.connection_.getAutoCommit()) {
            try {
                this.connection_.ibase_.iscCommitRetaining(iscTrHandle, this.sqlWarnings_);
            }
            catch (IBException iBException) {
                this.connection_.ibase_.iscRollbackRetaining(iscTrHandle, this.sqlWarnings_);
            }
        }
        this.cancelable = false;
        if (this.resultSet_ != null) {
            this.resultSet_.close();
            this.resultSet_ = null;
            this.resultSetStack_ = null;
        }
        byArray = null;
        sqlInfo = null;
        return n;
    }

    public synchronized void close() throws SQLException {
        this.println("CLOSE", this);
        if (!this.openOnClient_) {
            return;
        }
        if (this.openOnServer_ || this.stmtHandle_ != null) {
            this.remote_CLOSE_STATEMENT();
        }
        this.local_Close();
    }

    void local_Close() throws SQLException {
        this.clearBatch();
        if (this.resultSet_ != null) {
            this.resultSet_.local_Close();
        }
        this.openOnClient_ = false;
        this.connection_.openStatements_.removeElement(this);
        this.resultSet_ = null;
        this.resultSetStack_ = null;
        this.sqlWarnings_ = null;
        this.connection_ = null;
    }

    void remote_CLOSE_STATEMENT() throws SQLException {
        try {
            if (this.stmtHandle_ != null) {
                if (this.resultSet_ != null) {
                    this.resultSet_.close();
                    this.resultSet_ = null;
                    this.resultSetStack_ = null;
                }
                this.sqlWarningsCleared_ = false;
                this.println("free statement:", this);
                this.connection_.ibase_.iscDsqlFreeStatement(this.stmtHandle_, 2, this.sqlWarnings_);
                this.stmtHandle_.clearSqlda();
                this.stmtHandle_.clearRows();
                this.stmtHandle_ = null;
                this.openOnServer_ = false;
            }
        }
        catch (IBException iBException) {
            throw new SQLException(iBException.getMessage(), iBException.getSQLState(), iBException.getErrorCode());
        }
    }

    void remote_CANCEL_STATEMENT() throws SQLException {
        try {
            this.sqlWarningsCleared_ = false;
            this.connection_.ibase_.iscDsqlFreeStatement(this.stmtHandle_, 4, this.sqlWarnings_);
        }
        catch (IBException iBException) {
            throw new SQLException(iBException.getMessage(), iBException.getSQLState(), iBException.getErrorCode());
        }
    }

    public synchronized int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize_;
    }

    public synchronized void setMaxFieldSize(int n) throws SQLException {
        this.checkForClosedStatement();
        if (n < 0) {
            IBException iBException = new IBException(225544006);
            throw iBException.getSQLExceptionFromIBE();
        }
        this.maxFieldSize_ = n;
    }

    public synchronized int getMaxRows() throws SQLException {
        return this.maxRows_;
    }

    public synchronized void setMaxRows(int n) throws SQLException {
        this.checkForClosedStatement();
        if (n < 0) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__negative_max_rows__);
        }
        this.maxRows_ = n;
    }

    public synchronized void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkForClosedStatement();
        this.escapeProcessingEnabled_ = bl;
        this.batchSql.setEscapeProcessorEnabled(bl);
    }

    public synchronized int getQueryTimeout() throws SQLException {
        return this.timeout_;
    }

    public synchronized void setQueryTimeout(int n) throws SQLException {
        this.checkForClosedStatement();
        this.timeout_ = n;
    }

    public void cancel() throws SQLException {
        this.checkForClosedStatement();
        if (!this.cancelable) {
            throw new InvalidOperationException(ErrorKey.invalidOperation__statement_notcancelable__);
        }
        this.remote_CANCEL_STATEMENT();
        this.cancelable = false;
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        if (this.sqlWarnings_ == null) {
            if (this.sqlWarningsCleared_) {
                return null;
            }
            return new SQLWarning();
        }
        return new SQLWarning(this.sqlWarnings_.getMessage());
    }

    public synchronized void clearWarnings() throws SQLException {
        this.sqlWarnings_ = null;
        this.sqlWarningsCleared_ = true;
    }

    public synchronized void setCursorName(String string) throws SQLException {
        this.println("setCursorName: " + string, this);
        this.checkForClosedStatement();
        this.cursorName_ = string == null ? "" : string;
    }

    public synchronized String getCursorName() throws SQLException {
        this.println("getCursorName: " + this.cursorName_, this);
        return this.cursorName_;
    }

    public synchronized boolean execute(String string) throws SQLException {
        this.println("execute: " + string, this);
        this.checkForClosedStatement();
        this.clearWarnings();
        if (this.resultSet_ != null) {
            this.resultSet_.close();
            this.resultSet_ = null;
            this.resultSetStack_ = null;
        }
        this.updateCountStack_ = null;
        this.checkForEmptySQL(string);
        if (this.escapeProcessingEnabled_) {
            EscapeProcessor escapeProcessor = new EscapeProcessor();
            string = escapeProcessor.doEscapeProcessing(string, this.connection_.getAttachmentSQLDialect());
        }
        boolean bl = this.remote_EXECUTE_STATEMENT(string, false);
        this.openOnServer_ = true;
        this.resultSetStack_ = this.resultSet_;
        return bl;
    }

    protected boolean remote_EXECUTE_STATEMENT(String string, boolean bl) throws SQLException {
        try {
            XSQLDA xSQLDA;
            IscTrHandle iscTrHandle;
            if (this.checkCommitRollback(string)) {
                return false;
            }
            if (!bl && this.doDllStatement(string)) {
                this.updateCountStack_ = new Integer(0);
                return false;
            }
            if (!this.isDdl_) {
                this.connection_.setTransaction();
                iscTrHandle = this.connection_.tra_;
            } else {
                this.connection_.setDdlTransaction();
                iscTrHandle = this.connection_.traDdl_;
            }
            if (bl) {
                xSQLDA = this.stmtHandle_.getOutSqlda();
            } else {
                this.allocateStatement();
                xSQLDA = this.connection_.ibase_.iscDsqlPrepare(iscTrHandle, this.stmtHandle_, string, this.connection_.getAttachmentSQLDialect(), this.sqlWarnings_);
            }
            if (xSQLDA != null && xSQLDA.sqld > 0) {
                this.run_execute_query(xSQLDA);
                return true;
            }
            this.updateCountStack_ = new Integer(this.run_execute_update(xSQLDA, iscTrHandle));
            return false;
        }
        catch (IBException iBException) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
            }
            this.resultSet_ = null;
            this.resultSetStack_ = null;
            this.updateCountStack_ = null;
            this.cancelable = false;
            throw new SQLException(iBException.getMessage(), iBException.getSQLState(), iBException.getErrorCode());
        }
        catch (SQLException sQLException) {
            if (this.resultSet_ != null) {
                this.resultSet_.close();
            }
            this.resultSet_ = null;
            this.resultSetStack_ = null;
            this.updateCountStack_ = null;
            throw sQLException;
        }
    }

    public synchronized java.sql.ResultSet getResultSet() throws SQLException {
        this.checkForClosedStatement();
        return this.resultSetStack_;
    }

    public synchronized int getUpdateCount() throws SQLException {
        this.checkForClosedStatement();
        if (this.updateCountStack_ == null) {
            return -1;
        }
        int n = this.updateCountStack_;
        this.updateCountStack_ = null;
        return n;
    }

    public synchronized boolean getMoreResults() throws SQLException {
        this.checkForClosedStatement();
        if (this.resultSet_ != null) {
            this.resultSet_.close();
        }
        this.resultSetStack_ = null;
        return false;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
        }
    }

    public synchronized int getFetchDirection() throws SQLException {
        if (this.resultSet_ != null) {
            return this.resultSet_.getFetchDirection();
        }
        return 1000;
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.checkForClosedStatement();
        if (n < 0) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__negative_row_fetch_size__);
        }
        if (this.maxRows_ > 0 && n > this.maxRows_) {
            throw new InvalidArgumentException(ErrorKey.invalidArgument__fetch_size_exceeds_max_rows__);
        }
        this.fetchSize_ = n;
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.fetchSize_;
    }

    public synchronized int getResultSetConcurrency() throws SQLException {
        if (this.resultSet_ != null) {
            return this.resultSet_.getConcurrency();
        }
        return this.connection_.resultSetConcurrency_;
    }

    public synchronized int getResultSetType() throws SQLException {
        if (this.resultSet_ != null) {
            return this.resultSet_.getType();
        }
        return this.resultSetType_;
    }

    public synchronized void addBatch(String string) throws SQLException {
        this.println("addBatch: " + string, this);
        this.checkForEmptySQL(string);
        if (this.batchSql == null) {
            this.batchSql = this.createBatchSql(this.connection_.ibase_.getDbai().getNegotiatedProtocol(), this, this.escapeProcessor);
        }
        this.batchSql.addBatch(string);
    }

    BatchSql createBatchSql(int n, Statement statement, EscapeProcessor escapeProcessor) {
        BatchSql batchSql = n > 14 ? new BatchSqlAbove14(statement, escapeProcessor) : new BatchSqlBelow15(statement, escapeProcessor);
        return batchSql;
    }

    public synchronized void clearBatch() throws SQLException {
        this.println("clearBatch: ", this);
        if (this.batchSql != null) {
            this.batchSql.clear();
            this.batchSql = null;
        }
    }

    public synchronized int[] executeBatch() throws BatchUpdateException, SQLException {
        return this.batchSql.executeBatch();
    }

    public synchronized java.sql.Connection getConnection() throws SQLException {
        return this.connection_;
    }

    final void println(String string, Statement statement) {
        DriverManager.println("  \"  :  \"  :" + string + " [" + statement + "]");
    }

    public synchronized boolean getMoreResults(int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized java.sql.ResultSet getGeneratedKeys() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int executeUpdate(String string, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean execute(String string, int n) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    public synchronized int getResultSetHoldability() throws SQLException {
        throw new DriverNotCapableException(ErrorKey.driverNotCapable__jdbc2_not_yet_supported__);
    }

    static class SqlInfo {
        private int statementType = -1;
        private int insertCount;
        private int updateCount;
        private int deleteCount;
        private int selectCount;

        SqlInfo(byte[] byArray, Ibase ibase) {
            byte by;
            int n = 0;
            block10: while ((by = byArray[n++]) != 1) {
                int n2 = Ibase.iscVaxInteger(byArray, n, 2);
                n += 2;
                switch (by) {
                    case 23: {
                        byte by2;
                        while ((by2 = byArray[n++]) != 1) {
                            int n3 = Ibase.iscVaxInteger(byArray, n, 2);
                            n += 2;
                            switch (by2) {
                                case 14: {
                                    this.insertCount = Ibase.iscVaxInteger(byArray, n, n3);
                                    break;
                                }
                                case 15: {
                                    this.updateCount = Ibase.iscVaxInteger(byArray, n, n3);
                                    break;
                                }
                                case 16: {
                                    this.deleteCount = Ibase.iscVaxInteger(byArray, n, n3);
                                    break;
                                }
                                case 13: {
                                    this.selectCount = Ibase.iscVaxInteger(byArray, n, n3);
                                    break;
                                }
                            }
                            n += n3;
                        }
                        continue block10;
                    }
                    case 21: {
                        this.statementType = Ibase.iscVaxInteger(byArray, n, n2);
                        n += n2;
                        continue block10;
                    }
                }
                n += n2;
            }
        }

        int getStatementType() {
            return this.statementType;
        }

        int getInsertCount() {
            return this.insertCount;
        }

        int getUpdateCount() {
            return this.updateCount;
        }

        int getDeleteCount() {
            return this.deleteCount;
        }

        int getSelectCount() {
            return this.selectCount;
        }

        int getTotalChangesCount() {
            return this.insertCount + this.deleteCount + this.updateCount;
        }
    }
}

