--
-- PostgreSQL database dump
--

-- Dumped from database version 9.5.14
-- Dumped by pg_dump version 9.5.14

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: logs; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA logs;


ALTER SCHEMA logs OWNER TO postgres;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: accept_guarantee(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.accept_guarantee(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	
BEGIN
	---accept guarantee request
	IF($3 = '1')THEN
		UPDATE guarantees SET guarantee_accepted = true, accepted_date = current_date, 	is_active = true, 
		approve_status = 'Approved',action_date = current_date
		WHERE (guarantee_id = $1::integer) 
		AND (approve_status = 'Draft') 
		AND (is_active = false);
		
		msg := 'Guarantee Request Accepted';
	
	END IF;

	----reject guarantee request
	IF($3 = '2')THEN
		UPDATE guarantees SET guarantee_accepted = false, accepted_date = current_date, is_active = false, 
		approve_status = 'Rejected',action_date = current_date
		WHERE (guarantee_id = $1::integer) 
		AND (approve_status = 'Draft') 
		AND (is_active = false);
		
		msg := 'Guarantee Request Rejected';
	
	END IF;

	----Drop guarantee request
	IF($3 = '3')THEN
		DELETE FROM guarantees WHERE (guarantee_id = $1::integer);		
		msg := 'Guarantee Request Droped Permanently...!!';	
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.accept_guarantee(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: add_client(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.add_client(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	rec						RECORD;
	v_lead_id				integer;
	v_entity_id				integer;
	v_entity_type_id		integer;
	v_industry_id			integer;
	v_sales_id				integer;
	v_account_id			integer;
	v_lead_category_id		integer;
	v_country_id			varchar(2);
	msg 					varchar(120);
BEGIN

	msg := null;

	IF($3 = '1')THEN
		SELECT org_id, business_id, business_name, business_address, city,
			state, country_id, number_of_employees, telephone, website,
			primary_contact, job_title, primary_email
		INTO rec
		FROM leads WHERE lead_id = $1::integer;
		
		SELECT entity_id INTO v_entity_id
		FROM entitys WHERE user_name = lower(trim(rec.primary_email));
		
		SELECT max(entity_type_id) INTO v_entity_type_id
		FROM entity_types
		WHERE (org_id = rec.org_id) AND (use_key_id = 2);
		
		SELECT account_id INTO v_account_id
		FROM default_accounts 
		WHERE (org_id = rec.org_id) AND (use_key_id = 51);

		IF(rec.business_id is not null)THEN
			msg := 'The business is already added.';
		ELSIF(rec.primary_email is null)THEN
			RAISE EXCEPTION 'You must enter an email address';
		ELSIF(v_entity_id is not null)THEN
			RAISE EXCEPTION 'You must have a unique email address';
		ELSIF(v_entity_type_id is null)THEN
			RAISE EXCEPTION 'You must and entity type with use key being 2';
		ELSE
			v_entity_id := nextval('entitys_entity_id_seq');
			INSERT INTO entitys (entity_id, org_id, entity_type_id, account_id, entity_name, attention, user_name, primary_email,  function_role, use_key_id)
			VALUES (v_entity_id, rec.org_id, v_entity_type_id, v_account_id, rec.business_name, rec.primary_contact, lower(trim(rec.primary_email)), lower(trim(rec.primary_email)), 'client', 2);
			
			INSERT INTO address (address_name, sys_country_id, table_name, org_id, table_id, premises, town, phone_number, website, is_default) 
			VALUES (rec.business_name, rec.country_id, 'entitys', rec.org_id, v_entity_id, rec.business_address, rec.city, rec.telephone, rec.website, true);
			
			UPDATE leads SET business_id = v_entity_id WHERE (lead_id = $1::integer);
			
			msg := 'You have added the client';
		END IF;
	ELSIF($3 = '2')THEN
		SELECT a.org_id, a.entity_id, a.entity_type_id, a.org_id, a.entity_name, a.user_name, a.primary_email, 
			a.primary_telephone, a.attention, b.sys_country_id, b.address_name, 
			b.post_office_box, b.postal_code, b.premises, b.town, b.website INTO rec
		FROM entitys a LEFT JOIN
			(SELECT address_id, address_type_id, sys_country_id, org_id, address_name, 
			table_id, post_office_box, postal_code, premises, 
			street, town, phone_number, mobile, email, website
			FROM address
			WHERE (is_default = true) AND (table_name = 'entitys')) b
		ON a.entity_id = b.table_id
		WHERE (a.entity_id = $1::integer);
		
		SELECT lead_id INTO v_lead_id
		FROM leads 
		WHERE (business_id = rec.entity_id) OR (lower(trim(business_name)) = lower(trim(rec.entity_name)));
		
		IF(v_lead_id is not null)THEN
			msg := 'The business is already added.';
		ELSE		
			SELECT min(industry_id) INTO v_industry_id
			FROM industry WHERE (org_id = rec.org_id);
			
			SELECT min(entity_id) INTO v_sales_id
			FROM entitys
			WHERE (org_id = rec.org_id) AND (use_key_id = 1);
			
			SELECT min(lead_category_id) INTO v_lead_category_id
			FROM lead_categorys
			WHERE (org_id = rec.org_id);
			
			v_country_id := rec.sys_country_id;
			IF(v_country_id is null)THEN
				SELECT default_country_id INTO v_country_id
				FROM orgs
				WHERE (org_id = rec.org_id);
			END IF;
				
			INSERT INTO leads(industry_id, entity_id, lead_category_id, org_id, business_id, business_name, 
				business_address, city, country_id, 
				telephone, primary_contact, primary_email, website)
			VALUES (v_industry_id, v_sales_id, v_lead_category_id, rec.org_id, rec.entity_id, rec.entity_name,
				rec.premises, rec.town, rec.sys_country_id,
				rec.primary_telephone, rec.attention, rec.primary_email, rec.website);
			
            msg := 'You have added the lead';
		END IF;
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.add_client(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: add_periods(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.add_periods(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_org_id			integer;
	v_period_id			integer;
	msg					varchar(120);
BEGIN

	SELECT org_id INTO v_org_id
	FROM fiscal_years
	WHERE (fiscal_year_id = $1::int);
	
	UPDATE periods SET fiscal_year_id = fiscal_years.fiscal_year_id
	FROM fiscal_years WHERE (fiscal_years.fiscal_year_id = $1::int)
		AND (fiscal_years.fiscal_year_start <= start_date) AND (fiscal_years.fiscal_year_end >= end_date);
	
	SELECT period_id INTO v_period_id
	FROM periods
	WHERE (fiscal_year_id = $1::int) AND (org_id = v_org_id);
	
	IF(v_period_id is null)THEN
		INSERT INTO periods (fiscal_year_id, org_id, start_date, end_date)
		SELECT $1::int, v_org_id, period_start, CAST(period_start + CAST('1 month' as interval) as date) - 1
		FROM (SELECT CAST(generate_series(fiscal_year_start, fiscal_year_end, '1 month') as date) as period_start
			FROM fiscal_years WHERE fiscal_year_id = $1::int) as a;
		msg := 'Months for the year generated';
	ELSE
		msg := 'Months year already created';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.add_periods(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: add_sys_login(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.add_sys_login(character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_sys_login_id			integer;
	v_entity_id				integer;
BEGIN
	SELECT entity_id INTO v_entity_id
	FROM entitys WHERE user_name = $1;

	v_sys_login_id := nextval('sys_logins_sys_login_id_seq');

	INSERT INTO sys_logins (sys_login_id, entity_id)
	VALUES (v_sys_login_id, v_entity_id);

	return v_sys_login_id;
END;
$_$;


ALTER FUNCTION public.add_sys_login(character varying) OWNER TO postgres;

--
-- Name: add_tx_link(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.add_tx_link(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
BEGIN
	
	INSERT INTO transaction_details (transaction_id, org_id, item_id, quantity, amount, tax_amount, narrative, details)
	SELECT CAST($3 as integer), org_id, item_id, quantity, amount, tax_amount, narrative, details
	FROM transaction_details
	WHERE (transaction_detail_id = CAST($1 as integer));

	INSERT INTO transaction_links (org_id, transaction_detail_id, transaction_detail_to, quantity, amount)
	SELECT org_id, transaction_detail_id, currval('transaction_details_transaction_detail_id_seq'), quantity, amount
	FROM transaction_details
	WHERE (transaction_detail_id = CAST($1 as integer));

	return 'DONE';
END;
$_$;


ALTER FUNCTION public.add_tx_link(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: af_upd_transaction_details(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.af_upd_transaction_details() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_amount					real;
	v_tax_amount				real;
BEGIN

	IF(TG_OP = 'DELETE')THEN
		SELECT SUM(quantity * (amount + tax_amount) * ((100 - discount) / 100)), 
			SUM(quantity *  tax_amount * ((100 - discount) / 100)) 
			INTO v_amount, v_tax_amount
		FROM transaction_details WHERE (transaction_id = OLD.transaction_id);
		IF(v_amount is null)THEN v_amount := 0; END IF;
		IF(v_tax_amount is null)THEN v_tax_amount := 0; END IF;
		
		UPDATE transactions SET transaction_amount = v_amount, transaction_tax_amount = v_tax_amount
		WHERE (transaction_id = OLD.transaction_id);	
	ELSE
		SELECT SUM(quantity * (amount + tax_amount) * ((100 - discount) / 100)), 
			SUM(quantity *  tax_amount * ((100 - discount) / 100)) 
			INTO v_amount, v_tax_amount
		FROM transaction_details WHERE (transaction_id = NEW.transaction_id);
		
		UPDATE transactions SET transaction_amount = v_amount, transaction_tax_amount = v_tax_amount
		WHERE (transaction_id = NEW.transaction_id);	
	END IF;

	RETURN NULL;
END;
$$;


ALTER FUNCTION public.af_upd_transaction_details() OWNER TO postgres;

--
-- Name: aft_account_activity(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.aft_account_activity() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	reca 						RECORD;
	v_account_activity_id		integer;
	v_product_id				integer;
	v_use_key_id				integer;
	v_exchange_rate				real;
	v_account_credit			real;
	v_account_debit				real;
	v_actual_balance			real;
	v_total_debits				real;
BEGIN

	IF(NEW.deposit_account_id is not null) THEN
		SELECT product_id INTO v_product_id
		FROM deposit_accounts WHERE deposit_account_id = NEW.deposit_account_id;
	END IF;
	IF(NEW.loan_id is not null) THEN 
		SELECT product_id INTO v_product_id
		FROM loans WHERE loan_id = NEW.loan_id;
	END IF;
	
	SELECT use_key_id INTO v_use_key_id
	FROM activity_types WHERE (activity_type_id = NEW.activity_type_id);
	
	--- Generate the countra entry for a transfer
	IF(NEW.transfer_account_id is not null)THEN
		SELECT account_activity_id INTO v_account_activity_id
		FROM account_activity
		WHERE (deposit_account_id = NEW.transfer_account_id)
			AND (link_activity_id = NEW.link_activity_id);
			
		IF(v_account_activity_id is null)THEN
			IF(v_use_key_id = 250)THEN
				IF(NEW.invert_rate = true)THEN v_exchange_rate := 1 / NEW.trading_rate;
				ELSE v_exchange_rate := NEW.trading_rate; END IF;
				v_account_credit := NEW.account_debit / v_exchange_rate;
				v_account_debit := NEW.account_credit / v_exchange_rate;
			ELSE
				v_exchange_rate := 1;
				v_account_credit := NEW.account_debit;
				v_account_debit := NEW.account_credit;
			END IF;
			INSERT INTO account_activity (deposit_account_id, transfer_account_id, transfer_loan_id, activity_type_id,
				org_id, entity_id, link_activity_id, activity_date, value_date,
				activity_status_id, account_credit, account_debit, activity_frequency_id, commodity_trade_id,
				exchange_rate, trading_rate, mean_rate)
			VALUES (NEW.transfer_account_id, NEW.deposit_account_id, NEW.loan_id, NEW.activity_type_id,
				NEW.org_id, NEW.entity_id, NEW.link_activity_id, NEW.activity_date, NEW.value_date,
				NEW.activity_status_id, v_account_credit, v_account_debit, 1, NEW.commodity_trade_id,
				v_exchange_rate, NEW.trading_rate, NEW.mean_rate);
		END IF;
	END IF;
	
	--- Generate the countra entry for a loan
	IF(NEW.transfer_loan_id is not null)THEN
		SELECT account_activity_id INTO v_account_activity_id
		FROM account_activity
		WHERE (loan_id = NEW.transfer_loan_id)
			AND (link_activity_id = NEW.link_activity_id);
			
		IF(v_account_activity_id is null)THEN
			INSERT INTO account_activity (loan_id, transfer_account_id, transfer_loan_id, activity_type_id,
				org_id, entity_id, link_activity_id, activity_date, value_date,
				activity_status_id, account_credit, account_debit, activity_frequency_id)
			VALUES (NEW.transfer_loan_id, NEW.deposit_account_id, NEW.loan_id, NEW.activity_type_id,
				NEW.org_id, NEW.entity_id, NEW.link_activity_id, NEW.activity_date, NEW.value_date,
				NEW.activity_status_id, NEW.account_debit, NEW.account_credit, 1);
		END IF;
	END IF;

	--- Posting the charge on the transfer transaction
	IF((v_use_key_id < 200) AND (NEW.account_debit > 0))THEN
		INSERT INTO account_activity (deposit_account_id, activity_type_id, activity_frequency_id,
			activity_status_id, entity_id, org_id, transfer_account_no,
			link_activity_id, activity_date, value_date, account_debit)
		SELECT NEW.deposit_account_id, account_definations.charge_activity_id, account_definations.activity_frequency_id,
			1, NEW.entity_id, NEW.org_id, account_definations.account_number,
			NEW.link_activity_id, current_date, current_date, 
			(account_definations.fee_amount + account_definations.fee_ps * NEW.account_debit / 100)
			
		FROM account_definations INNER JOIN products ON account_definations.product_id = products.product_id
		WHERE (account_definations.product_id = v_product_id)
			AND (account_definations.activity_frequency_id = 1) 
			AND (account_definations.activity_type_id = NEW.activity_type_id) 
			AND (account_definations.is_active = true) AND (account_definations.has_charge = true)
			AND (account_definations.start_date < current_date);
	END IF;
	
	--- compute for Commited amounts taking the date into consideration
	IF((NEW.account_credit > 0) AND (NEW.activity_status_id = 1))THEN
		SELECT sum((account_credit - account_debit) * exchange_rate) INTO v_actual_balance
		FROM account_activity 
		WHERE (deposit_account_id = NEW.deposit_account_id) AND (activity_status_id < 3) AND (value_date <= NEW.value_date);
		IF(v_actual_balance is null)THEN v_actual_balance := 0; END IF;
		SELECT sum(account_debit * exchange_rate) INTO v_total_debits
		FROM account_activity 
		WHERE (deposit_account_id = NEW.deposit_account_id) AND (activity_status_id = 3) AND (value_date <= NEW.value_date);
		IF(v_total_debits is null)THEN v_total_debits := 0; END IF;
		v_actual_balance := v_actual_balance - v_total_debits;
			
		FOR reca IN SELECT account_activity_id, activity_status_id, link_activity_id, 
				(account_debit * exchange_rate) as debit_amount
			FROM account_activity 
			WHERE (deposit_account_id = NEW.deposit_account_id) AND (activity_status_id = 4) AND (activity_date <= NEW.value_date)
				AND (account_credit = 0) AND (account_debit > 0)
			ORDER BY activity_date, account_activity_id
		LOOP
			IF(v_actual_balance > reca.debit_amount)THEN
				UPDATE account_activity SET activity_status_id = 1 WHERE link_activity_id = reca.link_activity_id;
				v_actual_balance := v_actual_balance - reca.debit_amount;
			END IF;
		END LOOP;
	END IF;
	
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.aft_account_activity() OWNER TO postgres;

--
-- Name: aft_commodity_trades(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.aft_commodity_trades() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_activity_type_id			integer;
BEGIN

	IF((OLD.approve_status = 'Completed') AND (NEW.approve_status = 'Approved'))THEN
		SELECT activity_type_id INTO v_activity_type_id
		FROM activity_types WHERE (use_key_id = NEW.use_key_id);
	
		IF(NEW.use_key_id = 210)THEN			----- Commodity purchase
			INSERT INTO account_activity (activity_date, value_date, deposit_account_id, transfer_account_no, 
				account_debit, activity_type_id, activity_frequency_id, activity_status_id, 
				commodity_trade_id, entity_id, org_id) 
			VALUES (NEW.trade_date, NEW.trade_date, NEW.deposit_account_id, NEW.transfer_account_no, 
				(NEW.unit_credit * NEW.price), v_activity_type_id, 1, 1, 
				NEW.commodity_trade_id, NEW.entity_id, NEW.org_id);
		END IF;
		IF(NEW.use_key_id = 220)THEN			----- Commodity sale
			INSERT INTO account_activity (activity_date, value_date, deposit_account_id, transfer_account_no, 
				account_credit, activity_type_id, activity_frequency_id, activity_status_id, 
				commodity_trade_id, entity_id, org_id) 
			VALUES (NEW.trade_date, NEW.trade_date, NEW.deposit_account_id, NEW.transfer_account_no, 
				(NEW.unit_debit * NEW.price), v_activity_type_id, 1, 1, 
				NEW.commodity_trade_id, NEW.entity_id, NEW.org_id);
		END IF;
		IF(NEW.use_key_id = 230)THEN			----- Commodity trade
			INSERT INTO account_activity (activity_date, value_date, deposit_account_id, transfer_account_no, 
				account_credit, activity_type_id, activity_frequency_id, activity_status_id, 
				commodity_trade_id, entity_id, org_id) 
			VALUES (NEW.trade_date, NEW.trade_date, NEW.deposit_account_id, NEW.transfer_account_no, 
				(NEW.unit_debit * NEW.price), v_activity_type_id, 1, 1, 
				NEW.commodity_trade_id, NEW.entity_id, NEW.org_id);
				
			INSERT INTO commodity_trades (deposit_account_id, transfer_account_id,
				commodity_id, entity_id, use_key_id, org_id, link_activity_id,
				unit_debit, unit_credit, price, trade_date, approve_status)
			VALUES (NEW.transfer_account_id, NEW.deposit_account_id,
				NEW.commodity_id, NEW.entity_id, NEW.use_key_id, NEW.org_id, NEW.link_activity_id,
				NEW.unit_credit, NEW.unit_debit, NEW.price, NEW.trade_date, NEW.approve_status);
		END IF;
	END IF;
	
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.aft_commodity_trades() OWNER TO postgres;

--
-- Name: aft_entitys(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.aft_entitys() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	IF(NEW.entity_type_id is not null) THEN
		INSERT INTO entity_subscriptions (org_id, entity_type_id, entity_id)
		VALUES (NEW.org_id, NEW.entity_type_id, NEW.entity_id);
	END IF;

	INSERT INTO entity_values (org_id, entity_id, entity_field_id)
	SELECT NEW.org_id, NEW.entity_id, entity_field_id
	FROM entity_fields
	WHERE (org_id = NEW.org_id) AND (is_active = true);

	INSERT INTO sys_access_entitys (entity_id, sys_access_level_id, org_id)
	SELECT NEW.entity_id, sys_access_level_id, org_id
	FROM sys_access_levels
	WHERE (org_id = NEW.org_id) AND (use_key_id = NEW.use_key_id);

	RETURN NULL;
END;
$$;


ALTER FUNCTION public.aft_entitys() OWNER TO postgres;

--
-- Name: aft_etf_members(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.aft_etf_members() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
	IF((NEW.table_code = 301) AND (NEW.is_active = true))THEN
		INSERT INTO e_fields (et_field_id, org_id, table_code, table_id)
		SELECT NEW.et_field_id, NEW.org_id, NEW.table_code, member_id
		FROM members
		WHERE (org_id = NEW.org_id) AND (is_active = true);
	END IF;
	
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.aft_etf_members() OWNER TO postgres;

--
-- Name: aft_loans_processing(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.aft_loans_processing() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	reca 					RECORD;
	msg						varchar(120);
BEGIN
	
	SELECT loan_id, loan_status INTO reca FROM loans WHERE loan_status = 'Processing';
	IF((reca.loan_status = 'Processing'))THEN
		INSERT INTO loan_approval_levels ( org_id,loan_approval_id,loan_id,narrative)
		SELECT org_id,loan_approval_id,NEW.loan_id,'For your Approval'
		FROM loan_approval
		WHERE org_id = NEW.org_id AND is_active = true;
	END IF;
	
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.aft_loans_processing() OWNER TO postgres;

--
-- Name: aft_members(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.aft_members() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_entity_type_id		integer;
	v_entity_id				integer;
	v_user_name				varchar(32);
	v_message				varchar(32);
BEGIN

	IF((TG_OP = 'INSERT') AND (NEW.business_account = 0))THEN
		SELECT entity_type_id INTO v_entity_type_id
		FROM entity_types 
		WHERE (org_id = NEW.org_id) AND (use_key_id = 100);
		v_entity_id := nextval('entitys_entity_id_seq');
		v_user_name := 'OR' || NEW.org_id || 'EN' || v_entity_id;
		
		INSERT INTO entitys (entity_id, org_id, use_key_id, entity_type_id, member_id, entity_name, user_name, primary_email, primary_telephone, function_role)
		VALUES (v_entity_id, NEW.org_id, 100, v_entity_type_id, NEW.member_id, NEW.member_name, v_user_name, lower(trim(NEW.member_email)), NEW.telephone_number, 'members');
		
		---email login credentials to new members
		INSERT INTO sys_emailed (org_id, sys_email_id, table_id, table_name, email_type)
		SELECT org_id, sys_email_id, NEW.entity_id, 'entitys', 1
		FROM sys_emails
		WHERE (use_type = 2) AND (org_id = NEW.org_id);			
	END IF;

	--Additional fields for the members
	INSERT INTO e_fields (et_field_id, org_id, table_code, table_id)
		SELECT et_fields.et_field_id, et_fields.org_id, et_fields.table_code, NEW.entity_id
			FROM et_fields LEFT JOIN 
				(SELECT et_field_id FROM e_fields WHERE (org_id = NEW.org_id) AND (table_id = NEW.entity_id)) as ef
					ON et_fields.et_field_id = ef.et_field_id
					WHERE (et_fields.org_id = NEW.org_id) AND (et_fields.table_code = 301) AND (ef.et_field_id is null)
					AND (et_fields.is_active = true);
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.aft_members() OWNER TO postgres;

--
-- Name: apply_approval(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.apply_approval(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	v_deposit_account_id		integer;
	v_principal_amount			real;
	v_repayment_amount			real;
	v_maximum_repayments		integer;
	v_repayment_period			integer;
	v_contribution_amount		real;
	v_guaranteed_amount		    real;
	v_total_amount			    real;
	v_collateral_amount 		real;
BEGIN

	IF($3 = '1')THEN
		UPDATE members SET approve_status = 'Completed' 
		WHERE (member_id = $1::integer) AND (approve_status = 'Draft');

		msg := 'Applied for member approval';
	ELSIF($3 = '2')THEN
		UPDATE deposit_accounts SET approve_status = 'Completed' 
		WHERE (deposit_account_id = $1::integer) AND (approve_status = 'Draft');
		
		msg := 'Applied for account approval';
	ELSIF($3 = '4')THEN
		UPDATE guarantees SET approve_status = 'Completed' 
		WHERE (guarantee_id = $1::integer) AND (approve_status = 'Draft');
		
		msg := 'Applied for guarantees approval';
	ELSIF($3 = '5')THEN
		UPDATE collaterals SET approve_status = 'Completed' 
		WHERE (collateral_id = $1::integer) AND (approve_status = 'Draft');
		
		msg := 'Applied for collateral approval';
	ELSIF($3 = '7')THEN
		UPDATE transfer_beneficiary SET approve_status = 'Approved' 
		WHERE (transfer_beneficiary_id = $1::integer) AND (approve_status = 'Completed');
		
		msg := 'Applied for beneficiary application submited';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.apply_approval(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: archiving(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.archiving(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	
BEGIN
	---- deactivating the account product
	IF($3 = '1')THEN
		UPDATE deposit_accounts SET is_active = false, details = ('archive/deactivated account product on'|| ' :- ' ||current_date)
		WHERE (deposit_account_id = $1::integer) AND (approve_status = 'Approved') AND (is_active = true);

		msg := 'Account Product deactivated';
	
	END IF;

	--- Activating the account product
	IF($3 = '2')THEN
		UPDATE deposit_accounts SET is_active = true, details = ('Activated account product on'|| ' :- ' ||current_date)
		WHERE (deposit_account_id = $1::integer) AND (approve_status = 'Approved') AND (is_active = false);

		msg := 'Account Product Activated';
	
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.archiving(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: archiving_loan_setting(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.archiving_loan_setting(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	
BEGIN
----DEACTIVATING
	---- deactivating loan configuration
	IF($3 = '1')THEN
		UPDATE loan_configs SET is_active = false, details = ('archived/deactivated on'|| ' :- ' ||current_date)
		WHERE (loan_config_id = $1::integer) AND (is_active = true);

		msg := 'Archived/deactivated Successfully...';
	
	END IF;

	--- deactivating loan approval
	IF($3 = '2')THEN
		UPDATE loan_approval SET is_active = false, details = ('archived/deactivated on'|| ' :- ' ||current_date)
		WHERE (loan_approval_id = $1::integer) AND (is_active = true);

		msg := 'Archived/deactivated Successfully...';
	
	END IF;

----ACTIVATING
	---- activating loan configuration
	IF($3 = '3')THEN
		UPDATE loan_configs SET is_active = true, details = ('activated on'|| ' :- ' ||current_date)
		WHERE (loan_config_id = $1::integer) AND (is_active = false);

		msg := 'Activated Successfully...';
	
	END IF;

	--- activating loan approval
	IF($3 = '4')THEN
		UPDATE loan_approval SET is_active = true, details = ('activated on'|| ' :- ' ||current_date)
		WHERE (loan_approval_id = $1::integer) AND (is_active = false);

		msg := 'Activated Successfully...';
	
	END IF;

------LOAN APPROVALS
	---processing approval
	IF($3 = '5')THEN
		UPDATE loan_approval SET processing_approval = true, details = ('Processing Approval Activated on'|| ' :- ' ||current_date)
		WHERE (loan_approval_id = $1::integer) AND (processing_approval = false);

		msg := 'Processing Approval Activated Successfully...';
	
	END IF;

	IF($3 = '6')THEN
		UPDATE loan_approval SET processing_approval = false, details = ('Processing Approval Deactivated on'|| ' :- ' ||current_date)
		WHERE (loan_approval_id = $1::integer) AND (processing_approval = true);

		msg := 'Processing Approval Deactivated Successfully...';
	
	END IF;
	-------------
	---final approval
	IF($3 = '7')THEN
		UPDATE loan_approval SET final_approval = true, details = ('Final Approval Activated on'|| ' :- ' ||current_date)
		WHERE (loan_approval_id = $1::integer) AND (final_approval = false);

		msg := 'Final Approval Activated Successfully...';
	
	END IF;

	IF($3 = '8')THEN
		UPDATE loan_approval SET final_approval = false, details = ('Final Approval Deactivated on'|| ' :- ' ||current_date)
		WHERE (loan_approval_id = $1::integer) AND (final_approval = true);

		msg := 'Final Approval Deactivated Successfully...';
	
	END IF;

	---------
	---activating and deactivating
	IF($3 = '9')THEN
		UPDATE loan_approval SET is_active = true, details = ('Activated on'|| ' :- ' ||current_date)
		WHERE (loan_approval_id = $1::integer) AND (is_active = false);

		msg := 'Activated Successfully...';
	
	END IF;

	IF($3 = '10')THEN
		UPDATE loan_approval SET is_active = false, details = ('Deactivated on'|| ' :- ' ||current_date)
		WHERE (loan_approval_id = $1::integer) AND (is_active = true);

		msg := 'Deactivated Successfully...';
	
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.archiving_loan_setting(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: budget_process(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.budget_process(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	rec 	RECORD;
	recb 	RECORD;

	nb_id 	INTEGER;
	ntrx	INTEGER;
	msg 	varchar(120);
BEGIN
	SELECT budget_id, org_id, fiscal_year_id, department_id, link_budget_id, budget_type, budget_name, approve_status INTO rec
	FROM budgets
	WHERE (budget_id = CAST($1 as integer));
	
	IF($3 = '1') THEN
		IF(rec.approve_status = 'Draft') THEN
			UPDATE budgets SET approve_status = 'Completed', entity_id = CAST($2 as integer)
			WHERE budget_id = rec.budget_id;
		END IF;
		msg := 'Transaction completed.';
	ELSIF (($3 = '2') OR ($3 = '3')) THEN
		IF(rec.approve_status = 'Approved') THEN
			IF(rec.link_budget_id is null) THEN
				nb_id := create_budget(rec.budget_id, rec.fiscal_year_id, CAST($3 as int));
				UPDATE budgets SET link_budget_id = nb_id WHERE budget_id = rec.budget_id;
				msg := 'The budget created.';
			ELSE
				msg := 'Another budget has already been created';
			END IF;
		ELSE
			msg := 'The budget needs to be aprroved first';
		END IF;
	ELSIF (($3 = '4')) THEN
		SELECT transaction_id, approve_status INTO recb 
		FROM vw_budget_lines WHERE (budget_line_id = CAST($1 as integer));

		IF(recb.approve_status != 'Approved') THEN
			msg := 'The budget neets approval first.';
		ELSIF(recb.transaction_id is null) THEN
			INSERT INTO transactions (org_id, currency_id, entity_id, department_id, transaction_type_id, transaction_date)
			SELECT orgs.org_id, orgs.currency_id, CAST($2 as integer), vw_budget_lines.department_id, 16, current_date
			FROM vw_budget_lines INNER JOIN orgs ON vw_budget_lines.org_id = orgs.org_id
			WHERE (budget_line_id = CAST($1 as integer));

			ntrx := currval('transactions_transaction_id_seq');

			INSERT INTO transaction_details (org_id, transaction_id, account_id, item_id, quantity, amount, tax_amount, narrative, details)
			SELECT org_id, ntrx, account_id, item_id, quantity, amount, tax_amount, narrative, details
			FROM vw_budget_lines
			WHERE (budget_line_id = CAST($1 as integer));

			UPDATE budget_lines SET transaction_id = ntrx WHERE (budget_line_id = CAST($1 as integer));

			msg := 'Requisition Created.';
		ELSE
			msg := 'Requisition had been created from this budget.';
		END IF;
	ELSE
		msg := 'Transaction alerady completed.';
	END IF;

	return msg;
END;
$_$;


ALTER FUNCTION public.budget_process(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: change_password(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.change_password(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	old_password 		varchar(64);
	v_entity_id			integer;
	v_pass_change		varchar(120);
	msg					varchar(120);
BEGIN
	msg := 'Password Error';
	v_entity_id := $1::int;

	SELECT Entity_password INTO old_password
	FROM entitys WHERE (entity_id = v_entity_id);

	IF ($2 = '0') THEN
		v_pass_change := first_password();
		UPDATE entitys SET first_password = v_pass_change, Entity_password = md5(v_pass_change)
		WHERE (entity_id = v_entity_id);
		msg := 'Password Changed';
	ELSIF (old_password = md5($2)) THEN
		UPDATE entitys SET Entity_password = md5($3) WHERE (entity_id = v_entity_id);
		msg := 'Password Changed';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.change_password(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: change_password(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.change_password(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	old_password 		varchar(64);
	v_entity_id			integer;
	v_pass_change		varchar(120);
	msg					varchar(120);
BEGIN
	msg := 'Password Error';
	v_entity_id := $1::int;

	SELECT Entity_password INTO old_password
	FROM entitys WHERE (entity_id = v_entity_id);

	IF ($3 = '1') THEN
		v_pass_change := first_password();
		UPDATE entitys SET first_password = v_pass_change, Entity_password = md5(v_pass_change)
		WHERE (entity_id = v_entity_id);
		msg := 'Password Changed';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.change_password(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: close_periods(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.close_periods(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg 					varchar(120);
BEGIN
	
	IF(v_period_id is null)THEN
		INSERT INTO periods (fiscal_year_id, org_id, start_date, end_date)
		SELECT $1::int, v_org_id, period_start, CAST(period_start + CAST('1 month' as interval) as date) - 1
		FROM (SELECT CAST(generate_series(fiscal_year_start, fiscal_year_end, '1 month') as date) as period_start
			FROM fiscal_years WHERE fiscal_year_id = $1::int) as a;
		msg := 'Months for the year generated';
	ELSE
		msg := 'Months year already created';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.close_periods(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: close_year(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.close_year(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	trx_date		DATE;
	periodid		INTEGER;
	journalid		INTEGER;
	profit_acct		INTEGER;
	retain_acct		INTEGER;
	rec				RECORD;
	msg				varchar(120);
BEGIN
	SELECT fiscal_year_id, fiscal_year_start, fiscal_year_end, year_opened, year_closed INTO rec
	FROM fiscal_years
	WHERE (fiscal_year_id = CAST($1 as integer));

	SELECT account_id INTO profit_acct FROM default_accounts WHERE default_account_id = 1;
	SELECT account_id INTO retain_acct FROM default_accounts WHERE default_account_id = 2;
	
	trx_date := CAST($1 || '-12-31' as date);
	periodid := get_open_period(trx_date);
	IF(periodid is null) THEN
		msg := 'Cannot post. No active period to post.';
	ELSIF(rec.year_opened = false)THEN
		msg := 'Cannot post. The year is not opened.';
	ELSIF(rec.year_closed = true)THEN
		msg := 'Cannot post. The year is closed.';
	ELSE
		INSERT INTO journals (period_id, journal_date, narrative, year_closing)
		VALUES (periodid, trx_date, 'End of year closing', false);
		journalid := currval('journals_journal_id_seq');

		INSERT INTO gls (journal_id, account_id, debit, credit, gl_narrative)
		SELECT journalid, account_id, dr_amount, cr_amount, 'Account Balance'
		FROM ((SELECT account_id, sum(bal_credit) as dr_amount, sum(bal_debit) as cr_amount
		FROM vw_ledger
		WHERE (chat_type_id > 3) AND (fiscal_year_id = rec.fiscal_year_id) AND (acc_balance <> 0)
		GROUP BY account_id)
		UNION
		(SELECT profit_acct, (CASE WHEN sum(bal_debit) > sum(bal_credit) THEN sum(bal_debit - bal_credit) ELSE 0 END),
		(CASE WHEN sum(bal_debit) < sum(bal_credit) THEN sum(bal_credit - bal_debit) ELSE 0 END)
		FROM vw_ledger
		WHERE (chat_type_id > 3) AND (fiscal_year_id = rec.fiscal_year_id) AND (acc_balance <> 0))) as a;

		msg := process_journal(CAST(journalid as varchar),'0','0');

		INSERT INTO journals (period_id, journal_date, narrative, year_closing)
		VALUES (periodid, trx_date, 'Retained Earnings', false);
		journalid := currval('journals_journal_id_seq');

		INSERT INTO gls (journal_id, account_id, debit, credit, gl_narrative)
		SELECT journalid, profit_acct, (CASE WHEN sum(bal_debit) < sum(bal_credit) THEN sum(bal_credit - bal_debit) ELSE 0 END),
			(CASE WHEN sum(bal_debit) > sum(bal_credit) THEN sum(bal_debit - bal_credit) ELSE 0 END), 'Retained Earnings'
		FROM vw_ledger
		WHERE (account_id = profit_acct) AND (fiscal_year_id = rec.fiscal_year_id) AND (acc_balance <> 0);

		INSERT INTO gls (journal_id, account_id, debit, credit, gl_narrative)
		SELECT journalid, retain_acct, (CASE WHEN sum(bal_debit) > sum(bal_credit) THEN sum(bal_debit - bal_credit) ELSE 0 END),
			(CASE WHEN sum(bal_debit) < sum(bal_credit) THEN sum(bal_credit - bal_debit) ELSE 0 END), 'Retained Earnings'
		FROM vw_ledger
		WHERE (account_id = profit_acct) AND (fiscal_year_id = rec.fiscal_year_id) AND (acc_balance <> 0);

		msg := process_journal(CAST(journalid as varchar),'0','0');

		UPDATE fiscal_years SET year_closed = true WHERE fiscal_year_id = rec.fiscal_year_id;
		UPDATE periods SET period_closed = true WHERE fiscal_year_id = rec.fiscal_year_id;
	END IF;

	return msg;
END;
$_$;


ALTER FUNCTION public.close_year(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: complete_transaction(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.complete_transaction(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	rec RECORD;
	bankacc INTEGER;
	msg varchar(120);
BEGIN
	SELECT transaction_id, transaction_type_id, transaction_status_id, bank_account_id INTO rec
	FROM transactions
	WHERE (transaction_id = CAST($1 as integer));

	IF($3 = '2') THEN
		UPDATE transactions SET transaction_status_id = 4 
		WHERE transaction_id = rec.transaction_id;
		msg := 'Transaction Archived';
	ELSIF($3 = '1') AND (rec.transaction_status_id = 1)THEN
		IF((rec.transaction_type_id = 7) or (rec.transaction_type_id = 8)) THEN
			IF(rec.bank_account_id is null)THEN
				msg := 'Transaction completed.';
				RAISE EXCEPTION 'You need to add the bank account to receive the funds';
			ELSE
				UPDATE transactions SET transaction_status_id = 2, approve_status = 'Completed'
				WHERE transaction_id = rec.transaction_id;
				msg := 'Transaction completed.';
			END IF;
		ELSE
			UPDATE transactions SET transaction_status_id = 2, approve_status = 'Completed'
			WHERE transaction_id = rec.transaction_id;
			msg := 'Transaction completed.';
		END IF;
	ELSE
		msg := 'Transaction alerady completed.';
	END IF;

	return msg;
END;
$_$;


ALTER FUNCTION public.complete_transaction(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: compute_loans(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.compute_loans(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	reca 						RECORD;
	v_period_id					integer;
	v_org_id					integer;
	v_start_date				date;
	v_end_date					date;
	v_account_activity_id		integer;
	v_penalty_formural			varchar(320);
	v_penalty_account			varchar(32);
	v_penalty_amount			real;
	v_activity_type_id			integer;
	v_reducing_payments			boolean;
	v_interest_formural			varchar(320);
	v_interest_account			varchar(32);
	v_interest_amount			real;
	v_repayment_amount			real;
	v_repayment_balance			real;
	v_available_balance			real;
	v_activity_status_id		integer;
	msg							varchar(120);
BEGIN

	SELECT period_id, org_id, start_date, end_date
		INTO v_period_id, v_org_id, v_start_date, v_end_date
	FROM periods
	WHERE (period_id = $1::integer) AND (opened = true) AND (activated = true) AND (closed = false);

	FOR reca IN SELECT currency_id, loan_id, product_id, activity_frequency_id,
			account_number, disburse_account, principal_amount, interest_rate,
			repayment_period, repayment_amount, disbursed_date, actual_balance
		FROM vw_loans
		WHERE (org_id = v_org_id) AND (approve_status = 'Approved') AND (actual_balance > 0) AND (disbursed_date < v_start_date)
	LOOP
	
		---- Compute for penalty
		v_repayment_amount := 0;
		v_account_activity_id := null;
		v_penalty_amount := 0;
		SELECT penalty_methods.activity_type_id, penalty_methods.formural, penalty_methods.account_number 
			INTO v_activity_type_id, v_penalty_formural, v_penalty_account
		FROM penalty_methods INNER JOIN products ON penalty_methods.penalty_method_id = products.penalty_method_id
		WHERE (products.product_id = reca.product_id);
		IF(v_penalty_formural is not null)THEN
			v_penalty_formural := replace(v_penalty_formural, 'period_id', v_period_id::text);
			EXECUTE 'SELECT ' || v_penalty_formural || ' FROM loans WHERE loan_id = ' || reca.loan_id 
			INTO v_penalty_amount;
			
			SELECT account_activity_id INTO v_account_activity_id
			FROM account_activity
			WHERE (period_id = v_period_id) AND (activity_type_id = v_activity_type_id) AND (loan_id = reca.loan_id);
		END IF;
		IF((v_penalty_amount > 0) AND (v_account_activity_id is null))THEN
			INSERT INTO account_activity (period_id, loan_id, transfer_account_no, activity_type_id,
				org_id, activity_date, value_date,
				activity_frequency_id, activity_status_id, account_credit, account_debit)
			VALUES (v_period_id, reca.loan_id, v_penalty_account, v_activity_type_id,
				v_org_id, v_end_date, v_end_date,
				1, 1, 0, v_penalty_amount);
			v_repayment_amount := v_penalty_amount;
		END IF;
	
		---- Compute for intrest
		v_account_activity_id := null;
		v_interest_amount := 0;
		SELECT interest_methods.activity_type_id, interest_methods.formural, interest_methods.account_number, interest_methods.reducing_payments
			INTO v_activity_type_id, v_interest_formural, v_interest_account, v_reducing_payments
		FROM interest_methods INNER JOIN products ON interest_methods.interest_method_id = products.interest_method_id
		WHERE (products.product_id = reca.product_id);
		IF(v_interest_formural is not null)THEN
			v_interest_formural := replace(v_interest_formural, 'period_id', v_period_id::text);
			EXECUTE 'SELECT ' || v_interest_formural || ' FROM loans WHERE loan_id = ' || reca.loan_id 
			INTO v_interest_amount;
			
			SELECT account_activity_id INTO v_account_activity_id
			FROM account_activity
			WHERE (period_id = v_period_id) AND (activity_type_id = v_activity_type_id) AND (loan_id = reca.loan_id);
		END IF;
		IF((v_interest_amount > 0) AND (v_account_activity_id is null))THEN
			INSERT INTO account_activity (period_id, loan_id, transfer_account_no, activity_type_id,
				org_id, activity_date, value_date,
				activity_frequency_id, activity_status_id, account_credit, account_debit)
			VALUES (v_period_id, reca.loan_id, v_interest_account, v_activity_type_id,
				v_org_id, v_end_date, v_end_date,
				1, 1, 0, v_interest_amount);
			IF(v_reducing_payments = true)THEN
				v_repayment_amount := v_repayment_amount + v_interest_amount;
			END IF;
		END IF;
		
		--- Computer for repayment
		v_account_activity_id := null;
		SELECT activity_type_id INTO v_activity_type_id
		FROM vw_account_definations 
		WHERE (product_id = reca.product_id) AND (use_key_id = 107);
		SELECT account_activity_id INTO v_account_activity_id
		FROM account_activity
		WHERE (period_id = v_period_id) AND (activity_type_id = v_activity_type_id) AND (loan_id = reca.loan_id);
		IF((v_account_activity_id is null) AND (v_activity_type_id is not null))THEN
			v_repayment_balance := v_repayment_amount + reca.actual_balance;
			v_repayment_amount := v_repayment_amount + reca.repayment_amount;
			v_activity_status_id := 1;
			
			SELECT available_balance INTO v_available_balance
			FROM vw_deposit_accounts
			WHERE (account_number = reca.disburse_account);
			IF(v_repayment_amount > v_repayment_balance)THEN v_repayment_amount := v_repayment_balance; END IF;
			IF(v_available_balance < v_repayment_amount)THEN v_activity_status_id := 4; END IF;
			
			INSERT INTO account_activity (period_id, loan_id, transfer_account_no, activity_type_id,
				org_id, activity_date, value_date,
				activity_frequency_id, activity_status_id, account_credit, account_debit)
			VALUES (v_period_id, reca.loan_id, reca.disburse_account, v_activity_type_id,
				v_org_id, v_end_date, v_end_date,
				1, v_activity_status_id, v_repayment_amount, 0);
		END IF;
	END LOOP;

	msg := 'loans computed';

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.compute_loans(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: compute_savings(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.compute_savings(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	reca 						RECORD;
	v_period_id					integer;
	v_org_id					integer;
	v_start_date				date;
	v_end_date					date;
	v_account_activity_id		integer;
	v_penalty_formural			varchar(320);
	v_penalty_account			varchar(32);
	v_penalty_amount			real;
	v_activity_type_id			integer;
	v_reducing_balance			boolean;
	v_interest_formural			varchar(320);
	v_interest_account			varchar(32);
	v_interest_amount			real;
	msg							varchar(120);
BEGIN

	SELECT period_id, org_id, start_date, end_date
		INTO v_period_id, v_org_id, v_start_date, v_end_date
	FROM periods
	WHERE (period_id = $1::integer) AND (opened = true) AND (activated = true) AND (closed = false);

	FOR reca IN SELECT currency_id, deposit_account_id, product_id, activity_frequency_id, credit_limit,
		minimum_balance, maximum_balance, interest_rate
	FROM vw_deposit_accounts
	WHERE (org_id = v_org_id) AND (approve_status = 'Approved') AND (is_active = true) AND (opening_date < v_start_date)
	LOOP

		---- Compute for penalty
		v_account_activity_id := null;
		v_penalty_amount := 0;
		SELECT penalty_methods.activity_type_id, penalty_methods.formural, penalty_methods.account_number 
			INTO v_activity_type_id, v_penalty_formural, v_penalty_account
		FROM penalty_methods INNER JOIN products ON penalty_methods.penalty_method_id = products.penalty_method_id
		WHERE (products.product_id = reca.product_id);
		IF(v_penalty_formural is not null)THEN
			v_penalty_formural := replace(v_penalty_formural, 'period_id', v_period_id::text);
			EXECUTE 'SELECT ' || v_penalty_formural || ' FROM deposit_accounts WHERE deposit_account_id = ' || reca.deposit_account_id 
			INTO v_penalty_amount;
			
			SELECT account_activity_id INTO v_account_activity_id
			FROM account_activity
			WHERE (period_id = v_period_id) AND (activity_type_id = v_activity_type_id) AND (deposit_account_id = reca.deposit_account_id);
		END IF;
		IF((v_penalty_amount > 0) AND (v_account_activity_id is null))THEN
			INSERT INTO account_activity (period_id, deposit_account_id, transfer_account_no, activity_type_id,
				org_id, activity_date, value_date,
				activity_frequency_id, activity_status_id, account_credit, account_debit)
			VALUES (v_period_id, reca.deposit_account_id, v_interest_account, v_activity_type_id,
				v_org_id, v_end_date, v_end_date,
				1, 1, 0, v_penalty_amount);
		END IF;
	
		---- Compute for intrest
		v_account_activity_id := null;
		v_interest_amount := 0;
		SELECT interest_methods.activity_type_id, interest_methods.formural, interest_methods.account_number, interest_methods.reducing_balance
			INTO v_activity_type_id, v_interest_formural, v_interest_account, v_reducing_balance
		FROM interest_methods INNER JOIN products ON interest_methods.interest_method_id = products.interest_method_id
		WHERE (products.product_id = reca.product_id);
		IF(v_interest_formural is not null)THEN
			v_interest_formural := replace(v_interest_formural, 'period_id', v_period_id::text);
			EXECUTE 'SELECT ' || v_interest_formural || ' FROM deposit_accounts WHERE deposit_account_id = ' || reca.deposit_account_id 
			INTO v_interest_amount;
			
			SELECT account_activity_id INTO v_account_activity_id
			FROM account_activity
			WHERE (period_id = v_period_id) AND (activity_type_id = v_activity_type_id) AND (deposit_account_id = reca.deposit_account_id);
		END IF;
		IF((v_interest_amount > 0) AND (v_account_activity_id is null))THEN
			INSERT INTO account_activity (period_id, deposit_account_id, transfer_account_no, activity_type_id,
				org_id, activity_date, value_date,
				activity_frequency_id, activity_status_id, account_credit, account_debit)
			VALUES (v_period_id, reca.deposit_account_id, v_interest_account, v_activity_type_id,
				v_org_id, v_end_date, v_end_date,
				1, 1, v_interest_amount, 0);
		END IF;
	END LOOP;

	msg := 'Savings computed.....';

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.compute_savings(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: copy_transaction(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.copy_transaction(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg varchar(120);
BEGIN

	INSERT INTO transactions (org_id, department_id, entity_id, currency_id, transaction_type_id, transaction_date, order_number, payment_terms, job, narrative, details, notes)
	SELECT org_id, department_id, entity_id, currency_id, transaction_type_id, CURRENT_DATE, order_number, payment_terms, job, narrative, details, notes
	FROM transactions
	WHERE (transaction_id = CAST($1 as integer));

	INSERT INTO transaction_details (org_id, transaction_id, account_id, item_id, quantity, amount, tax_amount, narrative, details, discount)
	SELECT org_id, currval('transactions_transaction_id_seq'), account_id, item_id, quantity, amount, tax_amount, narrative, details, discount
	FROM transaction_details
	WHERE (transaction_id = CAST($1 as integer));

	msg := 'Transaction Copied';

	return msg;
END;
$_$;


ALTER FUNCTION public.copy_transaction(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: cpy_trx_ledger(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.cpy_trx_ledger(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_ledger_date				timestamp;
	last_date					timestamp;
	v_start						integer;
	v_end						integer;
	v_inteval					interval;
	msg							varchar(120);
BEGIN

	SELECT max(payment_date)::timestamp INTO last_date
	FROM transactions
	WHERE (to_char(payment_date, 'YYYY.MM') = $1);
	v_start := EXTRACT(YEAR FROM last_date) * 12 + EXTRACT(MONTH FROM last_date);
	
	SELECT max(payment_date)::timestamp INTO v_ledger_date
	FROM transactions;
	v_end := EXTRACT(YEAR FROM v_ledger_date) * 12 + EXTRACT(MONTH FROM v_ledger_date) + 1;
	v_inteval :=  ((v_end - v_start) || ' months')::interval;

	IF ($3 = '1') THEN
		INSERT INTO transactions(ledger_type_id, entity_id, bank_account_id, 
				currency_id, journal_id, org_id, exchange_rate, tx_type, payment_date, 
				transaction_amount, transaction_tax_amount, reference_number, 
				narrative, transaction_type_id, transaction_date)
		SELECT ledger_type_id, entity_id, bank_account_id, 
			currency_id, journal_id, org_id, exchange_rate, tx_type, (payment_date + v_inteval), 
			transaction_amount, transaction_tax_amount, reference_number,
			narrative, transaction_type_id, (transaction_date  + v_inteval)
		FROM transactions
		WHERE (tx_type is not null) AND (to_char(payment_date, 'YYYY.MM') = $1);

		msg := 'Appended a new month';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.cpy_trx_ledger(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: cpy_trx_transaction(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.cpy_trx_transaction(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_inteval					interval;
	msg							varchar(120);
BEGIN
	
	IF ($3 = '1') THEN
		v_inteval :=  '1 month'::interval;
		
		INSERT INTO transactions(ledger_type_id, entity_id, bank_account_id, 
				currency_id, journal_id, org_id, exchange_rate, tx_type, payment_date, 
				transaction_amount, transaction_tax_amount, reference_number, 
				narrative, transaction_type_id, transaction_date)
		SELECT ledger_type_id, entity_id, bank_account_id, 
			currency_id, journal_id, org_id, exchange_rate, tx_type, (payment_date + v_inteval), 
			transaction_amount, transaction_tax_amount, reference_number,
			narrative, transaction_type_id, (transaction_date  + v_inteval)
		FROM transactions
		WHERE (transaction_id = $1::int);

		msg := 'Appended a new month';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.cpy_trx_transaction(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: create_budget(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.create_budget(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	rec 	RECORD;
	
	nb_id 	INTEGER;
	p_id	INTEGER;
	p_date	DATE;
BEGIN
	INSERT INTO budgets (budget_type, org_id, fiscal_year_id, department_id, entity_id, budget_name)
	SELECT $3, org_id, fiscal_year_id, department_id, entity_id, budget_name
	FROM budgets
	WHERE (budget_id = $1);

	nb_id := currval('budgets_budget_id_seq');

	FOR rec IN SELECT org_id, period_id, account_id, item_id, spend_type, quantity, amount, tax_amount, income_budget, narrative
	FROM budget_lines WHERE (budget_id =  $1) ORDER BY period_id LOOP
		IF(rec.spend_type = 1)THEN
			INSERT INTO budget_lines (budget_id, period_id, org_id, account_id, item_id, quantity, amount, tax_amount, income_budget, narrative)
			SELECT nb_id, period_id, rec.org_id, rec.account_id, rec.item_id, rec.quantity, rec.amount, rec.tax_amount, rec.income_budget, rec.narrative
			FROM periods
			WHERE (fiscal_year_id = $2);
		ELSIF(rec.spend_type = 2)THEN
			FOR i IN 0..3 LOOP
				SELECT start_date + (i*3 || ' month')::INTERVAL INTO p_date 
				FROM periods WHERE (period_id = rec.period_id);
				SELECT period_id INTO p_id
				FROM periods WHERE (start_date <= p_date) AND (end_date >= p_date);

				IF(p_id is not null)THEN
					INSERT INTO budget_lines (budget_id, period_id, org_id, account_id, item_id, quantity, amount, tax_amount, income_budget, narrative)
					VALUES(nb_id, p_id, rec.org_id, rec.account_id, rec.item_id, rec.quantity, rec.amount, rec.tax_amount, rec.income_budget, rec.narrative);
				END IF;
			END LOOP;
		ELSE
			INSERT INTO budget_lines (budget_id, period_id, org_id, account_id, item_id, quantity, amount, tax_amount, income_budget, narrative)
			VALUES(nb_id, rec.period_id, rec.org_id, rec.account_id, rec.item_id, rec.quantity, rec.amount, rec.tax_amount, rec.income_budget, rec.narrative);
		END IF;
	END LOOP;

	RETURN nb_id;
END;
$_$;


ALTER FUNCTION public.create_budget(integer, integer, integer) OWNER TO postgres;

--
-- Name: curr_base_returns(date, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.curr_base_returns(date, date) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT COALESCE(sum(base_credit - base_debit), 0)
	FROM vw_gls
	WHERE (chat_type_id > 3) AND (posted = true) AND (year_closing = false)
		AND (journal_date >= $1) AND (journal_date <= $2);
$_$;


ALTER FUNCTION public.curr_base_returns(date, date) OWNER TO postgres;

--
-- Name: curr_returns(date, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.curr_returns(date, date) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT COALESCE(sum(credit - debit), 0)
	FROM vw_gls
	WHERE (chat_type_id > 3) AND (posted = true) AND (year_closing = false)
		AND (journal_date >= $1) AND (journal_date <= $2);
$_$;


ALTER FUNCTION public.curr_returns(date, date) OWNER TO postgres;

--
-- Name: default_currency(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.default_currency(character varying) RETURNS integer
    LANGUAGE sql
    AS $_$
	SELECT orgs.currency_id
	FROM orgs INNER JOIN entitys ON orgs.org_id = entitys.org_id
	WHERE (entitys.entity_id = CAST($1 as integer));
$_$;


ALTER FUNCTION public.default_currency(character varying) OWNER TO postgres;

--
-- Name: email_credentials(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.email_credentials(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_entity_id			integer;
	v_org_id			integer;
	v_sys_email_id		integer;
	msg					varchar(120);
BEGIN
	SELECT entity_id, org_id INTO v_entity_id, v_org_id
	FROM entitys WHERE (entity_id = $1::int);

	SELECT sys_email_id INTO v_sys_email_id
	FROM sys_emails WHERE (use_type = 2) AND (org_id = v_org_id);

	IF(v_sys_email_id is null)THEN
		msg := 'Ensure you have an email template setup';
	ELSE
		INSERT INTO sys_emailed (org_id, sys_email_id, table_id, table_name)
		VALUES(v_org_id, v_sys_email_id, v_entity_id, 'entitys');

		msg := 'Emailed the credentials';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.email_credentials(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: email_to_username(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.email_to_username(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_entity_id			integer;
	v_email				varchar(120);
	v_user_name			varchar(120);
	msg					varchar(120);
BEGIN
	msg := 'Error changing email to username';

	SELECT entity_id, trim(lower(primary_email)) INTO v_entity_id, v_email
	FROM entitys WHERE (entity_id = $1::int);

	SELECT user_name INTO v_user_name
	FROM entitys WHERE (trim(lower(user_name)) = v_email);

	IF(v_email is null)THEN
		msg := 'Ensure you have an email entered';
	ELSIF(v_user_name is not null)THEN
		msg := 'There is an existing user with that email address as username';
	ELSE
		UPDATE entitys SET user_name = v_email WHERE entity_id = v_entity_id;
		msg := 'Email address updated to username';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.email_to_username(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: emailed(integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.emailed(integer, character varying) RETURNS void
    LANGUAGE sql
    AS $_$
	UPDATE sys_emailed SET emailed = true WHERE (sys_emailed_id = CAST($2 as int));
$_$;


ALTER FUNCTION public.emailed(integer, character varying) OWNER TO postgres;

--
-- Name: first_password(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.first_password() RETURNS character varying
    LANGUAGE plpgsql
    AS $$
DECLARE
	rnd integer;
	passchange varchar(12);
BEGIN
	passchange := trunc(random()*1000);
	rnd := trunc(65+random()*25);
	passchange := passchange || chr(rnd);
	passchange := passchange || trunc(random()*1000);
	rnd := trunc(65+random()*25);
	passchange := passchange || chr(rnd);
	rnd := trunc(65+random()*25);
	passchange := passchange || chr(rnd);

	RETURN passchange;
END;
$$;


ALTER FUNCTION public.first_password() OWNER TO postgres;

--
-- Name: get_acct(integer, date, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_acct(integer, date, date) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT sum(gls.debit - gls.credit)
	FROM gls INNER JOIN journals ON gls.journal_id = journals.journal_id
	WHERE (gls.account_id = $1) AND (journals.posted = true) AND (journals.year_closing = false)
		AND (journals.journal_date >= $2) AND (journals.journal_date <= $3);
$_$;


ALTER FUNCTION public.get_acct(integer, date, date) OWNER TO postgres;

--
-- Name: get_active_loan_amount(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_active_loan_amount(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
    SELECT COALESCE(sum(principal_amount), 0)::integer
	FROM loans
	WHERE (approve_status = 'Approved') AND (member_id = $1);
$_$;


ALTER FUNCTION public.get_active_loan_amount(integer) OWNER TO postgres;

--
-- Name: get_active_loans(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_active_loans(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
    SELECT COALESCE(count(loan_id), 0)::integer
	FROM loans
	WHERE (approve_status = 'Approved') AND (member_id = $1);
$_$;


ALTER FUNCTION public.get_active_loans(integer) OWNER TO postgres;

--
-- Name: get_applied_loan_amount(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_applied_loan_amount(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
    SELECT COALESCE(sum(principal_amount), 0)::integer
	FROM loans
	WHERE (member_id = $1) AND loan_status != 'Draft';
$_$;


ALTER FUNCTION public.get_applied_loan_amount(integer) OWNER TO postgres;

--
-- Name: get_applied_loans(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_applied_loans(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
    SELECT COALESCE(count(loan_id), 0)::integer
	FROM loans
	WHERE (member_id = $1);
$_$;


ALTER FUNCTION public.get_applied_loans(integer) OWNER TO postgres;

--
-- Name: get_balance(integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_balance(integer, character varying) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT COALESCE(sum(exchange_rate * (debit_amount - credit_amount)), 0)
	FROM vw_trx
	WHERE (vw_trx.approve_status = 'Approved')
		AND (vw_trx.for_posting = true)
		AND (vw_trx.entity_id = $1)
		AND (vw_trx.transaction_date < $2::date);
$_$;


ALTER FUNCTION public.get_balance(integer, character varying) OWNER TO postgres;

--
-- Name: get_balance(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_balance(integer, integer, character varying) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT COALESCE(sum(debit_amount - credit_amount), 0)
	FROM vw_trx
	WHERE (vw_trx.approve_status = 'Approved')
		AND (vw_trx.for_posting = true)
		AND (vw_trx.entity_id = $1)
		AND (vw_trx.currency_id = $2)
		AND (vw_trx.transaction_date < $3::date);
$_$;


ALTER FUNCTION public.get_balance(integer, integer, character varying) OWNER TO postgres;

--
-- Name: get_base_acct(integer, date, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_base_acct(integer, date, date) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT sum(gls.debit * journals.exchange_rate - gls.credit * journals.exchange_rate) 
	FROM gls INNER JOIN journals ON gls.journal_id = journals.journal_id
	WHERE (gls.account_id = $1) AND (journals.posted = true) AND (journals.year_closing = false)
		AND (journals.journal_date >= $2) AND (journals.journal_date <= $3);
$_$;


ALTER FUNCTION public.get_base_acct(integer, date, date) OWNER TO postgres;

--
-- Name: get_budgeted(integer, date, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_budgeted(integer, date, integer) RETURNS real
    LANGUAGE plpgsql
    AS $_$
DECLARE
	reca		RECORD;
	app_id		Integer;
	v_bill		real;
	v_variance	real;
BEGIN

	FOR reca IN SELECT transaction_detail_id, account_id, amount 
		FROM transaction_details WHERE (transaction_id = $1) LOOP

		SELECT sum(amount) INTO v_bill
		FROM transactions INNER JOIN transaction_details ON transactions.transaction_id = transaction_details.transaction_id
		WHERE (transactions.department_id = $3) AND (transaction_details.account_id = reca.account_id)
			AND (transactions.journal_id is null) AND (transaction_details.transaction_detail_id <> reca.transaction_detail_id);
		IF(v_bill is null)THEN
			v_bill := 0;
		END IF;

		SELECT sum(budget_lines.amount) INTO v_variance
		FROM fiscal_years INNER JOIN budgets ON fiscal_years.fiscal_year_id = budgets.fiscal_year_id
			INNER JOIN budget_lines ON budgets.budget_id = budget_lines.budget_id
		WHERE (budgets.department_id = $3) AND (budget_lines.account_id = reca.account_id)
			AND (budgets.approve_status = 'Approved')
			AND (fiscal_years.fiscal_year_start <= $2) AND (fiscal_years.fiscal_year_end >= $2);
		IF(v_variance is null)THEN
			v_variance := 0;
		END IF;

		v_variance := v_variance - (reca.amount + v_bill);

		IF(v_variance < 0)THEN
			RETURN v_variance;
		END IF;
	END LOOP;

	RETURN v_variance;
END;
$_$;


ALTER FUNCTION public.get_budgeted(integer, date, integer) OWNER TO postgres;

--
-- Name: get_currency_rate(integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_currency_rate(integer, integer) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT max(exchange_rate)
	FROM currency_rates
	WHERE (org_id = $1) AND (currency_id = $2)
		AND (exchange_date = (SELECT max(exchange_date) FROM currency_rates WHERE (org_id = $1) AND (currency_id = $2)));
$_$;


ALTER FUNCTION public.get_currency_rate(integer, integer) OWNER TO postgres;

--
-- Name: get_current_year(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_current_year(character varying) RETURNS character varying
    LANGUAGE sql
    AS $$
	SELECT to_char(current_date, 'YYYY');
$$;


ALTER FUNCTION public.get_current_year(character varying) OWNER TO postgres;

--
-- Name: get_default_account(integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_default_account(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$
	SELECT accounts.account_no
	FROM default_accounts INNER JOIN accounts ON default_accounts.account_id = accounts.account_id
	WHERE (default_accounts.use_key_id = $1) AND (default_accounts.org_id = $2);
$_$;


ALTER FUNCTION public.get_default_account(integer, integer) OWNER TO postgres;

--
-- Name: get_default_account_id(integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_default_account_id(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$
	SELECT accounts.account_id
	FROM default_accounts INNER JOIN accounts ON default_accounts.account_id = accounts.account_id
	WHERE (default_accounts.use_key_id = $1) AND (default_accounts.org_id = $2);
$_$;


ALTER FUNCTION public.get_default_account_id(integer, integer) OWNER TO postgres;

--
-- Name: get_default_country(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_default_country(integer) RETURNS character
    LANGUAGE sql
    AS $_$
	SELECT default_country_id::varchar(2)
	FROM orgs
	WHERE (org_id = $1);
$_$;


ALTER FUNCTION public.get_default_country(integer) OWNER TO postgres;

--
-- Name: get_default_currency(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_default_currency(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
	SELECT currency_id
	FROM orgs
	WHERE (org_id = $1);
$_$;


ALTER FUNCTION public.get_default_currency(integer) OWNER TO postgres;

--
-- Name: get_end_month(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_end_month(character varying) RETURNS character varying
    LANGUAGE sql
    AS $$
	SELECT to_char((to_char(current_date, 'YYYY-MM') || '-01')::date + '1 month'::interval - '1 day'::interval, 'DD/MM/YYYY');
$$;


ALTER FUNCTION public.get_end_month(character varying) OWNER TO postgres;

--
-- Name: get_end_year(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_end_year(character varying) RETURNS character varying
    LANGUAGE sql
    AS $$
	SELECT '31/12/' || to_char(current_date, 'YYYY');
$$;


ALTER FUNCTION public.get_end_year(character varying) OWNER TO postgres;

--
-- Name: get_et_field_name(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_et_field_name(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$
	SELECT et_field_name
	FROM et_fields WHERE (et_field_id = $1);
$_$;


ALTER FUNCTION public.get_et_field_name(integer) OWNER TO postgres;

--
-- Name: get_intrest(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_intrest(integer, integer, integer) RETURNS real
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_principal_amount 			real;
	v_interest_rate				real;
	v_actual_balance			real;
	v_total_debits				real;
	v_start_date				date;
	v_end_date					date;
	ans							real;
BEGIN

	SELECT start_date, end_date INTO v_start_date, v_end_date
	FROM periods WHERE (period_id = $3::integer);

	IF($1 = 1)THEN
		SELECT interest_rate INTO v_interest_rate
		FROM loans  WHERE (loan_id = $2);

		SELECT sum((account_debit - account_credit) * exchange_rate) INTO v_actual_balance
		FROM account_activity 
		WHERE (loan_id = $2) AND (activity_status_id < 2) AND (value_date <= v_end_date);

		ans := v_actual_balance * v_interest_rate / 1200;
	ELSIF($1 = 2)THEN
		SELECT principal_amount, interest_rate INTO v_principal_amount, v_interest_rate
		FROM vw_loans 
		WHERE (loan_id = $2);
		
		ans := v_principal_amount * v_interest_rate / 1200;
	ELSIF($1 = 3)THEN
		SELECT interest_rate INTO v_interest_rate
		FROM deposit_accounts  WHERE (deposit_account_id = $2);
		
		SELECT sum((account_credit - account_debit) * exchange_rate) INTO v_actual_balance
		FROM account_activity 
		WHERE (deposit_account_id = $2) AND (activity_status_id < 2) AND (value_date < v_start_date);
		IF(v_actual_balance is null)THEN v_actual_balance := 0; END IF;
		SELECT sum(account_debit * exchange_rate) INTO v_total_debits
		FROM account_activity 
		WHERE (deposit_account_id = $2) AND (activity_status_id < 2) AND (value_date BETWEEN v_start_date AND v_end_date);
		IF(v_total_debits is null)THEN v_total_debits := 0; END IF;
	
		ans := (v_actual_balance - v_total_debits) * v_interest_rate / 1200;
	END IF;

	RETURN ans;
END;
$_$;


ALTER FUNCTION public.get_intrest(integer, integer, integer) OWNER TO postgres;

--
-- Name: get_ledger_link(integer, integer, integer, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_ledger_link(integer, integer, integer, character varying, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_ledger_type_id		integer;
	v_account_no			integer;
	v_account_id			integer;
BEGIN

	SELECT ledger_types.ledger_type_id, accounts.account_no INTO v_ledger_type_id, v_account_no
	FROM ledger_types INNER JOIN ledger_links ON ledger_types.ledger_type_id = ledger_links.ledger_type_id
		INNER JOIN accounts ON ledger_types.account_id = accounts.account_id
	WHERE (ledger_links.org_id = $1) AND (ledger_links.link_type = $2) AND (ledger_links.link_id = $3);
	
	IF(v_ledger_type_id is null)THEN
		v_ledger_type_id := nextval('ledger_types_ledger_type_id_seq');
		SELECT accounts.account_id INTO v_account_id
		FROM accounts
		WHERE (accounts.org_id = $1) AND (accounts.account_no::text = $4);
		
		INSERT INTO ledger_types (ledger_type_id, account_id, tax_account_id, org_id,
			ledger_type_name, ledger_posting, expense_ledger, income_ledger)
		VALUES (v_ledger_type_id, v_account_id, v_account_id, $1,
			$5, true, true, false);

		INSERT INTO ledger_links (ledger_type_id, org_id, link_type, link_id)
		VALUES (v_ledger_type_id, $1, $2, $3);
	END IF;
	
	RETURN v_ledger_type_id;
END;
$_$;


ALTER FUNCTION public.get_ledger_link(integer, integer, integer, character varying, character varying) OWNER TO postgres;

--
-- Name: get_member_id(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_member_id(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
	SELECT member_id FROM entitys WHERE (entity_id = $1);
$_$;


ALTER FUNCTION public.get_member_id(integer) OWNER TO postgres;

--
-- Name: get_open_period(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_open_period(date) RETURNS integer
    LANGUAGE sql
    AS $_$
	SELECT period_id FROM periods WHERE (start_date <= $1) AND (end_date >= $1)
		AND (opened = true) AND (closed = false); 
$_$;


ALTER FUNCTION public.get_open_period(date) OWNER TO postgres;

--
-- Name: get_opening_stock(integer, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_opening_stock(integer, date) RETURNS integer
    LANGUAGE sql
    AS $_$
	SELECT COALESCE(sum(q_purchased - q_sold - q_used)::integer, 0)
	FROM vw_stock_movement
	WHERE (item_id = $1) AND (transaction_date < $2);
$_$;


ALTER FUNCTION public.get_opening_stock(integer, date) OWNER TO postgres;

--
-- Name: get_org_logo(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_org_logo(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$
	SELECT orgs.logo
	FROM orgs WHERE (orgs.org_id = $1);
$_$;


ALTER FUNCTION public.get_org_logo(integer) OWNER TO postgres;

--
-- Name: get_pc_budget(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_pc_budget(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_start_date		integer;
	v_department_id		integer;
	v_pc_allocation_id	integer;
	v_org_id			integer;
	msg 				varchar(120);
BEGIN

	IF($3 = '1')THEN
		SELECT periods.start_date - '1 month'::interval, pc_allocations.department_id 
			INTO v_start_date, v_department_id
		FROM periods INNER JOIN pc_allocations ON pc_allocations.period_id = pc_allocations.period_id
		WHERE (pc_allocations.pc_allocation_id = $1::integer);
		
		SELECT pc_allocation_id INTO v_pc_allocation_id
		FROM periods INNER JOIN pc_allocations ON pc_allocations.period_id = pc_allocations.period_id
		WHERE (v_start_date BETWEEN periods.start_date AND periods.end_date)
			AND (pc_allocations.department_id = v_department_id);
	
		INSERT INTO pc_budget(pc_allocation_id, pc_item_id, org_id, budget_units, budget_price, details)
		SELECT $1::integer, pc_item_id, org_id, budget_units, budget_price, details
		FROM pc_budget WHERE (pc_allocation_id = v_pc_allocation_id);
		
		msg := 'Created budget from last budget';
	ELSIF($3 = '2')THEN
		SELECT org_id INTO v_org_id
		FROM pc_allocations
		WHERE (pc_allocation_id = $1::integer);
		
		INSERT INTO pc_budget(pc_allocation_id, org_id, pc_item_id, budget_units, budget_price)
		SELECT $1::integer, org_id, pc_item_id, default_units, default_price
		FROM pc_items
		WHERE (org_id = v_org_id) AND (default_units > 0);
		
		msg := 'Created budget from items';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.get_pc_budget(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: get_penalty(integer, integer, integer, real); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_penalty(integer, integer, integer, real) RETURNS real
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_actual_default			real;
	v_start_date				date;
	v_end_date					date;
	ans							real;
BEGIN

	SELECT start_date, end_date INTO v_start_date, v_end_date
	FROM periods WHERE (period_id = $3::integer);

	IF($1 = 1)THEN
		SELECT sum(account_credit * exchange_rate) INTO v_actual_default
		FROM account_activity 
		WHERE (loan_id = $2) AND (activity_status_id = 4) AND (value_date < v_start_date);
		
		ans := v_actual_default * $3 / 1200;
	END IF;

	RETURN ans;
END;
$_$;


ALTER FUNCTION public.get_penalty(integer, integer, integer, real) OWNER TO postgres;

--
-- Name: get_period(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_period(date) RETURNS integer
    LANGUAGE sql
    AS $_$
	SELECT period_id FROM periods WHERE (start_date <= $1) AND (end_date >= $1); 
$_$;


ALTER FUNCTION public.get_period(date) OWNER TO postgres;

--
-- Name: get_phase_email(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_phase_email(integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
    myrec	RECORD;
	myemail	varchar(320);
BEGIN
	myemail := null;
	FOR myrec IN SELECT entitys.primary_email
		FROM entitys INNER JOIN entity_subscriptions ON entitys.entity_id = entity_subscriptions.entity_id
		WHERE (entity_subscriptions.entity_type_id = $1) LOOP

		IF (myemail is null) THEN
			IF (myrec.primary_email is not null) THEN
				myemail := myrec.primary_email;
			END IF;
		ELSE
			IF (myrec.primary_email is not null) THEN
				myemail := myemail || ', ' || myrec.primary_email;
			END IF;
		END IF;

	END LOOP;

	RETURN myemail;
END;
$_$;


ALTER FUNCTION public.get_phase_email(integer) OWNER TO postgres;

--
-- Name: get_phase_entitys(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_phase_entitys(integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
    myrec			RECORD;
	myentitys		varchar(320);
BEGIN
	myentitys := null;
	FOR myrec IN SELECT entitys.entity_name
		FROM entitys INNER JOIN entity_subscriptions ON entitys.entity_id = entity_subscriptions.entity_id
		WHERE (entity_subscriptions.entity_type_id = $1) LOOP

		IF (myentitys is null) THEN
			IF (myrec.entity_name is not null) THEN
				myentitys := myrec.entity_name;
			END IF;
		ELSE
			IF (myrec.entity_name is not null) THEN
				myentitys := myentitys || ', ' || myrec.entity_name;
			END IF;
		END IF;

	END LOOP;

	RETURN myentitys;
END;
$_$;


ALTER FUNCTION public.get_phase_entitys(integer) OWNER TO postgres;

--
-- Name: get_phase_status(boolean, boolean); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_phase_status(boolean, boolean) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	ps		varchar(16);
BEGIN
	ps := 'Draft';
	IF ($1 = true) THEN
		ps := 'Approved';
	END IF;
	IF ($2 = true) THEN
		ps := 'Rejected';
	END IF;

	RETURN ps;
END;
$_$;


ALTER FUNCTION public.get_phase_status(boolean, boolean) OWNER TO postgres;

--
-- Name: get_reporting_list(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_reporting_list(integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
    myrec	RECORD;
	mylist	varchar(320);
BEGIN
	mylist := null;
	FOR myrec IN SELECT entitys.entity_name
		FROM reporting INNER JOIN entitys ON reporting.report_to_id = entitys.entity_id
		WHERE (reporting.primary_report = true) AND (reporting.entity_id = $1)
	LOOP

		IF (mylist is null) THEN
			mylist := myrec.entity_name;
		ELSE
			mylist := mylist || ', ' || myrec.entity_name;
		END IF;
	END LOOP;

	RETURN mylist;
END;
$_$;


ALTER FUNCTION public.get_reporting_list(integer) OWNER TO postgres;

--
-- Name: get_settled_loan_amount(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_settled_loan_amount(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
    SELECT COALESCE(sum(principal_amount), 0)::integer
	FROM loans
	WHERE (is_active = false) AND (approve_status = 'Approved') AND (member_id = $1);
$_$;


ALTER FUNCTION public.get_settled_loan_amount(integer) OWNER TO postgres;

--
-- Name: get_settled_loans(integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_settled_loans(integer) RETURNS integer
    LANGUAGE sql
    AS $_$
    SELECT COALESCE(count(loan_id), 0)::integer
	FROM loans
	WHERE (is_active = false) AND (approve_status = 'Approved') AND (member_id = $1);
$_$;


ALTER FUNCTION public.get_settled_loans(integer) OWNER TO postgres;

--
-- Name: get_start_month(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_start_month(character varying) RETURNS character varying
    LANGUAGE sql
    AS $$
	SELECT '01/' || to_char(current_date, 'MM/YYYY');
$$;


ALTER FUNCTION public.get_start_month(character varying) OWNER TO postgres;

--
-- Name: get_start_year(character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_start_year(character varying) RETURNS character varying
    LANGUAGE sql
    AS $$
	SELECT '01/01/' || to_char(current_date, 'YYYY');
$$;


ALTER FUNCTION public.get_start_year(character varying) OWNER TO postgres;

--
-- Name: get_tax_min(double precision, integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.get_tax_min(double precision, integer, integer) RETURNS double precision
    LANGUAGE sql
    AS $_$
	SELECT CASE WHEN max(tax_range) is null THEN 0 ELSE max(tax_range) END 
	FROM period_tax_rates WHERE (tax_range < $1) AND (period_tax_type_id = $2) AND (employer_rate = $3);
$_$;


ALTER FUNCTION public.get_tax_min(double precision, integer, integer) OWNER TO postgres;

--
-- Name: id_to_username(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.id_to_username(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_entity_id			integer;
	v_member_id 		integer;
	v_id_number 		varchar(120);
	reca 				RECORD;
	v_user_name			varchar(120);
	v_username			varchar(120);
	msg					varchar(120);
BEGIN
	msg := 'Error changing Identification Number to username';

	SELECT en.entity_id,en.member_id, mm.member_id, mm.person_title, mm.member_name, mm.identification_type, 
	mm.identification_number,mm.is_active, en.user_name INTO reca
	FROM members mm
	INNER JOIN entitys en ON en.member_id = mm.member_id
	WHERE (en.entity_id = $1::int);	

	SELECT entity_id, user_name INTO v_entity_id, v_username
	FROM entitys WHERE (entity_id = $1::int);

	SELECT user_name INTO v_user_name
	FROM entitys WHERE (reca.identification_number = v_username);

	IF(reca.identification_number is null)THEN
		msg := 'Ensure you have an identification number entered';
	ELSIF(v_user_name is not null)THEN
		msg := 'There is an existing user with that Identification Number as username';
	ELSE
		UPDATE entitys SET user_name = reca.identification_number WHERE entity_id = v_entity_id;
		msg := 'Identification Number updated to username';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.id_to_username(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: ins_account_activity(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_account_activity() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_deposit_account_id		integer;
	v_period_id					integer;
	v_loan_id					integer;
	v_activity_type_id			integer;
	v_use_key_id				integer;
	v_org_currency_id			integer;
	v_account_currency_id		integer;
	v_transfer_currency_id		integer;
	v_minimum_balance			real;
	v_account_transfer			varchar(32);
	v_first_trx					boolean;
BEGIN

	IF((NEW.account_credit = 0) AND (NEW.account_debit = 0))THEN
		RAISE EXCEPTION 'You must enter a debit or credit amount';
	ELSIF((NEW.account_credit < 0) OR (NEW.account_debit < 0))THEN
		RAISE EXCEPTION 'The amounts must be positive';
	ELSIF((NEW.account_credit > 0) AND (NEW.account_debit > 0))THEN
		RAISE EXCEPTION 'Both debit and credit cannot not have an amount at the same time';
	END IF;
	
	SELECT periods.period_id INTO NEW.period_id
	FROM periods
	WHERE (opened = true) AND (activated = true) AND (closed = false)
		AND (start_date <= NEW.activity_date) AND (end_date >= NEW.activity_date) AND (org_id = NEW.org_id);
	IF(NEW.period_id is null)THEN
		RAISE EXCEPTION 'The transaction needs to be in an open and active period';
	END IF;
	
	SELECT use_key_id INTO v_use_key_id
	FROM activity_types WHERE (activity_type_id = NEW.activity_type_id);
	
	IF(NEW.deposit_account_id is not null)THEN
		SELECT orgs.currency_id, products.currency_id, COALESCE(deposit_accounts.minimum_balance, 0)
			INTO v_org_currency_id, v_account_currency_id, v_minimum_balance
		FROM deposit_accounts INNER JOIN products ON deposit_accounts.product_id = products.product_id
			INNER JOIN orgs ON deposit_accounts.org_id = orgs.org_id
		WHERE (deposit_accounts.deposit_account_id = NEW.deposit_account_id);
	ELSIF(NEW.loan_id is not null)THEN
		SELECT orgs.currency_id, products.currency_id, null
			INTO v_org_currency_id, v_account_currency_id, v_minimum_balance
		FROM loans INNER JOIN products ON loans.product_id = products.product_id
			INNER JOIN orgs ON loans.org_id = orgs.org_id
		WHERE (loans.loan_id = NEW.loan_id);
	END IF;
	
	v_first_trx := false;
	IF(NEW.link_activity_id is null)THEN
		v_first_trx := true;
		NEW.link_activity_id := nextval('link_activity_id_seq');
	END IF;
	
	IF(NEW.transfer_link_id is not null)THEN
		SELECT account_number INTO NEW.transfer_account_no
		FROM deposit_accounts WHERE (deposit_account_id = NEW.transfer_link_id);
		NEW.activity_date := current_date;
		NEW.value_date := current_date;
		IF(NEW.transfer_account_no is null)THEN
			RAISE EXCEPTION 'Enter the correct transfer account';
		END IF;
	END IF;
	
	IF(TG_OP = 'INSERT')THEN
		IF(NEW.deposit_account_id is not null)THEN
			SELECT sum(account_credit - account_debit) INTO NEW.balance
			FROM account_activity
			WHERE (account_activity_id < NEW.account_activity_id)
				AND (deposit_account_id = NEW.deposit_account_id);
		END IF;
		IF(NEW.loan_id is not null)THEN
			SELECT sum(account_credit - account_debit) INTO NEW.balance
			FROM account_activity
			WHERE (account_activity_id < NEW.account_activity_id)
				AND (loan_id = NEW.loan_id);
		END IF;
		IF(NEW.balance is null)THEN
			NEW.balance := 0;
		END IF;
		NEW.balance := NEW.balance + (NEW.account_credit - NEW.account_debit);
				
		IF(v_use_key_id IN (102, 104, 107))THEN			
			IF((NEW.balance < v_minimum_balance) AND (NEW.activity_status_id = 1))THEN
					RAISE EXCEPTION 'You cannot withdraw below allowed minimum balance';
			END IF;
		END IF;
	END IF;
	
	IF((NEW.transfer_account_no is null) AND (NEW.transfer_account_id is null) AND (NEW.transfer_loan_id is null))THEN
		SELECT vw_account_definations.account_number INTO NEW.transfer_account_no
		FROM vw_account_definations INNER JOIN deposit_accounts ON vw_account_definations.product_id = deposit_accounts.product_id
		WHERE (deposit_accounts.deposit_account_id = NEW.deposit_account_id) 
			AND (vw_account_definations.activity_type_id = NEW.activity_type_id) 
			AND (vw_account_definations.use_key_id IN (101, 102));
	END IF;

	IF(NEW.transfer_account_no is not null)THEN
		SELECT deposit_accounts.deposit_account_id, products.currency_id INTO v_deposit_account_id, v_transfer_currency_id
		FROM deposit_accounts INNER JOIN products ON deposit_accounts.product_id = products.product_id
		WHERE (deposit_accounts.account_number = NEW.transfer_account_no);
		
		IF(v_deposit_account_id is null)THEN
			SELECT loans.loan_id, products.currency_id INTO v_loan_id, v_transfer_currency_id
			FROM loans INNER JOIN products ON loans.product_id = products.product_id
			WHERE (loans.account_number = NEW.transfer_account_no);
		END IF;
		
		IF((v_deposit_account_id is null) AND (v_loan_id is null))THEN
			RAISE EXCEPTION 'Enter a valid account to do transfer';
		ELSIF((v_deposit_account_id is not null) AND (NEW.deposit_account_id = v_deposit_account_id))THEN
			RAISE EXCEPTION 'You cannot do a transfer on same account';
		ELSIF((v_loan_id is not null) AND (NEW.loan_id = v_loan_id))THEN
			RAISE EXCEPTION 'You cannot do a transfer on same account';
		ELSIF((v_account_currency_id != v_transfer_currency_id) AND (v_use_key_id != 250))THEN
			RAISE EXCEPTION 'You cannot do a transfer on different currency accounts';
		ELSIF(v_deposit_account_id is not null)THEN
			NEW.transfer_account_id := v_deposit_account_id;
		ELSIF(v_loan_id is not null)THEN
			NEW.transfer_loan_id := v_loan_id;
		END IF;
	ELSIF(NEW.transfer_account_id is not null)THEN
		SELECT account_number INTO NEW.transfer_account_no
		FROM deposit_accounts WHERE (deposit_account_id = NEW.transfer_account_id);
	ELSIF(NEW.transfer_loan_id is not null)THEN
		SELECT account_number INTO NEW.transfer_account_no
		FROM loans WHERE (loan_id = NEW.transfer_loan_id);
	END IF;
	
	---- geting the exchange rate
	IF(v_org_currency_id = v_account_currency_id)THEN
		NEW.exchange_rate := 1;
	ELSE
		IF(v_use_key_id = 250)THEN
			IF(v_first_trx = true)THEN
				IF(NEW.invert_rate = true)THEN NEW.exchange_rate := NEW.trading_rate;
				ELSE NEW.exchange_rate := 1 / NEW.trading_rate; END IF;
			END IF;
		ELSE
			NEW.exchange_rate := get_currency_rate(NEW.org_id, v_account_currency_id);
		END IF;
	END IF;
			
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_account_activity() OWNER TO postgres;

--
-- Name: ins_address(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_address() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_address_id		integer;
BEGIN
	SELECT address_id INTO v_address_id
	FROM address WHERE (is_default = true)
		AND (table_name = NEW.table_name) AND (table_id = NEW.table_id) AND (address_id <> NEW.address_id);

	IF(NEW.is_default is null)THEN
		NEW.is_default := false;
	END IF;

	IF(NEW.is_default = true) AND (v_address_id is not null) THEN
		RAISE EXCEPTION 'Only one default Address allowed.';
	ELSIF (NEW.is_default = false) AND (v_address_id is null) THEN
		NEW.is_default := true;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_address() OWNER TO postgres;

--
-- Name: ins_applicants(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_applicants() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_member_id			integer;
BEGIN

	IF (TG_OP = 'INSERT') THEN
		NEW.approve_status := 'Completed';
	ELSIF(NEW.approve_status = 'Approved')THEN
		SELECT member_id INTO v_member_id
		FROM members WHERE (identification_number = NEW.identification_number);
		
		IF(v_member_id is null)THEN
			v_member_id := nextval('members_member_id_seq');
			INSERT INTO members(member_id, org_id, business_account, person_title, 
				member_name, identification_number, identification_type, member_email, 
				telephone_number, telephone_number2, address, town, zip_code, 
				date_of_birth, gender, nationality, marital_status, picture_file, 
				employed, self_employed, employer_name, employer_address, introduced_by,
				details)
			VALUES (v_member_id, NEW.org_id, NEW.business_account, NEW.person_title, 
				NEW.member_name, NEW.identification_number, NEW.identification_type, NEW.member_email, 
				NEW.telephone_number, NEW.telephone_number2, NEW.address, NEW.town, NEW.zip_code, 
				NEW.date_of_birth, NEW.gender, NEW.nationality, NEW.marital_status, NEW.picture_file, 
				NEW.employed, NEW.self_employed, NEW.employer_name, NEW.employer_address, NEW.introduced_by,
				NEW.details);
		END IF;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_applicants() OWNER TO postgres;

--
-- Name: ins_approvals(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_approvals() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	reca	RECORD;
BEGIN

	IF (NEW.forward_id is not null) THEN
		SELECT workflow_phase_id, org_entity_id, app_entity_id, approval_level, table_name, table_id INTO reca
		FROM approvals
		WHERE (approval_id = NEW.forward_id);

		NEW.workflow_phase_id := reca.workflow_phase_id;
		NEW.approval_level := reca.approval_level;
		NEW.table_name := reca.table_name;
		NEW.table_id := reca.table_id;
		NEW.approve_status := 'Completed';
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_approvals() OWNER TO postgres;

--
-- Name: ins_budget(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_budget() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN

	INSERT INTO pc_allocations (period_id, department_id, org_id)
	SELECT NEW.period_id, department_id, org_id
	FROM departments
	WHERE (departments.active = true) AND (departments.petty_cash = true) AND (departments.org_id = NEW.org_id);

	INSERT INTO pc_budget (pc_allocation_id, org_id, pc_item_id, budget_units, budget_price)
	SELECT pc_allocations.pc_allocation_id, pc_allocations.org_id,
		pc_items.pc_item_id, pc_items.default_units, pc_items.default_price
	FROM pc_allocation CROSS JOIN pc_items
	WHERE (pc_allocation.period_id = NEW.period_id) AND (pc_allocation.org_id = NEW.org_id)
		AND (pc_items.default_units > 0);
	
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.ins_budget() OWNER TO postgres;

--
-- Name: ins_commodity_trades(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_commodity_trades() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_first_trx					boolean;
	v_total_units				real;
	v_current_price 			real;
BEGIN

	IF((NEW.unit_credit = 0) AND (NEW.unit_debit = 0))THEN
		RAISE EXCEPTION 'You must enter a debit or credit units';
	ELSIF((NEW.unit_credit < 0) OR (NEW.unit_debit < 0))THEN
		RAISE EXCEPTION 'The amounts must be positive';
	ELSIF((NEW.unit_credit > 0) AND (NEW.unit_debit > 0))THEN
		RAISE EXCEPTION 'Both debit and credit cannot not have an amount at the same time';
	ELSIF((NEW.price < 0))THEN
		RAISE EXCEPTION 'The transaction must have a valid price';
	END IF;

	SELECT current_price INTO v_current_price
	FROM commoditys
	WHERE commodity_id = NEW.commodity_id;
	IF(NEW.price = 0)THEN NEW.price := v_current_price; END IF;

	SELECT sum(unit_credit - unit_debit) INTO v_total_units
	FROM commodity_trades
	WHERE (deposit_account_id = NEW.deposit_account_id) AND (commodity_id = NEW.commodity_id)
		AND (approve_status = 'Approved');

	IF(NEW.unit_debit > v_total_units)THEN
		RAISE EXCEPTION 'You cannot sell more units that you have';
	END IF;

	v_first_trx := false;
	IF(NEW.link_activity_id is null)THEN
		v_first_trx := true;
		NEW.link_activity_id := nextval('link_activity_id_seq');
	END IF;
	
	IF(NEW.use_key_id = 230)THEN
		IF(NEW.transfer_account_no is not null)THEN
			SELECT deposit_accounts.deposit_account_id INTO NEW.transfer_account_id
			FROM deposit_accounts WHERE deposit_accounts.account_number = NEW.transfer_account_no;
		END IF;
	ELSE
		SELECT commoditys.commodity_account, deposit_accounts.deposit_account_id 
			INTO NEW.transfer_account_no, NEW.transfer_account_id
		FROM commoditys INNER JOIN deposit_accounts ON commoditys.commodity_account = deposit_accounts.account_number
		WHERE (commoditys.commodity_id = NEW.commodity_id);
	END IF;
	
	IF(NEW.transfer_account_id is null)THEN
		RAISE EXCEPTION 'Ensure you have the right account';
	END IF;
	
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_commodity_trades() OWNER TO postgres;

--
-- Name: ins_deposit_accounts(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_deposit_accounts() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_account_count		integer;
	myrec				RECORD;
BEGIN

	IF(TG_OP = 'INSERT')THEN
		SELECT interest_rate, activity_frequency_id, min_opening_balance, lockin_period_frequency,
			minimum_balance, maximum_balance INTO myrec
		FROM products WHERE product_id = NEW.product_id;
		
		IF(NEW.member_id is null)THEN
			SELECT member_id INTO NEW.member_id
			FROM entitys WHERE (entity_id = NEW.entity_id);
		END IF;
		
		SELECT count(deposit_account_id) INTO v_account_count
		FROM deposit_accounts WHERE (member_id = NEW.member_id);
		IF(v_account_count is null) THEN v_account_count := 1; ELSE v_account_count := v_account_count + 1; END IF;
		
		NEW.account_number := '4' || lpad(NEW.org_id::varchar, 2, '0')  || lpad(NEW.member_id::varchar, 4, '0') || lpad(v_account_count::varchar, 2, '0');
		
		IF(NEW.minimum_balance is null) THEN NEW.minimum_balance := myrec.minimum_balance; END IF;
		IF(NEW.maximum_balance is null) THEN NEW.maximum_balance := myrec.maximum_balance; END IF;
		IF(NEW.interest_rate is null) THEN NEW.interest_rate := myrec.interest_rate; END IF;
		
		NEW.activity_frequency_id := myrec.activity_frequency_id;
		NEW.lockin_period_frequency := myrec.lockin_period_frequency;
	ELSE
		IF((OLD.approve_status != 'Approved') AND (NEW.approve_status = 'Approved'))THEN
			NEW.is_active = true;
			----initial charges
			INSERT INTO account_activity (deposit_account_id, activity_type_id, activity_frequency_id,
				activity_status_id, entity_id, org_id, transfer_account_no,
				activity_date, value_date, account_debit)
			SELECT NEW.deposit_account_id, account_definations.activity_type_id, account_definations.activity_frequency_id,
				1, NEW.entity_id, NEW.org_id, account_definations.account_number,
				NEW.opening_date, NEW.opening_date, account_definations.fee_amount
			FROM account_definations INNER JOIN activity_types ON account_definations.activity_type_id = activity_types.activity_type_id
				INNER JOIN products ON account_definations.product_id = products.product_id
			WHERE (account_definations.product_id = NEW.product_id) AND (account_definations.org_id = NEW.org_id)
				AND (account_definations.activity_frequency_id = 1) AND (activity_types.use_key_id = 201) 
				AND (account_definations.is_active = true)
				AND (account_definations.start_date < NEW.opening_date);
		END IF;
	END IF;
	
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_deposit_accounts() OWNER TO postgres;

--
-- Name: ins_entitys(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_entitys() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN

	IF(NEW.org_id is null)THEN
		RAISE EXCEPTION 'You have to select a valid organisation';
	END IF;

	SELECT use_key_id INTO NEW.use_key_id
	FROM entity_types
	WHERE (entity_type_id = NEW.entity_type_id);

	IF(NEW.sys_language_id is null)THEN
		NEW.sys_language_id := 0;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_entitys() OWNER TO postgres;

--
-- Name: ins_entry_form(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_entry_form(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	rec 		RECORD;
	vorgid		integer;
	formName 	varchar(120);
	msg 		varchar(120);
BEGIN
	SELECT entry_form_id, org_id INTO rec
	FROM entry_forms 
	WHERE (form_id = CAST($1 as int)) AND (entity_ID = CAST($2 as int))
		AND (approve_status = 'Draft');

	SELECT form_name, org_id INTO formName, vorgid
	FROM forms WHERE (form_id = CAST($1 as int));

	IF rec.entry_form_id is null THEN
		INSERT INTO entry_forms (form_id, entity_id, org_id) 
		VALUES (CAST($1 as int), CAST($2 as int), vorgid);
		msg := 'Added Form : ' || formName;
	ELSE
		msg := 'There is an incomplete form : ' || formName;
	END IF;

	return msg;
END;
$_$;


ALTER FUNCTION public.ins_entry_form(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: ins_entry_forms(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_entry_forms() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	reca		RECORD;
BEGIN
	
	SELECT default_values, default_sub_values INTO reca
	FROM forms
	WHERE (form_id = NEW.form_id);
	
	NEW.answer := reca.default_values;
	NEW.sub_answer := reca.default_sub_values;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_entry_forms() OWNER TO postgres;

--
-- Name: ins_fields(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_fields() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_ord	integer;
BEGIN
	IF(NEW.field_order is null) THEN
		SELECT max(field_order) INTO v_ord
		FROM fields
		WHERE (form_id = NEW.form_id);

		IF (v_ord is null) THEN
			NEW.field_order := 10;
		ELSE
			NEW.field_order := v_ord + 10;
		END IF;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_fields() OWNER TO postgres;

--
-- Name: ins_loan_approval(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_loan_approval() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	myrec				RECORD;	
	msg					varchar(120);
BEGIN

	IF(TG_OP = 'INSERT')THEN
		SELECT loan_approval_id,sacco_official_id,org_id,processing_approval,final_approval,
		is_active INTO myrec
		FROM loan_approval WHERE sacco_official_id = NEW.sacco_official_id;

		IF(NEW.sacco_official_id = myrec.sacco_official_id) THEN
			RAISE EXCEPTION 'Sacco Official for loan approval already exists....';
		END IF;	

		IF((NEW.processing_approval = true) and (NEW.final_approval = true))THEN
			msg := 'One cannot do two levels of loan approval.. Choose either processing approval OR final approval..';
			RAISE EXCEPTION '%',msg;
		END IF;

	END IF;	
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_loan_approval() OWNER TO postgres;

--
-- Name: ins_loan_configs(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_loan_configs() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	myrec				RECORD;
BEGIN

	IF(TG_OP = 'INSERT')THEN
		SELECT loan_config_id,org_id,product_id,is_guaranteed,is_collateral,membership_period,less_guaranteed,
		is_active INTO myrec
		FROM loan_configs WHERE product_id = NEW.product_id;

		IF(NEW.product_id = myrec.product_id) THEN
		RAISE EXCEPTION 'Loan product configuration already exists...OR is archived...';
		END IF;			
	END IF;	
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_loan_configs() OWNER TO postgres;

--
-- Name: ins_loans(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_loans() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	myrec					RECORD;
	v_activity_type_id		integer;
	v_repayments			integer;
	v_currency_id			integer;
	v_less_initial_fee		boolean;
	v_reducing_balance		boolean;
	v_reducing_payments		boolean;
	v_loan_amount			real;
	v_nir					real;
	v_disbursed_date		date;
	v_loan_count 			integer;
BEGIN

	IF(NEW.repayment_period < 1)THEN
		RAISE EXCEPTION 'The repayment period has to be greater than 1 or 1';
	ELSIF(NEW.principal_amount < 1)THEN
		RAISE EXCEPTION 'The principal amount has to be greater than 1';
	END IF;
	
	IF(TG_OP = 'INSERT')THEN
		SELECT interest_rate, activity_frequency_id, min_opening_balance, 
			minimum_balance, maximum_balance INTO myrec
		FROM products WHERE product_id = NEW.product_id;
		
		IF(NEW.member_id is null)THEN
			SELECT member_id INTO NEW.member_id
			FROM entitys WHERE (entity_id = NEW.entity_id);
		END IF;
	
		SELECT count(loan_id) INTO v_loan_count
        FROM loans WHERE (member_id = NEW.member_id);
        IF(v_loan_count is null) THEN v_loan_count := 1; ELSE v_loan_count := v_loan_count + 1; END IF;
    
        NEW.account_number := '5' || lpad(NEW.org_id::varchar, 2, '0')  || lpad(NEW.member_id::varchar, 4, '0') || lpad(v_loan_count::varchar, 3, '0');
        
			
		NEW.interest_rate := myrec.interest_rate;
		NEW.activity_frequency_id := myrec.activity_frequency_id;
		---on loan approval 
	ELSIF((NEW.approve_status = 'Approved') AND (OLD.approve_status <> 'Approved'))THEN
		SELECT activity_type_id INTO v_activity_type_id
		FROM vw_account_definations 
		WHERE (use_key_id = 108) AND (is_active = true) AND (product_id = NEW.product_id);
		
		SELECT currency_id, less_initial_fee INTO v_currency_id, v_less_initial_fee
		FROM products
		WHERE (product_id = NEW.product_id);
		
		v_disbursed_date := current_date;
		IF(NEW.disbursed_date is not null)THEN v_disbursed_date := NEW.disbursed_date; END IF;
		--initial charges
		INSERT INTO account_activity (loan_id, activity_type_id, activity_frequency_id,
			activity_status_id, entity_id, org_id, transfer_account_no,
			activity_date, value_date, account_debit)
		SELECT NEW.loan_id, account_definations.activity_type_id, account_definations.activity_frequency_id,
			1, NEW.entity_id, NEW.org_id, account_definations.account_number,
			v_disbursed_date, v_disbursed_date, account_definations.fee_amount
		FROM account_definations INNER JOIN activity_types ON account_definations.activity_type_id = activity_types.activity_type_id
			INNER JOIN products ON account_definations.product_id = products.product_id
		WHERE (account_definations.product_id = NEW.product_id) AND (account_definations.org_id = NEW.org_id)
			AND (account_definations.activity_frequency_id = 1) AND (activity_types.use_key_id = 201) 
			AND (account_definations.is_active = true)
			AND (account_definations.start_date < v_disbursed_date);
		
		v_loan_amount := NEW.principal_amount;
		IF(v_less_initial_fee = true)THEN
			SELECT sum(account_debit - account_credit) INTO v_loan_amount
			FROM account_activity WHERE loan_id = NEW.loan_id;
			IF(v_loan_amount is null)THEN v_loan_amount := 0; END IF;
			v_loan_amount := NEW.principal_amount - v_loan_amount;
		END IF;
		
		IF(v_activity_type_id is not null)THEN
			INSERT INTO account_activity (loan_id, transfer_account_no, org_id, activity_type_id,  
				activity_frequency_id, activity_date, value_date, activity_status_id, account_credit, account_debit)
			VALUES (NEW.loan_id, NEW.disburse_account, NEW.org_id, v_activity_type_id,  
				1, v_disbursed_date, v_disbursed_date, 1, 0, v_loan_amount);
		
			NEW.disbursed_date := v_disbursed_date;
			NEW.expected_matured_date := v_disbursed_date + (NEW.repayment_period || ' months')::interval;
		END IF;
		--- Update the loan status
		NEW.loan_status = 'Active';
		New.is_active = true;

		---loan approval notification and disbursment details
		INSERT INTO sys_emailed (org_id, sys_email_id, table_id, table_name, email_type)
		SELECT org_id, sys_email_id, NEW.loan_id, 'loans', 1
		FROM sys_emails
		WHERE (use_type = 6) AND (org_id = NEW.org_id);
	END IF;
	
	---- Calculate for repayment
	IF(NEW.approve_status <> 'Approved')THEN
		SELECT interest_methods.reducing_balance, interest_methods.reducing_payments INTO v_reducing_balance, v_reducing_payments
		FROM interest_methods INNER JOIN products ON interest_methods.interest_method_id = products.interest_method_id
		WHERE (products.product_id = NEW.product_id);
		IF(v_reducing_balance = true)THEN
			v_nir := NEW.interest_rate / 1200;
			IF(v_reducing_payments = true)THEN
				NEW.repayment_amount := NEW.principal_amount / NEW.repayment_period;
				NEW.expected_repayment := NEW.principal_amount * NEW.repayment_period * v_nir;
				NEW.expected_repayment := NEW.expected_repayment - (NEW.repayment_period * (NEW.repayment_period - 1) * NEW.repayment_amount * v_nir / 2);
				NEW.expected_repayment := NEW.expected_repayment + NEW.principal_amount;
			ELSE
				NEW.repayment_amount := (v_nir * NEW.principal_amount) / (1 - ((1 + v_nir) ^ (-NEW.repayment_period)));
				NEW.expected_repayment := NEW.repayment_amount * NEW.repayment_period;
			END IF;
			
			RAISE NOTICE 'Month Intrest % ', v_nir;
			RAISE NOTICE 'Expected % ', NEW.expected_repayment;
		ELSE
			NEW.expected_repayment := NEW.principal_amount * ((1.0 + (NEW.interest_rate / 100)) ^ (NEW.repayment_period::real / 12));
			NEW.repayment_amount := NEW.expected_repayment / NEW.repayment_period;
			
			RAISE NOTICE 'repayment period % ', NEW.repayment_period;
			RAISE NOTICE 'repayment annual % ', (NEW.repayment_period::real / 12);
			RAISE NOTICE 'Intrest Rate % ', (1.0 + (NEW.interest_rate / 100));
			RAISE NOTICE 'repayment rate % ', ((1.0 + (NEW.interest_rate / 100)) ^ (NEW.repayment_period::real / 12));
		END IF;
	END IF;
	
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_loans() OWNER TO postgres;

--
-- Name: ins_member_imports(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_member_imports() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	msg			RECORD;

BEGIN

	IF((TG_OP = 'INSERT'))THEN
		UPDATE member_imports SET org_id = NEW.org_id;		
	END IF;
	
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.ins_member_imports() OWNER TO postgres;

--
-- Name: ins_member_limit(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_member_limit() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_member_count			integer;
	v_member_limit			integer;
BEGIN

	SELECT count(member_id) INTO v_member_count
	FROM members
	WHERE (org_id = NEW.org_id);
	
	SELECT member_limit INTO v_member_limit
	FROM orgs
	WHERE (org_id = NEW.org_id);
	
	IF(v_member_count > v_member_limit)THEN
		RAISE EXCEPTION 'You have reached the maximum transaction limit, request for a quite for more';
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_member_limit() OWNER TO postgres;

--
-- Name: ins_mpesa_api(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_mpesa_api() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_member_id			integer;
BEGIN

	NEW.TransactionTime := to_timestamp(NEW.TransTime, 'YYYYMMDDHH24MISS');
	
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_mpesa_api() OWNER TO postgres;

--
-- Name: ins_password(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_password() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_entity_id		integer;
BEGIN

	SELECT entity_id INTO v_entity_id
	FROM entitys
	WHERE (trim(lower(user_name)) = trim(lower(NEW.user_name)))
		AND entity_id <> NEW.entity_id;

	IF(v_entity_id is not null)THEN
		RAISE EXCEPTION 'The username exists use a different one or reset password for the current one';
	END IF;

	IF(TG_OP = 'INSERT') THEN
		IF(NEW.first_password is null)THEN
			NEW.first_password := first_password();
		END IF;

		IF (NEW.entity_password is null) THEN
			NEW.entity_password := md5(NEW.first_password);
		END IF;
	ELSIF(OLD.first_password <> NEW.first_password) THEN
		NEW.Entity_password := md5(NEW.first_password);
	END IF;

	IF(NEW.user_name is null)THEN
		SELECT org_sufix || '.' || lower(trim(replace(NEW.entity_name, ' ', ''))) INTO NEW.user_name
		FROM orgs
		WHERE org_id = NEW.org_id;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_password() OWNER TO postgres;

--
-- Name: ins_periods(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_periods() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	year_close 		BOOLEAN;
BEGIN
	SELECT year_closed INTO year_close
	FROM fiscal_years
	WHERE (fiscal_year_id = NEW.fiscal_year_id);

	IF(year_close = true)THEN
		RAISE EXCEPTION 'The year is closed not transactions are allowed.';
	END IF;
	IF(NEW.start_date > NEW.end_date)THEN
		RAISE EXCEPTION 'The starting date has to be before the ending date.';
	END IF;
	
	IF(TG_OP = 'UPDATE')THEN    
		IF (OLD.closed = true) AND (NEW.closed = false) THEN
			NEW.approve_status := 'Draft';
		END IF;
	ELSE
		IF(NEW.gl_payroll_account is null)THEN NEW.gl_payroll_account := get_default_account(27, NEW.org_id); END IF;
		IF(NEW.gl_advance_account is null)THEN NEW.gl_advance_account := get_default_account(28, NEW.org_id); END IF;
	END IF;

	IF (NEW.approve_status = 'Approved') THEN
		NEW.opened = false;
		NEW.activated = false;
		NEW.closed = true;
	END IF;


	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_periods() OWNER TO postgres;

--
-- Name: ins_sms(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_sms() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_telephone_number 		varchar(20);
	v_member_entity_id 		integer;
	reca 					RECORD;
BEGIN
	
	IF (TG_OP = 'INSERT')THEN		
		--- member sms
		IF((NEW.member_id is not null) AND (NEW.is_groupsms = false) AND (NEW.sms_group_id is null)) THEN
			SELECT telephone_number INTO v_telephone_number
			FROM members
			WHERE member_id = NEW.member_id;

			SELECT entity_id INTO v_member_entity_id
			FROM entitys
			WHERE member_id = NEW.member_id;

			NEW.sms_number := v_telephone_number;
			NEW.entity_id := v_member_entity_id;
			NEW.folder_id := 0;
		END IF;

		-- IF(NEW.is_groupsms = true) THEN
		-- 	----group sms
		-- SELECT sms_group_id, member_id INTO reca
		-- FROM sms_group_members
		-- WHERE sms_group_id = NEW.sms_group_id;
		
		-- 	SELECT telephone_number INTO v_telephone_number
		-- 	FROM members
		-- 	WHERE member_id = reca.member_id;

		-- 	SELECT entity_id INTO v_member_entity_id
		-- 	FROM entitys
		-- 	WHERE member_id = reca.member_id;

		-- 	NEW.sms_number := v_telephone_number;
		-- 	NEW.entity_id := v_member_entity_id;
		-- 	NEW.folder_id := 0;
		-- END IF;

	END IF;
	
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_sms() OWNER TO postgres;

--
-- Name: ins_sms_group_members(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_sms_group_members() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_member_id 		integer;
BEGIN
	
	IF (TG_OP = 'INSERT')THEN
		SELECT member_id INTO v_member_id
		FROM sms_group_members 
		WHERE (org_id = NEW.org_id) AND (member_id = NEW.member_id);

		IF (v_member_id is not null) THEN
			RAISE EXCEPTION 'Member Already Exists in the Group SMS';
		END IF;

	END IF;
	
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_sms_group_members() OWNER TO postgres;

--
-- Name: ins_sub_fields(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_sub_fields() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_ord	integer;
BEGIN
	IF(NEW.sub_field_order is null) THEN
		SELECT max(sub_field_order) INTO v_ord
		FROM sub_fields
		WHERE (field_id = NEW.field_id);

		IF (v_ord is null) THEN
			NEW.sub_field_order := 10;
		ELSE
			NEW.sub_field_order := v_ord + 10;
		END IF;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_sub_fields() OWNER TO postgres;

--
-- Name: ins_subscriptions(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_subscriptions() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_entity_id				integer;
	v_entity_type_id		integer;
	v_org_id				integer;
	v_currency_id			integer;
	v_member_id			integer;
	v_account_number		varchar(32);
	v_product_id			integer;
	v_department_id			integer;
	v_bank_id				integer;
	v_deposit_account		integer;
	v_tax_type_id			integer;
	v_workflow_id			integer;
	v_org_suffix			char(2);
	myrec 					RECORD;
BEGIN

	IF (TG_OP = 'INSERT') THEN
		SELECT entity_id INTO v_entity_id
		FROM entitys WHERE lower(trim(user_name)) = lower(trim(NEW.primary_email));

		IF(v_entity_id is null)THEN
			NEW.entity_id := nextval('entitys_entity_id_seq');
			INSERT INTO entitys (entity_id, org_id, use_key_id, entity_type_id, entity_name, User_name, primary_email,  function_role, first_password)
			VALUES (NEW.entity_id, 0, 5, 5, NEW.primary_contact, lower(trim(NEW.primary_email)), lower(trim(NEW.primary_email)), 'subscription', null);
		
			INSERT INTO sys_emailed (sys_email_id, org_id, table_id, table_name)
			VALUES (4, 0, NEW.entity_id, 'subscription');
		
			NEW.approve_status := 'Completed';
		ELSE
			RAISE EXCEPTION 'You already have an account, login and request for services';
		END IF;
	ELSIF(NEW.approve_status = 'Approved')THEN

		NEW.org_id := nextval('orgs_org_id_seq');
		v_member_id := nextval('members_member_id_seq');
		v_deposit_account := nextval('deposit_accounts_deposit_account_id_seq');
		INSERT INTO orgs(org_id, currency_id, org_name, org_full_name, org_sufix, default_country_id, logo)
		VALUES(NEW.org_id, 1, NEW.business_name, NEW.business_name, NEW.org_id, NEW.country_id, 'logo.png');
		----NEW ORG/SACCO ADDRESSES
		INSERT INTO address (address_name, sys_country_id, table_name, table_id, premises, town, phone_number, website, is_default) 
		VALUES (NEW.business_name, NEW.country_id, 'orgs', NEW.org_id, NEW.business_address, NEW.city, NEW.telephone, NEW.website, true);
		--- CURRENCY
		v_currency_id := nextval('currency_currency_id_seq');
		INSERT INTO currency (org_id, currency_id, currency_name, currency_symbol) VALUES (NEW.org_id, v_currency_id, 'Default Currency', 'DC');
		UPDATE orgs SET currency_id = v_currency_id WHERE org_id = NEW.org_id;
		---CURRENCY RATES
		INSERT INTO currency_rates (org_id, currency_id, exchange_rate) VALUES (NEW.org_id, v_currency_id, 1);

		---- ENTITY TYPES
		INSERT INTO entity_types (org_id, entity_type_name, entity_role, use_key_id)
		SELECT NEW.org_id, entity_type_name, entity_role, use_key_id
		FROM entity_types WHERE org_id = 1;

		-----NEXT OF KINS TYPE
		INSERT INTO kin_types (org_id, kin_type_name)
		SELECT NEW.org_id, kin_type_name
		FROM kin_types WHERE org_id = 1;

		---SACCO POSITIONS
		INSERT INTO position_levels (org_id,position_level_name,narrative)
		SELECT NEW.org_id,position_level_name,narrative
		FROM position_levels
		WHERE org_id = 1;

		---SYS SMS CONFIGURATIONS
		INSERT INTO sms_configs(org_id,use_key_id,sms_config_name,is_active,sms_template)
		SELECT NEW.org_id,use_key_id,sms_config_name,is_active,sms_template
		FROM sms_configs
		WHERE org_id = 1;

		---USER LEVELS FOR SACCO
		INSERT INTO sys_access_levels (use_key_id, org_id, sys_access_level_name, access_tag) VALUES
		(0, NEW.org_id, 'Subscription', 'subscription'),
		(0, NEW.org_id, 'admin', 'admin'),
		(1, NEW.org_id, 'Staff', 'staff'),
		(2, NEW.org_id, 'Client', 'client'),
		(4, NEW.org_id, 'Applicants', 'applicant'),
		(100, NEW.org_id, 'Members', 'members'),
		(100, NEW.org_id, 'Service Desk Module', 'service_desk'),

		(0, NEW.org_id, 'Operations Module', 'operations'),
		(0, NEW.org_id, 'configurations Module', 'configurations'),
		(0, NEW.org_id, 'Loans Module', 'loans'),
		(0, NEW.org_id, 'Processing Module', 'processing'),
		(0, NEW.org_id, 'Transaction Module', 'transactions'),
		(0, NEW.org_id, 'Sacco Report Module', 'sacco_reports');

		---ISSUES LEVEL
		INSERT INTO issue_levels(org_id, issue_level_name)
		SELECT NEW.org_id, issue_level_name
		FROM issue_levels
		WHERE org_id = 1;

		---ISSUE TYPES
		INSERT INTO issue_types (org_id, issue_type_name)
		SELECT NEW.org_id, issue_type_name
		FROM issue_types
		WHERE org_id = 1;

		-----LOCATION AND DEPARTMENT DEFAULT DATA
		INSERT INTO locations (org_id, location_name) VALUES (NEW.org_id, 'Head Office');
		INSERT INTO departments (org_id, department_name) VALUES (NEW.org_id, 'Board of Directors');

		----TAX TYPES
		FOR myrec IN SELECT tax_type_id, use_key_id, tax_type_name, formural, tax_relief, 
			tax_type_order, in_tax, linear, percentage, employer, employer_ps, active,
			account_number, employer_account
			FROM tax_types WHERE org_id = 1 AND ((sys_country_id is null) OR (sys_country_id = NEW.country_id))
			ORDER BY tax_type_id 
		LOOP
			v_tax_type_id := nextval('tax_types_tax_type_id_seq');
			INSERT INTO tax_types (org_id, tax_type_id, use_key_id, tax_type_name, formural, tax_relief, tax_type_order, in_tax, linear, percentage, employer, employer_ps, active, currency_id, account_number, employer_account)
			VALUES (NEW.org_id, v_tax_type_id, myrec.use_key_id, myrec.tax_type_name, myrec.formural, myrec.tax_relief, myrec.tax_type_order, myrec.in_tax, myrec.linear, myrec.percentage, myrec.employer, myrec.employer_ps, myrec.active, v_currency_id, myrec.account_number, myrec.employer_account);
			
			INSERT INTO tax_rates (org_id, tax_type_id, tax_range, tax_rate)
			SELECT NEW.org_id,  v_tax_type_id, tax_range, tax_rate
			FROM tax_rates
			WHERE org_id = 1 and tax_type_id = myrec.tax_type_id;
		END LOOP;

		------BANKS AND BANK BRANCHS
		v_bank_id := nextval('banks_bank_id_seq');
		INSERT INTO banks (org_id, bank_id, bank_name) VALUES (NEW.org_id, v_bank_id, 'Cash');
		INSERT INTO bank_branch (org_id, bank_id, bank_branch_name) VALUES (NEW.org_id, v_bank_id, 'Cash');

		----TRANSACTION COUNTERS
		INSERT INTO transaction_counters(transaction_type_id, org_id, document_number)
		SELECT transaction_type_id, NEW.org_id, 1
		FROM transaction_types;	
		
		----ACCOUNT CLASSES
		INSERT INTO account_class (org_id, account_class_no, chat_type_id, chat_type_name, account_class_name)
		SELECT NEW.org_id, account_class_no, chat_type_id, chat_type_name, account_class_name
		FROM account_class
		WHERE org_id = 1;
		----ACCOUNT TYPES
		INSERT INTO account_types (org_id, account_class_id, account_type_no, account_type_name)
		SELECT a.org_id, a.account_class_id, b.account_type_no, b.account_type_name
		FROM account_class a INNER JOIN vw_account_types b ON a.account_class_no = b.account_class_no
		WHERE (a.org_id = NEW.org_id) AND (b.org_id = 1);
		----ACCOUNTS
		INSERT INTO accounts (org_id, account_type_id, account_no, account_name)
		SELECT a.org_id, a.account_type_id, b.account_no, b.account_name
		FROM account_types a INNER JOIN vw_accounts b ON a.account_type_no = b.account_type_no
		WHERE (a.org_id = NEW.org_id) AND (b.org_id = 1);
		-----DEFAULT ACCOUNTS
		INSERT INTO default_accounts (org_id, use_key_id, account_id)
		SELECT c.org_id, a.use_key_id, c.account_id
		FROM default_accounts a INNER JOIN accounts b ON a.account_id = b.account_id
			INNER JOIN accounts c ON b.account_no = c.account_no
		WHERE (a.org_id = 1) AND (c.org_id = NEW.org_id);
		---ITEM CATEGORIES
		INSERT INTO item_category (org_id, item_category_name) VALUES (NEW.org_id, 'Services');
		INSERT INTO item_category (org_id, item_category_name) VALUES (NEW.org_id, 'Goods');
		INSERT INTO item_units (org_id, item_unit_name) VALUES (NEW.org_id, 'Each');
		
		SELECT entity_type_id INTO v_entity_type_id
		FROM entity_types 
		WHERE (org_id = NEW.org_id) AND (use_key_id = 0);
				
		UPDATE entitys SET org_id = NEW.org_id, entity_type_id = v_entity_type_id, function_role='subscription,admin,manager'
		WHERE entity_id = NEW.entity_id;
		
		UPDATE entity_subscriptions SET org_id = NEW.org_id, entity_type_id = v_entity_type_id
		WHERE entity_id = NEW.entity_id;
		
		INSERT INTO collateral_types (org_id, collateral_type_name) VALUES (NEW.org_id, 'Property Title Deed');

		---ACCOUNT TYPES
		INSERT INTO activity_types (cr_account_id, dr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no)
		SELECT dra.account_id, cra.account_id, vw_activity_types.use_key_id, NEW.org_id, 
			vw_activity_types.activity_type_name, vw_activity_types.is_active, vw_activity_types.activity_type_no
		FROM vw_activity_types
			INNER JOIN accounts dra ON vw_activity_types.dr_account_no = dra.account_no
			INNER JOIN accounts cra ON vw_activity_types.cr_account_no = cra.account_no
		WHERE (dra.org_id = NEW.org_id) AND (cra.org_id = NEW.org_id) AND (vw_activity_types.org_id = 1)
		ORDER BY vw_activity_types.activity_type_id;
		
		v_account_number := '4' || lpad(NEW.org_id::varchar, 2, '0')  || lpad(v_member_id::varchar, 4, '0');

		INSERT INTO interest_methods (activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, interest_method_no, account_number)
		SELECT oa.activity_type_id, oa.org_id, interest_methods.interest_method_name, 
			interest_methods.reducing_balance, interest_methods.reducing_payments, 
			interest_methods.formural, interest_methods.interest_method_no,
			v_account_number || lpad((v_deposit_account + 3)::varchar, 2, '0') 
		FROM interest_methods INNER JOIN activity_types ON interest_methods.activity_type_id = activity_types.activity_type_id
			INNER JOIN activity_types oa ON activity_types.activity_type_no = oa.activity_type_no
		WHERE (activity_types.org_id = 1) AND (oa.org_id = NEW.org_id)
		ORDER BY interest_methods.interest_method_id;

		---PENALTY METHODS
		INSERT INTO penalty_methods(activity_type_id, org_id, penalty_method_name, formural, penalty_method_no, account_number)
		SELECT oa.activity_type_id, oa.org_id, penalty_methods.penalty_method_name, 
			penalty_methods.formural, penalty_methods.penalty_method_no,
			v_account_number || lpad((v_deposit_account + 4)::varchar, 2, '0') 
		FROM penalty_methods INNER JOIN activity_types ON penalty_methods.activity_type_id = activity_types.activity_type_id
			INNER JOIN activity_types oa ON activity_types.activity_type_no = oa.activity_type_no
		WHERE (activity_types.org_id = 1) AND (oa.org_id = NEW.org_id)
		ORDER BY penalty_methods.penalty_method_id;

		---PRODUCTS
		INSERT INTO products(interest_method_id, penalty_method_id, activity_frequency_id, 
			currency_id, org_id, product_name, description, loan_account, 
			is_active, interest_rate, min_opening_balance, lockin_period_frequency, 
			minimum_balance, maximum_balance, minimum_day, maximum_day, minimum_trx, 
			maximum_trx, maximum_repayments, product_no,  approve_status)
		SELECT interest_methods.interest_method_id, penalty_methods.penalty_method_id, vw_products.activity_frequency_id, 
			v_currency_id, NEW.org_id, vw_products.product_name, vw_products.description, vw_products.loan_account, 
			vw_products.is_active, vw_products.interest_rate, vw_products.min_opening_balance, vw_products.lockin_period_frequency, 
			vw_products.minimum_balance, vw_products.maximum_balance, vw_products.minimum_day, vw_products.maximum_day, vw_products.minimum_trx, 
			vw_products.maximum_trx, vw_products.maximum_repayments, vw_products.product_no, vw_products.approve_status
		FROM vw_products INNER JOIN interest_methods ON vw_products.interest_method_no = interest_methods.interest_method_no
			INNER JOIN penalty_methods ON vw_products.penalty_method_no = penalty_methods.penalty_method_no
		WHERE (vw_products.org_id = 1) 
			AND (interest_methods.org_id = NEW.org_id) AND (penalty_methods.org_id = NEW.org_id)
		ORDER BY vw_products.product_id;
		
		---ACCOUNT DEFINATIONS
		INSERT INTO account_definations(product_id, activity_type_id, charge_activity_id, 
			activity_frequency_id, org_id, account_defination_name, start_date, 
			end_date, fee_amount, fee_ps, has_charge, is_active, account_number)
		SELECT products.product_id, activity_types.activity_type_id, charge_activity.activity_type_id, 
			ad.activity_frequency_id, NEW.org_id, ad.account_defination_name, 
			ad.start_date, ad.end_date, ad.fee_amount, 
			ad.fee_ps, ad.has_charge, ad.is_active, 
			v_account_number || lpad((v_deposit_account + ad.account_number::integer)::varchar, 2, '0')
		FROM vw_account_definations as ad INNER JOIN products ON ad.product_no = products.product_no
			INNER JOIN activity_types ON ad.activity_type_no = activity_types.activity_type_no
			INNER JOIN activity_types as charge_activity ON ad.charge_activity_no = charge_activity.activity_type_no
		WHERE (ad.org_id = 1) 
			AND (products.org_id = NEW.org_id) AND (activity_types.org_id = NEW.org_id) AND (charge_activity.org_id = NEW.org_id);

		SELECT product_id INTO v_product_id
		FROM products WHERE (product_no = 0) AND (org_id = NEW.org_id);
		
		INSERT INTO members (member_id, org_id, business_account, member_name, identification_number, identification_type, member_email, telephone_number, date_of_birth, nationality, approve_status)
		VALUES (v_member_id, NEW.org_id, 2, NEW.business_name, '0', 'Org', NEW.primary_email, NEW.telephone, current_date, NEW.country_id, 'Approved');

		INSERT INTO deposit_accounts (member_id, product_id, org_id, is_active, approve_status, narrative, minimum_balance) VALUES 
		(v_member_id, v_product_id, NEW.org_id, true, 'Approved', 'Deposits', -100000000000),
		(v_member_id, v_product_id, NEW.org_id, true, 'Approved', 'Charges', -100000000000),
		(v_member_id, v_product_id, NEW.org_id, true, 'Approved', 'Interest', -100000000000),
		(v_member_id, v_product_id, NEW.org_id, true, 'Approved', 'Penalty', -100000000000),
		(v_member_id, v_product_id, NEW.org_id, true, 'Approved', 'Shares', -100000000000);
		
		INSERT INTO workflows (link_copy, org_id, source_entity_id, workflow_name, table_name, approve_email, reject_email) 
		SELECT aa.workflow_id, cc.org_id, cc.entity_type_id, aa.workflow_name, aa.table_name, aa.approve_email, aa.reject_email
		FROM workflows aa INNER JOIN entity_types bb ON aa.source_entity_id = bb.entity_type_id
			INNER JOIN entity_types cc ON bb.use_key_id = cc.use_key_id
		WHERE aa.org_id = 1 AND cc.org_id = NEW.org_id
		ORDER BY aa.workflow_id;

		INSERT INTO workflow_phases (org_id, workflow_id, approval_entity_id, approval_level, return_level, 
			escalation_days, escalation_hours, required_approvals, advice, notice, 
			phase_narrative, advice_email, notice_email) 
		SELECT bb.org_id, bb.workflow_id, dd.entity_type_id, aa.approval_level, aa.return_level, 
			aa.escalation_days, aa.escalation_hours, aa.required_approvals, aa.advice, aa.notice, 
			aa.phase_narrative, aa.advice_email, aa.notice_email
		FROM workflow_phases aa INNER JOIN workflows bb ON aa.workflow_id = bb.link_copy
			INNER JOIN entity_types cc ON aa.approval_entity_id = cc.entity_type_id
			INNER JOIN entity_types dd ON cc.use_key_id = dd.use_key_id
		WHERE aa.org_id = 1 AND bb.org_id = NEW.org_id AND dd.org_id = NEW.org_id;
		
		INSERT INTO sys_emails (org_id, use_type, sys_email_name, title, details)
		SELECT NEW.org_id, use_type, sys_email_name, title, details
		FROM sys_emails
		WHERE org_id = 1;

		INSERT INTO sys_emailed (sys_email_id, org_id, table_id, table_name)
		VALUES (5, NEW.org_id, NEW.entity_id, 'subscription');
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_subscriptions() OWNER TO postgres;

--
-- Name: ins_sys_reset(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_sys_reset() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_entity_id			integer;
	v_org_id			integer;
	v_sys_email_id		integer;
	v_password			varchar(32);
BEGIN
	SELECT entity_id, org_id INTO v_entity_id, v_org_id
	FROM entitys
	WHERE (lower(trim(primary_email)) = lower(trim(NEW.request_email)));

	IF(v_entity_id is not null) THEN
		v_password := upper(substring(md5(random()::text) from 3 for 9));

		UPDATE entitys SET first_password = v_password, entity_password = md5(v_password)
		WHERE entity_id = v_entity_id;

		SELECT sys_email_id INTO v_sys_email_id
		FROM sys_emails WHERE (use_type = 3) AND (org_id = v_org_id);

		INSERT INTO sys_emailed (org_id, sys_email_id, table_id, table_name)
		VALUES(v_org_id, v_sys_email_id, v_entity_id, 'entitys');
	END IF;

	RETURN NULL;
END;
$$;


ALTER FUNCTION public.ins_sys_reset() OWNER TO postgres;

--
-- Name: ins_transactions(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_transactions() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_counter_id	integer;
	transid 		integer;
	currid			integer;
BEGIN

	IF(TG_OP = 'INSERT') THEN
		SELECT transaction_counter_id, document_number INTO v_counter_id, transid
		FROM transaction_counters 
		WHERE (transaction_type_id = NEW.transaction_type_id) AND (org_id = NEW.org_id);
		UPDATE transaction_counters SET document_number = transid + 1 
		WHERE (transaction_counter_id = v_counter_id);

		NEW.document_number := transid;
		IF(NEW.currency_id is null)THEN
			SELECT currency_id INTO NEW.currency_id
			FROM orgs
			WHERE (org_id = NEW.org_id);
		END IF;
				
		IF(NEW.payment_date is null) AND (NEW.transaction_date is not null)THEN
			NEW.payment_date := NEW.transaction_date;
		END IF;
	ELSE
	
		--- Ensure the direct expediture items are not added
		IF (OLD.ledger_type_id is null) AND (NEW.ledger_type_id is not null) THEN
			NEW.ledger_type_id := null;
		END IF;
			
		IF (OLD.journal_id is null) AND (NEW.journal_id is not null) THEN
		ELSIF ((OLD.approve_status != 'Completed') AND (NEW.approve_status = 'Completed')) THEN
			NEW.completed = true;
		ELSIF ((OLD.approve_status = 'Completed') AND (NEW.approve_status != 'Completed')) THEN
		ELSIF ((OLD.is_cleared = false) AND (NEW.is_cleared = true)) THEN
		ELSIF ((OLD.journal_id is not null) AND (OLD.transaction_status_id = NEW.transaction_status_id)) THEN
			RAISE EXCEPTION 'Transaction % is already posted no changes are allowed.', NEW.transaction_id;
		ELSIF ((OLD.transaction_status_id > 1) AND (OLD.transaction_status_id = NEW.transaction_status_id)) THEN
			RAISE EXCEPTION 'Transaction % is already completed no changes are allowed.', NEW.transaction_id;
		END IF;
	END IF;
	
	IF ((NEW.approve_status = 'Draft') AND (NEW.completed = true)) THEN
		NEW.approve_status := 'Completed';
		NEW.transaction_status_id := 2;
	END IF;
	
	IF(NEW.transaction_type_id = 7)THEN
		NEW.tx_type := 1;
	END IF;
	IF(NEW.transaction_type_id = 8)THEN
		NEW.tx_type := -1;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_transactions() OWNER TO postgres;

--
-- Name: ins_transfer_beneficiary(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.ins_transfer_beneficiary() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_member_id			integer;
BEGIN

	SELECT member_id INTO NEW.member_id
	FROM entitys WHERE (entity_id = NEW.entity_id);
	
	SELECT deposit_account_id, member_id INTO NEW.deposit_account_id, v_member_id
	FROM deposit_accounts
	WHERE (is_active = true) AND (approve_status = 'Approved')
		AND (account_number = NEW.account_number);
		
	IF(NEW.deposit_account_id is null)THEN
		RAISE EXCEPTION 'The account needs to exist and be active';
	ELSIF(NEW.member_id = v_member_id)THEN
		RAISE EXCEPTION 'You cannot add your own account as a beneficiary account';
	END IF;
	
	IF(TG_OP = 'INSERT')THEN
		NEW.approve_status = 'Completed';
	END IF;
	
	RETURN NEW;
END;
$$;


ALTER FUNCTION public.ins_transfer_beneficiary() OWNER TO postgres;

--
-- Name: issue_tracking(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.issue_tracking(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg 					varchar(120);
	reca 					RECORD;
	v_entity_id 			integer;
BEGIN

	msg := null;
	---clossing the issue
	IF($3 = '1')THEN
		SELECT problem, solution INTO reca FROM helpdesk WHERE helpdesk_id = $1::integer;

		IF ((reca.problem is null) AND (reca.solution is null)) THEN
			RAISE EXCEPTION 'You must provide the solution to the issue before closing the issue...!';
		ELSE
			UPDATE helpdesk SET closed_by = $2::integer, solved_time = current_timestamp, is_solved = true,
			curr_action = 'Done', curr_status = 'Closed'
			WHERE helpdesk_id = $1::integer;
		END IF;
		msg := 'Closed the call';
	END IF;

	---escalating the issue
	IF($3 = '3')THEN
		SELECT entity_id INTO v_entity_id FROM entitys WHERE entity_id = $1::integer;

		UPDATE helpdesk SET escalated_to = v_entity_id, is_escalated = true, curr_action = 'Escalated/Fowarded',escalated_by = $2::integer
		WHERE helpdesk_id = cast($4 as int);			
		msg := 'Issue Escalated/Assigned Successfully...';
			
	END IF;
	
	return msg;
END;
$_$;


ALTER FUNCTION public.issue_tracking(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: loan_approval(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.loan_approval(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	reca 						RECORD;
	v_deposit_account_id		integer;
	v_principal_amount			real;
	v_repayment_amount			real;
	v_maximum_repayments		integer;
	v_repayment_period			integer;
	v_contribution_amount		real;
	v_guaranteed_amount		    real;
	v_total_amount			    real;
	v_collateral_amount 		real;
	v_is_guaranteed 			boolean;
	v_is_collateral 			boolean;
	recb 						RECORD;
	v_entry_date 				date;
BEGIN
	---SUBMISSION FOR LOAN APPROVAL
	IF($3 = '1')THEN
		UPDATE loans SET loan_status = 'Completed', approve_status = 'Completed'
		WHERE (loan_id = $1::integer) AND (approve_status = 'Draft') AND (loan_status = 'Processing');
			
			msg := 'Applied for loan Approval';
	END IF;

	---LOAN APPLICATION PROCESSING 
	----(member loan application process check for securities)
	IF($3 = '2')THEN
		---get application details for loan product and deposit account
		SELECT deposit_accounts.deposit_account_id, loans.principal_amount, loans.repayment_amount,
				loans.repayment_period, products.maximum_repayments,loans.is_collateral, loans.is_guaranteed
			INTO v_deposit_account_id, v_principal_amount, v_repayment_amount, v_repayment_period, v_maximum_repayments
		FROM deposit_accounts INNER JOIN loans ON (deposit_accounts.account_number = loans.disburse_account)
			INNER JOIN products ON loans.product_id = products.product_id
			AND (deposit_accounts.member_id = loans.member_id) AND (loans.loan_id = $1::integer)
			AND (deposit_accounts.approve_status = 'Approved');

		---get contribution available balance
		SELECT COALESCE((available_balance),0)  INTO v_contribution_amount
		FROM vw_deposit_accounts INNER JOIN loans ON loans.member_id = vw_deposit_accounts.member_id
		WHERE (loans.loan_id = $1::integer)
		AND (product_no = 2);

		---get total guarantees for the loan
		v_guaranteed_amount := 0;
		SELECT COALESCE(sum(guarantee_amount),0) AS total_guarentee INTO v_guaranteed_amount
		FROM guarantees
		WHERE guarantee_accepted = true AND (approve_status = 'Approved') 
		AND (is_active = true) AND (loan_id = $1::integer);

		---get total collateral value
		v_collateral_amount := 0;
		SELECT COALESCE(sum(collateral_amount),0) AS total_collateral INTO v_collateral_amount
		FROM collaterals
		WHERE collateral_received = true AND (approve_status = 'Approved') 
		AND (collateral_released = false) AND (loan_id = $1::integer);	

		---get member entry date to the sacco
		SELECT entry_date into v_entry_date FROM members
		INNER JOIN loans ON loans.member_id = members.member_id
		WHERE (loan_id = $1::integer);	

		---check the disbursment account
		IF(v_deposit_account_id is null)THEN
			msg := 'The disburse account needs to be active and owned by the member';
			RAISE EXCEPTION '%', msg;

		---check repaymemnt period
		ELSIF(v_repayment_period > v_maximum_repayments)THEN
			msg := 'The repayment periods are more than what is prescribed by the product';
			RAISE EXCEPTION '%', msg;
		END IF;

		---CHECK LOAN SECURITIES
		SELECT is_guaranteed,is_collateral INTO recb FROM loans WHERE loan_id = $1::integer;

		----loans with guarantee requirement
		IF (recb.is_guaranteed = true) THEN
			---getting the total
			v_total_amount = v_contribution_amount + v_guaranteed_amount;

			IF(v_principal_amount > v_total_amount)THEN
				msg := 'The Guaranteed amount Value is less than Total Amount of Loan Requested...';
				RAISE EXCEPTION '%',msg;
			ELSE
				UPDATE loans SET loan_status = 'Processing'
				WHERE (loan_id = $1::integer) AND (approve_status = 'Draft');
				
				msg := 'Applied for loan approval';
				END IF;
		END IF;

		----loan collateral requirement
		IF (recb.is_collateral = true) THEN
			---getting the total
			v_total_amount = v_contribution_amount + v_collateral_amount;

			IF(v_principal_amount > v_total_amount)THEN
				msg := 'The Collateral amount Value is less than Total Amount of Loan Requested...';
				RAISE EXCEPTION '%',msg;
			ELSE
				UPDATE loans SET loan_status = 'Processing'
				WHERE (loan_id = $1::integer) AND (approve_status = 'Draft');
				
				msg := 'Applied for loan approval';
			END IF;
		END IF;

		----loan guarantee and collateral requirement
		IF ((recb.is_guaranteed = true) AND (recb.is_collateral = true)) THEN
			---getting the total
			v_total_amount = v_contribution_amount + v_collateral_amount + v_guaranteed_amount;
			
			IF(v_principal_amount > v_total_amount)THEN
				msg := 'The total guaranteed and Collateral amount is less than Total Amount of Loan Requested...';
				RAISE EXCEPTION '%', msg;
			ELSE
				UPDATE loans SET loan_status = 'Processing'
				WHERE (loan_id = $1::integer) AND (approve_status = 'Draft');
				
				msg := 'Applied for loan approval';
			END IF;
		END IF;

		----loan no collateral/guarantee requirement
		IF ((recb.is_guaranteed = false) and (recb.is_collateral = false)) THEN
			
			UPDATE loans SET loan_status = 'Processing'
			WHERE (loan_id = $1::integer) AND (approve_status = 'Draft');
			
			msg := 'Loan Approval Application Successful..';
		END IF;
	END IF;

	-- FULLY SETTLED LOANS UPDATE AND RELEASE OF GUARANTORS AND COLLATERALS
	IF($3 = '3')THEN
		--- get loan balances
		SELECT vw_loan_balance.loan_balance INTO reca FROM vw_loan_balance
		WHERE vw_loan_balance.loan_id = $1::integer;

		IF (reca.loan_balance = 0::real) THEN
			---update loans table
			UPDATE loans SET loan_status = 'Settled', is_active = false
			WHERE (loan_id = $1::integer) AND (approve_status = 'Approved') AND (is_active = true);

			--update guarantees table			
			UPDATE guarantees SET is_active = false, details = 'Loan Fully Paid back'
			WHERE (loan_id = $1::integer) AND (is_active = true);
			
			msg := 'Loan Fully Paid back.. updated successfully';
		ELSE
			--msg := 'Loan NOT Fully Paid back..';
			RAISE EXCEPTION 'Loan NOT Fully Paid back.. Loan Balance:- % ',reca.loan_balance;
		END IF;	
	END IF;	

	---SET LOAN AS DEFAULTED AND NOTIFY THE GUARANTORS
	IF($3 = '4')THEN
		UPDATE loans SET loan_status = 'Defaulted', is_active = false
		WHERE (loan_id = $1::integer) AND (approve_status = 'Processing') AND (is_active = true);
		
		msg := 'Loan Defaulted. updated';
	
	END IF;

	---LOAN FINAL APPROVAL FOR DISBURSEMENT
	IF($3 = '5')THEN

		UPDATE loans SET approve_status = 'Approved', action_date = current_date 
		WHERE (loan_id = $1::integer) AND (approve_status = 'Processing');
		
		msg := 'Loan Approved and Disbursed to member transaction account';
	
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.loan_approval(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: loan_approval_final(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.loan_approval_final(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	reca 						RECORD;
	v_deposit_account_id		integer;
	v_product_id				integer;
	v_principal_amount			real;
	v_repayment_amount			real;
	v_maximum_repayments		integer;
	v_repayment_period			integer;
	v_contribution_amount		real;
	v_guaranteed_amount		    real;
	v_total_amount			    real;
	v_collateral_amount 		real;
	v_is_guaranteed 			boolean;
	v_is_collateral 			boolean;
	recb 						RECORD;
	v_entry_date 				date;
	v_membership_period			integer;
	v_config_period				integer;
	v_approval_count 			integer;
BEGIN
	---SUBMISSION FOR LOAN APPROVAL
	IF($3 = '1')THEN
		SELECT COALESCE(COUNT(loan_id)) AS loan_approval_count INTO v_approval_count 
		FROM loan_approval_levels
		WHERE (loan_id = $1::integer) AND (is_approved = false);
		
		IF(v_approval_count = 0) THEN
			UPDATE loans SET loan_status = 'Completed', approve_status = 'Completed'
			WHERE (loan_id = $1::integer) AND (approve_status = 'Draft') AND (loan_status = 'Processing');
				
			msg := 'Applied for loan Approval';
		ELSE
			RAISE EXCEPTION 'Pending Processing Approval Detected...!';
		END IF;
	END IF;

	---LOAN APPLICATION PROCESSING 
	----(member loan application process check for securities)
	IF($3 = '2')THEN
		---get application details for loan product and deposit account
		SELECT deposit_accounts.deposit_account_id, loans.principal_amount, loans.repayment_amount,
				loans.repayment_period, products.maximum_repayments,products.product_id
			INTO v_deposit_account_id, v_principal_amount, v_repayment_amount, v_repayment_period, v_maximum_repayments,
			v_product_id
		FROM deposit_accounts INNER JOIN loans ON (deposit_accounts.account_number = loans.disburse_account)
			INNER JOIN products ON loans.product_id = products.product_id
			AND (deposit_accounts.member_id = loans.member_id) AND (loans.loan_id = $1::integer)
			AND (deposit_accounts.approve_status = 'Approved');

		---get contribution available balance
		SELECT COALESCE((available_balance),0)  INTO v_contribution_amount
		FROM vw_deposit_accounts INNER JOIN loans ON loans.member_id = vw_deposit_accounts.member_id
		WHERE (loans.loan_id = $1::integer)
		AND (product_no = 2);

		---get total guarantees for the loan
		v_guaranteed_amount := 0;
		SELECT COALESCE(sum(guarantee_amount),0) AS total_guarentee INTO v_guaranteed_amount
		FROM guarantees
		WHERE guarantee_accepted = true AND (approve_status = 'Approved') 
		AND (is_active = true) AND (loan_id = $1::integer);

		---get total collateral value
		v_collateral_amount := 0;
		SELECT COALESCE(sum(collateral_amount),0) AS total_collateral INTO v_collateral_amount
		FROM collaterals
		WHERE collateral_received = true AND (approve_status = 'Approved') 
		AND (collateral_released = false) AND (loan_id = $1::integer);	

		---get member entry date to the sacco
		SELECT entry_date into v_entry_date FROM members
		INNER JOIN loans ON loans.member_id = members.member_id
		WHERE (loan_id = $1::integer);

		---get member's membership duration in months
		SELECT EXTRACT(YEAR FROM AGE(current_date, entry_date)) * 12 +
		EXTRACT(MONTH FROM AGE(current_date ,entry_date))AS membership_period INTO v_membership_period
		FROM members
		INNER JOIN loans ON loans.member_id = members.member_id
		WHERE (loan_id = $1::integer);

		---=====CHECKS FOR THE LOAN REQUIREMENTS======

		---check the disbursment account
		IF(v_deposit_account_id is null)THEN
			msg := 'The disburse account needs to be active and owned by the member';
			RAISE EXCEPTION '%', msg;

		---check repaymemnt period
		ELSIF(v_repayment_period > v_maximum_repayments)THEN
			msg := 'The repayment periods are more than what is prescribed by the product';
			RAISE EXCEPTION '%', msg;
		END IF;

		---CHECK LOAN SECURITIES CONFIGURATION
		SELECT loan_config_id,org_id,product_id,is_guaranteed,is_collateral,membership_period,less_guaranteed,
		is_active INTO recb
		FROM loan_configs
		WHERE product_id = v_product_id;

		IF(recb.loan_config_id is null) THEN
			msg:= 'The Sacco loan product has not being configured.....';
			RAISE EXCEPTION '%', msg;
		END IF;

		---check membership period requirement
		IF(recb.membership_period > v_membership_period::int) THEN
			msg:= 'You do not meet the membership period to qualify for this loan...';
			RAISE EXCEPTION ' %',msg;
		END IF;

		----loans with guarantee requirement
		IF (recb.is_guaranteed = true) THEN
			---getting the total
			v_total_amount = v_contribution_amount + v_guaranteed_amount;

			IF(v_principal_amount > v_total_amount)THEN
				msg := 'The Guaranteed amount Value is less than Total Amount of Loan Requested...';
				RAISE EXCEPTION '%',msg;
			ELSE
				UPDATE loans SET loan_status = 'Processing'
				WHERE (loan_id = $1::integer) AND (approve_status = 'Draft');
				
				msg := 'Applied for loan approval';
				END IF;
		END IF;

		----loan collateral requirement
		IF (recb.is_collateral = true) THEN
			---getting the total
			v_total_amount = v_contribution_amount + v_collateral_amount;

			IF(v_principal_amount > v_total_amount)THEN
				msg := 'The Collateral amount Value is less than Total Amount of Loan Requested...';
				RAISE EXCEPTION '%',msg;
			ELSE
				UPDATE loans SET loan_status = 'Processing'
				WHERE (loan_id = $1::integer) AND (approve_status = 'Draft');
				
				msg := 'Applied for loan approval';
			END IF;
		END IF;

		----loan guarantee and collateral requirement
		IF ((recb.is_guaranteed = true) AND (recb.is_collateral = true)) THEN
			---getting the total
			v_total_amount = v_contribution_amount + v_collateral_amount + v_guaranteed_amount;
			
			IF(v_principal_amount > v_total_amount)THEN
				msg := 'The total guaranteed and Collateral amount is less than Total Amount of Loan Requested...';
				RAISE EXCEPTION '%', msg;
			ELSE
				UPDATE loans SET loan_status = 'Processing'
				WHERE (loan_id = $1::integer) AND (approve_status = 'Draft');
				
				msg := 'Applied for loan approval';
			END IF;
		END IF;

		----loan no collateral/guarantee requirement
		IF ((recb.is_guaranteed = false) and (recb.is_collateral = false)) THEN
			
			UPDATE loans SET loan_status = 'Processing'
			WHERE (loan_id = $1::integer) AND (approve_status = 'Draft');
			
			msg := 'Loan Approval Application Successful..';
		END IF;
	END IF;

	-- FULLY SETTLED LOANS UPDATE AND RELEASE OF GUARANTORS AND COLLATERALS
	IF($3 = '3')THEN
		--- get loan balances
		SELECT vw_loan_balance.loan_balance INTO reca FROM vw_loan_balance
		WHERE vw_loan_balance.loan_id = $1::integer;

		IF (reca.loan_balance = 0::real) THEN
			---update loans table
			UPDATE loans SET loan_status = 'Settled', is_active = false
			WHERE (loan_id = $1::integer) AND (approve_status = 'Approved') AND (is_active = true);

			--update guarantees table			
			UPDATE guarantees SET is_active = false, details = 'Loan Fully Paid back'
			WHERE (loan_id = $1::integer) AND (is_active = true);
			
			msg := 'Loan Fully Paid back.. updated successfully';
		ELSE
			--msg := 'Loan NOT Fully Paid back..';
			RAISE EXCEPTION 'Loan NOT Fully Paid back.. Loan Balance:- % ',reca.loan_balance;
		END IF;	
	END IF;	

	---SET LOAN AS DEFAULTED AND NOTIFY THE GUARANTORS
	IF($3 = '4')THEN
		UPDATE loans SET loan_status = 'Defaulted', is_active = false
		WHERE (loan_id = $1::integer) AND (approve_status = 'Approved') AND (is_active = true);
		
		msg := 'Loan Defaulted. updated';
	
	END IF;

	---LOAN FINAL APPROVAL FOR DISBURSEMENT
	IF($3 = '5')THEN

		UPDATE loans SET approve_status = 'Approved', action_date = current_date 
		WHERE (loan_id = $1::integer) AND (approve_status = 'Draft');
		
		msg := 'Loan Approved and Disbursed to member transaction account';
	
	END IF;

	-----final approval and disbursment
	IF($3 = '9')THEN
		
			UPDATE loans SET loan_status = 'Approved', approve_status = 'Approved', action_date = now()
			WHERE (loan_id = $1::integer) AND (approve_status = 'Completed');
				
			msg := 'Loan approved successfully... Amount disbursed to members transaction account..';
		
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.loan_approval_final(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: loan_workflow_approval(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.loan_workflow_approval(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	reca 						RECORD;	
BEGIN
	---- loan processing approval
	IF($3 = '1')THEN

		UPDATE loan_approval_levels SET is_approved = true,approved_time = now(), entity_id = $2::integer, 
		status = 'Approval_Accepted', details = ('approved on'|| ' :- ' ||current_date)
		WHERE (loan_approval_level_id = $1::integer);

		msg := 'Loan Approved Successfully...';
	
	END IF;
	-----reject approval
	IF($3 = '2')THEN
		SELECT details INTO reca FROM loan_approval_levels WHERE (loan_approval_level_id = $1::integer);
		--- details = ('Approval Rejected on'|| ' :- ' ||current_date)
		IF(reca.details is null) THEN
			RAISE EXCEPTION 'Give details for Rejecting the loan Approval....';
		ELSE
			UPDATE loan_approval_levels SET is_approved = false ,approved_time = now(), entity_id = $2::integer, 
			status='Approval_Rejected'
			WHERE (loan_approval_level_id = $1::integer);

			msg := 'Loan Approval Rejected...';
		END IF;
	
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.loan_workflow_approval(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: log_account_activity(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.log_account_activity() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	INSERT INTO log.lg_account_activity_log(account_activity_id, deposit_account_id, 
		transfer_account_id, activity_type_id, activity_frequency_id, 
		activity_status_id, commodity_trade_id, period_id, entity_id,
		loan_id, transfer_loan_id, org_id, link_activity_id, deposit_account_no, 
		transfer_link_id, transfer_account_no, activity_date, value_date, account_credit, 
		account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate,
		application_date, approve_status, 
		workflow_table_id, action_date, details)
    VALUES (OLD.account_activity_id, OLD.deposit_account_id, 
		OLD.transfer_account_id, OLD.activity_type_id, OLD.activity_frequency_id, 
		OLD.activity_status_id, OLD.commodity_trade_id, OLD.period_id, OLD.entity_id,
		OLD.loan_id, OLD.transfer_loan_id, OLD.org_id, OLD.link_activity_id, OLD.deposit_account_no, 
		OLD.transfer_link_id, OLD.transfer_account_no, OLD.activity_date, OLD.value_date, OLD.account_credit, 
		OLD.account_debit, OLD.balance, OLD.exchange_rate, OLD.invert_rate, OLD.trading_rate, OLD.mean_rate,
		OLD.application_date, OLD.approve_status, 
		OLD.workflow_table_id, OLD.action_date, OLD.details);
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.log_account_activity() OWNER TO postgres;

--
-- Name: log_collaterals(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.log_collaterals() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	INSERT INTO logs.lg_collaterals(collateral_id, loan_id, collateral_type_id, entity_id, org_id, 
		collateral_amount, collateral_received, collateral_released, 
		application_date, approve_status, workflow_table_id, action_date, details)
	VALUES (OLD.collateral_id, OLD.loan_id, OLD.collateral_type_id, OLD.entity_id, OLD.org_id,
		OLD.collateral_amount, OLD.collateral_received, OLD.collateral_released,
		OLD.application_date, OLD.approve_status, OLD.workflow_table_id, OLD.action_date, OLD.details);
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.log_collaterals() OWNER TO postgres;

--
-- Name: log_commodity_trades(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.log_commodity_trades() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	INSERT INTO logs.lg_commodity_trades(commodity_trade_id, deposit_account_id, transfer_account_id, 
		commodity_id, entity_id, use_key_id, org_id, transfer_account_no, 
		link_activity_id, unit_debit, unit_credit, price, trade_date, 
		application_date, approve_status, workflow_table_id, action_date, details)
	VALUES (OLD.commodity_trade_id, OLD.deposit_account_id, OLD.transfer_account_id, 
		OLD.commodity_id, OLD.entity_id, OLD.use_key_id, OLD.org_id, OLD.transfer_account_no, 
		OLD.link_activity_id, OLD.unit_debit, OLD.unit_credit, OLD.price, OLD.trade_date, 
		OLD.application_date, OLD.approve_status, OLD.workflow_table_id, OLD.action_date, OLD.details);
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.log_commodity_trades() OWNER TO postgres;

--
-- Name: log_deposit_accounts(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.log_deposit_accounts() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	INSERT INTO logs.lg_deposit_accounts(deposit_account_id, member_id, product_id, activity_frequency_id, 
		entity_id, org_id, is_active, account_number, narrative, opening_date, 
		last_closing_date, credit_limit, minimum_balance, maximum_balance, 
		interest_rate, lockin_period_frequency, lockedin_until_date, 
		application_date, approve_status, workflow_table_id, action_date, details)
	VALUES (OLD.deposit_account_id, OLD.member_id, OLD.product_id, OLD.activity_frequency_id,
		OLD.entity_id, OLD.org_id, OLD.is_active, OLD.account_number, OLD.narrative, OLD.opening_date,
		OLD.last_closing_date, OLD.credit_limit, OLD.minimum_balance, OLD.maximum_balance,
		OLD.interest_rate, OLD.lockin_period_frequency, OLD.lockedin_until_date,
		OLD.application_date, OLD.approve_status, OLD.workflow_table_id, OLD.action_date, OLD.details);
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.log_deposit_accounts() OWNER TO postgres;

--
-- Name: log_guarantees(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.log_guarantees() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	INSERT INTO logs.lg_guarantees(guarantee_id, loan_id, member_id, entity_id, org_id, guarantee_amount, 
		guarantee_accepted, accepted_date, application_date, approve_status, 
		workflow_table_id, action_date, details)
	VALUES(OLD.guarantee_id, OLD.loan_id, OLD.member_id, OLD.entity_id, OLD.org_id, OLD.guarantee_amount,
		OLD.guarantee_accepted, OLD.accepted_date, OLD.application_date, OLD.approve_status,
		OLD.workflow_table_id, OLD.action_date, OLD.details);
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.log_guarantees() OWNER TO postgres;

--
-- Name: log_loans(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.log_loans() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	INSERT INTO logs.lg_loans(loan_id, member_id, product_id, activity_frequency_id, entity_id, 
		org_id, account_number, disburse_account, principal_amount, interest_rate, 
		repayment_amount, repayment_period, disbursed_date, matured_date, 
		expected_matured_date, expected_repayment, application_date, 
		approve_status, workflow_table_id, action_date, details)
	VALUES(OLD.loan_id, OLD.member_id, OLD.product_id, OLD.activity_frequency_id, OLD.entity_id,
		OLD.org_id, OLD.account_number, OLD.disburse_account, OLD.principal_amount, OLD.interest_rate,
		OLD.repayment_amount, OLD.repayment_period, OLD.disbursed_date, OLD.matured_date,
		OLD.expected_matured_date, OLD.expected_repayment, OLD.application_date,
		OLD.approve_status, OLD.workflow_table_id, OLD.action_date, OLD.details);
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.log_loans() OWNER TO postgres;

--
-- Name: log_members(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.log_members() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
	INSERT INTO logs.lg_members(member_id, entity_id, org_id, business_account, person_title, 
		member_name, identification_number, identification_type, member_email, 
		telephone_number, telephone_number2, address, town, zip_code, 
		date_of_birth, gender, nationality, marital_status, picture_file, 
		employed, self_employed, employer_name, monthly_salary, monthly_net_income, 
		annual_turnover, annual_net_income, employer_address, introduced_by, 
		application_date, approve_status, workflow_table_id, action_date, details)
	VALUES (OLD.member_id, OLD.entity_id, OLD.org_id, OLD.business_account, OLD.person_title,
		OLD.member_name, OLD.identification_number, OLD.identification_type, OLD.member_email,
		OLD.telephone_number, OLD.telephone_number2, OLD.address, OLD.town, OLD.zip_code,
		OLD.date_of_birth, OLD.gender, OLD.nationality, OLD.marital_status, OLD.picture_file,
		OLD.employed, OLD.self_employed, OLD.employer_name, OLD.monthly_salary, OLD.monthly_net_income,
		OLD.annual_turnover, OLD.annual_net_income, OLD.employer_address, OLD.introduced_by,
		OLD.application_date, OLD.approve_status, OLD.workflow_table_id, OLD.action_date, OLD.details);
	RETURN NULL;
END;
$$;


ALTER FUNCTION public.log_members() OWNER TO postgres;

--
-- Name: member_imports(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.member_imports(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	
BEGIN
	---- deleting member import record
	IF($3 = '1')THEN
		DELETE FROM member_imports WHERE member_import_id = $1::integer;
		msg := 'Import Record Deleted';	
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.member_imports(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: member_termination(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.member_termination(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	v_is_active 				boolean;
	rec1 						RECORD;
	reca 						RECORD;	
	recb 						RECORD;
	v_product_id 				integer;
	recd 						RECORD;
	
BEGIN
	--- Application for member Termination/exit 
	IF($3 = '1')THEN
		--check for active loans
		SELECT loan_id,account_number,loan_status,member_id INTO reca
		FROM loans
		WHERE member_id = $1::integer;

		SELECT guarantee_id,member_id,guarantee_amount,loan_id,is_active,guarantee_accepted INTO recd 
		FROM guarantees
		WHERE member_id = $1::integer;

		IF (reca.loan_status = 'Active') THEN
			RAISE EXCEPTION 'Member has an active loan which should be cleared before Exit%',reca.account_number;
		END IF;

		IF ((recd.guarantee_accepted = true) AND (recd.is_active = true)) THEN
			RAISE EXCEPTION 'Member has Guaranteed a loan which is not cleared.......';
		END IF;

		UPDATE members SET terminate_status = 'Pending', terminate_application_date = current_date
		WHERE (member_id = $1::integer) AND (approve_status = 'Approved') AND (terminate_status = 'N/A');

		UPDATE deposit_accounts SET is_active = false
		WHERE (member_id = $1::integer) AND (approve_status = 'Approved') AND (is_active = true);

		msg := 'Applied for member Exit';
	
	END IF;
	--- completing the member exit/termination proccess and archiving the member
	IF($3 = '2')THEN		
		--- deactivating 
		UPDATE members SET terminate_status = 'Completed', terminated = true, is_active = false, terminate_date = current_date,details = ('archived/deactivated member on'|| ' :- ' ||current_date)
		WHERE (member_id = $1::integer) AND (approve_status = 'Approved') AND (terminate_status = 'Pending');

		UPDATE entitys SET is_active = false WHERE member_id = $1::integer;

		msg := 'Member(s) Exit completed and Deactivated...';

	END IF;

	IF($3 = '3')THEN
		--Activating the member		
		UPDATE members SET terminate_status = 'N/A', terminated = false, is_active = true, terminate_date = Null,details = ('activated member on'|| ' :- ' ||current_date)
		WHERE (member_id = $1::integer) AND (approve_status = 'Approved') AND (terminate_status = 'Completed');
		msg := 'Member(s) Activated...';
		---Activating members account
		UPDATE deposit_accounts SET is_active = true
		WHERE (member_id = $1::integer) AND (approve_status = 'Approved') AND (is_active = false);
		---Activating logins
		UPDATE entitys SET is_active = true WHERE member_id = $1::integer;

	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.member_termination(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: open_periods(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.open_periods(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_org_id			integer;
	v_period_id			integer;
	msg					varchar(120);
BEGIN

	IF ($3 = '1') THEN
		UPDATE periods SET opened = true WHERE period_id = $1::int;
		msg := 'Period Opened';
	ELSIF ($3 = '2') THEN
		UPDATE periods SET closed = true WHERE period_id = $1::int;
		msg := 'Period Closed';
	ELSIF ($3 = '3') THEN
		UPDATE periods SET activated = true WHERE period_id = $1::int;
		msg := 'Period Activated';
	ELSIF ($3 = '4') THEN
		UPDATE periods SET activated = false WHERE period_id = $1::int;
		msg := 'Period De-activated';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.open_periods(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: org_access(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.org_access(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_org_id				integer;
	v_use_key_id			integer;
	reca 					RECORD;
	msg						varchar(120);
BEGIN

	IF($3 = '1')THEN
		SELECT org_id INTO v_org_id FROM orgs WHERE (org_id = $4::int);		
		
		SELECT use_key_id, sys_access_level_name, access_tag INTO reca FROM sys_access_levels 
		WHERE (sys_access_level_id = $1::int);

		SELECT use_key_id INTO v_use_key_id
		FROM sys_access_levels
		WHERE (org_id = $4::int) AND (use_key_id =reca.use_key_id);

		IF(v_use_key_id is null)THEN
			INSERT INTO sys_access_levels (use_key_id, org_id, sys_access_level_name, access_tag)
			VALUES (reca.use_key_id, $4::int, reca.sys_access_level_name,reca.access_tag );
			
			msg := 'Granted access level';
		ELSE
			msg := 'Access level already granted';
		END IF;
	ELSIF($3 = '2')THEN
		DELETE FROM sys_access_levels WHERE sys_access_level_id = $1::int;
		
		msg := 'Revoked access level';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.org_access(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: password_validate(character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.password_validate(character varying, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_entity_id			integer;
	v_entity_password	varchar(64);
BEGIN

	SELECT entity_id, entity_password INTO v_entity_id, v_entity_password
	FROM entitys WHERE (user_name = $1);

	IF(v_entity_id is null)THEN
		v_entity_id = -1;
	ELSIF(md5($2) != v_entity_password) THEN
		v_entity_id = -1;
	END IF;

	return v_entity_id;
END;
$_$;


ALTER FUNCTION public.password_validate(character varying, character varying) OWNER TO postgres;

--
-- Name: payroll_payable(integer, integer); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.payroll_payable(integer, integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_org_id				integer;
	v_org_name				varchar(50);
	v_org_client_id			integer;
	v_account_id			integer;
	v_entity_type_id		integer;
	v_bank_account_id		integer;
	reca					RECORD;
	msg						varchar(120);
BEGIN

	SELECT orgs.org_id, orgs.org_client_id, orgs.org_name INTO v_org_id, v_org_client_id, v_org_name
	FROM orgs INNER JOIN periods ON orgs.org_id = periods.org_id
	WHERE (periods.period_id = $1);
	
	IF(v_org_client_id is null)THEN
		SELECT account_id INTO v_account_id
		FROM default_accounts 
		WHERE (org_id = v_org_id) AND (use_key_id = 52);
		
		SELECT max(entity_type_id) INTO v_entity_type_id
		FROM entity_types
		WHERE (org_id = v_org_id) AND (use_key_id = 3);
		
		IF((v_account_id is not null) AND (v_entity_type_id is not null))THEN
			v_org_client_id := nextval('entitys_entity_id_seq');
			
			INSERT INTO entitys (entity_id, org_id, entity_type_id, account_id, entity_name, user_name, function_role, use_key_id)
			VALUES (v_org_client_id, v_org_id, v_entity_type_id, v_account_id, v_org_name, lower(trim(v_org_name)), 'supplier', 3);
		END IF;
	END IF;
	
	SELECT bank_account_id INTO v_bank_account_id
	FROM bank_accounts
	WHERE (org_id = v_org_id) AND (is_default = true);
	
	IF((v_org_client_id is not null) AND (v_bank_account_id is not null))THEN
		--- add transactions for banking payments	
		INSERT INTO transactions (transaction_type_id, transaction_status_id, entered_by, tx_type, 
			entity_id, bank_account_id, currency_id, org_id, ledger_type_id,
			exchange_rate, transaction_date, payment_date, transaction_amount, narrative)
		SELECT 21, 1, $2, -1, 
			v_org_client_id, v_bank_account_id, a.currency_id, a.org_id, 
			get_ledger_link(a.org_id, 1, a.pay_group_id, a.gl_payment_account, 'PAYROLL Payments ' || a.pay_group_name),
			a.exchange_rate, a.end_date, a.end_date, sum(a.b_banked),
			'PAYROLL Payments ' || a.pay_group_name
		FROM vw_ems a
		WHERE (a.period_id = $1)
		GROUP BY a.org_id, a.period_id, a.end_date, a.gl_payment_account, a.pay_group_id, a.currency_id, 
			a.exchange_rate, a.pay_group_name;

		--- add transactions for deduction remitance
		INSERT INTO transactions (transaction_type_id, transaction_status_id, entered_by, tx_type, 
			entity_id, bank_account_id, currency_id, org_id, ledger_type_id,
			exchange_rate, transaction_date, payment_date, transaction_amount, narrative)
		SELECT 21, 1, $2, -1, 
			v_org_client_id, v_bank_account_id, a.currency_id, a.org_id, 
			get_ledger_link(a.org_id, 2, a.adjustment_id, a.account_number, 'PAYROLL Deduction ' || a.adjustment_name),
			a.exchange_rate, a.end_date, a.end_date, sum(a.amount),
			'PAYROLL Deduction ' || a.adjustment_name
		FROM vw_employee_adjustments a
		WHERE (a.period_id = $1)
		GROUP BY a.currency_id, a.org_id, a.adjustment_id, a.account_number, a.adjustment_name, 
			a.exchange_rate, a.end_date;
			
		--- add transactions for tax remitance
		INSERT INTO transactions (transaction_type_id, transaction_status_id, entered_by, tx_type, 
			entity_id, bank_account_id, currency_id, org_id, ledger_type_id,
			exchange_rate, transaction_date, payment_date, transaction_amount, narrative)
		SELECT 21, 1, $2, -1, 
			v_org_client_id, v_bank_account_id, a.currency_id, a.org_id, 
			get_ledger_link(a.org_id, 3, a.tax_type_id, a.account_number, 'PAYROLL Tax ' || a.tax_type_name),
			a.exchange_rate, a.end_date, a.end_date, sum(a.amount + a.employer),
			'PAYROLL Tax ' || a.tax_type_name
		FROM vw_employee_tax_types a
		WHERE (a.period_id = $1)
		GROUP BY a.currency_id, a.org_id, a.tax_type_id, a.account_number, a.tax_type_name, 
			a.exchange_rate, a.end_date;
	END IF;
		
	RETURN msg;
END;
$_$;


ALTER FUNCTION public.payroll_payable(integer, integer) OWNER TO postgres;

--
-- Name: pc_allocation_request(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.pc_allocation_request(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_amount			real;
	msg 				varchar(120);
BEGIN
	msg := 'Petty cash budget applied';
	
	SELECT sum(budget_units * budget_price) INTO v_amount
	FROM pc_budget
	WHERE (pc_allocation_id = $1::int);
	
	IF(v_amount is null)THEN
		RAISE EXCEPTION 'You need to add claim details';
	END IF;
	
	UPDATE pc_allocations SET approve_status = 'Completed'
	WHERE (pc_allocation_id = $1::int) AND (approve_status = 'Draft');

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.pc_allocation_request(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: post_sacco(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.post_sacco(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	reca 						RECORD;
	v_journal_id				integer;
	v_org_id					integer;
	v_currency_id				integer;
	v_period_id					integer;
	v_start_date				date;
	v_end_date					date;

	msg							varchar(120);
BEGIN

	SELECT orgs.org_id, orgs.currency_id, periods.period_id, periods.start_date, periods.end_date
		INTO v_org_id, v_currency_id, v_period_id, v_start_date, v_end_date
	FROM periods INNER JOIN orgs ON periods.org_id = orgs.org_id
	WHERE (period_id = $1::integer) AND (opened = true) AND (activated = false) AND (closed = false);
	
	IF(v_period_id is null)THEN
		msg := 'sacco not posted period need to be open but not active';
	ELSE
		UPDATE account_activity SET period_id = v_period_id 
		WHERE (period_id is null) AND (activity_date BETWEEN v_start_date AND v_end_date);
		
		v_journal_id := nextval('journals_journal_id_seq');
		INSERT INTO journals (journal_id, org_id, currency_id, period_id, exchange_rate, journal_date, narrative)
		VALUES (v_journal_id, v_org_id, v_currency_id, v_period_id, 1, v_end_date, 'sacco - ' || to_char(v_start_date, 'MMYYY'));
		
		INSERT INTO gls(org_id, journal_id, account_activity_id, account_id, 
			debit, credit, gl_narrative)
		SELECT v_org_id, v_journal_id, account_activity.account_activity_id, activity_types.account_id,
			(account_activity.account_debit * account_activity.exchange_rate),
			(account_activity.account_credit * account_activity.exchange_rate),
			COALESCE(deposit_accounts.account_number, loans.account_number)
		FROM account_activity INNER JOIN activity_types ON account_activity.activity_type_id = activity_types.activity_type_id
			LEFT JOIN deposit_accounts ON account_activity.deposit_account_id = deposit_accounts.deposit_account_id
			LEFT JOIN loans ON account_activity.loan_id = loans.loan_id
		WHERE (account_activity.period_id = v_period_id);
	
		msg := 'sacco posted';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.post_sacco(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: post_transaction(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.post_transaction(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	rec					RECORD;
	v_period_id			int;
	v_journal_id		int;
	msg					varchar(120);
BEGIN
	SELECT org_id, department_id, transaction_id, transaction_type_id, transaction_type_name as tx_name, 
		transaction_status_id, journal_id, gl_bank_account_id, currency_id, exchange_rate,
		transaction_date, transaction_amount, transaction_tax_amount, document_number, 
		credit_amount, debit_amount, entity_account_id, entity_name, approve_status, 
		ledger_account_id, tax_account_id, ledger_posting INTO rec
	FROM vw_transactions
	WHERE (transaction_id = CAST($1 as integer));

	v_period_id := get_open_period(rec.transaction_date);
	IF(v_period_id is null) THEN
		msg := 'No active period to post.';
		RAISE EXCEPTION 'No active period to post.';
	ELSIF(rec.journal_id is not null) THEN
		msg := 'Transaction previously Posted.';
		RAISE EXCEPTION 'Transaction previously Posted.';
	ELSIF(rec.transaction_status_id = 1) THEN
		msg := 'Transaction needs to be completed first.';
		RAISE EXCEPTION 'Transaction needs to be completed first.';
	ELSIF(rec.approve_status != 'Approved') THEN
		msg := 'Transaction is not yet approved.';
		RAISE EXCEPTION 'Transaction is not yet approved.';
	ELSIF((rec.ledger_account_id is not null) AND (rec.ledger_posting = false)) THEN
		msg := 'Transaction not for posting.';
		RAISE EXCEPTION 'Transaction not for posting.';
	ELSE
		v_journal_id := nextval('journals_journal_id_seq');
		INSERT INTO journals (journal_id, org_id, department_id, currency_id, period_id, exchange_rate, journal_date, narrative)
		VALUES (v_journal_id, rec.org_id, rec.department_id, rec.currency_id, v_period_id, rec.exchange_rate, rec.transaction_date, rec.tx_name || ' - posting for ' || rec.document_number);
		
		IF((rec.transaction_type_id = 7) or (rec.transaction_type_id = 8)) THEN
			INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
			VALUES (rec.org_id, v_journal_id, rec.entity_account_id, rec.debit_amount, rec.credit_amount, rec.tx_name || ' - ' || rec.entity_name);

			INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
			VALUES (rec.org_id, v_journal_id, rec.gl_bank_account_id, rec.credit_amount, rec.debit_amount, rec.tx_name || ' - ' || rec.entity_name);
		ELSIF((rec.transaction_type_id = 21) or (rec.transaction_type_id = 22)) THEN		
			INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
			VALUES (rec.org_id, v_journal_id, rec.gl_bank_account_id, rec.credit_amount, rec.debit_amount, rec.tx_name || ' - ' || rec.entity_name);
			
			IF(rec.transaction_tax_amount = 0)THEN
				INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
				VALUES (rec.org_id, v_journal_id, rec.ledger_account_id, rec.debit_amount, rec.credit_amount, rec.tx_name || ' - ' || rec.entity_name);
			ELSIF(rec.transaction_type_id = 21)THEN
				INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
				VALUES (rec.org_id, v_journal_id, rec.ledger_account_id, rec.debit_amount - rec.transaction_tax_amount, rec.credit_amount, rec.tx_name || ' - ' || rec.entity_name);
				
				INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
				VALUES (rec.org_id, v_journal_id, rec.tax_account_id, rec.transaction_tax_amount, 0, rec.tx_name || ' - ' || rec.entity_name);
			ELSE
				INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
				VALUES (rec.org_id, v_journal_id, rec.ledger_account_id, rec.debit_amount, rec.credit_amount - rec.transaction_tax_amount, rec.tx_name || ' - ' || rec.entity_name);
				
				INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
				VALUES (rec.org_id, v_journal_id, rec.tax_account_id, 0, rec.transaction_tax_amount, rec.tx_name || ' - ' || rec.entity_name);			
			END IF;
		ELSE
			INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
			VALUES (rec.org_id, v_journal_id, rec.entity_account_id, rec.debit_amount, rec.credit_amount, rec.tx_name || ' - ' || rec.entity_name);

			INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
			SELECT org_id, v_journal_id, trans_account_id, full_debit_amount, full_credit_amount, rec.tx_name || ' - ' || item_name
			FROM vw_transaction_details
			WHERE (transaction_id = rec.transaction_id) AND (full_amount > 0);

			INSERT INTO gls (org_id, journal_id, account_id, debit, credit, gl_narrative)
			SELECT org_id, v_journal_id, tax_account_id, tax_debit_amount, tax_credit_amount, rec.tx_name || ' - ' || item_name
			FROM vw_transaction_details
			WHERE (transaction_id = rec.transaction_id) AND (full_tax_amount > 0);
		END IF;

		UPDATE transactions SET journal_id = v_journal_id WHERE (transaction_id = rec.transaction_id);
		msg := process_journal(CAST(v_journal_id as varchar),'0','0');
	END IF;

	return msg;
END;
$_$;


ALTER FUNCTION public.post_transaction(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: prev_acct(integer, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.prev_acct(integer, date) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT sum(gls.debit - gls.credit)
	FROM gls INNER JOIN journals ON gls.journal_id = journals.journal_id
	WHERE (gls.account_id = $1) AND (journals.posted = true) 
		AND (journals.journal_date < $2);
$_$;


ALTER FUNCTION public.prev_acct(integer, date) OWNER TO postgres;

--
-- Name: prev_balance(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.prev_balance(date) RETURNS real
    LANGUAGE sql
    AS $_$
    SELECT COALESCE(sum(transactions.exchange_rate * transactions.tx_type * transactions.transaction_amount), 0)::real
	FROM transactions
	WHERE (transactions.payment_date < $1) 
		AND (transactions.tx_type is not null);
$_$;


ALTER FUNCTION public.prev_balance(date) OWNER TO postgres;

--
-- Name: prev_base_acct(integer, date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.prev_base_acct(integer, date) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT sum(gls.debit * journals.exchange_rate - gls.credit * journals.exchange_rate) 
	FROM gls INNER JOIN journals ON gls.journal_id = journals.journal_id
	WHERE (gls.account_id = $1) AND (journals.posted = true) 
		AND (journals.journal_date < $2);
$_$;


ALTER FUNCTION public.prev_base_acct(integer, date) OWNER TO postgres;

--
-- Name: prev_base_returns(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.prev_base_returns(date) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT COALESCE(sum(base_credit - base_debit), 0)
	FROM vw_gls
	WHERE (chat_type_id > 3) AND (posted = true) AND (journal_date < $1);
$_$;


ALTER FUNCTION public.prev_base_returns(date) OWNER TO postgres;

--
-- Name: prev_clear_balance(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.prev_clear_balance(date) RETURNS real
    LANGUAGE sql
    AS $_$
    SELECT COALESCE(sum(transactions.exchange_rate * transactions.tx_type * transactions.transaction_amount), 0)::real
	FROM transactions
	WHERE (transactions.payment_date < $1) AND (transactions.completed = true) 
		AND (transactions.is_cleared = true) AND (transactions.tx_type is not null);
$_$;


ALTER FUNCTION public.prev_clear_balance(date) OWNER TO postgres;

--
-- Name: prev_returns(date); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.prev_returns(date) RETURNS real
    LANGUAGE sql
    AS $_$
	SELECT COALESCE(sum(credit - debit), 0)
	FROM vw_gls
	WHERE (chat_type_id > 3) AND (posted = true) AND (journal_date < $1);
$_$;


ALTER FUNCTION public.prev_returns(date) OWNER TO postgres;

--
-- Name: process_journal(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.process_journal(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	rec RECORD;
	msg varchar(120);
BEGIN
	SELECT periods.start_date, periods.end_date, periods.opened, periods.closed, journals.journal_date, journals.posted, 
		sum(debit) as sum_debit, sum(credit) as sum_credit INTO rec
	FROM (periods INNER JOIN journals ON periods.period_id = journals.period_id)
		INNER JOIN gls ON journals.journal_id = gls.journal_id
	WHERE (journals.journal_id = CAST($1 as integer))
	GROUP BY periods.start_date, periods.end_date, periods.opened, periods.closed, journals.journal_date, journals.posted;

	IF(rec.posted = true) THEN
		msg := 'Journal previously Processed.';
	ELSIF((rec.start_date > rec.journal_date) OR (rec.end_date < rec.journal_date)) THEN
		msg := 'Journal date has to be within periods date.';
	ELSIF((rec.opened = false) OR (rec.closed = true)) THEN
		msg := 'Transaction period has to be opened and not closed.';
	ELSIF(rec.sum_debit <> rec.sum_credit) THEN
		msg := 'Cannot process Journal because credits do not equal debits.';
	ELSE
		UPDATE journals SET posted = true WHERE (journals.journal_id = CAST($1 as integer));
		msg := 'Journal Processed.';
	END IF;

	return msg;
END;
$_$;


ALTER FUNCTION public.process_journal(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: process_transaction(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.process_transaction(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	rec RECORD;
	bankacc INTEGER;
	msg varchar(120);
BEGIN
	SELECT org_id, transaction_id, transaction_type_id, transaction_status_id, transaction_amount INTO rec
	FROM transactions
	WHERE (transaction_id = CAST($1 as integer));

	IF(rec.transaction_status_id = 1) THEN
		msg := 'Transaction needs to be completed first.';
	ELSIF(rec.transaction_status_id = 2) THEN
		IF (($3 = '7') AND ($3 = '8')) THEN
			SELECT max(bank_account_id) INTO bankacc
			FROM bank_accounts WHERE (is_default = true);

			INSERT INTO transactions (org_id, department_id, entity_id, currency_id, transaction_type_id, transaction_date, bank_account_id, transaction_amount)
			SELECT transactions.org_id, transactions.department_id, transactions.entity_id, transactions.currency_id, 1, CURRENT_DATE, bankacc, 
				SUM(transaction_details.quantity * (transaction_details.amount + transaction_details.tax_amount))
			FROM transactions INNER JOIN transaction_details ON transactions.transaction_id = transaction_details.transaction_id
			WHERE (transactions.transaction_id = rec.transaction_id)
			GROUP BY transactions.transaction_id, transactions.entity_id;

			INSERT INTO transaction_links (org_id, transaction_id, transaction_to, amount)
			VALUES (rec.org_id, currval('transactions_transaction_id_seq'), rec.transaction_id, rec.transaction_amount);
		
			UPDATE transactions SET transaction_status_id = 3 WHERE transaction_id = rec.transaction_id;
		ELSE
			INSERT INTO transactions (org_id, department_id, entity_id, currency_id, transaction_type_id, transaction_date, order_number, payment_terms, job, narrative, details)
			SELECT org_id, department_id, entity_id, currency_id, CAST($3 as integer), CURRENT_DATE, order_number, payment_terms, job, narrative, details
			FROM transactions
			WHERE (transaction_id = rec.transaction_id);

			INSERT INTO transaction_details (org_id, transaction_id, account_id, item_id, quantity, amount, tax_amount, narrative, details)
			SELECT org_id, currval('transactions_transaction_id_seq'), account_id, item_id, quantity, amount, tax_amount, narrative, details
			FROM transaction_details
			WHERE (transaction_id = rec.transaction_id);

			INSERT INTO transaction_links (org_id, transaction_id, transaction_to, amount)
			VALUES (REC.org_id, currval('transactions_transaction_id_seq'), rec.transaction_id, rec.transaction_amount);

			UPDATE transactions SET transaction_status_id = 3 WHERE transaction_id = rec.transaction_id;
		END IF;
		msg := 'Transaction proccesed';
	ELSE
		msg := 'Transaction previously Processed.';
	END IF;

	return msg;
END;
$_$;


ALTER FUNCTION public.process_transaction(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: sms_module(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.sms_module(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	reca 						RECORD;
	v_org_name					varchar(120);
	v_message 					text;
	v_template 					text;
	
BEGIN
	---sms member login credentials
	IF($3 = '1')THEN
		SELECT members.member_id, members.member_name, members.telephone_number,entitys.entity_id, entitys.user_name, entitys.first_password,entitys.org_id INTO reca
		FROM entitys
		INNER JOIN members ON members.member_id = entitys.member_id
		WHERE entitys.entity_id = $1::int;

		SELECT org_name INTO v_org_name FROM orgs WHERE org_id = reca.org_id;

		SELECT sms_template INTO v_template FROM sms_configs WHERE use_key_id = 300 AND org_id = reca.org_id;

		SELECT (replace(replace(replace(replace(sms_template, ' {{member_name}}', reca.member_name), ' {{user_name}}', reca.user_name), '{{first_password}}', reca.first_password), '{{sacco_name}}', v_org_name)) INTO v_message
		FROM sms_configs WHERE use_key_id = 300 AND org_id = 0;

		---v_message := 'Dear '||reca.member_name||' your username is: '||reca.user_name||' and password: '||reca.first_password|| '  From ' ||v_org_name;

		INSERT INTO sms (folder_id,entity_id, org_id, sms_number, message) VALUES
		(0,reca.entity_id, reca.org_id, reca.telephone_number,v_message);

		msg := 'Login Credentials, SMS Sent... ';
	
	END IF;

	IF($3 = '2')THEN
		UPDATE sms_configs SET is_active = true WHERE sms_config_id = $1::int AND is_active = false;
		msg := 'SMS Module Activated ';	
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.sms_module(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: transfer_approval(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.transfer_approval(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
	v_account_activity_id		integer;
BEGIN

	IF($3 = '1')THEN
		v_account_activity_id := nextval('account_activity_account_activity_id_seq');
		INSERT INTO account_activity (account_activity_id, org_id, entity_id, activity_frequency_id, activity_type_id, 
			activity_status_id, transfer_account_no, deposit_account_id,
			activity_date, value_date, account_debit, exchange_rate)
		SELECT v_account_activity_id, org_id, entity_id, activity_frequency_id, activity_type_id, 
			1, beneficiary_account_number, deposit_account_id,
			current_date, current_date, transfer_amount, 1
		FROM vw_transfer_activity
		WHERE (transfer_activity_id = $1::integer);
		
		UPDATE transfer_activity SET approve_status = 'Approved',action_date = current_date, account_activity_id = v_account_activity_id
		WHERE (transfer_activity_id = $1::integer);
		
		msg := 'Transfer Approved Successfully.....';
	ELSIF($3 = '2')THEN
		UPDATE transfer_activity SET approve_status = 'Declined',action_date = current_date
		WHERE (transfer_activity_id = $1::integer);
		
		msg := 'Transfer Rejected.....';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.transfer_approval(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: upd_access_level(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_access_level(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	v_org_id				integer;
	v_sys_access_entity_id	integer;
	msg						varchar(120);
BEGIN

	IF($3 = '1')THEN
		SELECT org_id INTO v_org_id FROM entitys WHERE (entity_id = $4::int);

		SELECT sys_access_entity_id INTO v_sys_access_entity_id
		FROM sys_access_entitys
		WHERE (entity_id = $4::int) AND (sys_access_level_id = $1::int);

		IF(v_sys_access_entity_id is null)THEN
			INSERT INTO sys_access_entitys (entity_id, sys_access_level_id, org_id)
			VALUES ($4::int, $1::int, v_org_id);

			msg := 'Granted access level';
		ELSE
			msg := 'Access level already granted';
		END IF;
	ELSIF($3 = '2')THEN
		DELETE FROM sys_access_entitys WHERE sys_access_level_id = $1::int;

		msg := 'Rovoked access level';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.upd_access_level(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: upd_action(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_action() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	v_column_name			varchar;
	v_workflow_narrative	varchar(240);
	wfid					integer;
	reca					record;
	tbid					integer;
	iswf					boolean;
	add_flow				boolean;
BEGIN
	add_flow := false;
	IF(TG_OP = 'INSERT')THEN
		IF (NEW.approve_status = 'Completed')THEN
			add_flow := true;
		END IF;
	ELSE
		IF(OLD.approve_status = 'Draft') AND (NEW.approve_status = 'Completed')THEN
			add_flow := true;
		END IF;
	END IF;

	IF(add_flow = true)THEN
		wfid := nextval('workflow_table_id_seq');
		NEW.workflow_table_id := wfid;

		SELECT column_name INTO v_column_name
		FROM information_schema.columns
		WHERE table_name = TG_TABLE_NAME and column_name = 'workflow_narrative';
		IF(v_column_name is not null)THEN v_workflow_narrative := NEW.workflow_narrative; END IF;
		IF(v_workflow_narrative is null)THEN v_workflow_narrative := ''; END IF;

		IF(TG_OP = 'UPDATE')THEN
			IF(OLD.workflow_table_id is not null)THEN
				INSERT INTO workflow_logs (org_id, table_name, table_id, table_old_id)
				VALUES (NEW.org_id, TG_TABLE_NAME, wfid, OLD.workflow_table_id);
			END IF;
		END IF;

		FOR reca IN SELECT workflows.workflow_id, workflows.table_name, workflows.table_link_field, workflows.table_link_id
		FROM workflows INNER JOIN entity_subscriptions ON workflows.source_entity_id = entity_subscriptions.entity_type_id
		WHERE (workflows.table_name = TG_TABLE_NAME) AND (entity_subscriptions.entity_id= NEW.entity_id) LOOP
			iswf := true;
			IF(reca.table_link_field is null)THEN
				iswf := true;
			ELSE
				IF(TG_TABLE_NAME = 'entry_forms')THEN
					tbid := NEW.form_id;
				END IF;
				IF(tbid = reca.table_link_id)THEN
					iswf := true;
				END IF;
			END IF;

			IF(iswf = true)THEN
				INSERT INTO approvals (org_id, workflow_phase_id, table_name, table_id, org_entity_id,
					escalation_days, escalation_hours, approval_level,
					approval_narrative, to_be_done)
				SELECT org_id, workflow_phase_id, TG_TABLE_NAME, wfid, NEW.entity_id,
					escalation_days, escalation_hours, approval_level,
					(CASE WHEN phase_narrative is null THEN v_workflow_narrative
						ELSE phase_narrative || ' - ' || v_workflow_narrative END),
					'Approve - ' || COALESCE(phase_narrative, '')
				FROM vw_workflow_entitys
				WHERE (table_name = TG_TABLE_NAME) AND (entity_id = NEW.entity_id) AND (workflow_id = reca.workflow_id)
				ORDER BY approval_level, workflow_phase_id;

				UPDATE approvals SET approve_status = 'Completed'
				WHERE (table_id = wfid) AND (approval_level = 1);
			END IF;
		END LOOP;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.upd_action() OWNER TO postgres;

--
-- Name: upd_approvals(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_approvals() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	reca		RECORD;
	wfid		integer;
	vorgid		integer;
	vnotice		boolean;
	vadvice		boolean;
BEGIN

	SELECT notice, advice, org_id INTO vnotice, vadvice, vorgid
	FROM workflow_phases
	WHERE (workflow_phase_id = NEW.workflow_phase_id);

	IF (NEW.approve_status = 'Completed') THEN
		INSERT INTO sys_emailed (table_id, table_name, email_type, org_id)
		VALUES (NEW.approval_id, TG_TABLE_NAME, 1, vorgid);
	END IF;
	IF (NEW.approve_status = 'Approved') AND (vadvice = true) AND (NEW.forward_id is null) THEN
		INSERT INTO sys_emailed (table_id, table_name, email_type, org_id)
		VALUES (NEW.approval_id, TG_TABLE_NAME, 1, vorgid);
	END IF;
	IF (NEW.approve_status = 'Approved') AND (vnotice = true) AND (NEW.forward_id is null) THEN
		INSERT INTO sys_emailed (table_id, table_name, email_type, org_id)
		VALUES (NEW.approval_id, TG_TABLE_NAME, 2, vorgid);
	END IF;

	IF(TG_OP = 'INSERT') AND (NEW.forward_id is null) THEN
		INSERT INTO approval_checklists (approval_id, checklist_id, requirement, manditory, org_id)
		SELECT NEW.approval_id, checklist_id, requirement, manditory, org_id
		FROM checklists
		WHERE (workflow_phase_id = NEW.workflow_phase_id)
		ORDER BY checklist_number;
	END IF;

	RETURN NULL;
END;
$$;


ALTER FUNCTION public.upd_approvals() OWNER TO postgres;

--
-- Name: upd_approvals(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_approvals(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	app_id		Integer;
	reca 		RECORD;
	recb		RECORD;
	recc		RECORD;
	recd		RECORD;

	min_level	Integer;
	mysql		varchar(240);
	msg 		varchar(120);
BEGIN
	app_id := CAST($1 as int);
	SELECT approvals.approval_id, approvals.org_id, approvals.table_name, approvals.table_id, 
		approvals.approval_level, approvals.review_advice, approvals.org_entity_id,
		workflow_phases.workflow_phase_id, workflow_phases.workflow_id, workflow_phases.return_level 
	INTO reca
	FROM approvals INNER JOIN workflow_phases ON approvals.workflow_phase_id = workflow_phases.workflow_phase_id
	WHERE (approvals.approval_id = app_id);

	SELECT count(approval_checklist_id) as cl_count INTO recc
	FROM approval_checklists
	WHERE (approval_id = app_id) AND (manditory = true) AND (done = false);

	SELECT orgs.org_id, transactions.transaction_type_id, orgs.enforce_budget,
		get_budgeted(transactions.transaction_id, transactions.transaction_date, transactions.department_id) as budget_var 
		INTO recd
	FROM orgs INNER JOIN transactions ON orgs.org_id = transactions.org_id
	WHERE (transactions.workflow_table_id = reca.table_id);

	IF ($3 = '1') THEN
		UPDATE approvals SET approve_status = 'Completed', completion_date = now()
		WHERE approval_id = app_id;
		msg := 'Completed';
	ELSIF ($3 = '2') AND (recc.cl_count <> 0) THEN
		msg := 'There are manditory checklist that must be checked first.';
	ELSIF (recd.transaction_type_id = 5) AND (recd.enforce_budget = true) AND (recd.budget_var < 0) THEN
		msg := 'You need a budget to approve the expenditure.';
	ELSIF ($3 = '2') AND (recc.cl_count = 0) THEN
		UPDATE approvals SET approve_status = 'Approved', action_date = now(), app_entity_id = CAST($2 as int)
		WHERE approval_id = app_id;

		SELECT min(approvals.approval_level) INTO min_level
		FROM approvals INNER JOIN workflow_phases ON approvals.workflow_phase_id = workflow_phases.workflow_phase_id
		WHERE (approvals.table_id = reca.table_id) AND (approvals.approve_status = 'Draft')
			AND (workflow_phases.advice = false);
		
		IF(min_level is null)THEN
			mysql := 'UPDATE ' || reca.table_name || ' SET approve_status = ' || quote_literal('Approved') 
			|| ', action_date = now()'
			|| ' WHERE workflow_table_id = ' || reca.table_id;
			EXECUTE mysql;

			INSERT INTO sys_emailed (table_id, table_name, email_type)
			VALUES (reca.table_id, 'vw_workflow_approvals', 1);
			
			FOR recb IN SELECT workflow_phase_id, advice, notice
			FROM workflow_phases
			WHERE (workflow_id = reca.workflow_id) AND (approval_level >= reca.approval_level) LOOP
				IF (recb.advice = true) THEN
					UPDATE approvals SET approve_status = 'Approved', action_date = now(), completion_date = now()
					WHERE (workflow_phase_id = recb.workflow_phase_id) AND (table_id = reca.table_id);
				END IF;
			END LOOP;
		ELSE
			FOR recb IN SELECT workflow_phase_id, advice, notice
			FROM workflow_phases
			WHERE (workflow_id = reca.workflow_id) AND (approval_level <= min_level) LOOP
				IF (recb.advice = true) THEN
					UPDATE approvals SET approve_status = 'Approved', action_date = now(), completion_date = now()
					WHERE (workflow_phase_id = recb.workflow_phase_id) 
						AND (approve_status = 'Draft') AND (table_id = reca.table_id);
				ELSE
					UPDATE approvals SET approve_status = 'Completed', completion_date = now()
					WHERE (workflow_phase_id = recb.workflow_phase_id) 
						AND (approve_status = 'Draft') AND (table_id = reca.table_id);
				END IF;
			END LOOP;
		END IF;
		msg := 'Approved';
	ELSIF ($3 = '3') THEN
		UPDATE approvals SET approve_status = 'Rejected',  action_date = now(), app_entity_id = CAST($2 as int)
		WHERE approval_id = app_id;

		mysql := 'UPDATE ' || reca.table_name || ' SET approve_status = ' || quote_literal('Rejected') 
		|| ', action_date = now()'
		|| ' WHERE workflow_table_id = ' || reca.table_id;
		EXECUTE mysql;

		INSERT INTO sys_emailed (table_id, table_name, email_type, org_id)
		VALUES (reca.table_id, 'vw_workflow_approvals', 2, reca.org_id);
		msg := 'Rejected';
	ELSIF ($3 = '4') AND (reca.return_level = 0) THEN
		UPDATE approvals SET approve_status = 'Review',  action_date = now(), app_entity_id = CAST($2 as int)
		WHERE approval_id = app_id;

		mysql := 'UPDATE ' || reca.table_name || ' SET approve_status = ' || quote_literal('Draft')
		|| ', action_date = now()'
		|| ' WHERE workflow_table_id = ' || reca.table_id;
		EXECUTE mysql;

		msg := 'Forwarded for review';
	ELSIF ($3 = '4') AND (reca.return_level <> 0) THEN
		UPDATE approvals SET approve_status = 'Review',  action_date = now(), app_entity_id = CAST($2 as int)
		WHERE approval_id = app_id;

		INSERT INTO approvals (org_id, workflow_phase_id, table_name, table_id, org_entity_id, escalation_days, escalation_hours, approval_level, approval_narrative, to_be_done, approve_status)
		SELECT org_id, workflow_phase_id, reca.table_name, reca.table_id, CAST($2 as int), escalation_days, escalation_hours, approval_level, phase_narrative, reca.review_advice, 'Completed'
		FROM vw_workflow_entitys
		WHERE (workflow_id = reca.workflow_id) AND (approval_level = reca.return_level)
			AND (entity_id = reca.org_entity_id)
		ORDER BY workflow_phase_id;

		UPDATE approvals SET approve_status = 'Draft' WHERE approval_id = app_id;

		msg := 'Forwarded to owner for review';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.upd_approvals(character varying, character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: upd_budget_lines(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_budget_lines() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	accountid 	INTEGER;
BEGIN

	IF(NEW.income_budget = true)THEN
		SELECT sales_account_id INTO accountid
		FROM items
		WHERE (item_id = NEW.item_id);
	ELSE
		SELECT purchase_account_id INTO accountid
		FROM items
		WHERE (item_id = NEW.item_id);
	END IF;

	IF(NEW.account_id is null) THEN
		NEW.account_id = accountid;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.upd_budget_lines() OWNER TO postgres;

--
-- Name: upd_checklist(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_checklist(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	cl_id		Integer;
	reca 		RECORD;
	recc 		RECORD;
	msg 		varchar(120);
BEGIN
	cl_id := CAST($1 as int);

	SELECT approval_checklist_id, approval_id, checklist_id, requirement, manditory, done INTO reca
	FROM approval_checklists
	WHERE (approval_checklist_id = cl_id);

	IF ($3 = '1') THEN
		UPDATE approval_checklists SET done = true WHERE (approval_checklist_id = cl_id);

		SELECT count(approval_checklist_id) as cl_count INTO recc
		FROM approval_checklists
		WHERE (approval_id = reca.approval_id) AND (manditory = true) AND (done = false);
		msg := 'Checklist done.';
	ELSIF ($3 = '2') THEN
		UPDATE approval_checklists SET done = false WHERE (approval_checklist_id = cl_id);
		msg := 'Checklist not done.';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.upd_checklist(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: upd_complete_form(character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_complete_form(character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg varchar(120);
BEGIN
	IF ($3 = '1') THEN
		UPDATE entry_forms SET approve_status = 'Completed', completion_date = now()
		WHERE (entry_form_id = CAST($1 as int));
		msg := 'Completed the form';
	ELSIF ($3 = '2') THEN
		UPDATE entry_forms SET approve_status = 'Approved', action_date = now()
		WHERE (entry_form_id = CAST($1 as int));
		msg := 'Approved the form';
	ELSIF ($3 = '3') THEN
		UPDATE entry_forms SET approve_status = 'Rejected', action_date = now()
		WHERE (entry_form_id = CAST($1 as int));
		msg := 'Rejected the form';
	END IF;

	return msg;
END;
$_$;


ALTER FUNCTION public.upd_complete_form(character varying, character varying, character varying) OWNER TO postgres;

--
-- Name: upd_gls(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_gls() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	isposted BOOLEAN;
BEGIN
	SELECT posted INTO isposted
	FROM journals 
	WHERE (journal_id = NEW.journal_id);

	IF (isposted = true) THEN
		RAISE EXCEPTION '% Journal is already posted no changes are allowed.', NEW.journal_id;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.upd_gls() OWNER TO postgres;

--
-- Name: upd_transaction_details(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_transaction_details() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	statusID 	INTEGER;
	journalID 	INTEGER;
	v_for_sale	BOOLEAN;
	accountid 	INTEGER;
	taxrate 	REAL;
BEGIN
	SELECT transactions.transaction_status_id, transactions.journal_id, transaction_types.for_sales
		INTO statusID, journalID, v_for_sale
	FROM transaction_types INNER JOIN transactions ON transaction_types.transaction_type_id = transactions.transaction_type_id
	WHERE (transaction_id = NEW.transaction_id);

	IF ((statusID > 1) OR (journalID is not null)) THEN
		RAISE EXCEPTION 'Transaction is already posted no changes are allowed.';
	END IF;

	IF(v_for_sale = true)THEN
		SELECT items.sales_account_id, tax_types.tax_rate INTO accountid, taxrate
		FROM tax_types INNER JOIN items ON tax_types.tax_type_id = items.tax_type_id
		WHERE (items.item_id = NEW.item_id);
	ELSE
		SELECT items.purchase_account_id, tax_types.tax_rate INTO accountid, taxrate
		FROM tax_types INNER JOIN items ON tax_types.tax_type_id = items.tax_type_id
		WHERE (items.item_id = NEW.item_id);
	END IF;

	NEW.tax_amount := NEW.amount * taxrate / 100;
	IF(accountid is not null)THEN
		NEW.account_id := accountid;
	END IF;

	RETURN NEW;
END;
$$;


ALTER FUNCTION public.upd_transaction_details() OWNER TO postgres;

--
-- Name: upd_trx_ledger(character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.upd_trx_ledger(character varying, character varying, character varying, character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $_$
DECLARE
	msg							varchar(120);
BEGIN
	
	IF ($3 = '1') THEN
		UPDATE transactions SET for_processing = true WHERE transaction_id = $1::integer;
		msg := 'Opened for processing';
	ELSIF ($3 = '2') THEN
		UPDATE transactions SET for_processing = false WHERE transaction_id = $1::integer;
		msg := 'Closed for processing';
	ELSIF ($3 = '3') THEN
		UPDATE transactions  SET payment_date = current_date, completed = true
		WHERE transaction_id = $1::integer AND completed = false;
		msg := 'Completed';
	ELSIF ($3 = '4') THEN
		UPDATE transactions  SET is_cleared = true WHERE transaction_id = $1::integer;
		msg := 'Cleared for posting ';
	END IF;

	RETURN msg;
END;
$_$;


ALTER FUNCTION public.upd_trx_ledger(character varying, character varying, character varying, character varying) OWNER TO postgres;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: lg_account_activity; Type: TABLE; Schema: logs; Owner: postgres
--

CREATE TABLE logs.lg_account_activity (
    lg_account_activity_id integer NOT NULL,
    account_activity_id integer,
    deposit_account_id integer,
    transfer_account_id integer,
    activity_type_id integer,
    activity_frequency_id integer,
    activity_status_id integer,
    commodity_trade_id integer,
    period_id integer,
    entity_id integer,
    loan_id integer,
    transfer_loan_id integer,
    org_id integer,
    link_activity_id integer NOT NULL,
    transfer_link_id integer,
    deposit_account_no character varying(32),
    transfer_account_no character varying(32),
    activity_date date DEFAULT ('now'::text)::date NOT NULL,
    value_date date NOT NULL,
    account_credit real,
    account_debit real,
    balance real,
    exchange_rate real,
    invert_rate boolean,
    trading_rate real,
    mean_rate real,
    application_date timestamp without time zone,
    approve_status character varying(16),
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text,
    created timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE logs.lg_account_activity OWNER TO postgres;

--
-- Name: lg_account_activity_lg_account_activity_id_seq; Type: SEQUENCE; Schema: logs; Owner: postgres
--

CREATE SEQUENCE logs.lg_account_activity_lg_account_activity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logs.lg_account_activity_lg_account_activity_id_seq OWNER TO postgres;

--
-- Name: lg_account_activity_lg_account_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: logs; Owner: postgres
--

ALTER SEQUENCE logs.lg_account_activity_lg_account_activity_id_seq OWNED BY logs.lg_account_activity.lg_account_activity_id;


--
-- Name: lg_collaterals; Type: TABLE; Schema: logs; Owner: postgres
--

CREATE TABLE logs.lg_collaterals (
    lg_collateral_id integer NOT NULL,
    collateral_id integer,
    loan_id integer,
    collateral_type_id integer,
    entity_id integer,
    org_id integer,
    collateral_amount real NOT NULL,
    collateral_received boolean DEFAULT false NOT NULL,
    collateral_released boolean DEFAULT false NOT NULL,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text,
    created timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE logs.lg_collaterals OWNER TO postgres;

--
-- Name: lg_collaterals_lg_collateral_id_seq; Type: SEQUENCE; Schema: logs; Owner: postgres
--

CREATE SEQUENCE logs.lg_collaterals_lg_collateral_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logs.lg_collaterals_lg_collateral_id_seq OWNER TO postgres;

--
-- Name: lg_collaterals_lg_collateral_id_seq; Type: SEQUENCE OWNED BY; Schema: logs; Owner: postgres
--

ALTER SEQUENCE logs.lg_collaterals_lg_collateral_id_seq OWNED BY logs.lg_collaterals.lg_collateral_id;


--
-- Name: lg_commodity_trades; Type: TABLE; Schema: logs; Owner: postgres
--

CREATE TABLE logs.lg_commodity_trades (
    lg_commodity_trade_id integer NOT NULL,
    commodity_trade_id integer,
    deposit_account_id integer,
    transfer_account_id integer,
    commodity_id integer,
    entity_id integer,
    use_key_id integer,
    org_id integer,
    transfer_account_no character varying(32),
    link_activity_id integer,
    unit_debit real,
    unit_credit real,
    price real,
    trade_date date,
    application_date timestamp without time zone,
    approve_status character varying(16),
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text,
    created timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE logs.lg_commodity_trades OWNER TO postgres;

--
-- Name: lg_commodity_trades_lg_commodity_trade_id_seq; Type: SEQUENCE; Schema: logs; Owner: postgres
--

CREATE SEQUENCE logs.lg_commodity_trades_lg_commodity_trade_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logs.lg_commodity_trades_lg_commodity_trade_id_seq OWNER TO postgres;

--
-- Name: lg_commodity_trades_lg_commodity_trade_id_seq; Type: SEQUENCE OWNED BY; Schema: logs; Owner: postgres
--

ALTER SEQUENCE logs.lg_commodity_trades_lg_commodity_trade_id_seq OWNED BY logs.lg_commodity_trades.lg_commodity_trade_id;


--
-- Name: lg_deposit_accounts; Type: TABLE; Schema: logs; Owner: postgres
--

CREATE TABLE logs.lg_deposit_accounts (
    lg_deposit_account_id integer NOT NULL,
    deposit_account_id integer,
    member_id integer,
    product_id integer,
    activity_frequency_id integer,
    entity_id integer,
    org_id integer,
    is_active boolean DEFAULT false NOT NULL,
    account_number character varying(32) NOT NULL,
    narrative character varying(120),
    opening_date date DEFAULT ('now'::text)::date NOT NULL,
    last_closing_date date,
    credit_limit real,
    minimum_balance real,
    maximum_balance real,
    interest_rate real NOT NULL,
    lockin_period_frequency real,
    lockedin_until_date date,
    application_date timestamp without time zone DEFAULT now() NOT NULL,
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text,
    created timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE logs.lg_deposit_accounts OWNER TO postgres;

--
-- Name: lg_deposit_accounts_lg_deposit_account_id_seq; Type: SEQUENCE; Schema: logs; Owner: postgres
--

CREATE SEQUENCE logs.lg_deposit_accounts_lg_deposit_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logs.lg_deposit_accounts_lg_deposit_account_id_seq OWNER TO postgres;

--
-- Name: lg_deposit_accounts_lg_deposit_account_id_seq; Type: SEQUENCE OWNED BY; Schema: logs; Owner: postgres
--

ALTER SEQUENCE logs.lg_deposit_accounts_lg_deposit_account_id_seq OWNED BY logs.lg_deposit_accounts.lg_deposit_account_id;


--
-- Name: lg_guarantees; Type: TABLE; Schema: logs; Owner: postgres
--

CREATE TABLE logs.lg_guarantees (
    lg_guarantee_id integer NOT NULL,
    guarantee_id integer,
    loan_id integer,
    member_id integer,
    entity_id integer,
    org_id integer,
    guarantee_amount real NOT NULL,
    guarantee_accepted boolean DEFAULT false NOT NULL,
    accepted_date timestamp without time zone,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text,
    created timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE logs.lg_guarantees OWNER TO postgres;

--
-- Name: lg_guarantees_lg_guarantee_id_seq; Type: SEQUENCE; Schema: logs; Owner: postgres
--

CREATE SEQUENCE logs.lg_guarantees_lg_guarantee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logs.lg_guarantees_lg_guarantee_id_seq OWNER TO postgres;

--
-- Name: lg_guarantees_lg_guarantee_id_seq; Type: SEQUENCE OWNED BY; Schema: logs; Owner: postgres
--

ALTER SEQUENCE logs.lg_guarantees_lg_guarantee_id_seq OWNED BY logs.lg_guarantees.lg_guarantee_id;


--
-- Name: lg_loans; Type: TABLE; Schema: logs; Owner: postgres
--

CREATE TABLE logs.lg_loans (
    lg_loan_id integer NOT NULL,
    loan_id integer,
    member_id integer,
    product_id integer,
    activity_frequency_id integer,
    entity_id integer,
    org_id integer,
    account_number character varying(32) NOT NULL,
    disburse_account character varying(32) NOT NULL,
    principal_amount real NOT NULL,
    interest_rate real NOT NULL,
    repayment_amount real NOT NULL,
    repayment_period integer NOT NULL,
    disbursed_date date,
    matured_date date,
    expected_matured_date date,
    expected_repayment real,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text,
    created timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE logs.lg_loans OWNER TO postgres;

--
-- Name: lg_loans_lg_loan_id_seq; Type: SEQUENCE; Schema: logs; Owner: postgres
--

CREATE SEQUENCE logs.lg_loans_lg_loan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logs.lg_loans_lg_loan_id_seq OWNER TO postgres;

--
-- Name: lg_loans_lg_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: logs; Owner: postgres
--

ALTER SEQUENCE logs.lg_loans_lg_loan_id_seq OWNED BY logs.lg_loans.lg_loan_id;


--
-- Name: lg_members; Type: TABLE; Schema: logs; Owner: postgres
--

CREATE TABLE logs.lg_members (
    lg_member_id integer NOT NULL,
    member_id integer,
    entity_id integer,
    org_id integer,
    business_account integer DEFAULT 0 NOT NULL,
    person_title character varying(7),
    member_name character varying(150) NOT NULL,
    identification_number character varying(50) NOT NULL,
    identification_type character varying(50) NOT NULL,
    member_email character varying(50) NOT NULL,
    telephone_number character varying(20) NOT NULL,
    telephone_number2 character varying(20),
    address character varying(50),
    town character varying(50),
    zip_code character varying(50),
    date_of_birth date NOT NULL,
    gender character varying(1),
    nationality character(2),
    marital_status character varying(2),
    picture_file character varying(32),
    employed boolean DEFAULT true NOT NULL,
    self_employed boolean DEFAULT false NOT NULL,
    employer_name character varying(120),
    monthly_salary real,
    monthly_net_income real,
    annual_turnover real,
    annual_net_income real,
    employer_address text,
    introduced_by character varying(100),
    application_date timestamp without time zone DEFAULT now() NOT NULL,
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text,
    created timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE logs.lg_members OWNER TO postgres;

--
-- Name: lg_members_lg_member_id_seq; Type: SEQUENCE; Schema: logs; Owner: postgres
--

CREATE SEQUENCE logs.lg_members_lg_member_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE logs.lg_members_lg_member_id_seq OWNER TO postgres;

--
-- Name: lg_members_lg_member_id_seq; Type: SEQUENCE OWNED BY; Schema: logs; Owner: postgres
--

ALTER SEQUENCE logs.lg_members_lg_member_id_seq OWNED BY logs.lg_members.lg_member_id;


--
-- Name: account_activity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.account_activity (
    account_activity_id integer NOT NULL,
    deposit_account_id integer,
    transfer_account_id integer,
    activity_type_id integer,
    activity_frequency_id integer,
    activity_status_id integer,
    commodity_trade_id integer,
    period_id integer,
    entity_id integer,
    org_id integer,
    link_activity_id integer NOT NULL,
    transfer_link_id integer,
    deposit_account_no character varying(32),
    transfer_account_no character varying(32),
    activity_date date DEFAULT ('now'::text)::date NOT NULL,
    value_date date NOT NULL,
    account_credit real DEFAULT 0 NOT NULL,
    account_debit real DEFAULT 0 NOT NULL,
    balance real NOT NULL,
    exchange_rate real DEFAULT 1 NOT NULL,
    invert_rate boolean DEFAULT false NOT NULL,
    trading_rate real DEFAULT 1 NOT NULL,
    mean_rate real DEFAULT 1 NOT NULL,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text,
    loan_id integer,
    transfer_loan_id integer
);


ALTER TABLE public.account_activity OWNER TO postgres;

--
-- Name: account_activity_account_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.account_activity_account_activity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.account_activity_account_activity_id_seq OWNER TO postgres;

--
-- Name: account_activity_account_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.account_activity_account_activity_id_seq OWNED BY public.account_activity.account_activity_id;


--
-- Name: account_class; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.account_class (
    account_class_id integer NOT NULL,
    account_class_no integer NOT NULL,
    org_id integer,
    chat_type_id integer NOT NULL,
    chat_type_name character varying(50) NOT NULL,
    account_class_name character varying(120) NOT NULL,
    details text
);


ALTER TABLE public.account_class OWNER TO postgres;

--
-- Name: account_class_account_class_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.account_class_account_class_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.account_class_account_class_id_seq OWNER TO postgres;

--
-- Name: account_class_account_class_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.account_class_account_class_id_seq OWNED BY public.account_class.account_class_id;


--
-- Name: account_definations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.account_definations (
    account_defination_id integer NOT NULL,
    product_id integer NOT NULL,
    activity_type_id integer NOT NULL,
    charge_activity_id integer NOT NULL,
    activity_frequency_id integer NOT NULL,
    org_id integer,
    account_defination_name character varying(50) NOT NULL,
    start_date date NOT NULL,
    end_date date,
    fee_amount real DEFAULT 0 NOT NULL,
    fee_ps real DEFAULT 0 NOT NULL,
    has_charge boolean DEFAULT false NOT NULL,
    is_active boolean DEFAULT false NOT NULL,
    account_number character varying(32) NOT NULL,
    details text
);


ALTER TABLE public.account_definations OWNER TO postgres;

--
-- Name: account_definations_account_defination_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.account_definations_account_defination_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.account_definations_account_defination_id_seq OWNER TO postgres;

--
-- Name: account_definations_account_defination_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.account_definations_account_defination_id_seq OWNED BY public.account_definations.account_defination_id;


--
-- Name: account_notes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.account_notes (
    account_note_id integer NOT NULL,
    deposit_account_id integer,
    org_id integer,
    comment_date timestamp without time zone DEFAULT now() NOT NULL,
    narrative character varying(320) NOT NULL,
    note text NOT NULL
);


ALTER TABLE public.account_notes OWNER TO postgres;

--
-- Name: account_notes_account_note_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.account_notes_account_note_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.account_notes_account_note_id_seq OWNER TO postgres;

--
-- Name: account_notes_account_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.account_notes_account_note_id_seq OWNED BY public.account_notes.account_note_id;


--
-- Name: account_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.account_types (
    account_type_id integer NOT NULL,
    account_type_no integer NOT NULL,
    account_class_id integer,
    org_id integer,
    account_type_name character varying(120) NOT NULL,
    details text
);


ALTER TABLE public.account_types OWNER TO postgres;

--
-- Name: account_types_account_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.account_types_account_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.account_types_account_type_id_seq OWNER TO postgres;

--
-- Name: account_types_account_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.account_types_account_type_id_seq OWNED BY public.account_types.account_type_id;


--
-- Name: accounts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.accounts (
    account_id integer NOT NULL,
    account_no integer NOT NULL,
    account_type_id integer,
    org_id integer,
    account_name character varying(120) NOT NULL,
    is_header boolean DEFAULT false NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    details text
);


ALTER TABLE public.accounts OWNER TO postgres;

--
-- Name: accounts_account_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.accounts_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.accounts_account_id_seq OWNER TO postgres;

--
-- Name: accounts_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.accounts_account_id_seq OWNED BY public.accounts.account_id;


--
-- Name: activity_frequency; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.activity_frequency (
    activity_frequency_id integer NOT NULL,
    activity_frequency_name character varying(50) NOT NULL
);


ALTER TABLE public.activity_frequency OWNER TO postgres;

--
-- Name: activity_status; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.activity_status (
    activity_status_id integer NOT NULL,
    activity_status_name character varying(50) NOT NULL
);


ALTER TABLE public.activity_status OWNER TO postgres;

--
-- Name: activity_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.activity_types (
    activity_type_id integer NOT NULL,
    dr_account_id integer NOT NULL,
    cr_account_id integer NOT NULL,
    use_key_id integer NOT NULL,
    org_id integer,
    activity_type_name character varying(120) NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    activity_type_no integer,
    details text
);


ALTER TABLE public.activity_types OWNER TO postgres;

--
-- Name: activity_types_activity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.activity_types_activity_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.activity_types_activity_type_id_seq OWNER TO postgres;

--
-- Name: activity_types_activity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.activity_types_activity_type_id_seq OWNED BY public.activity_types.activity_type_id;


--
-- Name: address; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.address (
    address_id integer NOT NULL,
    address_type_id integer,
    sys_country_id character(2),
    org_id integer,
    address_name character varying(120),
    table_name character varying(32),
    table_id integer,
    post_office_box character varying(50),
    postal_code character varying(12),
    premises character varying(120),
    street character varying(120),
    town character varying(50),
    phone_number character varying(150),
    extension character varying(15),
    mobile character varying(150),
    fax character varying(150),
    email character varying(120),
    website character varying(120),
    is_default boolean DEFAULT false NOT NULL,
    first_password character varying(32),
    details text
);


ALTER TABLE public.address OWNER TO postgres;

--
-- Name: address_address_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.address_address_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.address_address_id_seq OWNER TO postgres;

--
-- Name: address_address_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.address_address_id_seq OWNED BY public.address.address_id;


--
-- Name: address_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.address_types (
    address_type_id integer NOT NULL,
    org_id integer,
    address_type_name character varying(50)
);


ALTER TABLE public.address_types OWNER TO postgres;

--
-- Name: address_types_address_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.address_types_address_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.address_types_address_type_id_seq OWNER TO postgres;

--
-- Name: address_types_address_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.address_types_address_type_id_seq OWNED BY public.address_types.address_type_id;


--
-- Name: applicants; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.applicants (
    applicant_id integer NOT NULL,
    member_id integer,
    org_id integer,
    business_account integer DEFAULT 0 NOT NULL,
    person_title character varying(7),
    applicant_name character varying(150) NOT NULL,
    identification_number character varying(50) NOT NULL,
    identification_type character varying(50) NOT NULL,
    member_email character varying(50) NOT NULL,
    telephone_number character varying(20) NOT NULL,
    telephone_number2 character varying(20),
    address character varying(50),
    town character varying(50),
    zip_code character varying(50),
    date_of_birth date NOT NULL,
    gender character varying(1),
    nationality character(2),
    marital_status character varying(2),
    picture_file character varying(32),
    employed boolean DEFAULT true NOT NULL,
    self_employed boolean DEFAULT false NOT NULL,
    employer_name character varying(120),
    monthly_salary real,
    monthly_net_income real,
    annual_turnover real,
    annual_net_income real,
    employer_address text,
    introduced_by character varying(100),
    entity_id integer,
    application_date timestamp without time zone DEFAULT now() NOT NULL,
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.applicants OWNER TO postgres;

--
-- Name: applicants_applicant_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.applicants_applicant_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.applicants_applicant_id_seq OWNER TO postgres;

--
-- Name: applicants_applicant_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.applicants_applicant_id_seq OWNED BY public.applicants.applicant_id;


--
-- Name: approval_checklists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.approval_checklists (
    approval_checklist_id integer NOT NULL,
    approval_id integer NOT NULL,
    checklist_id integer NOT NULL,
    org_id integer,
    requirement text,
    manditory boolean DEFAULT false NOT NULL,
    done boolean DEFAULT false NOT NULL,
    narrative character varying(320)
);


ALTER TABLE public.approval_checklists OWNER TO postgres;

--
-- Name: approval_checklists_approval_checklist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.approval_checklists_approval_checklist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.approval_checklists_approval_checklist_id_seq OWNER TO postgres;

--
-- Name: approval_checklists_approval_checklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.approval_checklists_approval_checklist_id_seq OWNED BY public.approval_checklists.approval_checklist_id;


--
-- Name: approvals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.approvals (
    approval_id integer NOT NULL,
    workflow_phase_id integer NOT NULL,
    org_entity_id integer NOT NULL,
    app_entity_id integer,
    org_id integer,
    approval_level integer DEFAULT 1 NOT NULL,
    escalation_days integer DEFAULT 0 NOT NULL,
    escalation_hours integer DEFAULT 3 NOT NULL,
    escalation_time timestamp without time zone DEFAULT now() NOT NULL,
    forward_id integer,
    table_name character varying(64),
    table_id integer,
    application_date timestamp without time zone DEFAULT now() NOT NULL,
    completion_date timestamp without time zone,
    action_date timestamp without time zone,
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    approval_narrative character varying(240),
    to_be_done text,
    what_is_done text,
    review_advice text,
    details text
);


ALTER TABLE public.approvals OWNER TO postgres;

--
-- Name: approvals_approval_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.approvals_approval_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.approvals_approval_id_seq OWNER TO postgres;

--
-- Name: approvals_approval_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.approvals_approval_id_seq OWNED BY public.approvals.approval_id;


--
-- Name: bank_accounts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bank_accounts (
    bank_account_id integer NOT NULL,
    org_id integer,
    bank_branch_id integer,
    account_id integer,
    currency_id integer,
    bank_account_name character varying(120),
    bank_account_number character varying(50),
    narrative character varying(240),
    is_default boolean DEFAULT false NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    details text
);


ALTER TABLE public.bank_accounts OWNER TO postgres;

--
-- Name: bank_accounts_bank_account_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.bank_accounts_bank_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bank_accounts_bank_account_id_seq OWNER TO postgres;

--
-- Name: bank_accounts_bank_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.bank_accounts_bank_account_id_seq OWNED BY public.bank_accounts.bank_account_id;


--
-- Name: bank_branch; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bank_branch (
    bank_branch_id integer NOT NULL,
    bank_id integer,
    org_id integer,
    bank_branch_name character varying(50) NOT NULL,
    bank_branch_code character varying(50),
    narrative character varying(240)
);


ALTER TABLE public.bank_branch OWNER TO postgres;

--
-- Name: bank_branch_bank_branch_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.bank_branch_bank_branch_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bank_branch_bank_branch_id_seq OWNER TO postgres;

--
-- Name: bank_branch_bank_branch_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.bank_branch_bank_branch_id_seq OWNED BY public.bank_branch.bank_branch_id;


--
-- Name: banks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.banks (
    bank_id integer NOT NULL,
    sys_country_id character(2),
    org_id integer,
    bank_name character varying(50) NOT NULL,
    bank_code character varying(25),
    swift_code character varying(25),
    sort_code character varying(25),
    narrative character varying(240)
);


ALTER TABLE public.banks OWNER TO postgres;

--
-- Name: banks_bank_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.banks_bank_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.banks_bank_id_seq OWNER TO postgres;

--
-- Name: banks_bank_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.banks_bank_id_seq OWNED BY public.banks.bank_id;


--
-- Name: bidders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.bidders (
    bidder_id integer NOT NULL,
    tender_id integer,
    entity_id integer,
    org_id integer,
    tender_amount real,
    bind_bond character varying(120),
    bind_bond_amount real,
    return_date date,
    points real,
    is_awarded boolean NOT NULL,
    award_reference character varying(32),
    details text
);


ALTER TABLE public.bidders OWNER TO postgres;

--
-- Name: bidders_bidder_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.bidders_bidder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.bidders_bidder_id_seq OWNER TO postgres;

--
-- Name: bidders_bidder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.bidders_bidder_id_seq OWNED BY public.bidders.bidder_id;


--
-- Name: block_chains; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.block_chains (
    block_chain_id integer NOT NULL,
    org_id integer,
    link_activity_id integer NOT NULL,
    block_data text,
    block_hash text,
    previous_hash text
);


ALTER TABLE public.block_chains OWNER TO postgres;

--
-- Name: block_chains_block_chain_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.block_chains_block_chain_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.block_chains_block_chain_id_seq OWNER TO postgres;

--
-- Name: block_chains_block_chain_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.block_chains_block_chain_id_seq OWNED BY public.block_chains.block_chain_id;


--
-- Name: budget_lines; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.budget_lines (
    budget_line_id integer NOT NULL,
    budget_id integer,
    period_id integer,
    account_id integer,
    item_id integer,
    transaction_id integer,
    org_id integer,
    spend_type integer DEFAULT 0 NOT NULL,
    quantity integer DEFAULT 1 NOT NULL,
    amount real DEFAULT 0 NOT NULL,
    tax_amount real DEFAULT 0 NOT NULL,
    income_budget boolean DEFAULT false NOT NULL,
    narrative character varying(240),
    details text
);


ALTER TABLE public.budget_lines OWNER TO postgres;

--
-- Name: budget_lines_budget_line_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.budget_lines_budget_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.budget_lines_budget_line_id_seq OWNER TO postgres;

--
-- Name: budget_lines_budget_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.budget_lines_budget_line_id_seq OWNED BY public.budget_lines.budget_line_id;


--
-- Name: budgets; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.budgets (
    budget_id integer NOT NULL,
    fiscal_year_id integer,
    department_id integer,
    link_budget_id integer,
    entity_id integer,
    org_id integer,
    budget_type integer DEFAULT 1 NOT NULL,
    budget_name character varying(50),
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.budgets OWNER TO postgres;

--
-- Name: budgets_budget_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.budgets_budget_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.budgets_budget_id_seq OWNER TO postgres;

--
-- Name: budgets_budget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.budgets_budget_id_seq OWNED BY public.budgets.budget_id;


--
-- Name: checklists; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.checklists (
    checklist_id integer NOT NULL,
    workflow_phase_id integer NOT NULL,
    org_id integer,
    checklist_number integer,
    manditory boolean DEFAULT false NOT NULL,
    requirement text,
    details text
);


ALTER TABLE public.checklists OWNER TO postgres;

--
-- Name: checklists_checklist_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.checklists_checklist_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.checklists_checklist_id_seq OWNER TO postgres;

--
-- Name: checklists_checklist_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.checklists_checklist_id_seq OWNED BY public.checklists.checklist_id;


--
-- Name: collateral_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.collateral_types (
    collateral_type_id integer NOT NULL,
    org_id integer,
    collateral_type_name character varying(50) NOT NULL,
    details text
);


ALTER TABLE public.collateral_types OWNER TO postgres;

--
-- Name: collateral_types_collateral_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.collateral_types_collateral_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.collateral_types_collateral_type_id_seq OWNER TO postgres;

--
-- Name: collateral_types_collateral_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.collateral_types_collateral_type_id_seq OWNED BY public.collateral_types.collateral_type_id;


--
-- Name: collaterals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.collaterals (
    collateral_id integer NOT NULL,
    loan_id integer,
    collateral_type_id integer,
    entity_id integer,
    org_id integer,
    collateral_amount real NOT NULL,
    collateral_received boolean DEFAULT false NOT NULL,
    collateral_released boolean DEFAULT false NOT NULL,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.collaterals OWNER TO postgres;

--
-- Name: collaterals_collateral_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.collaterals_collateral_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.collaterals_collateral_id_seq OWNER TO postgres;

--
-- Name: collaterals_collateral_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.collaterals_collateral_id_seq OWNED BY public.collaterals.collateral_id;


--
-- Name: commodity_trades; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.commodity_trades (
    commodity_trade_id integer NOT NULL,
    deposit_account_id integer,
    transfer_account_id integer,
    commodity_id integer,
    entity_id integer,
    use_key_id integer NOT NULL,
    org_id integer,
    transfer_account_no character varying(32),
    link_activity_id integer NOT NULL,
    unit_debit real DEFAULT 0 NOT NULL,
    unit_credit real DEFAULT 0 NOT NULL,
    price real DEFAULT 0 NOT NULL,
    trade_date date NOT NULL,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.commodity_trades OWNER TO postgres;

--
-- Name: commodity_trades_commodity_trade_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.commodity_trades_commodity_trade_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.commodity_trades_commodity_trade_id_seq OWNER TO postgres;

--
-- Name: commodity_trades_commodity_trade_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.commodity_trades_commodity_trade_id_seq OWNED BY public.commodity_trades.commodity_trade_id;


--
-- Name: commodity_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.commodity_types (
    commodity_type_id integer NOT NULL,
    org_id integer,
    commodity_type_name character varying(50) NOT NULL,
    details text
);


ALTER TABLE public.commodity_types OWNER TO postgres;

--
-- Name: commodity_types_commodity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.commodity_types_commodity_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.commodity_types_commodity_type_id_seq OWNER TO postgres;

--
-- Name: commodity_types_commodity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.commodity_types_commodity_type_id_seq OWNED BY public.commodity_types.commodity_type_id;


--
-- Name: commoditys; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.commoditys (
    commodity_id integer NOT NULL,
    commodity_type_id integer,
    org_id integer,
    commodity_name character varying(50) NOT NULL,
    commodity_account character varying(32) NOT NULL,
    current_price real DEFAULT 0 NOT NULL,
    details text
);


ALTER TABLE public.commoditys OWNER TO postgres;

--
-- Name: commoditys_commodity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.commoditys_commodity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.commoditys_commodity_id_seq OWNER TO postgres;

--
-- Name: commoditys_commodity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.commoditys_commodity_id_seq OWNED BY public.commoditys.commodity_id;


--
-- Name: contracts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.contracts (
    contract_id integer NOT NULL,
    bidder_id integer,
    org_id integer,
    contract_name character varying(320) NOT NULL,
    contract_date date,
    contract_end date,
    contract_amount real,
    contract_tax real,
    details text
);


ALTER TABLE public.contracts OWNER TO postgres;

--
-- Name: contracts_contract_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.contracts_contract_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.contracts_contract_id_seq OWNER TO postgres;

--
-- Name: contracts_contract_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.contracts_contract_id_seq OWNED BY public.contracts.contract_id;


--
-- Name: currency; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.currency (
    currency_id integer NOT NULL,
    currency_name character varying(50),
    currency_symbol character varying(3),
    org_id integer
);


ALTER TABLE public.currency OWNER TO postgres;

--
-- Name: currency_currency_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.currency_currency_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.currency_currency_id_seq OWNER TO postgres;

--
-- Name: currency_currency_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.currency_currency_id_seq OWNED BY public.currency.currency_id;


--
-- Name: currency_rates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.currency_rates (
    currency_rate_id integer NOT NULL,
    currency_id integer,
    org_id integer,
    exchange_date date DEFAULT ('now'::text)::date NOT NULL,
    exchange_rate real DEFAULT 1 NOT NULL
);


ALTER TABLE public.currency_rates OWNER TO postgres;

--
-- Name: currency_rates_currency_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.currency_rates_currency_rate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.currency_rates_currency_rate_id_seq OWNER TO postgres;

--
-- Name: currency_rates_currency_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.currency_rates_currency_rate_id_seq OWNED BY public.currency_rates.currency_rate_id;


--
-- Name: default_accounts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.default_accounts (
    default_account_id integer NOT NULL,
    account_id integer,
    use_key_id integer NOT NULL,
    org_id integer,
    narrative character varying(240)
);


ALTER TABLE public.default_accounts OWNER TO postgres;

--
-- Name: default_accounts_default_account_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.default_accounts_default_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.default_accounts_default_account_id_seq OWNER TO postgres;

--
-- Name: default_accounts_default_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.default_accounts_default_account_id_seq OWNED BY public.default_accounts.default_account_id;


--
-- Name: default_tax_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.default_tax_types (
    default_tax_type_id integer NOT NULL,
    entity_id integer,
    tax_type_id integer,
    org_id integer,
    tax_identification character varying(50),
    narrative character varying(240),
    additional double precision DEFAULT 0 NOT NULL,
    active boolean DEFAULT true
);


ALTER TABLE public.default_tax_types OWNER TO postgres;

--
-- Name: default_tax_types_default_tax_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.default_tax_types_default_tax_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.default_tax_types_default_tax_type_id_seq OWNER TO postgres;

--
-- Name: default_tax_types_default_tax_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.default_tax_types_default_tax_type_id_seq OWNED BY public.default_tax_types.default_tax_type_id;


--
-- Name: departments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.departments (
    department_id integer NOT NULL,
    ln_department_id integer,
    org_id integer,
    department_name character varying(120),
    department_account character varying(50),
    function_code character varying(50),
    active boolean DEFAULT true NOT NULL,
    petty_cash boolean DEFAULT false NOT NULL,
    cost_center boolean DEFAULT true NOT NULL,
    revenue_center boolean DEFAULT true NOT NULL,
    description text,
    duties text,
    reports text,
    details text
);


ALTER TABLE public.departments OWNER TO postgres;

--
-- Name: departments_department_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.departments_department_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.departments_department_id_seq OWNER TO postgres;

--
-- Name: departments_department_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.departments_department_id_seq OWNED BY public.departments.department_id;


--
-- Name: deposit_accounts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.deposit_accounts (
    deposit_account_id integer NOT NULL,
    member_id integer,
    product_id integer,
    activity_frequency_id integer,
    entity_id integer,
    org_id integer,
    is_active boolean DEFAULT false NOT NULL,
    account_number character varying(32) NOT NULL,
    narrative character varying(120),
    opening_date date DEFAULT ('now'::text)::date NOT NULL,
    last_closing_date date,
    credit_limit real,
    minimum_balance real,
    maximum_balance real,
    interest_rate real NOT NULL,
    lockin_period_frequency real,
    lockedin_until_date date,
    application_date timestamp without time zone DEFAULT now() NOT NULL,
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.deposit_accounts OWNER TO postgres;

--
-- Name: deposit_accounts_deposit_account_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.deposit_accounts_deposit_account_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.deposit_accounts_deposit_account_id_seq OWNER TO postgres;

--
-- Name: deposit_accounts_deposit_account_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.deposit_accounts_deposit_account_id_seq OWNED BY public.deposit_accounts.deposit_account_id;


--
-- Name: e_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.e_fields (
    e_field_id integer NOT NULL,
    et_field_id integer,
    org_id integer,
    table_code integer NOT NULL,
    table_id integer,
    e_field_value character varying(320)
);


ALTER TABLE public.e_fields OWNER TO postgres;

--
-- Name: e_fields_e_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.e_fields_e_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.e_fields_e_field_id_seq OWNER TO postgres;

--
-- Name: e_fields_e_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.e_fields_e_field_id_seq OWNED BY public.e_fields.e_field_id;


--
-- Name: entity_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entity_fields (
    entity_field_id integer NOT NULL,
    org_id integer NOT NULL,
    use_type integer DEFAULT 1 NOT NULL,
    is_active boolean DEFAULT true,
    entity_field_name character varying(240),
    entity_field_source character varying(320)
);


ALTER TABLE public.entity_fields OWNER TO postgres;

--
-- Name: entity_fields_entity_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entity_fields_entity_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entity_fields_entity_field_id_seq OWNER TO postgres;

--
-- Name: entity_fields_entity_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entity_fields_entity_field_id_seq OWNED BY public.entity_fields.entity_field_id;


--
-- Name: entity_orgs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entity_orgs (
    entity_org_id integer NOT NULL,
    entity_id integer NOT NULL,
    org_id integer,
    details text
);


ALTER TABLE public.entity_orgs OWNER TO postgres;

--
-- Name: entity_orgs_entity_org_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entity_orgs_entity_org_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entity_orgs_entity_org_id_seq OWNER TO postgres;

--
-- Name: entity_orgs_entity_org_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entity_orgs_entity_org_id_seq OWNED BY public.entity_orgs.entity_org_id;


--
-- Name: entity_subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entity_subscriptions (
    entity_subscription_id integer NOT NULL,
    entity_type_id integer NOT NULL,
    entity_id integer NOT NULL,
    org_id integer,
    details text
);


ALTER TABLE public.entity_subscriptions OWNER TO postgres;

--
-- Name: entity_subscriptions_entity_subscription_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entity_subscriptions_entity_subscription_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entity_subscriptions_entity_subscription_id_seq OWNER TO postgres;

--
-- Name: entity_subscriptions_entity_subscription_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entity_subscriptions_entity_subscription_id_seq OWNED BY public.entity_subscriptions.entity_subscription_id;


--
-- Name: entity_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entity_types (
    entity_type_id integer NOT NULL,
    use_key_id integer NOT NULL,
    org_id integer,
    entity_type_name character varying(50) NOT NULL,
    entity_role character varying(240),
    start_view character varying(120),
    group_email character varying(120),
    description text,
    details text
);


ALTER TABLE public.entity_types OWNER TO postgres;

--
-- Name: entity_types_entity_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entity_types_entity_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entity_types_entity_type_id_seq OWNER TO postgres;

--
-- Name: entity_types_entity_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entity_types_entity_type_id_seq OWNED BY public.entity_types.entity_type_id;


--
-- Name: entity_values; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entity_values (
    entity_value_id integer NOT NULL,
    entity_id integer,
    entity_field_id integer,
    org_id integer,
    entity_value character varying(240)
);


ALTER TABLE public.entity_values OWNER TO postgres;

--
-- Name: entity_values_entity_value_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entity_values_entity_value_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entity_values_entity_value_id_seq OWNER TO postgres;

--
-- Name: entity_values_entity_value_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entity_values_entity_value_id_seq OWNED BY public.entity_values.entity_value_id;


--
-- Name: entitys; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entitys (
    entity_id integer NOT NULL,
    entity_type_id integer NOT NULL,
    use_key_id integer NOT NULL,
    sys_language_id integer,
    org_id integer NOT NULL,
    entity_name character varying(120) NOT NULL,
    user_name character varying(120) NOT NULL,
    primary_email character varying(120),
    primary_telephone character varying(50),
    super_user boolean DEFAULT false NOT NULL,
    entity_leader boolean DEFAULT false NOT NULL,
    no_org boolean DEFAULT false NOT NULL,
    function_role character varying(240),
    date_enroled timestamp without time zone DEFAULT now() NOT NULL,
    is_active boolean DEFAULT true,
    entity_password character varying(64) NOT NULL,
    first_password character varying(64) NOT NULL,
    new_password character varying(64),
    start_url character varying(64),
    is_picked boolean DEFAULT false NOT NULL,
    details text,
    attention character varying(50),
    credit_limit real DEFAULT 0,
    account_id integer,
    member_id integer
);


ALTER TABLE public.entitys OWNER TO postgres;

--
-- Name: entitys_entity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entitys_entity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entitys_entity_id_seq OWNER TO postgres;

--
-- Name: entitys_entity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entitys_entity_id_seq OWNED BY public.entitys.entity_id;


--
-- Name: entry_forms; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.entry_forms (
    entry_form_id integer NOT NULL,
    org_id integer,
    entity_id integer,
    form_id integer,
    entered_by_id integer,
    application_date timestamp without time zone DEFAULT now() NOT NULL,
    completion_date timestamp without time zone,
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    narrative character varying(240),
    answer text,
    sub_answer text,
    details text
);


ALTER TABLE public.entry_forms OWNER TO postgres;

--
-- Name: entry_forms_entry_form_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.entry_forms_entry_form_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.entry_forms_entry_form_id_seq OWNER TO postgres;

--
-- Name: entry_forms_entry_form_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.entry_forms_entry_form_id_seq OWNED BY public.entry_forms.entry_form_id;


--
-- Name: et_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.et_fields (
    et_field_id integer NOT NULL,
    org_id integer,
    et_field_name character varying(320) NOT NULL,
    table_name character varying(64) NOT NULL,
    table_code integer NOT NULL,
    table_link integer,
    is_active boolean DEFAULT true NOT NULL
);


ALTER TABLE public.et_fields OWNER TO postgres;

--
-- Name: et_fields_et_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.et_fields_et_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.et_fields_et_field_id_seq OWNER TO postgres;

--
-- Name: et_fields_et_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.et_fields_et_field_id_seq OWNED BY public.et_fields.et_field_id;


--
-- Name: fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.fields (
    field_id integer NOT NULL,
    org_id integer,
    form_id integer,
    field_name character varying(50),
    question text,
    field_lookup text,
    field_type character varying(25) NOT NULL,
    field_class character varying(25),
    field_bold character(1) DEFAULT '0'::bpchar NOT NULL,
    field_italics character(1) DEFAULT '0'::bpchar NOT NULL,
    field_order integer NOT NULL,
    share_line integer,
    field_size integer DEFAULT 25 NOT NULL,
    label_position character(1) DEFAULT 'L'::bpchar,
    field_fnct character varying(120),
    manditory character(1) DEFAULT '0'::bpchar NOT NULL,
    show character(1) DEFAULT '1'::bpchar,
    tab character varying(25),
    details text
);


ALTER TABLE public.fields OWNER TO postgres;

--
-- Name: fields_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.fields_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fields_field_id_seq OWNER TO postgres;

--
-- Name: fields_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.fields_field_id_seq OWNED BY public.fields.field_id;


--
-- Name: fiscal_years; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.fiscal_years (
    fiscal_year_id integer NOT NULL,
    fiscal_year character varying(9) NOT NULL,
    org_id integer,
    fiscal_year_start date NOT NULL,
    fiscal_year_end date NOT NULL,
    submission_date date,
    year_opened boolean DEFAULT true NOT NULL,
    year_closed boolean DEFAULT false NOT NULL,
    details text
);


ALTER TABLE public.fiscal_years OWNER TO postgres;

--
-- Name: fiscal_years_fiscal_year_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.fiscal_years_fiscal_year_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fiscal_years_fiscal_year_id_seq OWNER TO postgres;

--
-- Name: fiscal_years_fiscal_year_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.fiscal_years_fiscal_year_id_seq OWNED BY public.fiscal_years.fiscal_year_id;


--
-- Name: folders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.folders (
    folder_id integer NOT NULL,
    org_id integer,
    folder_name character varying(25),
    details text
);


ALTER TABLE public.folders OWNER TO postgres;

--
-- Name: folders_folder_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.folders_folder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.folders_folder_id_seq OWNER TO postgres;

--
-- Name: folders_folder_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.folders_folder_id_seq OWNED BY public.folders.folder_id;


--
-- Name: follow_up; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.follow_up (
    follow_up_id integer NOT NULL,
    lead_item_id integer,
    entity_id integer,
    org_id integer,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    follow_date date DEFAULT ('now'::text)::date NOT NULL,
    follow_time time without time zone DEFAULT ('now'::text)::time with time zone NOT NULL,
    done boolean DEFAULT false NOT NULL,
    narrative character varying(240),
    details text
);


ALTER TABLE public.follow_up OWNER TO postgres;

--
-- Name: follow_up_follow_up_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.follow_up_follow_up_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.follow_up_follow_up_id_seq OWNER TO postgres;

--
-- Name: follow_up_follow_up_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.follow_up_follow_up_id_seq OWNED BY public.follow_up.follow_up_id;


--
-- Name: forms; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.forms (
    form_id integer NOT NULL,
    org_id integer,
    form_name character varying(240) NOT NULL,
    form_number character varying(50),
    table_name character varying(50),
    version character varying(25),
    completed character(1) DEFAULT '0'::bpchar NOT NULL,
    is_active character(1) DEFAULT '0'::bpchar NOT NULL,
    use_key integer DEFAULT 0,
    form_header text,
    form_footer text,
    default_values text,
    details text
);


ALTER TABLE public.forms OWNER TO postgres;

--
-- Name: forms_form_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.forms_form_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.forms_form_id_seq OWNER TO postgres;

--
-- Name: forms_form_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.forms_form_id_seq OWNED BY public.forms.form_id;


--
-- Name: gls; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.gls (
    gl_id integer NOT NULL,
    journal_id integer NOT NULL,
    account_id integer NOT NULL,
    org_id integer,
    debit real DEFAULT 0 NOT NULL,
    credit real DEFAULT 0 NOT NULL,
    gl_narrative character varying(240),
    account_activity_id integer
);


ALTER TABLE public.gls OWNER TO postgres;

--
-- Name: gls_gl_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.gls_gl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.gls_gl_id_seq OWNER TO postgres;

--
-- Name: gls_gl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.gls_gl_id_seq OWNED BY public.gls.gl_id;


--
-- Name: group_sms_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.group_sms_details (
    group_sms_detail_id integer NOT NULL,
    sms_group_id integer,
    sms_group_member_id integer,
    org_id integer,
    message text
);


ALTER TABLE public.group_sms_details OWNER TO postgres;

--
-- Name: group_sms_details_group_sms_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.group_sms_details_group_sms_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.group_sms_details_group_sms_detail_id_seq OWNER TO postgres;

--
-- Name: group_sms_details_group_sms_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.group_sms_details_group_sms_detail_id_seq OWNED BY public.group_sms_details.group_sms_detail_id;


--
-- Name: guarantees; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.guarantees (
    guarantee_id integer NOT NULL,
    loan_id integer,
    member_id integer,
    entity_id integer,
    org_id integer,
    guarantee_amount real NOT NULL,
    guarantee_accepted boolean DEFAULT false NOT NULL,
    accepted_date timestamp without time zone,
    is_active boolean DEFAULT false NOT NULL,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.guarantees OWNER TO postgres;

--
-- Name: guarantees_guarantee_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.guarantees_guarantee_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.guarantees_guarantee_id_seq OWNER TO postgres;

--
-- Name: guarantees_guarantee_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.guarantees_guarantee_id_seq OWNED BY public.guarantees.guarantee_id;


--
-- Name: helpdesk; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.helpdesk (
    helpdesk_id integer NOT NULL,
    org_id integer,
    issue_definition_id integer,
    issue_level_id integer,
    member_id integer,
    description text,
    recorded_by integer,
    recoded_time timestamp without time zone DEFAULT now() NOT NULL,
    solved_time timestamp without time zone,
    is_solved boolean DEFAULT false NOT NULL,
    closed_by integer,
    is_escalated boolean DEFAULT false NOT NULL,
    escalated_to integer,
    escalated_by integer,
    escalated_time timestamp without time zone,
    curr_action character varying(50),
    curr_status character varying(50),
    problem text,
    solution text
);


ALTER TABLE public.helpdesk OWNER TO postgres;

--
-- Name: helpdesk_helpdesk_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.helpdesk_helpdesk_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.helpdesk_helpdesk_id_seq OWNER TO postgres;

--
-- Name: helpdesk_helpdesk_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.helpdesk_helpdesk_id_seq OWNED BY public.helpdesk.helpdesk_id;


--
-- Name: holidays; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.holidays (
    holiday_id integer NOT NULL,
    org_id integer,
    holiday_name character varying(50) NOT NULL,
    holiday_date date,
    details text
);


ALTER TABLE public.holidays OWNER TO postgres;

--
-- Name: holidays_holiday_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.holidays_holiday_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.holidays_holiday_id_seq OWNER TO postgres;

--
-- Name: holidays_holiday_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.holidays_holiday_id_seq OWNED BY public.holidays.holiday_id;


--
-- Name: industry; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.industry (
    industry_id integer NOT NULL,
    org_id integer,
    industry_name character varying(50) NOT NULL,
    details text
);


ALTER TABLE public.industry OWNER TO postgres;

--
-- Name: industry_industry_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.industry_industry_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.industry_industry_id_seq OWNER TO postgres;

--
-- Name: industry_industry_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.industry_industry_id_seq OWNED BY public.industry.industry_id;


--
-- Name: interest_methods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.interest_methods (
    interest_method_id integer NOT NULL,
    activity_type_id integer NOT NULL,
    org_id integer,
    interest_method_name character varying(120) NOT NULL,
    reducing_balance boolean DEFAULT false NOT NULL,
    reducing_payments boolean DEFAULT false NOT NULL,
    formural character varying(320),
    account_number character varying(32),
    interest_method_no integer,
    details text
);


ALTER TABLE public.interest_methods OWNER TO postgres;

--
-- Name: interest_methods_interest_method_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.interest_methods_interest_method_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.interest_methods_interest_method_id_seq OWNER TO postgres;

--
-- Name: interest_methods_interest_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.interest_methods_interest_method_id_seq OWNED BY public.interest_methods.interest_method_id;


--
-- Name: investment_status; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.investment_status (
    investment_status_id integer NOT NULL,
    org_id integer,
    investment_status_name character varying(120),
    details text
);


ALTER TABLE public.investment_status OWNER TO postgres;

--
-- Name: investment_status_investment_status_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.investment_status_investment_status_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.investment_status_investment_status_id_seq OWNER TO postgres;

--
-- Name: investment_status_investment_status_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.investment_status_investment_status_id_seq OWNED BY public.investment_status.investment_status_id;


--
-- Name: investment_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.investment_types (
    investment_type_id integer NOT NULL,
    org_id integer,
    investment_type_name character varying(120),
    interest_amount real,
    details text
);


ALTER TABLE public.investment_types OWNER TO postgres;

--
-- Name: investment_types_investment_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.investment_types_investment_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.investment_types_investment_type_id_seq OWNER TO postgres;

--
-- Name: investment_types_investment_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.investment_types_investment_type_id_seq OWNED BY public.investment_types.investment_type_id;


--
-- Name: investments; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.investments (
    investment_id integer NOT NULL,
    investment_type_id integer,
    investment_status_id integer,
    currency_id integer,
    entity_id integer,
    org_id integer,
    investment_name character varying(120),
    started_date date,
    expected_maturity date,
    exchange_rate real DEFAULT 1 NOT NULL,
    proposed_capital real DEFAULT 0 NOT NULL,
    expected_profit real DEFAULT 0 NOT NULL,
    initial_payment real DEFAULT 0 NOT NULL,
    monthly_payments real DEFAULT 0 NOT NULL,
    monthly_returns real DEFAULT 0 NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    is_completed boolean DEFAULT true NOT NULL,
    application_date timestamp without time zone,
    approve_status character varying(16),
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.investments OWNER TO postgres;

--
-- Name: investments_investment_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.investments_investment_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.investments_investment_id_seq OWNER TO postgres;

--
-- Name: investments_investment_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.investments_investment_id_seq OWNED BY public.investments.investment_id;


--
-- Name: issue_definitions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.issue_definitions (
    issue_definition_id integer NOT NULL,
    issue_type_id integer,
    org_id integer,
    issue_definition_name character varying(50) NOT NULL,
    description text,
    solution text
);


ALTER TABLE public.issue_definitions OWNER TO postgres;

--
-- Name: issue_definitions_issue_definition_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.issue_definitions_issue_definition_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.issue_definitions_issue_definition_id_seq OWNER TO postgres;

--
-- Name: issue_definitions_issue_definition_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.issue_definitions_issue_definition_id_seq OWNED BY public.issue_definitions.issue_definition_id;


--
-- Name: issue_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.issue_levels (
    issue_level_id integer NOT NULL,
    org_id integer,
    issue_level_name character varying(50) NOT NULL,
    details text
);


ALTER TABLE public.issue_levels OWNER TO postgres;

--
-- Name: issue_levels_issue_level_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.issue_levels_issue_level_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.issue_levels_issue_level_id_seq OWNER TO postgres;

--
-- Name: issue_levels_issue_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.issue_levels_issue_level_id_seq OWNED BY public.issue_levels.issue_level_id;


--
-- Name: issue_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.issue_types (
    issue_type_id integer NOT NULL,
    org_id integer,
    issue_type_name character varying(50) NOT NULL,
    details text
);


ALTER TABLE public.issue_types OWNER TO postgres;

--
-- Name: issue_types_issue_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.issue_types_issue_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.issue_types_issue_type_id_seq OWNER TO postgres;

--
-- Name: issue_types_issue_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.issue_types_issue_type_id_seq OWNED BY public.issue_types.issue_type_id;


--
-- Name: item_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.item_category (
    item_category_id integer NOT NULL,
    org_id integer,
    item_category_name character varying(120) NOT NULL,
    details text
);


ALTER TABLE public.item_category OWNER TO postgres;

--
-- Name: item_category_item_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.item_category_item_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.item_category_item_category_id_seq OWNER TO postgres;

--
-- Name: item_category_item_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.item_category_item_category_id_seq OWNED BY public.item_category.item_category_id;


--
-- Name: item_units; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.item_units (
    item_unit_id integer NOT NULL,
    org_id integer,
    item_unit_name character varying(50) NOT NULL,
    details text
);


ALTER TABLE public.item_units OWNER TO postgres;

--
-- Name: item_units_item_unit_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.item_units_item_unit_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.item_units_item_unit_id_seq OWNER TO postgres;

--
-- Name: item_units_item_unit_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.item_units_item_unit_id_seq OWNED BY public.item_units.item_unit_id;


--
-- Name: items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.items (
    item_id integer NOT NULL,
    org_id integer,
    item_category_id integer,
    tax_type_id integer,
    item_unit_id integer,
    sales_account_id integer,
    purchase_account_id integer,
    item_name character varying(120) NOT NULL,
    bar_code character varying(32),
    inventory boolean DEFAULT false NOT NULL,
    for_sale boolean DEFAULT true NOT NULL,
    for_purchase boolean DEFAULT true NOT NULL,
    for_stock boolean DEFAULT true NOT NULL,
    sales_price real,
    purchase_price real,
    reorder_level integer,
    lead_time integer,
    is_active boolean DEFAULT true NOT NULL,
    details text
);


ALTER TABLE public.items OWNER TO postgres;

--
-- Name: items_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.items_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.items_item_id_seq OWNER TO postgres;

--
-- Name: items_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.items_item_id_seq OWNED BY public.items.item_id;


--
-- Name: journals; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.journals (
    journal_id integer NOT NULL,
    period_id integer NOT NULL,
    currency_id integer,
    department_id integer,
    org_id integer,
    exchange_rate real DEFAULT 1 NOT NULL,
    journal_date date NOT NULL,
    posted boolean DEFAULT false NOT NULL,
    year_closing boolean DEFAULT false NOT NULL,
    narrative character varying(240),
    details text
);


ALTER TABLE public.journals OWNER TO postgres;

--
-- Name: journals_journal_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.journals_journal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.journals_journal_id_seq OWNER TO postgres;

--
-- Name: journals_journal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.journals_journal_id_seq OWNED BY public.journals.journal_id;


--
-- Name: kin_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.kin_types (
    kin_type_id integer NOT NULL,
    org_id integer,
    spouse boolean DEFAULT false NOT NULL,
    kin_type_name character varying(50),
    details text
);


ALTER TABLE public.kin_types OWNER TO postgres;

--
-- Name: kin_types_kin_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.kin_types_kin_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.kin_types_kin_type_id_seq OWNER TO postgres;

--
-- Name: kin_types_kin_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.kin_types_kin_type_id_seq OWNED BY public.kin_types.kin_type_id;


--
-- Name: kins; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.kins (
    kin_id integer NOT NULL,
    member_id integer,
    kin_type_id integer,
    org_id integer,
    full_names character varying(120),
    date_of_birth date,
    identification character varying(50),
    identification_type character varying(50),
    emergency_contact boolean DEFAULT false NOT NULL,
    beneficiary boolean DEFAULT false NOT NULL,
    beneficiary_ps real,
    details text
);


ALTER TABLE public.kins OWNER TO postgres;

--
-- Name: kins_kin_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.kins_kin_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.kins_kin_id_seq OWNER TO postgres;

--
-- Name: kins_kin_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.kins_kin_id_seq OWNED BY public.kins.kin_id;


--
-- Name: lead_categorys; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.lead_categorys (
    lead_category_id integer NOT NULL,
    use_key_id integer,
    org_id integer,
    lead_category_name character varying(120) NOT NULL,
    details text
);


ALTER TABLE public.lead_categorys OWNER TO postgres;

--
-- Name: lead_categorys_lead_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.lead_categorys_lead_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lead_categorys_lead_category_id_seq OWNER TO postgres;

--
-- Name: lead_categorys_lead_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.lead_categorys_lead_category_id_seq OWNED BY public.lead_categorys.lead_category_id;


--
-- Name: lead_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.lead_items (
    lead_item_id integer NOT NULL,
    lead_id integer,
    entity_id integer,
    item_id integer,
    org_id integer,
    pitch_date date DEFAULT ('now'::text)::date NOT NULL,
    units integer DEFAULT 1 NOT NULL,
    price real DEFAULT 0 NOT NULL,
    lead_level integer DEFAULT 1 NOT NULL,
    narrative character varying(320),
    details text
);


ALTER TABLE public.lead_items OWNER TO postgres;

--
-- Name: lead_items_lead_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.lead_items_lead_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.lead_items_lead_item_id_seq OWNER TO postgres;

--
-- Name: lead_items_lead_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.lead_items_lead_item_id_seq OWNED BY public.lead_items.lead_item_id;


--
-- Name: leads; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.leads (
    lead_id integer NOT NULL,
    lead_category_id integer NOT NULL,
    industry_id integer NOT NULL,
    entity_id integer NOT NULL,
    org_id integer,
    business_id integer,
    business_name character varying(50) NOT NULL,
    business_address character varying(100),
    city character varying(30),
    state character varying(50),
    country_id character(2),
    number_of_employees integer,
    telephone character varying(50),
    website character varying(120),
    primary_contact character varying(120),
    job_title character varying(120),
    primary_email character varying(120),
    prospect_level integer DEFAULT 1 NOT NULL,
    contact_date date DEFAULT ('now'::text)::date NOT NULL,
    details text
);


ALTER TABLE public.leads OWNER TO postgres;

--
-- Name: leads_lead_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.leads_lead_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.leads_lead_id_seq OWNER TO postgres;

--
-- Name: leads_lead_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.leads_lead_id_seq OWNED BY public.leads.lead_id;


--
-- Name: ledger_links; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ledger_links (
    ledger_link_id integer NOT NULL,
    ledger_type_id integer,
    org_id integer,
    link_type integer,
    link_id integer
);


ALTER TABLE public.ledger_links OWNER TO postgres;

--
-- Name: ledger_links_ledger_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ledger_links_ledger_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ledger_links_ledger_link_id_seq OWNER TO postgres;

--
-- Name: ledger_links_ledger_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ledger_links_ledger_link_id_seq OWNED BY public.ledger_links.ledger_link_id;


--
-- Name: ledger_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ledger_types (
    ledger_type_id integer NOT NULL,
    account_id integer,
    tax_account_id integer,
    org_id integer,
    ledger_type_name character varying(120) NOT NULL,
    ledger_posting boolean DEFAULT true NOT NULL,
    income_ledger boolean DEFAULT true NOT NULL,
    expense_ledger boolean DEFAULT true NOT NULL,
    details text
);


ALTER TABLE public.ledger_types OWNER TO postgres;

--
-- Name: ledger_types_ledger_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ledger_types_ledger_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ledger_types_ledger_type_id_seq OWNER TO postgres;

--
-- Name: ledger_types_ledger_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ledger_types_ledger_type_id_seq OWNED BY public.ledger_types.ledger_type_id;


--
-- Name: link_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.link_activity_id_seq
    START WITH 101
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.link_activity_id_seq OWNER TO postgres;

--
-- Name: loan_approval; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_approval (
    loan_approval_id integer NOT NULL,
    sacco_official_id integer,
    org_id integer,
    processing_approval boolean DEFAULT true NOT NULL,
    final_approval boolean DEFAULT false NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    narrative character varying(120),
    details text
);


ALTER TABLE public.loan_approval OWNER TO postgres;

--
-- Name: loan_approval_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_approval_levels (
    loan_approval_level_id integer NOT NULL,
    org_id integer,
    loan_approval_id integer,
    loan_id integer,
    is_approved boolean DEFAULT false NOT NULL,
    approved_time timestamp without time zone,
    status character varying(50) DEFAULT 'Pending'::character varying NOT NULL,
    entity_id integer,
    narrative character varying(120),
    details text
);


ALTER TABLE public.loan_approval_levels OWNER TO postgres;

--
-- Name: loan_approval_levels_loan_approval_level_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_approval_levels_loan_approval_level_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loan_approval_levels_loan_approval_level_id_seq OWNER TO postgres;

--
-- Name: loan_approval_levels_loan_approval_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_approval_levels_loan_approval_level_id_seq OWNED BY public.loan_approval_levels.loan_approval_level_id;


--
-- Name: loan_approval_loan_approval_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_approval_loan_approval_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loan_approval_loan_approval_id_seq OWNER TO postgres;

--
-- Name: loan_approval_loan_approval_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_approval_loan_approval_id_seq OWNED BY public.loan_approval.loan_approval_id;


--
-- Name: loan_configs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_configs (
    loan_config_id integer NOT NULL,
    org_id integer,
    product_id integer,
    is_guaranteed boolean DEFAULT true NOT NULL,
    is_collateral boolean DEFAULT false NOT NULL,
    membership_period integer DEFAULT 6 NOT NULL,
    less_guaranteed boolean DEFAULT false NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    narrative character varying(120),
    details text
);


ALTER TABLE public.loan_configs OWNER TO postgres;

--
-- Name: loan_configs_loan_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_configs_loan_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loan_configs_loan_config_id_seq OWNER TO postgres;

--
-- Name: loan_configs_loan_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_configs_loan_config_id_seq OWNED BY public.loan_configs.loan_config_id;


--
-- Name: loan_notes; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loan_notes (
    loan_note_id integer NOT NULL,
    loan_id integer,
    org_id integer,
    comment_date timestamp without time zone DEFAULT now() NOT NULL,
    narrative character varying(320) NOT NULL,
    note text NOT NULL
);


ALTER TABLE public.loan_notes OWNER TO postgres;

--
-- Name: loan_notes_loan_note_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loan_notes_loan_note_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loan_notes_loan_note_id_seq OWNER TO postgres;

--
-- Name: loan_notes_loan_note_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loan_notes_loan_note_id_seq OWNED BY public.loan_notes.loan_note_id;


--
-- Name: loans; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.loans (
    loan_id integer NOT NULL,
    member_id integer,
    product_id integer,
    activity_frequency_id integer,
    entity_id integer,
    org_id integer,
    account_number character varying(32) NOT NULL,
    disburse_account character varying(32) NOT NULL,
    principal_amount real NOT NULL,
    interest_rate real NOT NULL,
    repayment_amount real NOT NULL,
    repayment_period integer NOT NULL,
    disbursed_date date,
    matured_date date,
    expected_matured_date date,
    expected_repayment real,
    loan_status character varying(50) DEFAULT 'Draft'::character varying NOT NULL,
    is_active boolean DEFAULT false NOT NULL,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    is_guaranteed boolean DEFAULT true NOT NULL,
    is_collateral boolean DEFAULT false NOT NULL,
    details text
);


ALTER TABLE public.loans OWNER TO postgres;

--
-- Name: loans_loan_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.loans_loan_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.loans_loan_id_seq OWNER TO postgres;

--
-- Name: loans_loan_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.loans_loan_id_seq OWNED BY public.loans.loan_id;


--
-- Name: locations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.locations (
    location_id integer NOT NULL,
    org_id integer,
    location_name character varying(50),
    details text
);


ALTER TABLE public.locations OWNER TO postgres;

--
-- Name: locations_location_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.locations_location_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.locations_location_id_seq OWNER TO postgres;

--
-- Name: locations_location_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.locations_location_id_seq OWNED BY public.locations.location_id;


--
-- Name: members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.members (
    member_id integer NOT NULL,
    entity_id integer,
    org_id integer,
    business_account integer DEFAULT 0 NOT NULL,
    person_title character varying(7),
    member_name character varying(150) NOT NULL,
    identification_number character varying(50) NOT NULL,
    identification_type character varying(50) NOT NULL,
    member_email character varying(50) NOT NULL,
    telephone_number character varying(20) NOT NULL,
    telephone_number2 character varying(20),
    address character varying(50),
    town character varying(50),
    zip_code character varying(50),
    date_of_birth date NOT NULL,
    gender character varying(1),
    nationality character(2),
    marital_status character varying(2),
    picture_file character varying(32),
    entry_date date DEFAULT now(),
    employed boolean DEFAULT true NOT NULL,
    self_employed boolean DEFAULT false NOT NULL,
    employer_name character varying(120),
    monthly_salary real,
    monthly_net_income real,
    annual_turnover real,
    annual_net_income real,
    employer_address text,
    introduced_by character varying(100),
    is_active boolean DEFAULT true NOT NULL,
    terminated boolean DEFAULT false NOT NULL,
    terminate_date timestamp without time zone,
    terminate_status character varying(100) DEFAULT 'N/A'::character varying NOT NULL,
    terminate_application_date timestamp without time zone,
    application_date timestamp without time zone DEFAULT now() NOT NULL,
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.members OWNER TO postgres;

--
-- Name: orgs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.orgs (
    org_id integer NOT NULL,
    currency_id integer,
    default_country_id character(2),
    parent_org_id integer,
    org_name character varying(50) NOT NULL,
    org_full_name character varying(120),
    org_sufix character varying(4) NOT NULL,
    is_default boolean DEFAULT true NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    pin character varying(50),
    pcc character varying(12),
    logo character varying(50),
    letter_head character varying(50),
    email_from character varying(120),
    web_logos boolean DEFAULT false NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL,
    system_key character varying(64),
    system_identifier character varying(64),
    mac_address character varying(64),
    public_key bytea,
    license bytea,
    details text,
    org_client_id integer,
    payroll_payable boolean DEFAULT true NOT NULL,
    cert_number character varying(50),
    vat_number character varying(50),
    enforce_budget boolean DEFAULT true NOT NULL,
    invoice_footer text,
    member_limit integer DEFAULT 100 NOT NULL
);


ALTER TABLE public.orgs OWNER TO postgres;

--
-- Name: sys_countrys; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_countrys (
    sys_country_id character(2) NOT NULL,
    sys_continent_id character(2),
    sys_country_code character varying(3),
    sys_country_name character varying(120),
    sys_country_number character varying(3),
    sys_country_capital character varying(64),
    sys_phone_code character varying(7),
    sys_currency_name character varying(50),
    sys_currency_code character varying(3),
    sys_currency_cents character varying(50),
    sys_currency_exchange real
);


ALTER TABLE public.sys_countrys OWNER TO postgres;

--
-- Name: member_details_p; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.member_details_p AS
 SELECT orgs.org_id,
    orgs.org_name,
    sys_countrys.sys_country_name AS nationality,
    members.member_id,
    members.business_account,
    members.person_title,
    members.member_name,
    members.identification_number,
    members.identification_type,
    members.member_email,
    members.telephone_number,
    members.telephone_number2,
    members.address,
    members.town,
    members.zip_code,
    members.date_of_birth,
        CASE members.gender
            WHEN 'M'::text THEN 'Male'::text
            WHEN 'F'::text THEN 'Female'::text
            ELSE 'N/A'::text
        END AS gender,
        CASE members.marital_status
            WHEN 'M'::text THEN 'Married'::text
            WHEN 'S'::text THEN 'Single'::text
            WHEN 'D'::text THEN 'Divorced'::text
            WHEN 'W'::text THEN 'Widowed'::text
            WHEN 'X'::text THEN 'Separated'::text
            ELSE 'N/A'::text
        END AS marital_status,
    members.picture_file,
    members.employed,
    members.self_employed,
    members.employer_name,
    members.monthly_salary,
    members.monthly_net_income,
    members.annual_turnover,
    members.annual_net_income,
    members.employer_address,
    members.introduced_by,
    members.application_date,
    members.approve_status,
    members.workflow_table_id,
    members.action_date,
    members.details,
    entitys.entity_id,
    members.is_active,
    orgs.letter_head
   FROM (((public.members
     JOIN public.entitys ON ((members.member_id = entitys.member_id)))
     JOIN public.orgs ON ((members.org_id = orgs.org_id)))
     JOIN public.sys_countrys ON ((members.nationality = sys_countrys.sys_country_id)));


ALTER TABLE public.member_details_p OWNER TO postgres;

--
-- Name: member_imports; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.member_imports (
    member_import_id integer NOT NULL,
    org_id character varying(150),
    entity_id character varying(150),
    person_title character varying(150),
    member_name character varying(150),
    identification_number character varying(150),
    identification_type character varying(150),
    member_email character varying(150),
    telephone_number character varying(120),
    date_of_birth character varying(150),
    gender character varying(100),
    marital_status character varying(102),
    entry_date character varying(150),
    address character varying(150),
    zip_code character varying(150),
    town character varying(150)
);


ALTER TABLE public.member_imports OWNER TO postgres;

--
-- Name: member_imports_member_import_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.member_imports_member_import_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.member_imports_member_import_id_seq OWNER TO postgres;

--
-- Name: member_imports_member_import_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.member_imports_member_import_id_seq OWNED BY public.member_imports.member_import_id;


--
-- Name: members_member_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.members_member_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.members_member_id_seq OWNER TO postgres;

--
-- Name: members_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.members_member_id_seq OWNED BY public.members.member_id;


--
-- Name: mpesa_api; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mpesa_api (
    mpesa_api_id integer NOT NULL,
    org_id integer,
    transactiontype character varying(32),
    transid character varying(32),
    transtime character varying(16),
    transamount real,
    businessshortcode character varying(16),
    billrefnumber character varying(64),
    invoicenumber character varying(64),
    orgaccountbalance real,
    thirdpartytransid character varying(64),
    msisdn character varying(16),
    firstname character varying(64),
    middlename character varying(64),
    lastname character varying(64),
    transactiontime timestamp without time zone,
    created timestamp without time zone DEFAULT now() NOT NULL,
    narrative character varying(240),
    in_words character varying(320),
    is_picked boolean,
    picked_account character varying(64)
);


ALTER TABLE public.mpesa_api OWNER TO postgres;

--
-- Name: mpesa_api_mpesa_api_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mpesa_api_mpesa_api_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mpesa_api_mpesa_api_id_seq OWNER TO postgres;

--
-- Name: mpesa_api_mpesa_api_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mpesa_api_mpesa_api_id_seq OWNED BY public.mpesa_api.mpesa_api_id;


--
-- Name: mpesa_trxs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mpesa_trxs (
    mpesa_trx_id integer NOT NULL,
    org_id integer,
    mpesa_id integer,
    mpesa_orig character varying(50),
    mpesa_dest character varying(50),
    mpesa_tstamp timestamp without time zone,
    mpesa_text character varying(320),
    mpesa_code character varying(50),
    mpesa_acc character varying(50),
    mpesa_msisdn character varying(50),
    mpesa_trx_date date,
    mpesa_trx_time time without time zone,
    mpesa_amt real,
    mpesa_sender character varying(50),
    mpesa_pick_time timestamp without time zone DEFAULT now()
);


ALTER TABLE public.mpesa_trxs OWNER TO postgres;

--
-- Name: mpesa_trxs_mpesa_trx_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.mpesa_trxs_mpesa_trx_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.mpesa_trxs_mpesa_trx_id_seq OWNER TO postgres;

--
-- Name: mpesa_trxs_mpesa_trx_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.mpesa_trxs_mpesa_trx_id_seq OWNED BY public.mpesa_trxs.mpesa_trx_id;


--
-- Name: orgs_org_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.orgs_org_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.orgs_org_id_seq OWNER TO postgres;

--
-- Name: orgs_org_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.orgs_org_id_seq OWNED BY public.orgs.org_id;


--
-- Name: pc_allocations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pc_allocations (
    pc_allocation_id integer NOT NULL,
    period_id integer,
    department_id integer,
    entity_id integer,
    org_id integer,
    narrative character varying(320),
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.pc_allocations OWNER TO postgres;

--
-- Name: pc_allocations_pc_allocation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pc_allocations_pc_allocation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pc_allocations_pc_allocation_id_seq OWNER TO postgres;

--
-- Name: pc_allocations_pc_allocation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pc_allocations_pc_allocation_id_seq OWNED BY public.pc_allocations.pc_allocation_id;


--
-- Name: pc_banking; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pc_banking (
    pc_banking_id integer NOT NULL,
    pc_allocation_id integer,
    org_id integer,
    banking_date date NOT NULL,
    amount double precision NOT NULL,
    narrative character varying(320) NOT NULL,
    details text
);


ALTER TABLE public.pc_banking OWNER TO postgres;

--
-- Name: pc_banking_pc_banking_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pc_banking_pc_banking_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pc_banking_pc_banking_id_seq OWNER TO postgres;

--
-- Name: pc_banking_pc_banking_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pc_banking_pc_banking_id_seq OWNED BY public.pc_banking.pc_banking_id;


--
-- Name: pc_budget; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pc_budget (
    pc_budget_id integer NOT NULL,
    pc_allocation_id integer,
    pc_item_id integer,
    org_id integer,
    budget_units integer NOT NULL,
    budget_price double precision NOT NULL,
    details text
);


ALTER TABLE public.pc_budget OWNER TO postgres;

--
-- Name: pc_budget_pc_budget_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pc_budget_pc_budget_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pc_budget_pc_budget_id_seq OWNER TO postgres;

--
-- Name: pc_budget_pc_budget_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pc_budget_pc_budget_id_seq OWNED BY public.pc_budget.pc_budget_id;


--
-- Name: pc_category; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pc_category (
    pc_category_id integer NOT NULL,
    org_id integer,
    pc_category_name character varying(50) NOT NULL,
    details text
);


ALTER TABLE public.pc_category OWNER TO postgres;

--
-- Name: pc_category_pc_category_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pc_category_pc_category_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pc_category_pc_category_id_seq OWNER TO postgres;

--
-- Name: pc_category_pc_category_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pc_category_pc_category_id_seq OWNED BY public.pc_category.pc_category_id;


--
-- Name: pc_expenditure; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pc_expenditure (
    pc_expenditure_id integer NOT NULL,
    pc_allocation_id integer,
    pc_item_id integer,
    pc_type_id integer,
    entity_id integer,
    org_id integer,
    is_request boolean DEFAULT true NOT NULL,
    request_date timestamp without time zone DEFAULT now(),
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    units integer NOT NULL,
    unit_price double precision NOT NULL,
    receipt_number character varying(50),
    exp_date date,
    details text
);


ALTER TABLE public.pc_expenditure OWNER TO postgres;

--
-- Name: pc_expenditure_pc_expenditure_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pc_expenditure_pc_expenditure_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pc_expenditure_pc_expenditure_id_seq OWNER TO postgres;

--
-- Name: pc_expenditure_pc_expenditure_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pc_expenditure_pc_expenditure_id_seq OWNED BY public.pc_expenditure.pc_expenditure_id;


--
-- Name: pc_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pc_items (
    pc_item_id integer NOT NULL,
    pc_category_id integer,
    org_id integer,
    pc_item_name character varying(50) NOT NULL,
    default_price double precision NOT NULL,
    default_units integer NOT NULL,
    details text
);


ALTER TABLE public.pc_items OWNER TO postgres;

--
-- Name: pc_items_pc_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pc_items_pc_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pc_items_pc_item_id_seq OWNER TO postgres;

--
-- Name: pc_items_pc_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pc_items_pc_item_id_seq OWNED BY public.pc_items.pc_item_id;


--
-- Name: pc_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.pc_types (
    pc_type_id integer NOT NULL,
    org_id integer,
    pc_type_name character varying(50) NOT NULL,
    details text
);


ALTER TABLE public.pc_types OWNER TO postgres;

--
-- Name: pc_types_pc_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.pc_types_pc_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.pc_types_pc_type_id_seq OWNER TO postgres;

--
-- Name: pc_types_pc_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.pc_types_pc_type_id_seq OWNED BY public.pc_types.pc_type_id;


--
-- Name: penalty_methods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.penalty_methods (
    penalty_method_id integer NOT NULL,
    activity_type_id integer NOT NULL,
    org_id integer,
    penalty_method_name character varying(120) NOT NULL,
    formural character varying(320),
    account_number character varying(32),
    penalty_method_no integer,
    details text
);


ALTER TABLE public.penalty_methods OWNER TO postgres;

--
-- Name: penalty_methods_penalty_method_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.penalty_methods_penalty_method_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.penalty_methods_penalty_method_id_seq OWNER TO postgres;

--
-- Name: penalty_methods_penalty_method_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.penalty_methods_penalty_method_id_seq OWNED BY public.penalty_methods.penalty_method_id;


--
-- Name: period_tax_rates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.period_tax_rates (
    period_tax_rate_id integer NOT NULL,
    period_tax_type_id integer,
    tax_rate_id integer,
    org_id integer,
    tax_range double precision NOT NULL,
    tax_rate double precision NOT NULL,
    employer_rate integer DEFAULT 0 NOT NULL,
    rate_relief real DEFAULT 0 NOT NULL,
    narrative character varying(240)
);


ALTER TABLE public.period_tax_rates OWNER TO postgres;

--
-- Name: period_tax_rates_period_tax_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.period_tax_rates_period_tax_rate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.period_tax_rates_period_tax_rate_id_seq OWNER TO postgres;

--
-- Name: period_tax_rates_period_tax_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.period_tax_rates_period_tax_rate_id_seq OWNED BY public.period_tax_rates.period_tax_rate_id;


--
-- Name: period_tax_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.period_tax_types (
    period_tax_type_id integer NOT NULL,
    period_id integer,
    tax_type_id integer,
    account_id integer,
    org_id integer,
    period_tax_type_name character varying(50) NOT NULL,
    pay_date date DEFAULT ('now'::text)::date NOT NULL,
    formural character varying(320),
    tax_relief real DEFAULT 0 NOT NULL,
    employer_relief real DEFAULT 0 NOT NULL,
    tax_type_order integer DEFAULT 0 NOT NULL,
    in_tax boolean DEFAULT false NOT NULL,
    tax_rate real DEFAULT 0 NOT NULL,
    tax_inclusive boolean DEFAULT false NOT NULL,
    linear boolean DEFAULT true,
    percentage boolean DEFAULT true,
    account_number character varying(32),
    limit_employee real,
    employer double precision DEFAULT 0 NOT NULL,
    employer_ps double precision DEFAULT 0 NOT NULL,
    employer_formural character varying(320),
    employer_account character varying(32),
    limit_employer real,
    details text
);


ALTER TABLE public.period_tax_types OWNER TO postgres;

--
-- Name: period_tax_types_period_tax_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.period_tax_types_period_tax_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.period_tax_types_period_tax_type_id_seq OWNER TO postgres;

--
-- Name: period_tax_types_period_tax_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.period_tax_types_period_tax_type_id_seq OWNED BY public.period_tax_types.period_tax_type_id;


--
-- Name: periods; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.periods (
    period_id integer NOT NULL,
    fiscal_year_id integer,
    org_id integer,
    start_date date NOT NULL,
    end_date date NOT NULL,
    opened boolean DEFAULT false NOT NULL,
    activated boolean DEFAULT false NOT NULL,
    closed boolean DEFAULT false NOT NULL,
    overtime_rate double precision DEFAULT 1 NOT NULL,
    per_diem_tax_limit double precision DEFAULT 2000 NOT NULL,
    is_posted boolean DEFAULT false NOT NULL,
    loan_approval boolean DEFAULT false NOT NULL,
    gl_payroll_account character varying(32),
    gl_advance_account character varying(32),
    entity_id integer,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.periods OWNER TO postgres;

--
-- Name: periods_period_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.periods_period_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.periods_period_id_seq OWNER TO postgres;

--
-- Name: periods_period_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.periods_period_id_seq OWNED BY public.periods.period_id;


--
-- Name: phases; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.phases (
    phase_id integer NOT NULL,
    investment_id integer,
    org_id integer,
    phase_name character varying(240) NOT NULL,
    start_date date NOT NULL,
    end_date date,
    completed boolean DEFAULT false NOT NULL,
    phase_cost real DEFAULT 0 NOT NULL,
    details text
);


ALTER TABLE public.phases OWNER TO postgres;

--
-- Name: phases_phase_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.phases_phase_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.phases_phase_id_seq OWNER TO postgres;

--
-- Name: phases_phase_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.phases_phase_id_seq OWNED BY public.phases.phase_id;


--
-- Name: picture_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.picture_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.picture_id_seq OWNER TO postgres;

--
-- Name: position_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.position_levels (
    position_level_id integer NOT NULL,
    org_id integer,
    position_level_name character varying(150) NOT NULL,
    narrative character varying(225),
    details text
);


ALTER TABLE public.position_levels OWNER TO postgres;

--
-- Name: position_levels_position_level_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.position_levels_position_level_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.position_levels_position_level_id_seq OWNER TO postgres;

--
-- Name: position_levels_position_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.position_levels_position_level_id_seq OWNED BY public.position_levels.position_level_id;


--
-- Name: products; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.products (
    product_id integer NOT NULL,
    interest_method_id integer,
    penalty_method_id integer,
    activity_frequency_id integer,
    currency_id integer,
    entity_id integer,
    org_id integer,
    product_name character varying(120) NOT NULL,
    description character varying(320),
    loan_account boolean DEFAULT true NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    interest_rate real NOT NULL,
    min_opening_balance real DEFAULT 0 NOT NULL,
    lockin_period_frequency real,
    minimum_balance real,
    maximum_balance real,
    minimum_day real,
    maximum_day real,
    minimum_trx real,
    maximum_trx real,
    maximum_repayments integer DEFAULT 100 NOT NULL,
    less_initial_fee boolean DEFAULT false NOT NULL,
    product_no integer,
    application_date timestamp without time zone DEFAULT now() NOT NULL,
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.products OWNER TO postgres;

--
-- Name: products_product_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.products_product_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.products_product_id_seq OWNER TO postgres;

--
-- Name: products_product_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.products_product_id_seq OWNED BY public.products.product_id;


--
-- Name: quotations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.quotations (
    quotation_id integer NOT NULL,
    org_id integer,
    item_id integer,
    entity_id integer,
    active boolean DEFAULT false NOT NULL,
    amount real,
    valid_from date,
    valid_to date,
    lead_time integer,
    details text
);


ALTER TABLE public.quotations OWNER TO postgres;

--
-- Name: quotations_quotation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.quotations_quotation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.quotations_quotation_id_seq OWNER TO postgres;

--
-- Name: quotations_quotation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.quotations_quotation_id_seq OWNED BY public.quotations.quotation_id;


--
-- Name: reporting; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.reporting (
    reporting_id integer NOT NULL,
    entity_id integer,
    report_to_id integer,
    org_id integer,
    date_from date,
    date_to date,
    reporting_level integer DEFAULT 1 NOT NULL,
    primary_report boolean DEFAULT true NOT NULL,
    is_active boolean DEFAULT true NOT NULL,
    ps_reporting real,
    details text
);


ALTER TABLE public.reporting OWNER TO postgres;

--
-- Name: reporting_reporting_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.reporting_reporting_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.reporting_reporting_id_seq OWNER TO postgres;

--
-- Name: reporting_reporting_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.reporting_reporting_id_seq OWNED BY public.reporting.reporting_id;


--
-- Name: sacco_officials; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sacco_officials (
    sacco_official_id integer NOT NULL,
    position_level_id integer,
    org_id integer,
    member_id integer,
    start_date date NOT NULL,
    end_date date,
    term_limit integer,
    is_active boolean DEFAULT true NOT NULL,
    narrative character varying(225),
    details text
);


ALTER TABLE public.sacco_officials OWNER TO postgres;

--
-- Name: sacco_officials_sacco_official_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sacco_officials_sacco_official_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sacco_officials_sacco_official_id_seq OWNER TO postgres;

--
-- Name: sacco_officials_sacco_official_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sacco_officials_sacco_official_id_seq OWNED BY public.sacco_officials.sacco_official_id;


--
-- Name: sms; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sms (
    sms_id integer NOT NULL,
    entity_id integer,
    member_id integer,
    folder_id integer,
    org_id integer,
    sms_number character varying(25),
    sms_time timestamp without time zone DEFAULT now(),
    sent boolean DEFAULT false NOT NULL,
    is_groupsms boolean DEFAULT false NOT NULL,
    message text,
    details text,
    sms_group_id integer
);


ALTER TABLE public.sms OWNER TO postgres;

--
-- Name: sms_configs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sms_configs (
    sms_config_id integer NOT NULL,
    org_id integer,
    use_key_id integer,
    sms_config_name character varying(120),
    is_active boolean DEFAULT false NOT NULL,
    sms_template text,
    details text
);


ALTER TABLE public.sms_configs OWNER TO postgres;

--
-- Name: sms_configs_sms_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sms_configs_sms_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_configs_sms_config_id_seq OWNER TO postgres;

--
-- Name: sms_configs_sms_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sms_configs_sms_config_id_seq OWNED BY public.sms_configs.sms_config_id;


--
-- Name: sms_group; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sms_group (
    sms_group_id integer NOT NULL,
    org_id integer,
    sms_group_name character varying(120),
    details text
);


ALTER TABLE public.sms_group OWNER TO postgres;

--
-- Name: sms_group_members; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sms_group_members (
    sms_group_member_id integer NOT NULL,
    sms_group_id integer,
    org_id integer,
    member_id integer,
    narrative character varying(120),
    details text
);


ALTER TABLE public.sms_group_members OWNER TO postgres;

--
-- Name: sms_group_members_sms_group_member_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sms_group_members_sms_group_member_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_group_members_sms_group_member_id_seq OWNER TO postgres;

--
-- Name: sms_group_members_sms_group_member_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sms_group_members_sms_group_member_id_seq OWNED BY public.sms_group_members.sms_group_member_id;


--
-- Name: sms_group_sms_group_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sms_group_sms_group_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_group_sms_group_id_seq OWNER TO postgres;

--
-- Name: sms_group_sms_group_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sms_group_sms_group_id_seq OWNED BY public.sms_group.sms_group_id;


--
-- Name: sms_sms_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sms_sms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sms_sms_id_seq OWNER TO postgres;

--
-- Name: sms_sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sms_sms_id_seq OWNED BY public.sms.sms_id;


--
-- Name: ss_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ss_items (
    ss_item_id integer NOT NULL,
    ss_type_id integer,
    org_id integer,
    ss_item_name character varying(120),
    picture character varying(120),
    description text,
    purchase_date date NOT NULL,
    purchase_price real DEFAULT 0 NOT NULL,
    sale_date date,
    sale_price real DEFAULT 0 NOT NULL,
    sold boolean DEFAULT false NOT NULL,
    details text
);


ALTER TABLE public.ss_items OWNER TO postgres;

--
-- Name: ss_items_ss_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ss_items_ss_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ss_items_ss_item_id_seq OWNER TO postgres;

--
-- Name: ss_items_ss_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ss_items_ss_item_id_seq OWNED BY public.ss_items.ss_item_id;


--
-- Name: ss_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ss_types (
    ss_type_id integer NOT NULL,
    org_id integer,
    ss_type_name character varying(120),
    details text
);


ALTER TABLE public.ss_types OWNER TO postgres;

--
-- Name: ss_types_ss_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.ss_types_ss_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.ss_types_ss_type_id_seq OWNER TO postgres;

--
-- Name: ss_types_ss_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.ss_types_ss_type_id_seq OWNED BY public.ss_types.ss_type_id;


--
-- Name: stock_lines; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stock_lines (
    stock_line_id integer NOT NULL,
    org_id integer,
    stock_id integer,
    item_id integer,
    quantity integer,
    narrative character varying(240)
);


ALTER TABLE public.stock_lines OWNER TO postgres;

--
-- Name: stock_lines_stock_line_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stock_lines_stock_line_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stock_lines_stock_line_id_seq OWNER TO postgres;

--
-- Name: stock_lines_stock_line_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stock_lines_stock_line_id_seq OWNED BY public.stock_lines.stock_line_id;


--
-- Name: stocks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stocks (
    stock_id integer NOT NULL,
    org_id integer,
    store_id integer,
    stock_name character varying(50),
    stock_take_date date,
    details text
);


ALTER TABLE public.stocks OWNER TO postgres;

--
-- Name: stocks_stock_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stocks_stock_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stocks_stock_id_seq OWNER TO postgres;

--
-- Name: stocks_stock_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stocks_stock_id_seq OWNED BY public.stocks.stock_id;


--
-- Name: store_movement; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.store_movement (
    store_movement_id integer NOT NULL,
    store_id integer,
    store_to_id integer,
    item_id integer,
    org_id integer,
    movement_date date NOT NULL,
    quantity integer NOT NULL,
    narrative character varying(240)
);


ALTER TABLE public.store_movement OWNER TO postgres;

--
-- Name: store_movement_store_movement_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.store_movement_store_movement_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.store_movement_store_movement_id_seq OWNER TO postgres;

--
-- Name: store_movement_store_movement_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.store_movement_store_movement_id_seq OWNED BY public.store_movement.store_movement_id;


--
-- Name: stores; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stores (
    store_id integer NOT NULL,
    org_id integer,
    store_name character varying(120),
    details text
);


ALTER TABLE public.stores OWNER TO postgres;

--
-- Name: stores_store_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.stores_store_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.stores_store_id_seq OWNER TO postgres;

--
-- Name: stores_store_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.stores_store_id_seq OWNED BY public.stores.store_id;


--
-- Name: sub_fields; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sub_fields (
    sub_field_id integer NOT NULL,
    org_id integer,
    field_id integer,
    sub_field_order integer NOT NULL,
    sub_title_share character varying(120),
    sub_field_type character varying(25),
    sub_field_lookup text,
    sub_field_size integer NOT NULL,
    sub_col_spans integer DEFAULT 1 NOT NULL,
    manditory character(1) DEFAULT '0'::bpchar NOT NULL,
    show character(1) DEFAULT '1'::bpchar,
    question text
);


ALTER TABLE public.sub_fields OWNER TO postgres;

--
-- Name: sub_fields_sub_field_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sub_fields_sub_field_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sub_fields_sub_field_id_seq OWNER TO postgres;

--
-- Name: sub_fields_sub_field_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sub_fields_sub_field_id_seq OWNED BY public.sub_fields.sub_field_id;


--
-- Name: subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.subscriptions (
    subscription_id integer NOT NULL,
    entity_id integer,
    org_id integer,
    business_name character varying(50),
    business_address character varying(100),
    city character varying(30),
    number_of_members double precision NOT NULL,
    country_id character(2),
    telephone character varying(50),
    website character varying(120),
    primary_contact character varying(120),
    job_title character varying(120),
    primary_email character varying(120),
    confirm_email character varying(120),
    system_key character varying(64),
    subscribed boolean,
    subscribed_date timestamp without time zone,
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    application_date timestamp without time zone DEFAULT now(),
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.subscriptions OWNER TO postgres;

--
-- Name: subscriptions_subscription_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.subscriptions_subscription_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.subscriptions_subscription_id_seq OWNER TO postgres;

--
-- Name: subscriptions_subscription_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.subscriptions_subscription_id_seq OWNED BY public.subscriptions.subscription_id;


--
-- Name: sys_access_entitys; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_access_entitys (
    sys_access_entity_id integer NOT NULL,
    sys_access_level_id integer NOT NULL,
    entity_id integer NOT NULL,
    org_id integer,
    narrative character varying(320)
);


ALTER TABLE public.sys_access_entitys OWNER TO postgres;

--
-- Name: sys_access_entitys_sys_access_entity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_access_entitys_sys_access_entity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_access_entitys_sys_access_entity_id_seq OWNER TO postgres;

--
-- Name: sys_access_entitys_sys_access_entity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_access_entitys_sys_access_entity_id_seq OWNED BY public.sys_access_entitys.sys_access_entity_id;


--
-- Name: sys_access_levels; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_access_levels (
    sys_access_level_id integer NOT NULL,
    use_key_id integer,
    sys_country_id character(2),
    org_id integer,
    sys_access_level_name character varying(64) NOT NULL,
    access_tag character varying(32) NOT NULL,
    acess_details text
);


ALTER TABLE public.sys_access_levels OWNER TO postgres;

--
-- Name: sys_access_levels_sys_access_level_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_access_levels_sys_access_level_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_access_levels_sys_access_level_id_seq OWNER TO postgres;

--
-- Name: sys_access_levels_sys_access_level_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_access_levels_sys_access_level_id_seq OWNED BY public.sys_access_levels.sys_access_level_id;


--
-- Name: sys_audit_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_audit_details (
    sys_audit_trail_id integer NOT NULL,
    old_value text
);


ALTER TABLE public.sys_audit_details OWNER TO postgres;

--
-- Name: sys_audit_trail; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_audit_trail (
    sys_audit_trail_id integer NOT NULL,
    user_id character varying(50) NOT NULL,
    user_ip character varying(50),
    change_date timestamp without time zone DEFAULT now() NOT NULL,
    table_name character varying(50) NOT NULL,
    record_id character varying(50) NOT NULL,
    change_type character varying(50) NOT NULL,
    narrative character varying(240)
);


ALTER TABLE public.sys_audit_trail OWNER TO postgres;

--
-- Name: sys_audit_trail_sys_audit_trail_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_audit_trail_sys_audit_trail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_audit_trail_sys_audit_trail_id_seq OWNER TO postgres;

--
-- Name: sys_audit_trail_sys_audit_trail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_audit_trail_sys_audit_trail_id_seq OWNED BY public.sys_audit_trail.sys_audit_trail_id;


--
-- Name: sys_configs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_configs (
    sys_config_id integer NOT NULL,
    config_type_id integer NOT NULL,
    config_name character varying(254) NOT NULL,
    config_value text NOT NULL
);


ALTER TABLE public.sys_configs OWNER TO postgres;

--
-- Name: sys_configs_sys_config_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_configs_sys_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_configs_sys_config_id_seq OWNER TO postgres;

--
-- Name: sys_configs_sys_config_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_configs_sys_config_id_seq OWNED BY public.sys_configs.sys_config_id;


--
-- Name: sys_continents; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_continents (
    sys_continent_id character(2) NOT NULL,
    sys_continent_name character varying(120)
);


ALTER TABLE public.sys_continents OWNER TO postgres;

--
-- Name: sys_dashboard; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_dashboard (
    sys_dashboard_id integer NOT NULL,
    entity_id integer,
    org_id integer,
    narrative character varying(240),
    details text
);


ALTER TABLE public.sys_dashboard OWNER TO postgres;

--
-- Name: sys_dashboard_sys_dashboard_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_dashboard_sys_dashboard_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_dashboard_sys_dashboard_id_seq OWNER TO postgres;

--
-- Name: sys_dashboard_sys_dashboard_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_dashboard_sys_dashboard_id_seq OWNED BY public.sys_dashboard.sys_dashboard_id;


--
-- Name: sys_emailed; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_emailed (
    sys_emailed_id integer NOT NULL,
    sys_email_id integer,
    org_id integer,
    table_id integer,
    table_name character varying(50),
    email_type integer DEFAULT 1 NOT NULL,
    emailed boolean DEFAULT false NOT NULL,
    created timestamp without time zone DEFAULT now() NOT NULL,
    narrative character varying(240),
    mail_body text
);


ALTER TABLE public.sys_emailed OWNER TO postgres;

--
-- Name: sys_emailed_sys_emailed_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_emailed_sys_emailed_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_emailed_sys_emailed_id_seq OWNER TO postgres;

--
-- Name: sys_emailed_sys_emailed_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_emailed_sys_emailed_id_seq OWNED BY public.sys_emailed.sys_emailed_id;


--
-- Name: sys_emails; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_emails (
    sys_email_id integer NOT NULL,
    org_id integer,
    use_type integer DEFAULT 1 NOT NULL,
    sys_email_name character varying(50),
    default_email character varying(320),
    title character varying(240) NOT NULL,
    details text
);


ALTER TABLE public.sys_emails OWNER TO postgres;

--
-- Name: sys_emails_sys_email_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_emails_sys_email_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_emails_sys_email_id_seq OWNER TO postgres;

--
-- Name: sys_emails_sys_email_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_emails_sys_email_id_seq OWNED BY public.sys_emails.sys_email_id;


--
-- Name: sys_errors; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_errors (
    sys_error_id integer NOT NULL,
    sys_error character varying(240) NOT NULL,
    error_message text NOT NULL
);


ALTER TABLE public.sys_errors OWNER TO postgres;

--
-- Name: sys_errors_sys_error_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_errors_sys_error_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_errors_sys_error_id_seq OWNER TO postgres;

--
-- Name: sys_errors_sys_error_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_errors_sys_error_id_seq OWNED BY public.sys_errors.sys_error_id;


--
-- Name: sys_files; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_files (
    sys_file_id integer NOT NULL,
    org_id integer,
    table_id integer,
    table_name character varying(50),
    file_name character varying(320),
    file_type character varying(320),
    file_size integer,
    narrative character varying(320),
    details text
);


ALTER TABLE public.sys_files OWNER TO postgres;

--
-- Name: sys_files_sys_file_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_files_sys_file_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_files_sys_file_id_seq OWNER TO postgres;

--
-- Name: sys_files_sys_file_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_files_sys_file_id_seq OWNED BY public.sys_files.sys_file_id;


--
-- Name: sys_languages; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_languages (
    sys_language_id integer NOT NULL,
    sys_language_name character varying(50) NOT NULL
);


ALTER TABLE public.sys_languages OWNER TO postgres;

--
-- Name: sys_languages_sys_language_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_languages_sys_language_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_languages_sys_language_id_seq OWNER TO postgres;

--
-- Name: sys_languages_sys_language_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_languages_sys_language_id_seq OWNED BY public.sys_languages.sys_language_id;


--
-- Name: sys_logins; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_logins (
    sys_login_id integer NOT NULL,
    entity_id integer,
    login_time timestamp without time zone DEFAULT now(),
    login_ip character varying(64),
    narrative character varying(240)
);


ALTER TABLE public.sys_logins OWNER TO postgres;

--
-- Name: sys_logins_sys_login_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_logins_sys_login_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_logins_sys_login_id_seq OWNER TO postgres;

--
-- Name: sys_logins_sys_login_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_logins_sys_login_id_seq OWNED BY public.sys_logins.sys_login_id;


--
-- Name: sys_menu_msg; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_menu_msg (
    sys_menu_msg_id integer NOT NULL,
    menu_id character varying(16) NOT NULL,
    menu_name character varying(50) NOT NULL,
    xml_file character varying(50) NOT NULL,
    msg text
);


ALTER TABLE public.sys_menu_msg OWNER TO postgres;

--
-- Name: sys_menu_msg_sys_menu_msg_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_menu_msg_sys_menu_msg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_menu_msg_sys_menu_msg_id_seq OWNER TO postgres;

--
-- Name: sys_menu_msg_sys_menu_msg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_menu_msg_sys_menu_msg_id_seq OWNED BY public.sys_menu_msg.sys_menu_msg_id;


--
-- Name: sys_news; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_news (
    sys_news_id integer NOT NULL,
    org_id integer,
    sys_news_group integer,
    sys_news_title character varying(240) NOT NULL,
    publish boolean DEFAULT false NOT NULL,
    details text
);


ALTER TABLE public.sys_news OWNER TO postgres;

--
-- Name: sys_news_sys_news_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_news_sys_news_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_news_sys_news_id_seq OWNER TO postgres;

--
-- Name: sys_news_sys_news_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_news_sys_news_id_seq OWNED BY public.sys_news.sys_news_id;


--
-- Name: sys_queries; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_queries (
    sys_queries_id integer NOT NULL,
    org_id integer,
    sys_query_name character varying(50),
    query_date timestamp without time zone DEFAULT now() NOT NULL,
    query_text text,
    query_params text
);


ALTER TABLE public.sys_queries OWNER TO postgres;

--
-- Name: sys_queries_sys_queries_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_queries_sys_queries_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_queries_sys_queries_id_seq OWNER TO postgres;

--
-- Name: sys_queries_sys_queries_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_queries_sys_queries_id_seq OWNED BY public.sys_queries.sys_queries_id;


--
-- Name: sys_reset; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_reset (
    sys_reset_id integer NOT NULL,
    entity_id integer,
    org_id integer,
    request_email character varying(320),
    request_time timestamp without time zone DEFAULT now(),
    login_ip character varying(64),
    narrative character varying(240)
);


ALTER TABLE public.sys_reset OWNER TO postgres;

--
-- Name: sys_reset_sys_reset_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_reset_sys_reset_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_reset_sys_reset_id_seq OWNER TO postgres;

--
-- Name: sys_reset_sys_reset_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_reset_sys_reset_id_seq OWNED BY public.sys_reset.sys_reset_id;


--
-- Name: sys_translations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sys_translations (
    sys_translation_id integer NOT NULL,
    sys_language_id integer,
    org_id integer,
    reference character varying(64) NOT NULL,
    title character varying(320) NOT NULL
);


ALTER TABLE public.sys_translations OWNER TO postgres;

--
-- Name: sys_translations_sys_translation_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.sys_translations_sys_translation_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.sys_translations_sys_translation_id_seq OWNER TO postgres;

--
-- Name: sys_translations_sys_translation_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.sys_translations_sys_translation_id_seq OWNED BY public.sys_translations.sys_translation_id;


--
-- Name: tasks; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tasks (
    task_id integer NOT NULL,
    phase_id integer,
    member_id integer,
    org_id integer,
    task_name character varying(320) NOT NULL,
    task_start date NOT NULL,
    task_deadline date,
    task_end date,
    task_cost real DEFAULT 0 NOT NULL,
    task_completed boolean DEFAULT false NOT NULL,
    details text
);


ALTER TABLE public.tasks OWNER TO postgres;

--
-- Name: tasks_task_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tasks_task_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tasks_task_id_seq OWNER TO postgres;

--
-- Name: tasks_task_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tasks_task_id_seq OWNED BY public.tasks.task_id;


--
-- Name: tax_rates; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tax_rates (
    tax_rate_id integer NOT NULL,
    tax_type_id integer,
    org_id integer,
    tax_range double precision NOT NULL,
    tax_rate double precision NOT NULL,
    employer_rate integer DEFAULT 0 NOT NULL,
    rate_relief real DEFAULT 0 NOT NULL,
    narrative character varying(240)
);


ALTER TABLE public.tax_rates OWNER TO postgres;

--
-- Name: tax_rates_tax_rate_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tax_rates_tax_rate_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tax_rates_tax_rate_id_seq OWNER TO postgres;

--
-- Name: tax_rates_tax_rate_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tax_rates_tax_rate_id_seq OWNED BY public.tax_rates.tax_rate_id;


--
-- Name: tax_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tax_types (
    tax_type_id integer NOT NULL,
    account_id integer,
    currency_id integer,
    use_key_id integer NOT NULL,
    sys_country_id character(2),
    org_id integer,
    tax_type_name character varying(50) NOT NULL,
    tax_type_number character varying(50),
    formural character varying(320),
    tax_relief real DEFAULT 0 NOT NULL,
    employer_relief real DEFAULT 0 NOT NULL,
    tax_type_order integer DEFAULT 0 NOT NULL,
    in_tax boolean DEFAULT false NOT NULL,
    tax_rate real DEFAULT 0 NOT NULL,
    tax_inclusive boolean DEFAULT false NOT NULL,
    linear boolean DEFAULT true,
    percentage boolean DEFAULT true,
    account_number character varying(32),
    limit_employee real,
    employer double precision DEFAULT 0 NOT NULL,
    employer_ps double precision DEFAULT 0 NOT NULL,
    employer_formural character varying(320),
    employer_account character varying(32),
    limit_employer real,
    active boolean DEFAULT true NOT NULL,
    details text
);


ALTER TABLE public.tax_types OWNER TO postgres;

--
-- Name: tax_types_tax_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tax_types_tax_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tax_types_tax_type_id_seq OWNER TO postgres;

--
-- Name: tax_types_tax_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tax_types_tax_type_id_seq OWNED BY public.tax_types.tax_type_id;


--
-- Name: tender_items; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tender_items (
    tender_item_id integer NOT NULL,
    bidder_id integer,
    org_id integer,
    tender_item_name character varying(320) NOT NULL,
    quantity integer,
    item_amount real,
    item_tax real,
    details text
);


ALTER TABLE public.tender_items OWNER TO postgres;

--
-- Name: tender_items_tender_item_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tender_items_tender_item_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tender_items_tender_item_id_seq OWNER TO postgres;

--
-- Name: tender_items_tender_item_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tender_items_tender_item_id_seq OWNED BY public.tender_items.tender_item_id;


--
-- Name: tender_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tender_types (
    tender_type_id integer NOT NULL,
    org_id integer,
    tender_type_name character varying(50) NOT NULL,
    details text
);


ALTER TABLE public.tender_types OWNER TO postgres;

--
-- Name: tender_types_tender_type_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tender_types_tender_type_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tender_types_tender_type_id_seq OWNER TO postgres;

--
-- Name: tender_types_tender_type_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tender_types_tender_type_id_seq OWNED BY public.tender_types.tender_type_id;


--
-- Name: tenders; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tenders (
    tender_id integer NOT NULL,
    tender_type_id integer,
    currency_id integer,
    org_id integer,
    tender_name character varying(320) NOT NULL,
    tender_number character varying(64),
    tender_date date NOT NULL,
    tender_end_date date,
    is_completed boolean DEFAULT false NOT NULL,
    details text
);


ALTER TABLE public.tenders OWNER TO postgres;

--
-- Name: tenders_tender_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tenders_tender_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tenders_tender_id_seq OWNER TO postgres;

--
-- Name: tenders_tender_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tenders_tender_id_seq OWNED BY public.tenders.tender_id;


--
-- Name: tmp1; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tmp1 (
    account_activity_id integer,
    deposit_account_id integer,
    transfer_account_id integer,
    activity_type_id integer,
    activity_frequency_id integer,
    activity_status_id integer,
    period_id integer,
    entity_id integer,
    org_id integer,
    link_activity_id integer,
    transfer_link_id integer,
    deposit_account_no character varying(32),
    transfer_account_no character varying(32),
    activity_date date,
    value_date date,
    account_credit real,
    account_debit real,
    balance real,
    exchange_rate real,
    application_date timestamp without time zone,
    approve_status character varying(16),
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text,
    loan_id integer,
    transfer_loan_id integer
);


ALTER TABLE public.tmp1 OWNER TO postgres;

--
-- Name: tomcat_users; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.tomcat_users AS
 SELECT entitys.user_name,
    entitys.entity_password,
    entity_types.entity_role
   FROM ((public.entity_subscriptions
     JOIN public.entitys ON ((entity_subscriptions.entity_id = entitys.entity_id)))
     JOIN public.entity_types ON ((entity_subscriptions.entity_type_id = entity_types.entity_type_id)))
  WHERE (entitys.is_active = true);


ALTER TABLE public.tomcat_users OWNER TO postgres;

--
-- Name: transaction_counters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transaction_counters (
    transaction_counter_id integer NOT NULL,
    transaction_type_id integer,
    org_id integer,
    document_number integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.transaction_counters OWNER TO postgres;

--
-- Name: transaction_counters_transaction_counter_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transaction_counters_transaction_counter_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transaction_counters_transaction_counter_id_seq OWNER TO postgres;

--
-- Name: transaction_counters_transaction_counter_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transaction_counters_transaction_counter_id_seq OWNED BY public.transaction_counters.transaction_counter_id;


--
-- Name: transaction_details; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transaction_details (
    transaction_detail_id integer NOT NULL,
    transaction_id integer,
    account_id integer,
    item_id integer,
    store_id integer,
    org_id integer,
    quantity integer NOT NULL,
    amount real DEFAULT 0 NOT NULL,
    tax_amount real DEFAULT 0 NOT NULL,
    discount real DEFAULT 0 NOT NULL,
    narrative character varying(240),
    purpose character varying(320),
    details text,
    CONSTRAINT transaction_details_discount_check CHECK (((discount >= (0)::double precision) AND (discount <= (100)::double precision)))
);


ALTER TABLE public.transaction_details OWNER TO postgres;

--
-- Name: transaction_details_transaction_detail_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transaction_details_transaction_detail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transaction_details_transaction_detail_id_seq OWNER TO postgres;

--
-- Name: transaction_details_transaction_detail_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transaction_details_transaction_detail_id_seq OWNED BY public.transaction_details.transaction_detail_id;


--
-- Name: transaction_links; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transaction_links (
    transaction_link_id integer NOT NULL,
    org_id integer,
    transaction_id integer,
    transaction_to integer,
    transaction_detail_id integer,
    transaction_detail_to integer,
    amount real DEFAULT 0 NOT NULL,
    quantity integer DEFAULT 0 NOT NULL,
    narrative character varying(240)
);


ALTER TABLE public.transaction_links OWNER TO postgres;

--
-- Name: transaction_links_transaction_link_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transaction_links_transaction_link_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transaction_links_transaction_link_id_seq OWNER TO postgres;

--
-- Name: transaction_links_transaction_link_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transaction_links_transaction_link_id_seq OWNED BY public.transaction_links.transaction_link_id;


--
-- Name: transaction_status; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transaction_status (
    transaction_status_id integer NOT NULL,
    transaction_status_name character varying(50) NOT NULL
);


ALTER TABLE public.transaction_status OWNER TO postgres;

--
-- Name: transaction_types; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transaction_types (
    transaction_type_id integer NOT NULL,
    transaction_type_name character varying(50) NOT NULL,
    document_prefix character varying(16) DEFAULT 'D'::character varying NOT NULL,
    for_sales boolean DEFAULT true NOT NULL,
    for_posting boolean DEFAULT true NOT NULL
);


ALTER TABLE public.transaction_types OWNER TO postgres;

--
-- Name: transactions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transactions (
    transaction_id integer NOT NULL,
    entity_id integer,
    transaction_type_id integer,
    ledger_type_id integer,
    transaction_status_id integer DEFAULT 1,
    bank_account_id integer,
    journal_id integer,
    currency_id integer,
    department_id integer,
    entered_by integer,
    org_id integer,
    exchange_rate real DEFAULT 1 NOT NULL,
    transaction_date date NOT NULL,
    payment_date date NOT NULL,
    transaction_amount real DEFAULT 0 NOT NULL,
    transaction_tax_amount real DEFAULT 0 NOT NULL,
    document_number integer DEFAULT 1 NOT NULL,
    tx_type integer,
    for_processing boolean DEFAULT false NOT NULL,
    is_cleared boolean DEFAULT false NOT NULL,
    completed boolean DEFAULT false NOT NULL,
    reference_number character varying(50),
    payment_number character varying(50),
    order_number character varying(50),
    payment_terms character varying(50),
    job character varying(240),
    point_of_use character varying(240),
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    narrative character varying(120),
    notes text,
    details text,
    investment_id integer
);


ALTER TABLE public.transactions OWNER TO postgres;

--
-- Name: transactions_transaction_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transactions_transaction_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transactions_transaction_id_seq OWNER TO postgres;

--
-- Name: transactions_transaction_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transactions_transaction_id_seq OWNED BY public.transactions.transaction_id;


--
-- Name: transfer_activity; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transfer_activity (
    transfer_activity_id integer NOT NULL,
    transfer_beneficiary_id integer,
    deposit_account_id integer,
    activity_type_id integer,
    activity_frequency_id integer,
    entity_id integer,
    account_activity_id integer,
    org_id integer,
    transfer_amount real NOT NULL,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.transfer_activity OWNER TO postgres;

--
-- Name: transfer_activity_transfer_activity_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transfer_activity_transfer_activity_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transfer_activity_transfer_activity_id_seq OWNER TO postgres;

--
-- Name: transfer_activity_transfer_activity_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transfer_activity_transfer_activity_id_seq OWNED BY public.transfer_activity.transfer_activity_id;


--
-- Name: transfer_beneficiary; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.transfer_beneficiary (
    transfer_beneficiary_id integer NOT NULL,
    member_id integer,
    deposit_account_id integer,
    entity_id integer,
    org_id integer,
    beneficiary_name character varying(150) NOT NULL,
    account_number character varying(32) NOT NULL,
    allow_transfer boolean DEFAULT true NOT NULL,
    application_date timestamp without time zone DEFAULT now(),
    approve_status character varying(16) DEFAULT 'Draft'::character varying NOT NULL,
    workflow_table_id integer,
    action_date timestamp without time zone,
    details text
);


ALTER TABLE public.transfer_beneficiary OWNER TO postgres;

--
-- Name: transfer_beneficiary_transfer_beneficiary_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.transfer_beneficiary_transfer_beneficiary_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.transfer_beneficiary_transfer_beneficiary_id_seq OWNER TO postgres;

--
-- Name: transfer_beneficiary_transfer_beneficiary_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.transfer_beneficiary_transfer_beneficiary_id_seq OWNED BY public.transfer_beneficiary.transfer_beneficiary_id;


--
-- Name: use_keys; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.use_keys (
    use_key_id integer NOT NULL,
    use_key_name character varying(32) NOT NULL,
    use_function integer
);


ALTER TABLE public.use_keys OWNER TO postgres;

--
-- Name: vw_account_types; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_account_types AS
 SELECT account_class.account_class_id,
    account_class.account_class_no,
    account_class.account_class_name,
    account_class.chat_type_id,
    account_class.chat_type_name,
    account_types.account_type_id,
    account_types.account_type_no,
    account_types.org_id,
    account_types.account_type_name,
    account_types.details
   FROM (public.account_types
     JOIN public.account_class ON ((account_types.account_class_id = account_class.account_class_id)));


ALTER TABLE public.vw_account_types OWNER TO postgres;

--
-- Name: vw_accounts; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_accounts AS
 SELECT vw_account_types.chat_type_id,
    vw_account_types.chat_type_name,
    vw_account_types.account_class_id,
    vw_account_types.account_class_no,
    vw_account_types.account_class_name,
    vw_account_types.account_type_id,
    vw_account_types.account_type_no,
    vw_account_types.account_type_name,
    accounts.account_id,
    accounts.account_no,
    accounts.org_id,
    accounts.account_name,
    accounts.is_header,
    accounts.is_active,
    accounts.details,
    ((((((accounts.account_no || ' : '::text) || (vw_account_types.account_class_name)::text) || ' : '::text) || (vw_account_types.account_type_name)::text) || ' : '::text) || (accounts.account_name)::text) AS account_description
   FROM (public.accounts
     JOIN public.vw_account_types ON ((accounts.account_type_id = vw_account_types.account_type_id)));


ALTER TABLE public.vw_accounts OWNER TO postgres;

--
-- Name: vw_activity_types; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_activity_types AS
 SELECT orgs.org_name,
    orgs.letter_head,
    activity_types.dr_account_id,
    dra.account_no AS dr_account_no,
    dra.account_name AS dr_account_name,
    activity_types.cr_account_id,
    cra.account_no AS cr_account_no,
    cra.account_name AS cr_account_name,
    use_keys.use_key_id,
    use_keys.use_key_name,
    activity_types.org_id,
    activity_types.activity_type_id,
    activity_types.activity_type_name,
    activity_types.is_active,
    activity_types.activity_type_no,
    activity_types.details
   FROM ((((public.activity_types
     JOIN public.vw_accounts dra ON ((activity_types.dr_account_id = dra.account_id)))
     JOIN public.vw_accounts cra ON ((activity_types.cr_account_id = cra.account_id)))
     JOIN public.use_keys ON ((activity_types.use_key_id = use_keys.use_key_id)))
     JOIN public.orgs ON ((activity_types.org_id = orgs.org_id)));


ALTER TABLE public.vw_activity_types OWNER TO postgres;

--
-- Name: vw_deposit_balance; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_deposit_balance AS
 SELECT cb.deposit_account_id,
    cb.current_balance,
    COALESCE(ab.c_balance, (0)::real) AS cleared_balance,
    COALESCE(uc.u_credit, (0)::real) AS unprocessed_credit
   FROM ((( SELECT account_activity.deposit_account_id,
            sum((account_activity.account_credit - account_activity.account_debit)) AS current_balance
           FROM public.account_activity
          GROUP BY account_activity.deposit_account_id) cb
     LEFT JOIN ( SELECT account_activity.deposit_account_id,
            sum((account_activity.account_credit - account_activity.account_debit)) AS c_balance
           FROM public.account_activity
          WHERE (account_activity.activity_status_id < 3)
          GROUP BY account_activity.deposit_account_id) ab ON ((cb.deposit_account_id = ab.deposit_account_id)))
     LEFT JOIN ( SELECT account_activity.deposit_account_id,
            sum(account_activity.account_credit) AS u_credit
           FROM public.account_activity
          WHERE (account_activity.activity_status_id > 2)
          GROUP BY account_activity.deposit_account_id) uc ON ((cb.deposit_account_id = uc.deposit_account_id)));


ALTER TABLE public.vw_deposit_balance OWNER TO postgres;

--
-- Name: vw_interest_methods; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_interest_methods AS
 SELECT activity_types.activity_type_id,
    activity_types.activity_type_name,
    activity_types.use_key_id,
    interest_methods.org_id,
    interest_methods.interest_method_id,
    interest_methods.interest_method_name,
    interest_methods.reducing_balance,
    interest_methods.formural,
    interest_methods.account_number,
    interest_methods.interest_method_no,
    interest_methods.details,
    orgs.org_name,
    orgs.letter_head
   FROM ((public.interest_methods
     JOIN public.activity_types ON ((interest_methods.activity_type_id = activity_types.activity_type_id)))
     JOIN public.orgs ON ((interest_methods.org_id = orgs.org_id)));


ALTER TABLE public.vw_interest_methods OWNER TO postgres;

--
-- Name: vw_products; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_products AS
 SELECT activity_frequency.activity_frequency_id,
    activity_frequency.activity_frequency_name,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    vw_interest_methods.interest_method_id,
    vw_interest_methods.interest_method_name,
    vw_interest_methods.reducing_balance,
    vw_interest_methods.interest_method_no,
    penalty_methods.penalty_method_id,
    penalty_methods.penalty_method_name,
    penalty_methods.penalty_method_no,
    products.org_id,
    products.product_id,
    products.product_name,
    products.description,
    products.loan_account,
    products.is_active,
    products.interest_rate,
    products.min_opening_balance,
    products.lockin_period_frequency,
    products.minimum_balance,
    products.maximum_balance,
    products.minimum_day,
    products.maximum_day,
    products.minimum_trx,
    products.maximum_trx,
    products.maximum_repayments,
    products.product_no,
    products.application_date,
    products.approve_status,
    products.workflow_table_id,
    products.action_date,
    products.details,
    vw_interest_methods.org_name,
    vw_interest_methods.letter_head
   FROM ((((public.products
     JOIN public.activity_frequency ON ((products.activity_frequency_id = activity_frequency.activity_frequency_id)))
     JOIN public.currency ON ((products.currency_id = currency.currency_id)))
     JOIN public.vw_interest_methods ON ((products.interest_method_id = vw_interest_methods.interest_method_id)))
     JOIN public.penalty_methods ON ((products.penalty_method_id = penalty_methods.penalty_method_id)));


ALTER TABLE public.vw_products OWNER TO postgres;

--
-- Name: vw_deposit_accounts; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_deposit_accounts AS
 SELECT members.member_id,
    members.member_name,
    members.business_account,
    vw_products.product_id,
    vw_products.product_name,
    vw_products.product_no,
    vw_products.currency_id,
    vw_products.currency_name,
    vw_products.currency_symbol,
    activity_frequency.activity_frequency_id,
    activity_frequency.activity_frequency_name,
    orgs.org_id,
    orgs.org_name,
    orgs.letter_head,
    deposit_accounts.deposit_account_id,
    deposit_accounts.is_active,
    deposit_accounts.account_number,
    deposit_accounts.narrative,
    deposit_accounts.last_closing_date,
    deposit_accounts.credit_limit,
    deposit_accounts.minimum_balance,
    deposit_accounts.maximum_balance,
    deposit_accounts.interest_rate,
    deposit_accounts.lockin_period_frequency,
    deposit_accounts.opening_date,
    deposit_accounts.lockedin_until_date,
    deposit_accounts.application_date,
    deposit_accounts.approve_status,
    deposit_accounts.workflow_table_id,
    deposit_accounts.action_date,
    deposit_accounts.details,
    vw_deposit_balance.current_balance,
    vw_deposit_balance.cleared_balance,
    vw_deposit_balance.unprocessed_credit,
    (vw_deposit_balance.cleared_balance - vw_deposit_balance.unprocessed_credit) AS available_balance
   FROM (((((public.deposit_accounts
     JOIN public.members ON ((deposit_accounts.member_id = members.member_id)))
     JOIN public.vw_products ON ((deposit_accounts.product_id = vw_products.product_id)))
     JOIN public.activity_frequency ON ((deposit_accounts.activity_frequency_id = activity_frequency.activity_frequency_id)))
     JOIN public.orgs ON ((deposit_accounts.org_id = orgs.org_id)))
     LEFT JOIN public.vw_deposit_balance ON ((deposit_accounts.deposit_account_id = vw_deposit_balance.deposit_account_id)));


ALTER TABLE public.vw_deposit_accounts OWNER TO postgres;

--
-- Name: vw_periods; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_periods AS
 SELECT fiscal_years.fiscal_year_id,
    fiscal_years.fiscal_year,
    fiscal_years.fiscal_year_start,
    fiscal_years.fiscal_year_end,
    fiscal_years.submission_date,
    fiscal_years.year_opened,
    fiscal_years.year_closed,
    periods.period_id,
    periods.org_id,
    periods.start_date,
    periods.end_date,
    periods.opened,
    periods.activated,
    periods.closed,
    periods.overtime_rate,
    periods.per_diem_tax_limit,
    periods.is_posted,
    periods.gl_payroll_account,
    periods.gl_advance_account,
    periods.details,
    date_part('month'::text, periods.start_date) AS month_id,
    to_char((periods.start_date)::timestamp with time zone, 'YYYY'::text) AS period_year,
    to_char((periods.start_date)::timestamp with time zone, 'Month'::text) AS period_month,
    to_char((periods.start_date)::timestamp with time zone, 'YYYY, Month'::text) AS period_disp,
    (trunc(((date_part('month'::text, periods.start_date) - (1)::double precision) / (3)::double precision)) + (1)::double precision) AS quarter,
    (trunc(((date_part('month'::text, periods.start_date) - (1)::double precision) / (6)::double precision)) + (1)::double precision) AS semister,
    to_char((periods.start_date)::timestamp with time zone, 'YYYYMM'::text) AS period_code
   FROM (public.periods
     LEFT JOIN public.fiscal_years ON ((periods.fiscal_year_id = fiscal_years.fiscal_year_id)))
  ORDER BY periods.start_date;


ALTER TABLE public.vw_periods OWNER TO postgres;

--
-- Name: vw_account_activity; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_account_activity AS
 SELECT vw_deposit_accounts.member_id,
    vw_deposit_accounts.member_name,
    vw_deposit_accounts.business_account,
    vw_deposit_accounts.product_id,
    vw_deposit_accounts.product_name,
    vw_deposit_accounts.deposit_account_id,
    vw_deposit_accounts.is_active,
    vw_deposit_accounts.account_number,
    vw_deposit_accounts.last_closing_date,
    vw_deposit_accounts.currency_id,
    vw_deposit_accounts.currency_name,
    vw_deposit_accounts.currency_symbol,
    vw_activity_types.activity_type_id,
    vw_activity_types.activity_type_name,
    vw_activity_types.dr_account_id,
    vw_activity_types.dr_account_no,
    vw_activity_types.dr_account_name,
    vw_activity_types.cr_account_id,
    vw_activity_types.cr_account_no,
    vw_activity_types.cr_account_name,
    vw_activity_types.use_key_id,
    vw_activity_types.use_key_name,
    activity_frequency.activity_frequency_id,
    activity_frequency.activity_frequency_name,
    activity_status.activity_status_id,
    activity_status.activity_status_name,
    account_activity.transfer_account_id,
    trnf_accounts.account_number AS trnf_account_number,
    trnf_accounts.member_id AS trnf_member_id,
    trnf_accounts.member_name AS trnf_member_name,
    trnf_accounts.product_id AS trnf_product_id,
    trnf_accounts.product_name AS trnf_product_name,
    vw_periods.period_id,
    vw_periods.start_date,
    vw_periods.end_date,
    vw_periods.fiscal_year_id,
    vw_periods.fiscal_year,
    account_activity.org_id,
    account_activity.account_activity_id,
    account_activity.activity_date,
    account_activity.value_date,
    account_activity.transfer_account_no,
    account_activity.transfer_link_id,
    account_activity.account_credit,
    account_activity.account_debit,
    account_activity.balance,
    account_activity.exchange_rate,
    account_activity.application_date,
    account_activity.approve_status,
    account_activity.workflow_table_id,
    account_activity.action_date,
    account_activity.details,
    (account_activity.account_credit * account_activity.exchange_rate) AS base_credit,
    (account_activity.account_debit * account_activity.exchange_rate) AS base_debit,
    vw_deposit_accounts.product_no,
    vw_deposit_accounts.letter_head
   FROM ((((((public.account_activity
     JOIN public.vw_deposit_accounts ON ((account_activity.deposit_account_id = vw_deposit_accounts.deposit_account_id)))
     JOIN public.vw_activity_types ON ((account_activity.activity_type_id = vw_activity_types.activity_type_id)))
     JOIN public.activity_frequency ON ((account_activity.activity_frequency_id = activity_frequency.activity_frequency_id)))
     JOIN public.activity_status ON ((account_activity.activity_status_id = activity_status.activity_status_id)))
     LEFT JOIN public.vw_periods ON ((account_activity.period_id = vw_periods.period_id)))
     LEFT JOIN public.vw_deposit_accounts trnf_accounts ON ((account_activity.transfer_account_id = trnf_accounts.deposit_account_id)));


ALTER TABLE public.vw_account_activity OWNER TO postgres;

--
-- Name: vw_account_definations; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_account_definations AS
 SELECT products.product_id,
    products.product_name,
    products.product_no,
    vw_activity_types.activity_type_id,
    vw_activity_types.activity_type_name,
    vw_activity_types.activity_type_no,
    vw_activity_types.use_key_id,
    vw_activity_types.use_key_name,
    account_definations.charge_activity_id,
    charge_activitys.activity_type_name AS charge_activity_name,
    charge_activitys.activity_type_no AS charge_activity_no,
    activity_frequency.activity_frequency_id,
    activity_frequency.activity_frequency_name,
    account_definations.org_id,
    account_definations.account_defination_id,
    account_definations.account_defination_name,
    account_definations.start_date,
    account_definations.end_date,
    account_definations.is_active,
    account_definations.account_number,
    account_definations.fee_amount,
    account_definations.fee_ps,
    account_definations.has_charge,
    account_definations.details
   FROM ((((public.account_definations
     JOIN public.vw_activity_types ON ((account_definations.activity_type_id = vw_activity_types.activity_type_id)))
     JOIN public.products ON ((account_definations.product_id = products.product_id)))
     JOIN public.activity_frequency ON ((account_definations.activity_frequency_id = activity_frequency.activity_frequency_id)))
     LEFT JOIN public.activity_types charge_activitys ON ((account_definations.charge_activity_id = charge_activitys.activity_type_id)));


ALTER TABLE public.vw_account_definations OWNER TO postgres;

--
-- Name: vw_account_notes; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_account_notes AS
 SELECT vw_deposit_accounts.member_id,
    vw_deposit_accounts.member_name,
    vw_deposit_accounts.product_id,
    vw_deposit_accounts.product_name,
    vw_deposit_accounts.deposit_account_id,
    vw_deposit_accounts.is_active,
    vw_deposit_accounts.account_number,
    vw_deposit_accounts.last_closing_date,
    account_notes.org_id,
    account_notes.account_note_id,
    account_notes.comment_date,
    account_notes.narrative,
    account_notes.note,
    vw_deposit_accounts.letter_head
   FROM (public.account_notes
     JOIN public.vw_deposit_accounts ON ((account_notes.deposit_account_id = vw_deposit_accounts.deposit_account_id)));


ALTER TABLE public.vw_account_notes OWNER TO postgres;

--
-- Name: vw_address; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_address AS
 SELECT sys_countrys.sys_country_id,
    sys_countrys.sys_country_name,
    address.address_id,
    address.org_id,
    address.address_name,
    address.table_name,
    address.table_id,
    address.post_office_box,
    address.postal_code,
    address.premises,
    address.street,
    address.town,
    address.phone_number,
    address.extension,
    address.mobile,
    address.fax,
    address.email,
    address.is_default,
    address.website,
    address.details,
    address_types.address_type_id,
    address_types.address_type_name
   FROM ((public.address
     JOIN public.sys_countrys ON ((address.sys_country_id = sys_countrys.sys_country_id)))
     LEFT JOIN public.address_types ON ((address.address_type_id = address_types.address_type_id)));


ALTER TABLE public.vw_address OWNER TO postgres;

--
-- Name: vw_address_entitys; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_address_entitys AS
 SELECT vw_address.address_id,
    vw_address.address_name,
    vw_address.table_id,
    vw_address.table_name,
    vw_address.sys_country_id,
    vw_address.sys_country_name,
    vw_address.is_default,
    vw_address.post_office_box,
    vw_address.postal_code,
    vw_address.premises,
    vw_address.street,
    vw_address.town,
    vw_address.phone_number,
    vw_address.extension,
    vw_address.mobile,
    vw_address.fax,
    vw_address.email,
    vw_address.website
   FROM public.vw_address
  WHERE (((vw_address.table_name)::text = 'entitys'::text) AND (vw_address.is_default = true));


ALTER TABLE public.vw_address_entitys OWNER TO postgres;

--
-- Name: workflows; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.workflows (
    workflow_id integer NOT NULL,
    source_entity_id integer NOT NULL,
    org_id integer,
    workflow_name character varying(240) NOT NULL,
    table_name character varying(64),
    table_link_field character varying(64),
    table_link_id integer,
    approve_email text NOT NULL,
    reject_email text NOT NULL,
    approve_file character varying(320),
    reject_file character varying(320),
    link_copy integer,
    details text
);


ALTER TABLE public.workflows OWNER TO postgres;

--
-- Name: vw_workflows; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_workflows AS
 SELECT entity_types.entity_type_id AS source_entity_id,
    entity_types.entity_type_name AS source_entity_name,
    workflows.workflow_id,
    workflows.org_id,
    workflows.workflow_name,
    workflows.table_name,
    workflows.table_link_field,
    workflows.table_link_id,
    workflows.approve_email,
    workflows.reject_email,
    workflows.approve_file,
    workflows.reject_file,
    workflows.details
   FROM (public.workflows
     JOIN public.entity_types ON ((workflows.source_entity_id = entity_types.entity_type_id)));


ALTER TABLE public.vw_workflows OWNER TO postgres;

--
-- Name: workflow_phases; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.workflow_phases (
    workflow_phase_id integer NOT NULL,
    workflow_id integer NOT NULL,
    approval_entity_id integer NOT NULL,
    org_id integer,
    approval_level integer DEFAULT 1 NOT NULL,
    return_level integer DEFAULT 1 NOT NULL,
    escalation_days integer DEFAULT 0 NOT NULL,
    escalation_hours integer DEFAULT 3 NOT NULL,
    required_approvals integer DEFAULT 1 NOT NULL,
    reporting_level integer DEFAULT 1 NOT NULL,
    use_reporting boolean DEFAULT false NOT NULL,
    advice boolean DEFAULT false NOT NULL,
    notice boolean DEFAULT false NOT NULL,
    phase_narrative character varying(240) NOT NULL,
    advice_email text,
    notice_email text,
    advice_file character varying(320),
    notice_file character varying(320),
    details text
);


ALTER TABLE public.workflow_phases OWNER TO postgres;

--
-- Name: vw_workflow_phases; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_workflow_phases AS
 SELECT vw_workflows.source_entity_id,
    vw_workflows.source_entity_name,
    vw_workflows.workflow_id,
    vw_workflows.workflow_name,
    vw_workflows.table_name,
    vw_workflows.table_link_field,
    vw_workflows.table_link_id,
    vw_workflows.approve_email,
    vw_workflows.reject_email,
    vw_workflows.approve_file,
    vw_workflows.reject_file,
    entity_types.entity_type_id AS approval_entity_id,
    entity_types.entity_type_name AS approval_entity_name,
    workflow_phases.workflow_phase_id,
    workflow_phases.org_id,
    workflow_phases.approval_level,
    workflow_phases.return_level,
    workflow_phases.escalation_days,
    workflow_phases.escalation_hours,
    workflow_phases.notice,
    workflow_phases.notice_email,
    workflow_phases.notice_file,
    workflow_phases.advice,
    workflow_phases.advice_email,
    workflow_phases.advice_file,
    workflow_phases.required_approvals,
    workflow_phases.use_reporting,
    workflow_phases.reporting_level,
    workflow_phases.phase_narrative,
    workflow_phases.details
   FROM ((public.workflow_phases
     JOIN public.vw_workflows ON ((workflow_phases.workflow_id = vw_workflows.workflow_id)))
     JOIN public.entity_types ON ((workflow_phases.approval_entity_id = entity_types.entity_type_id)));


ALTER TABLE public.vw_workflow_phases OWNER TO postgres;

--
-- Name: vw_approvals; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_approvals AS
 SELECT vw_workflow_phases.workflow_id,
    vw_workflow_phases.workflow_name,
    vw_workflow_phases.approve_email,
    vw_workflow_phases.reject_email,
    vw_workflow_phases.source_entity_id,
    vw_workflow_phases.source_entity_name,
    vw_workflow_phases.approval_entity_id,
    vw_workflow_phases.approval_entity_name,
    vw_workflow_phases.approve_file,
    vw_workflow_phases.reject_file,
    vw_workflow_phases.workflow_phase_id,
    vw_workflow_phases.approval_level,
    vw_workflow_phases.phase_narrative,
    vw_workflow_phases.return_level,
    vw_workflow_phases.required_approvals,
    vw_workflow_phases.notice,
    vw_workflow_phases.notice_email,
    vw_workflow_phases.notice_file,
    vw_workflow_phases.advice,
    vw_workflow_phases.advice_email,
    vw_workflow_phases.advice_file,
    vw_workflow_phases.use_reporting,
    approvals.approval_id,
    approvals.org_id,
    approvals.forward_id,
    approvals.table_name,
    approvals.table_id,
    approvals.completion_date,
    approvals.escalation_days,
    approvals.escalation_hours,
    approvals.escalation_time,
    approvals.application_date,
    approvals.approve_status,
    approvals.action_date,
    approvals.approval_narrative,
    approvals.to_be_done,
    approvals.what_is_done,
    approvals.review_advice,
    approvals.details,
    oe.entity_id AS org_entity_id,
    oe.entity_name AS org_entity_name,
    oe.user_name AS org_user_name,
    oe.primary_email AS org_primary_email,
    ae.entity_id AS app_entity_id,
    ae.entity_name AS app_entity_name,
    ae.user_name AS app_user_name,
    ae.primary_email AS app_primary_email
   FROM (((public.vw_workflow_phases
     JOIN public.approvals ON ((vw_workflow_phases.workflow_phase_id = approvals.workflow_phase_id)))
     JOIN public.entitys oe ON ((approvals.org_entity_id = oe.entity_id)))
     LEFT JOIN public.entitys ae ON ((approvals.app_entity_id = ae.entity_id)));


ALTER TABLE public.vw_approvals OWNER TO postgres;

--
-- Name: vw_approvals_entitys; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_approvals_entitys AS
 SELECT vw_workflow_phases.workflow_id,
    vw_workflow_phases.workflow_name,
    vw_workflow_phases.source_entity_id,
    vw_workflow_phases.source_entity_name,
    vw_workflow_phases.approval_entity_id,
    vw_workflow_phases.approval_entity_name,
    vw_workflow_phases.workflow_phase_id,
    vw_workflow_phases.approval_level,
    vw_workflow_phases.notice,
    vw_workflow_phases.notice_email,
    vw_workflow_phases.notice_file,
    vw_workflow_phases.advice,
    vw_workflow_phases.advice_email,
    vw_workflow_phases.advice_file,
    vw_workflow_phases.return_level,
    vw_workflow_phases.required_approvals,
    vw_workflow_phases.phase_narrative,
    vw_workflow_phases.use_reporting,
    approvals.approval_id,
    approvals.org_id,
    approvals.forward_id,
    approvals.table_name,
    approvals.table_id,
    approvals.completion_date,
    approvals.escalation_days,
    approvals.escalation_hours,
    approvals.escalation_time,
    approvals.application_date,
    approvals.approve_status,
    approvals.action_date,
    approvals.approval_narrative,
    approvals.to_be_done,
    approvals.what_is_done,
    approvals.review_advice,
    approvals.details,
    oe.entity_id AS org_entity_id,
    oe.entity_name AS org_entity_name,
    oe.user_name AS org_user_name,
    oe.primary_email AS org_primary_email,
    entitys.entity_id,
    entitys.entity_name,
    entitys.user_name,
    entitys.primary_email
   FROM ((((public.vw_workflow_phases
     JOIN public.approvals ON ((vw_workflow_phases.workflow_phase_id = approvals.workflow_phase_id)))
     JOIN public.entitys oe ON ((approvals.org_entity_id = oe.entity_id)))
     JOIN public.entity_subscriptions ON ((vw_workflow_phases.approval_entity_id = entity_subscriptions.entity_type_id)))
     JOIN public.entitys ON ((entity_subscriptions.entity_id = entitys.entity_id)))
  WHERE ((approvals.forward_id IS NULL) AND (vw_workflow_phases.use_reporting = false))
UNION
 SELECT vw_workflow_phases.workflow_id,
    vw_workflow_phases.workflow_name,
    vw_workflow_phases.source_entity_id,
    vw_workflow_phases.source_entity_name,
    vw_workflow_phases.approval_entity_id,
    vw_workflow_phases.approval_entity_name,
    vw_workflow_phases.workflow_phase_id,
    vw_workflow_phases.approval_level,
    vw_workflow_phases.notice,
    vw_workflow_phases.notice_email,
    vw_workflow_phases.notice_file,
    vw_workflow_phases.advice,
    vw_workflow_phases.advice_email,
    vw_workflow_phases.advice_file,
    vw_workflow_phases.return_level,
    vw_workflow_phases.required_approvals,
    vw_workflow_phases.phase_narrative,
    vw_workflow_phases.use_reporting,
    approvals.approval_id,
    approvals.org_id,
    approvals.forward_id,
    approvals.table_name,
    approvals.table_id,
    approvals.completion_date,
    approvals.escalation_days,
    approvals.escalation_hours,
    approvals.escalation_time,
    approvals.application_date,
    approvals.approve_status,
    approvals.action_date,
    approvals.approval_narrative,
    approvals.to_be_done,
    approvals.what_is_done,
    approvals.review_advice,
    approvals.details,
    oe.entity_id AS org_entity_id,
    oe.entity_name AS org_entity_name,
    oe.user_name AS org_user_name,
    oe.primary_email AS org_primary_email,
    entitys.entity_id,
    entitys.entity_name,
    entitys.user_name,
    entitys.primary_email
   FROM ((((public.vw_workflow_phases
     JOIN public.approvals ON ((vw_workflow_phases.workflow_phase_id = approvals.workflow_phase_id)))
     JOIN public.entitys oe ON ((approvals.org_entity_id = oe.entity_id)))
     JOIN public.reporting ON (((approvals.org_entity_id = reporting.entity_id) AND (vw_workflow_phases.reporting_level = reporting.reporting_level))))
     JOIN public.entitys ON ((reporting.report_to_id = entitys.entity_id)))
  WHERE ((approvals.forward_id IS NULL) AND (reporting.primary_report = true) AND (reporting.is_active = true) AND (vw_workflow_phases.use_reporting = true));


ALTER TABLE public.vw_approvals_entitys OWNER TO postgres;

--
-- Name: vw_bank_branch; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_bank_branch AS
 SELECT sys_countrys.sys_country_id,
    sys_countrys.sys_country_code,
    sys_countrys.sys_country_name,
    banks.bank_id,
    banks.bank_name,
    banks.bank_code,
    banks.swift_code,
    banks.sort_code,
    bank_branch.bank_branch_id,
    bank_branch.org_id,
    bank_branch.bank_branch_name,
    bank_branch.bank_branch_code,
    bank_branch.narrative,
    (((banks.bank_name)::text || ', '::text) || (bank_branch.bank_branch_name)::text) AS bank_branch_disp
   FROM ((public.bank_branch
     JOIN public.banks ON ((bank_branch.bank_id = banks.bank_id)))
     LEFT JOIN public.sys_countrys ON ((banks.sys_country_id = sys_countrys.sys_country_id)));


ALTER TABLE public.vw_bank_branch OWNER TO postgres;

--
-- Name: vw_bank_accounts; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_bank_accounts AS
 SELECT vw_bank_branch.bank_id,
    vw_bank_branch.bank_name,
    vw_bank_branch.bank_branch_id,
    vw_bank_branch.bank_branch_name,
    vw_accounts.account_type_id,
    vw_accounts.account_type_name,
    vw_accounts.account_id,
    vw_accounts.account_name,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    bank_accounts.bank_account_id,
    bank_accounts.org_id,
    bank_accounts.bank_account_name,
    bank_accounts.bank_account_number,
    bank_accounts.narrative,
    bank_accounts.is_active,
    bank_accounts.details
   FROM (((public.bank_accounts
     JOIN public.vw_bank_branch ON ((bank_accounts.bank_branch_id = vw_bank_branch.bank_branch_id)))
     JOIN public.vw_accounts ON ((bank_accounts.account_id = vw_accounts.account_id)))
     JOIN public.currency ON ((bank_accounts.currency_id = currency.currency_id)));


ALTER TABLE public.vw_bank_accounts OWNER TO postgres;

--
-- Name: vw_tenders; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_tenders AS
 SELECT tender_types.tender_type_id,
    tender_types.tender_type_name,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    tenders.org_id,
    tenders.tender_id,
    tenders.tender_name,
    tenders.tender_number,
    tenders.tender_date,
    tenders.tender_end_date,
    tenders.is_completed,
    tenders.details
   FROM ((public.tenders
     JOIN public.tender_types ON ((tenders.tender_type_id = tender_types.tender_type_id)))
     JOIN public.currency ON ((tenders.currency_id = currency.currency_id)));


ALTER TABLE public.vw_tenders OWNER TO postgres;

--
-- Name: vw_bidders; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_bidders AS
 SELECT vw_tenders.tender_type_id,
    vw_tenders.tender_type_name,
    vw_tenders.tender_id,
    vw_tenders.tender_name,
    vw_tenders.tender_number,
    vw_tenders.tender_date,
    vw_tenders.tender_end_date,
    vw_tenders.is_completed,
    entitys.entity_id,
    entitys.entity_name,
    bidders.org_id,
    bidders.bidder_id,
    bidders.tender_amount,
    bidders.bind_bond,
    bidders.bind_bond_amount,
    bidders.return_date,
    bidders.points,
    bidders.is_awarded,
    bidders.award_reference,
    bidders.details
   FROM ((public.bidders
     JOIN public.vw_tenders ON ((bidders.tender_id = vw_tenders.tender_id)))
     JOIN public.entitys ON ((bidders.entity_id = entitys.entity_id)));


ALTER TABLE public.vw_bidders OWNER TO postgres;

--
-- Name: vw_budgets; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_budgets AS
 SELECT departments.department_id,
    departments.department_name,
    fiscal_years.fiscal_year_id,
    fiscal_years.fiscal_year_start,
    fiscal_years.fiscal_year,
    fiscal_years.fiscal_year_end,
    fiscal_years.year_opened,
    fiscal_years.year_closed,
    budgets.budget_id,
    budgets.org_id,
    budgets.budget_type,
    budgets.budget_name,
    budgets.application_date,
    budgets.approve_status,
    budgets.workflow_table_id,
    budgets.action_date,
    budgets.details
   FROM ((public.budgets
     JOIN public.departments ON ((budgets.department_id = departments.department_id)))
     JOIN public.fiscal_years ON ((budgets.fiscal_year_id = fiscal_years.fiscal_year_id)));


ALTER TABLE public.vw_budgets OWNER TO postgres;

--
-- Name: vw_items; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_items AS
 SELECT sales_account.account_id AS sales_account_id,
    sales_account.account_name AS sales_account_name,
    purchase_account.account_id AS purchase_account_id,
    purchase_account.account_name AS purchase_account_name,
    item_category.item_category_id,
    item_category.item_category_name,
    item_units.item_unit_id,
    item_units.item_unit_name,
    tax_types.tax_type_id,
    tax_types.tax_type_name,
    tax_types.account_id AS tax_account_id,
    tax_types.tax_rate,
    tax_types.tax_inclusive,
    items.item_id,
    items.org_id,
    items.item_name,
    items.bar_code,
    items.for_sale,
    items.for_purchase,
    items.for_stock,
    items.inventory,
    items.sales_price,
    items.purchase_price,
    items.reorder_level,
    items.lead_time,
    items.is_active,
    items.details
   FROM (((((public.items
     JOIN public.accounts sales_account ON ((items.sales_account_id = sales_account.account_id)))
     JOIN public.accounts purchase_account ON ((items.purchase_account_id = purchase_account.account_id)))
     JOIN public.item_category ON ((items.item_category_id = item_category.item_category_id)))
     JOIN public.item_units ON ((items.item_unit_id = item_units.item_unit_id)))
     JOIN public.tax_types ON ((items.tax_type_id = tax_types.tax_type_id)));


ALTER TABLE public.vw_items OWNER TO postgres;

--
-- Name: vw_budget_lines; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_budget_lines AS
 SELECT vw_budgets.department_id,
    vw_budgets.department_name,
    vw_budgets.fiscal_year_id,
    vw_budgets.fiscal_year,
    vw_budgets.fiscal_year_start,
    vw_budgets.fiscal_year_end,
    vw_budgets.year_opened,
    vw_budgets.year_closed,
    vw_budgets.budget_id,
    vw_budgets.budget_name,
    vw_budgets.budget_type,
    vw_budgets.approve_status,
    periods.period_id,
    periods.start_date,
    periods.end_date,
    periods.opened,
    periods.activated,
    periods.closed,
    periods.overtime_rate,
    periods.per_diem_tax_limit,
    periods.is_posted,
    date_part('month'::text, periods.start_date) AS month_id,
    to_char((periods.start_date)::timestamp with time zone, 'YYYY'::text) AS period_year,
    to_char((periods.start_date)::timestamp with time zone, 'Month'::text) AS period_month,
    (trunc(((date_part('month'::text, periods.start_date) - (1)::double precision) / (3)::double precision)) + (1)::double precision) AS quarter,
    (trunc(((date_part('month'::text, periods.start_date) - (1)::double precision) / (6)::double precision)) + (1)::double precision) AS semister,
    vw_accounts.account_class_id,
    vw_accounts.chat_type_id,
    vw_accounts.chat_type_name,
    vw_accounts.account_class_name,
    vw_accounts.account_type_id,
    vw_accounts.account_type_name,
    vw_accounts.account_id,
    vw_accounts.account_name,
    vw_accounts.is_header,
    vw_accounts.is_active,
    vw_items.item_id,
    vw_items.item_name,
    vw_items.tax_type_id,
    vw_items.tax_account_id,
    vw_items.tax_type_name,
    vw_items.tax_rate,
    vw_items.tax_inclusive,
    vw_items.sales_account_id,
    vw_items.purchase_account_id,
    budget_lines.budget_line_id,
    budget_lines.org_id,
    budget_lines.transaction_id,
    budget_lines.spend_type,
    budget_lines.quantity,
    budget_lines.amount,
    budget_lines.tax_amount,
    budget_lines.narrative,
    budget_lines.details,
        CASE
            WHEN (budget_lines.spend_type = 1) THEN 'Monthly'::text
            WHEN (budget_lines.spend_type = 2) THEN 'Quaterly'::text
            ELSE 'Once'::text
        END AS spend_type_name,
    budget_lines.income_budget,
        CASE
            WHEN (budget_lines.income_budget = true) THEN 'Income Budget'::text
            ELSE 'Expenditure Budget'::text
        END AS income_expense,
        CASE
            WHEN (budget_lines.income_budget = true) THEN budget_lines.amount
            ELSE (0)::real
        END AS dr_budget,
        CASE
            WHEN (budget_lines.income_budget = false) THEN budget_lines.amount
            ELSE (0)::real
        END AS cr_budget
   FROM ((((public.budget_lines
     JOIN public.vw_budgets ON ((budget_lines.budget_id = vw_budgets.budget_id)))
     JOIN public.periods ON ((budget_lines.period_id = periods.period_id)))
     JOIN public.vw_accounts ON ((budget_lines.account_id = vw_accounts.account_id)))
     LEFT JOIN public.vw_items ON ((budget_lines.item_id = vw_items.item_id)));


ALTER TABLE public.vw_budget_lines OWNER TO postgres;

--
-- Name: vw_budget_ads; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_budget_ads AS
 SELECT vw_budget_lines.department_id,
    vw_budget_lines.department_name,
    vw_budget_lines.fiscal_year_id,
    vw_budget_lines.fiscal_year,
    vw_budget_lines.fiscal_year_start,
    vw_budget_lines.fiscal_year_end,
    vw_budget_lines.year_opened,
    vw_budget_lines.year_closed,
    vw_budget_lines.budget_type,
    vw_budget_lines.account_class_id,
    vw_budget_lines.chat_type_id,
    vw_budget_lines.chat_type_name,
    vw_budget_lines.account_class_name,
    vw_budget_lines.account_type_id,
    vw_budget_lines.account_type_name,
    vw_budget_lines.account_id,
    vw_budget_lines.account_name,
    vw_budget_lines.is_header,
    vw_budget_lines.is_active,
    vw_budget_lines.item_id,
    vw_budget_lines.item_name,
    vw_budget_lines.tax_type_id,
    vw_budget_lines.tax_account_id,
    vw_budget_lines.org_id,
    vw_budget_lines.spend_type,
    vw_budget_lines.spend_type_name,
    vw_budget_lines.income_budget,
    vw_budget_lines.income_expense,
    sum(vw_budget_lines.quantity) AS s_quantity,
    sum(vw_budget_lines.amount) AS s_amount,
    sum(vw_budget_lines.tax_amount) AS s_tax_amount,
    sum(vw_budget_lines.dr_budget) AS s_dr_budget,
    sum(vw_budget_lines.cr_budget) AS s_cr_budget,
    sum((vw_budget_lines.dr_budget - vw_budget_lines.cr_budget)) AS budget_diff
   FROM public.vw_budget_lines
  WHERE ((vw_budget_lines.approve_status)::text = 'Approved'::text)
  GROUP BY vw_budget_lines.department_id, vw_budget_lines.department_name, vw_budget_lines.fiscal_year_id, vw_budget_lines.fiscal_year, vw_budget_lines.fiscal_year_start, vw_budget_lines.fiscal_year_end, vw_budget_lines.year_opened, vw_budget_lines.year_closed, vw_budget_lines.budget_type, vw_budget_lines.account_class_id, vw_budget_lines.chat_type_id, vw_budget_lines.chat_type_name, vw_budget_lines.account_class_name, vw_budget_lines.account_type_id, vw_budget_lines.account_type_name, vw_budget_lines.account_id, vw_budget_lines.account_name, vw_budget_lines.is_header, vw_budget_lines.is_active, vw_budget_lines.item_id, vw_budget_lines.item_name, vw_budget_lines.tax_type_id, vw_budget_lines.tax_account_id, vw_budget_lines.org_id, vw_budget_lines.spend_type, vw_budget_lines.spend_type_name, vw_budget_lines.income_budget, vw_budget_lines.income_expense;


ALTER TABLE public.vw_budget_ads OWNER TO postgres;

--
-- Name: vw_budget_ledger; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_budget_ledger AS
 SELECT journals.org_id,
    periods.fiscal_year_id,
    journals.department_id,
    accounts.account_id,
    accounts.account_no,
    accounts.account_type_id,
    accounts.account_name,
    sum((journals.exchange_rate * gls.debit)) AS bl_debit,
    sum((journals.exchange_rate * gls.credit)) AS bl_credit,
    sum((journals.exchange_rate * (gls.debit - gls.credit))) AS bl_diff
   FROM (((public.journals
     JOIN public.gls ON ((journals.journal_id = gls.journal_id)))
     JOIN public.accounts ON ((gls.account_id = accounts.account_id)))
     JOIN public.periods ON ((journals.period_id = periods.period_id)))
  WHERE (journals.posted = true)
  GROUP BY journals.org_id, periods.fiscal_year_id, journals.department_id, accounts.account_id, accounts.account_no, accounts.account_type_id, accounts.account_name;


ALTER TABLE public.vw_budget_ledger OWNER TO postgres;

--
-- Name: vw_budget_pdc; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_budget_pdc AS
 SELECT vw_budget_ads.department_id,
    vw_budget_ads.department_name,
    vw_budget_ads.fiscal_year_id,
    vw_budget_ads.fiscal_year,
    vw_budget_ads.fiscal_year_start,
    vw_budget_ads.fiscal_year_end,
    vw_budget_ads.year_opened,
    vw_budget_ads.year_closed,
    vw_budget_ads.budget_type,
    vw_budget_ads.account_class_id,
    vw_budget_ads.chat_type_id,
    vw_budget_ads.chat_type_name,
    vw_budget_ads.account_class_name,
    vw_budget_ads.account_type_id,
    vw_budget_ads.account_type_name,
    vw_budget_ads.account_id,
    vw_budget_ads.account_name,
    vw_budget_ads.is_header,
    vw_budget_ads.is_active,
    vw_budget_ads.item_id,
    vw_budget_ads.item_name,
    vw_budget_ads.tax_type_id,
    vw_budget_ads.tax_account_id,
    vw_budget_ads.org_id,
    vw_budget_ads.spend_type,
    vw_budget_ads.spend_type_name,
    vw_budget_ads.income_budget,
    vw_budget_ads.income_expense,
    vw_budget_ads.s_quantity,
    vw_budget_ads.s_amount,
    vw_budget_ads.s_tax_amount,
    vw_budget_ads.s_dr_budget,
    vw_budget_ads.s_cr_budget,
    vw_budget_ledger.bl_debit,
    vw_budget_ledger.bl_credit,
        CASE
            WHEN (vw_budget_ads.income_budget = true) THEN COALESCE((('-1'::integer)::double precision * vw_budget_ledger.bl_diff), (0)::double precision)
            ELSE (COALESCE(vw_budget_ledger.bl_diff, (0)::real))::double precision
        END AS amount_used,
        CASE
            WHEN (vw_budget_ads.income_budget = true) THEN (vw_budget_ads.s_amount + COALESCE(vw_budget_ledger.bl_diff, (0)::real))
            ELSE (vw_budget_ads.s_amount - COALESCE(vw_budget_ledger.bl_diff, (0)::real))
        END AS budget_balance
   FROM (public.vw_budget_ads
     LEFT JOIN public.vw_budget_ledger ON (((vw_budget_ads.department_id = vw_budget_ledger.department_id) AND (vw_budget_ads.account_id = vw_budget_ledger.account_id) AND (vw_budget_ads.fiscal_year_id = vw_budget_ledger.fiscal_year_id))));


ALTER TABLE public.vw_budget_pdc OWNER TO postgres;

--
-- Name: vw_budget_pds; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_budget_pds AS
 SELECT vw_budget_lines.department_id,
    vw_budget_lines.department_name,
    vw_budget_lines.fiscal_year_id,
    vw_budget_lines.fiscal_year,
    vw_budget_lines.fiscal_year_start,
    vw_budget_lines.fiscal_year_end,
    vw_budget_lines.year_opened,
    vw_budget_lines.year_closed,
    vw_budget_lines.period_id,
    vw_budget_lines.start_date,
    vw_budget_lines.end_date,
    vw_budget_lines.opened,
    vw_budget_lines.closed,
    vw_budget_lines.month_id,
    vw_budget_lines.period_year,
    vw_budget_lines.period_month,
    vw_budget_lines.quarter,
    vw_budget_lines.semister,
    vw_budget_lines.budget_type,
    vw_budget_lines.account_class_id,
    vw_budget_lines.chat_type_id,
    vw_budget_lines.chat_type_name,
    vw_budget_lines.account_class_name,
    vw_budget_lines.account_type_id,
    vw_budget_lines.account_type_name,
    vw_budget_lines.account_id,
    vw_budget_lines.account_name,
    vw_budget_lines.is_header,
    vw_budget_lines.is_active,
    vw_budget_lines.item_id,
    vw_budget_lines.item_name,
    vw_budget_lines.tax_type_id,
    vw_budget_lines.tax_account_id,
    vw_budget_lines.tax_type_name,
    vw_budget_lines.tax_rate,
    vw_budget_lines.tax_inclusive,
    vw_budget_lines.sales_account_id,
    vw_budget_lines.purchase_account_id,
    vw_budget_lines.budget_line_id,
    vw_budget_lines.org_id,
    vw_budget_lines.transaction_id,
    vw_budget_lines.spend_type,
    vw_budget_lines.spend_type_name,
    vw_budget_lines.income_budget,
    vw_budget_lines.income_expense,
    sum(vw_budget_lines.quantity) AS s_quantity,
    sum(vw_budget_lines.amount) AS s_amount,
    sum(vw_budget_lines.tax_amount) AS s_tax_amount,
    sum(vw_budget_lines.dr_budget) AS s_dr_budget,
    sum(vw_budget_lines.cr_budget) AS s_cr_budget,
    sum((vw_budget_lines.dr_budget - vw_budget_lines.cr_budget)) AS budget_diff
   FROM public.vw_budget_lines
  WHERE ((vw_budget_lines.approve_status)::text = 'Approved'::text)
  GROUP BY vw_budget_lines.department_id, vw_budget_lines.department_name, vw_budget_lines.fiscal_year_id, vw_budget_lines.fiscal_year, vw_budget_lines.fiscal_year_start, vw_budget_lines.fiscal_year_end, vw_budget_lines.year_opened, vw_budget_lines.year_closed, vw_budget_lines.period_id, vw_budget_lines.start_date, vw_budget_lines.end_date, vw_budget_lines.opened, vw_budget_lines.closed, vw_budget_lines.month_id, vw_budget_lines.period_year, vw_budget_lines.period_month, vw_budget_lines.quarter, vw_budget_lines.semister, vw_budget_lines.budget_type, vw_budget_lines.account_class_id, vw_budget_lines.chat_type_id, vw_budget_lines.chat_type_name, vw_budget_lines.account_class_name, vw_budget_lines.account_type_id, vw_budget_lines.account_type_name, vw_budget_lines.account_id, vw_budget_lines.account_name, vw_budget_lines.is_header, vw_budget_lines.is_active, vw_budget_lines.item_id, vw_budget_lines.item_name, vw_budget_lines.tax_type_id, vw_budget_lines.tax_account_id, vw_budget_lines.tax_type_name, vw_budget_lines.tax_rate, vw_budget_lines.tax_inclusive, vw_budget_lines.sales_account_id, vw_budget_lines.purchase_account_id, vw_budget_lines.budget_line_id, vw_budget_lines.org_id, vw_budget_lines.transaction_id, vw_budget_lines.spend_type, vw_budget_lines.spend_type_name, vw_budget_lines.income_budget, vw_budget_lines.income_expense;


ALTER TABLE public.vw_budget_pds OWNER TO postgres;

--
-- Name: vw_loan_balance; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_loan_balance AS
 SELECT cb.loan_id,
    cb.loan_balance,
    COALESCE(ab.a_balance, (0)::real) AS actual_balance,
    COALESCE(li.l_intrest, (0)::real) AS loan_intrest,
    COALESCE(lp.l_penalty, (0)::real) AS loan_penalty
   FROM (((( SELECT account_activity.loan_id,
            sum(((account_activity.account_debit - account_activity.account_credit) * account_activity.exchange_rate)) AS loan_balance
           FROM public.account_activity
          GROUP BY account_activity.loan_id) cb
     LEFT JOIN ( SELECT account_activity.loan_id,
            sum(((account_activity.account_debit - account_activity.account_credit) * account_activity.exchange_rate)) AS a_balance
           FROM public.account_activity
          WHERE (account_activity.activity_status_id < 3)
          GROUP BY account_activity.loan_id) ab ON ((cb.loan_id = ab.loan_id)))
     LEFT JOIN ( SELECT account_activity.loan_id,
            sum(((account_activity.account_debit - account_activity.account_credit) * account_activity.exchange_rate)) AS l_intrest
           FROM (public.account_activity
             JOIN public.activity_types ON ((account_activity.activity_type_id = activity_types.activity_type_id)))
          WHERE (activity_types.use_key_id = 105)
          GROUP BY account_activity.loan_id) li ON ((cb.loan_id = li.loan_id)))
     LEFT JOIN ( SELECT account_activity.loan_id,
            sum(((account_activity.account_debit - account_activity.account_credit) * account_activity.exchange_rate)) AS l_penalty
           FROM (public.account_activity
             JOIN public.activity_types ON ((account_activity.activity_type_id = activity_types.activity_type_id)))
          WHERE (activity_types.use_key_id = 106)
          GROUP BY account_activity.loan_id) lp ON ((cb.loan_id = lp.loan_id)));


ALTER TABLE public.vw_loan_balance OWNER TO postgres;

--
-- Name: vw_loans; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_loans AS
 SELECT members.member_id,
    members.member_name,
    members.business_account,
    vw_products.product_id,
    vw_products.product_name,
    vw_products.currency_id,
    vw_products.currency_name,
    vw_products.currency_symbol,
    activity_frequency.activity_frequency_id,
    activity_frequency.activity_frequency_name,
    loans.org_id,
    loans.loan_id,
    loans.account_number,
    loans.principal_amount,
    loans.interest_rate,
    loans.repayment_amount,
    loans.disbursed_date,
    loans.expected_matured_date,
    loans.matured_date,
    loans.repayment_period,
    loans.expected_repayment,
    loans.disburse_account,
    loans.loan_status,
    loans.application_date,
    loans.approve_status,
    loans.workflow_table_id,
    loans.action_date,
    loans.details,
    loans.is_collateral,
    loans.is_guaranteed,
    vw_loan_balance.loan_balance,
    vw_loan_balance.actual_balance,
    (vw_loan_balance.actual_balance - vw_loan_balance.loan_balance) AS committed_balance,
    vw_products.letter_head,
    loans.is_active
   FROM ((((public.loans
     JOIN public.members ON ((loans.member_id = members.member_id)))
     JOIN public.vw_products ON ((loans.product_id = vw_products.product_id)))
     JOIN public.activity_frequency ON ((loans.activity_frequency_id = activity_frequency.activity_frequency_id)))
     LEFT JOIN public.vw_loan_balance ON ((loans.loan_id = vw_loan_balance.loan_id)));


ALTER TABLE public.vw_loans OWNER TO postgres;

--
-- Name: vw_collaterals; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_collaterals AS
 SELECT vw_loans.member_id,
    vw_loans.member_name,
    vw_loans.product_id,
    vw_loans.product_name,
    vw_loans.loan_id,
    vw_loans.principal_amount,
    vw_loans.interest_rate,
    vw_loans.loan_status,
    vw_loans.activity_frequency_id,
    vw_loans.activity_frequency_name,
    vw_loans.disbursed_date,
    vw_loans.expected_matured_date,
    vw_loans.matured_date,
    collateral_types.collateral_type_id,
    collateral_types.collateral_type_name,
    collaterals.org_id,
    collaterals.collateral_id,
    collaterals.collateral_amount,
    collaterals.collateral_received,
    collaterals.collateral_released,
    collaterals.application_date,
    collaterals.approve_status,
    collaterals.workflow_table_id,
    collaterals.action_date,
    collaterals.details,
    vw_loans.letter_head
   FROM ((public.collaterals
     JOIN public.vw_loans ON ((collaterals.loan_id = vw_loans.loan_id)))
     JOIN public.collateral_types ON ((collaterals.collateral_type_id = collateral_types.collateral_type_id)));


ALTER TABLE public.vw_collaterals OWNER TO postgres;

--
-- Name: vw_commodity_summary; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_commodity_summary AS
 SELECT vw_deposit_accounts.member_id,
    vw_deposit_accounts.member_name,
    vw_deposit_accounts.business_account,
    vw_deposit_accounts.product_id,
    vw_deposit_accounts.product_name,
    vw_deposit_accounts.currency_id,
    vw_deposit_accounts.currency_name,
    vw_deposit_accounts.currency_symbol,
    vw_deposit_accounts.deposit_account_id,
    vw_deposit_accounts.account_number,
    vw_deposit_accounts.is_active,
    commoditys.commodity_id,
    commoditys.commodity_name,
    orgs.org_id,
    orgs.org_name,
    sum((commodity_trades.unit_credit - commodity_trades.unit_debit)) AS total_units,
    sum(((commodity_trades.unit_credit - commodity_trades.unit_debit) * commodity_trades.price)) AS total_value,
    vw_deposit_accounts.letter_head
   FROM (((public.commodity_trades
     JOIN public.vw_deposit_accounts ON ((commodity_trades.deposit_account_id = vw_deposit_accounts.deposit_account_id)))
     JOIN public.commoditys ON ((commodity_trades.commodity_id = commoditys.commodity_id)))
     JOIN public.orgs ON ((commodity_trades.org_id = orgs.org_id)))
  GROUP BY vw_deposit_accounts.member_id, vw_deposit_accounts.member_name, vw_deposit_accounts.business_account, vw_deposit_accounts.product_id, vw_deposit_accounts.product_name, vw_deposit_accounts.currency_id, vw_deposit_accounts.currency_name, vw_deposit_accounts.currency_symbol, vw_deposit_accounts.deposit_account_id, vw_deposit_accounts.account_number, vw_deposit_accounts.is_active, commoditys.commodity_id, commoditys.commodity_name, orgs.org_id, orgs.org_name, vw_deposit_accounts.letter_head;


ALTER TABLE public.vw_commodity_summary OWNER TO postgres;

--
-- Name: vw_commodity_trades; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_commodity_trades AS
 SELECT vw_deposit_accounts.member_id,
    vw_deposit_accounts.member_name,
    vw_deposit_accounts.business_account,
    vw_deposit_accounts.product_id,
    vw_deposit_accounts.product_name,
    vw_deposit_accounts.currency_id,
    vw_deposit_accounts.currency_name,
    vw_deposit_accounts.currency_symbol,
    vw_deposit_accounts.activity_frequency_id,
    vw_deposit_accounts.activity_frequency_name,
    vw_deposit_accounts.deposit_account_id,
    vw_deposit_accounts.account_number,
    vw_deposit_accounts.is_active,
    commoditys.commodity_id,
    commoditys.commodity_name,
    entitys.entity_id,
    entitys.entity_name,
    orgs.org_id,
    orgs.org_name,
    orgs.letter_head,
    commodity_trades.commodity_trade_id,
    commodity_trades.unit_debit,
    commodity_trades.unit_credit,
    commodity_trades.price,
    commodity_trades.trade_date,
    commodity_trades.application_date,
    commodity_trades.approve_status,
    commodity_trades.workflow_table_id,
    commodity_trades.action_date,
    commodity_trades.details,
    (commodity_trades.unit_debit * commodity_trades.price) AS trade_debit,
    (commodity_trades.unit_credit * commodity_trades.price) AS trade_credit
   FROM ((((public.commodity_trades
     JOIN public.vw_deposit_accounts ON ((commodity_trades.deposit_account_id = vw_deposit_accounts.deposit_account_id)))
     JOIN public.commoditys ON ((commodity_trades.commodity_id = commoditys.commodity_id)))
     JOIN public.entitys ON ((commodity_trades.entity_id = entitys.entity_id)))
     JOIN public.orgs ON ((commodity_trades.org_id = orgs.org_id)));


ALTER TABLE public.vw_commodity_trades OWNER TO postgres;

--
-- Name: vw_commoditys; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_commoditys AS
 SELECT commodity_types.commodity_type_id,
    commodity_types.commodity_type_name,
    orgs.org_id,
    orgs.org_name,
    orgs.letter_head,
    commoditys.commodity_id,
    commoditys.commodity_name,
    commoditys.commodity_account,
    commoditys.current_price,
    commoditys.details
   FROM ((public.commoditys
     JOIN public.commodity_types ON ((commoditys.commodity_type_id = commodity_types.commodity_type_id)))
     JOIN public.orgs ON ((commoditys.org_id = orgs.org_id)));


ALTER TABLE public.vw_commoditys OWNER TO postgres;

--
-- Name: vw_contracts; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_contracts AS
 SELECT vw_bidders.tender_type_id,
    vw_bidders.tender_type_name,
    vw_bidders.tender_id,
    vw_bidders.tender_name,
    vw_bidders.tender_number,
    vw_bidders.tender_date,
    vw_bidders.tender_end_date,
    vw_bidders.is_completed,
    vw_bidders.entity_id,
    vw_bidders.entity_name,
    vw_bidders.bidder_id,
    vw_bidders.tender_amount,
    vw_bidders.bind_bond,
    vw_bidders.bind_bond_amount,
    vw_bidders.return_date,
    vw_bidders.points,
    vw_bidders.is_awarded,
    vw_bidders.award_reference,
    contracts.org_id,
    contracts.contract_id,
    contracts.contract_name,
    contracts.contract_date,
    contracts.contract_end,
    contracts.contract_amount,
    contracts.contract_tax,
    contracts.details
   FROM (public.contracts
     JOIN public.vw_bidders ON ((contracts.bidder_id = vw_bidders.bidder_id)));


ALTER TABLE public.vw_contracts OWNER TO postgres;

--
-- Name: vw_curr_orgs; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_curr_orgs AS
 SELECT currency.currency_id AS base_currency_id,
    currency.currency_name AS base_currency_name,
    currency.currency_symbol AS base_currency_symbol,
    orgs.org_id,
    orgs.org_name,
    orgs.is_default,
    orgs.is_active,
    orgs.logo,
    orgs.cert_number,
    orgs.pin,
    orgs.vat_number,
    orgs.invoice_footer,
    orgs.details
   FROM (public.orgs
     JOIN public.currency ON ((orgs.currency_id = currency.currency_id)));


ALTER TABLE public.vw_curr_orgs OWNER TO postgres;

--
-- Name: vw_default_accounts; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_default_accounts AS
 SELECT vw_accounts.account_class_id,
    vw_accounts.chat_type_id,
    vw_accounts.chat_type_name,
    vw_accounts.account_class_name,
    vw_accounts.account_type_id,
    vw_accounts.account_type_name,
    vw_accounts.account_id,
    vw_accounts.account_no,
    vw_accounts.account_name,
    vw_accounts.is_header,
    vw_accounts.is_active,
    use_keys.use_key_id,
    use_keys.use_key_name,
    use_keys.use_function,
    default_accounts.default_account_id,
    default_accounts.org_id,
    default_accounts.narrative
   FROM ((public.vw_accounts
     JOIN public.default_accounts ON ((vw_accounts.account_id = default_accounts.account_id)))
     JOIN public.use_keys ON ((default_accounts.use_key_id = use_keys.use_key_id)));


ALTER TABLE public.vw_default_accounts OWNER TO postgres;

--
-- Name: vw_tax_types; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_tax_types AS
 SELECT vw_accounts.account_type_id,
    vw_accounts.account_type_name,
    vw_accounts.account_id,
    vw_accounts.account_name,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    use_keys.use_key_id,
    use_keys.use_key_name,
    use_keys.use_function,
    tax_types.org_id,
    tax_types.tax_type_id,
    tax_types.tax_type_name,
    tax_types.formural,
    tax_types.tax_relief,
    tax_types.tax_type_order,
    tax_types.in_tax,
    tax_types.tax_rate,
    tax_types.tax_inclusive,
    tax_types.linear,
    tax_types.percentage,
    tax_types.employer,
    tax_types.employer_ps,
    tax_types.account_number,
    tax_types.employer_account,
    tax_types.active,
    tax_types.tax_type_number,
    tax_types.employer_formural,
    tax_types.employer_relief,
    tax_types.details
   FROM (((public.tax_types
     JOIN public.currency ON ((tax_types.currency_id = currency.currency_id)))
     JOIN public.use_keys ON ((tax_types.use_key_id = use_keys.use_key_id)))
     LEFT JOIN public.vw_accounts ON ((tax_types.account_id = vw_accounts.account_id)));


ALTER TABLE public.vw_tax_types OWNER TO postgres;

--
-- Name: vw_default_tax_types; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_default_tax_types AS
 SELECT entitys.entity_id,
    entitys.entity_name,
    vw_tax_types.tax_type_id,
    vw_tax_types.tax_type_name,
    vw_tax_types.tax_type_number,
    vw_tax_types.currency_id,
    vw_tax_types.currency_name,
    vw_tax_types.currency_symbol,
    default_tax_types.default_tax_type_id,
    default_tax_types.org_id,
    default_tax_types.tax_identification,
    default_tax_types.active,
    default_tax_types.narrative
   FROM ((public.default_tax_types
     JOIN public.entitys ON ((default_tax_types.entity_id = entitys.entity_id)))
     JOIN public.vw_tax_types ON ((default_tax_types.tax_type_id = vw_tax_types.tax_type_id)));


ALTER TABLE public.vw_default_tax_types OWNER TO postgres;

--
-- Name: vw_departments; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_departments AS
 SELECT departments.ln_department_id,
    p_departments.department_name AS ln_department_name,
    departments.department_id,
    departments.org_id,
    departments.department_name,
    departments.active,
    departments.function_code,
    departments.petty_cash,
    departments.cost_center,
    departments.revenue_center,
    departments.description,
    departments.duties,
    departments.reports,
    departments.details
   FROM (public.departments
     LEFT JOIN public.departments p_departments ON ((departments.ln_department_id = p_departments.department_id)));


ALTER TABLE public.vw_departments OWNER TO postgres;

--
-- Name: vw_e_fields; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_e_fields AS
 SELECT orgs.org_id,
    orgs.org_name,
    et_fields.et_field_id,
    et_fields.et_field_name,
    et_fields.table_name,
    et_fields.table_link,
    e_fields.e_field_id,
    e_fields.table_code,
    e_fields.table_id,
    e_fields.e_field_value
   FROM ((public.e_fields
     JOIN public.orgs ON ((e_fields.org_id = orgs.org_id)))
     JOIN public.et_fields ON ((e_fields.et_field_id = et_fields.et_field_id)));


ALTER TABLE public.vw_e_fields OWNER TO postgres;

--
-- Name: vw_entity_accounts; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_entity_accounts AS
 SELECT vw_deposit_accounts.member_id,
    vw_deposit_accounts.member_name,
    vw_deposit_accounts.business_account,
    vw_deposit_accounts.product_id,
    vw_deposit_accounts.product_name,
    vw_deposit_accounts.letter_head,
    vw_deposit_accounts.currency_id,
    vw_deposit_accounts.currency_name,
    vw_deposit_accounts.currency_symbol,
    vw_deposit_accounts.activity_frequency_id,
    vw_deposit_accounts.activity_frequency_name,
    vw_deposit_accounts.org_id,
    vw_deposit_accounts.deposit_account_id,
    vw_deposit_accounts.is_active,
    vw_deposit_accounts.account_number,
    vw_deposit_accounts.narrative,
    vw_deposit_accounts.last_closing_date,
    vw_deposit_accounts.credit_limit,
    vw_deposit_accounts.minimum_balance,
    vw_deposit_accounts.maximum_balance,
    vw_deposit_accounts.interest_rate,
    vw_deposit_accounts.lockin_period_frequency,
    vw_deposit_accounts.opening_date,
    vw_deposit_accounts.lockedin_until_date,
    vw_deposit_accounts.application_date,
    vw_deposit_accounts.approve_status,
    vw_deposit_accounts.workflow_table_id,
    vw_deposit_accounts.action_date,
    vw_deposit_accounts.details,
    vw_deposit_accounts.current_balance,
    vw_deposit_accounts.cleared_balance,
    vw_deposit_accounts.unprocessed_credit,
    vw_deposit_accounts.available_balance,
    entitys.entity_id,
    entitys.user_name,
    entitys.entity_name,
    (((((((vw_deposit_accounts.product_name)::text || ', '::text) || (vw_deposit_accounts.account_number)::text) || ', '::text) || (vw_deposit_accounts.currency_symbol)::text) || ', '::text) || btrim(to_char(COALESCE(vw_deposit_accounts.available_balance, (0)::real), '999,999,999,999'::text))) AS deposit_account_disp,
    vw_deposit_accounts.product_no
   FROM (public.vw_deposit_accounts
     JOIN public.entitys ON ((vw_deposit_accounts.member_id = entitys.member_id)));


ALTER TABLE public.vw_entity_accounts OWNER TO postgres;

--
-- Name: vw_entity_address; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_entity_address AS
 SELECT vw_address.address_id,
    vw_address.address_name,
    vw_address.sys_country_id,
    vw_address.sys_country_name,
    vw_address.table_id,
    vw_address.table_name,
    vw_address.is_default,
    vw_address.post_office_box,
    vw_address.postal_code,
    vw_address.premises,
    vw_address.street,
    vw_address.town,
    vw_address.phone_number,
    vw_address.extension,
    vw_address.mobile,
    vw_address.fax,
    vw_address.email,
    vw_address.website
   FROM public.vw_address
  WHERE (((vw_address.table_name)::text = 'entitys'::text) AND (vw_address.is_default = true));


ALTER TABLE public.vw_entity_address OWNER TO postgres;

--
-- Name: vw_entity_loans; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_entity_loans AS
 SELECT vw_loans.member_id,
    vw_loans.member_name,
    vw_loans.business_account,
    vw_loans.product_id,
    vw_loans.product_name,
    vw_loans.loan_status,
    vw_loans.currency_id,
    vw_loans.currency_name,
    vw_loans.currency_symbol,
    vw_loans.activity_frequency_id,
    vw_loans.activity_frequency_name,
    vw_loans.org_id,
    vw_loans.loan_id,
    vw_loans.account_number,
    vw_loans.principal_amount,
    vw_loans.interest_rate,
    vw_loans.repayment_amount,
    vw_loans.disbursed_date,
    vw_loans.expected_matured_date,
    vw_loans.matured_date,
    vw_loans.repayment_period,
    vw_loans.expected_repayment,
    vw_loans.disburse_account,
    vw_loans.application_date,
    vw_loans.approve_status,
    vw_loans.workflow_table_id,
    vw_loans.action_date,
    vw_loans.details,
    vw_loans.is_guaranteed,
    vw_loans.is_collateral,
    vw_loans.loan_balance,
    vw_loans.actual_balance,
    vw_loans.committed_balance,
    entitys.entity_id,
    entitys.user_name,
    entitys.entity_name,
    vw_loans.letter_head,
    vw_loans.is_active
   FROM (public.vw_loans
     JOIN public.entitys ON ((vw_loans.member_id = entitys.member_id)));


ALTER TABLE public.vw_entity_loans OWNER TO postgres;

--
-- Name: vw_entity_orgs; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_entity_orgs AS
 SELECT entitys.entity_id,
    entitys.entity_name,
    entitys.user_name,
    entitys.super_user,
    entitys.entity_leader,
    entitys.date_enroled,
    entitys.is_active,
    entitys.entity_password,
    entitys.first_password,
    entitys.function_role,
    entitys.use_key_id,
    entitys.primary_email,
    entitys.primary_telephone,
    orgs.org_id,
    orgs.org_name,
    orgs.org_full_name,
    entity_orgs.entity_org_id,
    entity_orgs.details
   FROM ((public.entity_orgs
     JOIN public.entitys ON ((entitys.entity_id = entity_orgs.entity_id)))
     JOIN public.orgs ON ((entity_orgs.org_id = orgs.org_id)));


ALTER TABLE public.vw_entity_orgs OWNER TO postgres;

--
-- Name: vw_entity_subscriptions; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_entity_subscriptions AS
 SELECT entity_types.entity_type_id,
    entity_types.entity_type_name,
    entitys.entity_id,
    entitys.entity_name,
    entity_subscriptions.entity_subscription_id,
    entity_subscriptions.org_id,
    entity_subscriptions.details
   FROM ((public.entity_subscriptions
     JOIN public.entity_types ON ((entity_subscriptions.entity_type_id = entity_types.entity_type_id)))
     JOIN public.entitys ON ((entity_subscriptions.entity_id = entitys.entity_id)));


ALTER TABLE public.vw_entity_subscriptions OWNER TO postgres;

--
-- Name: vw_entity_types; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_entity_types AS
 SELECT use_keys.use_key_id,
    use_keys.use_key_name,
    use_keys.use_function,
    entity_types.entity_type_id,
    entity_types.org_id,
    entity_types.entity_type_name,
    entity_types.entity_role,
    entity_types.start_view,
    entity_types.group_email,
    entity_types.description,
    entity_types.details
   FROM (public.use_keys
     JOIN public.entity_types ON ((use_keys.use_key_id = entity_types.use_key_id)));


ALTER TABLE public.vw_entity_types OWNER TO postgres;

--
-- Name: vw_entity_values; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_entity_values AS
 SELECT entitys.entity_id,
    entitys.entity_name,
    entity_fields.entity_field_id,
    entity_fields.entity_field_name,
    entity_values.org_id,
    entity_values.entity_value_id,
    entity_values.entity_value
   FROM ((public.entity_values
     JOIN public.entitys ON ((entity_values.entity_id = entitys.entity_id)))
     JOIN public.entity_fields ON ((entity_values.entity_field_id = entity_fields.entity_field_id)));


ALTER TABLE public.vw_entity_values OWNER TO postgres;

--
-- Name: vw_org_address; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_org_address AS
 SELECT vw_address.sys_country_id AS org_sys_country_id,
    vw_address.sys_country_name AS org_sys_country_name,
    vw_address.address_id AS org_address_id,
    vw_address.table_id AS org_table_id,
    vw_address.table_name AS org_table_name,
    vw_address.post_office_box AS org_post_office_box,
    vw_address.postal_code AS org_postal_code,
    vw_address.premises AS org_premises,
    vw_address.street AS org_street,
    vw_address.town AS org_town,
    vw_address.phone_number AS org_phone_number,
    vw_address.extension AS org_extension,
    vw_address.mobile AS org_mobile,
    vw_address.fax AS org_fax,
    vw_address.email AS org_email,
    vw_address.website AS org_website
   FROM public.vw_address
  WHERE (((vw_address.table_name)::text = 'orgs'::text) AND (vw_address.is_default = true));


ALTER TABLE public.vw_org_address OWNER TO postgres;

--
-- Name: vw_orgs; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_orgs AS
 SELECT orgs.org_id,
    orgs.org_name,
    orgs.is_default,
    orgs.is_active,
    orgs.logo,
    orgs.org_full_name,
    orgs.pin,
    orgs.pcc,
    orgs.details,
    orgs.cert_number,
    orgs.vat_number,
    orgs.invoice_footer,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    vw_org_address.org_sys_country_id,
    vw_org_address.org_sys_country_name,
    vw_org_address.org_address_id,
    vw_org_address.org_table_name,
    vw_org_address.org_post_office_box,
    vw_org_address.org_postal_code,
    vw_org_address.org_premises,
    vw_org_address.org_street,
    vw_org_address.org_town,
    vw_org_address.org_phone_number,
    vw_org_address.org_extension,
    vw_org_address.org_mobile,
    vw_org_address.org_fax,
    vw_org_address.org_email,
    vw_org_address.org_website
   FROM ((public.orgs
     JOIN public.currency ON ((orgs.currency_id = currency.currency_id)))
     LEFT JOIN public.vw_org_address ON ((orgs.org_id = vw_org_address.org_table_id)));


ALTER TABLE public.vw_orgs OWNER TO postgres;

--
-- Name: vw_entitys; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_entitys AS
 SELECT vw_orgs.org_id,
    vw_orgs.org_name,
    vw_orgs.is_default AS org_is_default,
    vw_orgs.is_active AS org_is_active,
    vw_orgs.logo AS org_logo,
    vw_orgs.cert_number AS org_cert_number,
    vw_orgs.pin AS org_pin,
    vw_orgs.vat_number AS org_vat_number,
    vw_orgs.invoice_footer AS org_invoice_footer,
    vw_orgs.org_sys_country_id,
    vw_orgs.org_sys_country_name,
    vw_orgs.org_address_id,
    vw_orgs.org_table_name,
    vw_orgs.org_post_office_box,
    vw_orgs.org_postal_code,
    vw_orgs.org_premises,
    vw_orgs.org_street,
    vw_orgs.org_town,
    vw_orgs.org_phone_number,
    vw_orgs.org_extension,
    vw_orgs.org_mobile,
    vw_orgs.org_fax,
    vw_orgs.org_email,
    vw_orgs.org_website,
    addr.address_id,
    addr.address_name,
    addr.sys_country_id,
    addr.sys_country_name,
    addr.table_name,
    addr.is_default,
    addr.post_office_box,
    addr.postal_code,
    addr.premises,
    addr.street,
    addr.town,
    addr.phone_number,
    addr.extension,
    addr.mobile,
    addr.fax,
    addr.email,
    addr.website,
    entity_types.entity_type_id,
    entity_types.entity_type_name,
    entity_types.entity_role,
    entitys.entity_id,
    entitys.use_key_id,
    entitys.entity_name,
    entitys.user_name,
    entitys.super_user,
    entitys.entity_leader,
    entitys.date_enroled,
    entitys.is_active,
    entitys.entity_password,
    entitys.first_password,
    entitys.function_role,
    entitys.attention,
    entitys.primary_email,
    entitys.primary_telephone,
    entitys.credit_limit
   FROM (((public.entitys
     LEFT JOIN public.vw_address_entitys addr ON ((entitys.entity_id = addr.table_id)))
     JOIN public.vw_orgs ON ((entitys.org_id = vw_orgs.org_id)))
     JOIN public.entity_types ON ((entitys.entity_type_id = entity_types.entity_type_id)));


ALTER TABLE public.vw_entitys OWNER TO postgres;

--
-- Name: vw_entry_forms; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_entry_forms AS
 SELECT entitys.entity_id,
    entitys.entity_name,
    forms.form_id,
    forms.form_name,
    forms.form_number,
    forms.completed,
    forms.is_active,
    forms.use_key,
    entry_forms.org_id,
    entry_forms.entry_form_id,
    entry_forms.approve_status,
    entry_forms.application_date,
    entry_forms.completion_date,
    entry_forms.action_date,
    entry_forms.narrative,
    entry_forms.answer,
    entry_forms.workflow_table_id,
    entry_forms.details
   FROM ((public.entry_forms
     JOIN public.entitys ON ((entry_forms.entity_id = entitys.entity_id)))
     JOIN public.forms ON ((entry_forms.form_id = forms.form_id)));


ALTER TABLE public.vw_entry_forms OWNER TO postgres;

--
-- Name: vw_issue_definitions; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_issue_definitions AS
 SELECT issue_types.issue_type_id,
    issue_types.issue_type_name,
    issue_definitions.org_id,
    issue_definitions.issue_definition_id,
    issue_definitions.issue_definition_name,
    issue_definitions.description,
    issue_definitions.solution,
    (((issue_types.issue_type_name)::text || ' - '::text) || (issue_definitions.issue_definition_name)::text) AS issue_definition_disp
   FROM (public.issue_definitions
     JOIN public.issue_types ON ((issue_definitions.issue_type_id = issue_types.issue_type_id)));


ALTER TABLE public.vw_issue_definitions OWNER TO postgres;

--
-- Name: vw_helpdesk_issues; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_helpdesk_issues AS
 SELECT vw_issue_definitions.issue_type_id,
    vw_issue_definitions.issue_type_name,
    vw_issue_definitions.issue_definition_id,
    vw_issue_definitions.issue_definition_name,
    issue_levels.issue_level_id,
    issue_levels.issue_level_name,
    helpdesk.recorded_by,
    recorder.entity_name AS recorder_name,
    helpdesk.org_id,
    helpdesk.helpdesk_id,
    helpdesk.description,
    helpdesk.recoded_time,
    helpdesk.solved_time,
    helpdesk.is_solved,
    helpdesk.curr_action,
    helpdesk.curr_status,
    helpdesk.problem,
    helpdesk.solution,
    helpdesk.closed_by,
    closer.entity_name AS closer_name,
    helpdesk.escalated_to,
    escalated_to.entity_name AS escalated_to_name,
    helpdesk.is_escalated,
    helpdesk.escalated_by,
    escalated_by.entity_name AS escalated_by_name,
    helpdesk.escalated_time,
    members.member_id,
    members.member_name,
    members.telephone_number,
    members.member_email
   FROM (((((((public.helpdesk
     JOIN public.vw_issue_definitions ON ((helpdesk.issue_definition_id = vw_issue_definitions.issue_definition_id)))
     JOIN public.issue_levels ON ((helpdesk.issue_level_id = issue_levels.issue_level_id)))
     JOIN public.entitys recorder ON ((helpdesk.recorded_by = recorder.entity_id)))
     JOIN public.members ON ((helpdesk.member_id = members.member_id)))
     LEFT JOIN public.entitys closer ON ((helpdesk.closed_by = closer.entity_id)))
     LEFT JOIN public.entitys escalated_to ON ((helpdesk.escalated_to = escalated_to.entity_id)))
     LEFT JOIN public.entitys escalated_by ON ((helpdesk.escalated_by = escalated_by.entity_id)));


ALTER TABLE public.vw_helpdesk_issues OWNER TO postgres;

--
-- Name: vw_escalated_issues; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_escalated_issues AS
 SELECT vw_helpdesk_issues.issue_type_id,
    vw_helpdesk_issues.issue_type_name,
    vw_helpdesk_issues.issue_definition_id,
    vw_helpdesk_issues.issue_definition_name,
    vw_helpdesk_issues.issue_level_id,
    vw_helpdesk_issues.issue_level_name,
    vw_helpdesk_issues.recorded_by,
    vw_helpdesk_issues.recorder_name,
    vw_helpdesk_issues.org_id,
    vw_helpdesk_issues.helpdesk_id,
    vw_helpdesk_issues.description,
    vw_helpdesk_issues.recoded_time,
    vw_helpdesk_issues.is_solved,
    vw_helpdesk_issues.escalated_time,
    vw_helpdesk_issues.curr_action,
    vw_helpdesk_issues.curr_status,
    vw_helpdesk_issues.problem,
    vw_helpdesk_issues.solution,
    vw_helpdesk_issues.escalated_to,
    vw_helpdesk_issues.escalated_to_name,
    vw_helpdesk_issues.is_escalated,
    vw_helpdesk_issues.escalated_by,
    vw_helpdesk_issues.escalated_by_name,
    vw_helpdesk_issues.member_name,
    vw_helpdesk_issues.telephone_number,
    vw_helpdesk_issues.member_email,
    entitys.entity_id
   FROM (public.vw_helpdesk_issues
     JOIN public.entitys ON ((vw_helpdesk_issues.escalated_to = entitys.entity_id)));


ALTER TABLE public.vw_escalated_issues OWNER TO postgres;

--
-- Name: vw_fields; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_fields AS
 SELECT forms.form_id,
    forms.form_name,
    fields.field_id,
    fields.org_id,
    fields.question,
    fields.field_lookup,
    fields.field_type,
    fields.field_order,
    fields.share_line,
    fields.field_size,
    fields.field_fnct,
    fields.manditory,
    fields.field_bold,
    fields.field_italics
   FROM (public.fields
     JOIN public.forms ON ((fields.form_id = forms.form_id)));


ALTER TABLE public.vw_fields OWNER TO postgres;

--
-- Name: vw_sacco_officials; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_sacco_officials AS
 SELECT position_levels.position_level_name,
    sacco_officials.sacco_official_id,
    sacco_officials.position_level_id,
    sacco_officials.org_id,
    sacco_officials.member_id,
    sacco_officials.start_date,
    sacco_officials.end_date,
    sacco_officials.term_limit,
    sacco_officials.is_active,
    sacco_officials.narrative,
    sacco_officials.details,
    members.member_name,
    members.identification_number,
    members.identification_type,
    members.member_email,
    members.telephone_number,
    members.telephone_number2,
    members.address,
    members.town,
    members.zip_code,
    entitys.entity_id
   FROM (((public.sacco_officials
     JOIN public.position_levels ON ((position_levels.position_level_id = sacco_officials.position_level_id)))
     JOIN public.members ON ((members.member_id = sacco_officials.member_id)))
     JOIN public.entitys ON ((entitys.member_id = sacco_officials.member_id)));


ALTER TABLE public.vw_sacco_officials OWNER TO postgres;

--
-- Name: vw_loan_approval; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_loan_approval AS
 SELECT loan_approval.loan_approval_id,
    loan_approval.sacco_official_id,
    loan_approval.org_id,
    loan_approval.processing_approval,
    loan_approval.final_approval,
    loan_approval.is_active,
    loan_approval.narrative,
    loan_approval.details,
    vw_sacco_officials.position_level_name,
    vw_sacco_officials.position_level_id,
    vw_sacco_officials.member_id,
    vw_sacco_officials.start_date,
    vw_sacco_officials.end_date,
    vw_sacco_officials.term_limit,
    vw_sacco_officials.member_name,
    vw_sacco_officials.identification_number,
    vw_sacco_officials.identification_type,
    vw_sacco_officials.member_email,
    vw_sacco_officials.telephone_number,
    vw_sacco_officials.telephone_number2,
    vw_sacco_officials.address,
    vw_sacco_officials.town,
    vw_sacco_officials.zip_code,
    vw_sacco_officials.entity_id
   FROM (public.vw_sacco_officials
     JOIN public.loan_approval ON ((loan_approval.sacco_official_id = vw_sacco_officials.sacco_official_id)));


ALTER TABLE public.vw_loan_approval OWNER TO postgres;

--
-- Name: vw_final_loan_approval; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_final_loan_approval AS
 SELECT loan_approval_levels.loan_approval_level_id,
    loan_approval_levels.org_id,
    loan_approval_levels.loan_approval_id,
    loan_approval_levels.loan_id,
    loan_approval_levels.is_approved,
    loan_approval_levels.approved_time,
    loan_approval_levels.entity_id AS approved_by,
    loan_approval_levels.narrative,
    loan_approval_levels.details,
    vw_loans.member_id,
    vw_loans.member_name,
    vw_loans.business_account,
    vw_loans.product_id,
    vw_loans.product_name,
    vw_loans.currency_id,
    vw_loans.currency_name,
    vw_loans.currency_symbol,
    vw_loans.account_number,
    vw_loans.principal_amount,
    vw_loans.interest_rate,
    vw_loans.repayment_amount,
    vw_loans.disbursed_date,
    vw_loans.repayment_period,
    vw_loans.expected_repayment,
    vw_loans.disburse_account,
    vw_loans.loan_status,
    vw_loan_approval.sacco_official_id,
    vw_loan_approval.processing_approval,
    vw_loan_approval.final_approval,
    vw_loan_approval.is_active,
    vw_loan_approval.position_level_name,
    vw_loan_approval.member_name AS official_name,
    vw_loan_approval.entity_id,
    loan_approval_levels.status
   FROM ((public.loan_approval_levels
     JOIN public.vw_loan_approval ON ((vw_loan_approval.loan_approval_id = loan_approval_levels.loan_approval_id)))
     JOIN public.vw_loans ON ((vw_loans.loan_id = loan_approval_levels.loan_id)));


ALTER TABLE public.vw_final_loan_approval OWNER TO postgres;

--
-- Name: vw_leads; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_leads AS
 SELECT entitys.entity_id,
    entitys.entity_name,
    industry.industry_id,
    industry.industry_name,
    lead_categorys.lead_category_id,
    lead_categorys.use_key_id,
    lead_categorys.lead_category_name,
    sys_countrys.sys_country_id,
    sys_countrys.sys_country_name,
    leads.org_id,
    leads.lead_id,
    leads.business_name,
    leads.business_address,
    leads.city,
    leads.state,
    leads.country_id,
    leads.number_of_employees,
    leads.telephone,
    leads.website,
    leads.primary_contact,
    leads.job_title,
    leads.primary_email,
    leads.prospect_level,
    leads.contact_date,
    leads.details
   FROM ((((public.leads
     JOIN public.entitys ON ((leads.entity_id = entitys.entity_id)))
     JOIN public.industry ON ((leads.industry_id = industry.industry_id)))
     JOIN public.lead_categorys ON ((leads.lead_category_id = lead_categorys.lead_category_id)))
     JOIN public.sys_countrys ON ((leads.country_id = sys_countrys.sys_country_id)));


ALTER TABLE public.vw_leads OWNER TO postgres;

--
-- Name: vw_lead_items; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_lead_items AS
 SELECT entitys.entity_id,
    entitys.entity_name,
    items.item_id,
    items.item_name,
    vw_leads.industry_id,
    vw_leads.industry_name,
    vw_leads.lead_category_id,
    vw_leads.lead_category_name,
    vw_leads.sys_country_id,
    vw_leads.sys_country_name,
    vw_leads.lead_id,
    vw_leads.business_name,
    vw_leads.business_address,
    vw_leads.city,
    vw_leads.state,
    vw_leads.country_id,
    vw_leads.number_of_employees,
    vw_leads.telephone,
    vw_leads.website,
    vw_leads.primary_contact,
    vw_leads.job_title,
    vw_leads.primary_email,
    vw_leads.prospect_level,
    vw_leads.contact_date,
    lead_items.org_id,
    lead_items.lead_item_id,
    lead_items.pitch_date,
    lead_items.units,
    lead_items.price,
    lead_items.lead_level,
    lead_items.narrative,
    lead_items.details,
    ((lead_items.units)::double precision * lead_items.price) AS lead_value
   FROM (((public.lead_items
     JOIN public.vw_leads ON ((lead_items.lead_id = vw_leads.lead_id)))
     JOIN public.entitys ON ((lead_items.entity_id = entitys.entity_id)))
     JOIN public.items ON ((lead_items.item_id = items.item_id)));


ALTER TABLE public.vw_lead_items OWNER TO postgres;

--
-- Name: vw_follow_up; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_follow_up AS
 SELECT vw_lead_items.item_id,
    vw_lead_items.item_name,
    vw_lead_items.industry_id,
    vw_lead_items.industry_name,
    vw_lead_items.sys_country_id,
    vw_lead_items.sys_country_name,
    vw_lead_items.lead_id,
    vw_lead_items.business_name,
    vw_lead_items.business_address,
    vw_lead_items.city,
    vw_lead_items.state,
    vw_lead_items.country_id,
    vw_lead_items.number_of_employees,
    vw_lead_items.telephone,
    vw_lead_items.website,
    vw_lead_items.primary_contact,
    vw_lead_items.job_title,
    vw_lead_items.primary_email,
    vw_lead_items.prospect_level,
    vw_lead_items.contact_date,
    vw_lead_items.lead_item_id,
    vw_lead_items.pitch_date,
    vw_lead_items.units,
    vw_lead_items.price,
    vw_lead_items.lead_value,
    vw_lead_items.lead_level,
    entitys.entity_id,
    entitys.entity_name,
    follow_up.org_id,
    follow_up.follow_up_id,
    follow_up.create_time,
    follow_up.follow_date,
    follow_up.follow_time,
    follow_up.done,
    follow_up.narrative,
    follow_up.details
   FROM ((public.follow_up
     JOIN public.vw_lead_items ON ((follow_up.lead_item_id = vw_lead_items.lead_item_id)))
     JOIN public.entitys ON ((follow_up.entity_id = entitys.entity_id)));


ALTER TABLE public.vw_follow_up OWNER TO postgres;

--
-- Name: vw_journals; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_journals AS
 SELECT vw_periods.fiscal_year_id,
    vw_periods.fiscal_year_start,
    vw_periods.fiscal_year_end,
    vw_periods.year_opened,
    vw_periods.year_closed,
    vw_periods.period_id,
    vw_periods.start_date,
    vw_periods.end_date,
    vw_periods.opened,
    vw_periods.closed,
    vw_periods.month_id,
    vw_periods.period_year,
    vw_periods.period_month,
    vw_periods.quarter,
    vw_periods.semister,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    departments.department_id,
    departments.department_name,
    journals.journal_id,
    journals.org_id,
    journals.journal_date,
    journals.posted,
    journals.year_closing,
    journals.narrative,
    journals.exchange_rate,
    journals.details
   FROM (((public.journals
     JOIN public.vw_periods ON ((journals.period_id = vw_periods.period_id)))
     JOIN public.currency ON ((journals.currency_id = currency.currency_id)))
     LEFT JOIN public.departments ON ((journals.department_id = departments.department_id)));


ALTER TABLE public.vw_journals OWNER TO postgres;

--
-- Name: vw_gls; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_gls AS
 SELECT vw_accounts.account_class_id,
    vw_accounts.account_class_no,
    vw_accounts.account_class_name,
    vw_accounts.chat_type_id,
    vw_accounts.chat_type_name,
    vw_accounts.account_type_id,
    vw_accounts.account_type_no,
    vw_accounts.account_type_name,
    vw_accounts.account_id,
    vw_accounts.account_no,
    vw_accounts.account_name,
    vw_accounts.is_header,
    vw_accounts.is_active,
    vw_journals.fiscal_year_id,
    vw_journals.fiscal_year_start,
    vw_journals.fiscal_year_end,
    vw_journals.year_opened,
    vw_journals.year_closed,
    vw_journals.period_id,
    vw_journals.start_date,
    vw_journals.end_date,
    vw_journals.opened,
    vw_journals.closed,
    vw_journals.month_id,
    vw_journals.period_year,
    vw_journals.period_month,
    vw_journals.quarter,
    vw_journals.semister,
    vw_journals.currency_id,
    vw_journals.currency_name,
    vw_journals.currency_symbol,
    vw_journals.exchange_rate,
    vw_journals.journal_id,
    vw_journals.journal_date,
    vw_journals.posted,
    vw_journals.year_closing,
    vw_journals.narrative,
    gls.gl_id,
    gls.org_id,
    gls.debit,
    gls.credit,
    gls.gl_narrative,
    (gls.debit * vw_journals.exchange_rate) AS base_debit,
    (gls.credit * vw_journals.exchange_rate) AS base_credit
   FROM ((public.gls
     JOIN public.vw_accounts ON ((gls.account_id = vw_accounts.account_id)))
     JOIN public.vw_journals ON ((gls.journal_id = vw_journals.journal_id)));


ALTER TABLE public.vw_gls OWNER TO postgres;

--
-- Name: vw_guarantees; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_guarantees AS
 SELECT vw_loans.member_id,
    vw_loans.member_name,
    vw_loans.product_id,
    vw_loans.product_name,
    vw_loans.loan_id,
    vw_loans.principal_amount,
    vw_loans.interest_rate,
    vw_loans.activity_frequency_id,
    vw_loans.activity_frequency_name,
    vw_loans.loan_status,
    vw_loans.disbursed_date,
    vw_loans.expected_matured_date,
    vw_loans.matured_date,
    members.member_id AS guarantor_id,
    members.member_name AS guarantor_name,
    guarantees.org_id,
    guarantees.guarantee_id,
    guarantees.guarantee_amount,
    guarantees.guarantee_accepted,
    guarantees.accepted_date,
    guarantees.application_date,
    guarantees.is_active,
    guarantees.approve_status,
    guarantees.workflow_table_id,
    guarantees.action_date,
    guarantees.details,
    vw_loans.repayment_period,
    vw_loans.letter_head
   FROM ((public.guarantees
     JOIN public.vw_loans ON ((guarantees.loan_id = vw_loans.loan_id)))
     JOIN public.members ON ((guarantees.member_id = members.member_id)));


ALTER TABLE public.vw_guarantees OWNER TO postgres;

--
-- Name: vw_guarantees_request; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_guarantees_request AS
 SELECT vw_guarantees.member_id,
    vw_guarantees.member_name,
    vw_guarantees.product_id,
    vw_guarantees.product_name,
    vw_guarantees.loan_id,
    vw_guarantees.principal_amount,
    vw_guarantees.interest_rate,
    vw_guarantees.activity_frequency_id,
    vw_guarantees.activity_frequency_name,
    vw_guarantees.disbursed_date,
    vw_guarantees.expected_matured_date,
    vw_guarantees.matured_date,
    vw_guarantees.loan_status,
    vw_guarantees.guarantor_id,
    vw_guarantees.repayment_period,
    vw_guarantees.guarantor_name,
    vw_guarantees.org_id,
    vw_guarantees.guarantee_id,
    vw_guarantees.guarantee_amount,
    vw_guarantees.guarantee_accepted,
    vw_guarantees.accepted_date,
    vw_guarantees.application_date,
    vw_guarantees.details,
    entitys.entity_id,
    entitys.primary_email,
    entitys.primary_telephone,
    entitys.is_active,
    vw_guarantees.is_active AS active_guarantee,
    vw_guarantees.letter_head
   FROM (public.vw_guarantees
     JOIN public.entitys ON ((entitys.member_id = vw_guarantees.guarantor_id)));


ALTER TABLE public.vw_guarantees_request OWNER TO postgres;

--
-- Name: vw_investments; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_investments AS
 SELECT investment_types.investment_type_id,
    investment_types.investment_type_name,
    investment_status.investment_status_id,
    investment_status.investment_status_name,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    entitys.entity_id,
    entitys.entity_name,
    investments.org_id,
    investments.investment_id,
    investments.investment_name,
    investments.started_date,
    investments.expected_maturity,
    investments.exchange_rate,
    investments.proposed_capital,
    investments.expected_profit,
    investments.initial_payment,
    investments.monthly_payments,
    investments.monthly_returns,
    investments.is_active,
    investments.is_completed,
    investments.application_date,
    investments.approve_status,
    investments.workflow_table_id,
    investments.action_date,
    investments.details
   FROM ((((public.investments
     JOIN public.investment_types ON ((investments.investment_type_id = investment_types.investment_type_id)))
     JOIN public.investment_status ON ((investments.investment_status_id = investment_status.investment_status_id)))
     JOIN public.currency ON ((investments.currency_id = currency.currency_id)))
     JOIN public.entitys ON ((investments.entity_id = entitys.entity_id)));


ALTER TABLE public.vw_investments OWNER TO postgres;

--
-- Name: vw_kins; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_kins AS
 SELECT orgs.org_name,
    orgs.letter_head,
    members.member_id,
    members.member_name,
    entitys.entity_id,
    kin_types.kin_type_id,
    kin_types.kin_type_name,
    kin_types.spouse,
    kins.org_id,
    kins.kin_id,
    kins.full_names,
    kins.date_of_birth,
    kins.identification,
    kins.identification_type,
    kins.emergency_contact,
    kins.beneficiary,
    kins.beneficiary_ps,
    kins.details
   FROM ((((public.kins
     JOIN public.members ON ((kins.member_id = members.member_id)))
     JOIN public.entitys ON ((kins.member_id = entitys.member_id)))
     JOIN public.kin_types ON ((kins.kin_type_id = kin_types.kin_type_id)))
     JOIN public.orgs ON ((orgs.org_id = kins.org_id)));


ALTER TABLE public.vw_kins OWNER TO postgres;

--
-- Name: vw_kins_member; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_kins_member AS
 SELECT members.member_id,
    members.member_name,
    orgs.org_name,
    orgs.letter_head,
    kin_types.kin_type_id,
    kin_types.kin_type_name,
    kin_types.spouse,
    kins.org_id,
    kins.kin_id,
    kins.full_names,
    kins.date_of_birth,
    kins.identification,
    kins.identification_type,
    kins.emergency_contact,
    kins.beneficiary,
    kins.beneficiary_ps,
    kins.details,
    entitys.entity_id
   FROM ((((public.kins
     JOIN public.members ON ((kins.member_id = members.member_id)))
     JOIN public.kin_types ON ((kins.kin_type_id = kin_types.kin_type_id)))
     JOIN public.orgs ON ((orgs.org_id = kins.org_id)))
     JOIN public.entitys ON ((entitys.member_id = kins.member_id)));


ALTER TABLE public.vw_kins_member OWNER TO postgres;

--
-- Name: vw_kins_p; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_kins_p AS
 SELECT members.member_id,
    members.member_name,
    orgs.org_name,
    orgs.letter_head,
    kin_types.kin_type_id,
    kin_types.kin_type_name,
    kin_types.spouse,
    kins.org_id,
    kins.kin_id,
    kins.full_names,
    kins.date_of_birth,
    kins.identification,
    kins.identification_type,
    kins.emergency_contact,
    kins.beneficiary,
    kins.beneficiary_ps,
    kins.details
   FROM (((public.kins
     JOIN public.members ON ((kins.member_id = members.member_id)))
     JOIN public.kin_types ON ((kins.kin_type_id = kin_types.kin_type_id)))
     JOIN public.orgs ON ((orgs.org_id = kins.org_id)));


ALTER TABLE public.vw_kins_p OWNER TO postgres;

--
-- Name: vw_sm_gls; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_sm_gls AS
 SELECT vw_gls.org_id,
    vw_gls.account_class_id,
    vw_gls.account_class_no,
    vw_gls.account_class_name,
    vw_gls.chat_type_id,
    vw_gls.chat_type_name,
    vw_gls.account_type_id,
    vw_gls.account_type_no,
    vw_gls.account_type_name,
    vw_gls.account_id,
    vw_gls.account_no,
    vw_gls.account_name,
    vw_gls.is_header,
    vw_gls.is_active,
    vw_gls.fiscal_year_id,
    vw_gls.fiscal_year_start,
    vw_gls.fiscal_year_end,
    vw_gls.year_opened,
    vw_gls.year_closed,
    vw_gls.period_id,
    vw_gls.start_date,
    vw_gls.end_date,
    vw_gls.opened,
    vw_gls.closed,
    vw_gls.month_id,
    vw_gls.period_year,
    vw_gls.period_month,
    vw_gls.quarter,
    vw_gls.semister,
    sum(vw_gls.debit) AS acc_debit,
    sum(vw_gls.credit) AS acc_credit,
    sum(vw_gls.base_debit) AS acc_base_debit,
    sum(vw_gls.base_credit) AS acc_base_credit
   FROM public.vw_gls
  WHERE (vw_gls.posted = true)
  GROUP BY vw_gls.org_id, vw_gls.account_class_id, vw_gls.account_class_no, vw_gls.account_class_name, vw_gls.chat_type_id, vw_gls.chat_type_name, vw_gls.account_type_id, vw_gls.account_type_no, vw_gls.account_type_name, vw_gls.account_id, vw_gls.account_no, vw_gls.account_name, vw_gls.is_header, vw_gls.is_active, vw_gls.fiscal_year_id, vw_gls.fiscal_year_start, vw_gls.fiscal_year_end, vw_gls.year_opened, vw_gls.year_closed, vw_gls.period_id, vw_gls.start_date, vw_gls.end_date, vw_gls.opened, vw_gls.closed, vw_gls.month_id, vw_gls.period_year, vw_gls.period_month, vw_gls.quarter, vw_gls.semister
  ORDER BY vw_gls.account_id;


ALTER TABLE public.vw_sm_gls OWNER TO postgres;

--
-- Name: vw_ledger; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_ledger AS
 SELECT vw_sm_gls.org_id,
    vw_sm_gls.account_class_id,
    vw_sm_gls.account_class_no,
    vw_sm_gls.account_class_name,
    vw_sm_gls.chat_type_id,
    vw_sm_gls.chat_type_name,
    vw_sm_gls.account_type_id,
    vw_sm_gls.account_type_no,
    vw_sm_gls.account_type_name,
    vw_sm_gls.account_id,
    vw_sm_gls.account_no,
    vw_sm_gls.account_name,
    vw_sm_gls.is_header,
    vw_sm_gls.is_active,
    vw_sm_gls.fiscal_year_id,
    vw_sm_gls.fiscal_year_start,
    vw_sm_gls.fiscal_year_end,
    vw_sm_gls.year_opened,
    vw_sm_gls.year_closed,
    vw_sm_gls.period_id,
    vw_sm_gls.start_date,
    vw_sm_gls.end_date,
    vw_sm_gls.opened,
    vw_sm_gls.closed,
    vw_sm_gls.month_id,
    vw_sm_gls.period_year,
    vw_sm_gls.period_month,
    vw_sm_gls.quarter,
    vw_sm_gls.semister,
    vw_sm_gls.acc_debit,
    vw_sm_gls.acc_credit,
    (vw_sm_gls.acc_debit - vw_sm_gls.acc_credit) AS acc_balance,
    COALESCE(
        CASE
            WHEN (vw_sm_gls.acc_debit > vw_sm_gls.acc_credit) THEN (vw_sm_gls.acc_debit - vw_sm_gls.acc_credit)
            ELSE (0)::real
        END, (0)::real) AS bal_debit,
    COALESCE(
        CASE
            WHEN (vw_sm_gls.acc_debit < vw_sm_gls.acc_credit) THEN (vw_sm_gls.acc_credit - vw_sm_gls.acc_debit)
            ELSE (0)::real
        END, (0)::real) AS bal_credit,
    vw_sm_gls.acc_base_debit,
    vw_sm_gls.acc_base_credit,
    (vw_sm_gls.acc_base_debit - vw_sm_gls.acc_base_credit) AS acc_base_balance,
    COALESCE(
        CASE
            WHEN (vw_sm_gls.acc_base_debit > vw_sm_gls.acc_base_credit) THEN (vw_sm_gls.acc_base_debit - vw_sm_gls.acc_base_credit)
            ELSE (0)::real
        END, (0)::real) AS bal_base_debit,
    COALESCE(
        CASE
            WHEN (vw_sm_gls.acc_base_debit < vw_sm_gls.acc_base_credit) THEN (vw_sm_gls.acc_base_credit - vw_sm_gls.acc_base_debit)
            ELSE (0)::real
        END, (0)::real) AS bal_base_credit
   FROM public.vw_sm_gls;


ALTER TABLE public.vw_ledger OWNER TO postgres;

--
-- Name: vw_ledger_types; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_ledger_types AS
 SELECT vw_accounts.account_class_id,
    vw_accounts.chat_type_id,
    vw_accounts.chat_type_name,
    vw_accounts.account_class_name,
    vw_accounts.account_type_id,
    vw_accounts.account_type_name,
    vw_accounts.account_id,
    vw_accounts.account_no,
    vw_accounts.account_name,
    vw_accounts.is_header,
    vw_accounts.is_active,
    ta.account_class_id AS t_account_class_id,
    ta.chat_type_id AS t_chat_type_id,
    ta.chat_type_name AS t_chat_type_name,
    ta.account_class_name AS t_account_class_name,
    ta.account_type_id AS t_account_type_id,
    ta.account_type_name AS t_account_type_name,
    ta.account_id AS t_account_id,
    ta.account_no AS t_account_no,
    ta.account_name AS t_account_name,
    ledger_types.org_id,
    ledger_types.ledger_type_id,
    ledger_types.ledger_type_name,
    ledger_types.ledger_posting,
    ledger_types.income_ledger,
    ledger_types.expense_ledger,
    ledger_types.details
   FROM ((public.ledger_types
     JOIN public.vw_accounts ON ((ledger_types.account_id = vw_accounts.account_id)))
     JOIN public.vw_accounts ta ON ((ledger_types.tax_account_id = ta.account_id)));


ALTER TABLE public.vw_ledger_types OWNER TO postgres;

--
-- Name: vw_loan_activity; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_loan_activity AS
 SELECT vw_loans.member_id,
    vw_loans.member_name,
    vw_loans.business_account,
    vw_loans.product_id,
    vw_loans.product_name,
    vw_loans.loan_status,
    vw_loans.loan_id,
    vw_loans.principal_amount,
    vw_loans.interest_rate,
    vw_loans.disbursed_date,
    vw_loans.expected_matured_date,
    vw_loans.matured_date,
    vw_loans.currency_id,
    vw_loans.currency_name,
    vw_loans.currency_symbol,
    vw_activity_types.activity_type_id,
    vw_activity_types.activity_type_name,
    vw_activity_types.dr_account_id,
    vw_activity_types.dr_account_no,
    vw_activity_types.dr_account_name,
    vw_activity_types.cr_account_id,
    vw_activity_types.cr_account_no,
    vw_activity_types.cr_account_name,
    vw_activity_types.use_key_id,
    vw_activity_types.use_key_name,
    activity_frequency.activity_frequency_id,
    activity_frequency.activity_frequency_name,
    activity_status.activity_status_id,
    activity_status.activity_status_name,
    account_activity.transfer_account_id,
    trnf_accounts.account_number AS trnf_account_number,
    trnf_accounts.member_id AS trnf_member_id,
    trnf_accounts.member_name AS trnf_member_name,
    trnf_accounts.product_id AS trnf_product_id,
    trnf_accounts.product_name AS trnf_product_name,
    vw_periods.period_id,
    vw_periods.start_date,
    vw_periods.end_date,
    vw_periods.fiscal_year_id,
    vw_periods.fiscal_year,
    account_activity.org_id,
    account_activity.account_activity_id,
    account_activity.activity_date,
    account_activity.value_date,
    account_activity.transfer_account_no,
    account_activity.account_credit,
    account_activity.account_debit,
    account_activity.balance,
    account_activity.exchange_rate,
    account_activity.application_date,
    account_activity.approve_status,
    account_activity.workflow_table_id,
    account_activity.action_date,
    account_activity.details,
    (account_activity.account_credit * account_activity.exchange_rate) AS base_credit,
    (account_activity.account_debit * account_activity.exchange_rate) AS base_debit,
    vw_loans.letter_head
   FROM ((((((public.account_activity
     JOIN public.vw_loans ON ((account_activity.loan_id = vw_loans.loan_id)))
     JOIN public.vw_activity_types ON ((account_activity.activity_type_id = vw_activity_types.activity_type_id)))
     JOIN public.activity_frequency ON ((account_activity.activity_frequency_id = activity_frequency.activity_frequency_id)))
     JOIN public.activity_status ON ((account_activity.activity_status_id = activity_status.activity_status_id)))
     LEFT JOIN public.vw_periods ON ((account_activity.period_id = vw_periods.period_id)))
     LEFT JOIN public.vw_deposit_accounts trnf_accounts ON ((account_activity.transfer_account_id = trnf_accounts.deposit_account_id)));


ALTER TABLE public.vw_loan_activity OWNER TO postgres;

--
-- Name: vw_loan_approval_levels; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_loan_approval_levels AS
 SELECT loan_approval.loan_approval_id,
    loan_approval.sacco_official_id,
    loan_approval.org_id,
    loan_approval.processing_approval,
    loan_approval.final_approval,
    loan_approval.is_active,
    loan_approval.narrative,
    loan_approval.details,
    vw_sacco_officials.position_level_name,
    vw_sacco_officials.position_level_id,
    vw_sacco_officials.member_id,
    vw_sacco_officials.start_date,
    vw_sacco_officials.end_date,
    vw_sacco_officials.term_limit,
    vw_sacco_officials.is_active AS active_official,
    vw_sacco_officials.member_name,
    vw_sacco_officials.identification_number,
    vw_sacco_officials.identification_type,
    vw_sacco_officials.member_email,
    vw_sacco_officials.telephone_number,
    vw_sacco_officials.telephone_number2,
    vw_sacco_officials.address,
    vw_sacco_officials.town,
    vw_sacco_officials.zip_code
   FROM (public.loan_approval
     JOIN public.vw_sacco_officials ON ((vw_sacco_officials.sacco_official_id = loan_approval.sacco_official_id)));


ALTER TABLE public.vw_loan_approval_levels OWNER TO postgres;

--
-- Name: vw_loan_configs; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_loan_configs AS
 SELECT loan_configs.loan_config_id,
    loan_configs.org_id,
    loan_configs.product_id,
    loan_configs.is_guaranteed,
    loan_configs.is_collateral,
    loan_configs.membership_period,
    loan_configs.is_active,
    loan_configs.narrative,
    loan_configs.details,
    vw_products.activity_frequency_id,
    vw_products.activity_frequency_name,
    vw_products.currency_id,
    vw_products.currency_name,
    vw_products.currency_symbol,
    vw_products.interest_method_id,
    vw_products.interest_method_name,
    vw_products.reducing_balance,
    vw_products.interest_method_no,
    vw_products.penalty_method_id,
    vw_products.penalty_method_name,
    vw_products.penalty_method_no,
    vw_products.product_name,
    vw_products.description,
    vw_products.maximum_repayments
   FROM (public.loan_configs
     JOIN public.vw_products ON ((vw_products.product_id = loan_configs.product_id)));


ALTER TABLE public.vw_loan_configs OWNER TO postgres;

--
-- Name: vw_loan_notes; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_loan_notes AS
 SELECT vw_loans.member_id,
    vw_loans.member_name,
    vw_loans.product_id,
    vw_loans.product_name,
    vw_loans.loan_id,
    vw_loans.principal_amount,
    vw_loans.interest_rate,
    vw_loans.loan_status,
    vw_loans.activity_frequency_id,
    vw_loans.activity_frequency_name,
    vw_loans.disbursed_date,
    vw_loans.expected_matured_date,
    vw_loans.matured_date,
    loan_notes.org_id,
    loan_notes.loan_note_id,
    loan_notes.comment_date,
    loan_notes.narrative,
    loan_notes.note,
    vw_loans.letter_head
   FROM (public.loan_notes
     JOIN public.vw_loans ON ((loan_notes.loan_id = vw_loans.loan_id)));


ALTER TABLE public.vw_loan_notes OWNER TO postgres;

--
-- Name: vw_member_issues; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_member_issues AS
 SELECT vw_helpdesk_issues.issue_type_id,
    vw_helpdesk_issues.issue_type_name,
    vw_helpdesk_issues.issue_definition_id,
    vw_helpdesk_issues.issue_definition_name,
    vw_helpdesk_issues.issue_level_id,
    vw_helpdesk_issues.issue_level_name,
    vw_helpdesk_issues.recorded_by,
    vw_helpdesk_issues.recorder_name,
    vw_helpdesk_issues.org_id,
    vw_helpdesk_issues.helpdesk_id,
    vw_helpdesk_issues.description,
    vw_helpdesk_issues.recoded_time,
    vw_helpdesk_issues.is_solved,
    vw_helpdesk_issues.solved_time,
    vw_helpdesk_issues.curr_action,
    vw_helpdesk_issues.curr_status,
    vw_helpdesk_issues.problem,
    vw_helpdesk_issues.solution,
    vw_helpdesk_issues.closed_by,
    vw_helpdesk_issues.closer_name,
    vw_helpdesk_issues.member_id,
    vw_helpdesk_issues.member_name,
    vw_helpdesk_issues.is_escalated,
    vw_helpdesk_issues.telephone_number,
    vw_helpdesk_issues.member_email,
    entitys.entity_id
   FROM (public.vw_helpdesk_issues
     JOIN public.entitys ON ((entitys.member_id = vw_helpdesk_issues.member_id)));


ALTER TABLE public.vw_member_issues OWNER TO postgres;

--
-- Name: vw_member_loan_summary; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.vw_member_loan_summary (
    member_id integer,
    member_name character varying(150),
    business_account integer,
    identification_number character varying(50),
    identification_type character varying(50),
    member_email character varying(50),
    telephone_number character varying(20),
    entry_date date,
    applied_loans integer,
    approved_loans integer,
    fully_paid_loans integer,
    total_applied_loan_amount integer,
    approved_amount integer,
    repaid_amount integer,
    balance_amount integer,
    org_id integer
);

ALTER TABLE ONLY public.vw_member_loan_summary REPLICA IDENTITY NOTHING;


ALTER TABLE public.vw_member_loan_summary OWNER TO postgres;

--
-- Name: vw_member_sms; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_member_sms AS
 SELECT sms.sms_id,
    sms.entity_id,
    sms.org_id,
    sms.sms_number,
    sms.sms_time,
    sms.sent,
    sms.message,
    sms.details,
    sms.folder_id,
    sms.member_id,
    members.person_title,
    members.member_name,
    members.identification_number,
    members.identification_type,
    members.member_email,
    members.address,
    members.town,
    members.zip_code,
    members.nationality
   FROM (public.members
     JOIN public.sms ON ((members.member_id = sms.member_id)));


ALTER TABLE public.vw_member_sms OWNER TO postgres;

--
-- Name: vw_org_select; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_org_select AS
 SELECT orgs.org_id,
    orgs.parent_org_id,
    orgs.org_name
   FROM public.orgs
  WHERE ((orgs.is_active = true) AND (orgs.org_id <> orgs.parent_org_id))
UNION
 SELECT orgs.org_id,
    orgs.org_id AS parent_org_id,
    orgs.org_name
   FROM public.orgs
  WHERE (orgs.is_active = true);


ALTER TABLE public.vw_org_select OWNER TO postgres;

--
-- Name: vw_pc_allocations; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_pc_allocations AS
 SELECT vw_periods.fiscal_year_id,
    vw_periods.fiscal_year_start,
    vw_periods.fiscal_year_end,
    vw_periods.year_opened,
    vw_periods.year_closed,
    vw_periods.period_id,
    vw_periods.start_date,
    vw_periods.end_date,
    vw_periods.opened,
    vw_periods.closed,
    vw_periods.month_id,
    vw_periods.period_year,
    vw_periods.period_month,
    vw_periods.quarter,
    vw_periods.semister,
    departments.department_id,
    departments.department_name,
    pc_allocations.org_id,
    pc_allocations.pc_allocation_id,
    pc_allocations.narrative,
    pc_allocations.approve_status,
    pc_allocations.details,
    ( SELECT sum(((pc_budget.budget_units)::double precision * pc_budget.budget_price)) AS sum
           FROM public.pc_budget
          WHERE (pc_budget.pc_allocation_id = pc_allocations.pc_allocation_id)) AS sum_budget,
    ( SELECT sum(((pc_expenditure.units)::double precision * pc_expenditure.unit_price)) AS sum
           FROM public.pc_expenditure
          WHERE (pc_expenditure.pc_allocation_id = pc_allocations.pc_allocation_id)) AS sum_expenditure,
    ( SELECT sum(pc_banking.amount) AS sum
           FROM public.pc_banking
          WHERE (pc_banking.pc_allocation_id = pc_allocations.pc_allocation_id)) AS sum_banking
   FROM ((public.pc_allocations
     JOIN public.vw_periods ON ((pc_allocations.period_id = vw_periods.period_id)))
     JOIN public.departments ON ((pc_allocations.department_id = departments.department_id)));


ALTER TABLE public.vw_pc_allocations OWNER TO postgres;

--
-- Name: vw_pc_items; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_pc_items AS
 SELECT pc_category.pc_category_id,
    pc_category.pc_category_name,
    pc_items.org_id,
    pc_items.pc_item_id,
    pc_items.pc_item_name,
    pc_items.default_price,
    pc_items.default_units,
    pc_items.details,
    (pc_items.default_price * (pc_items.default_units)::double precision) AS default_cost
   FROM (public.pc_items
     JOIN public.pc_category ON ((pc_items.pc_category_id = pc_category.pc_category_id)));


ALTER TABLE public.vw_pc_items OWNER TO postgres;

--
-- Name: vw_pc_budget; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_pc_budget AS
 SELECT vw_pc_allocations.fiscal_year_id,
    vw_pc_allocations.fiscal_year_start,
    vw_pc_allocations.fiscal_year_end,
    vw_pc_allocations.year_opened,
    vw_pc_allocations.year_closed,
    vw_pc_allocations.period_id,
    vw_pc_allocations.start_date,
    vw_pc_allocations.end_date,
    vw_pc_allocations.opened,
    vw_pc_allocations.closed,
    vw_pc_allocations.month_id,
    vw_pc_allocations.period_year,
    vw_pc_allocations.period_month,
    vw_pc_allocations.quarter,
    vw_pc_allocations.semister,
    vw_pc_allocations.department_id,
    vw_pc_allocations.department_name,
    vw_pc_allocations.pc_allocation_id,
    vw_pc_allocations.narrative,
    vw_pc_allocations.approve_status,
    vw_pc_items.pc_category_id,
    vw_pc_items.pc_category_name,
    vw_pc_items.pc_item_id,
    vw_pc_items.pc_item_name,
    vw_pc_items.default_price,
    vw_pc_items.default_units,
    vw_pc_items.default_cost,
    pc_budget.org_id,
    pc_budget.pc_budget_id,
    pc_budget.budget_units,
    pc_budget.budget_price,
    ((pc_budget.budget_units)::double precision * pc_budget.budget_price) AS budget_cost,
    pc_budget.details
   FROM ((public.pc_budget
     JOIN public.vw_pc_allocations ON ((pc_budget.pc_allocation_id = vw_pc_allocations.pc_allocation_id)))
     JOIN public.vw_pc_items ON ((pc_budget.pc_item_id = vw_pc_items.pc_item_id)));


ALTER TABLE public.vw_pc_budget OWNER TO postgres;

--
-- Name: vw_pc_expenditure; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_pc_expenditure AS
 SELECT vw_pc_allocations.fiscal_year_id,
    vw_pc_allocations.fiscal_year_start,
    vw_pc_allocations.fiscal_year_end,
    vw_pc_allocations.year_opened,
    vw_pc_allocations.year_closed,
    vw_pc_allocations.period_id,
    vw_pc_allocations.start_date,
    vw_pc_allocations.end_date,
    vw_pc_allocations.opened,
    vw_pc_allocations.closed,
    vw_pc_allocations.month_id,
    vw_pc_allocations.period_year,
    vw_pc_allocations.period_month,
    vw_pc_allocations.quarter,
    vw_pc_allocations.semister,
    vw_pc_allocations.department_id,
    vw_pc_allocations.department_name,
    vw_pc_allocations.pc_allocation_id,
    vw_pc_allocations.narrative,
    vw_pc_items.pc_category_id,
    vw_pc_items.pc_category_name,
    vw_pc_items.pc_item_id,
    vw_pc_items.pc_item_name,
    vw_pc_items.default_price,
    vw_pc_items.default_units,
    vw_pc_items.default_cost,
    pc_types.pc_type_id,
    pc_types.pc_type_name,
    entitys.entity_id,
    entitys.entity_name,
    pc_expenditure.org_id,
    pc_expenditure.pc_expenditure_id,
    pc_expenditure.units,
    pc_expenditure.unit_price,
    pc_expenditure.receipt_number,
    pc_expenditure.exp_date,
    pc_expenditure.is_request,
    pc_expenditure.request_date,
    ((pc_expenditure.units)::double precision * pc_expenditure.unit_price) AS items_cost,
    pc_expenditure.application_date,
    pc_expenditure.approve_status,
    pc_expenditure.workflow_table_id,
    pc_expenditure.action_date,
    pc_expenditure.details
   FROM ((((public.pc_expenditure
     JOIN public.vw_pc_allocations ON ((pc_expenditure.pc_allocation_id = vw_pc_allocations.pc_allocation_id)))
     JOIN public.vw_pc_items ON ((pc_expenditure.pc_item_id = vw_pc_items.pc_item_id)))
     JOIN public.pc_types ON ((pc_expenditure.pc_type_id = pc_types.pc_type_id)))
     LEFT JOIN public.entitys ON ((pc_expenditure.entity_id = entitys.entity_id)));


ALTER TABLE public.vw_pc_expenditure OWNER TO postgres;

--
-- Name: vw_penalty_methods; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_penalty_methods AS
 SELECT activity_types.activity_type_id,
    activity_types.activity_type_name,
    activity_types.use_key_id,
    penalty_methods.org_id,
    penalty_methods.penalty_method_id,
    penalty_methods.penalty_method_name,
    penalty_methods.formural,
    penalty_methods.account_number,
    penalty_methods.penalty_method_no,
    penalty_methods.details,
    orgs.org_name,
    orgs.letter_head
   FROM ((public.penalty_methods
     JOIN public.activity_types ON ((penalty_methods.activity_type_id = activity_types.activity_type_id)))
     JOIN public.orgs ON ((penalty_methods.org_id = orgs.org_id)));


ALTER TABLE public.vw_penalty_methods OWNER TO postgres;

--
-- Name: vw_period_month; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_period_month AS
 SELECT vw_periods.org_id,
    vw_periods.month_id,
    vw_periods.period_year,
    vw_periods.period_month
   FROM public.vw_periods
  GROUP BY vw_periods.org_id, vw_periods.month_id, vw_periods.period_year, vw_periods.period_month
  ORDER BY vw_periods.month_id, vw_periods.period_year, vw_periods.period_month;


ALTER TABLE public.vw_period_month OWNER TO postgres;

--
-- Name: vw_period_quarter; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_period_quarter AS
 SELECT vw_periods.org_id,
    vw_periods.quarter
   FROM public.vw_periods
  GROUP BY vw_periods.org_id, vw_periods.quarter
  ORDER BY vw_periods.quarter;


ALTER TABLE public.vw_period_quarter OWNER TO postgres;

--
-- Name: vw_period_semister; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_period_semister AS
 SELECT vw_periods.org_id,
    vw_periods.semister
   FROM public.vw_periods
  GROUP BY vw_periods.org_id, vw_periods.semister
  ORDER BY vw_periods.semister;


ALTER TABLE public.vw_period_semister OWNER TO postgres;

--
-- Name: vw_period_tax_rates; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_period_tax_rates AS
 SELECT period_tax_types.period_tax_type_id,
    period_tax_types.period_tax_type_name,
    period_tax_types.tax_type_id,
    period_tax_types.period_id,
    period_tax_rates.period_tax_rate_id,
    public.get_tax_min(period_tax_rates.tax_range, period_tax_types.period_tax_type_id, 0) AS min_range,
    period_tax_rates.org_id,
    period_tax_rates.tax_range AS max_range,
    period_tax_rates.tax_rate,
    period_tax_rates.employer_rate,
    period_tax_rates.rate_relief,
    period_tax_rates.narrative
   FROM (public.period_tax_rates
     JOIN public.period_tax_types ON ((period_tax_rates.period_tax_type_id = period_tax_types.period_tax_type_id)));


ALTER TABLE public.vw_period_tax_rates OWNER TO postgres;

--
-- Name: vw_period_tax_types; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_period_tax_types AS
 SELECT vw_periods.period_id,
    vw_periods.start_date,
    vw_periods.end_date,
    vw_periods.overtime_rate,
    vw_periods.activated,
    vw_periods.closed,
    vw_periods.month_id,
    vw_periods.period_year,
    vw_periods.period_month,
    vw_periods.quarter,
    vw_periods.semister,
    tax_types.tax_type_id,
    tax_types.tax_type_name,
    period_tax_types.period_tax_type_id,
    tax_types.tax_type_number,
    use_keys.use_key_id,
    use_keys.use_key_name,
    use_keys.use_function,
    period_tax_types.period_tax_type_name,
    period_tax_types.org_id,
    period_tax_types.pay_date,
    period_tax_types.tax_relief,
    period_tax_types.linear,
    period_tax_types.percentage,
    period_tax_types.formural,
    period_tax_types.employer_formural,
    period_tax_types.employer_relief,
    period_tax_types.details
   FROM (((public.period_tax_types
     JOIN public.vw_periods ON ((period_tax_types.period_id = vw_periods.period_id)))
     JOIN public.tax_types ON ((period_tax_types.tax_type_id = tax_types.tax_type_id)))
     JOIN public.use_keys ON ((tax_types.use_key_id = use_keys.use_key_id)));


ALTER TABLE public.vw_period_tax_types OWNER TO postgres;

--
-- Name: vw_period_year; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_period_year AS
 SELECT vw_periods.org_id,
    vw_periods.period_year
   FROM public.vw_periods
  GROUP BY vw_periods.org_id, vw_periods.period_year
  ORDER BY vw_periods.period_year;


ALTER TABLE public.vw_period_year OWNER TO postgres;

--
-- Name: vw_phases; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_phases AS
 SELECT vw_investments.investment_type_id,
    vw_investments.investment_type_name,
    vw_investments.investment_status_id,
    vw_investments.investment_status_name,
    vw_investments.investment_id,
    vw_investments.investment_name,
    vw_investments.started_date,
    phases.org_id,
    phases.phase_id,
    phases.phase_name,
    phases.start_date,
    phases.end_date,
    phases.completed,
    phases.phase_cost,
    phases.details
   FROM (public.phases
     JOIN public.vw_investments ON ((phases.investment_id = vw_investments.investment_id)));


ALTER TABLE public.vw_phases OWNER TO postgres;

--
-- Name: vw_quotations; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_quotations AS
 SELECT entitys.entity_id,
    entitys.entity_name,
    items.item_id,
    items.item_name,
    quotations.quotation_id,
    quotations.org_id,
    quotations.active,
    quotations.amount,
    quotations.valid_from,
    quotations.valid_to,
    quotations.lead_time,
    quotations.details
   FROM ((public.quotations
     JOIN public.entitys ON ((quotations.entity_id = entitys.entity_id)))
     JOIN public.items ON ((quotations.item_id = items.item_id)));


ALTER TABLE public.vw_quotations OWNER TO postgres;

--
-- Name: vw_reporting; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_reporting AS
 SELECT entitys.entity_id,
    entitys.entity_name,
    rpt.entity_id AS rpt_id,
    rpt.entity_name AS rpt_name,
    reporting.org_id,
    reporting.reporting_id,
    reporting.date_from,
    reporting.date_to,
    reporting.primary_report,
    reporting.is_active,
    reporting.ps_reporting,
    reporting.reporting_level,
    reporting.details
   FROM ((public.reporting
     JOIN public.entitys ON ((reporting.entity_id = entitys.entity_id)))
     JOIN public.entitys rpt ON ((reporting.report_to_id = rpt.entity_id)));


ALTER TABLE public.vw_reporting OWNER TO postgres;

--
-- Name: vw_sms_group_members; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_sms_group_members AS
 SELECT members.person_title,
    members.member_name,
    members.member_email,
    members.telephone_number,
    sms_group.sms_group_name,
    sms_group_members.sms_group_member_id,
    sms_group_members.org_id,
    sms_group_members.member_id,
    sms_group_members.narrative,
    sms_group_members.details,
    sms_group_members.sms_group_id
   FROM ((public.members
     JOIN public.sms_group_members ON ((members.member_id = sms_group_members.member_id)))
     JOIN public.sms_group ON ((sms_group.sms_group_id = sms_group_members.sms_group_id)));


ALTER TABLE public.vw_sms_group_members OWNER TO postgres;

--
-- Name: vw_ss_items; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_ss_items AS
 SELECT orgs.org_id,
    orgs.org_name,
    ss_types.ss_type_id,
    ss_types.ss_type_name,
    ss_items.ss_item_id,
    ss_items.ss_item_name,
    ss_items.picture,
    ss_items.description,
    ss_items.purchase_date,
    ss_items.purchase_price,
    ss_items.sale_date,
    ss_items.sale_price,
    ss_items.sold,
    ss_items.details,
    (ss_items.sale_price - ss_items.purchase_price) AS gross_margin
   FROM ((public.ss_items
     JOIN public.ss_types ON ((ss_items.ss_type_id = ss_types.ss_type_id)))
     JOIN public.orgs ON ((ss_items.org_id = orgs.org_id)));


ALTER TABLE public.vw_ss_items OWNER TO postgres;

--
-- Name: vw_stocks; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_stocks AS
 SELECT stores.store_id,
    stores.store_name,
    stocks.stock_id,
    stocks.org_id,
    stocks.stock_name,
    stocks.stock_take_date,
    stocks.details
   FROM (public.stocks
     JOIN public.stores ON ((stocks.store_id = stores.store_id)));


ALTER TABLE public.vw_stocks OWNER TO postgres;

--
-- Name: vw_stock_lines; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_stock_lines AS
 SELECT vw_stocks.stock_id,
    vw_stocks.stock_name,
    vw_stocks.stock_take_date,
    vw_stocks.store_id,
    vw_stocks.store_name,
    items.item_id,
    items.item_name,
    stock_lines.stock_line_id,
    stock_lines.org_id,
    stock_lines.quantity,
    stock_lines.narrative
   FROM ((public.stock_lines
     JOIN public.vw_stocks ON ((stock_lines.stock_id = vw_stocks.stock_id)))
     JOIN public.items ON ((stock_lines.item_id = items.item_id)));


ALTER TABLE public.vw_stock_lines OWNER TO postgres;

--
-- Name: vw_transactions; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_transactions AS
 SELECT transaction_types.transaction_type_id,
    transaction_types.transaction_type_name,
    transaction_types.document_prefix,
    transaction_types.for_posting,
    transaction_types.for_sales,
    entitys.entity_id,
    entitys.entity_name,
    entitys.account_id AS entity_account_id,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    vw_bank_accounts.bank_id,
    vw_bank_accounts.bank_name,
    vw_bank_accounts.bank_branch_name,
    vw_bank_accounts.account_id AS gl_bank_account_id,
    vw_bank_accounts.bank_account_id,
    vw_bank_accounts.bank_account_name,
    vw_bank_accounts.bank_account_number,
    departments.department_id,
    departments.department_name,
    ledger_types.ledger_type_id,
    ledger_types.ledger_type_name,
    ledger_types.account_id AS ledger_account_id,
    ledger_types.tax_account_id,
    ledger_types.ledger_posting,
    transaction_status.transaction_status_id,
    transaction_status.transaction_status_name,
    transactions.journal_id,
    transactions.transaction_id,
    transactions.org_id,
    transactions.transaction_date,
    transactions.transaction_amount,
    transactions.transaction_tax_amount,
    transactions.application_date,
    transactions.approve_status,
    transactions.workflow_table_id,
    transactions.action_date,
    transactions.narrative,
    transactions.document_number,
    transactions.payment_number,
    transactions.order_number,
    transactions.exchange_rate,
    transactions.payment_terms,
    transactions.job,
    transactions.details,
    transactions.notes,
    (transactions.transaction_amount - transactions.transaction_tax_amount) AS transaction_net_amount,
        CASE
            WHEN (transactions.journal_id IS NULL) THEN 'Not Posted'::text
            ELSE 'Posted'::text
        END AS posted,
        CASE
            WHEN ((transactions.transaction_type_id = 2) OR (transactions.transaction_type_id = 8) OR (transactions.transaction_type_id = 10) OR (transactions.transaction_type_id = 21)) THEN transactions.transaction_amount
            ELSE (0)::real
        END AS debit_amount,
        CASE
            WHEN ((transactions.transaction_type_id = 5) OR (transactions.transaction_type_id = 7) OR (transactions.transaction_type_id = 9) OR (transactions.transaction_type_id = 22)) THEN transactions.transaction_amount
            ELSE (0)::real
        END AS credit_amount
   FROM (((((((public.transactions
     JOIN public.transaction_types ON ((transactions.transaction_type_id = transaction_types.transaction_type_id)))
     JOIN public.transaction_status ON ((transactions.transaction_status_id = transaction_status.transaction_status_id)))
     JOIN public.currency ON ((transactions.currency_id = currency.currency_id)))
     LEFT JOIN public.entitys ON ((transactions.entity_id = entitys.entity_id)))
     LEFT JOIN public.vw_bank_accounts ON ((vw_bank_accounts.bank_account_id = transactions.bank_account_id)))
     LEFT JOIN public.departments ON ((transactions.department_id = departments.department_id)))
     LEFT JOIN public.ledger_types ON ((transactions.ledger_type_id = ledger_types.ledger_type_id)));


ALTER TABLE public.vw_transactions OWNER TO postgres;

--
-- Name: vw_transaction_details; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_transaction_details AS
 SELECT vw_transactions.department_id,
    vw_transactions.department_name,
    vw_transactions.transaction_type_id,
    vw_transactions.transaction_type_name,
    vw_transactions.document_prefix,
    vw_transactions.transaction_id,
    vw_transactions.transaction_date,
    vw_transactions.entity_id,
    vw_transactions.entity_name,
    vw_transactions.document_number,
    vw_transactions.approve_status,
    vw_transactions.workflow_table_id,
    vw_transactions.currency_name,
    vw_transactions.exchange_rate,
    accounts.account_id,
    accounts.account_name,
    stores.store_id,
    stores.store_name,
    vw_items.item_id,
    vw_items.item_name,
    vw_items.tax_type_id,
    vw_items.tax_account_id,
    vw_items.tax_type_name,
    vw_items.tax_rate,
    vw_items.tax_inclusive,
    vw_items.sales_account_id,
    vw_items.purchase_account_id,
    vw_items.for_sale,
    vw_items.for_purchase,
    vw_items.for_stock,
    vw_items.inventory,
    transaction_details.transaction_detail_id,
    transaction_details.org_id,
    transaction_details.quantity,
    transaction_details.amount,
    transaction_details.tax_amount,
    transaction_details.discount,
    transaction_details.narrative,
    transaction_details.details,
    COALESCE(transaction_details.narrative, vw_items.item_name) AS item_description,
    (((transaction_details.quantity)::double precision * (((100)::double precision - transaction_details.discount) / (100)::double precision)) * transaction_details.amount) AS full_amount,
    (((transaction_details.quantity)::double precision * (((100)::double precision - transaction_details.discount) / (100)::double precision)) * transaction_details.tax_amount) AS full_tax_amount,
    (((transaction_details.quantity)::double precision * (((100)::double precision - transaction_details.discount) / (100)::double precision)) * (transaction_details.amount + transaction_details.tax_amount)) AS full_total_amount,
        CASE
            WHEN ((vw_transactions.transaction_type_id = 5) OR (vw_transactions.transaction_type_id = 9)) THEN (((transaction_details.quantity)::double precision * (((100)::double precision - transaction_details.discount) / (100)::double precision)) * transaction_details.tax_amount)
            ELSE (0)::double precision
        END AS tax_debit_amount,
        CASE
            WHEN ((vw_transactions.transaction_type_id = 2) OR (vw_transactions.transaction_type_id = 10)) THEN (((transaction_details.quantity)::double precision * (((100)::double precision - transaction_details.discount) / (100)::double precision)) * transaction_details.tax_amount)
            ELSE (0)::double precision
        END AS tax_credit_amount,
        CASE
            WHEN ((vw_transactions.transaction_type_id = 5) OR (vw_transactions.transaction_type_id = 9)) THEN (((transaction_details.quantity)::double precision * (((100)::double precision - transaction_details.discount) / (100)::double precision)) * transaction_details.amount)
            ELSE (0)::double precision
        END AS full_debit_amount,
        CASE
            WHEN ((vw_transactions.transaction_type_id = 2) OR (vw_transactions.transaction_type_id = 10)) THEN (((transaction_details.quantity)::double precision * (((100)::double precision - transaction_details.discount) / (100)::double precision)) * transaction_details.amount)
            ELSE (0)::double precision
        END AS full_credit_amount,
        CASE
            WHEN ((vw_transactions.transaction_type_id = 2) OR (vw_transactions.transaction_type_id = 9)) THEN vw_items.sales_account_id
            ELSE vw_items.purchase_account_id
        END AS trans_account_id
   FROM ((((public.transaction_details
     JOIN public.vw_transactions ON ((transaction_details.transaction_id = vw_transactions.transaction_id)))
     LEFT JOIN public.vw_items ON ((transaction_details.item_id = vw_items.item_id)))
     LEFT JOIN public.accounts ON ((transaction_details.account_id = accounts.account_id)))
     LEFT JOIN public.stores ON ((transaction_details.store_id = stores.store_id)));


ALTER TABLE public.vw_transaction_details OWNER TO postgres;

--
-- Name: vw_stock_movement; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_stock_movement AS
 SELECT vw_transaction_details.org_id,
    vw_transaction_details.department_id,
    vw_transaction_details.department_name,
    vw_transaction_details.transaction_type_id,
    vw_transaction_details.transaction_type_name,
    vw_transaction_details.document_prefix,
    vw_transaction_details.document_number,
    vw_transaction_details.transaction_id,
    vw_transaction_details.transaction_date,
    vw_transaction_details.entity_id,
    vw_transaction_details.entity_name,
    vw_transaction_details.approve_status,
    vw_transaction_details.store_id,
    vw_transaction_details.store_name,
    vw_transaction_details.item_id,
    vw_transaction_details.item_name,
        CASE
            WHEN (vw_transaction_details.transaction_type_id = 11) THEN vw_transaction_details.quantity
            ELSE 0
        END AS q_sold,
        CASE
            WHEN (vw_transaction_details.transaction_type_id = 12) THEN vw_transaction_details.quantity
            ELSE 0
        END AS q_purchased,
        CASE
            WHEN (vw_transaction_details.transaction_type_id = 17) THEN vw_transaction_details.quantity
            ELSE 0
        END AS q_used
   FROM public.vw_transaction_details
  WHERE ((vw_transaction_details.transaction_type_id = ANY (ARRAY[11, 17, 12])) AND (vw_transaction_details.for_stock = true) AND ((vw_transaction_details.approve_status)::text <> 'Draft'::text));


ALTER TABLE public.vw_stock_movement OWNER TO postgres;

--
-- Name: vw_store_movement; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_store_movement AS
 SELECT items.item_id,
    items.item_name,
    stores.store_id,
    stores.store_name,
    store_to.store_id AS store_to_id,
    stores.store_name AS store_to_name,
    store_movement.org_id,
    store_movement.store_movement_id,
    store_movement.movement_date,
    store_movement.quantity,
    store_movement.narrative
   FROM (((public.store_movement
     JOIN public.items ON ((store_movement.item_id = items.item_id)))
     JOIN public.stores ON ((store_movement.store_id = stores.store_id)))
     JOIN public.stores store_to ON ((store_movement.store_to_id = store_to.store_id)));


ALTER TABLE public.vw_store_movement OWNER TO postgres;

--
-- Name: vw_sub_fields; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_sub_fields AS
 SELECT vw_fields.form_id,
    vw_fields.form_name,
    vw_fields.field_id,
    sub_fields.sub_field_id,
    sub_fields.org_id,
    sub_fields.sub_field_order,
    sub_fields.sub_title_share,
    sub_fields.sub_field_type,
    sub_fields.sub_field_lookup,
    sub_fields.sub_field_size,
    sub_fields.sub_col_spans,
    sub_fields.manditory,
    sub_fields.question
   FROM (public.sub_fields
     JOIN public.vw_fields ON ((sub_fields.field_id = vw_fields.field_id)));


ALTER TABLE public.vw_sub_fields OWNER TO postgres;

--
-- Name: vw_subscriptions; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_subscriptions AS
 SELECT sys_countrys.sys_country_id,
    sys_countrys.sys_country_name,
    entitys.entity_id,
    entitys.entity_name,
    orgs.org_id,
    orgs.org_name,
    subscriptions.subscription_id,
    subscriptions.business_name,
    subscriptions.business_address,
    subscriptions.city,
    subscriptions.number_of_members,
    subscriptions.country_id,
    subscriptions.telephone,
    subscriptions.website,
    subscriptions.primary_contact,
    subscriptions.job_title,
    subscriptions.primary_email,
    subscriptions.approve_status,
    subscriptions.workflow_table_id,
    subscriptions.application_date,
    subscriptions.action_date,
    subscriptions.system_key,
    subscriptions.subscribed,
    subscriptions.subscribed_date,
    subscriptions.details
   FROM (((public.subscriptions
     JOIN public.sys_countrys ON ((subscriptions.country_id = sys_countrys.sys_country_id)))
     LEFT JOIN public.entitys ON ((subscriptions.entity_id = entitys.entity_id)))
     LEFT JOIN public.orgs ON ((subscriptions.org_id = orgs.org_id)));


ALTER TABLE public.vw_subscriptions OWNER TO postgres;

--
-- Name: vw_sys_access_entitys; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_sys_access_entitys AS
 SELECT sys_access_levels.sys_access_level_id,
    sys_access_levels.use_key_id,
    sys_access_levels.sys_access_level_name,
    sys_access_levels.access_tag,
    entitys.entity_id,
    entitys.entity_name,
    sys_access_entitys.org_id,
    sys_access_entitys.sys_access_entity_id,
    sys_access_entitys.narrative
   FROM ((public.sys_access_entitys
     JOIN public.sys_access_levels ON ((sys_access_entitys.sys_access_level_id = sys_access_levels.sys_access_level_id)))
     JOIN public.entitys ON ((sys_access_entitys.entity_id = entitys.entity_id)));


ALTER TABLE public.vw_sys_access_entitys OWNER TO postgres;

--
-- Name: vw_sys_countrys; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_sys_countrys AS
 SELECT sys_continents.sys_continent_id,
    sys_continents.sys_continent_name,
    sys_countrys.sys_country_id,
    sys_countrys.sys_country_code,
    sys_countrys.sys_country_number,
    sys_countrys.sys_phone_code,
    sys_countrys.sys_country_name
   FROM (public.sys_continents
     JOIN public.sys_countrys ON ((sys_continents.sys_continent_id = sys_countrys.sys_continent_id)));


ALTER TABLE public.vw_sys_countrys OWNER TO postgres;

--
-- Name: vw_sys_emailed; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_sys_emailed AS
 SELECT sys_emails.sys_email_id,
    sys_emails.org_id,
    sys_emails.sys_email_name,
    sys_emails.use_type,
    sys_emails.title,
    sys_emails.details,
    sys_emailed.sys_emailed_id,
    sys_emailed.table_id,
    sys_emailed.table_name,
    sys_emailed.email_type,
    sys_emailed.created,
    sys_emailed.emailed,
    sys_emailed.narrative
   FROM (public.sys_emails
     RIGHT JOIN public.sys_emailed ON ((sys_emails.sys_email_id = sys_emailed.sys_email_id)));


ALTER TABLE public.vw_sys_emailed OWNER TO postgres;

--
-- Name: vw_tasks; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_tasks AS
 SELECT vw_phases.investment_type_id,
    vw_phases.investment_type_name,
    vw_phases.investment_status_id,
    vw_phases.investment_status_name,
    vw_phases.investment_id,
    vw_phases.investment_name,
    vw_phases.started_date,
    vw_phases.phase_id,
    vw_phases.phase_name,
    vw_phases.start_date,
    vw_phases.end_date,
    vw_phases.completed,
    members.entity_id,
    members.member_name,
    tasks.org_id,
    tasks.task_id,
    tasks.task_name,
    tasks.task_start,
    tasks.task_deadline,
    tasks.task_end,
    tasks.task_cost,
    tasks.task_completed,
    tasks.details
   FROM ((public.tasks
     JOIN public.vw_phases ON ((tasks.phase_id = vw_phases.phase_id)))
     JOIN public.members ON ((tasks.member_id = members.member_id)));


ALTER TABLE public.vw_tasks OWNER TO postgres;

--
-- Name: vw_tax_rates; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_tax_rates AS
 SELECT tax_types.tax_type_id,
    tax_types.tax_type_name,
    tax_types.tax_relief,
    tax_types.linear,
    tax_types.percentage,
    tax_rates.org_id,
    tax_rates.tax_rate_id,
    tax_rates.tax_range,
    tax_rates.tax_rate,
    tax_rates.employer_rate,
    tax_rates.rate_relief,
    tax_rates.narrative
   FROM (public.tax_rates
     JOIN public.tax_types ON ((tax_rates.tax_type_id = tax_types.tax_type_id)));


ALTER TABLE public.vw_tax_rates OWNER TO postgres;

--
-- Name: vw_tender_items; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_tender_items AS
 SELECT vw_bidders.tender_type_id,
    vw_bidders.tender_type_name,
    vw_bidders.tender_id,
    vw_bidders.tender_name,
    vw_bidders.tender_number,
    vw_bidders.tender_date,
    vw_bidders.tender_end_date,
    vw_bidders.is_completed,
    vw_bidders.entity_id,
    vw_bidders.entity_name,
    vw_bidders.bidder_id,
    vw_bidders.tender_amount,
    vw_bidders.bind_bond,
    vw_bidders.bind_bond_amount,
    vw_bidders.return_date,
    vw_bidders.points,
    vw_bidders.is_awarded,
    vw_bidders.award_reference,
    tender_items.org_id,
    tender_items.tender_item_id,
    tender_items.tender_item_name,
    tender_items.quantity,
    tender_items.item_amount,
    tender_items.item_tax,
    tender_items.details
   FROM (public.tender_items
     JOIN public.vw_bidders ON ((tender_items.bidder_id = vw_bidders.bidder_id)));


ALTER TABLE public.vw_tender_items OWNER TO postgres;

--
-- Name: vw_transaction_counters; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_transaction_counters AS
 SELECT transaction_types.transaction_type_id,
    transaction_types.transaction_type_name,
    transaction_types.document_prefix,
    transaction_types.for_posting,
    transaction_types.for_sales,
    transaction_counters.org_id,
    transaction_counters.transaction_counter_id,
    transaction_counters.document_number
   FROM (public.transaction_counters
     JOIN public.transaction_types ON ((transaction_counters.transaction_type_id = transaction_types.transaction_type_id)));


ALTER TABLE public.vw_transaction_counters OWNER TO postgres;

--
-- Name: vw_transfer_beneficiary; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_transfer_beneficiary AS
 SELECT vw_deposit_accounts.member_id,
    vw_deposit_accounts.member_name,
    vw_deposit_accounts.business_account,
    vw_deposit_accounts.product_id,
    vw_deposit_accounts.product_name,
    vw_deposit_accounts.currency_id,
    vw_deposit_accounts.currency_name,
    vw_deposit_accounts.currency_symbol,
    vw_deposit_accounts.activity_frequency_id,
    vw_deposit_accounts.activity_frequency_name,
    vw_deposit_accounts.deposit_account_id,
    vw_deposit_accounts.is_active,
    vw_deposit_accounts.approve_status AS account_status,
    transfer_beneficiary.member_id AS account_member_id,
    transfer_beneficiary.org_id,
    transfer_beneficiary.transfer_beneficiary_id,
    transfer_beneficiary.beneficiary_name,
    transfer_beneficiary.account_number,
    transfer_beneficiary.allow_transfer,
    transfer_beneficiary.application_date,
    transfer_beneficiary.approve_status,
    transfer_beneficiary.workflow_table_id,
    transfer_beneficiary.action_date,
    transfer_beneficiary.details,
    vw_deposit_accounts.letter_head
   FROM (public.transfer_beneficiary
     JOIN public.vw_deposit_accounts ON ((transfer_beneficiary.deposit_account_id = vw_deposit_accounts.deposit_account_id)));


ALTER TABLE public.vw_transfer_beneficiary OWNER TO postgres;

--
-- Name: vw_transfer_activity; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_transfer_activity AS
 SELECT vw_transfer_beneficiary.transfer_beneficiary_id,
    vw_transfer_beneficiary.member_name AS beneficiary_name,
    vw_transfer_beneficiary.account_number AS beneficiary_account_number,
    vw_deposit_accounts.deposit_account_id,
    vw_deposit_accounts.product_id,
    vw_deposit_accounts.product_name,
    vw_deposit_accounts.member_id,
    vw_deposit_accounts.account_number,
    vw_deposit_accounts.currency_id,
    vw_deposit_accounts.currency_name,
    vw_deposit_accounts.currency_symbol,
    activity_frequency.activity_frequency_id,
    activity_frequency.activity_frequency_name,
    activity_types.activity_type_id,
    activity_types.activity_type_name,
    transfer_activity.org_id,
    transfer_activity.transfer_activity_id,
    transfer_activity.account_activity_id,
    transfer_activity.entity_id,
    transfer_activity.transfer_amount,
    transfer_activity.application_date,
    transfer_activity.approve_status,
    transfer_activity.workflow_table_id,
    transfer_activity.action_date,
    transfer_activity.details,
    vw_deposit_accounts.letter_head
   FROM ((((public.transfer_activity
     JOIN public.vw_transfer_beneficiary ON ((transfer_activity.transfer_beneficiary_id = vw_transfer_beneficiary.transfer_beneficiary_id)))
     JOIN public.vw_deposit_accounts ON ((transfer_activity.deposit_account_id = vw_deposit_accounts.deposit_account_id)))
     JOIN public.activity_frequency ON ((transfer_activity.activity_frequency_id = activity_frequency.activity_frequency_id)))
     JOIN public.activity_types ON ((transfer_activity.activity_type_id = activity_types.activity_type_id)));


ALTER TABLE public.vw_transfer_activity OWNER TO postgres;

--
-- Name: vw_trx; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_trx AS
 SELECT vw_orgs.org_id,
    vw_orgs.org_name,
    vw_orgs.is_default AS org_is_default,
    vw_orgs.is_active AS org_is_active,
    vw_orgs.logo AS org_logo,
    vw_orgs.cert_number AS org_cert_number,
    vw_orgs.pin AS org_pin,
    vw_orgs.vat_number AS org_vat_number,
    vw_orgs.invoice_footer AS org_invoice_footer,
    vw_orgs.org_sys_country_id,
    vw_orgs.org_sys_country_name,
    vw_orgs.org_address_id,
    vw_orgs.org_table_name,
    vw_orgs.org_post_office_box,
    vw_orgs.org_postal_code,
    vw_orgs.org_premises,
    vw_orgs.org_street,
    vw_orgs.org_town,
    vw_orgs.org_phone_number,
    vw_orgs.org_extension,
    vw_orgs.org_mobile,
    vw_orgs.org_fax,
    vw_orgs.org_email,
    vw_orgs.org_website,
    vw_entitys.address_id,
    vw_entitys.address_name,
    vw_entitys.sys_country_id,
    vw_entitys.sys_country_name,
    vw_entitys.table_name,
    vw_entitys.is_default,
    vw_entitys.post_office_box,
    vw_entitys.postal_code,
    vw_entitys.premises,
    vw_entitys.street,
    vw_entitys.town,
    vw_entitys.phone_number,
    vw_entitys.extension,
    vw_entitys.mobile,
    vw_entitys.fax,
    vw_entitys.email,
    vw_entitys.website,
    vw_entitys.entity_id,
    vw_entitys.entity_name,
    vw_entitys.user_name,
    vw_entitys.super_user,
    vw_entitys.attention,
    vw_entitys.date_enroled,
    vw_entitys.is_active,
    vw_entitys.entity_type_id,
    vw_entitys.entity_type_name,
    vw_entitys.entity_role,
    vw_entitys.use_key_id,
    transaction_types.transaction_type_id,
    transaction_types.transaction_type_name,
    transaction_types.document_prefix,
    transaction_types.for_sales,
    transaction_types.for_posting,
    transaction_status.transaction_status_id,
    transaction_status.transaction_status_name,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    departments.department_id,
    departments.department_name,
    transactions.journal_id,
    transactions.bank_account_id,
    transactions.ledger_type_id,
    transactions.transaction_id,
    transactions.transaction_date,
    transactions.transaction_amount,
    transactions.transaction_tax_amount,
    transactions.application_date,
    transactions.approve_status,
    transactions.workflow_table_id,
    transactions.action_date,
    transactions.narrative,
    transactions.document_number,
    transactions.payment_number,
    transactions.order_number,
    transactions.exchange_rate,
    transactions.payment_terms,
    transactions.job,
    transactions.details,
    transactions.notes,
    (transactions.transaction_amount - transactions.transaction_tax_amount) AS transaction_net_amount,
        CASE
            WHEN (transactions.journal_id IS NULL) THEN 'Not Posted'::text
            ELSE 'Posted'::text
        END AS posted,
        CASE
            WHEN ((transactions.transaction_type_id = 2) OR (transactions.transaction_type_id = 8) OR (transactions.transaction_type_id = 10)) THEN transactions.transaction_amount
            ELSE (0)::real
        END AS debit_amount,
        CASE
            WHEN ((transactions.transaction_type_id = 5) OR (transactions.transaction_type_id = 7) OR (transactions.transaction_type_id = 9)) THEN transactions.transaction_amount
            ELSE (0)::real
        END AS credit_amount
   FROM ((((((public.transactions
     JOIN public.transaction_types ON ((transactions.transaction_type_id = transaction_types.transaction_type_id)))
     JOIN public.vw_orgs ON ((transactions.org_id = vw_orgs.org_id)))
     JOIN public.transaction_status ON ((transactions.transaction_status_id = transaction_status.transaction_status_id)))
     JOIN public.currency ON ((transactions.currency_id = currency.currency_id)))
     LEFT JOIN public.vw_entitys ON ((transactions.entity_id = vw_entitys.entity_id)))
     LEFT JOIN public.departments ON ((transactions.department_id = departments.department_id)));


ALTER TABLE public.vw_trx OWNER TO postgres;

--
-- Name: vw_trx_contrib; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_trx_contrib AS
 SELECT aa.member_id,
    aa.member_name,
    aa.org_id,
    aa.deposit_account_id,
    aa.account_number AS trx_accno,
    aa.product_id,
    aa.product_no,
    aa.product_name,
    ab.account_number AS transfer_account_no
   FROM (public.vw_deposit_accounts aa
     LEFT JOIN ( SELECT vw_deposit_accounts.member_id,
            vw_deposit_accounts.account_number
           FROM public.vw_deposit_accounts
          WHERE (vw_deposit_accounts.product_no = 2)) ab ON (((aa.member_id)::text = (ab.member_id)::text)))
  WHERE (aa.product_no = 1);


ALTER TABLE public.vw_trx_contrib OWNER TO postgres;

--
-- Name: vw_trx_sum; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_trx_sum AS
 SELECT transaction_details.transaction_id,
    sum(((((transaction_details.quantity)::double precision * transaction_details.amount) * ((100)::double precision - transaction_details.discount)) / (100)::double precision)) AS total_amount,
    sum(((((transaction_details.quantity)::double precision * transaction_details.tax_amount) * ((100)::double precision - transaction_details.discount)) / (100)::double precision)) AS total_tax_amount,
    sum((((transaction_details.quantity)::double precision * (((100)::double precision - transaction_details.discount) / (100)::double precision)) * (transaction_details.amount + transaction_details.tax_amount))) AS total_sale_amount
   FROM public.transaction_details
  GROUP BY transaction_details.transaction_id;


ALTER TABLE public.vw_trx_sum OWNER TO postgres;

--
-- Name: vw_tx_ledger; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_tx_ledger AS
 SELECT ledger_types.ledger_type_id,
    ledger_types.ledger_type_name,
    ledger_types.account_id,
    ledger_types.ledger_posting,
    currency.currency_id,
    currency.currency_name,
    currency.currency_symbol,
    entitys.entity_id,
    entitys.entity_name,
    bank_accounts.bank_account_id,
    bank_accounts.bank_account_name,
    vw_investments.investment_type_id,
    vw_investments.investment_type_name,
    vw_investments.investment_status_id,
    vw_investments.investment_status_name,
    vw_investments.investment_id,
    vw_investments.investment_name,
    transactions.org_id,
    transactions.transaction_id,
    transactions.journal_id,
    transactions.exchange_rate,
    transactions.tx_type,
    transactions.transaction_date,
    transactions.payment_date,
    transactions.transaction_amount,
    transactions.transaction_tax_amount,
    transactions.reference_number,
    transactions.payment_number,
    transactions.for_processing,
    transactions.completed,
    transactions.is_cleared,
    transactions.application_date,
    transactions.approve_status,
    transactions.workflow_table_id,
    transactions.action_date,
    transactions.narrative,
    transactions.details,
        CASE
            WHEN (transactions.journal_id IS NULL) THEN 'Not Posted'::text
            ELSE 'Posted'::text
        END AS posted,
    to_char((transactions.payment_date)::timestamp with time zone, 'YYYY.MM'::text) AS ledger_period,
    to_char((transactions.payment_date)::timestamp with time zone, 'YYYY'::text) AS ledger_year,
    to_char((transactions.payment_date)::timestamp with time zone, 'Month'::text) AS ledger_month,
    ((transactions.exchange_rate * (transactions.tx_type)::double precision) * transactions.transaction_amount) AS base_amount,
    ((transactions.exchange_rate * (transactions.tx_type)::double precision) * transactions.transaction_tax_amount) AS base_tax_amount,
        CASE
            WHEN (transactions.completed = true) THEN ((transactions.exchange_rate * (transactions.tx_type)::double precision) * transactions.transaction_amount)
            ELSE ((0)::real)::double precision
        END AS base_balance,
        CASE
            WHEN (transactions.is_cleared = true) THEN ((transactions.exchange_rate * (transactions.tx_type)::double precision) * transactions.transaction_amount)
            ELSE ((0)::real)::double precision
        END AS cleared_balance,
        CASE
            WHEN (transactions.tx_type = 1) THEN (transactions.exchange_rate * transactions.transaction_amount)
            ELSE (0)::real
        END AS dr_amount,
        CASE
            WHEN (transactions.tx_type = '-1'::integer) THEN (transactions.exchange_rate * transactions.transaction_amount)
            ELSE (0)::real
        END AS cr_amount
   FROM (((((public.transactions
     JOIN public.currency ON ((transactions.currency_id = currency.currency_id)))
     JOIN public.entitys ON ((transactions.entity_id = entitys.entity_id)))
     LEFT JOIN public.bank_accounts ON ((transactions.bank_account_id = bank_accounts.bank_account_id)))
     LEFT JOIN public.ledger_types ON ((transactions.ledger_type_id = ledger_types.ledger_type_id)))
     LEFT JOIN public.vw_investments ON ((transactions.investment_id = vw_investments.investment_id)))
  WHERE (transactions.tx_type IS NOT NULL);


ALTER TABLE public.vw_tx_ledger OWNER TO postgres;

--
-- Name: vw_workflow_approvals; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_workflow_approvals AS
 SELECT vw_approvals.org_id,
    vw_approvals.approval_id,
    vw_approvals.workflow_id,
    vw_approvals.workflow_name,
    vw_approvals.approve_email,
    vw_approvals.approve_file,
    vw_approvals.reject_file,
    vw_approvals.reject_email,
    vw_approvals.source_entity_id,
    vw_approvals.source_entity_name,
    vw_approvals.table_name,
    vw_approvals.table_id,
    vw_approvals.org_entity_id,
    vw_approvals.org_entity_name,
    vw_approvals.org_user_name,
    vw_approvals.org_primary_email,
    rt.rejected_count,
        CASE
            WHEN (rt.rejected_count IS NULL) THEN ((vw_approvals.workflow_name)::text || ' Approved'::text)
            ELSE ((vw_approvals.workflow_name)::text || ' declined'::text)
        END AS workflow_narrative
   FROM (public.vw_approvals
     LEFT JOIN ( SELECT approvals.table_id,
            count(approvals.approval_id) AS rejected_count
           FROM public.approvals
          WHERE (((approvals.approve_status)::text = 'Rejected'::text) AND (approvals.forward_id IS NULL))
          GROUP BY approvals.table_id) rt ON ((vw_approvals.table_id = rt.table_id)))
  GROUP BY vw_approvals.org_id, vw_approvals.approval_id, vw_approvals.workflow_id, vw_approvals.workflow_name, vw_approvals.approve_email, vw_approvals.approve_file, vw_approvals.reject_file, vw_approvals.reject_email, vw_approvals.source_entity_id, vw_approvals.source_entity_name, vw_approvals.table_name, vw_approvals.table_id, vw_approvals.org_entity_id, vw_approvals.org_entity_name, vw_approvals.org_user_name, vw_approvals.org_primary_email, rt.rejected_count;


ALTER TABLE public.vw_workflow_approvals OWNER TO postgres;

--
-- Name: vw_workflow_entitys; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_workflow_entitys AS
 SELECT vw_workflow_phases.workflow_id,
    vw_workflow_phases.org_id,
    vw_workflow_phases.workflow_name,
    vw_workflow_phases.table_name,
    vw_workflow_phases.table_link_id,
    vw_workflow_phases.source_entity_id,
    vw_workflow_phases.source_entity_name,
    vw_workflow_phases.approve_file,
    vw_workflow_phases.reject_file,
    vw_workflow_phases.approval_entity_id,
    vw_workflow_phases.approval_entity_name,
    vw_workflow_phases.workflow_phase_id,
    vw_workflow_phases.approval_level,
    vw_workflow_phases.return_level,
    vw_workflow_phases.escalation_days,
    vw_workflow_phases.escalation_hours,
    vw_workflow_phases.notice,
    vw_workflow_phases.notice_email,
    vw_workflow_phases.notice_file,
    vw_workflow_phases.advice,
    vw_workflow_phases.advice_email,
    vw_workflow_phases.advice_file,
    vw_workflow_phases.required_approvals,
    vw_workflow_phases.use_reporting,
    vw_workflow_phases.phase_narrative,
    entity_subscriptions.entity_subscription_id,
    entity_subscriptions.entity_id
   FROM (public.vw_workflow_phases
     JOIN public.entity_subscriptions ON ((vw_workflow_phases.source_entity_id = entity_subscriptions.entity_type_id)));


ALTER TABLE public.vw_workflow_entitys OWNER TO postgres;

--
-- Name: workflow_sql; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.workflow_sql (
    workflow_sql_id integer NOT NULL,
    workflow_phase_id integer NOT NULL,
    org_id integer,
    workflow_sql_name character varying(50),
    is_condition boolean DEFAULT false,
    is_action boolean DEFAULT false,
    message text NOT NULL,
    sql text NOT NULL
);


ALTER TABLE public.workflow_sql OWNER TO postgres;

--
-- Name: vw_workflow_sql; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vw_workflow_sql AS
 SELECT workflow_sql.org_id,
    workflow_sql.workflow_sql_id,
    workflow_sql.workflow_phase_id,
    workflow_sql.workflow_sql_name,
    workflow_sql.is_condition,
    workflow_sql.is_action,
    workflow_sql.message,
    workflow_sql.sql,
    approvals.approval_id,
    approvals.org_entity_id,
    approvals.app_entity_id,
    approvals.approval_level,
    approvals.escalation_days,
    approvals.escalation_hours,
    approvals.escalation_time,
    approvals.forward_id,
    approvals.table_name,
    approvals.table_id,
    approvals.application_date,
    approvals.completion_date,
    approvals.action_date,
    approvals.approve_status,
    approvals.approval_narrative
   FROM (public.workflow_sql
     JOIN public.approvals ON ((workflow_sql.workflow_phase_id = approvals.workflow_phase_id)));


ALTER TABLE public.vw_workflow_sql OWNER TO postgres;

--
-- Name: vws_pc_expenditure; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vws_pc_expenditure AS
 SELECT a.org_id,
    a.period_id,
    a.period_year,
    a.period_month,
    a.department_id,
    a.department_name,
    a.pc_allocation_id,
    a.pc_category_id,
    a.pc_category_name,
    a.pc_item_id,
    a.pc_item_name,
    a.sum_units,
    a.avg_unit_price,
    a.sum_items_cost,
    pc_budget.budget_units,
    pc_budget.budget_price,
    ((pc_budget.budget_units)::double precision * pc_budget.budget_price) AS budget_cost,
    (COALESCE(pc_budget.budget_units, 0) - a.sum_units) AS unit_diff,
    (COALESCE(((pc_budget.budget_units)::double precision * pc_budget.budget_price), (0)::double precision) - a.sum_items_cost) AS budget_diff
   FROM (( SELECT vw_pc_expenditure.org_id,
            vw_pc_expenditure.period_id,
            vw_pc_expenditure.period_year,
            vw_pc_expenditure.period_month,
            vw_pc_expenditure.department_id,
            vw_pc_expenditure.department_name,
            vw_pc_expenditure.pc_allocation_id,
            vw_pc_expenditure.pc_category_id,
            vw_pc_expenditure.pc_category_name,
            vw_pc_expenditure.pc_item_id,
            vw_pc_expenditure.pc_item_name,
            sum(vw_pc_expenditure.units) AS sum_units,
            avg(vw_pc_expenditure.unit_price) AS avg_unit_price,
            sum(((vw_pc_expenditure.units)::double precision * vw_pc_expenditure.unit_price)) AS sum_items_cost
           FROM public.vw_pc_expenditure
          GROUP BY vw_pc_expenditure.org_id, vw_pc_expenditure.period_id, vw_pc_expenditure.period_year, vw_pc_expenditure.period_month, vw_pc_expenditure.department_id, vw_pc_expenditure.department_name, vw_pc_expenditure.pc_allocation_id, vw_pc_expenditure.pc_category_id, vw_pc_expenditure.pc_category_name, vw_pc_expenditure.pc_item_id, vw_pc_expenditure.pc_item_name) a
     LEFT JOIN public.pc_budget ON (((a.pc_allocation_id = pc_budget.pc_allocation_id) AND (a.pc_item_id = pc_budget.pc_item_id))));


ALTER TABLE public.vws_pc_expenditure OWNER TO postgres;

--
-- Name: vws_pc_budget_diff; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vws_pc_budget_diff AS
 SELECT a.org_id,
    a.period_id,
    a.period_year,
    a.period_month,
    a.department_id,
    a.department_name,
    a.pc_allocation_id,
    a.pc_category_id,
    a.pc_category_name,
    a.pc_item_id,
    a.pc_item_name,
    a.sum_units,
    a.avg_unit_price,
    a.sum_items_cost,
    a.budget_units,
    a.budget_price,
    a.budget_cost,
    a.unit_diff,
    a.budget_diff
   FROM public.vws_pc_expenditure a
UNION
 SELECT a.org_id,
    a.period_id,
    a.period_year,
    a.period_month,
    a.department_id,
    a.department_name,
    a.pc_allocation_id,
    a.pc_category_id,
    a.pc_category_name,
    a.pc_item_id,
    a.pc_item_name,
    0 AS sum_units,
    0 AS avg_unit_price,
    0 AS sum_items_cost,
    a.budget_units,
    a.budget_price,
    a.budget_cost,
    a.budget_units AS unit_diff,
    a.budget_cost AS budget_diff
   FROM (public.vw_pc_budget a
     LEFT JOIN public.pc_expenditure ON (((a.pc_allocation_id = pc_expenditure.pc_allocation_id) AND (a.pc_item_id = pc_expenditure.pc_item_id))))
  WHERE (pc_expenditure.pc_item_id IS NULL);


ALTER TABLE public.vws_pc_budget_diff OWNER TO postgres;

--
-- Name: vws_tx_ledger; Type: VIEW; Schema: public; Owner: postgres
--

CREATE VIEW public.vws_tx_ledger AS
 SELECT vw_tx_ledger.org_id,
    vw_tx_ledger.ledger_period,
    vw_tx_ledger.ledger_year,
    vw_tx_ledger.ledger_month,
    sum(vw_tx_ledger.base_amount) AS sum_base_amount,
    sum(vw_tx_ledger.base_tax_amount) AS sum_base_tax_amount,
    sum(vw_tx_ledger.base_balance) AS sum_base_balance,
    sum(vw_tx_ledger.cleared_balance) AS sum_cleared_balance,
    sum(vw_tx_ledger.dr_amount) AS sum_dr_amount,
    sum(vw_tx_ledger.cr_amount) AS sum_cr_amount,
    to_date((vw_tx_ledger.ledger_period || '.01'::text), 'YYYY.MM.DD'::text) AS start_date,
    (sum(vw_tx_ledger.base_amount) + public.prev_balance(to_date((vw_tx_ledger.ledger_period || '.01'::text), 'YYYY.MM.DD'::text))) AS prev_balance_amount,
    (sum(vw_tx_ledger.cleared_balance) + public.prev_clear_balance(to_date((vw_tx_ledger.ledger_period || '.01'::text), 'YYYY.MM.DD'::text))) AS prev_clear_balance_amount
   FROM public.vw_tx_ledger
  GROUP BY vw_tx_ledger.org_id, vw_tx_ledger.ledger_period, vw_tx_ledger.ledger_year, vw_tx_ledger.ledger_month;


ALTER TABLE public.vws_tx_ledger OWNER TO postgres;

--
-- Name: workflow_logs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.workflow_logs (
    workflow_log_id integer NOT NULL,
    org_id integer,
    table_name character varying(64),
    table_id integer,
    table_old_id integer
);


ALTER TABLE public.workflow_logs OWNER TO postgres;

--
-- Name: workflow_logs_workflow_log_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.workflow_logs_workflow_log_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.workflow_logs_workflow_log_id_seq OWNER TO postgres;

--
-- Name: workflow_logs_workflow_log_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.workflow_logs_workflow_log_id_seq OWNED BY public.workflow_logs.workflow_log_id;


--
-- Name: workflow_phases_workflow_phase_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.workflow_phases_workflow_phase_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.workflow_phases_workflow_phase_id_seq OWNER TO postgres;

--
-- Name: workflow_phases_workflow_phase_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.workflow_phases_workflow_phase_id_seq OWNED BY public.workflow_phases.workflow_phase_id;


--
-- Name: workflow_sql_workflow_sql_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.workflow_sql_workflow_sql_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.workflow_sql_workflow_sql_id_seq OWNER TO postgres;

--
-- Name: workflow_sql_workflow_sql_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.workflow_sql_workflow_sql_id_seq OWNED BY public.workflow_sql.workflow_sql_id;


--
-- Name: workflow_table_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.workflow_table_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.workflow_table_id_seq OWNER TO postgres;

--
-- Name: workflows_workflow_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.workflows_workflow_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.workflows_workflow_id_seq OWNER TO postgres;

--
-- Name: workflows_workflow_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.workflows_workflow_id_seq OWNED BY public.workflows.workflow_id;


--
-- Name: lg_account_activity_id; Type: DEFAULT; Schema: logs; Owner: postgres
--

ALTER TABLE ONLY logs.lg_account_activity ALTER COLUMN lg_account_activity_id SET DEFAULT nextval('logs.lg_account_activity_lg_account_activity_id_seq'::regclass);


--
-- Name: lg_collateral_id; Type: DEFAULT; Schema: logs; Owner: postgres
--

ALTER TABLE ONLY logs.lg_collaterals ALTER COLUMN lg_collateral_id SET DEFAULT nextval('logs.lg_collaterals_lg_collateral_id_seq'::regclass);


--
-- Name: lg_commodity_trade_id; Type: DEFAULT; Schema: logs; Owner: postgres
--

ALTER TABLE ONLY logs.lg_commodity_trades ALTER COLUMN lg_commodity_trade_id SET DEFAULT nextval('logs.lg_commodity_trades_lg_commodity_trade_id_seq'::regclass);


--
-- Name: lg_deposit_account_id; Type: DEFAULT; Schema: logs; Owner: postgres
--

ALTER TABLE ONLY logs.lg_deposit_accounts ALTER COLUMN lg_deposit_account_id SET DEFAULT nextval('logs.lg_deposit_accounts_lg_deposit_account_id_seq'::regclass);


--
-- Name: lg_guarantee_id; Type: DEFAULT; Schema: logs; Owner: postgres
--

ALTER TABLE ONLY logs.lg_guarantees ALTER COLUMN lg_guarantee_id SET DEFAULT nextval('logs.lg_guarantees_lg_guarantee_id_seq'::regclass);


--
-- Name: lg_loan_id; Type: DEFAULT; Schema: logs; Owner: postgres
--

ALTER TABLE ONLY logs.lg_loans ALTER COLUMN lg_loan_id SET DEFAULT nextval('logs.lg_loans_lg_loan_id_seq'::regclass);


--
-- Name: lg_member_id; Type: DEFAULT; Schema: logs; Owner: postgres
--

ALTER TABLE ONLY logs.lg_members ALTER COLUMN lg_member_id SET DEFAULT nextval('logs.lg_members_lg_member_id_seq'::regclass);


--
-- Name: account_activity_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.account_activity ALTER COLUMN account_activity_id SET DEFAULT nextval('public.account_activity_account_activity_id_seq'::regclass);


--
-- Name: account_class_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.account_class ALTER COLUMN account_class_id SET DEFAULT nextval('public.account_class_account_class_id_seq'::regclass);


--
-- Name: account_defination_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.account_definations ALTER COLUMN account_defination_id SET DEFAULT nextval('public.account_definations_account_defination_id_seq'::regclass);


--
-- Name: account_note_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.account_notes ALTER COLUMN account_note_id SET DEFAULT nextval('public.account_notes_account_note_id_seq'::regclass);


--
-- Name: account_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.account_types ALTER COLUMN account_type_id SET DEFAULT nextval('public.account_types_account_type_id_seq'::regclass);


--
-- Name: account_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.accounts ALTER COLUMN account_id SET DEFAULT nextval('public.accounts_account_id_seq'::regclass);


--
-- Name: activity_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.activity_types ALTER COLUMN activity_type_id SET DEFAULT nextval('public.activity_types_activity_type_id_seq'::regclass);


--
-- Name: address_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.address ALTER COLUMN address_id SET DEFAULT nextval('public.address_address_id_seq'::regclass);


--
-- Name: address_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.address_types ALTER COLUMN address_type_id SET DEFAULT nextval('public.address_types_address_type_id_seq'::regclass);


--
-- Name: applicant_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.applicants ALTER COLUMN applicant_id SET DEFAULT nextval('public.applicants_applicant_id_seq'::regclass);


--
-- Name: approval_checklist_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.approval_checklists ALTER COLUMN approval_checklist_id SET DEFAULT nextval('public.approval_checklists_approval_checklist_id_seq'::regclass);


--
-- Name: approval_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.approvals ALTER COLUMN approval_id SET DEFAULT nextval('public.approvals_approval_id_seq'::regclass);


--
-- Name: bank_account_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bank_accounts ALTER COLUMN bank_account_id SET DEFAULT nextval('public.bank_accounts_bank_account_id_seq'::regclass);


--
-- Name: bank_branch_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bank_branch ALTER COLUMN bank_branch_id SET DEFAULT nextval('public.bank_branch_bank_branch_id_seq'::regclass);


--
-- Name: bank_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.banks ALTER COLUMN bank_id SET DEFAULT nextval('public.banks_bank_id_seq'::regclass);


--
-- Name: bidder_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.bidders ALTER COLUMN bidder_id SET DEFAULT nextval('public.bidders_bidder_id_seq'::regclass);


--
-- Name: block_chain_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.block_chains ALTER COLUMN block_chain_id SET DEFAULT nextval('public.block_chains_block_chain_id_seq'::regclass);


--
-- Name: budget_line_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.budget_lines ALTER COLUMN budget_line_id SET DEFAULT nextval('public.budget_lines_budget_line_id_seq'::regclass);


--
-- Name: budget_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.budgets ALTER COLUMN budget_id SET DEFAULT nextval('public.budgets_budget_id_seq'::regclass);


--
-- Name: checklist_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.checklists ALTER COLUMN checklist_id SET DEFAULT nextval('public.checklists_checklist_id_seq'::regclass);


--
-- Name: collateral_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.collateral_types ALTER COLUMN collateral_type_id SET DEFAULT nextval('public.collateral_types_collateral_type_id_seq'::regclass);


--
-- Name: collateral_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.collaterals ALTER COLUMN collateral_id SET DEFAULT nextval('public.collaterals_collateral_id_seq'::regclass);


--
-- Name: commodity_trade_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.commodity_trades ALTER COLUMN commodity_trade_id SET DEFAULT nextval('public.commodity_trades_commodity_trade_id_seq'::regclass);


--
-- Name: commodity_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.commodity_types ALTER COLUMN commodity_type_id SET DEFAULT nextval('public.commodity_types_commodity_type_id_seq'::regclass);


--
-- Name: commodity_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.commoditys ALTER COLUMN commodity_id SET DEFAULT nextval('public.commoditys_commodity_id_seq'::regclass);


--
-- Name: contract_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.contracts ALTER COLUMN contract_id SET DEFAULT nextval('public.contracts_contract_id_seq'::regclass);


--
-- Name: currency_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.currency ALTER COLUMN currency_id SET DEFAULT nextval('public.currency_currency_id_seq'::regclass);


--
-- Name: currency_rate_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.currency_rates ALTER COLUMN currency_rate_id SET DEFAULT nextval('public.currency_rates_currency_rate_id_seq'::regclass);


--
-- Name: default_account_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.default_accounts ALTER COLUMN default_account_id SET DEFAULT nextval('public.default_accounts_default_account_id_seq'::regclass);


--
-- Name: default_tax_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.default_tax_types ALTER COLUMN default_tax_type_id SET DEFAULT nextval('public.default_tax_types_default_tax_type_id_seq'::regclass);


--
-- Name: department_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.departments ALTER COLUMN department_id SET DEFAULT nextval('public.departments_department_id_seq'::regclass);


--
-- Name: deposit_account_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.deposit_accounts ALTER COLUMN deposit_account_id SET DEFAULT nextval('public.deposit_accounts_deposit_account_id_seq'::regclass);


--
-- Name: e_field_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.e_fields ALTER COLUMN e_field_id SET DEFAULT nextval('public.e_fields_e_field_id_seq'::regclass);


--
-- Name: entity_field_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entity_fields ALTER COLUMN entity_field_id SET DEFAULT nextval('public.entity_fields_entity_field_id_seq'::regclass);


--
-- Name: entity_org_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entity_orgs ALTER COLUMN entity_org_id SET DEFAULT nextval('public.entity_orgs_entity_org_id_seq'::regclass);


--
-- Name: entity_subscription_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entity_subscriptions ALTER COLUMN entity_subscription_id SET DEFAULT nextval('public.entity_subscriptions_entity_subscription_id_seq'::regclass);


--
-- Name: entity_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entity_types ALTER COLUMN entity_type_id SET DEFAULT nextval('public.entity_types_entity_type_id_seq'::regclass);


--
-- Name: entity_value_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entity_values ALTER COLUMN entity_value_id SET DEFAULT nextval('public.entity_values_entity_value_id_seq'::regclass);


--
-- Name: entity_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entitys ALTER COLUMN entity_id SET DEFAULT nextval('public.entitys_entity_id_seq'::regclass);


--
-- Name: entry_form_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.entry_forms ALTER COLUMN entry_form_id SET DEFAULT nextval('public.entry_forms_entry_form_id_seq'::regclass);


--
-- Name: et_field_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.et_fields ALTER COLUMN et_field_id SET DEFAULT nextval('public.et_fields_et_field_id_seq'::regclass);


--
-- Name: field_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.fields ALTER COLUMN field_id SET DEFAULT nextval('public.fields_field_id_seq'::regclass);


--
-- Name: fiscal_year_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.fiscal_years ALTER COLUMN fiscal_year_id SET DEFAULT nextval('public.fiscal_years_fiscal_year_id_seq'::regclass);


--
-- Name: folder_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.folders ALTER COLUMN folder_id SET DEFAULT nextval('public.folders_folder_id_seq'::regclass);


--
-- Name: follow_up_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.follow_up ALTER COLUMN follow_up_id SET DEFAULT nextval('public.follow_up_follow_up_id_seq'::regclass);


--
-- Name: form_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.forms ALTER COLUMN form_id SET DEFAULT nextval('public.forms_form_id_seq'::regclass);


--
-- Name: gl_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.gls ALTER COLUMN gl_id SET DEFAULT nextval('public.gls_gl_id_seq'::regclass);


--
-- Name: group_sms_detail_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.group_sms_details ALTER COLUMN group_sms_detail_id SET DEFAULT nextval('public.group_sms_details_group_sms_detail_id_seq'::regclass);


--
-- Name: guarantee_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.guarantees ALTER COLUMN guarantee_id SET DEFAULT nextval('public.guarantees_guarantee_id_seq'::regclass);


--
-- Name: helpdesk_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.helpdesk ALTER COLUMN helpdesk_id SET DEFAULT nextval('public.helpdesk_helpdesk_id_seq'::regclass);


--
-- Name: holiday_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.holidays ALTER COLUMN holiday_id SET DEFAULT nextval('public.holidays_holiday_id_seq'::regclass);


--
-- Name: industry_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.industry ALTER COLUMN industry_id SET DEFAULT nextval('public.industry_industry_id_seq'::regclass);


--
-- Name: interest_method_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.interest_methods ALTER COLUMN interest_method_id SET DEFAULT nextval('public.interest_methods_interest_method_id_seq'::regclass);


--
-- Name: investment_status_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.investment_status ALTER COLUMN investment_status_id SET DEFAULT nextval('public.investment_status_investment_status_id_seq'::regclass);


--
-- Name: investment_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.investment_types ALTER COLUMN investment_type_id SET DEFAULT nextval('public.investment_types_investment_type_id_seq'::regclass);


--
-- Name: investment_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.investments ALTER COLUMN investment_id SET DEFAULT nextval('public.investments_investment_id_seq'::regclass);


--
-- Name: issue_definition_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.issue_definitions ALTER COLUMN issue_definition_id SET DEFAULT nextval('public.issue_definitions_issue_definition_id_seq'::regclass);


--
-- Name: issue_level_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.issue_levels ALTER COLUMN issue_level_id SET DEFAULT nextval('public.issue_levels_issue_level_id_seq'::regclass);


--
-- Name: issue_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.issue_types ALTER COLUMN issue_type_id SET DEFAULT nextval('public.issue_types_issue_type_id_seq'::regclass);


--
-- Name: item_category_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.item_category ALTER COLUMN item_category_id SET DEFAULT nextval('public.item_category_item_category_id_seq'::regclass);


--
-- Name: item_unit_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.item_units ALTER COLUMN item_unit_id SET DEFAULT nextval('public.item_units_item_unit_id_seq'::regclass);


--
-- Name: item_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.items ALTER COLUMN item_id SET DEFAULT nextval('public.items_item_id_seq'::regclass);


--
-- Name: journal_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.journals ALTER COLUMN journal_id SET DEFAULT nextval('public.journals_journal_id_seq'::regclass);


--
-- Name: kin_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.kin_types ALTER COLUMN kin_type_id SET DEFAULT nextval('public.kin_types_kin_type_id_seq'::regclass);


--
-- Name: kin_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.kins ALTER COLUMN kin_id SET DEFAULT nextval('public.kins_kin_id_seq'::regclass);


--
-- Name: lead_category_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.lead_categorys ALTER COLUMN lead_category_id SET DEFAULT nextval('public.lead_categorys_lead_category_id_seq'::regclass);


--
-- Name: lead_item_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.lead_items ALTER COLUMN lead_item_id SET DEFAULT nextval('public.lead_items_lead_item_id_seq'::regclass);


--
-- Name: lead_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.leads ALTER COLUMN lead_id SET DEFAULT nextval('public.leads_lead_id_seq'::regclass);


--
-- Name: ledger_link_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ledger_links ALTER COLUMN ledger_link_id SET DEFAULT nextval('public.ledger_links_ledger_link_id_seq'::regclass);


--
-- Name: ledger_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ledger_types ALTER COLUMN ledger_type_id SET DEFAULT nextval('public.ledger_types_ledger_type_id_seq'::regclass);


--
-- Name: loan_approval_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_approval ALTER COLUMN loan_approval_id SET DEFAULT nextval('public.loan_approval_loan_approval_id_seq'::regclass);


--
-- Name: loan_approval_level_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_approval_levels ALTER COLUMN loan_approval_level_id SET DEFAULT nextval('public.loan_approval_levels_loan_approval_level_id_seq'::regclass);


--
-- Name: loan_config_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_configs ALTER COLUMN loan_config_id SET DEFAULT nextval('public.loan_configs_loan_config_id_seq'::regclass);


--
-- Name: loan_note_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loan_notes ALTER COLUMN loan_note_id SET DEFAULT nextval('public.loan_notes_loan_note_id_seq'::regclass);


--
-- Name: loan_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.loans ALTER COLUMN loan_id SET DEFAULT nextval('public.loans_loan_id_seq'::regclass);


--
-- Name: location_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.locations ALTER COLUMN location_id SET DEFAULT nextval('public.locations_location_id_seq'::regclass);


--
-- Name: member_import_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.member_imports ALTER COLUMN member_import_id SET DEFAULT nextval('public.member_imports_member_import_id_seq'::regclass);


--
-- Name: member_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.members ALTER COLUMN member_id SET DEFAULT nextval('public.members_member_id_seq'::regclass);


--
-- Name: mpesa_api_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mpesa_api ALTER COLUMN mpesa_api_id SET DEFAULT nextval('public.mpesa_api_mpesa_api_id_seq'::regclass);


--
-- Name: mpesa_trx_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mpesa_trxs ALTER COLUMN mpesa_trx_id SET DEFAULT nextval('public.mpesa_trxs_mpesa_trx_id_seq'::regclass);


--
-- Name: org_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.orgs ALTER COLUMN org_id SET DEFAULT nextval('public.orgs_org_id_seq'::regclass);


--
-- Name: pc_allocation_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pc_allocations ALTER COLUMN pc_allocation_id SET DEFAULT nextval('public.pc_allocations_pc_allocation_id_seq'::regclass);


--
-- Name: pc_banking_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pc_banking ALTER COLUMN pc_banking_id SET DEFAULT nextval('public.pc_banking_pc_banking_id_seq'::regclass);


--
-- Name: pc_budget_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pc_budget ALTER COLUMN pc_budget_id SET DEFAULT nextval('public.pc_budget_pc_budget_id_seq'::regclass);


--
-- Name: pc_category_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pc_category ALTER COLUMN pc_category_id SET DEFAULT nextval('public.pc_category_pc_category_id_seq'::regclass);


--
-- Name: pc_expenditure_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pc_expenditure ALTER COLUMN pc_expenditure_id SET DEFAULT nextval('public.pc_expenditure_pc_expenditure_id_seq'::regclass);


--
-- Name: pc_item_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pc_items ALTER COLUMN pc_item_id SET DEFAULT nextval('public.pc_items_pc_item_id_seq'::regclass);


--
-- Name: pc_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.pc_types ALTER COLUMN pc_type_id SET DEFAULT nextval('public.pc_types_pc_type_id_seq'::regclass);


--
-- Name: penalty_method_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.penalty_methods ALTER COLUMN penalty_method_id SET DEFAULT nextval('public.penalty_methods_penalty_method_id_seq'::regclass);


--
-- Name: period_tax_rate_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.period_tax_rates ALTER COLUMN period_tax_rate_id SET DEFAULT nextval('public.period_tax_rates_period_tax_rate_id_seq'::regclass);


--
-- Name: period_tax_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.period_tax_types ALTER COLUMN period_tax_type_id SET DEFAULT nextval('public.period_tax_types_period_tax_type_id_seq'::regclass);


--
-- Name: period_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.periods ALTER COLUMN period_id SET DEFAULT nextval('public.periods_period_id_seq'::regclass);


--
-- Name: phase_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.phases ALTER COLUMN phase_id SET DEFAULT nextval('public.phases_phase_id_seq'::regclass);


--
-- Name: position_level_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.position_levels ALTER COLUMN position_level_id SET DEFAULT nextval('public.position_levels_position_level_id_seq'::regclass);


--
-- Name: product_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.products ALTER COLUMN product_id SET DEFAULT nextval('public.products_product_id_seq'::regclass);


--
-- Name: quotation_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.quotations ALTER COLUMN quotation_id SET DEFAULT nextval('public.quotations_quotation_id_seq'::regclass);


--
-- Name: reporting_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.reporting ALTER COLUMN reporting_id SET DEFAULT nextval('public.reporting_reporting_id_seq'::regclass);


--
-- Name: sacco_official_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sacco_officials ALTER COLUMN sacco_official_id SET DEFAULT nextval('public.sacco_officials_sacco_official_id_seq'::regclass);


--
-- Name: sms_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sms ALTER COLUMN sms_id SET DEFAULT nextval('public.sms_sms_id_seq'::regclass);


--
-- Name: sms_config_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sms_configs ALTER COLUMN sms_config_id SET DEFAULT nextval('public.sms_configs_sms_config_id_seq'::regclass);


--
-- Name: sms_group_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sms_group ALTER COLUMN sms_group_id SET DEFAULT nextval('public.sms_group_sms_group_id_seq'::regclass);


--
-- Name: sms_group_member_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sms_group_members ALTER COLUMN sms_group_member_id SET DEFAULT nextval('public.sms_group_members_sms_group_member_id_seq'::regclass);


--
-- Name: ss_item_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ss_items ALTER COLUMN ss_item_id SET DEFAULT nextval('public.ss_items_ss_item_id_seq'::regclass);


--
-- Name: ss_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ss_types ALTER COLUMN ss_type_id SET DEFAULT nextval('public.ss_types_ss_type_id_seq'::regclass);


--
-- Name: stock_line_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stock_lines ALTER COLUMN stock_line_id SET DEFAULT nextval('public.stock_lines_stock_line_id_seq'::regclass);


--
-- Name: stock_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stocks ALTER COLUMN stock_id SET DEFAULT nextval('public.stocks_stock_id_seq'::regclass);


--
-- Name: store_movement_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.store_movement ALTER COLUMN store_movement_id SET DEFAULT nextval('public.store_movement_store_movement_id_seq'::regclass);


--
-- Name: store_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stores ALTER COLUMN store_id SET DEFAULT nextval('public.stores_store_id_seq'::regclass);


--
-- Name: sub_field_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sub_fields ALTER COLUMN sub_field_id SET DEFAULT nextval('public.sub_fields_sub_field_id_seq'::regclass);


--
-- Name: subscription_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.subscriptions ALTER COLUMN subscription_id SET DEFAULT nextval('public.subscriptions_subscription_id_seq'::regclass);


--
-- Name: sys_access_entity_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_access_entitys ALTER COLUMN sys_access_entity_id SET DEFAULT nextval('public.sys_access_entitys_sys_access_entity_id_seq'::regclass);


--
-- Name: sys_access_level_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_access_levels ALTER COLUMN sys_access_level_id SET DEFAULT nextval('public.sys_access_levels_sys_access_level_id_seq'::regclass);


--
-- Name: sys_audit_trail_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_audit_trail ALTER COLUMN sys_audit_trail_id SET DEFAULT nextval('public.sys_audit_trail_sys_audit_trail_id_seq'::regclass);


--
-- Name: sys_config_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_configs ALTER COLUMN sys_config_id SET DEFAULT nextval('public.sys_configs_sys_config_id_seq'::regclass);


--
-- Name: sys_dashboard_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_dashboard ALTER COLUMN sys_dashboard_id SET DEFAULT nextval('public.sys_dashboard_sys_dashboard_id_seq'::regclass);


--
-- Name: sys_emailed_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_emailed ALTER COLUMN sys_emailed_id SET DEFAULT nextval('public.sys_emailed_sys_emailed_id_seq'::regclass);


--
-- Name: sys_email_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_emails ALTER COLUMN sys_email_id SET DEFAULT nextval('public.sys_emails_sys_email_id_seq'::regclass);


--
-- Name: sys_error_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_errors ALTER COLUMN sys_error_id SET DEFAULT nextval('public.sys_errors_sys_error_id_seq'::regclass);


--
-- Name: sys_file_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_files ALTER COLUMN sys_file_id SET DEFAULT nextval('public.sys_files_sys_file_id_seq'::regclass);


--
-- Name: sys_language_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_languages ALTER COLUMN sys_language_id SET DEFAULT nextval('public.sys_languages_sys_language_id_seq'::regclass);


--
-- Name: sys_login_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_logins ALTER COLUMN sys_login_id SET DEFAULT nextval('public.sys_logins_sys_login_id_seq'::regclass);


--
-- Name: sys_menu_msg_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_menu_msg ALTER COLUMN sys_menu_msg_id SET DEFAULT nextval('public.sys_menu_msg_sys_menu_msg_id_seq'::regclass);


--
-- Name: sys_news_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_news ALTER COLUMN sys_news_id SET DEFAULT nextval('public.sys_news_sys_news_id_seq'::regclass);


--
-- Name: sys_queries_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_queries ALTER COLUMN sys_queries_id SET DEFAULT nextval('public.sys_queries_sys_queries_id_seq'::regclass);


--
-- Name: sys_reset_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_reset ALTER COLUMN sys_reset_id SET DEFAULT nextval('public.sys_reset_sys_reset_id_seq'::regclass);


--
-- Name: sys_translation_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sys_translations ALTER COLUMN sys_translation_id SET DEFAULT nextval('public.sys_translations_sys_translation_id_seq'::regclass);


--
-- Name: task_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tasks ALTER COLUMN task_id SET DEFAULT nextval('public.tasks_task_id_seq'::regclass);


--
-- Name: tax_rate_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tax_rates ALTER COLUMN tax_rate_id SET DEFAULT nextval('public.tax_rates_tax_rate_id_seq'::regclass);


--
-- Name: tax_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tax_types ALTER COLUMN tax_type_id SET DEFAULT nextval('public.tax_types_tax_type_id_seq'::regclass);


--
-- Name: tender_item_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tender_items ALTER COLUMN tender_item_id SET DEFAULT nextval('public.tender_items_tender_item_id_seq'::regclass);


--
-- Name: tender_type_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tender_types ALTER COLUMN tender_type_id SET DEFAULT nextval('public.tender_types_tender_type_id_seq'::regclass);


--
-- Name: tender_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tenders ALTER COLUMN tender_id SET DEFAULT nextval('public.tenders_tender_id_seq'::regclass);


--
-- Name: transaction_counter_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transaction_counters ALTER COLUMN transaction_counter_id SET DEFAULT nextval('public.transaction_counters_transaction_counter_id_seq'::regclass);


--
-- Name: transaction_detail_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transaction_details ALTER COLUMN transaction_detail_id SET DEFAULT nextval('public.transaction_details_transaction_detail_id_seq'::regclass);


--
-- Name: transaction_link_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transaction_links ALTER COLUMN transaction_link_id SET DEFAULT nextval('public.transaction_links_transaction_link_id_seq'::regclass);


--
-- Name: transaction_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transactions ALTER COLUMN transaction_id SET DEFAULT nextval('public.transactions_transaction_id_seq'::regclass);


--
-- Name: transfer_activity_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transfer_activity ALTER COLUMN transfer_activity_id SET DEFAULT nextval('public.transfer_activity_transfer_activity_id_seq'::regclass);


--
-- Name: transfer_beneficiary_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.transfer_beneficiary ALTER COLUMN transfer_beneficiary_id SET DEFAULT nextval('public.transfer_beneficiary_transfer_beneficiary_id_seq'::regclass);


--
-- Name: workflow_log_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.workflow_logs ALTER COLUMN workflow_log_id SET DEFAULT nextval('public.workflow_logs_workflow_log_id_seq'::regclass);


--
-- Name: workflow_phase_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.workflow_phases ALTER COLUMN workflow_phase_id SET DEFAULT nextval('public.workflow_phases_workflow_phase_id_seq'::regclass);


--
-- Name: workflow_sql_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.workflow_sql ALTER COLUMN workflow_sql_id SET DEFAULT nextval('public.workflow_sql_workflow_sql_id_seq'::regclass);


--
-- Name: workflow_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.workflows ALTER COLUMN workflow_id SET DEFAULT nextval('public.workflows_workflow_id_seq'::regclass);


--
-- Data for Name: lg_account_activity; Type: TABLE DATA; Schema: logs; Owner: postgres
--



--
-- Name: lg_account_activity_lg_account_activity_id_seq; Type: SEQUENCE SET; Schema: logs; Owner: postgres
--

SELECT pg_catalog.setval('logs.lg_account_activity_lg_account_activity_id_seq', 1, false);


--
-- Data for Name: lg_collaterals; Type: TABLE DATA; Schema: logs; Owner: postgres
--



--
-- Name: lg_collaterals_lg_collateral_id_seq; Type: SEQUENCE SET; Schema: logs; Owner: postgres
--

SELECT pg_catalog.setval('logs.lg_collaterals_lg_collateral_id_seq', 1, false);


--
-- Data for Name: lg_commodity_trades; Type: TABLE DATA; Schema: logs; Owner: postgres
--



--
-- Name: lg_commodity_trades_lg_commodity_trade_id_seq; Type: SEQUENCE SET; Schema: logs; Owner: postgres
--

SELECT pg_catalog.setval('logs.lg_commodity_trades_lg_commodity_trade_id_seq', 1, false);


--
-- Data for Name: lg_deposit_accounts; Type: TABLE DATA; Schema: logs; Owner: postgres
--

INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (1, 101, 1, 1, 4, 0, 0, true, '400000101', NULL, '2017-02-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (2, 102, 2, 1, 4, 0, 0, true, '400000201', NULL, '2017-03-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (3, 103, 3, 1, 4, 0, 0, true, '400000301', NULL, '2017-04-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (4, 104, 4, 1, 4, 0, 0, true, '400000401', NULL, '2017-05-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (5, 105, 5, 1, 4, 0, 0, true, '400000501', NULL, '2017-06-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (6, 106, 6, 1, 4, 0, 0, true, '400000601', NULL, '2017-07-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (7, 107, 7, 1, 4, 0, 0, true, '400000701', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (8, 108, 8, 1, 4, 0, 0, true, '400000801', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (9, 109, 9, 1, 4, 0, 0, true, '400000901', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (10, 110, 10, 1, 4, 0, 0, true, '400001001', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (11, 111, 1, 2, 4, 0, 0, true, '400000102', NULL, '2017-02-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (12, 112, 2, 2, 4, 0, 0, true, '400000202', NULL, '2017-03-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (13, 113, 3, 2, 4, 0, 0, true, '400000302', NULL, '2017-04-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (14, 114, 4, 2, 4, 0, 0, true, '400000402', NULL, '2017-05-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (15, 115, 5, 2, 4, 0, 0, true, '400000502', NULL, '2017-06-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (16, 116, 6, 2, 4, 0, 0, true, '400000602', NULL, '2017-07-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (17, 117, 7, 2, 4, 0, 0, true, '400000702', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (18, 118, 8, 2, 4, 0, 0, true, '400000802', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (19, 119, 9, 2, 4, 0, 0, true, '400000902', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (20, 120, 10, 2, 4, 0, 0, true, '400001002', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (21, 101, 1, 1, 4, 0, 0, true, '400000101', NULL, '2017-02-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 11, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (22, 102, 2, 1, 4, 0, 0, true, '400000201', NULL, '2017-03-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 12, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (23, 103, 3, 1, 4, 0, 0, true, '400000301', NULL, '2017-04-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 13, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (24, 104, 4, 1, 4, 0, 0, true, '400000401', NULL, '2017-05-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 14, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (25, 105, 5, 1, 4, 0, 0, true, '400000501', NULL, '2017-06-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 15, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (26, 106, 6, 1, 4, 0, 0, true, '400000601', NULL, '2017-07-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 16, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (27, 107, 7, 1, 4, 0, 0, true, '400000701', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 17, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (28, 108, 8, 1, 4, 0, 0, true, '400000801', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 18, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (29, 109, 9, 1, 4, 0, 0, true, '400000901', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 19, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (30, 110, 10, 1, 4, 0, 0, true, '400001001', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 20, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (31, 111, 1, 2, 4, 0, 0, true, '400000102', NULL, '2017-02-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 21, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (32, 112, 2, 2, 4, 0, 0, true, '400000202', NULL, '2017-03-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 22, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (33, 113, 3, 2, 4, 0, 0, true, '400000302', NULL, '2017-04-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 23, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (34, 114, 4, 2, 4, 0, 0, true, '400000402', NULL, '2017-05-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 24, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (35, 115, 5, 2, 4, 0, 0, true, '400000502', NULL, '2017-06-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 25, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (36, 116, 6, 2, 4, 0, 0, true, '400000602', NULL, '2017-07-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 26, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (37, 117, 7, 2, 4, 0, 0, true, '400000702', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 27, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (38, 118, 8, 2, 4, 0, 0, true, '400000802', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 28, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (39, 119, 9, 2, 4, 0, 0, true, '400000902', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 29, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_deposit_accounts (lg_deposit_account_id, deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (40, 120, 10, 2, 4, 0, 0, true, '400001002', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Completed', 30, NULL, NULL, '2019-01-31 11:57:00.083365');


--
-- Name: lg_deposit_accounts_lg_deposit_account_id_seq; Type: SEQUENCE SET; Schema: logs; Owner: postgres
--

SELECT pg_catalog.setval('logs.lg_deposit_accounts_lg_deposit_account_id_seq', 40, true);


--
-- Data for Name: lg_guarantees; Type: TABLE DATA; Schema: logs; Owner: postgres
--



--
-- Name: lg_guarantees_lg_guarantee_id_seq; Type: SEQUENCE SET; Schema: logs; Owner: postgres
--

SELECT pg_catalog.setval('logs.lg_guarantees_lg_guarantee_id_seq', 1, false);


--
-- Data for Name: lg_loans; Type: TABLE DATA; Schema: logs; Owner: postgres
--

INSERT INTO logs.lg_loans (lg_loan_id, loan_id, member_id, product_id, activity_frequency_id, entity_id, org_id, account_number, disburse_account, principal_amount, interest_rate, repayment_amount, repayment_period, disbursed_date, matured_date, expected_matured_date, expected_repayment, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (1, 1, 1, 4, 4, 0, 0, '5000001001', '400000101', 100000, 12, 10558.208, 10, '2017-04-12', NULL, NULL, 105582.078, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_loans (lg_loan_id, loan_id, member_id, product_id, activity_frequency_id, entity_id, org_id, account_number, disburse_account, principal_amount, interest_rate, repayment_amount, repayment_period, disbursed_date, matured_date, expected_matured_date, expected_repayment, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (2, 2, 4, 4, 4, 0, 0, '5000004001', '400000401', 50000, 12, 5279.104, 10, '2017-05-12', NULL, NULL, 52791.0391, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_loans (lg_loan_id, loan_id, member_id, product_id, activity_frequency_id, entity_id, org_id, account_number, disburse_account, principal_amount, interest_rate, repayment_amount, repayment_period, disbursed_date, matured_date, expected_matured_date, expected_repayment, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (3, 1, 1, 4, 4, 0, 0, '5000001001', '400000101', 100000, 12, 10558.208, 10, '2017-04-12', NULL, NULL, 105582.078, '2019-01-31 11:57:00.083365', 'Completed', 31, NULL, NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_loans (lg_loan_id, loan_id, member_id, product_id, activity_frequency_id, entity_id, org_id, account_number, disburse_account, principal_amount, interest_rate, repayment_amount, repayment_period, disbursed_date, matured_date, expected_matured_date, expected_repayment, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (4, 2, 4, 4, 4, 0, 0, '5000004001', '400000401', 50000, 12, 5279.104, 10, '2017-05-12', NULL, NULL, 52791.0391, '2019-01-31 11:57:00.083365', 'Completed', 32, NULL, NULL, '2019-01-31 11:57:00.083365');


--
-- Name: lg_loans_lg_loan_id_seq; Type: SEQUENCE SET; Schema: logs; Owner: postgres
--

SELECT pg_catalog.setval('logs.lg_loans_lg_loan_id_seq', 4, true);


--
-- Data for Name: lg_members; Type: TABLE DATA; Schema: logs; Owner: postgres
--

INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (1, 1, 0, 0, 0, 'Mr', 'Peter Mwangi', '30043751', 'ID', 'peter@peter.me.ke', '0797897897', NULL, '0725741369', 'Nairobi', NULL, '2010-06-08', 'M', 'KE', 'S', NULL, true, false, 'Dew CIS Solutions Ltd', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 14:14:49.971406', 'Completed', 1, '2017-06-07 15:09:33.906413', NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (2, 2, 0, 0, 0, 'Miss', 'Dorcas Mwigereri', '258741369', 'ID', 'dmwigereri@gmail.com', '0708066768', NULL, '3698547', 'Nairobi', '00200', '1993-06-09', 'F', 'KE', 'S', NULL, true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 15:06:57.308398', 'Completed', 2, '2017-06-07 15:09:33.922914', NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (3, 3, 0, 0, 0, 'Mr', 'Haron Korir', '22165656295', 'ID', 'hkorir@gmail.com', '0723456987', NULL, '22564', 'Nairobi', '00200', '1990-08-09', 'M', 'KE', 'M', NULL, true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 15:06:57.308398', 'Completed', 3, '2017-06-07 15:09:33.922914', NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (4, 4, 0, 0, 0, 'Miss', 'Faith Mandela', '300741369', 'ID', 'fmandela@gmail.com', '0782456852', NULL, '35874', 'Nairobi', '00200', '1993-09-12', 'F', 'KE', 'S', NULL, true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 15:06:57.308398', 'Completed', 4, '2017-06-07 15:09:33.922914', NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (5, 5, 0, 0, 0, 'Mr', 'Kamau M. Yoz', '272645978655', 'ID', 'mkamau@gmail.com', '0729357951', NULL, '20058', 'Nairobi', '00200', '1989-02-09', 'M', 'KE', 'S', NULL, true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 15:06:57.308398', 'Completed', 5, '2017-06-07 15:09:33.922914', NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (6, 6, 0, 0, 0, 'Miss', 'Florence Ngugi', '24798523625', 'ID', 'fngugi@gmail.com', '0715258963', NULL, '32547', 'Nairobi', '00200', '1987-07-09', 'F', 'KE', 'S', NULL, true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 15:06:57.308398', 'Completed', 6, '2017-06-07 15:09:33.922914', NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (7, 7, 0, 0, 0, 'Mr', 'Dennis Gichangi', '2015648970', 'ID', 'dennis@dennis.me.ke', '0725564978', NULL, '99987', 'Nairobi', '00200', '1983-06-09', 'M', 'KE', 'M', NULL, true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 15:06:57.308398', 'Completed', 7, '2017-06-07 15:09:33.922914', NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (8, 8, 0, 0, 0, 'Mr', 'Francis Chege', '2956481440', 'ID', 'fchege@gmail.com', '0788268751', NULL, '20202', 'Nairobi', '00200', '1991-06-09', 'M', 'KE', 'S', NULL, true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 15:06:57.308398', 'Completed', 8, '2017-06-07 15:09:33.922914', NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (9, 9, 0, 0, 0, 'Mr', 'Evin Mwailongo', '3005987432', 'ID', 'evin@gmail.com', '0755468913', NULL, '30025', 'Nairobi', '00200', '1992-06-09', 'M', 'KE', 'S', NULL, true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 15:06:57.308398', 'Completed', 9, '2017-06-07 15:09:33.922914', NULL, '2019-01-31 11:57:00.083365');
INSERT INTO logs.lg_members (lg_member_id, member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, application_date, approve_status, workflow_table_id, action_date, details, created) VALUES (10, 10, 0, 0, 0, 'Mrs', 'Rachel Mogire', '2897564130', 'ID', 'rmogire@gmail.com', '0709456258', NULL, '580698', 'Nairobi', '00200', '1991-06-09', 'F', 'KE', 'M', NULL, true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, '2017-06-07 15:06:57.308398', 'Completed', 10, '2017-06-07 15:09:33.922914', NULL, '2019-01-31 11:57:00.083365');


--
-- Name: lg_members_lg_member_id_seq; Type: SEQUENCE SET; Schema: logs; Owner: postgres
--

SELECT pg_catalog.setval('logs.lg_members_lg_member_id_seq', 10, true);


--
-- Data for Name: account_activity; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (245, 101, 2, 21, 1, 1, NULL, 2, 0, 0, 101, NULL, NULL, '400000002', '2017-02-02', '2017-02-02', 0, 1000, -1000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (246, 2, 101, 21, 1, 1, NULL, 2, 0, 0, 101, NULL, NULL, '400000101', '2017-02-02', '2017-02-02', 1000, 0, 1000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (247, 101, 1, 2, 1, 1, NULL, 2, 0, 0, 115, NULL, NULL, '400000001', '2017-02-10', '2017-02-10', 250000, 0, 249000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (248, 1, 101, 2, 1, 1, NULL, 2, 0, 0, 115, NULL, NULL, '400000101', '2017-02-10', '2017-02-10', 0, 250000, -250000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (249, 102, 2, 21, 1, 1, NULL, 3, 0, 0, 102, NULL, NULL, '400000002', '2017-03-02', '2017-03-02', 0, 1000, -1000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (250, 2, 102, 21, 1, 1, NULL, 3, 0, 0, 102, NULL, NULL, '400000201', '2017-03-02', '2017-03-02', 1000, 0, 2000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (251, 101, 1, 2, 1, 1, NULL, 3, 0, 0, 127, NULL, NULL, '400000001', '2017-03-05', '2017-03-05', 15000, 0, 264000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (252, 1, 101, 2, 1, 1, NULL, 3, 0, 0, 127, NULL, NULL, '400000101', '2017-03-05', '2017-03-05', 0, 15000, -265000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (253, 102, 1, 2, 1, 1, NULL, 3, 0, 0, 116, NULL, NULL, '400000001', '2017-03-10', '2017-03-10', 140000, 0, 139000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (254, 103, 1, 2, 1, 1, NULL, 3, 0, 0, 117, NULL, NULL, '400000001', '2017-03-10', '2017-08-10', 45000, 0, 45000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (255, 1, 102, 2, 1, 1, NULL, 3, 0, 0, 116, NULL, NULL, '400000201', '2017-03-10', '2017-03-10', 0, 140000, -405000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (256, 1, 103, 2, 1, 1, NULL, 3, 0, 0, 117, NULL, NULL, '400000301', '2017-03-10', '2017-08-10', 0, 45000, -450000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (257, 103, 2, 21, 1, 1, NULL, 4, 0, 0, 103, NULL, NULL, '400000002', '2017-04-02', '2017-04-02', 0, 1000, 44000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (258, 2, 103, 21, 1, 1, NULL, 4, 0, 0, 103, NULL, NULL, '400000301', '2017-04-02', '2017-04-02', 1000, 0, 3000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (259, 101, 1, 2, 1, 1, NULL, 4, 0, 0, 128, NULL, NULL, '400000001', '2017-04-05', '2017-04-05', 15000, 0, 279000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (260, 1, 101, 2, 1, 1, NULL, 4, 0, 0, 128, NULL, NULL, '400000101', '2017-04-05', '2017-04-05', 0, 15000, -465000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (261, 104, 1, 2, 1, 1, NULL, 4, 0, 0, 118, NULL, NULL, '400000001', '2017-04-10', '2017-04-10', 74000, 0, 74000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (262, 1, 104, 2, 1, 1, NULL, 4, 0, 0, 118, NULL, NULL, '400000401', '2017-04-10', '2017-04-10', 0, 74000, -539000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (263, 101, 1, 5, 1, 1, NULL, 4, 0, 0, 125, NULL, NULL, '400000001', '2017-04-10', '2017-04-14', 0, 95000, 184000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (264, 106, 1, 5, 1, 1, NULL, 4, 0, 0, 126, NULL, NULL, '400000001', '2017-04-10', '2017-05-14', 0, 40000, -40000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (265, 1, 101, 5, 1, 1, NULL, 4, 0, 0, 125, NULL, NULL, '400000101', '2017-04-10', '2017-04-14', 95000, 0, -444000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (266, 1, 106, 5, 1, 1, NULL, 4, 0, 0, 126, NULL, NULL, '400000601', '2017-04-10', '2017-05-14', 40000, 0, -404000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (267, NULL, 2, 29, 1, 1, NULL, 4, 0, 0, 111, NULL, NULL, '400000002', '2017-04-12', '2017-04-12', 0, 2000, -2000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (268, 2, NULL, 29, 1, 1, NULL, 4, 0, 0, 111, NULL, NULL, '5000001001', '2017-04-12', '2017-04-12', 2000, 0, 5000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (269, NULL, 101, 11, 1, 1, NULL, 4, NULL, 0, 112, NULL, NULL, '400000101', '2017-04-12', '2017-04-12', 0, 100000, -102000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (270, 101, NULL, 11, 1, 1, NULL, 4, NULL, 0, 112, NULL, NULL, '5000001001', '2017-04-12', '2017-04-12', 100000, 0, 284000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (271, 104, 2, 21, 1, 1, NULL, 5, 0, 0, 104, NULL, NULL, '400000002', '2017-05-02', '2017-05-02', 0, 1000, 73000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (272, 2, 104, 21, 1, 1, NULL, 5, 0, 0, 104, NULL, NULL, '400000401', '2017-05-02', '2017-05-02', 1000, 0, 6000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (273, 101, 1, 2, 1, 1, NULL, 5, 0, 0, 129, NULL, NULL, '400000001', '2017-05-05', '2017-05-05', 15000, 0, 299000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (274, 1, 101, 2, 1, 1, NULL, 5, 0, 0, 129, NULL, NULL, '400000101', '2017-05-05', '2017-05-05', 0, 15000, -419000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (275, NULL, 2, 29, 1, 1, NULL, 5, 0, 0, 113, NULL, NULL, '400000002', '2017-05-12', '2017-05-12', 0, 2000, -2000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (276, 2, NULL, 29, 1, 1, NULL, 5, 0, 0, 113, NULL, NULL, '5000004001', '2017-05-12', '2017-05-12', 2000, 0, 8000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (277, NULL, 104, 11, 1, 1, NULL, 5, NULL, 0, 114, NULL, NULL, '400000401', '2017-05-12', '2017-05-12', 0, 50000, -52000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (278, 104, NULL, 11, 1, 1, NULL, 5, NULL, 0, 114, NULL, NULL, '5000004001', '2017-05-12', '2017-05-12', 50000, 0, 123000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (279, NULL, 3, 8, 1, 1, NULL, 5, NULL, 0, 169, NULL, NULL, '400000003', '2017-05-31', '2017-05-31', 0, 1020, -103020, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (280, 3, NULL, 8, 1, 1, NULL, 5, NULL, 0, 169, NULL, NULL, '5000001001', '2017-05-31', '2017-05-31', 1020, 0, 1020, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (281, NULL, 101, 10, 1, 1, NULL, 5, NULL, 0, 170, NULL, NULL, '400000101', '2017-05-31', '2017-05-31', 10558.208, 0, -92461.7891, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (282, 101, NULL, 10, 1, 1, NULL, 5, NULL, 0, 170, NULL, NULL, '5000001001', '2017-05-31', '2017-05-31', 0, 10558.208, 288441.781, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (283, 105, 2, 21, 1, 1, NULL, 6, 0, 0, 105, NULL, NULL, '400000002', '2017-06-02', '2017-06-02', 0, 1000, -1000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (284, 2, 105, 21, 1, 1, NULL, 6, 0, 0, 105, NULL, NULL, '400000501', '2017-06-02', '2017-06-02', 1000, 0, 9000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (285, 101, 1, 2, 1, 1, NULL, 6, 0, 0, 130, NULL, NULL, '400000001', '2017-06-05', '2017-06-05', 15000, 0, 303441.781, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (286, 1, 101, 2, 1, 1, NULL, 6, 0, 0, 130, NULL, NULL, '400000101', '2017-06-05', '2017-06-05', 0, 15000, -434000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (287, NULL, 3, 8, 1, 1, NULL, 6, NULL, 0, 171, NULL, NULL, '400000003', '2017-06-30', '2017-06-30', 0, 924.61792, -93386.4062, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (288, 3, NULL, 8, 1, 1, NULL, 6, NULL, 0, 171, NULL, NULL, '5000001001', '2017-06-30', '2017-06-30', 924.61792, 0, 1944.61792, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (289, NULL, 101, 10, 1, 1, NULL, 6, NULL, 0, 172, NULL, NULL, '400000101', '2017-06-30', '2017-06-30', 10558.208, 0, -82828.1953, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (290, 101, NULL, 10, 1, 1, NULL, 6, NULL, 0, 172, NULL, NULL, '5000001001', '2017-06-30', '2017-06-30', 0, 10558.208, 292883.594, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (291, NULL, 3, 8, 1, 1, NULL, 6, NULL, 0, 173, NULL, NULL, '400000003', '2017-06-30', '2017-06-30', 0, 520, -52520, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (292, 3, NULL, 8, 1, 1, NULL, 6, NULL, 0, 173, NULL, NULL, '5000004001', '2017-06-30', '2017-06-30', 520, 0, 2464.61792, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (293, NULL, 104, 10, 1, 1, NULL, 6, NULL, 0, 174, NULL, NULL, '400000401', '2017-06-30', '2017-06-30', 5279.104, 0, -47240.8945, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (294, 104, NULL, 10, 1, 1, NULL, 6, NULL, 0, 174, NULL, NULL, '5000004001', '2017-06-30', '2017-06-30', 0, 5279.104, 117720.898, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (295, 106, 2, 21, 1, 1, NULL, 7, 0, 0, 106, NULL, NULL, '400000002', '2017-07-02', '2017-07-02', 0, 1000, -41000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (296, 2, 106, 21, 1, 1, NULL, 7, 0, 0, 106, NULL, NULL, '400000601', '2017-07-02', '2017-07-02', 1000, 0, 10000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (297, 101, 1, 2, 1, 1, NULL, 7, 0, 0, 131, NULL, NULL, '400000001', '2017-07-05', '2017-07-05', 15000, 0, 307883.594, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (298, 1, 101, 2, 1, 1, NULL, 7, 0, 0, 131, NULL, NULL, '400000101', '2017-07-05', '2017-07-05', 0, 15000, -449000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (299, 106, 1, 2, 1, 1, NULL, 7, 0, 0, 150, NULL, NULL, '400000001', '2017-07-05', '2017-07-05', 5500, 0, -35500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (300, 1, 106, 2, 1, 1, NULL, 7, 0, 0, 150, NULL, NULL, '400000601', '2017-07-05', '2017-07-05', 0, 5500, -454500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (301, 105, 1, 2, 1, 1, NULL, 7, 0, 0, 119, NULL, NULL, '400000001', '2017-07-10', '2017-07-10', 55000, 0, 54000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (302, 1, 105, 2, 1, 1, NULL, 7, 0, 0, 119, NULL, NULL, '400000501', '2017-07-10', '2017-07-10', 0, 55000, -509500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (303, NULL, 3, 8, 1, 1, NULL, 7, NULL, 0, 175, NULL, NULL, '400000003', '2017-07-31', '2017-07-31', 0, 828.282043, -83656.4844, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (304, 3, NULL, 8, 1, 1, NULL, 7, NULL, 0, 175, NULL, NULL, '5000001001', '2017-07-31', '2017-07-31', 828.282043, 0, 3292.8999, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (305, NULL, 101, 10, 1, 1, NULL, 7, NULL, 0, 176, NULL, NULL, '400000101', '2017-07-31', '2017-07-31', 10558.208, 0, -73098.2734, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (306, 101, NULL, 10, 1, 1, NULL, 7, NULL, 0, 176, NULL, NULL, '5000001001', '2017-07-31', '2017-07-31', 0, 10558.208, 297325.375, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (307, NULL, 3, 8, 1, 1, NULL, 7, NULL, 0, 177, NULL, NULL, '400000003', '2017-07-31', '2017-07-31', 0, 472.408966, -47713.3047, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (308, 3, NULL, 8, 1, 1, NULL, 7, NULL, 0, 177, NULL, NULL, '5000004001', '2017-07-31', '2017-07-31', 472.408966, 0, 3765.30884, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (309, NULL, 104, 10, 1, 1, NULL, 7, NULL, 0, 178, NULL, NULL, '400000401', '2017-07-31', '2017-07-31', 5279.104, 0, -42434.1992, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (310, 104, NULL, 10, 1, 1, NULL, 7, NULL, 0, 178, NULL, NULL, '5000004001', '2017-07-31', '2017-07-31', 0, 5279.104, 112441.789, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (311, 107, 2, 21, 1, 1, NULL, 8, 0, 0, 107, NULL, NULL, '400000002', '2017-08-02', '2017-08-02', 0, 1000, -1000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (312, 2, 107, 21, 1, 1, NULL, 8, 0, 0, 107, NULL, NULL, '400000701', '2017-08-02', '2017-08-02', 1000, 0, 11000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (313, 108, 2, 21, 1, 1, NULL, 8, 0, 0, 108, NULL, NULL, '400000002', '2017-08-02', '2017-08-02', 0, 1000, -1000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (314, 2, 108, 21, 1, 1, NULL, 8, 0, 0, 108, NULL, NULL, '400000801', '2017-08-02', '2017-08-02', 1000, 0, 12000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (315, 109, 2, 21, 1, 1, NULL, 8, 0, 0, 109, NULL, NULL, '400000002', '2017-08-02', '2017-08-02', 0, 1000, -1000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (316, 2, 109, 21, 1, 1, NULL, 8, 0, 0, 109, NULL, NULL, '400000901', '2017-08-02', '2017-08-02', 1000, 0, 13000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (317, 110, 2, 21, 1, 1, NULL, 8, 0, 0, 110, NULL, NULL, '400000002', '2017-08-02', '2017-08-02', 0, 1000, -1000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (318, 2, 110, 21, 1, 1, NULL, 8, 0, 0, 110, NULL, NULL, '400001001', '2017-08-02', '2017-08-02', 1000, 0, 14000, 1, false, 1, 1, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (319, 101, 1, 2, 1, 1, NULL, 8, 0, 0, 132, NULL, NULL, '400000001', '2017-08-05', '2017-08-05', 15000, 0, 312325.375, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (320, 1, 101, 2, 1, 1, NULL, 8, 0, 0, 132, NULL, NULL, '400000101', '2017-08-05', '2017-08-05', 0, 15000, -524500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (321, 106, 1, 2, 1, 1, NULL, 8, 0, 0, 151, NULL, NULL, '400000001', '2017-08-05', '2017-08-05', 5500, 0, -30000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (322, 1, 106, 2, 1, 1, NULL, 8, 0, 0, 151, NULL, NULL, '400000601', '2017-08-05', '2017-08-05', 0, 5500, -530000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (323, 106, 1, 2, 1, 1, NULL, 8, 0, 0, 120, NULL, NULL, '400000001', '2017-08-10', '2017-08-10', 45000, 0, 15000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (324, 1, 106, 2, 1, 1, NULL, 8, 0, 0, 120, NULL, NULL, '400000601', '2017-08-10', '2017-08-10', 0, 45000, -575000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (325, NULL, 3, 8, 1, 1, NULL, 8, NULL, 0, 179, NULL, NULL, '400000003', '2017-08-31', '2017-08-31', 0, 730.982788, -73829.2656, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (326, 3, NULL, 8, 1, 1, NULL, 8, NULL, 0, 179, NULL, NULL, '5000001001', '2017-08-31', '2017-08-31', 730.982788, 0, 4496.29199, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (327, NULL, 101, 10, 1, 1, NULL, 8, NULL, 0, 180, NULL, NULL, '400000101', '2017-08-31', '2017-08-31', 10558.208, 0, -63271.0508, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (328, 101, NULL, 10, 1, 1, NULL, 8, NULL, 0, 180, NULL, NULL, '5000001001', '2017-08-31', '2017-08-31', 0, 10558.208, 301767.156, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (329, NULL, 3, 8, 1, 1, NULL, 8, NULL, 0, 181, NULL, NULL, '400000003', '2017-08-31', '2017-08-31', 0, 424.342041, -42858.5469, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (330, 3, NULL, 8, 1, 1, NULL, 8, NULL, 0, 181, NULL, NULL, '5000004001', '2017-08-31', '2017-08-31', 424.342041, 0, 4920.63379, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (331, NULL, 104, 10, 1, 1, NULL, 8, NULL, 0, 182, NULL, NULL, '400000401', '2017-08-31', '2017-08-31', 5279.104, 0, -37579.4375, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (332, 104, NULL, 10, 1, 1, NULL, 8, NULL, 0, 182, NULL, NULL, '5000004001', '2017-08-31', '2017-08-31', 0, 5279.104, 107162.695, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (333, 101, 1, 2, 1, 1, NULL, 9, 0, 0, 133, NULL, NULL, '400000001', '2017-09-05', '2017-09-05', 15000, 0, 316767.188, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (334, 1, 101, 2, 1, 1, NULL, 9, 0, 0, 133, NULL, NULL, '400000101', '2017-09-05', '2017-09-05', 0, 15000, -590000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (335, 106, 1, 2, 1, 1, NULL, 9, 0, 0, 152, NULL, NULL, '400000001', '2017-09-05', '2017-09-05', 5500, 0, 20500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (336, 1, 106, 2, 1, 1, NULL, 9, 0, 0, 152, NULL, NULL, '400000601', '2017-09-05', '2017-09-05', 0, 5500, -595500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (337, NULL, 3, 8, 1, 1, NULL, 9, NULL, 0, 183, NULL, NULL, '400000003', '2017-09-30', '2017-09-30', 0, 632.71051, -63903.7617, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (338, 3, NULL, 8, 1, 1, NULL, 9, NULL, 0, 183, NULL, NULL, '5000001001', '2017-09-30', '2017-09-30', 632.71051, 0, 5553.34424, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (339, NULL, 101, 10, 1, 1, NULL, 9, NULL, 0, 184, NULL, NULL, '400000101', '2017-09-30', '2017-09-30', 10558.208, 0, -53345.5547, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (340, 101, NULL, 10, 1, 1, NULL, 9, NULL, 0, 184, NULL, NULL, '5000001001', '2017-09-30', '2017-09-30', 0, 10558.208, 306208.969, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (341, NULL, 3, 8, 1, 1, NULL, 9, NULL, 0, 185, NULL, NULL, '400000003', '2017-09-30', '2017-09-30', 0, 375.794373, -37955.2305, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (342, 3, NULL, 8, 1, 1, NULL, 9, NULL, 0, 185, NULL, NULL, '5000004001', '2017-09-30', '2017-09-30', 375.794373, 0, 5929.13867, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (343, NULL, 104, 10, 1, 1, NULL, 9, NULL, 0, 186, NULL, NULL, '400000401', '2017-09-30', '2017-09-30', 5279.104, 0, -32676.1309, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (344, 104, NULL, 10, 1, 1, NULL, 9, NULL, 0, 186, NULL, NULL, '5000004001', '2017-09-30', '2017-09-30', 0, 5279.104, 101883.586, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (345, 101, 1, 2, 1, 1, NULL, 10, 0, 0, 134, NULL, NULL, '400000001', '2017-10-05', '2017-10-05', 15000, 0, 321208.969, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (346, 1, 101, 2, 1, 1, NULL, 10, 0, 0, 134, NULL, NULL, '400000101', '2017-10-05', '2017-10-05', 0, 15000, -610500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (347, 106, 1, 2, 1, 1, NULL, 10, 0, 0, 153, NULL, NULL, '400000001', '2017-10-05', '2017-10-05', 5500, 0, 26000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (348, 1, 106, 2, 1, 1, NULL, 10, 0, 0, 153, NULL, NULL, '400000601', '2017-10-05', '2017-10-05', 0, 5500, -616000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (349, NULL, 3, 8, 1, 1, NULL, 10, NULL, 0, 187, NULL, NULL, '400000003', '2017-10-31', '2017-10-31', 0, 533.455505, -53879.0117, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (350, 3, NULL, 8, 1, 1, NULL, 10, NULL, 0, 187, NULL, NULL, '5000001001', '2017-10-31', '2017-10-31', 533.455505, 0, 6462.59424, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (351, NULL, 101, 10, 1, 1, NULL, 10, NULL, 0, 188, NULL, NULL, '400000101', '2017-10-31', '2017-10-31', 10558.208, 0, -43320.8008, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (352, 101, NULL, 10, 1, 1, NULL, 10, NULL, 0, 188, NULL, NULL, '5000001001', '2017-10-31', '2017-10-31', 0, 10558.208, 310650.75, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (353, NULL, 3, 8, 1, 1, NULL, 10, NULL, 0, 189, NULL, NULL, '400000003', '2017-10-31', '2017-10-31', 0, 326.761292, -33002.8906, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (354, 3, NULL, 8, 1, 1, NULL, 10, NULL, 0, 189, NULL, NULL, '5000004001', '2017-10-31', '2017-10-31', 326.761292, 0, 6789.35498, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (355, NULL, 104, 10, 1, 1, NULL, 10, NULL, 0, 190, NULL, NULL, '400000401', '2017-10-31', '2017-10-31', 5279.104, 0, -27723.7871, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (356, 104, NULL, 10, 1, 1, NULL, 10, NULL, 0, 190, NULL, NULL, '5000004001', '2017-10-31', '2017-10-31', 0, 5279.104, 96604.4844, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (357, 101, 1, 2, 1, 1, NULL, 11, 0, 0, 135, NULL, NULL, '400000001', '2017-11-05', '2017-11-05', 15000, 0, 325650.75, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (358, 1, 101, 2, 1, 1, NULL, 11, 0, 0, 135, NULL, NULL, '400000101', '2017-11-05', '2017-11-05', 0, 15000, -631000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (359, 106, 1, 2, 1, 1, NULL, 11, 0, 0, 154, NULL, NULL, '400000001', '2017-11-05', '2017-11-05', 5500, 0, 31500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (360, 1, 106, 2, 1, 1, NULL, 11, 0, 0, 154, NULL, NULL, '400000601', '2017-11-05', '2017-11-05', 0, 5500, -636500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (361, NULL, 3, 8, 1, 1, NULL, 11, NULL, 0, 191, NULL, NULL, '400000003', '2017-11-30', '2017-11-30', 0, 433.208008, -43754.0078, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (362, 3, NULL, 8, 1, 1, NULL, 11, NULL, 0, 191, NULL, NULL, '5000001001', '2017-11-30', '2017-11-30', 433.208008, 0, 7222.56348, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (363, NULL, 101, 10, 1, 1, NULL, 11, NULL, 0, 192, NULL, NULL, '400000101', '2017-11-30', '2017-11-30', 10558.208, 0, -33195.8008, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (364, 101, NULL, 10, 1, 1, NULL, 11, NULL, 0, 192, NULL, NULL, '5000001001', '2017-11-30', '2017-11-30', 0, 10558.208, 315092.531, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (365, NULL, 3, 8, 1, 1, NULL, 11, NULL, 0, 193, NULL, NULL, '400000003', '2017-11-30', '2017-11-30', 0, 277.237854, -28001.0234, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (366, 3, NULL, 8, 1, 1, NULL, 11, NULL, 0, 193, NULL, NULL, '5000004001', '2017-11-30', '2017-11-30', 277.237854, 0, 7499.80127, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (367, NULL, 104, 10, 1, 1, NULL, 11, NULL, 0, 194, NULL, NULL, '400000401', '2017-11-30', '2017-11-30', 5279.104, 0, -22721.9199, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (368, 104, NULL, 10, 1, 1, NULL, 11, NULL, 0, 194, NULL, NULL, '5000004001', '2017-11-30', '2017-11-30', 0, 5279.104, 91325.3828, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (369, 101, 1, 2, 1, 1, NULL, 12, 0, 0, 136, NULL, NULL, '400000001', '2017-12-05', '2017-12-05', 15000, 0, 330092.562, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (370, 1, 101, 2, 1, 1, NULL, 12, 0, 0, 136, NULL, NULL, '400000101', '2017-12-05', '2017-12-05', 0, 15000, -651500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (371, 106, 1, 2, 1, 1, NULL, 12, 0, 0, 155, NULL, NULL, '400000001', '2017-12-05', '2017-12-05', 5500, 0, 37000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (372, 1, 106, 2, 1, 1, NULL, 12, 0, 0, 155, NULL, NULL, '400000601', '2017-12-05', '2017-12-05', 0, 5500, -657000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (373, NULL, 3, 8, 1, 1, NULL, 12, NULL, 0, 195, NULL, NULL, '400000003', '2017-12-31', '2017-12-31', 0, 331.958038, -33527.7617, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (374, 3, NULL, 8, 1, 1, NULL, 12, NULL, 0, 195, NULL, NULL, '5000001001', '2017-12-31', '2017-12-31', 331.958038, 0, 7831.75977, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (375, NULL, 101, 10, 1, 1, NULL, 12, NULL, 0, 196, NULL, NULL, '400000101', '2017-12-31', '2017-12-31', 10558.208, 0, -22969.5508, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (376, 101, NULL, 10, 1, 1, NULL, 12, NULL, 0, 196, NULL, NULL, '5000001001', '2017-12-31', '2017-12-31', 0, 10558.208, 319534.344, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (377, NULL, 3, 8, 1, 1, NULL, 12, NULL, 0, 197, NULL, NULL, '400000003', '2017-12-31', '2017-12-31', 0, 227.219193, -22949.1387, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (378, 3, NULL, 8, 1, 1, NULL, 12, NULL, 0, 197, NULL, NULL, '5000004001', '2017-12-31', '2017-12-31', 227.219193, 0, 8058.979, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (379, NULL, 104, 10, 1, 1, NULL, 12, NULL, 0, 198, NULL, NULL, '400000401', '2017-12-31', '2017-12-31', 5279.104, 0, -17670.0352, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (380, 104, NULL, 10, 1, 1, NULL, 12, NULL, 0, 198, NULL, NULL, '5000004001', '2017-12-31', '2017-12-31', 0, 5279.104, 86046.2734, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (381, 101, 1, 2, 1, 1, NULL, 13, 0, 0, 137, NULL, NULL, '400000001', '2018-01-05', '2018-01-05', 15000, 0, 334534.344, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (382, 1, 101, 2, 1, 1, NULL, 13, 0, 0, 137, NULL, NULL, '400000101', '2018-01-05', '2018-01-05', 0, 15000, -672000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (383, 106, 1, 2, 1, 1, NULL, 13, 0, 0, 156, NULL, NULL, '400000001', '2018-01-05', '2018-01-05', 5500, 0, 42500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (384, 1, 106, 2, 1, 1, NULL, 13, 0, 0, 156, NULL, NULL, '400000601', '2018-01-05', '2018-01-05', 0, 5500, -677500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (385, NULL, 3, 8, 1, 1, NULL, 13, NULL, 0, 199, NULL, NULL, '400000003', '2018-01-31', '2018-01-31', 0, 229.695465, -23199.2422, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (386, 3, NULL, 8, 1, 1, NULL, 13, NULL, 0, 199, NULL, NULL, '5000001001', '2018-01-31', '2018-01-31', 229.695465, 0, 8288.67383, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (387, NULL, 101, 10, 1, 1, NULL, 13, NULL, 0, 200, NULL, NULL, '400000101', '2018-01-31', '2018-01-31', 10558.208, 0, -12641.0342, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (388, 101, NULL, 10, 1, 1, NULL, 13, NULL, 0, 200, NULL, NULL, '5000001001', '2018-01-31', '2018-01-31', 0, 10558.208, 323976.125, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (389, NULL, 3, 8, 1, 1, NULL, 13, NULL, 0, 201, NULL, NULL, '400000003', '2018-01-31', '2018-01-31', 0, 176.700394, -17846.7402, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (390, 3, NULL, 8, 1, 1, NULL, 13, NULL, 0, 201, NULL, NULL, '5000004001', '2018-01-31', '2018-01-31', 176.700394, 0, 8465.375, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (391, NULL, 104, 10, 1, 1, NULL, 13, NULL, 0, 202, NULL, NULL, '400000401', '2018-01-31', '2018-01-31', 5279.104, 0, -12567.6348, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (392, 104, NULL, 10, 1, 1, NULL, 13, NULL, 0, 202, NULL, NULL, '5000004001', '2018-01-31', '2018-01-31', 0, 5279.104, 80767.1719, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (393, 101, 1, 2, 1, 1, NULL, 14, 0, 0, 138, NULL, NULL, '400000001', '2018-02-05', '2018-02-05', 15000, 0, 338976.125, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (394, 1, 101, 2, 1, 1, NULL, 14, 0, 0, 138, NULL, NULL, '400000101', '2018-02-05', '2018-02-05', 0, 15000, -692500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (395, 106, 1, 2, 1, 1, NULL, 14, 0, 0, 157, NULL, NULL, '400000001', '2018-02-05', '2018-02-05', 5500, 0, 48000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (396, 1, 106, 2, 1, 1, NULL, 14, 0, 0, 157, NULL, NULL, '400000601', '2018-02-05', '2018-02-05', 0, 5500, -698000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (397, 107, 1, 2, 1, 1, NULL, 14, 0, 0, 121, NULL, NULL, '400000001', '2018-02-10', '2018-02-10', 45000, 0, 44000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (398, 108, 1, 2, 1, 1, NULL, 14, 0, 0, 122, NULL, NULL, '400000001', '2018-02-10', '2018-02-10', 45000, 0, 44000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (399, 109, 1, 2, 1, 1, NULL, 14, 0, 0, 123, NULL, NULL, '400000001', '2018-02-10', '2018-02-10', 45000, 0, 44000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (400, 110, 1, 2, 1, 1, NULL, 14, 0, 0, 124, NULL, NULL, '400000001', '2018-02-10', '2018-02-10', 45000, 0, 44000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (401, 1, 107, 2, 1, 1, NULL, 14, 0, 0, 121, NULL, NULL, '400000701', '2018-02-10', '2018-02-10', 0, 45000, -743000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (402, 1, 108, 2, 1, 1, NULL, 14, 0, 0, 122, NULL, NULL, '400000801', '2018-02-10', '2018-02-10', 0, 45000, -788000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (403, 1, 109, 2, 1, 1, NULL, 14, 0, 0, 123, NULL, NULL, '400000901', '2018-02-10', '2018-02-10', 0, 45000, -833000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (404, 1, 110, 2, 1, 1, NULL, 14, 0, 0, 124, NULL, NULL, '400001001', '2018-02-10', '2018-02-10', 0, 45000, -878000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (405, NULL, 3, 8, 1, 1, NULL, 14, NULL, 0, 203, NULL, NULL, '400000003', '2018-02-28', '2018-02-28', 0, 126.410393, -12767.4492, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (406, 3, NULL, 8, 1, 1, NULL, 14, NULL, 0, 203, NULL, NULL, '5000001001', '2018-02-28', '2018-02-28', 126.410393, 0, 8591.78516, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (407, NULL, 101, 10, 1, 1, NULL, 14, NULL, 0, 204, NULL, NULL, '400000101', '2018-02-28', '2018-02-28', 10558.208, 0, -2209.2373, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (408, 101, NULL, 10, 1, 1, NULL, 14, NULL, 0, 204, NULL, NULL, '5000001001', '2018-02-28', '2018-02-28', 0, 10558.208, 328417.906, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (409, NULL, 3, 8, 1, 1, NULL, 14, NULL, 0, 205, NULL, NULL, '400000003', '2018-02-28', '2018-02-28', 0, 125.676331, -12693.3096, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (410, 3, NULL, 8, 1, 1, NULL, 14, NULL, 0, 205, NULL, NULL, '5000004001', '2018-02-28', '2018-02-28', 125.676331, 0, 8717.46191, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (411, NULL, 104, 10, 1, 1, NULL, 14, NULL, 0, 206, NULL, NULL, '400000401', '2018-02-28', '2018-02-28', 5279.104, 0, -7414.20459, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (412, 104, NULL, 10, 1, 1, NULL, 14, NULL, 0, 206, NULL, NULL, '5000004001', '2018-02-28', '2018-02-28', 0, 5279.104, 75488.0703, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (413, 101, 1, 2, 1, 1, NULL, 15, 0, 0, 139, NULL, NULL, '400000001', '2018-03-05', '2018-03-05', 15000, 0, 343417.938, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (414, 1, 101, 2, 1, 1, NULL, 15, 0, 0, 139, NULL, NULL, '400000101', '2018-03-05', '2018-03-05', 0, 15000, -893000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (415, 106, 1, 2, 1, 1, NULL, 15, 0, 0, 158, NULL, NULL, '400000001', '2018-03-05', '2018-03-05', 5500, 0, 53500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (416, 1, 106, 2, 1, 1, NULL, 15, 0, 0, 158, NULL, NULL, '400000601', '2018-03-05', '2018-03-05', 0, 5500, -898500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (417, NULL, 3, 8, 1, 1, NULL, 15, NULL, 0, 207, NULL, NULL, '400000003', '2018-03-31', '2018-03-31', 0, 22.0923443, -2231.32666, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (418, 3, NULL, 8, 1, 1, NULL, 15, NULL, 0, 207, NULL, NULL, '5000001001', '2018-03-31', '2018-03-31', 22.0923443, 0, 8739.55469, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (419, NULL, 101, 10, 1, 1, NULL, 15, NULL, 0, 208, NULL, NULL, '400000101', '2018-03-31', '2018-03-31', 2209.23633, 0, -22.0917969, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (420, 101, NULL, 10, 1, 1, NULL, 15, NULL, 0, 208, NULL, NULL, '5000001001', '2018-03-31', '2018-03-31', 0, 2209.23633, 341208.688, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (421, NULL, 3, 8, 1, 1, NULL, 15, NULL, 0, 209, NULL, NULL, '400000003', '2018-03-31', '2018-03-31', 0, 74.142067, -7488.34912, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (422, 3, NULL, 8, 1, 1, NULL, 15, NULL, 0, 209, NULL, NULL, '5000004001', '2018-03-31', '2018-03-31', 74.142067, 0, 8813.69531, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (423, NULL, 104, 10, 1, 1, NULL, 15, NULL, 0, 210, NULL, NULL, '400000401', '2018-03-31', '2018-03-31', 5279.104, 0, -2209.24365, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (424, 104, NULL, 10, 1, 1, NULL, 15, NULL, 0, 210, NULL, NULL, '5000004001', '2018-03-31', '2018-03-31', 0, 5279.104, 70208.9609, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (425, 101, 1, 2, 1, 1, NULL, 16, 0, 0, 140, NULL, NULL, '400000001', '2018-04-05', '2018-04-05', 15000, 0, 356208.688, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (426, 1, 101, 2, 1, 1, NULL, 16, 0, 0, 140, NULL, NULL, '400000101', '2018-04-05', '2018-04-05', 0, 15000, -913500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (427, 106, 1, 2, 1, 1, NULL, 16, 0, 0, 159, NULL, NULL, '400000001', '2018-04-05', '2018-04-05', 5500, 0, 59000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (428, 1, 106, 2, 1, 1, NULL, 16, 0, 0, 159, NULL, NULL, '400000601', '2018-04-05', '2018-04-05', 0, 5500, -919000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (429, NULL, 3, 8, 1, 1, NULL, 16, NULL, 0, 211, NULL, NULL, '400000003', '2018-04-30', '2018-04-30', 0, 0.220937505, -22.3146877, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (430, 3, NULL, 8, 1, 1, NULL, 16, NULL, 0, 211, NULL, NULL, '5000001001', '2018-04-30', '2018-04-30', 0.220937505, 0, 8813.91699, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (431, NULL, 101, 10, 1, 1, NULL, 16, NULL, 0, 212, NULL, NULL, '400000101', '2018-04-30', '2018-04-30', 22.0922852, 0, -0.220214844, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (432, 101, NULL, 10, 1, 1, NULL, 16, NULL, 0, 212, NULL, NULL, '5000001001', '2018-04-30', '2018-04-30', 0, 22.0922852, 356186.594, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (433, NULL, 3, 8, 1, 1, NULL, 16, NULL, 0, 213, NULL, NULL, '400000003', '2018-04-30', '2018-04-30', 0, 22.0923824, -2231.33057, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (434, 3, NULL, 8, 1, 1, NULL, 16, NULL, 0, 213, NULL, NULL, '5000004001', '2018-04-30', '2018-04-30', 22.0923824, 0, 8836.00977, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (435, NULL, 104, 10, 1, 1, NULL, 16, NULL, 0, 214, NULL, NULL, '400000401', '2018-04-30', '2018-04-30', 2209.2417, 0, -22.090332, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (436, 104, NULL, 10, 1, 1, NULL, 16, NULL, 0, 214, NULL, NULL, '5000004001', '2018-04-30', '2018-04-30', 0, 2209.2417, 67999.7109, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (437, 101, 1, 2, 1, 1, NULL, 17, 0, 0, 141, NULL, NULL, '400000001', '2018-05-05', '2018-05-05', 15000, 0, 371186.625, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (438, 1, 101, 2, 1, 1, NULL, 17, 0, 0, 141, NULL, NULL, '400000101', '2018-05-05', '2018-05-05', 0, 15000, -934000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (439, 106, 1, 2, 1, 1, NULL, 17, 0, 0, 160, NULL, NULL, '400000001', '2018-05-05', '2018-05-05', 5500, 0, 64500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (440, 1, 106, 2, 1, 1, NULL, 17, 0, 0, 160, NULL, NULL, '400000601', '2018-05-05', '2018-05-05', 0, 5500, -939500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (441, NULL, 3, 8, 1, 1, NULL, 17, NULL, 0, 215, NULL, NULL, '400000003', '2018-05-31', '2018-05-31', 0, 0.00218750001, -0.220937505, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (442, 3, NULL, 8, 1, 1, NULL, 17, NULL, 0, 215, NULL, NULL, '5000001001', '2018-05-31', '2018-05-31', 0.00218750001, 0, 8836.01074, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (443, NULL, 101, 10, 1, 1, NULL, 17, NULL, 0, 216, NULL, NULL, '400000101', '2018-05-31', '2018-05-31', 0.220937729, 0, 0.00218772888, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (444, 101, NULL, 10, 1, 1, NULL, 17, NULL, 0, 216, NULL, NULL, '5000001001', '2018-05-31', '2018-05-31', 0, 0.220937729, 371186.375, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (445, NULL, 3, 8, 1, 1, NULL, 17, NULL, 0, 217, NULL, NULL, '400000003', '2018-05-31', '2018-05-31', 0, 0.220898435, -22.3107414, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (446, 3, NULL, 8, 1, 1, NULL, 17, NULL, 0, 217, NULL, NULL, '5000004001', '2018-05-31', '2018-05-31', 0.220898435, 0, 8836.23242, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (447, NULL, 104, 10, 1, 1, NULL, 17, NULL, 0, 218, NULL, NULL, '400000401', '2018-05-31', '2018-05-31', 22.0922852, 0, -0.220214844, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (448, 104, NULL, 10, 1, 1, NULL, 17, NULL, 0, 218, NULL, NULL, '5000004001', '2018-05-31', '2018-05-31', 0, 22.0922852, 67977.625, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (449, 101, 1, 2, 1, 1, NULL, 18, 0, 0, 142, NULL, NULL, '400000001', '2018-06-05', '2018-06-05', 15000, 0, 386186.375, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (450, 1, 101, 2, 1, 1, NULL, 18, 0, 0, 142, NULL, NULL, '400000101', '2018-06-05', '2018-06-05', 0, 15000, -954500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (451, 106, 1, 2, 1, 1, NULL, 18, 0, 0, 161, NULL, NULL, '400000001', '2018-06-05', '2018-06-05', 5500, 0, 70000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (452, 1, 106, 2, 1, 1, NULL, 18, 0, 0, 161, NULL, NULL, '400000601', '2018-06-05', '2018-06-05', 0, 5500, -960000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (453, NULL, 101, 10, 1, 1, NULL, 18, NULL, 0, 219, NULL, NULL, '400000101', '2018-06-30', '2018-06-30', 0.00218750536, 0, 0.00218750536, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 1, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (454, 101, NULL, 10, 1, 1, NULL, 18, NULL, 0, 219, NULL, NULL, '5000001001', '2018-06-30', '2018-06-30', 0, 0.00218750536, 386186.375, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 1);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (455, NULL, 3, 8, 1, 1, NULL, 18, NULL, 0, 220, NULL, NULL, '400000003', '2018-06-30', '2018-06-30', 0, 0.00218750001, -0.220937505, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (456, 3, NULL, 8, 1, 1, NULL, 18, NULL, 0, 220, NULL, NULL, '5000004001', '2018-06-30', '2018-06-30', 0.00218750001, 0, 8836.23438, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (457, NULL, 104, 10, 1, 1, NULL, 18, NULL, 0, 221, NULL, NULL, '400000401', '2018-06-30', '2018-06-30', 0.220897675, 0, -0.00175857544, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (458, 104, NULL, 10, 1, 1, NULL, 18, NULL, 0, 221, NULL, NULL, '5000004001', '2018-06-30', '2018-06-30', 0, 0.220897675, 67977.4062, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (459, 101, 1, 2, 1, 1, NULL, 19, 0, 0, 143, NULL, NULL, '400000001', '2018-07-05', '2018-07-05', 15000, 0, 401186.375, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (460, 1, 101, 2, 1, 1, NULL, 19, 0, 0, 143, NULL, NULL, '400000101', '2018-07-05', '2018-07-05', 0, 15000, -975000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (461, 106, 1, 2, 1, 1, NULL, 19, 0, 0, 162, NULL, NULL, '400000001', '2018-07-05', '2018-07-05', 5500, 0, 75500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (462, 1, 106, 2, 1, 1, NULL, 19, 0, 0, 162, NULL, NULL, '400000601', '2018-07-05', '2018-07-05', 0, 5500, -980500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (463, NULL, 104, 10, 1, 1, NULL, 19, NULL, 0, 222, NULL, NULL, '400000401', '2018-07-31', '2018-07-31', 0.00218750536, 0, 0.00218750536, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, 2, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (464, 104, NULL, 10, 1, 1, NULL, 19, NULL, 0, 222, NULL, NULL, '5000004001', '2018-07-31', '2018-07-31', 0, 0.00218750536, 67977.3984, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, 2);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (465, 101, 1, 2, 1, 1, NULL, 20, 0, 0, 144, NULL, NULL, '400000001', '2018-08-05', '2018-08-05', 15000, 0, 416186.344, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (466, 1, 101, 2, 1, 1, NULL, 20, 0, 0, 144, NULL, NULL, '400000101', '2018-08-05', '2018-08-05', 0, 15000, -995500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (467, 106, 1, 2, 1, 1, NULL, 20, 0, 0, 163, NULL, NULL, '400000001', '2018-08-05', '2018-08-05', 5500, 0, 81000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (468, 1, 106, 2, 1, 1, NULL, 20, 0, 0, 163, NULL, NULL, '400000601', '2018-08-05', '2018-08-05', 0, 5500, -1001000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (469, 101, 1, 2, 1, 1, NULL, 21, 0, 0, 145, NULL, NULL, '400000001', '2018-09-05', '2018-09-05', 15000, 0, 431186.344, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (470, 1, 101, 2, 1, 1, NULL, 21, 0, 0, 145, NULL, NULL, '400000101', '2018-09-05', '2018-09-05', 0, 15000, -1016000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (471, 106, 1, 2, 1, 1, NULL, 21, 0, 0, 164, NULL, NULL, '400000001', '2018-09-05', '2018-09-05', 5500, 0, 86500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (472, 1, 106, 2, 1, 1, NULL, 21, 0, 0, 164, NULL, NULL, '400000601', '2018-09-05', '2018-09-05', 0, 5500, -1021500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (473, 101, 1, 2, 1, 1, NULL, 22, 0, 0, 146, NULL, NULL, '400000001', '2018-10-05', '2018-10-05', 15000, 0, 446186.312, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (474, 1, 101, 2, 1, 1, NULL, 22, 0, 0, 146, NULL, NULL, '400000101', '2018-10-05', '2018-10-05', 0, 15000, -1036500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (475, 106, 1, 2, 1, 1, NULL, 22, 0, 0, 165, NULL, NULL, '400000001', '2018-10-05', '2018-10-05', 5500, 0, 92000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (476, 1, 106, 2, 1, 1, NULL, 22, 0, 0, 165, NULL, NULL, '400000601', '2018-10-05', '2018-10-05', 0, 5500, -1042000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (477, 101, 1, 2, 1, 1, NULL, 23, 0, 0, 147, NULL, NULL, '400000001', '2018-11-05', '2018-11-05', 15000, 0, 461186.344, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (478, 1, 101, 2, 1, 1, NULL, 23, 0, 0, 147, NULL, NULL, '400000101', '2018-11-05', '2018-11-05', 0, 15000, -1057000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (479, 106, 1, 2, 1, 1, NULL, 23, 0, 0, 166, NULL, NULL, '400000001', '2018-11-05', '2018-11-05', 5500, 0, 97500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (480, 1, 106, 2, 1, 1, NULL, 23, 0, 0, 166, NULL, NULL, '400000601', '2018-11-05', '2018-11-05', 0, 5500, -1062500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (481, 101, 1, 2, 1, 1, NULL, 24, 0, 0, 148, NULL, NULL, '400000001', '2018-12-05', '2018-12-05', 15000, 0, 476186.406, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (482, 1, 101, 2, 1, 1, NULL, 24, 0, 0, 148, NULL, NULL, '400000101', '2018-12-05', '2018-12-05', 0, 15000, -1077500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (483, 106, 1, 2, 1, 1, NULL, 24, 0, 0, 167, NULL, NULL, '400000001', '2018-12-05', '2018-12-05', 5500, 0, 103000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (484, 1, 106, 2, 1, 1, NULL, 24, 0, 0, 167, NULL, NULL, '400000601', '2018-12-05', '2018-12-05', 0, 5500, -1083000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (485, 101, 1, 2, 1, 1, NULL, 25, 0, 0, 149, NULL, NULL, '400000001', '2019-01-05', '2019-01-05', 15000, 0, 491186.438, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (486, 1, 101, 2, 1, 1, NULL, 25, 0, 0, 149, NULL, NULL, '400000101', '2019-01-05', '2019-01-05', 0, 15000, -1098000, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (487, 106, 1, 2, 1, 1, NULL, 25, 0, 0, 168, NULL, NULL, '400000001', '2019-01-05', '2019-01-05', 5500, 0, 108500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);
INSERT INTO public.account_activity (account_activity_id, deposit_account_id, transfer_account_id, activity_type_id, activity_frequency_id, activity_status_id, commodity_trade_id, period_id, entity_id, org_id, link_activity_id, transfer_link_id, deposit_account_no, transfer_account_no, activity_date, value_date, account_credit, account_debit, balance, exchange_rate, invert_rate, trading_rate, mean_rate, application_date, approve_status, workflow_table_id, action_date, details, loan_id, transfer_loan_id) VALUES (488, 1, 106, 2, 1, 1, NULL, 25, 0, 0, 168, NULL, NULL, '400000601', '2019-01-05', '2019-01-05', 0, 5500, -1103500, 1, false, 1, 1, '2019-01-31 11:57:00.220512', 'Draft', NULL, NULL, NULL, NULL, NULL);


--
-- Name: account_activity_account_activity_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.account_activity_account_activity_id_seq', 488, true);


--
-- Data for Name: account_class; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (10, 10, 0, 1, 'ASSETS', 'FIXED ASSETS', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (20, 20, 0, 1, 'ASSETS', 'INTANGIBLE ASSETS', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (30, 30, 0, 1, 'ASSETS', 'CURRENT ASSETS', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (40, 40, 0, 2, 'LIABILITIES', 'CURRENT LIABILITIES', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (50, 50, 0, 2, 'LIABILITIES', 'LONG TERM LIABILITIES', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (60, 60, 0, 3, 'EQUITY', 'EQUITY AND RESERVES', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (70, 70, 0, 4, 'REVENUE', 'REVENUE AND OTHER INCOME', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (80, 80, 0, 5, 'COST OF REVENUE', 'COST OF REVENUE', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (90, 90, 0, 6, 'EXPENSES', 'EXPENSES', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (100, 90, 1, 6, 'EXPENSES', 'EXPENSES', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (101, 80, 1, 5, 'COST OF REVENUE', 'COST OF REVENUE', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (102, 70, 1, 4, 'REVENUE', 'REVENUE AND OTHER INCOME', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (103, 60, 1, 3, 'EQUITY', 'EQUITY AND RESERVES', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (104, 50, 1, 2, 'LIABILITIES', 'LONG TERM LIABILITIES', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (105, 40, 1, 2, 'LIABILITIES', 'CURRENT LIABILITIES', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (106, 30, 1, 1, 'ASSETS', 'CURRENT ASSETS', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (107, 20, 1, 1, 'ASSETS', 'INTANGIBLE ASSETS', NULL);
INSERT INTO public.account_class (account_class_id, account_class_no, org_id, chat_type_id, chat_type_name, account_class_name, details) VALUES (108, 10, 1, 1, 'ASSETS', 'FIXED ASSETS', NULL);


--
-- Name: account_class_account_class_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.account_class_account_class_id_seq', 108, true);


--
-- Data for Name: account_definations; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (1, 0, 2, 1, 1, 0, 'Cash Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (2, 0, 3, 1, 1, 0, 'Cheque Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (3, 0, 4, 1, 1, 0, 'MPESA Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (4, 0, 5, 1, 1, 0, 'Cash Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (5, 0, 6, 1, 1, 0, 'Cheque Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (6, 0, 7, 1, 1, 0, 'MPESA Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (7, 1, 2, 1, 1, 0, 'Cash Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (8, 1, 3, 1, 1, 0, 'Cheque Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (9, 1, 4, 1, 1, 0, 'MPESA Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (10, 1, 5, 1, 1, 0, 'Cash Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (11, 1, 6, 1, 1, 0, 'Cheque Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (12, 1, 7, 1, 1, 0, 'MPESA Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (13, 1, 12, 22, 1, 0, 'Transfer', '2017-01-01', NULL, 0, 1, true, true, '400000002', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (14, 1, 21, 1, 1, 0, 'Opening account', '2017-01-01', NULL, 1000, 0, true, true, '400000002', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (15, 4, 29, 1, 1, 0, 'Loan Processing fees', '2017-01-01', NULL, 2000, 0, true, true, '400000002', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (16, 4, 11, 1, 1, 0, 'Loan Disbursement', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (17, 4, 10, 1, 1, 0, 'Loan Payment', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (18, 3, 2, 1, 1, 0, 'Cash Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (19, 3, 3, 1, 1, 0, 'Cheque Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (20, 3, 4, 1, 1, 0, 'MPESA Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (21, 3, 5, 1, 1, 0, 'Cash Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (22, 3, 6, 1, 1, 0, 'Cheque Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (23, 3, 7, 1, 1, 0, 'MPESA Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (24, 3, 12, 22, 1, 0, 'Transfer', '2017-01-01', NULL, 0, 1, true, true, '400000002', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (25, 5, 29, 1, 1, 0, 'Loan Processing fees', '2017-01-01', NULL, 0, 0, true, true, '400000002', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (26, 5, 11, 1, 1, 0, 'Loan Disbursement', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (27, 5, 10, 1, 1, 0, 'Loan Payment', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (28, 6, 29, 1, 1, 0, 'Loan Processing fees', '2017-01-01', NULL, 0, 0, true, true, '400000002', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (29, 6, 11, 1, 1, 0, 'Loan Disbursement', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (30, 6, 10, 1, 1, 0, 'Loan Payment', '2017-01-01', NULL, 0, 0, false, true, '400000001', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (31, 7, 2, 1, 1, 0, 'Cash Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000005', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (32, 7, 3, 1, 1, 0, 'Cheque Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000005', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (33, 7, 4, 1, 1, 0, 'MPESA Deposit', '2017-01-01', NULL, 0, 0, false, true, '400000005', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (34, 7, 5, 1, 1, 0, 'Cash Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000005', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (35, 7, 6, 1, 1, 0, 'Cheque Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000005', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (36, 7, 7, 1, 1, 0, 'MPESA Withdraw', '2017-01-01', NULL, 0, 0, false, true, '400000005', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (37, 15, 32, 31, 1, 1, 'Cash Deposit', '2017-01-01', NULL, 0, 0, false, true, '5', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (38, 11, 32, 31, 1, 1, 'Cash Deposit', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (39, 9, 32, 31, 1, 1, 'Cash Deposit', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (40, 8, 32, 31, 1, 1, 'Cash Deposit', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (41, 15, 33, 31, 1, 1, 'Cheque Deposit', '2017-01-01', NULL, 0, 0, false, true, '5', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (42, 11, 33, 31, 1, 1, 'Cheque Deposit', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (43, 9, 33, 31, 1, 1, 'Cheque Deposit', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (44, 8, 33, 31, 1, 1, 'Cheque Deposit', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (45, 15, 34, 31, 1, 1, 'MPESA Deposit', '2017-01-01', NULL, 0, 0, false, true, '5', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (46, 11, 34, 31, 1, 1, 'MPESA Deposit', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (47, 9, 34, 31, 1, 1, 'MPESA Deposit', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (48, 8, 34, 31, 1, 1, 'MPESA Deposit', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (49, 15, 35, 31, 1, 1, 'Cash Withdraw', '2017-01-01', NULL, 0, 0, false, true, '5', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (50, 11, 35, 31, 1, 1, 'Cash Withdraw', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (51, 9, 35, 31, 1, 1, 'Cash Withdraw', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (52, 8, 35, 31, 1, 1, 'Cash Withdraw', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (53, 15, 36, 31, 1, 1, 'Cheque Withdraw', '2017-01-01', NULL, 0, 0, false, true, '5', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (54, 11, 36, 31, 1, 1, 'Cheque Withdraw', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (55, 9, 36, 31, 1, 1, 'Cheque Withdraw', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (56, 8, 36, 31, 1, 1, 'Cheque Withdraw', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (57, 15, 37, 31, 1, 1, 'MPESA Withdraw', '2017-01-01', NULL, 0, 0, false, true, '5', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (58, 11, 37, 31, 1, 1, 'MPESA Withdraw', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (59, 9, 37, 31, 1, 1, 'MPESA Withdraw', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (60, 8, 37, 31, 1, 1, 'MPESA Withdraw', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (61, 14, 40, 31, 1, 1, 'Loan Payment', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (62, 13, 40, 31, 1, 1, 'Loan Payment', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (63, 12, 40, 31, 1, 1, 'Loan Payment', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (64, 14, 41, 31, 1, 1, 'Loan Disbursement', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (65, 13, 41, 31, 1, 1, 'Loan Disbursement', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (66, 12, 41, 31, 1, 1, 'Loan Disbursement', '2017-01-01', NULL, 0, 0, false, true, '1', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (67, 11, 42, 46, 1, 1, 'Transfer', '2017-01-01', NULL, 0, 1, true, true, '2', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (68, 9, 42, 46, 1, 1, 'Transfer', '2017-01-01', NULL, 0, 1, true, true, '2', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (69, 9, 45, 31, 1, 1, 'Opening account', '2017-01-01', NULL, 1000, 0, true, true, '2', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (70, 14, 53, 31, 1, 1, 'Loan Processing fees', '2017-01-01', NULL, 0, 0, true, true, '2', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (71, 13, 53, 31, 1, 1, 'Loan Processing fees', '2017-01-01', NULL, 0, 0, true, true, '2', NULL);
INSERT INTO public.account_definations (account_defination_id, product_id, activity_type_id, charge_activity_id, activity_frequency_id, org_id, account_defination_name, start_date, end_date, fee_amount, fee_ps, has_charge, is_active, account_number, details) VALUES (72, 12, 53, 31, 1, 1, 'Loan Processing fees', '2017-01-01', NULL, 2000, 0, true, true, '2', NULL);


--
-- Name: account_definations_account_defination_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.account_definations_account_defination_id_seq', 72, true);


--
-- Data for Name: account_notes; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: account_notes_account_note_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.account_notes_account_note_id_seq', 1, false);


--
-- Data for Name: account_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (100, 100, 10, 0, 'COST', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (110, 110, 10, 0, 'ACCUMULATED DEPRECIATION', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (200, 200, 20, 0, 'COST', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (210, 210, 20, 0, 'ACCUMULATED AMORTISATION', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (300, 300, 30, 0, 'DEBTORS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (310, 310, 30, 0, 'INVESTMENTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (320, 320, 30, 0, 'CURRENT BANK ACCOUNTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (330, 330, 30, 0, 'CASH ON HAND', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (340, 340, 30, 0, 'PRE-PAYMMENTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (400, 400, 40, 0, 'CREDITORS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (410, 410, 40, 0, 'ADVANCED BILLING', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (420, 420, 40, 0, 'TAX', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (430, 430, 40, 0, 'WITHHOLDING TAX', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (500, 500, 50, 0, 'LOANS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (600, 600, 60, 0, 'CAPITAL GRANTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (610, 610, 60, 0, 'ACCUMULATED SURPLUS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (700, 700, 70, 0, 'SALES REVENUE', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (710, 710, 70, 0, 'OTHER INCOME', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (800, 800, 80, 0, 'COST OF REVENUE', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (900, 900, 90, 0, 'STAFF COSTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (905, 905, 90, 0, 'COMMUNICATIONS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (910, 910, 90, 0, 'DIRECTORS ALLOWANCES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (915, 915, 90, 0, 'TRANSPORT', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (920, 920, 90, 0, 'TRAVEL', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (925, 925, 90, 0, 'POSTAL and COURIER', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (930, 930, 90, 0, 'ICT PROJECT', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (935, 935, 90, 0, 'STATIONERY', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (940, 940, 90, 0, 'SUBSCRIPTION FEES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (945, 945, 90, 0, 'REPAIRS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (950, 950, 90, 0, 'PROFESSIONAL FEES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (955, 955, 90, 0, 'OFFICE EXPENSES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (960, 960, 90, 0, 'MARKETING EXPENSES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (965, 965, 90, 0, 'STRATEGIC PLANNING', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (970, 970, 90, 0, 'DEPRECIATION', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (975, 975, 90, 0, 'CORPORATE SOCIAL INVESTMENT', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (980, 980, 90, 0, 'FINANCE COSTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (985, 985, 90, 0, 'TAXES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (990, 990, 90, 0, 'INSURANCE', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (995, 995, 90, 0, 'OTHER EXPENSES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1000, 110, 108, 1, 'ACCUMULATED DEPRECIATION', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1001, 100, 108, 1, 'COST', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1002, 210, 107, 1, 'ACCUMULATED AMORTISATION', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1003, 200, 107, 1, 'COST', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1004, 340, 106, 1, 'PRE-PAYMMENTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1005, 330, 106, 1, 'CASH ON HAND', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1006, 320, 106, 1, 'CURRENT BANK ACCOUNTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1007, 310, 106, 1, 'INVESTMENTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1008, 300, 106, 1, 'DEBTORS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1009, 430, 105, 1, 'WITHHOLDING TAX', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1010, 420, 105, 1, 'TAX', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1011, 410, 105, 1, 'ADVANCED BILLING', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1012, 400, 105, 1, 'CREDITORS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1013, 500, 104, 1, 'LOANS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1014, 610, 103, 1, 'ACCUMULATED SURPLUS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1015, 600, 103, 1, 'CAPITAL GRANTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1016, 710, 102, 1, 'OTHER INCOME', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1017, 700, 102, 1, 'SALES REVENUE', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1018, 800, 101, 1, 'COST OF REVENUE', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1019, 995, 100, 1, 'OTHER EXPENSES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1020, 990, 100, 1, 'INSURANCE', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1021, 985, 100, 1, 'TAXES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1022, 980, 100, 1, 'FINANCE COSTS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1023, 975, 100, 1, 'CORPORATE SOCIAL INVESTMENT', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1024, 970, 100, 1, 'DEPRECIATION', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1025, 965, 100, 1, 'STRATEGIC PLANNING', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1026, 960, 100, 1, 'MARKETING EXPENSES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1027, 955, 100, 1, 'OFFICE EXPENSES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1028, 950, 100, 1, 'PROFESSIONAL FEES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1029, 945, 100, 1, 'REPAIRS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1030, 940, 100, 1, 'SUBSCRIPTION FEES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1031, 935, 100, 1, 'STATIONERY', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1032, 930, 100, 1, 'ICT PROJECT', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1033, 925, 100, 1, 'POSTAL and COURIER', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1034, 920, 100, 1, 'TRAVEL', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1035, 915, 100, 1, 'TRANSPORT', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1036, 910, 100, 1, 'DIRECTORS ALLOWANCES', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1037, 905, 100, 1, 'COMMUNICATIONS', NULL);
INSERT INTO public.account_types (account_type_id, account_type_no, account_class_id, org_id, account_type_name, details) VALUES (1038, 900, 100, 1, 'STAFF COSTS', NULL);


--
-- Name: account_types_account_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.account_types_account_type_id_seq', 1038, true);


--
-- Data for Name: accounts; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (10000, 10000, 100, 0, 'COMPUTERS and EQUIPMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (10005, 10005, 100, 0, 'FURNITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (11000, 11000, 110, 0, 'COMPUTERS and EQUIPMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (11005, 11005, 110, 0, 'FURNITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (20000, 20000, 200, 0, 'INTANGIBLE ASSETS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (20005, 20005, 200, 0, 'NON CURRENT ASSETS: DEFFERED TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (20010, 20010, 200, 0, 'INTANGIBLE ASSETS: ACCOUNTING PACKAGE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (21000, 21000, 210, 0, 'ACCUMULATED AMORTISATION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (30000, 30000, 300, 0, 'TRADE DEBTORS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (30005, 30005, 300, 0, 'STAFF DEBTORS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (30010, 30010, 300, 0, 'OTHER DEBTORS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (30015, 30015, 300, 0, 'DEBTORS PROMPT PAYMENT DISCOUNT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (30020, 30020, 300, 0, 'INVENTORY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (30025, 30025, 300, 0, 'INVENTORY WORK IN PROGRESS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (30030, 30030, 300, 0, 'GOODS RECEIVED CLEARING ACCOUNT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (31005, 31005, 310, 0, 'UNIT TRUST INVESTMENTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (32000, 32000, 320, 0, 'COMMERCIAL BANK', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (32005, 32005, 320, 0, 'MPESA', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (33000, 33000, 330, 0, 'CASH ACCOUNT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (33005, 33005, 330, 0, 'PETTY CASH', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (34000, 34000, 340, 0, 'PREPAYMENTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (34005, 34005, 340, 0, 'DEPOSITS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (34010, 34010, 340, 0, 'TAX RECOVERABLE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (34015, 34015, 340, 0, 'TOTAL REGISTRAR DEPOSITS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40000, 40000, 400, 0, 'TRADE CREDITORS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40005, 40005, 400, 0, 'ADVANCE BILLING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40010, 40010, 400, 0, 'LEAVE - ACCRUALS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40015, 40015, 400, 0, 'ACCRUED LIABILITIES: CORPORATE TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40020, 40020, 400, 0, 'OTHER ACCRUALS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40025, 40025, 400, 0, 'PROVISION FOR CREDIT NOTES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40030, 40030, 400, 0, 'NSSF', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40035, 40035, 400, 0, 'NHIF', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40040, 40040, 400, 0, 'HELB', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40045, 40045, 400, 0, 'PAYE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40050, 40050, 400, 0, 'PENSION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (40055, 40055, 400, 0, 'PAYROLL LIABILITIES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (41000, 41000, 410, 0, 'ADVANCED BILLING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (42000, 42000, 420, 0, 'Value Added Tax (VAT)', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (42010, 42010, 420, 0, 'REMITTANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (43000, 43000, 430, 0, 'WITHHOLDING TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (50000, 50000, 500, 0, 'BANK LOANS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (60000, 60000, 600, 0, 'CAPITAL GRANTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (60005, 60005, 600, 0, 'ACCUMULATED AMORTISATION OF CAPITAL GRANTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (60010, 60010, 600, 0, 'DIVIDEND', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (61000, 61000, 610, 0, 'RETAINED EARNINGS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (61005, 61005, 610, 0, 'ACCUMULATED SURPLUS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (61010, 61010, 610, 0, 'ASSET REVALUATION GAIN / LOSS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (70005, 70005, 700, 0, 'GOODS SALES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (70010, 70010, 700, 0, 'SERVICE SALES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (70015, 70015, 700, 0, 'INTEREST INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (70020, 70020, 700, 0, 'CHARGES INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (70025, 70025, 700, 0, 'PENALTY INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (71000, 71000, 710, 0, 'FAIR VALUE GAIN/LOSS IN INVESTMENTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (71005, 71005, 710, 0, 'DONATION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (71010, 71010, 710, 0, 'EXCHANGE GAIN(LOSS)', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (71015, 71015, 710, 0, 'REGISTRAR TRAINING FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (71020, 71020, 710, 0, 'DISPOSAL OF ASSETS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (71025, 71025, 710, 0, 'DIVIDEND INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (71030, 71030, 710, 0, 'INTEREST INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (71035, 71035, 710, 0, 'TRAINING, FORUM, MEETINGS and WORKSHOPS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (80000, 80000, 800, 0, 'COST OF GOODS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90000, 90000, 900, 0, 'BASIC SALARY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90005, 90005, 900, 0, 'STAFF ALLOWANCES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90010, 90010, 900, 0, 'AIRTIME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90012, 90012, 900, 0, 'TRANSPORT ALLOWANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90015, 90015, 900, 0, 'REMOTE ACCESS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90020, 90020, 900, 0, 'EMPLOYER PENSION CONTRIBUTION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90025, 90025, 900, 0, 'NSSF EMPLOYER CONTRIBUTION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90035, 90035, 900, 0, 'CAPACITY BUILDING - TRAINING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90040, 90040, 900, 0, 'INTERNSHIP ALLOWANCES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90045, 90045, 900, 0, 'BONUSES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90050, 90050, 900, 0, 'LEAVE ACCRUAL', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90055, 90055, 900, 0, 'WELFARE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90056, 90056, 900, 0, 'STAFF WELLFARE: CONSUMABLES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90060, 90060, 900, 0, 'MEDICAL INSURANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90065, 90065, 900, 0, 'GROUP PERSONAL ACCIDENT AND WIBA', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90070, 90070, 900, 0, 'STAFF EXPENDITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90075, 90075, 900, 0, 'GROUP LIFE INSURANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90500, 90500, 905, 0, 'FIXED LINES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90505, 90505, 905, 0, 'CALLING CARDS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90510, 90510, 905, 0, 'LEASE LINES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90515, 90515, 905, 0, 'REMOTE ACCESS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (90520, 90520, 905, 0, 'LEASE LINE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (91000, 91000, 910, 0, 'SITTING ALLOWANCES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (91005, 91005, 910, 0, 'HONORARIUM', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (91010, 91010, 910, 0, 'WORKSHOPS and SEMINARS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (91500, 91500, 915, 0, 'CAB FARE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (91505, 91505, 915, 0, 'FUEL', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (91510, 91510, 915, 0, 'BUS FARE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (91515, 91515, 915, 0, 'POSTAGE and BOX RENTAL', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (92000, 92000, 920, 0, 'TRAINING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (92005, 92005, 920, 0, 'BUSINESS PROSPECTING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (92505, 92505, 925, 0, 'DIRECTORY LISTING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (92510, 92510, 925, 0, 'COURIER', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (93000, 93000, 930, 0, 'IP TRAINING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (93010, 93010, 930, 0, 'COMPUTER SUPPORT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (93500, 93500, 935, 0, 'PRINTED MATTER', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (93505, 93505, 935, 0, 'PAPER', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (93510, 93510, 935, 0, 'OTHER CONSUMABLES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (93515, 93515, 935, 0, 'TONER and CATRIDGE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (93520, 93520, 935, 0, 'COMPUTER ACCESSORIES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (94010, 94010, 940, 0, 'LICENSE FEE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (94015, 94015, 940, 0, 'SYSTEM SUPPORT FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (94500, 94500, 945, 0, 'FURNITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (94505, 94505, 945, 0, 'COMPUTERS and EQUIPMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (94510, 94510, 945, 0, 'JANITORIAL', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95000, 95000, 950, 0, 'AUDIT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95005, 95005, 950, 0, 'MARKETING AGENCY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95010, 95010, 950, 0, 'ADVERTISING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95015, 95015, 950, 0, 'CONSULTANCY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95020, 95020, 950, 0, 'TAX CONSULTANCY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95025, 95025, 950, 0, 'MARKETING CAMPAIGN', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95030, 95030, 950, 0, 'PROMOTIONAL MATERIALS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95035, 95035, 950, 0, 'RECRUITMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95040, 95040, 950, 0, 'ANNUAL GENERAL MEETING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95045, 95045, 950, 0, 'SEMINARS, WORKSHOPS and MEETINGS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95500, 95500, 955, 0, 'OFFICE RENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95502, 95502, 955, 0, 'OFFICE COSTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95505, 95505, 955, 0, 'CLEANING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95510, 95510, 955, 0, 'NEWSPAPERS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95515, 95515, 955, 0, 'OTHER CONSUMABLES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (95520, 95520, 955, 0, 'ADMINISTRATIVE EXPENSES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (96005, 96005, 960, 0, 'WEBSITE REVAMPING COSTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (96505, 96505, 965, 0, 'STRATEGIC PLANNING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (96510, 96510, 965, 0, 'MONITORING and EVALUATION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (97000, 97000, 970, 0, 'COMPUTERS and EQUIPMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (97005, 97005, 970, 0, 'FURNITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (97010, 97010, 970, 0, 'AMMORTISATION OF INTANGIBLE ASSETS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (97500, 97500, 975, 0, 'CORPORATE SOCIAL INVESTMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (97505, 97505, 975, 0, 'DONATION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98000, 98000, 980, 0, 'LEDGER FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98005, 98005, 980, 0, 'BOUNCED CHEQUE CHARGES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98010, 98010, 980, 0, 'OTHER FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98015, 98015, 980, 0, 'SALARY TRANSFERS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98020, 98020, 980, 0, 'UPCOUNTRY CHEQUES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98025, 98025, 980, 0, 'SAFETY DEPOSIT BOX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98030, 98030, 980, 0, 'MPESA TRANSFERS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98035, 98035, 980, 0, 'CUSTODY FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98040, 98040, 980, 0, 'PROFESSIONAL FEES: MANAGEMENT FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98500, 98500, 985, 0, 'EXCISE DUTY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98505, 98505, 985, 0, 'FINES and PENALTIES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98510, 98510, 985, 0, 'CORPORATE TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (98515, 98515, 985, 0, 'FRINGE BENEFIT TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (99000, 99000, 990, 0, 'ALL RISKS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (99005, 99005, 990, 0, 'FIRE and PERILS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (99010, 99010, 990, 0, 'BURGLARY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (99015, 99015, 990, 0, 'COMPUTER POLICY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (99500, 99500, 995, 0, 'BAD DEBTS WRITTEN OFF', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (99505, 99505, 995, 0, 'PURCHASE DISCOUNT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (99510, 99510, 995, 0, 'COST OF GOODS SOLD (COGS)', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (99515, 99515, 995, 0, 'PURCHASE PRICE VARIANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (99999, 99999, 995, 0, 'SURPLUS/DEFICIT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100000, 90075, 1038, 1, 'GROUP LIFE INSURANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100001, 90070, 1038, 1, 'STAFF EXPENDITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100002, 90065, 1038, 1, 'GROUP PERSONAL ACCIDENT AND WIBA', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100003, 90060, 1038, 1, 'MEDICAL INSURANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100004, 90056, 1038, 1, 'STAFF WELLFARE: CONSUMABLES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100005, 90055, 1038, 1, 'WELFARE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100006, 90050, 1038, 1, 'LEAVE ACCRUAL', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100007, 90045, 1038, 1, 'BONUSES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100008, 90040, 1038, 1, 'INTERNSHIP ALLOWANCES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100009, 90035, 1038, 1, 'CAPACITY BUILDING - TRAINING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100010, 90025, 1038, 1, 'NSSF EMPLOYER CONTRIBUTION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100011, 90020, 1038, 1, 'EMPLOYER PENSION CONTRIBUTION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100012, 90015, 1038, 1, 'REMOTE ACCESS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100013, 90012, 1038, 1, 'TRANSPORT ALLOWANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100014, 90010, 1038, 1, 'AIRTIME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100015, 90005, 1038, 1, 'STAFF ALLOWANCES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100016, 90000, 1038, 1, 'BASIC SALARY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100017, 90520, 1037, 1, 'LEASE LINE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100018, 90515, 1037, 1, 'REMOTE ACCESS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100019, 90510, 1037, 1, 'LEASE LINES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100020, 90505, 1037, 1, 'CALLING CARDS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100021, 90500, 1037, 1, 'FIXED LINES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100022, 91010, 1036, 1, 'WORKSHOPS and SEMINARS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100023, 91005, 1036, 1, 'HONORARIUM', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100024, 91000, 1036, 1, 'SITTING ALLOWANCES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100025, 91515, 1035, 1, 'POSTAGE and BOX RENTAL', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100026, 91510, 1035, 1, 'BUS FARE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100027, 91505, 1035, 1, 'FUEL', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100028, 91500, 1035, 1, 'CAB FARE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100029, 92005, 1034, 1, 'BUSINESS PROSPECTING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100030, 92000, 1034, 1, 'TRAINING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100031, 92510, 1033, 1, 'COURIER', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100032, 92505, 1033, 1, 'DIRECTORY LISTING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100033, 93010, 1032, 1, 'COMPUTER SUPPORT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100034, 93000, 1032, 1, 'IP TRAINING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100035, 93520, 1031, 1, 'COMPUTER ACCESSORIES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100036, 93515, 1031, 1, 'TONER and CATRIDGE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100037, 93510, 1031, 1, 'OTHER CONSUMABLES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100038, 93505, 1031, 1, 'PAPER', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100039, 93500, 1031, 1, 'PRINTED MATTER', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100040, 94015, 1030, 1, 'SYSTEM SUPPORT FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100041, 94010, 1030, 1, 'LICENSE FEE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100042, 94510, 1029, 1, 'JANITORIAL', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100043, 94505, 1029, 1, 'COMPUTERS and EQUIPMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100044, 94500, 1029, 1, 'FURNITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100045, 95045, 1028, 1, 'SEMINARS, WORKSHOPS and MEETINGS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100046, 95040, 1028, 1, 'ANNUAL GENERAL MEETING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100047, 95035, 1028, 1, 'RECRUITMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100048, 95030, 1028, 1, 'PROMOTIONAL MATERIALS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100049, 95025, 1028, 1, 'MARKETING CAMPAIGN', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100050, 95020, 1028, 1, 'TAX CONSULTANCY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100051, 95015, 1028, 1, 'CONSULTANCY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100052, 95010, 1028, 1, 'ADVERTISING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100053, 95005, 1028, 1, 'MARKETING AGENCY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100054, 95000, 1028, 1, 'AUDIT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100055, 95520, 1027, 1, 'ADMINISTRATIVE EXPENSES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100056, 95515, 1027, 1, 'OTHER CONSUMABLES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100057, 95510, 1027, 1, 'NEWSPAPERS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100058, 95505, 1027, 1, 'CLEANING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100059, 95502, 1027, 1, 'OFFICE COSTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100060, 95500, 1027, 1, 'OFFICE RENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100061, 96005, 1026, 1, 'WEBSITE REVAMPING COSTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100062, 96510, 1025, 1, 'MONITORING and EVALUATION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100063, 96505, 1025, 1, 'STRATEGIC PLANNING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100064, 97010, 1024, 1, 'AMMORTISATION OF INTANGIBLE ASSETS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100065, 97005, 1024, 1, 'FURNITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100066, 97000, 1024, 1, 'COMPUTERS and EQUIPMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100067, 97505, 1023, 1, 'DONATION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100068, 97500, 1023, 1, 'CORPORATE SOCIAL INVESTMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100069, 98040, 1022, 1, 'PROFESSIONAL FEES: MANAGEMENT FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100070, 98035, 1022, 1, 'CUSTODY FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100071, 98030, 1022, 1, 'MPESA TRANSFERS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100072, 98025, 1022, 1, 'SAFETY DEPOSIT BOX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100073, 98020, 1022, 1, 'UPCOUNTRY CHEQUES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100074, 98015, 1022, 1, 'SALARY TRANSFERS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100075, 98010, 1022, 1, 'OTHER FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100076, 98005, 1022, 1, 'BOUNCED CHEQUE CHARGES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100077, 98000, 1022, 1, 'LEDGER FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100078, 98515, 1021, 1, 'FRINGE BENEFIT TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100079, 98510, 1021, 1, 'CORPORATE TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100080, 98505, 1021, 1, 'FINES and PENALTIES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100081, 98500, 1021, 1, 'EXCISE DUTY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100082, 99015, 1020, 1, 'COMPUTER POLICY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100083, 99010, 1020, 1, 'BURGLARY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100084, 99005, 1020, 1, 'FIRE and PERILS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100085, 99000, 1020, 1, 'ALL RISKS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100086, 99999, 1019, 1, 'SURPLUS/DEFICIT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100087, 99515, 1019, 1, 'PURCHASE PRICE VARIANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100088, 99510, 1019, 1, 'COST OF GOODS SOLD (COGS)', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100089, 99505, 1019, 1, 'PURCHASE DISCOUNT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100090, 99500, 1019, 1, 'BAD DEBTS WRITTEN OFF', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100091, 80000, 1018, 1, 'COST OF GOODS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100092, 70025, 1017, 1, 'PENALTY INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100093, 70020, 1017, 1, 'CHARGES INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100094, 70015, 1017, 1, 'INTEREST INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100095, 70010, 1017, 1, 'SERVICE SALES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100096, 70005, 1017, 1, 'GOODS SALES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100097, 71035, 1016, 1, 'TRAINING, FORUM, MEETINGS and WORKSHOPS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100098, 71030, 1016, 1, 'INTEREST INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100099, 71025, 1016, 1, 'DIVIDEND INCOME', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100100, 71020, 1016, 1, 'DISPOSAL OF ASSETS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100101, 71015, 1016, 1, 'REGISTRAR TRAINING FEES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100102, 71010, 1016, 1, 'EXCHANGE GAIN(LOSS)', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100103, 71005, 1016, 1, 'DONATION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100104, 71000, 1016, 1, 'FAIR VALUE GAIN/LOSS IN INVESTMENTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100105, 60010, 1015, 1, 'DIVIDEND', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100106, 60005, 1015, 1, 'ACCUMULATED AMORTISATION OF CAPITAL GRANTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100107, 60000, 1015, 1, 'CAPITAL GRANTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100108, 61010, 1014, 1, 'ASSET REVALUATION GAIN / LOSS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100109, 61005, 1014, 1, 'ACCUMULATED SURPLUS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100110, 61000, 1014, 1, 'RETAINED EARNINGS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100111, 50000, 1013, 1, 'BANK LOANS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100112, 40055, 1012, 1, 'PAYROLL LIABILITIES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100113, 40050, 1012, 1, 'PENSION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100114, 40045, 1012, 1, 'PAYE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100115, 40040, 1012, 1, 'HELB', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100116, 40035, 1012, 1, 'NHIF', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100117, 40030, 1012, 1, 'NSSF', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100118, 40025, 1012, 1, 'PROVISION FOR CREDIT NOTES', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100119, 40020, 1012, 1, 'OTHER ACCRUALS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100120, 40015, 1012, 1, 'ACCRUED LIABILITIES: CORPORATE TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100121, 40010, 1012, 1, 'LEAVE - ACCRUALS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100122, 40005, 1012, 1, 'ADVANCE BILLING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100123, 40000, 1012, 1, 'TRADE CREDITORS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100124, 41000, 1011, 1, 'ADVANCED BILLING', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100125, 42010, 1010, 1, 'REMITTANCE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100126, 42000, 1010, 1, 'Value Added Tax (VAT)', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100127, 43000, 1009, 1, 'WITHHOLDING TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100128, 30030, 1008, 1, 'GOODS RECEIVED CLEARING ACCOUNT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100129, 30025, 1008, 1, 'INVENTORY WORK IN PROGRESS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100130, 30020, 1008, 1, 'INVENTORY', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100131, 30015, 1008, 1, 'DEBTORS PROMPT PAYMENT DISCOUNT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100132, 30010, 1008, 1, 'OTHER DEBTORS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100133, 30005, 1008, 1, 'STAFF DEBTORS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100134, 30000, 1008, 1, 'TRADE DEBTORS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100135, 31005, 1007, 1, 'UNIT TRUST INVESTMENTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100136, 32005, 1006, 1, 'MPESA', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100137, 32000, 1006, 1, 'COMMERCIAL BANK', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100138, 33005, 1005, 1, 'PETTY CASH', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100139, 33000, 1005, 1, 'CASH ACCOUNT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100140, 34015, 1004, 1, 'TOTAL REGISTRAR DEPOSITS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100141, 34010, 1004, 1, 'TAX RECOVERABLE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100142, 34005, 1004, 1, 'DEPOSITS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100143, 34000, 1004, 1, 'PREPAYMENTS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100144, 20010, 1003, 1, 'INTANGIBLE ASSETS: ACCOUNTING PACKAGE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100145, 20005, 1003, 1, 'NON CURRENT ASSETS: DEFFERED TAX', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100146, 20000, 1003, 1, 'INTANGIBLE ASSETS', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100147, 21000, 1002, 1, 'ACCUMULATED AMORTISATION', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100148, 10005, 1001, 1, 'FURNITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100149, 10000, 1001, 1, 'COMPUTERS and EQUIPMENT', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100150, 11005, 1000, 1, 'FURNITURE', false, true, NULL);
INSERT INTO public.accounts (account_id, account_no, account_type_id, org_id, account_name, is_header, is_active, details) VALUES (100151, 11000, 1000, 1, 'COMPUTERS and EQUIPMENT', false, true, NULL);


--
-- Name: accounts_account_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.accounts_account_id_seq', 100151, true);


--
-- Data for Name: activity_frequency; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.activity_frequency (activity_frequency_id, activity_frequency_name) VALUES (1, 'Once');
INSERT INTO public.activity_frequency (activity_frequency_id, activity_frequency_name) VALUES (4, 'Monthly');


--
-- Data for Name: activity_status; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.activity_status (activity_status_id, activity_status_name) VALUES (1, 'Completed');
INSERT INTO public.activity_status (activity_status_id, activity_status_name) VALUES (2, 'UnCleared');
INSERT INTO public.activity_status (activity_status_id, activity_status_name) VALUES (3, 'Processing');
INSERT INTO public.activity_status (activity_status_id, activity_status_name) VALUES (4, 'Commited');


--
-- Data for Name: activity_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (1, 34005, 34005, 202, 0, 'No Charges', true, 1, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (2, 34005, 34005, 101, 0, 'Cash Deposits', true, 2, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (3, 34005, 34005, 101, 0, 'Cheque Deposits', true, 3, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (4, 34005, 34005, 101, 0, 'MPESA Deposits', true, 4, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (5, 34005, 34005, 102, 0, 'Cash Withdrawal', true, 5, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (6, 34005, 34005, 102, 0, 'Cheque Withdrawal', true, 6, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (7, 34005, 34005, 102, 0, 'MPESA Withdrawal', true, 7, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (8, 34005, 70015, 105, 0, 'Loan Intrests', true, 8, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (9, 34005, 70025, 106, 0, 'Loan Penalty', true, 9, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (10, 34005, 34005, 107, 0, 'Loan Payment', true, 10, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (11, 34005, 34005, 108, 0, 'Loan Disbursement', true, 11, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (12, 34005, 34005, 104, 0, 'Account Transfer', true, 12, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (14, 34005, 70015, 109, 0, 'Account Intrests', true, 14, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (15, 34005, 70025, 110, 0, 'Account Penalty', true, 15, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (21, 34005, 70020, 201, 0, 'Account opening charges', true, 21, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (22, 34005, 70020, 202, 0, 'Transfer fees', true, 22, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (23, 34005, 70020, 210, 0, 'Commodity Purchase', true, 23, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (24, 34005, 70020, 220, 0, 'Commodity Sale', true, 24, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (25, 34005, 70020, 230, 0, 'Commodity Trade', true, 25, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (26, 34005, 70020, 250, 0, 'Forex', true, 26, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (27, 34005, 70020, 203, 0, 'Member Termination Charges', true, 27, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (28, 34005, 34005, 111, 0, 'Contributions', true, 28, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (29, 34005, 70020, 201, 0, 'Loan Processing fees', true, 29, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (30, 34005, 34005, 101, 0, 'Payroll Deduction Deposits', true, 30, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (31, 100142, 100142, 202, 1, 'No Charges', true, 1, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (32, 100142, 100142, 101, 1, 'Cash Deposits', true, 2, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (33, 100142, 100142, 101, 1, 'Cheque Deposits', true, 3, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (34, 100142, 100142, 101, 1, 'MPESA Deposits', true, 4, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (35, 100142, 100142, 102, 1, 'Cash Withdrawal', true, 5, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (36, 100142, 100142, 102, 1, 'Cheque Withdrawal', true, 6, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (37, 100142, 100142, 102, 1, 'MPESA Withdrawal', true, 7, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (38, 100094, 100142, 105, 1, 'Loan Intrests', true, 8, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (39, 100092, 100142, 106, 1, 'Loan Penalty', true, 9, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (40, 100142, 100142, 107, 1, 'Loan Payment', true, 10, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (41, 100142, 100142, 108, 1, 'Loan Disbursement', true, 11, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (42, 100142, 100142, 104, 1, 'Account Transfer', true, 12, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (43, 100094, 100142, 109, 1, 'Account Intrests', true, 14, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (44, 100092, 100142, 110, 1, 'Account Penalty', true, 15, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (45, 100093, 100142, 201, 1, 'Account opening charges', true, 21, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (46, 100093, 100142, 202, 1, 'Transfer fees', true, 22, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (47, 100093, 100142, 210, 1, 'Commodity Purchase', true, 23, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (48, 100093, 100142, 220, 1, 'Commodity Sale', true, 24, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (49, 100093, 100142, 230, 1, 'Commodity Trade', true, 25, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (50, 100093, 100142, 250, 1, 'Forex', true, 26, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (51, 100093, 100142, 203, 1, 'Member Termination Charges', true, 27, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (52, 100142, 100142, 111, 1, 'Contributions', true, 28, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (53, 100093, 100142, 201, 1, 'Loan Processing fees', true, 29, NULL);
INSERT INTO public.activity_types (activity_type_id, dr_account_id, cr_account_id, use_key_id, org_id, activity_type_name, is_active, activity_type_no, details) VALUES (54, 100142, 100142, 101, 1, 'Payroll Deduction Deposits', true, 30, NULL);


--
-- Name: activity_types_activity_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.activity_types_activity_type_id_seq', 54, true);


--
-- Data for Name: address; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.address (address_id, address_type_id, sys_country_id, org_id, address_name, table_name, table_id, post_office_box, postal_code, premises, street, town, phone_number, extension, mobile, fax, email, website, is_default, first_password, details) VALUES (1, NULL, 'KE', 0, NULL, 'orgs', 0, '45689', '00100', '12th Floor, Barclays Plaza', 'Loita Street', 'Nairobi', '+254 (20) 2227100/2243097', NULL, '+254 725 819505 or +254 738 819505', NULL, 'accounts@dewcis.com', 'www.dewcis.com', true, NULL, NULL);


--
-- Name: address_address_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.address_address_id_seq', 1, true);


--
-- Data for Name: address_types; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: address_types_address_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.address_types_address_type_id_seq', 1, false);


--
-- Data for Name: applicants; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: applicants_applicant_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.applicants_applicant_id_seq', 1, false);


--
-- Data for Name: approval_checklists; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: approval_checklists_approval_checklist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.approval_checklists_approval_checklist_id_seq', 1, false);


--
-- Data for Name: approvals; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (1, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 1, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (2, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 2, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (3, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 3, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (4, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 4, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (5, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 5, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (6, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 6, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (7, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 7, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (8, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 8, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (9, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 9, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (10, 20, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'members', 10, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (11, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 11, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (12, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 12, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (13, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 13, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (14, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 14, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (15, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 15, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (16, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 16, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (17, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 17, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (18, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 18, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (19, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 19, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (20, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 20, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (21, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 21, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (22, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 22, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (23, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 23, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (24, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 24, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (25, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 25, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (26, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 26, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (27, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 27, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (28, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 28, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (29, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 29, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (30, 21, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'deposit_accounts', 30, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (31, 22, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'loans', 31, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);
INSERT INTO public.approvals (approval_id, workflow_phase_id, org_entity_id, app_entity_id, org_id, approval_level, escalation_days, escalation_hours, escalation_time, forward_id, table_name, table_id, application_date, completion_date, action_date, approve_status, approval_narrative, to_be_done, what_is_done, review_advice, details) VALUES (32, 22, 0, 0, 0, 1, 0, 3, '2019-01-31 11:57:00.083365', NULL, 'loans', 32, '2019-01-31 11:57:00.083365', NULL, '2019-01-31 11:57:00.083365', 'Approved', 'Approve - ', 'Approve - Approve', NULL, NULL, NULL);


--
-- Name: approvals_approval_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.approvals_approval_id_seq', 32, true);


--
-- Data for Name: bank_accounts; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.bank_accounts (bank_account_id, org_id, bank_branch_id, account_id, currency_id, bank_account_name, bank_account_number, narrative, is_default, is_active, details) VALUES (0, 0, 0, 33000, 1, 'Cash Account', NULL, NULL, true, true, NULL);


--
-- Name: bank_accounts_bank_account_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.bank_accounts_bank_account_id_seq', 1, false);


--
-- Data for Name: bank_branch; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.bank_branch (bank_branch_id, bank_id, org_id, bank_branch_name, bank_branch_code, narrative) VALUES (0, 0, 0, 'Cash', NULL, NULL);


--
-- Name: bank_branch_bank_branch_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.bank_branch_bank_branch_id_seq', 1, false);


--
-- Data for Name: banks; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.banks (bank_id, sys_country_id, org_id, bank_name, bank_code, swift_code, sort_code, narrative) VALUES (0, NULL, 0, 'Cash', NULL, NULL, NULL, NULL);


--
-- Name: banks_bank_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.banks_bank_id_seq', 1, false);


--
-- Data for Name: bidders; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: bidders_bidder_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.bidders_bidder_id_seq', 1, false);


--
-- Data for Name: block_chains; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: block_chains_block_chain_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.block_chains_block_chain_id_seq', 1, false);


--
-- Data for Name: budget_lines; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: budget_lines_budget_line_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.budget_lines_budget_line_id_seq', 1, false);


--
-- Data for Name: budgets; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: budgets_budget_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.budgets_budget_id_seq', 1, false);


--
-- Data for Name: checklists; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: checklists_checklist_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.checklists_checklist_id_seq', 1, false);


--
-- Data for Name: collateral_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.collateral_types (collateral_type_id, org_id, collateral_type_name, details) VALUES (1, 0, 'Land Title', NULL);
INSERT INTO public.collateral_types (collateral_type_id, org_id, collateral_type_name, details) VALUES (2, 0, 'Car Log book', NULL);
INSERT INTO public.collateral_types (collateral_type_id, org_id, collateral_type_name, details) VALUES (3, 1, 'Land Title', NULL);
INSERT INTO public.collateral_types (collateral_type_id, org_id, collateral_type_name, details) VALUES (4, 1, 'Car Log book', NULL);
INSERT INTO public.collateral_types (collateral_type_id, org_id, collateral_type_name, details) VALUES (5, 1, 'Property Title Deed', NULL);


--
-- Name: collateral_types_collateral_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.collateral_types_collateral_type_id_seq', 5, true);


--
-- Data for Name: collaterals; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: collaterals_collateral_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.collaterals_collateral_id_seq', 1, false);


--
-- Data for Name: commodity_trades; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: commodity_trades_commodity_trade_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.commodity_trades_commodity_trade_id_seq', 1, false);


--
-- Data for Name: commodity_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.commodity_types (commodity_type_id, org_id, commodity_type_name, details) VALUES (1, 0, 'Sacco Shares', NULL);


--
-- Name: commodity_types_commodity_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.commodity_types_commodity_type_id_seq', 1, true);


--
-- Data for Name: commoditys; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.commoditys (commodity_id, commodity_type_id, org_id, commodity_name, commodity_account, current_price, details) VALUES (1, 1, 0, 'Shares', '400000006', 10, NULL);


--
-- Name: commoditys_commodity_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.commoditys_commodity_id_seq', 1, true);


--
-- Data for Name: contracts; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: contracts_contract_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.contracts_contract_id_seq', 1, false);


--
-- Data for Name: currency; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.currency (currency_id, currency_name, currency_symbol, org_id) VALUES (1, 'Kenya Shillings', 'KES', 0);
INSERT INTO public.currency (currency_id, currency_name, currency_symbol, org_id) VALUES (2, 'US Dollar', 'USD', 0);
INSERT INTO public.currency (currency_id, currency_name, currency_symbol, org_id) VALUES (5, 'Kenya Shillings', 'KES', 1);


--
-- Name: currency_currency_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.currency_currency_id_seq', 5, true);


--
-- Data for Name: currency_rates; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.currency_rates (currency_rate_id, currency_id, org_id, exchange_date, exchange_rate) VALUES (0, 1, 0, '2018-12-12', 1);
INSERT INTO public.currency_rates (currency_rate_id, currency_id, org_id, exchange_date, exchange_rate) VALUES (1, 5, 1, '2019-01-31', 1);
INSERT INTO public.currency_rates (currency_rate_id, currency_id, org_id, exchange_date, exchange_rate) VALUES (2, 2, 0, '2019-01-31', 100);


--
-- Name: currency_rates_currency_rate_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.currency_rates_currency_rate_id_seq', 2, true);


--
-- Data for Name: default_accounts; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (1, 90012, 23, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (2, 30005, 24, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (3, 40045, 25, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (4, 40055, 26, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (5, 90000, 27, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (6, 40055, 28, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (7, 90005, 29, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (8, 40055, 30, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (9, 90070, 31, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (10, 30000, 51, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (11, 40000, 52, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (12, 70005, 53, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (13, 80000, 54, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (14, 42000, 55, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (15, 99999, 56, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (16, 61000, 57, 0, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (17, 100110, 57, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (18, 100086, 56, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (19, 100126, 55, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (20, 100091, 54, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (21, 100096, 53, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (22, 100123, 52, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (23, 100134, 51, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (24, 100001, 31, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (25, 100112, 30, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (26, 100015, 29, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (27, 100112, 28, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (28, 100016, 27, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (29, 100112, 26, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (30, 100114, 25, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (31, 100133, 24, 1, NULL);
INSERT INTO public.default_accounts (default_account_id, account_id, use_key_id, org_id, narrative) VALUES (32, 100013, 23, 1, NULL);


--
-- Name: default_accounts_default_account_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.default_accounts_default_account_id_seq', 32, true);


--
-- Data for Name: default_tax_types; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: default_tax_types_default_tax_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.default_tax_types_default_tax_type_id_seq', 1, false);


--
-- Data for Name: departments; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.departments (department_id, ln_department_id, org_id, department_name, department_account, function_code, active, petty_cash, cost_center, revenue_center, description, duties, reports, details) VALUES (0, 0, 0, 'Board of Directors', NULL, NULL, true, false, true, true, NULL, NULL, NULL, NULL);
INSERT INTO public.departments (department_id, ln_department_id, org_id, department_name, department_account, function_code, active, petty_cash, cost_center, revenue_center, description, duties, reports, details) VALUES (1, NULL, 0, 'Board of Directors', NULL, NULL, true, false, true, true, NULL, NULL, NULL, NULL);
INSERT INTO public.departments (department_id, ln_department_id, org_id, department_name, department_account, function_code, active, petty_cash, cost_center, revenue_center, description, duties, reports, details) VALUES (2, NULL, 1, 'Board of Directors', NULL, NULL, true, false, true, true, NULL, NULL, NULL, NULL);


--
-- Name: departments_department_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.departments_department_id_seq', 2, true);


--
-- Data for Name: deposit_accounts; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (1, 0, 0, 4, NULL, 0, true, '400000001', 'Deposits', '2019-01-31', NULL, NULL, -9.9999998e+10, 0, 0, 0, NULL, '2019-01-31 11:57:00.013458', 'Approved', NULL, NULL, NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (2, 0, 0, 4, NULL, 0, true, '400000002', 'Charges', '2019-01-31', NULL, NULL, -9.9999998e+10, 0, 0, 0, NULL, '2019-01-31 11:57:00.013458', 'Approved', NULL, NULL, NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (3, 0, 0, 4, NULL, 0, true, '400000003', 'Interest', '2019-01-31', NULL, NULL, -9.9999998e+10, 0, 0, 0, NULL, '2019-01-31 11:57:00.013458', 'Approved', NULL, NULL, NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (4, 0, 0, 4, NULL, 0, true, '400000004', 'Penalty', '2019-01-31', NULL, NULL, -9.9999998e+10, 0, 0, 0, NULL, '2019-01-31 11:57:00.013458', 'Approved', NULL, NULL, NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (5, 0, 0, 4, NULL, 0, true, '400000005', 'Shares', '2019-01-31', NULL, NULL, -9.9999998e+10, 0, 0, 0, NULL, '2019-01-31 11:57:00.013458', 'Approved', NULL, NULL, NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (6, 0, 7, 4, NULL, 0, true, '400000006', 'USD Deposit', '2019-01-31', NULL, NULL, -9.9999998e+10, 0, 0, 0, NULL, '2019-01-31 11:57:00.013458', 'Approved', NULL, NULL, NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (101, 1, 1, 4, 0, 0, true, '400000101', NULL, '2017-02-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 11, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (102, 2, 1, 4, 0, 0, true, '400000201', NULL, '2017-03-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 12, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (103, 3, 1, 4, 0, 0, true, '400000301', NULL, '2017-04-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 13, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (104, 4, 1, 4, 0, 0, true, '400000401', NULL, '2017-05-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 14, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (105, 5, 1, 4, 0, 0, true, '400000501', NULL, '2017-06-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 15, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (106, 6, 1, 4, 0, 0, true, '400000601', NULL, '2017-07-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 16, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (107, 7, 1, 4, 0, 0, true, '400000701', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 17, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (108, 8, 1, 4, 0, 0, true, '400000801', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 18, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (109, 9, 1, 4, 0, 0, true, '400000901', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 19, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (110, 10, 1, 4, 0, 0, true, '400001001', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 20, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (111, 1, 2, 4, 0, 0, true, '400000102', NULL, '2017-02-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 21, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (112, 2, 2, 4, 0, 0, true, '400000202', NULL, '2017-03-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 22, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (113, 3, 2, 4, 0, 0, true, '400000302', NULL, '2017-04-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 23, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (114, 4, 2, 4, 0, 0, true, '400000402', NULL, '2017-05-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 24, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (115, 5, 2, 4, 0, 0, true, '400000502', NULL, '2017-06-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 25, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (116, 6, 2, 4, 0, 0, true, '400000602', NULL, '2017-07-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 26, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (117, 7, 2, 4, 0, 0, true, '400000702', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 27, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (118, 8, 2, 4, 0, 0, true, '400000802', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 28, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (119, 9, 2, 4, 0, 0, true, '400000902', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 29, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.deposit_accounts (deposit_account_id, member_id, product_id, activity_frequency_id, entity_id, org_id, is_active, account_number, narrative, opening_date, last_closing_date, credit_limit, minimum_balance, maximum_balance, interest_rate, lockin_period_frequency, lockedin_until_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (120, 10, 2, 4, 0, 0, true, '400001002', NULL, '2017-08-02', NULL, NULL, 0, 0, 0, 0, NULL, '2019-01-31 11:57:00.083365', 'Approved', 30, '2019-01-31 11:57:00.083365', NULL);


--
-- Name: deposit_accounts_deposit_account_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.deposit_accounts_deposit_account_id_seq', 120, true);


--
-- Data for Name: e_fields; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: e_fields_e_field_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.e_fields_e_field_id_seq', 1, false);


--
-- Data for Name: entity_fields; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: entity_fields_entity_field_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.entity_fields_entity_field_id_seq', 1, false);


--
-- Data for Name: entity_orgs; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: entity_orgs_entity_org_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.entity_orgs_entity_org_id_seq', 1, false);


--
-- Data for Name: entity_subscriptions; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (1, 0, 0, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (2, 0, 1, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (3, 7, 2, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (4, 7, 3, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (5, 7, 4, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (6, 7, 5, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (7, 7, 6, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (8, 7, 7, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (9, 7, 8, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (10, 7, 9, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (11, 7, 10, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (12, 7, 11, 0, NULL);
INSERT INTO public.entity_subscriptions (entity_subscription_id, entity_type_id, entity_id, org_id, details) VALUES (13, 0, 12, 0, NULL);


--
-- Name: entity_subscriptions_entity_subscription_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.entity_subscriptions_entity_subscription_id_seq', 13, true);


--
-- Data for Name: entity_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (0, 0, 0, 'System Admins', 'sysadmin', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (1, 1, 0, 'Staff', 'staff', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (2, 2, 0, 'Client', 'client', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (3, 3, 0, 'Supplier', 'supplier', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (4, 4, 0, 'Applicant', 'applicant', '10:0', NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (5, 5, 0, 'Subscription', 'subscription', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (6, 6, 0, 'User', 'user', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (7, 100, 0, 'Sacco Members', 'member', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (8, 0, 1, 'Users', 'user', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (9, 1, 1, 'Staff', 'staff', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (10, 2, 1, 'Client', 'client', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (11, 3, 1, 'Supplier', 'supplier', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (12, 4, 1, 'Applicant', 'applicant', NULL, NULL, NULL, NULL);
INSERT INTO public.entity_types (entity_type_id, use_key_id, org_id, entity_type_name, entity_role, start_view, group_email, description, details) VALUES (13, 100, 1, 'Sacco Members', 'member', NULL, NULL, NULL, NULL);


--
-- Name: entity_types_entity_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.entity_types_entity_type_id_seq', 13, true);


--
-- Data for Name: entity_values; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: entity_values_entity_value_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.entity_values_entity_value_id_seq', 1, false);


--
-- Data for Name: entitys; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (1, 0, 0, 0, 0, 'repository', 'repository', 'repository@localhost', NULL, false, true, false, NULL, '2018-12-12 12:14:42.236582', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, NULL);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (2, 7, 100, 0, 0, 'Peter Mwangi', 'OR0EN2', 'peter@peter.me.ke', '0797897897', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 1);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (3, 7, 100, 0, 0, 'Dorcas Mwigereri', 'OR0EN3', 'dmwigereri@gmail.com', '0708066768', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 2);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (4, 7, 100, 0, 0, 'Haron Korir', 'OR0EN4', 'hkorir@gmail.com', '0723456987', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 3);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (5, 7, 100, 0, 0, 'Faith Mandela', 'OR0EN5', 'fmandela@gmail.com', '0782456852', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 4);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (6, 7, 100, 0, 0, 'Kamau M. Yoz', 'OR0EN6', 'mkamau@gmail.com', '0729357951', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 5);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (7, 7, 100, 0, 0, 'Florence Ngugi', 'OR0EN7', 'fngugi@gmail.com', '0715258963', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 6);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (8, 7, 100, 0, 0, 'Dennis Gichangi', 'OR0EN8', 'dennis@dennis.me.ke', '0725564978', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 7);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (9, 7, 100, 0, 0, 'Francis Chege', 'OR0EN9', 'fchege@gmail.com', '0788268751', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 8);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (10, 7, 100, 0, 0, 'Evin Mwailongo', 'OR0EN10', 'evin@gmail.com', '0755468913', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 9);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (11, 7, 100, 0, 0, 'Rachel Mogire', 'OR0EN11', 'rmogire@gmail.com', '0709456258', false, false, false, 'members', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 10);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (0, 0, 0, 0, 0, 'root', 'root', 'root@localhost', NULL, true, true, false, NULL, '2018-12-12 12:14:42.236582', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, 1);
INSERT INTO public.entitys (entity_id, entity_type_id, use_key_id, sys_language_id, org_id, entity_name, user_name, primary_email, primary_telephone, super_user, entity_leader, no_org, function_role, date_enroled, is_active, entity_password, first_password, new_password, start_url, is_picked, details, attention, credit_limit, account_id, member_id) VALUES (12, 0, 0, 0, 0, 'Administrator', 'admin', NULL, NULL, false, false, false, 'admin,manager,operations', '2019-01-31 11:57:00.083365', true, 'b6f0038dfd42f8aa6ca25354cd2e3660', 'baraza', NULL, NULL, false, NULL, NULL, 0, NULL, NULL);


--
-- Name: entitys_entity_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.entitys_entity_id_seq', 12, true);


--
-- Data for Name: entry_forms; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: entry_forms_entry_form_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.entry_forms_entry_form_id_seq', 1, false);


--
-- Data for Name: et_fields; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: et_fields_et_field_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.et_fields_et_field_id_seq', 1, false);


--
-- Data for Name: fields; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: fields_field_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.fields_field_id_seq', 1, false);


--
-- Data for Name: fiscal_years; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.fiscal_years (fiscal_year_id, fiscal_year, org_id, fiscal_year_start, fiscal_year_end, submission_date, year_opened, year_closed, details) VALUES (1, '2017', 0, '2017-01-01', '2017-12-31', NULL, true, false, NULL);
INSERT INTO public.fiscal_years (fiscal_year_id, fiscal_year, org_id, fiscal_year_start, fiscal_year_end, submission_date, year_opened, year_closed, details) VALUES (2, '2018', 0, '2018-01-01', '2018-12-31', NULL, true, false, NULL);
INSERT INTO public.fiscal_years (fiscal_year_id, fiscal_year, org_id, fiscal_year_start, fiscal_year_end, submission_date, year_opened, year_closed, details) VALUES (3, '2019', 0, '2019-01-01', '2019-12-31', NULL, true, false, NULL);


--
-- Name: fiscal_years_fiscal_year_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.fiscal_years_fiscal_year_id_seq', 3, true);


--
-- Data for Name: folders; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.folders (folder_id, org_id, folder_name, details) VALUES (0, NULL, 'Outbox', NULL);
INSERT INTO public.folders (folder_id, org_id, folder_name, details) VALUES (1, NULL, 'Draft', NULL);
INSERT INTO public.folders (folder_id, org_id, folder_name, details) VALUES (2, NULL, 'Sent', NULL);
INSERT INTO public.folders (folder_id, org_id, folder_name, details) VALUES (3, NULL, 'Inbox', NULL);
INSERT INTO public.folders (folder_id, org_id, folder_name, details) VALUES (4, NULL, 'Action', NULL);


--
-- Name: folders_folder_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.folders_folder_id_seq', 1, false);


--
-- Data for Name: follow_up; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: follow_up_follow_up_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.follow_up_follow_up_id_seq', 1, false);


--
-- Data for Name: forms; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: forms_form_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.forms_form_id_seq', 1, false);


--
-- Data for Name: gls; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: gls_gl_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.gls_gl_id_seq', 1, false);


--
-- Data for Name: group_sms_details; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: group_sms_details_group_sms_detail_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.group_sms_details_group_sms_detail_id_seq', 1, false);


--
-- Data for Name: guarantees; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: guarantees_guarantee_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.guarantees_guarantee_id_seq', 1, false);


--
-- Data for Name: helpdesk; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: helpdesk_helpdesk_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.helpdesk_helpdesk_id_seq', 1, false);


--
-- Data for Name: holidays; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: holidays_holiday_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.holidays_holiday_id_seq', 1, false);


--
-- Data for Name: industry; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: industry_industry_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.industry_industry_id_seq', 1, false);


--
-- Data for Name: interest_methods; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (0, 8, 0, 'No Intrest', false, false, NULL, '400000003', 0, NULL);
INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (1, 8, 0, 'Loan reducing balance', true, false, 'get_intrest(1, loan_id, period_id)', '400000003', 1, NULL);
INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (2, 8, 0, 'Loan Fixed Intrest', false, false, 'get_intrest(2, loan_id, period_id)', '400000003', 2, NULL);
INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (3, 14, 0, 'Savings intrest', false, false, 'get_intrest(3, deposit_account_id, period_id)', '400000003', 3, NULL);
INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (4, 8, 0, 'Loan reducing balance and payments', true, true, 'get_intrest(1, loan_id, period_id)', '400000003', 4, NULL);
INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (5, 38, 1, 'No Intrest', false, false, NULL, '400000003', 0, NULL);
INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (6, 38, 1, 'Loan reducing balance', true, false, 'get_intrest(1, loan_id, period_id)', '400000003', 1, NULL);
INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (7, 38, 1, 'Loan Fixed Intrest', false, false, 'get_intrest(2, loan_id, period_id)', '400000003', 2, NULL);
INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (8, 43, 1, 'Savings intrest', false, false, 'get_intrest(3, deposit_account_id, period_id)', '400000003', 3, NULL);
INSERT INTO public.interest_methods (interest_method_id, activity_type_id, org_id, interest_method_name, reducing_balance, reducing_payments, formural, account_number, interest_method_no, details) VALUES (9, 38, 1, 'Loan reducing balance and payments', true, true, 'get_intrest(1, loan_id, period_id)', '400000003', 4, NULL);


--
-- Name: interest_methods_interest_method_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.interest_methods_interest_method_id_seq', 9, true);


--
-- Data for Name: investment_status; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: investment_status_investment_status_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.investment_status_investment_status_id_seq', 1, false);


--
-- Data for Name: investment_types; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: investment_types_investment_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.investment_types_investment_type_id_seq', 1, false);


--
-- Data for Name: investments; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: investments_investment_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.investments_investment_id_seq', 1, false);


--
-- Data for Name: issue_definitions; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.issue_definitions (issue_definition_id, issue_type_id, org_id, issue_definition_name, description, solution) VALUES (1, 1, 0, 'Accounts Balance Querry', NULL, NULL);
INSERT INTO public.issue_definitions (issue_definition_id, issue_type_id, org_id, issue_definition_name, description, solution) VALUES (2, 1, 0, 'Contributions Balance', NULL, NULL);
INSERT INTO public.issue_definitions (issue_definition_id, issue_type_id, org_id, issue_definition_name, description, solution) VALUES (3, 6, 0, 'Others', NULL, NULL);


--
-- Name: issue_definitions_issue_definition_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.issue_definitions_issue_definition_id_seq', 4, true);


--
-- Data for Name: issue_levels; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.issue_levels (issue_level_id, org_id, issue_level_name, details) VALUES (1, 0, 'Critical', NULL);
INSERT INTO public.issue_levels (issue_level_id, org_id, issue_level_name, details) VALUES (2, 0, 'High', NULL);
INSERT INTO public.issue_levels (issue_level_id, org_id, issue_level_name, details) VALUES (3, 0, 'Medium', NULL);
INSERT INTO public.issue_levels (issue_level_id, org_id, issue_level_name, details) VALUES (4, 0, 'Low', NULL);
INSERT INTO public.issue_levels (issue_level_id, org_id, issue_level_name, details) VALUES (6, 1, 'Critical', NULL);
INSERT INTO public.issue_levels (issue_level_id, org_id, issue_level_name, details) VALUES (7, 1, 'High', NULL);
INSERT INTO public.issue_levels (issue_level_id, org_id, issue_level_name, details) VALUES (8, 1, 'Medium', NULL);
INSERT INTO public.issue_levels (issue_level_id, org_id, issue_level_name, details) VALUES (9, 1, 'Low', NULL);


--
-- Name: issue_levels_issue_level_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.issue_levels_issue_level_id_seq', 9, true);


--
-- Data for Name: issue_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (1, 0, 'Transactions', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (2, 0, 'Contributions', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (3, 0, 'Loans', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (4, 0, 'Statements', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (5, 0, 'Shares', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (6, 0, 'Others', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (8, 1, 'Transactions', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (9, 1, 'Contributions', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (10, 1, 'Loans', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (11, 1, 'Statements', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (12, 1, 'Shares', NULL);
INSERT INTO public.issue_types (issue_type_id, org_id, issue_type_name, details) VALUES (13, 1, 'Others', NULL);


--
-- Name: issue_types_issue_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.issue_types_issue_type_id_seq', 13, true);


--
-- Data for Name: item_category; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.item_category (item_category_id, org_id, item_category_name, details) VALUES (1, 0, 'Services', NULL);
INSERT INTO public.item_category (item_category_id, org_id, item_category_name, details) VALUES (2, 0, 'Goods', NULL);
INSERT INTO public.item_category (item_category_id, org_id, item_category_name, details) VALUES (3, 0, 'Utilities', NULL);


--
-- Name: item_category_item_category_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.item_category_item_category_id_seq', 3, true);


--
-- Data for Name: item_units; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.item_units (item_unit_id, org_id, item_unit_name, details) VALUES (1, 0, 'Each', NULL);
INSERT INTO public.item_units (item_unit_id, org_id, item_unit_name, details) VALUES (2, 0, 'Man Hours', NULL);
INSERT INTO public.item_units (item_unit_id, org_id, item_unit_name, details) VALUES (3, 0, '100KG', NULL);


--
-- Name: item_units_item_unit_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.item_units_item_unit_id_seq', 3, true);


--
-- Data for Name: items; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: items_item_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.items_item_id_seq', 1, false);


--
-- Data for Name: journals; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: journals_journal_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.journals_journal_id_seq', 1, false);


--
-- Data for Name: kin_types; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (1, 0, false, 'Wife', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (2, 0, false, 'Husband', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (3, 0, false, 'Daughter', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (4, 0, false, 'Son', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (5, 0, false, 'Mother', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (6, 0, false, 'Father', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (7, 0, false, 'Brother', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (8, 0, false, 'Sister', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (9, 0, false, 'Uncle', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (10, 0, false, 'Aunt', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (11, 0, false, 'Niece', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (12, 0, false, 'Nephew', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (13, 0, false, 'Others', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (14, 1, false, 'Wife', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (15, 1, false, 'Husband', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (16, 1, false, 'Daughter', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (17, 1, false, 'Son', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (18, 1, false, 'Mother', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (19, 1, false, 'Father', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (20, 1, false, 'Brother', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (21, 1, false, 'Sister', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (22, 1, false, 'Uncle', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (23, 1, false, 'Aunt', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (24, 1, false, 'Niece', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (25, 1, false, 'Nephew', NULL);
INSERT INTO public.kin_types (kin_type_id, org_id, spouse, kin_type_name, details) VALUES (26, 1, false, 'Others', NULL);


--
-- Name: kin_types_kin_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.kin_types_kin_type_id_seq', 26, true);


--
-- Data for Name: kins; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: kins_kin_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.kins_kin_id_seq', 1, false);


--
-- Data for Name: lead_categorys; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.lead_categorys (lead_category_id, use_key_id, org_id, lead_category_name, details) VALUES (1, NULL, 0, 'General', NULL);


--
-- Name: lead_categorys_lead_category_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.lead_categorys_lead_category_id_seq', 1, true);


--
-- Data for Name: lead_items; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: lead_items_lead_item_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.lead_items_lead_item_id_seq', 1, false);


--
-- Data for Name: leads; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: leads_lead_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.leads_lead_id_seq', 1, false);


--
-- Data for Name: ledger_links; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: ledger_links_ledger_link_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.ledger_links_ledger_link_id_seq', 1, false);


--
-- Data for Name: ledger_types; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: ledger_types_ledger_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.ledger_types_ledger_type_id_seq', 1, false);


--
-- Name: link_activity_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.link_activity_id_seq', 222, true);


--
-- Data for Name: loan_approval; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Data for Name: loan_approval_levels; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: loan_approval_levels_loan_approval_level_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_approval_levels_loan_approval_level_id_seq', 1, false);


--
-- Name: loan_approval_loan_approval_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_approval_loan_approval_id_seq', 1, false);


--
-- Data for Name: loan_configs; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: loan_configs_loan_config_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_configs_loan_config_id_seq', 1, false);


--
-- Data for Name: loan_notes; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: loan_notes_loan_note_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loan_notes_loan_note_id_seq', 1, false);


--
-- Data for Name: loans; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.loans (loan_id, member_id, product_id, activity_frequency_id, entity_id, org_id, account_number, disburse_account, principal_amount, interest_rate, repayment_amount, repayment_period, disbursed_date, matured_date, expected_matured_date, expected_repayment, loan_status, is_active, application_date, approve_status, workflow_table_id, action_date, is_guaranteed, is_collateral, details) VALUES (1, 1, 4, 4, 0, 0, '5000001001', '400000101', 100000, 12, 10558.208, 10, '2017-04-12', NULL, '2018-02-12', 105582.078, 'Active', true, '2019-01-31 11:57:00.083365', 'Approved', 31, '2019-01-31 11:57:00.083365', true, false, NULL);
INSERT INTO public.loans (loan_id, member_id, product_id, activity_frequency_id, entity_id, org_id, account_number, disburse_account, principal_amount, interest_rate, repayment_amount, repayment_period, disbursed_date, matured_date, expected_matured_date, expected_repayment, loan_status, is_active, application_date, approve_status, workflow_table_id, action_date, is_guaranteed, is_collateral, details) VALUES (2, 4, 4, 4, 0, 0, '5000004001', '400000401', 50000, 12, 5279.104, 10, '2017-05-12', NULL, '2018-03-12', 52791.0391, 'Active', true, '2019-01-31 11:57:00.083365', 'Approved', 32, '2019-01-31 11:57:00.083365', true, false, NULL);


--
-- Name: loans_loan_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.loans_loan_id_seq', 2, true);


--
-- Data for Name: locations; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.locations (location_id, org_id, location_name, details) VALUES (1, 0, 'Head Office', NULL);
INSERT INTO public.locations (location_id, org_id, location_name, details) VALUES (2, 1, 'Head Office', NULL);


--
-- Name: locations_location_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.locations_location_id_seq', 2, true);


--
-- Data for Name: member_imports; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: member_imports_member_import_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.member_imports_member_import_id_seq', 1, false);


--
-- Data for Name: members; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (0, NULL, 0, 2, NULL, 'OpenBaraza Sacco', '0', 'Org', 'info@openbaraza.org', '+254', NULL, NULL, NULL, NULL, '2019-01-31', NULL, 'KE', NULL, NULL, '2019-01-31', true, false, NULL, NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2019-01-31 11:57:00.013458', 'Approved', NULL, NULL, NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (1, 0, 0, 0, 'Mr', 'Peter Mwangi', '30043751', 'ID', 'peter@peter.me.ke', '0797897897', NULL, '0725741369', 'Nairobi', NULL, '2010-06-08', 'M', 'KE', 'S', NULL, '2019-01-31', true, false, 'Dew CIS Solutions Ltd', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 14:14:49.971406', 'Approved', 1, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (2, 0, 0, 0, 'Miss', 'Dorcas Mwigereri', '258741369', 'ID', 'dmwigereri@gmail.com', '0708066768', NULL, '3698547', 'Nairobi', '00200', '1993-06-09', 'F', 'KE', 'S', NULL, '2019-01-31', true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 15:06:57.308398', 'Approved', 2, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (3, 0, 0, 0, 'Mr', 'Haron Korir', '22165656295', 'ID', 'hkorir@gmail.com', '0723456987', NULL, '22564', 'Nairobi', '00200', '1990-08-09', 'M', 'KE', 'M', NULL, '2019-01-31', true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 15:06:57.308398', 'Approved', 3, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (4, 0, 0, 0, 'Miss', 'Faith Mandela', '300741369', 'ID', 'fmandela@gmail.com', '0782456852', NULL, '35874', 'Nairobi', '00200', '1993-09-12', 'F', 'KE', 'S', NULL, '2019-01-31', true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 15:06:57.308398', 'Approved', 4, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (5, 0, 0, 0, 'Mr', 'Kamau M. Yoz', '272645978655', 'ID', 'mkamau@gmail.com', '0729357951', NULL, '20058', 'Nairobi', '00200', '1989-02-09', 'M', 'KE', 'S', NULL, '2019-01-31', true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 15:06:57.308398', 'Approved', 5, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (6, 0, 0, 0, 'Miss', 'Florence Ngugi', '24798523625', 'ID', 'fngugi@gmail.com', '0715258963', NULL, '32547', 'Nairobi', '00200', '1987-07-09', 'F', 'KE', 'S', NULL, '2019-01-31', true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 15:06:57.308398', 'Approved', 6, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (7, 0, 0, 0, 'Mr', 'Dennis Gichangi', '2015648970', 'ID', 'dennis@dennis.me.ke', '0725564978', NULL, '99987', 'Nairobi', '00200', '1983-06-09', 'M', 'KE', 'M', NULL, '2019-01-31', true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 15:06:57.308398', 'Approved', 7, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (8, 0, 0, 0, 'Mr', 'Francis Chege', '2956481440', 'ID', 'fchege@gmail.com', '0788268751', NULL, '20202', 'Nairobi', '00200', '1991-06-09', 'M', 'KE', 'S', NULL, '2019-01-31', true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 15:06:57.308398', 'Approved', 8, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (9, 0, 0, 0, 'Mr', 'Evin Mwailongo', '3005987432', 'ID', 'evin@gmail.com', '0755468913', NULL, '30025', 'Nairobi', '00200', '1992-06-09', 'M', 'KE', 'S', NULL, '2019-01-31', true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 15:06:57.308398', 'Approved', 9, '2019-01-31 11:57:00.083365', NULL);
INSERT INTO public.members (member_id, entity_id, org_id, business_account, person_title, member_name, identification_number, identification_type, member_email, telephone_number, telephone_number2, address, town, zip_code, date_of_birth, gender, nationality, marital_status, picture_file, entry_date, employed, self_employed, employer_name, monthly_salary, monthly_net_income, annual_turnover, annual_net_income, employer_address, introduced_by, is_active, terminated, terminate_date, terminate_status, terminate_application_date, application_date, approve_status, workflow_table_id, action_date, details) VALUES (10, 0, 0, 0, 'Mrs', 'Rachel Mogire', '2897564130', 'ID', 'rmogire@gmail.com', '0709456258', NULL, '580698', 'Nairobi', '00200', '1991-06-09', 'F', 'KE', 'M', NULL, '2019-01-31', true, false, 'Dew CIS', NULL, NULL, NULL, NULL, NULL, NULL, true, false, NULL, 'N/A', NULL, '2017-06-07 15:06:57.308398', 'Approved', 10, '2019-01-31 11:57:00.083365', NULL);


--
-- Name: members_member_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.members_member_id_seq', 10, true);


--
-- Data for Name: mpesa_api; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: mpesa_api_mpesa_api_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.mpesa_api_mpesa_api_id_seq', 1, false);


--
-- Data for Name: mpesa_trxs; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: mpesa_trxs_mpesa_trx_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.mpesa_trxs_mpesa_trx_id_seq', 1, false);


--
-- Data for Name: orgs; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.orgs (org_id, currency_id, default_country_id, parent_org_id, org_name, org_full_name, org_sufix, is_default, is_active, pin, pcc, logo, letter_head, email_from, web_logos, created, system_key, system_identifier, mac_address, public_key, license, details, org_client_id, payroll_payable, cert_number, vat_number, enforce_budget, invoice_footer, member_limit) VALUES (1, 5, 'KE', NULL, 'Open Baraza', NULL, 'ob', true, true, NULL, NULL, 'logo.png', NULL, NULL, false, '2019-01-31 11:57:00.048282', NULL, NULL, NULL, NULL, NULL, NULL, NULL, true, NULL, NULL, true, NULL, 100);
INSERT INTO public.orgs (org_id, currency_id, default_country_id, parent_org_id, org_name, org_full_name, org_sufix, is_default, is_active, pin, pcc, logo, letter_head, email_from, web_logos, created, system_key, system_identifier, mac_address, public_key, license, details, org_client_id, payroll_payable, cert_number, vat_number, enforce_budget, invoice_footer, member_limit) VALUES (0, 1, 'KE', NULL, 'OpenBaraza', 'OpenBaraza', 'dc', true, true, 'P051165288J', NULL, 'logo.png', 'logo.png', NULL, false, '2018-12-12 12:14:42.236582', NULL, NULL, NULL, NULL, NULL, NULL, NULL, true, 'C.102554', '0142653A', true, 'Make all payments to : OpenBaraza
Thank you for your Business
We Turn your information into profitability', 100);


--
-- Name: orgs_org_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.orgs_org_id_seq', 1, true);


--
-- Data for Name: pc_allocations; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: pc_allocations_pc_allocation_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.pc_allocations_pc_allocation_id_seq', 1, false);


--
-- Data for Name: pc_banking; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: pc_banking_pc_banking_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.pc_banking_pc_banking_id_seq', 1, false);


--
-- Data for Name: pc_budget; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: pc_budget_pc_budget_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.pc_budget_pc_budget_id_seq', 1, false);


--
-- Data for Name: pc_category; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: pc_category_pc_category_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.pc_category_pc_category_id_seq', 1, false);


--
-- Data for Name: pc_expenditure; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: pc_expenditure_pc_expenditure_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.pc_expenditure_pc_expenditure_id_seq', 1, false);


--
-- Data for Name: pc_items; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: pc_items_pc_item_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.pc_items_pc_item_id_seq', 1, false);


--
-- Data for Name: pc_types; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: pc_types_pc_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.pc_types_pc_type_id_seq', 1, false);


--
-- Data for Name: penalty_methods; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.penalty_methods (penalty_method_id, activity_type_id, org_id, penalty_method_name, formural, account_number, penalty_method_no, details) VALUES (0, 9, 0, 'No penalty', NULL, '400000004', 0, NULL);
INSERT INTO public.penalty_methods (penalty_method_id, activity_type_id, org_id, penalty_method_name, formural, account_number, penalty_method_no, details) VALUES (1, 9, 0, 'Loan Penalty 15', 'get_penalty(1, loan_id, period_id, 15)', '400000004', 1, NULL);
INSERT INTO public.penalty_methods (penalty_method_id, activity_type_id, org_id, penalty_method_name, formural, account_number, penalty_method_no, details) VALUES (2, 15, 0, 'Account Penalty 15', 'get_penalty(1, deposit_account_id, period_id, 15)', '400000004', 2, NULL);
INSERT INTO public.penalty_methods (penalty_method_id, activity_type_id, org_id, penalty_method_name, formural, account_number, penalty_method_no, details) VALUES (3, 39, 1, 'No penalty', NULL, '400000004', 0, NULL);
INSERT INTO public.penalty_methods (penalty_method_id, activity_type_id, org_id, penalty_method_name, formural, account_number, penalty_method_no, details) VALUES (4, 39, 1, 'Loan Penalty 15', 'get_penalty(1, loan_id, period_id, 15)', '400000004', 1, NULL);
INSERT INTO public.penalty_methods (penalty_method_id, activity_type_id, org_id, penalty_method_name, formural, account_number, penalty_method_no, details) VALUES (5, 44, 1, 'Account Penalty 15', 'get_penalty(1, deposit_account_id, period_id, 15)', '400000004', 2, NULL);


--
-- Name: penalty_methods_penalty_method_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.penalty_methods_penalty_method_id_seq', 5, true);


--
-- Data for Name: period_tax_rates; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: period_tax_rates_period_tax_rate_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.period_tax_rates_period_tax_rate_id_seq', 1, false);


--
-- Data for Name: period_tax_types; Type: TABLE DATA; Schema: public; Owner: postgres
--



--
-- Name: period_tax_types_period_tax_type_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.period_tax_types_period_tax_type_id_seq', 1, false);


--
-- Data for Name: periods; Type: TABLE DATA; Schema: public; Owner: postgres
--

INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (26, 3, 0, '2019-02-01', '2019-02-28', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (27, 3, 0, '2019-03-01', '2019-03-31', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (28, 3, 0, '2019-04-01', '2019-04-30', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (29, 3, 0, '2019-05-01', '2019-05-31', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (30, 3, 0, '2019-06-01', '2019-06-30', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (31, 3, 0, '2019-07-01', '2019-07-31', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (32, 3, 0, '2019-08-01', '2019-08-31', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (33, 3, 0, '2019-09-01', '2019-09-30', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (34, 3, 0, '2019-10-01', '2019-10-31', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (35, 3, 0, '2019-11-01', '2019-11-30', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_limit, is_posted, loan_approval, gl_payroll_account, gl_advance_account, entity_id, application_date, approve_status, workflow_table_id, action_date, details) VALUES (36, 3, 0, '2019-12-01', '2019-12-31', false, false, false, 1, 2000, false, false, '90000', '40055', NULL, '2019-01-31 11:57:00.083365', 'Draft', NULL, NULL, NULL);
INSERT INTO public.periods (period_id, fiscal_year_id, org_id, start_date, end_date, opened, activated, closed, overtime_rate, per_diem_tax_lim