/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.DB;

import java.util.HashMap;
import java.util.Map;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;

public class BTranslations {
    BDB db = null;
    Map<Integer, String> languages;
    Map<Integer, Map<Integer, Map<String, String>>> orgLang;

    public BTranslations(BDB db) {
        this.db = db;
        this.loadTranslations();
    }

    public void loadTranslations() {
        this.languages = new HashMap<Integer, String>();
        this.orgLang = new HashMap<Integer, Map<Integer, Map<String, String>>>();
        String sql = "SELECT sys_language_id, sys_language_name FROM sys_languages ORDER BY sys_language_id";
        BQuery rsL = new BQuery(this.db, sql);
        while (rsL.moveNext()) {
            this.languages.put(rsL.getInt("sys_language_id"), rsL.getString("sys_language_name"));
        }
        rsL.close();
        sql = "SELECT org_id FROM orgs WHERE is_active = true ORDER BY org_id";
        BQuery rsQ = new BQuery(this.db, sql);
        while (rsQ.moveNext()) {
            Integer orgId = rsQ.getInt("org_id");
            HashMap langs = new HashMap();
            for (Integer langId : this.languages.keySet()) {
                HashMap<String, String> lang = new HashMap<String, String>();
                sql = "SELECT reference, title FROM sys_translations WHERE sys_language_id = " + langId.toString() + " AND org_id = " + orgId;
                BQuery rsT = new BQuery(this.db, sql);
                while (rsT.moveNext()) {
                    lang.put(rsT.getString("reference"), rsT.getString("title"));
                }
                langs.put(langId, lang);
                rsT.close();
            }
            this.orgLang.put(orgId, langs);
        }
        rsQ.close();
    }

    public String getTitle(Integer orgId, Integer languageId, String reference, String altTitle) {
        String title;
        if (orgId == null) {
            return altTitle;
        }
        if (languageId == null) {
            return altTitle;
        }
        if (this.orgLang.get(orgId) == null) {
            this.loadTranslations();
        }
        if ((title = this.orgLang.get(orgId).get(languageId).get(reference)) == null) {
            title = altTitle;
        }
        return title;
    }

    public Map<Integer, String> getLanguages() {
        return this.languages;
    }
}

