/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.GridLayout;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultTreeModel;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.app.BFilter;
import org.baraza.swing.BCellRenderer;
import org.baraza.swing.BImageTree;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;
import org.baraza.xml.BTreeNode;

public class BDrillDown
extends JPanel {
    Logger log = Logger.getLogger(BDrillDown.class.getName());
    BLogHandle logHandle;
    BImageTree tree;
    JScrollPane treeScroll;
    BTreeNode topNode;
    DefaultTreeModel treeModel;
    String filterName;
    BElement view;
    BDB db;

    public BDrillDown(BLogHandle logHandle, BDB db, BElement view, String reportDir) {
        super(new GridLayout(1, 0));
        this.db = db;
        this.view = view;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.topNode = new BTreeNode(view.getAttribute("name"));
        this.treeModel = new DefaultTreeModel(this.topNode);
        this.filterName = view.getAttribute("filter");
        if (this.filterName == null) {
            this.filterName = view.getAttribute("filtername", "filterid");
        }
        this.tree = new BImageTree("/org/baraza/resources/leftpanel.jpg", this.treeModel, false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new BCellRenderer());
        this.treeScroll = new JScrollPane(this.tree);
        super.add(this.treeScroll);
        this.createtree();
    }

    public void createtree() {
        this.topNode.removeAllChildren();
        this.addNode(this.topNode, this.view, null);
        this.treeModel.reload();
    }

    public void addNode(BTreeNode lnode, BElement fielddef, String wherekey) {
        this.filterName = fielddef.getAttribute("filter");
        if (this.filterName == null) {
            this.filterName = fielddef.getAttribute("filtername", "filterid");
        }
        String keyfield = fielddef.getAttribute("keyfield");
        String listfield = fielddef.getAttribute("listfield");
        String orderby = fielddef.getAttribute("orderby");
        if (orderby == null) {
            orderby = listfield;
        }
        String wheresql = fielddef.getAttribute("where");
        String wherefield = fielddef.getAttribute("wherefield");
        String sql = "SELECT " + keyfield + ", " + listfield;
        sql = sql + " FROM " + fielddef.getAttribute("table");
        if (wheresql == null) {
            if (wherefield != null) {
                wheresql = " WHERE " + wherefield + " = '" + wherekey + "'";
            }
        } else {
            wheresql = " WHERE " + wheresql;
            if (wherefield != null) {
                wheresql = wheresql + " AND " + wherefield + " = '" + wherekey + "'";
            }
        }
        if (fielddef.getAttribute("noorg") == null) {
            String orgID = this.db.getOrgID();
            String userOrg = this.db.getUserOrg();
            if (orgID != null && userOrg != null) {
                wheresql = wheresql == null ? " WHERE (" : wheresql + " AND (";
                wheresql = wheresql + orgID + "=" + userOrg + ")";
            }
        }
        if (wheresql != null) {
            sql = sql + wheresql;
        }
        sql = sql + " ORDER BY " + orderby;
        BQuery query = new BQuery(this.db, sql);
        while (query.moveNext()) {
            BTreeNode subnode = new BTreeNode(query.getString(keyfield), query.getString(listfield));
            lnode.add(subnode);
            for (BElement el : fielddef.getElements()) {
                if (!el.getName().equals("DRILLDOWN")) continue;
                this.addNode(subnode, el, query.getString(keyfield));
            }
        }
        query.close();
    }

    public String getKey() {
        BTreeNode node = (BTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (!node.isLeaf()) {
            return null;
        }
        return node.getString();
    }

    public String getFilterName() {
        return this.filterName;
    }

    public void setListener(BFilter flt) {
        this.tree.addTreeSelectionListener(flt);
    }
}

