/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import org.baraza.DB.BDB;
import org.baraza.app.BCalendar;
import org.baraza.app.BComboBox;
import org.baraza.app.BComboList;
import org.baraza.app.BEditor;
import org.baraza.app.BForm;
import org.baraza.app.BGridBox;
import org.baraza.app.BPicture;
import org.baraza.utils.BAmountInWords;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

class BField
implements MouseListener {
    Logger log = Logger.getLogger(BField.class.getName());
    BLogHandle logHandle;
    JLabel label;
    JScrollPane scrollPane;
    JTextField textField;
    JTextArea textArea;
    JCheckBox checkBox;
    JSpinner spinner;
    JFormattedTextField textDecimal;
    BComboList comboList;
    BComboBox comboBox;
    BCalendar calendar;
    BGridBox gridBox;
    BPicture picture;
    String defaultField;
    String errMsg = "";
    BEditor editor;
    BDB db;
    int type;
    int x;
    int y;
    int h;
    int w;
    int lw;
    int lh;
    int ph;
    String name;
    String title;
    String defaultValue;
    String format;
    String function;
    String filter;
    boolean ischar = false;
    boolean showcal = false;

    public BField(BLogHandle logHandle, BDB db, BElement view) {
        this.db = db;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.name = view.getValue();
        this.title = view.getAttribute("title", "");
        this.defaultValue = view.getAttribute("default", "");
        this.filter = view.getAttribute("filter");
        this.format = view.getAttribute("format");
        this.function = view.getAttribute("function");
        String default_fnct = view.getAttribute("default_fnct");
        if (default_fnct != null) {
            this.defaultValue = db.executeFunction("SELECT " + default_fnct + "('" + db.getUserID() + "')");
        }
        this.x = Integer.valueOf(view.getAttribute("x", "10"));
        this.y = Integer.valueOf(view.getAttribute("y", "10"));
        this.h = Integer.valueOf(view.getAttribute("h", "20")) + 4;
        this.w = Integer.valueOf(view.getAttribute("w", "150"));
        this.lw = Integer.valueOf(view.getAttribute("lw", "120"));
        this.lh = Integer.valueOf(view.getAttribute("lh", "20"));
        this.ph = Integer.valueOf(view.getAttribute("ph", "120"));
        if (view.getAttribute("ischar") != null) {
            this.ischar = true;
        }
        boolean disabled = false;
        if (view.getAttribute("disabled", "false").equals("true")) {
            disabled = true;
        }
        if (view.getAttribute("enabled", "true").equals("false")) {
            disabled = true;
        }
        this.label = new JLabel(this.title);
        if (view.getName().equals("TEXTFIELD")) {
            this.type = 0;
        } else if (view.getName().equals("TEXTAREA")) {
            this.type = 1;
        } else if (view.getName().equals("CHECKBOX")) {
            this.type = 2;
        } else if (view.getName().equals("TEXTTIME")) {
            this.type = 3;
        } else if (view.getName().equals("TEXTDATE")) {
            this.type = 4;
        } else if (view.getName().equals("TEXTTIMESTAMP")) {
            this.type = 5;
        } else if (view.getName().equals("SPINTIME")) {
            this.type = 6;
        } else if (view.getName().equals("SPINDATE")) {
            this.type = 7;
        } else if (view.getName().equals("SPINTIMESTAMP")) {
            this.type = 8;
        } else if (view.getName().equals("TEXTDECIMAL")) {
            this.type = 9;
        } else if (view.getName().equals("COMBOLIST")) {
            this.type = 10;
        } else if (view.getName().equals("COMBOBOX")) {
            this.type = 11;
        } else if (view.getName().equals("GRIDBOX")) {
            this.type = 12;
        } else if (view.getName().equals("DEFAULT")) {
            this.type = 13;
        } else if (view.getName().equals("EDITOR")) {
            this.type = 14;
        } else if (view.getName().equals("FUNCTION")) {
            this.type = 15;
        } else if (view.getName().equals("USERFIELD")) {
            this.type = 16;
        } else if (view.getName().equals("USERNAME")) {
            this.type = 17;
        } else if (view.getName().equals("PICTURE")) {
            this.type = 18;
        }
        SpinnerDateModel datemodel = new SpinnerDateModel();
        switch (this.type) {
            case 0: {
                this.textField = new JTextField();
                if (!disabled) break;
                this.textField.setEnabled(false);
                break;
            }
            case 1: {
                this.textArea = new JTextArea();
                if (disabled) {
                    this.textArea.setEnabled(false);
                }
                this.textArea.setLineWrap(true);
                this.textArea.setWrapStyleWord(true);
                this.scrollPane = new JScrollPane(this.textArea);
                break;
            }
            case 2: {
                this.checkBox = new JCheckBox();
                if (!disabled) break;
                this.checkBox.setEnabled(false);
                break;
            }
            case 3: {
                this.textField = new JTextField();
                if (!disabled) break;
                this.textField.setEnabled(false);
                break;
            }
            case 4: 
            case 5: {
                this.textField = new JTextField();
                this.calendar = new BCalendar(view);
                if (disabled) {
                    this.textField.setEnabled(false);
                } else {
                    this.textField.addMouseListener(this);
                }
                this.calendar.table.addMouseListener(this);
                break;
            }
            case 6: {
                this.spinner = new JSpinner(datemodel);
                this.spinner.setEditor(new JSpinner.DateEditor(this.spinner, "hh:mm a"));
                if (!disabled) break;
                this.spinner.setEnabled(false);
                break;
            }
            case 7: {
                this.spinner = new JSpinner(datemodel);
                this.spinner.setEditor(new JSpinner.DateEditor(this.spinner, "dd-MMM-yyyy"));
                if (!disabled) break;
                this.spinner.setEnabled(false);
                break;
            }
            case 8: {
                this.spinner = new JSpinner(datemodel);
                this.spinner.setEditor(new JSpinner.DateEditor(this.spinner, "dd-MMM-yyyy hh:mm a"));
                if (!disabled) break;
                this.spinner.setEnabled(false);
                break;
            }
            case 9: {
                NumberFormat numberformat = NumberFormat.getNumberInstance();
                this.textDecimal = new JFormattedTextField(numberformat);
                if (disabled) {
                    this.textDecimal.setEnabled(false);
                }
                if (!this.defaultValue.equals("")) break;
                this.defaultValue = "0";
                break;
            }
            case 10: {
                this.comboList = new BComboList(view);
                break;
            }
            case 11: {
                this.comboBox = new BComboBox(db, view);
                break;
            }
            case 12: {
                this.gridBox = new BGridBox(logHandle, db, view);
                break;
            }
            case 14: {
                this.editor = new BEditor(view);
                break;
            }
            case 18: {
                this.picture = new BPicture(db, view);
            }
        }
        this.setBounds();
    }

    public String getName() {
        return this.name;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getH() {
        return this.h;
    }

    public int getW() {
        return this.w;
    }

    public void addToPanel(JPanel panel) {
        if (this.title.length() > 0) {
            panel.add(this.label);
        }
        switch (this.type) {
            case 0: 
            case 3: {
                panel.add(this.textField);
                break;
            }
            case 1: {
                panel.add(this.scrollPane);
                break;
            }
            case 2: {
                panel.add(this.checkBox);
                break;
            }
            case 4: 
            case 5: {
                panel.add(this.textField);
                panel.add(this.calendar);
                this.calendar.setVisible(false);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                panel.add(this.spinner);
                break;
            }
            case 9: {
                panel.add(this.textDecimal);
                break;
            }
            case 10: {
                panel.add(this.comboList);
                break;
            }
            case 11: {
                panel.add(this.comboBox);
                break;
            }
            case 12: {
                panel.add(this.gridBox);
                panel.add(this.gridBox.getGrid());
                break;
            }
            case 14: {
                panel.add(this.editor);
                break;
            }
            case 18: {
                panel.add(this.picture);
            }
        }
    }

    public void setBounds() {
        if (this.title.length() > 0) {
            this.label.setBounds(this.x, this.y, this.lw, this.lh);
        } else {
            this.lw = 0;
        }
        switch (this.type) {
            case 0: 
            case 3: {
                this.textField.setBounds(this.x + this.lw, this.y, this.w, this.h);
                break;
            }
            case 1: {
                this.scrollPane.setBounds(this.x + this.lw, this.y, this.w, this.h);
                break;
            }
            case 2: {
                this.checkBox.setBounds(this.x + this.lw, this.y, this.w, this.h);
                break;
            }
            case 4: 
            case 5: {
                this.textField.setBounds(this.x + this.lw, this.y, this.w, this.h);
                this.calendar.setBounds(this.x, this.y + this.h, this.w + this.lw, this.h + this.ph);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.spinner.setBounds(this.x + this.lw, this.y, this.w, this.h);
                break;
            }
            case 9: {
                this.textDecimal.setBounds(this.x + this.lw, this.y, this.w, this.h);
                break;
            }
            case 10: {
                this.comboList.setBounds(this.x + this.lw, this.y, this.w, this.h);
                break;
            }
            case 11: {
                this.comboBox.setBounds(this.x + this.lw, this.y, this.w, this.h);
                break;
            }
            case 12: {
                this.gridBox.setBounds(this.x, this.y, this.w, this.h, this.lw, this.ph);
                break;
            }
            case 14: {
                this.editor.setBounds(this.x + this.lw, this.y, this.w, this.h);
                break;
            }
            case 18: {
                this.picture.setBounds(this.x + this.lw, this.y, this.w, this.h);
            }
        }
    }

    public void setNew() {
        switch (this.type) {
            case 10: {
                this.comboList.setText(this.defaultValue);
                this.setText(this.defaultValue);
                break;
            }
            case 11: {
                this.comboBox.getList();
                this.setText(this.defaultValue);
                break;
            }
            case 12: {
                this.gridBox.refresh();
                this.setText(this.defaultValue);
                break;
            }
            case 18: {
                this.picture.setText("Double click to add a picture");
                break;
            }
            default: {
                this.setText(this.defaultValue);
            }
        }
    }

    public void refresh() {
        switch (this.type) {
            case 11: {
                this.comboBox.getList();
                break;
            }
            case 12: {
                this.gridBox.refresh();
            }
        }
    }

    public void setText(String value) {
        switch (this.type) {
            case 0: {
                this.textField.setText(value);
                this.textField.moveCaretPosition(0);
                break;
            }
            case 1: {
                this.textArea.setText(value);
                this.textArea.moveCaretPosition(0);
                break;
            }
            case 2: {
                if (this.ischar) {
                    if (value == null) {
                        this.checkBox.setSelected(false);
                        break;
                    }
                    if (value.equals("1")) {
                        this.checkBox.setSelected(true);
                        break;
                    }
                    this.checkBox.setSelected(false);
                    break;
                }
                if (value == null) {
                    this.checkBox.setSelected(false);
                    break;
                }
                if (value.equals("t")) {
                    this.checkBox.setSelected(true);
                    break;
                }
                if (value.equals("true")) {
                    this.checkBox.setSelected(true);
                    break;
                }
                this.checkBox.setSelected(false);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.textField.setText(this.decodeDate(value));
                this.textField.moveCaretPosition(0);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                if (value == null) break;
                this.setSpinDateTime(value);
                break;
            }
            case 9: {
                this.setDecimal(value);
                break;
            }
            case 10: {
                this.comboList.setText(value);
                break;
            }
            case 11: {
                this.comboBox.setText(value);
                break;
            }
            case 12: {
                this.gridBox.setText(value);
                break;
            }
            case 13: {
                this.defaultField = value;
                break;
            }
            case 14: {
                this.editor.setText(value);
                break;
            }
            case 18: {
                this.picture.setPicture(value);
            }
        }
    }

    public String getText() {
        this.errMsg = "";
        switch (this.type) {
            case 0: {
                return this.textField.getText();
            }
            case 1: {
                return this.textArea.getText();
            }
            case 2: {
                String ldata = "false";
                if (this.ischar) {
                    ldata = "0";
                }
                if (this.checkBox.isSelected()) {
                    ldata = "true";
                    if (this.ischar) {
                        ldata = "1";
                    }
                }
                return ldata;
            }
            case 3: 
            case 4: 
            case 5: {
                return this.encodeDate(this.textField.getText());
            }
            case 6: 
            case 7: 
            case 8: {
                return this.getSpinDateTime();
            }
            case 9: {
                return this.getDecimal();
            }
            case 10: {
                return this.comboList.getText();
            }
            case 11: {
                return this.comboBox.getText();
            }
            case 12: {
                return this.gridBox.getText();
            }
            case 13: {
                return this.defaultValue;
            }
            case 14: {
                return this.editor.getText();
            }
            case 15: {
                return this.db.executeFunction(this.function);
            }
            case 16: {
                return this.db.getUserID();
            }
            case 17: {
                return this.db.getUserName();
            }
            case 18: {
                return this.picture.getPicture();
            }
        }
        return null;
    }

    public void setLinkData(String lkdata) {
        switch (this.type) {
            case 11: {
                this.comboBox.setLinkData(lkdata);
                break;
            }
            case 12: {
                this.gridBox.setLinkData(lkdata);
            }
        }
    }

    public String decodeDate(String ldata) {
        if (ldata == null) {
            return "";
        }
        if (ldata.length() > 0) {
            try {
                Date mydate = new Date();
                Locale locale = Locale.getDefault();
                SimpleDateFormat dateParse = new SimpleDateFormat();
                if (this.type == 3) {
                    dateParse.applyPattern("HH:mm:ss");
                    mydate = ldata.equals("now") ? new Date() : dateParse.parse(ldata);
                    dateParse.applyPattern("hh:mm a");
                } else if (this.type == 4) {
                    dateParse.applyPattern("yyyy-MM-dd");
                    mydate = ldata.equals("today") ? new Date() : (ldata.equals("now") ? new Date() : dateParse.parse(ldata));
                    dateParse.applyPattern("MMM dd, yyyy");
                } else if (this.type == 5) {
                    dateParse.applyPattern("yyyy-MM-dd HH:mm:ss");
                    mydate = ldata.equals("today") ? new Date() : (ldata.equals("now") ? new Date() : dateParse.parse(ldata));
                    dateParse.applyPattern("MMM dd, yyyy hh:mm a");
                }
                ldata = dateParse.format(mydate);
            }
            catch (ParseException ex) {
                ldata = "";
                this.errMsg = ex.getMessage() + "\n";
                this.log.severe("Date to String format conversion problem : " + ex);
            }
        }
        return ldata;
    }

    public String encodeDate(String ldata) {
        if (ldata == null) {
            return "";
        }
        if (ldata.length() > 0) {
            try {
                Date psdate = new Date();
                SimpleDateFormat dateParse = new SimpleDateFormat();
                if (this.type == 3) {
                    dateParse.applyPattern("hh:mm a");
                    psdate = dateParse.parse(ldata);
                    dateParse.applyPattern("HH:mm:ss");
                } else if (this.type == 4) {
                    if (ldata.indexOf(47) > 0) {
                        dateParse.applyPattern("dd/MM/yyyy");
                    } else if (ldata.indexOf(45) > 0) {
                        dateParse.applyPattern("dd-MM-yyyy");
                    } else if (ldata.indexOf(46) > 0) {
                        dateParse.applyPattern("dd.MM.yyyy");
                    } else if (ldata.indexOf(32) > 0) {
                        dateParse.applyPattern("MMM dd, yyyy");
                    }
                    psdate = dateParse.parse(ldata);
                    dateParse.applyPattern("yyyy-MM-dd");
                } else if (this.type == 5) {
                    if (ldata.indexOf(47) > 0) {
                        dateParse.applyPattern("dd/MM/yyyy hh:mm a");
                    } else if (ldata.indexOf(45) > 0) {
                        dateParse.applyPattern("dd-MM-yyyy hh:mm a");
                    } else if (ldata.indexOf(46) > 0) {
                        dateParse.applyPattern("dd.MM.yyyy hh:mm a");
                    } else if (ldata.indexOf(32) > 0) {
                        dateParse.applyPattern("MMM dd, yyyy hh:mm a");
                    }
                    psdate = dateParse.parse(ldata);
                    dateParse.applyPattern("yyyy-MM-dd HH:mm:ss");
                }
                ldata = dateParse.format(psdate);
            }
            catch (ParseException ex) {
                ldata = "";
                this.errMsg = ex.getMessage() + "\n";
                this.log.severe("String to date conversion problem : " + ex);
            }
        }
        return ldata;
    }

    public void setSpinDateTime(String ldata) {
        if (ldata.length() > 0) {
            try {
                Date mydate = new Date();
                SimpleDateFormat dateFormatter = new SimpleDateFormat();
                if (this.type == 6) {
                    dateFormatter.applyPattern("HH:mm:ss");
                } else if (this.type == 7) {
                    dateFormatter.applyPattern("yyyy-MM-dd");
                } else if (this.type == 8) {
                    dateFormatter.applyPattern("yyyy-MM-dd HH:mm:ss");
                }
                mydate = dateFormatter.parse(ldata);
                SpinnerModel datemodel = this.spinner.getModel();
                this.spinner.setValue(mydate);
            }
            catch (ParseException ex) {
                this.log.severe("String to date conversion problem : " + ex);
            }
        }
    }

    public String getSpinDateTime() {
        SpinnerModel datemodel = this.spinner.getModel();
        SimpleDateFormat dateFormatter = new SimpleDateFormat();
        if (this.type == 6) {
            dateFormatter.applyPattern("HH:mm:ss");
        } else if (this.type == 7) {
            dateFormatter.applyPattern("yyyy-MM-dd");
        } else if (this.type == 8) {
            dateFormatter.applyPattern("yyyy-MM-dd HH:mm:ss");
        }
        String mydate = dateFormatter.format(((SpinnerDateModel)datemodel).getDate());
        return mydate;
    }

    public void setDecimal(String ldata) {
        if (ldata == null) {
            ldata = "0";
        }
        if (ldata.length() > 0) {
            Double myvalue = (double)Double.valueOf(ldata);
            this.textDecimal.setValue(myvalue);
        }
    }

    public String getDecimal() {
        String myvalue = "";
        if (this.textDecimal.getText().length() > 0) {
            Double d = ((Number)this.textDecimal.getValue()).doubleValue();
            myvalue = d.toString();
        }
        return myvalue;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getInWords() {
        String myvs = this.getText();
        if (myvs.length() > 0) {
            Double d = Double.valueOf(myvs);
            myvs = BAmountInWords.convert(d.intValue());
        }
        return myvs;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public boolean hadListener() {
        switch (this.type) {
            case 11: {
                return this.comboBox.hadListener();
            }
        }
        return false;
    }

    public String getComboLink() {
        switch (this.type) {
            case 11: {
                return this.comboBox.getComboLink();
            }
        }
        return null;
    }

    public void addActionListener(BForm form) {
        if (this.hadListener()) {
            this.comboBox.addActionListener(form);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.showcal) {
            if (this.type == 4) {
                this.setText(this.calendar.getKey());
            } else if (this.type == 5) {
                this.setText(this.calendar.getKey() + " 12:00:00");
            }
            this.calendar.setVisible(false);
            this.showcal = false;
        } else if (e.getClickCount() == 2) {
            this.calendar.showCalendar(this.getText());
            this.calendar.setVisible(true);
            this.showcal = true;
        }
    }
}

