/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.app.BGrid;
import org.baraza.utils.BLogHandle;
import org.baraza.utils.BPropeties;
import org.baraza.utils.BWebdav;
import org.baraza.utils.Bio;
import org.baraza.xml.BElement;

class BFiles
extends JPanel
implements ActionListener {
    Logger log = Logger.getLogger(BFiles.class.getName());
    String linkValue;
    String linkField;
    String fileTable;
    Map<String, String> params;
    BWebdav webdav;
    BGrid grid;
    BQuery query;
    List<JButton> fileFunct;
    JPanel fileControls;

    public BFiles(BLogHandle logHandle, BDB db, BElement view) {
        super(new BorderLayout());
        this.linkField = view.getAttribute("linkfield");
        this.fileTable = view.getAttribute("filetable");
        this.linkValue = null;
        this.params = new HashMap<String, String>();
        this.fileFunct = new ArrayList<JButton>();
        this.fileControls = new JPanel();
        this.fileFunct.add(new JButton("Upload File"));
        this.fileFunct.add(new JButton("Download File"));
        this.fileFunct.add(new JButton("Delete File"));
        for (JButton btn : this.fileFunct) {
            this.fileControls.add(btn);
            btn.addActionListener(this);
        }
        super.add((Component)this.fileControls, "First");
        String repository = BPropeties.getParam("repository_url", "http://localhost:9090/repository/webdav/files/");
        String username = BPropeties.getParam("rep_username", "repository");
        String password = BPropeties.getParam("rep_password", "baraza");
        this.webdav = new BWebdav(repository, username, password);
        this.query = new BQuery(db, view, null, null, false);
        this.grid = new BGrid(logHandle, db, view, "");
        this.grid.showMain();
        super.add((Component)this.grid, "Center");
    }

    public void link(String linkValue, Map<String, String> params) {
        this.linkValue = linkValue;
        this.params = params;
        this.grid.link(linkValue);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if (this.webdav == null || !this.webdav.isConnected()) {
            JOptionPane.showMessageDialog(this, "The file repository is not connected");
            return;
        }
        if ("Upload File".equals(aKey)) {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                String contentType = URLConnection.guessContentTypeFromName(file.getName());
                long fs = file.length();
                this.query.recAdd();
                this.query.updateField("file_name", file.getName());
                if (this.linkField != null) {
                    this.query.updateField(this.linkField, this.linkValue);
                }
                if (this.fileTable != null) {
                    this.query.updateField("table_name", this.fileTable);
                }
                if (contentType != null) {
                    this.query.updateField("file_type", contentType);
                }
                this.query.updateField("file_size", String.valueOf(fs));
                this.query.recSave();
                String wdfn = this.query.getKeyField() + "ob.bwd";
                this.webdav.saveFile(file, wdfn);
                this.grid.refresh();
            }
        } else if ("Download File".equals(aKey)) {
            String wdfn = this.grid.getKey();
            if (wdfn != null) {
                wdfn = wdfn + "ob.bwd";
                String fileName = this.grid.readField("file_name");
                System.out.println("File : " + wdfn);
                JFileChooser fc = new JFileChooser();
                fc.setSelectedFile(new File(fileName));
                int returnVal = fc.showSaveDialog(this);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    InputStream is = this.webdav.getFile(wdfn);
                    Bio io = new Bio();
                    io.saveFile(file, is);
                }
            }
        } else if ("Delete File".equals(aKey)) {
            int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the file?", "Deletion", 0);
            String wdfn = this.grid.getKey();
            if (wdfn != null && n == 0) {
                this.query.filter(this.query.getKeyFieldName() + " = '" + wdfn + "'", null);
                this.query.moveFirst();
                this.query.recDelete();
                wdfn = wdfn + "ob.bwd";
                this.webdav.delFile(wdfn);
                this.grid.refresh();
            }
        }
    }
}

