/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.DB.BTableModel;
import org.baraza.app.BField;
import org.baraza.app.BFilter;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

class BForm
extends JPanel
implements ActionListener {
    Logger log = Logger.getLogger(BForm.class.getName());
    BLogHandle logHandle;
    BQuery query;
    BTableModel auditModel;
    JTable auditTable;
    JScrollPane auditScrollPane;
    BDB db = null;
    List<BField> fields;
    Map<String, Integer> fieldMap;
    Map<String, JPanel> tabList;
    Map<String, String> inputParams;
    Map<String, String> params;
    JTabbedPane tabs;
    JPanel auditPanel;
    JButton btNew;
    JButton btUpdate;
    JButton btCancel;
    JButton btDel;
    JButton btFilter;
    JButton btAudit;
    JLabel lblErr;
    String linkField = null;
    String linkValue = null;
    boolean isStarting = true;
    boolean canAdd = true;
    boolean canEdit = true;
    boolean canDel = true;
    boolean canAudit = true;
    boolean isFirst = true;
    boolean isLoading = true;

    public BForm(BLogHandle logHandle, BDB db, BElement view) {
        super(null);
        this.db = db;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.linkField = view.getAttribute("linkfield");
        if (view.getName().equals("FORM")) {
            String formFilter = null;
            if (this.linkField != null) {
                formFilter = this.linkField + " is null";
            }
            this.query = new BQuery(db, view, formFilter, null);
        }
        this.params = new HashMap<String, String>();
        this.inputParams = new HashMap<String, String>();
        this.fieldMap = new HashMap<String, Integer>();
        if (view.getAttribute("inputparams") != null) {
            String[] paramArr;
            for (String param : paramArr = view.getAttribute("inputparams").toLowerCase().split(",")) {
                String[] pItems = param.split("=");
                if (pItems.length != 2) continue;
                this.inputParams.put(pItems[0].trim(), pItems[1].trim());
            }
        }
        this.fields = new ArrayList<BField>();
        this.tabList = new HashMap<String, JPanel>();
        this.tabs = new JTabbedPane();
        int i = 0;
        int lh = 10;
        for (BElement el : view.getElements()) {
            if (el.getValue().equals("")) continue;
            this.fields.add(new BField(logHandle, db, el));
            String tabName = el.getAttribute("tab");
            if (tabName == null) {
                lh = this.fields.get(i).getY() + this.fields.get(i).getH();
                this.fields.get(i).addToPanel(this);
            } else {
                if (!this.tabList.containsKey(tabName)) {
                    this.tabList.put(tabName, new JPanel(null));
                    this.tabs.add(tabName, this.tabList.get(tabName));
                }
                this.fields.get(i).addToPanel(this.tabList.get(tabName));
            }
            this.fieldMap.put(el.getValue().trim(), i);
            if (this.fields.get(i).hadListener()) {
                this.fields.get(i).addActionListener(this);
            }
            ++i;
        }
        int tw = Integer.valueOf(view.getAttribute("tw", "700"));
        int th = Integer.valueOf(view.getAttribute("th", "300"));
        if (this.tabList.size() > 0) {
            this.tabs.setBounds(0, lh + 2, tw, th + 8);
            lh += th + 10;
            super.add(this.tabs);
        }
        lh += 2;
        if (view.getName().equals("FORM")) {
            if (view.getAttribute("del") != null) {
                this.canDel = false;
            }
            if (view.getAttribute("delete") != null) {
                this.canDel = false;
            }
            if (view.getAttribute("audit") != null) {
                this.canAudit = false;
            }
            if (view.getAttribute("new") != null) {
                this.canAdd = false;
            } else {
                this.btNew = new JButton("New");
                this.btNew.addActionListener(this);
                this.btNew.setBounds(10, lh, 100, 20);
                super.add(this.btNew);
            }
            if (view.getAttribute("edit") != null) {
                this.canEdit = false;
            }
            if (this.canAdd || this.canEdit) {
                this.btUpdate = new JButton("Save");
                this.btUpdate.addActionListener(this);
                this.btUpdate.setBounds(125, lh, 100, 20);
                super.add(this.btUpdate);
                this.btCancel = new JButton("Cancel");
                this.btCancel.addActionListener(this);
                this.btCancel.setBounds(240, lh, 100, 20);
                super.add(this.btCancel);
            }
            if (this.canDel) {
                this.btDel = new JButton("Delete");
                this.btDel.addActionListener(this);
                this.btDel.setBounds(350, lh, 100, 20);
                super.add(this.btDel);
            }
            if (this.canAudit) {
                this.btAudit = new JButton("Audit");
                this.btAudit.addActionListener(this);
                this.btAudit.setBounds(470, lh, 100, 20);
                super.add(this.btAudit);
            }
            this.lblErr = new JLabel("");
            this.lblErr.setOpaque(true);
            this.lblErr.setBounds(10, lh += 22, 500, 20);
            super.add(this.lblErr);
            this.auditPanel = new JPanel(new BorderLayout());
            this.auditPanel.setOpaque(true);
            this.auditPanel.setBounds(10, lh += 22, 500, 100);
            super.add(this.auditPanel);
            this.auditModel = new BTableModel();
            this.auditTable = new JTable(this.auditModel);
            this.auditScrollPane = new JScrollPane(this.auditTable);
            this.auditPanel.add((Component)this.auditScrollPane, "Center");
        } else if (view.getName().equals("FILTERFORM")) {
            this.btFilter = new JButton("Filter");
            this.btFilter.setBounds(10, lh, 100, 20);
            super.add(this.btFilter);
        }
    }

    public void link(String key, String linkValue) {
        this.linkValue = linkValue;
        for (BField field : this.fields) {
            field.setLinkData(linkValue);
            field.refresh();
        }
        this.filter(this.query.getKeyFieldName() + " = '" + key + "'", null);
        this.query.cancel();
        this.query.recEdit();
        this.lblErr.setText("");
        if (this.canAdd) {
            this.btNew.setVisible(false);
        }
        if (this.canDel) {
            this.btDel.setVisible(true);
        }
        if (this.canAudit) {
            this.btAudit.setVisible(true);
        }
        this.auditPanel.setVisible(false);
    }

    public void filter(String wheresql, String orderby) {
        this.isLoading = true;
        this.query.filter(wheresql, orderby);
        if (this.query.moveNext()) {
            for (BField field : this.fields) {
                field.setText(this.query.readField(field.getName()));
                if (!field.hadListener()) continue;
                int fIdx = this.fieldMap.get(field.getComboLink());
                this.fields.get(fIdx).setLinkData(field.getText());
            }
        }
        this.isLoading = false;
    }

    public void newRecord(String linkField, String linkValue, Map<String, String> passParams) {
        if (this.linkField == null) {
            this.linkField = linkField;
        }
        this.linkValue = linkValue;
        this.params.putAll(passParams);
        this.isLoading = true;
        for (BField field : this.fields) {
            field.setLinkData(linkValue);
        }
        this.isLoading = false;
        this.newRecord();
    }

    public void newRecord() {
        this.isLoading = true;
        for (BField field : this.fields) {
            field.setNew();
        }
        this.isLoading = false;
        this.query.cancel();
        this.query.recAdd();
        this.lblErr.setText("");
        if (this.linkField != null) {
            this.query.updateField(this.linkField, this.linkValue);
        }
        for (String param : this.inputParams.keySet()) {
            String inputParam = this.inputParams.get(param);
            this.query.updateField(param, this.params.get(inputParam));
        }
        if (this.canAdd) {
            this.btNew.setVisible(true);
            this.btUpdate.setVisible(true);
        }
        this.btDel.setVisible(false);
        if (this.canAudit) {
            this.btAudit.setVisible(false);
            this.auditPanel.setVisible(false);
        }
    }

    public void updateRecord() {
        String errMsg = "";
        for (BField field : this.fields) {
            errMsg = errMsg + this.query.updateField(field.getName(), field.getText());
            errMsg = errMsg + field.getErrMsg();
        }
        if ("".equals(errMsg = errMsg + this.query.recSave())) {
            errMsg = "Record is Updated";
        }
        this.lblErr.setText(errMsg);
        this.query.moveFirst();
    }

    public void moveFirst() {
        this.query.moveFirst();
    }

    public void cancel() {
        this.query.cancel();
    }

    public void setData() {
        for (BField field : this.fields) {
            field.setText(this.query.readField(field.getName()));
        }
    }

    public void setListener(BFilter flt) {
        this.btFilter.addActionListener(flt);
    }

    public Map<String, String> getParam() {
        HashMap<String, String> param = new HashMap<String, String>();
        for (BField field : this.fields) {
            param.put(field.getName(), field.getText());
        }
        return param;
    }

    public String getWhere() {
        this.isFirst = true;
        String mystr = "";
        for (BField field : this.fields) {
            mystr = mystr + this.makewhere(field.getName(), field.getText(), field.getFilter());
        }
        return mystr;
    }

    private String makewhere(String name, String text, String filter) {
        String mystr = "";
        if (!text.equals("")) {
            if (this.isFirst) {
                this.isFirst = false;
            } else {
                mystr = mystr + " AND ";
            }
            mystr = filter == null ? mystr + "(" + name + " ILIKE '%" + text + "%')" : mystr + "(" + name + " " + filter + " '" + text + "')";
        }
        return mystr;
    }

    public void showAudit() {
        String mysql = "SELECT entitys.entity_name, sys_audit_trail.user_id, sys_audit_trail.change_date, ";
        mysql = mysql + "sys_audit_trail.change_type, sys_audit_trail.user_ip ";
        mysql = this.db.getDBType() == 1 ? mysql + "FROM sys_audit_trail LEFT JOIN entitys ON sys_audit_trail.user_id  = CAST(entitys.entity_id as varchar) " : mysql + "FROM sys_audit_trail LEFT JOIN entitys ON sys_audit_trail.user_id  = entitys.entity_id ";
        mysql = mysql + "WHERE (sys_audit_trail.table_name = '" + this.query.getTableName() + "') ";
        mysql = mysql + "AND (sys_audit_trail.record_id = '" + this.query.getKeyField() + "')";
        String[] mytitles = new String[]{"Done By", "ID", "Done On", "Change", "Source"};
        this.auditModel = new BTableModel(this.db, mysql, -1);
        this.auditModel.setTitles(mytitles);
        this.auditTable.setModel(this.auditModel);
        this.auditTable.setFillsViewportHeight(true);
        this.auditTable.setAutoCreateRowSorter(true);
        if (this.auditPanel.isVisible()) {
            this.auditPanel.setVisible(false);
        } else {
            this.auditPanel.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("New".equals(aKey)) {
            this.newRecord();
        } else if ("Save".equals(aKey)) {
            this.updateRecord();
        } else if ("Cancel".equals(aKey)) {
            this.cancel();
        } else if ("Delete".equals(aKey)) {
            int n;
            if (this.canDel && (n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the record?", "Deletion", 0)) == 0) {
                String err = this.query.recDelete();
                if (err == null) {
                    for (BField field : this.fields) {
                        field.setNew();
                    }
                    this.lblErr.setText("The record is deleted.");
                    if (this.canAdd) {
                        this.btNew.setVisible(true);
                    }
                    this.btUpdate.setVisible(false);
                    this.btDel.setVisible(false);
                    this.btAudit.setVisible(false);
                    this.auditPanel.setVisible(false);
                } else {
                    this.lblErr.setText(err);
                }
            }
        } else if ("Audit".equals(aKey)) {
            this.showAudit();
        } else if (!this.isLoading && "comboBoxChanged".equals(aKey)) {
            for (BField field : this.fields) {
                if (!field.hadListener()) continue;
                int fIdx = this.fieldMap.get(field.getComboLink());
                this.fields.get(fIdx).setLinkData(field.getText());
            }
        }
    }

    public boolean allowNew() {
        return this.canAdd;
    }

    public boolean allowEdit() {
        return this.canEdit;
    }
}

