/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.app;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumn;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.baraza.DB.BDB;
import org.baraza.DB.BImportModel;
import org.baraza.DB.BQuery;
import org.baraza.DB.BTableModel;
import org.baraza.app.BActions;
import org.baraza.app.BBrowser;
import org.baraza.app.BFiles;
import org.baraza.app.BForm;
import org.baraza.app.BTabs;
import org.baraza.reports.BReport;
import org.baraza.swing.BDateTimeRenderer;
import org.baraza.swing.BTextIcon;
import org.baraza.swing.BTimeRenderer;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

class BGrids
extends JPanel
implements ActionListener,
MouseListener {
    Logger log = Logger.getLogger(BGrids.class.getName());
    BLogHandle logHandle;
    JScrollPane scrollPane;
    JScrollPane editScrollPane;
    JTable table;
    JPanel cards;
    JPanel gridCards;
    JPanel gridControls;
    JPanel formControl;
    JPanel filterPanel;
    JPanel gridPanel;
    JPanel formPanel;
    JCheckBox checkAnd;
    JCheckBox checkOr;
    JButton btAction;
    List<JButton> gridFunct;
    List<BForm> forms;
    List<BGrids> grids;
    List<BReport> reports;
    List<BTabs> tabs;
    List<BBrowser> browsers;
    List<BFiles> files;
    BActions actions = null;
    JEditorPane editorPane;
    JEditorPane footerPane;
    HTMLEditorKit cssKit;
    StyleSheet styleSheet;
    JTabbedPane formsPane;
    JTextField filterData;
    JComboBox<String> fieldList;
    JComboBox<String> filterList;
    JComboBox<String> actionList;
    BTableModel tableModel;
    boolean reportMode = false;
    boolean importProcess = false;
    BElement view;
    BDB db;
    Map<String, String> linkParams;
    Map<String, String> params;
    String tableFilter = null;
    String linkFilter = null;
    String linkValue = null;
    String linkField = null;
    String importType = null;
    String updateTable = null;
    String[] viewFilter = new String[2];
    String noDel = null;

    public BGrids(BLogHandle logHandle, BDB db, BElement view, String reportDir, boolean nullFilter) {
        super(new BorderLayout());
        this.view = view;
        this.db = db;
        this.logHandle = logHandle;
        logHandle.config(this.log);
        this.linkField = view.getAttribute("linkfield");
        this.importType = view.getAttribute("import");
        this.updateTable = view.getAttribute("update");
        this.noDel = view.getAttribute("del");
        String nfl = null;
        if (this.linkField != null) {
            nfl = this.linkField + " is null";
        }
        if (nullFilter) {
            nfl = view.getAttribute("keyfield") + " is null";
        }
        this.linkParams = new HashMap<String, String>();
        this.params = new HashMap<String, String>();
        if (view.getAttribute("linkparams") != null) {
            String[] paramArr = view.getAttribute("linkparams").toLowerCase().split(",");
            for (String param : paramArr) {
                String[] pItems = param.split("=");
                if (pItems.length != 2) continue;
                this.linkParams.put(pItems[0].trim(), pItems[1].trim());
            }
        }
        if (view.getAttribute("viewfilter") != null) {
            String[] viewFs = view.getAttribute("viewfilter").toLowerCase().split(",");
            for (String vfa : viewFs) {
                String[] viewF = vfa.split("=");
                if (viewF.length == 2) {
                    this.viewFilter[0] = viewF[0];
                    this.viewFilter[1] = viewF[1];
                    continue;
                }
                this.viewFilter[0] = null;
                this.viewFilter[1] = null;
            }
        } else {
            this.viewFilter[0] = null;
            this.viewFilter[1] = null;
        }
        this.tableModel = new BTableModel(db, view, nfl);
        this.table = new JTable(this.tableModel);
        this.table.setFillsViewportHeight(true);
        this.table.setAutoCreateRowSorter(true);
        this.table.addMouseListener(this);
        this.table.setDefaultRenderer(Timestamp.class, new BDateTimeRenderer());
        this.table.setDefaultRenderer(Time.class, new BTimeRenderer());
        if (this.updateTable == null && this.tableModel.getTableName().toLowerCase().startsWith("vw_")) {
            this.updateTable = this.tableModel.getTableName().replace("vw_", "").trim();
            if (!db.getTables().contains(this.updateTable)) {
                this.updateTable = null;
            }
        }
        this.scrollPane = new JScrollPane(this.table);
        this.formsPane = new JTabbedPane(4);
        this.formsPane.addMouseListener(this);
        this.forms = new ArrayList<BForm>();
        this.grids = new ArrayList<BGrids>();
        this.reports = new ArrayList<BReport>();
        this.tabs = new ArrayList<BTabs>();
        this.browsers = new ArrayList<BBrowser>();
        this.files = new ArrayList<BFiles>();
        this.editorPane = new JEditorPane();
        this.editScrollPane = new JScrollPane(this.editorPane);
        this.editorPane.setContentType("text/html");
        this.editorPane.setEditable(false);
        this.cssKit = new HTMLEditorKit();
        this.editorPane.setEditorKit(this.cssKit);
        StyleSheet styleSheet = this.cssKit.getStyleSheet();
        styleSheet.addRule("h1 {color: blue;}\n");
        styleSheet.addRule("table{border-spacing: 0px; border-collapse: collapse; width: 100%; }\n");
        styleSheet.addRule("th {text-align: left; font-weight: bold; padding: 1px; border: 1px solid #FFFFFF; background: #4a70aa; color: #FFFFFF; }\n");
        styleSheet.addRule("th {border-color: #FFFFFF;border-width: 1px 1px 0 0; border-style; solid thin;}\n");
        styleSheet.addRule("tr {text-align: left; padding: 1px; border: 1px solid #FFFFFF; background: #e3f0f7; }\n");
        styleSheet.addRule("tr.alt {background: #f7f7f7; }\n");
        styleSheet.addRule("td {border-color: #FFFFFF;border-width: 1px 1px 0 0; border-style; solid thin; }\n");
        for (BElement el : view.getElements()) {
            BTextIcon textIcon;
            if (el.getName().equals("FORM")) {
                this.forms.add(new BForm(logHandle, db, el));
                this.tabs.add(new BTabs(1, this.forms.size() - 1));
                String paneName = el.getAttribute("name");
                textIcon = new BTextIcon(this.formsPane, paneName, 4);
                this.formsPane.addTab("", textIcon, this.forms.get(this.forms.size() - 1));
                continue;
            }
            if (el.getName().equals("GRID") || el.getName().equals("FORMVIEW")) {
                this.grids.add(new BGrids(logHandle, db, el, reportDir, nullFilter));
                this.tabs.add(new BTabs(2, this.grids.size() - 1));
                String paneName = el.getAttribute("name");
                textIcon = new BTextIcon(this.formsPane, paneName, 4);
                this.formsPane.addTab("", textIcon, this.grids.get(this.grids.size() - 1));
                continue;
            }
            if (el.getName().equals("JASPER")) {
                this.reports.add(new BReport(logHandle, db, el, reportDir));
                this.tabs.add(new BTabs(3, this.reports.size() - 1));
                String paneName = el.getAttribute("name");
                textIcon = new BTextIcon(this.formsPane, paneName, 4);
                this.formsPane.addTab("", textIcon, this.reports.get(this.reports.size() - 1));
                continue;
            }
            if (el.getName().equals("BROWSER")) {
                this.browsers.add(new BBrowser(el));
                this.tabs.add(new BTabs(4, this.browsers.size() - 1));
                String paneName = el.getAttribute("name");
                if (paneName == null) {
                    paneName = el.getAttribute("title");
                }
                textIcon = new BTextIcon(this.formsPane, paneName, 4);
                this.formsPane.addTab("", textIcon, this.browsers.get(this.browsers.size() - 1));
                continue;
            }
            if (el.getName().equals("FILES")) {
                this.files.add(new BFiles(logHandle, db, el));
                this.tabs.add(new BTabs(4, this.files.size() - 1));
                String paneName = el.getAttribute("name");
                textIcon = new BTextIcon(this.formsPane, paneName, 4);
                this.formsPane.addTab("", textIcon, this.files.get(this.files.size() - 1));
                continue;
            }
            if (!el.getName().equals("ACTIONS")) continue;
            this.actions = new BActions(logHandle, el, db);
        }
        this.filterPanel = new JPanel(new FlowLayout());
        this.filterData = new JTextField(15);
        this.filterData.setActionCommand("Filter");
        this.filterData.addActionListener(this);
        String[] filterstr = new String[]{"ILIKE", "LIKE", "=", ">", "<", "<=", ">="};
        this.fieldList = new JComboBox<String>(this.tableModel.getColumnNames());
        this.filterList = new JComboBox<String>(filterstr);
        this.checkAnd = new JCheckBox("And");
        this.checkOr = new JCheckBox("Or");
        this.filterPanel.add(this.fieldList);
        this.filterPanel.add(this.filterList);
        this.filterPanel.add(this.filterData);
        this.filterPanel.add(this.checkAnd);
        this.filterPanel.add(this.checkOr);
        if (this.actions != null) {
            this.btAction = new JButton("Action");
            this.btAction.addActionListener(this);
            this.actionList = new JComboBox<String>(this.actions.getActions());
            this.filterPanel.add(this.btAction);
            this.filterPanel.add(this.actionList);
        }
        boolean canDel = true;
        if (view.getAttribute("del") != null) {
            canDel = false;
        }
        if (view.getAttribute("delete") != null) {
            canDel = false;
        }
        this.gridFunct = new ArrayList<JButton>();
        this.gridControls = new JPanel();
        this.gridFunct.add(new JButton("New"));
        this.gridFunct.add(new JButton("Refresh"));
        if (canDel) {
            this.gridFunct.add(new JButton("Delete"));
        }
        this.gridFunct.add(new JButton("Export"));
        BElement impEl = view.getElementByName("IMPORT");
        if (impEl != null) {
            this.gridFunct.add(new JButton("Import"));
        }
        if (this.importType != null) {
            this.gridFunct.add(new JButton("Import"));
        }
        this.gridFunct.add(new JButton("Report"));
        this.gridFunct.add(new JButton("Print"));
        for (JButton btn : this.gridFunct) {
            this.gridControls.add(btn);
            btn.addActionListener(this);
        }
        this.gridCards = new JPanel(new CardLayout());
        this.gridCards.add((Component)this.scrollPane, "grid");
        this.gridCards.add((Component)this.editScrollPane, "report");
        this.gridPanel = new JPanel(new BorderLayout());
        this.gridPanel.add((Component)this.gridControls, "First");
        this.gridPanel.add((Component)this.gridCards, "Center");
        this.gridPanel.add((Component)this.filterPanel, "Last");
        this.footerPane = new JEditorPane();
        this.footerPane.setContentType("text/html");
        this.footerPane.setEditorKit(this.cssKit);
        this.formPanel = new JPanel(new BorderLayout());
        this.formPanel.add((Component)this.formsPane, "Center");
        this.formPanel.add((Component)this.footerPane, "Last");
        this.cards = new JPanel(new CardLayout());
        this.cards.add((Component)this.gridPanel, "grid");
        this.cards.add((Component)this.formPanel, "form");
        super.add((Component)this.cards, "Center");
        this.adjustWidth();
    }

    public void exportData() {
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            String filename = fc.getSelectedFile().getAbsolutePath() + ".csv";
            this.tableModel.savecvs(filename);
        }
    }

    public void showForms() {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, "form");
    }

    public void hideForms() {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        cl.show(this.cards, "grid");
    }

    public void showReport() {
        CardLayout cl;
        int j = 0;
        for (JButton button : this.gridFunct) {
            if (j++ >= 3) continue;
            button.setEnabled(this.reportMode);
        }
        if (this.reportMode) {
            cl = (CardLayout)this.gridCards.getLayout();
            cl.show(this.gridCards, "grid");
            this.reportMode = false;
        } else {
            cl = (CardLayout)this.gridCards.getLayout();
            cl.show(this.gridCards, "report");
            this.reportMode = true;
            String mypage = "<html><body>" + this.tableModel.readDocument(true, false) + "</body></html>";
            this.editorPane.setText(mypage);
            this.editorPane.setCaretPosition(0);
        }
    }

    public void deleteRecords() {
        int n = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete the record?", "Deletion", 0);
        if (n == 0) {
            int[] selection = this.table.getSelectedRows();
            Arrays.sort(selection);
            int i = 1;
            for (int sel : selection) {
                int index = this.table.convertRowIndexToModel(sel) + i;
                --i;
                this.tableModel.movePos(index);
                if (this.updateTable == null) {
                    this.tableModel.recDelete();
                    continue;
                }
                this.tableModel.recAudit("DELETE", this.tableModel.getKeyField());
                String mysql = "DELETE FROM " + this.updateTable;
                mysql = mysql + " WHERE " + this.tableModel.getKeyFieldName() + " = '" + this.tableModel.getKeyField() + "'";
                this.db.executeQuery(mysql);
            }
            this.tableModel.requery();
        }
    }

    public void filter() {
        String wheresql = "(";
        String filterStr = null;
        if (this.linkField != null) {
            filterStr = "(" + this.linkField + " = '" + this.linkValue + "')";
        }
        for (String param : this.linkParams.keySet()) {
            filterStr = filterStr == null ? "(" : filterStr + " AND (";
            if (this.params.get(param) == null) {
                filterStr = filterStr + this.linkParams.get(param) + " = null)";
                continue;
            }
            filterStr = filterStr + this.linkParams.get(param) + " = '" + this.params.get(param) + "')";
        }
        if (this.tableFilter != null) {
            if (this.checkOr.isSelected()) {
                wheresql = this.tableFilter + " OR (";
            }
            if (this.checkAnd.isSelected()) {
                wheresql = this.tableFilter + " AND (";
            }
        }
        wheresql = wheresql + this.tableModel.getFieldName(this.fieldList.getSelectedIndex());
        wheresql = wheresql + " " + this.filterList.getSelectedItem();
        wheresql = this.filterList.getSelectedIndex() < 2 ? wheresql + " '%" + this.filterData.getText() + "%')" : wheresql + " '" + this.filterData.getText() + "')";
        this.tableFilter = wheresql;
        if (filterStr != null) {
            wheresql = "(" + filterStr + ") AND (" + wheresql + ")";
        }
        this.tableModel.filter(wheresql, null);
        if (this.reportMode) {
            String mypage = "<html><body>" + this.tableModel.readDocument(true, false) + "</body></html>";
            this.editorPane.setText(mypage);
            this.editorPane.setCaretPosition(0);
        }
        this.adjustWidth();
    }

    public void link(String linkValue, Map<String, String> passParams, Map<String, String> queryParams) {
        this.linkValue = linkValue;
        this.params.putAll(passParams);
        this.params.putAll(queryParams);
        this.hideForms();
        this.filter(null);
    }

    public void filter(String wheresql) {
        String filterStr = wheresql;
        if (this.linkField != null) {
            filterStr = filterStr == null ? "(" : filterStr + " AND (";
            filterStr = filterStr + this.linkField + " = '" + this.linkValue + "')";
        }
        for (String param : this.linkParams.keySet()) {
            filterStr = filterStr == null ? "(" : filterStr + " AND (";
            if (this.params.get(param) == null) {
                filterStr = filterStr + this.linkParams.get(param) + " = null)";
                continue;
            }
            filterStr = filterStr + this.linkParams.get(param) + " = '" + this.params.get(param) + "')";
        }
        this.tableModel.filter(filterStr, null);
        this.tableModel.refresh();
    }

    public void importData() {
        System.out.println("Import Data");
        if (this.importProcess) {
            if (this.view.getAttribute("process") != null) {
                String updSQL = "SELECT " + this.view.getAttribute("process");
                updSQL = updSQL + "('" + this.db.getOrgID() + "', '" + this.db.getUserID() + "', '" + this.db.getUserIP() + "')";
                System.out.println(updSQL);
                this.db.executeQuery(updSQL);
            }
            this.refresh();
            this.gridFunct.get(4).setText("Import");
            this.importProcess = false;
        } else {
            BElement impEl = this.view.getElementByName("IMPORT");
            if (impEl != null) {
                BDB impDB = new BDB(impEl);
                BQuery impQuery = new BQuery(impDB, impEl, null, null);
                this.tableModel.importData(impQuery.getData());
                this.tableModel.requery();
                impQuery.close();
                impDB.close();
            } else if (this.importType != null) {
                if (this.importType.equals("excel")) {
                    BImportModel impExcel = new BImportModel(this.view);
                    String worksheet = this.view.getAttribute("worksheet", "0");
                    impExcel.getExcelData(this, worksheet);
                    this.tableModel.importData(impExcel.getData());
                    this.tableModel.requery();
                    impExcel.close();
                } else if (this.importType.equals("text")) {
                    BImportModel impcsv = new BImportModel(this.view);
                    impcsv.getTextData(this, this.view.getAttribute("delimiter"));
                    this.tableModel.importData(impcsv.getData());
                    this.tableModel.requery();
                    impcsv.close();
                } else if (this.importType.equals("record")) {
                    BImportModel imprec = new BImportModel(this.view);
                    imprec.getRecordData(this);
                    this.tableModel.importData(imprec.getData());
                    this.tableModel.requery();
                    imprec.close();
                }
            }
            this.refresh();
            this.gridFunct.get(4).setText("Process");
            this.importProcess = true;
        }
    }

    public void refresh() {
        this.filter(null);
        if (this.reportMode) {
            String mypage = "<html><body>" + this.tableModel.readDocument(true, false) + "</body></html>";
            this.editorPane.setText(mypage);
            this.editorPane.setCaretPosition(0);
        }
        this.adjustWidth();
    }

    public void adjustWidth() {
        int i = 0;
        for (BElement el : this.view.getElements()) {
            if (el.getValue().equals("")) continue;
            int w = Integer.valueOf(el.getAttribute("w", "40"));
            TableColumn column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(w);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("New".equals(aKey)) {
            if (this.forms.size() > 0) {
                for (BForm form : this.forms) {
                    if (!form.allowNew()) continue;
                    form.newRecord(this.linkField, this.linkValue, this.params);
                }
                int i = 0;
                for (BTabs tab : this.tabs) {
                    if (tab.getType() == 1) {
                        if (tab.getIndex() == 0) {
                            this.formsPane.setSelectedIndex(i);
                        }
                    } else {
                        this.formsPane.setEnabledAt(i, false);
                    }
                    ++i;
                }
                this.showForms();
            }
        } else if ("Refresh".equals(aKey)) {
            this.refresh();
        } else if ("Delete".equals(aKey)) {
            if (this.noDel == null) {
                this.deleteRecords();
            }
        } else if ("Export".equals(aKey)) {
            this.exportData();
        } else if ("Filter".equals(aKey)) {
            this.filter();
        } else if ("Import".equals(aKey)) {
            this.importData();
        } else if ("Process".equals(aKey)) {
            this.importData();
        } else if ("Action".equals(aKey)) {
            this.actions.execproc(this.actionList.getSelectedIndex(), this.getKey(), this.linkValue);
            this.tableModel.requery();
        } else if ("Report".equals(aKey)) {
            this.showReport();
        } else if ("Print".equals(aKey)) {
            this.showReport();
            try {
                this.editorPane.print();
            }
            catch (PrinterException ex) {
                this.log.severe("Report Printing Error : " + ex);
            }
        }
    }

    public JTable getTable() {
        return this.table;
    }

    public String getKey() {
        String key = null;
        int aRow = this.table.getSelectedRow();
        if (aRow != -1) {
            int index = this.table.convertRowIndexToModel(aRow) + 1;
            this.tableModel.movePos(index);
            key = this.tableModel.getKeyField();
        }
        return key;
    }

    public String[] getViewFilter() {
        return this.viewFilter;
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (ev.getComponent().equals(this.table)) {
            int aRow = this.table.getSelectedRow();
            if (aRow != -1 && ev.getClickCount() == 2 && this.tabs.size() > 0) {
                int index = this.table.convertRowIndexToModel(aRow) + 1;
                this.tableModel.movePos(index);
                String key = this.tableModel.getKeyField();
                String keyField = this.tableModel.getKeyFieldName();
                if (key != null) {
                    for (BForm form : this.forms) {
                        if (!form.allowEdit()) continue;
                        form.link(key, this.linkValue);
                    }
                    for (BGrids grid : this.grids) {
                        grid.link(key, this.params, this.tableModel.getParams());
                    }
                    for (BReport report : this.reports) {
                        report.putLink(key);
                        report.drillReport();
                    }
                    for (BBrowser browser : this.browsers) {
                        browser.setPage(key);
                    }
                    for (BFiles file : this.files) {
                        file.link(key, this.tableModel.getParams());
                    }
                    BQuery ft = new BQuery(this.db, this.view, keyField + " = '" + key + "'", null);
                    this.footerPane.setText("<html><body><table>" + ft.readDocument(false, true) + "</table></html>");
                    this.footerPane.setCaretPosition(0);
                    ft.close();
                }
                int i = 0;
                int j = -1;
                boolean showTabs = false;
                for (BTabs tab : this.tabs) {
                    String vfv;
                    String vft;
                    if (tab.getType() == 1) {
                        if (!this.forms.get(tab.getIndex()).allowEdit()) {
                            this.formsPane.setEnabledAt(i, false);
                        } else {
                            this.formsPane.setEnabledAt(i, true);
                            showTabs = true;
                        }
                    } else if (tab.getType() == 2) {
                        vft = this.grids.get(tab.getIndex()).getViewFilter()[0];
                        vfv = this.grids.get(tab.getIndex()).getViewFilter()[1];
                        if (vft != null && vfv != null) {
                            if (vfv.equals(this.tableModel.getParams().get(vft))) {
                                this.formsPane.setEnabledAt(i, true);
                                showTabs = true;
                            } else {
                                this.formsPane.setEnabledAt(i, false);
                            }
                        } else {
                            this.formsPane.setEnabledAt(i, true);
                            showTabs = true;
                        }
                    } else if (tab.getType() == 3) {
                        vft = this.reports.get(tab.getIndex()).getViewFilter()[0];
                        vfv = this.reports.get(tab.getIndex()).getViewFilter()[1];
                        if (vft != null && vfv != null) {
                            if (vfv.equals(this.tableModel.getParams().get(vft))) {
                                this.formsPane.setEnabledAt(i, true);
                                showTabs = true;
                            } else {
                                this.formsPane.setEnabledAt(i, false);
                            }
                        } else {
                            this.formsPane.setEnabledAt(i, true);
                            showTabs = true;
                        }
                    } else {
                        this.formsPane.setEnabledAt(i, true);
                        showTabs = true;
                    }
                    if (showTabs && j == -1) {
                        j = i;
                    }
                    ++i;
                }
                if (j == -1) {
                    j = 0;
                }
                this.formsPane.setSelectedIndex(j);
                if (showTabs) {
                    this.showForms();
                }
            }
        } else if (ev.getComponent().equals(this.formsPane)) {
            int j;
            int i = this.formsPane.getSelectedIndex();
            if (this.tabs.get(i).getType() == 2) {
                j = this.tabs.get(i).getIndex();
                this.grids.get(j).hideForms();
                this.grids.get(j).refresh();
            }
            if (this.tabs.get(i).getType() == 3) {
                j = this.tabs.get(i).getIndex();
                this.reports.get(j).drillReport();
            }
        }
    }
}

