/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.ide;

import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import org.baraza.swing.BTextArea;
import org.baraza.utils.BLogHandle;
import org.baraza.utils.Bio;

public class BFileEdit
implements KeyListener {
    Logger log = Logger.getLogger(BFileEdit.class.getName());
    public JScrollPane scrollPanes;
    File dbFile = null;
    String dbDirName = null;
    BTextArea textArea;
    Bio io;

    public BFileEdit(File lfile, BLogHandle logHandle) {
        logHandle.config(this.log);
        this.dbFile = lfile;
        this.textArea = new BTextArea(logHandle);
        this.textArea.setTabSize(4);
        this.scrollPanes = new JScrollPane(this.textArea);
        this.io = new Bio();
        this.textArea.setText(this.io.loadFile(this.dbFile));
        this.textArea.setCaretPosition(0);
        this.textArea.addKeyListener(this);
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        Font font = this.textArea.getFont();
    }

    public BFileEdit(String dbDirName, BLogHandle logHandle) {
        this.dbDirName = dbDirName;
        logHandle.config(this.log);
        this.textArea = new BTextArea(logHandle);
        this.textArea.addKeyListener(this);
        this.textArea.setTabSize(4);
        this.scrollPanes = new JScrollPane(this.textArea);
        this.io = new Bio();
    }

    public void saveFile() {
        if (this.dbFile == null) {
            this.saveAsFile();
        } else {
            this.io.saveFile(this.dbFile, this.textArea.getText());
        }
        this.log.info("File saved : " + BFileEdit.getCurrentDate("yyyy/MM/dd HH:mm:ss"));
    }

    public void saveAsFile() {
        JFileChooser fc = new JFileChooser(this.dbDirName);
        int i = fc.showSaveDialog(this.textArea);
        if (i == 0) {
            this.dbFile = fc.getSelectedFile();
            this.saveFile();
        }
    }

    public String getName() {
        String flName = "new.sql";
        if (this.dbFile != null) {
            flName = this.dbFile.getName();
        }
        return flName;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void setText(String mystr) {
        this.textArea.setText(mystr);
    }

    public void appendText(String mystr) {
        mystr = mystr + "\n" + mystr;
        this.textArea.append(mystr);
    }

    public static String getCurrentDate(String format) {
        String mydate = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Date date = new Date();
        mydate = "" + dateFormat.format(date);
        return mydate;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isControlDown() && e.getKeyChar() != 's' && e.getKeyCode() == 83) {
            this.saveFile();
        } else if (e.isControlDown() && e.isShiftDown() && e.getKeyChar() != 's' && e.getKeyCode() == 83) {
            this.saveAsFile();
            System.out.println("File Saved As ");
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

