/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.ide;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import org.baraza.app.BAbout;
import org.baraza.ide.BDevelop;
import org.baraza.swing.BCellRenderer;
import org.baraza.swing.BImageDesktop;
import org.baraza.swing.BImageTree;
import org.baraza.utils.BDesEncrypter;
import org.baraza.utils.BLogHandle;
import org.baraza.utils.Bio;
import org.baraza.xml.BElement;
import org.baraza.xml.BTreeNode;
import org.baraza.xml.BXML;

public class BIDE
extends JPanel
implements TreeSelectionListener,
ActionListener {
    Logger log = Logger.getLogger(BIDE.class.getName());
    String configDir;
    String configFile;
    BElement root;
    Map<BElement, BDevelop> develop;
    BTreeNode top = null;
    BImageTree tree;
    DefaultTreeModel treemodel;
    BLogHandle logHandle;
    JSplitPane splitPane;
    JDesktopPane desktop;
    JScrollPane treeScroll;
    JPanel treePanel;
    JPanel mainPanel;

    public BIDE(String configDir) {
        super(new BorderLayout());
        this.configDir = configDir;
        this.configFile = "config.xml";
        BXML xml = new BXML(configDir + this.configFile, false);
        this.root = xml.getRoot();
        this.logHandle = new BLogHandle();
        this.logHandle.config(this.log);
        this.develop = new HashMap<BElement, BDevelop>();
        this.mainPanel = new JPanel(new BorderLayout());
        this.treePanel = new JPanel(new BorderLayout());
        this.top = new BTreeNode(this.root, "APP");
        for (BElement el : this.root.getElements()) {
            this.top.add(new BTreeNode(el, el.getValue()));
        }
        this.treemodel = new DefaultTreeModel(this.top);
        this.tree = new BImageTree("/org/baraza/resources/leftpanel.jpg", this.treemodel, true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new BCellRenderer());
        this.tree.addTreeSelectionListener(this);
        this.treeScroll = new JScrollPane(this.tree);
        this.treePanel.add((Component)this.treeScroll, "Center");
        String[] menuStrs = new String[]{"New Project", "Close Project", "Delete Project", "Save Projects", "Encrypt File", "Open Applications", "About"};
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        JMenuItem menuItem = null;
        for (String menuStr : menuStrs) {
            menuItem = new JMenuItem(menuStr);
            menuItem.addActionListener(this);
            fileMenu.add(menuItem);
        }
        menuBar.add(fileMenu);
        super.add((Component)menuBar, "First");
        this.desktop = new BImageDesktop("/org/baraza/resources/background.jpg");
        this.mainPanel.add((Component)this.desktop, "Center");
        this.mainPanel.add((Component)this.logHandle.getStatusBar(), "Last");
        this.splitPane = new JSplitPane(1, this.treePanel, this.mainPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(150);
        super.add((Component)this.splitPane, "Center");
        this.log.info("Status : Running");
    }

    @Override
    public void valueChanged(TreeSelectionEvent ev) {
        BTreeNode node = (BTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            BElement dKey = node.getKey();
            if (this.develop.get(dKey) == null) {
                this.develop.put(dKey, new BDevelop(dKey, this.root, node, this.treemodel, this.configDir, this.logHandle));
            }
            try {
                if (this.develop.get(dKey).isVisible()) {
                    this.develop.get(dKey).setSelected(true);
                    if (this.develop.get(dKey).isIcon()) {
                        this.develop.get(dKey).setIcon(false);
                    }
                } else {
                    this.develop.get(dKey).setVisible(true);
                    this.desktop.add(this.develop.get(dKey));
                    this.develop.get(dKey).setSelected(true);
                }
            }
            catch (PropertyVetoException ex) {
                this.log.severe("Desktop show error : " + ex);
            }
        }
    }

    public void closeProject(boolean delNode) {
        BTreeNode node = (BTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            BTreeNode parent = (BTreeNode)node.getParent();
            if (node.isLeaf()) {
                int n;
                BElement dKey = node.getKey();
                if (this.develop.get(dKey) != null) {
                    this.develop.get(dKey).close();
                    this.develop.remove(dKey);
                    this.tree.removeSelectionPath(this.tree.getSelectionPath());
                }
                if (delNode && parent != null && (n = JOptionPane.showConfirmDialog(this.treePanel, "Are you sure you want to delete the project?", "Project Deletion", 0)) == 0) {
                    this.treemodel.removeNodeFromParent(node);
                    this.root.delNode(dKey);
                    Bio io = new Bio();
                    io.saveFile(this.configDir + "config.xml", this.root.toString());
                    this.log.info("Project deleted");
                }
            }
        } else {
            this.log.info("Select a project first");
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("New Project".equals(aKey)) {
            BDevelop newdevdesk = new BDevelop(this.root, this.top, this.treemodel, this.configDir, this.logHandle);
            newdevdesk.setVisible(true);
            this.desktop.add(newdevdesk);
            try {
                newdevdesk.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                this.log.severe("Desktop show error : " + ex);
            }
        } else if ("Close Project".equals(aKey)) {
            this.closeProject(false);
        } else if ("Delete Project".equals(aKey)) {
            this.closeProject(true);
        } else if ("Save Projects".equals(aKey)) {
            Bio io = new Bio();
            io.saveFile(this.configDir + this.configFile, this.root.toString());
        } else if ("Encrypt File".equals(aKey)) {
            String encryFile = this.configFile.substring(0, this.configFile.length() - 3) + "cph";
            BDesEncrypter encrypter = new BDesEncrypter(this.root.getAttribute("encryption"));
            encrypter.encrypt(this.configDir + this.configFile, this.configDir + encryFile);
        } else if ("Open Applications".equals(aKey)) {
            JFileChooser fc = new JFileChooser(this.configDir);
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File cnFile = fc.getSelectedFile();
                this.configDir = cnFile.getParent() + "/";
                this.configFile = cnFile.getName();
                BXML xml = new BXML(this.configDir + this.configFile, false);
                this.root = xml.getRoot();
                this.top = new BTreeNode(this.root, "APP");
                for (BElement el : this.root.getElements()) {
                    this.top.add(new BTreeNode(el, el.getValue()));
                }
                this.treemodel.setRoot(this.top);
                this.treemodel.reload();
            }
        } else if ("About".equals(aKey)) {
            BAbout about = new BAbout("IDE");
            about.setVisible(true);
            this.desktop.add(about);
            try {
                about.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                this.log.severe("Desktop show error : " + ex);
            }
        }
    }

    public void close() {
        for (BElement dev : this.develop.keySet()) {
            this.develop.get(dev).close();
        }
    }
}

