/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.ide;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.baraza.DB.BDB;
import org.baraza.utils.Bio;
import org.baraza.xml.BElement;
import org.baraza.xml.BXML;

public class BSetup
implements ActionListener {
    String ps = System.getProperty("file.separator");
    String path;
    JPanel panel;
    JTextField ftUserName;
    JTextField ftPassword;
    JLabel lbStatus;
    BXML xml;
    BElement root;

    public BSetup(String path) {
        this.path = path;
        String setupXML = path + this.ps + "setup.xml";
        this.xml = new BXML(setupXML, false);
        this.root = this.xml.getRoot();
    }

    public void runSetup(String filename) {
        String dbPassword;
        String dbUserName = this.root.getAttribute("dbusername");
        String err = this.createDB(filename, dbUserName, dbPassword = this.root.getAttribute("dbpassword"));
        if (err != null) {
            System.out.println(err);
        } else {
            System.out.println("Database creation successfull.");
        }
    }

    public void runUISetup() {
        String dbUserName = this.root.getAttribute("dbusername");
        String dbPassword = this.root.getAttribute("dbpassword");
        this.panel = new JPanel(new GridLayout(0, 2, 2, 2));
        this.lbStatus = new JLabel("Baraza Setup");
        JLabel lbUserName = new JLabel("User Name : ");
        this.ftUserName = new JTextField(dbUserName);
        JLabel lbPassword = new JLabel("Password : ");
        this.ftPassword = new JTextField(dbPassword);
        JButton btTest = new JButton("Test Connection");
        JButton btSave = new JButton("Save Configuration");
        JButton btDemo = new JButton("Create Demo");
        JButton btNew = new JButton("Create New");
        btTest.addActionListener(this);
        btSave.addActionListener(this);
        btDemo.addActionListener(this);
        btNew.addActionListener(this);
        this.panel.add(lbUserName);
        this.panel.add(this.ftUserName);
        this.panel.add(lbPassword);
        this.panel.add(this.ftPassword);
        this.panel.add(btTest);
        this.panel.add(btSave);
        this.panel.add(btDemo);
        this.panel.add(btNew);
        JFrame frame = new JFrame("Baraza Setup");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)this.panel, "Center");
        frame.getContentPane().add((Component)this.lbStatus, "Last");
        frame.setLocation(200, 200);
        frame.setSize(400, 150);
        frame.setVisible(true);
    }

    public void saveConfigs(String dbUserName, String dbPassword) {
        this.root.setAttribute("dbusername", dbUserName);
        this.root.setAttribute("dbpassword", dbPassword);
        this.xml.saveFile();
        String configXML = this.path + this.ps + "config.xml";
        BXML cfgxml = new BXML(configXML, false);
        BElement cfg = cfgxml.getRoot();
        cfg.setAttribute("dbusername", dbUserName);
        cfg.setAttribute("dbpassword", dbPassword);
        for (BElement cel : cfg.getElements()) {
            cel.setAttribute("dbusername", dbUserName);
            cel.setAttribute("dbpassword", dbPassword);
        }
        cfgxml.saveFile();
        String webXML = "..";
        if (this.root.getAttribute("web") == null) {
            webXML = "webapps" + this.ps + "baraza";
        }
        webXML = webXML + this.ps + "META-INF" + this.ps + "context.xml";
        if (this.root.getAttribute("context") != null) {
            webXML = "projects" + this.ps + this.root.getAttribute("path") + this.ps;
            webXML = webXML + "configs" + this.ps + this.root.getAttribute("context");
        }
        BXML webxml = new BXML(webXML, false);
        BElement web = webxml.getRoot();
        for (BElement wel : web.getElements()) {
            if ("org.apache.catalina.realm.JDBCRealm".equals(wel.getAttribute("className"))) {
                wel.setAttribute("connectionName", dbUserName);
                wel.setAttribute("connectionPassword", dbPassword);
            }
            if (!"jdbc/database".equals(wel.getAttribute("name"))) continue;
            wel.setAttribute("username", dbUserName);
            wel.setAttribute("password", dbPassword);
        }
        webxml.saveFile();
    }

    public String createDB(String filename, String dbUserName, String dbPassword) {
        String err = null;
        BDB db = new BDB(this.root, dbUserName, dbPassword);
        if (db.getDB() != null) {
            err = db.executeFunction("SELECT rolname FROM pg_roles WHERE rolname = 'root';");
            if (err == null) {
                db.executeQuery("CREATE ROLE root LOGIN;");
            }
            db.executeQuery("DROP DATABASE " + this.root.getAttribute("dbname"));
            err = db.executeQuery("CREATE DATABASE " + this.root.getAttribute("dbname"));
        }
        db.close();
        BDB ndb = new BDB(this.root.getAttribute("dbclass"), this.root.getAttribute("newdbpath"), dbUserName, dbPassword);
        if (ndb.getDB() != null && err == null) {
            String ps = System.getProperty("file.separator");
            String fpath = "projects" + ps + this.root.getAttribute("path") + ps + "database" + ps + "setup" + ps + filename;
            Bio io = new Bio();
            String mysql = io.loadFile(fpath);
            err = ndb.executeQuery(mysql);
        }
        ndb.close();
        return err;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String aKey = ev.getActionCommand();
        if ("Test Connection".equals(aKey)) {
            BDB db = new BDB(this.root, this.ftUserName.getText(), this.ftPassword.getText());
            if (db.getDB() == null) {
                this.lbStatus.setText("Connection Error");
            } else {
                this.lbStatus.setText("Connection Successfull");
            }
            db.close();
        } else if ("Save Configuration".equals(aKey)) {
            this.saveConfigs(this.ftUserName.getText(), this.ftPassword.getText());
            this.lbStatus.setText("Configurations Saved");
        } else if ("Create Demo".equals(aKey)) {
            this.lbStatus.setText("The process will take a while to complete.");
            int n = JOptionPane.showConfirmDialog(this.panel, "This will delete existing database, are you sure you want to proceed?", "Demo Database", 0);
            if (n == 0) {
                String err = this.createDB("demo.sql", this.ftUserName.getText(), this.ftPassword.getText());
                if (err != null) {
                    JOptionPane.showMessageDialog(this.panel, "Database creation error : " + err);
                    this.lbStatus.setText(err);
                    this.lbStatus.repaint();
                } else {
                    JOptionPane.showMessageDialog(this.panel, "Database creation successfull.");
                    this.lbStatus.setText("Database creation successfull.");
                    this.lbStatus.repaint();
                }
            } else {
                this.lbStatus.setText("Baraza Setup");
            }
        } else if ("Create New".equals(aKey)) {
            this.lbStatus.setText("The process will take a while to complete.");
            int n = JOptionPane.showConfirmDialog(this.panel, "This will delete existing database, are you sure you want to proceed?", "New Database", 0);
            if (n == 0) {
                String err = this.createDB("setup.sql", this.ftUserName.getText(), this.ftPassword.getText());
                if (err != null) {
                    JOptionPane.showMessageDialog(this.panel, "Database creation error : " + err);
                    this.lbStatus.setText(err);
                    this.lbStatus.repaint();
                } else {
                    JOptionPane.showMessageDialog(this.panel, "Database creation successfull.");
                    this.lbStatus.setText("Database creation successfull.");
                    this.lbStatus.repaint();
                }
            } else {
                this.lbStatus.setText("Baraza Setup");
            }
        }
        this.lbStatus.repaint();
    }

    public static void main(String[] args) {
        String path = "projects";
        if (args.length == 1) {
            path = args[0].trim();
            BSetup st = new BSetup(path);
            st.runUISetup();
        } else if (args.length == 2) {
            path = args[0].trim();
            BSetup st = new BSetup(path);
            st.runSetup(args[1].trim());
        } else {
            BSetup st = new BSetup(path);
            st.runUISetup();
        }
    }
}

