/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.ide;

import org.baraza.xml.BElement;
import org.baraza.xml.BXML;

public class BVersions {
    public static void main(String[] args) {
        if (args.length == 1) {
            BVersions bVersions = new BVersions(args[0]);
        } else {
            System.out.println("java -cp ./baraza.jar org.baraza.ide.BVersions <xmlFile>");
        }
    }

    public BVersions(String xmlFile) {
        System.out.println("Baraza Versions - Processing : " + xmlFile);
        BXML xml = new BXML(xmlFile, false);
        BElement root = xml.getRoot();
        this.makeVersion(root);
    }

    public void makeVersion(BElement root) {
        for (BElement el : root.getElements()) {
            System.out.println("Processing : " + el.getAttribute("name"));
            BXML source = new BXML(el.getAttribute("source"), false);
            for (BElement action : el.getElements()) {
                System.out.println(action.getName());
                if (action.getName().equals("REMOVE")) {
                    for (BElement node : action.getElements()) {
                        System.out.println("\t" + node.getName() + " : " + node.getAttribute("name"));
                        this.removeNode(source.getRoot().getElementByName("MENU"), node);
                    }
                    continue;
                }
                if (action.getName().equals("MENUCHANGE")) {
                    for (BElement node : action.getElements()) {
                        System.out.println("\t" + node.getName() + " : " + node.getAttribute("name"));
                        this.replaceMenu(source.getRoot().getElementByName("MENU"), node);
                    }
                    continue;
                }
                if (!action.getName().equals("REPLACE")) continue;
                for (BElement node : action.getElements()) {
                    System.out.println("\t" + node.getName() + " : " + node.getAttribute("name"));
                    this.replaceNode(source.getRoot(), node);
                }
            }
            source.saveFile(el.getAttribute("destination"));
        }
    }

    public void removeNode(BElement nodes, BElement dNodes) {
        for (BElement node : nodes.getElements()) {
            if (dNodes.getValue().trim().equals("")) {
                if (dNodes.getAttribute("name").equals(node.getAttribute("name"))) {
                    nodes.delNode(node);
                    return;
                }
                if (node.isLeaf()) continue;
                this.removeNode(node, dNodes);
                continue;
            }
            if (dNodes.getValue().equals(node.getValue())) {
                nodes.delNode(node);
                return;
            }
            if (node.isLeaf()) continue;
            this.removeNode(node, dNodes);
        }
    }

    public void replaceMenu(BElement nodes, BElement nNodes) {
        for (BElement node : nodes.getElements()) {
            if (nNodes.getValue().trim().equals("")) {
                if (nNodes.getAttribute("name").equals(node.getAttribute("name"))) {
                    nodes.replaceAttribute("name", nNodes.getAttribute("name.new"));
                    if (nNodes.getAttribute("xml") != null) {
                        nodes.replaceAttribute("xml", nNodes.getAttribute("xml"));
                    }
                    return;
                }
                if (node.isLeaf()) continue;
                this.replaceMenu(node, nNodes);
                continue;
            }
            if (nNodes.getValue().equals(node.getValue())) {
                nodes.replaceAttribute("name", nNodes.getAttribute("name.new"));
                if (nNodes.getAttribute("xml") != null) {
                    nodes.replaceAttribute("xml", nNodes.getAttribute("xml"));
                }
                return;
            }
            if (node.isLeaf()) continue;
            this.replaceMenu(node, nNodes);
        }
    }

    public void replaceNode(BElement nodes, BElement newNode) {
        String key = newNode.getAttribute("key", "x");
        int pos = 0;
        for (BElement node : nodes.getElements()) {
            if (node.getAttribute("key", "y").equals(key)) {
                nodes.delNode(pos);
                nodes.addNode(newNode, pos);
                break;
            }
            ++pos;
        }
    }
}

