/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.reports;

import java.awt.Component;
import java.awt.GridLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import org.baraza.DB.BDB;
import org.baraza.reports.BReportViewer;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BReport
extends JPanel {
    Logger log = Logger.getLogger(BReport.class.getName());
    BLogHandle logHandle;
    BReportViewer rp;
    JasperPrint rd;
    boolean iscreated = false;
    boolean ischild = false;
    int linkkey;
    BDB db = null;
    Connection conn;
    String reportname;
    String jasperfile;
    String auditTable;
    String linkField = "filterid";
    int printcopies;
    Map<String, Object> parameters;
    String[] viewFilter = new String[2];

    public BReport(BDB db, String reportpath, String reportfile) {
        super(new GridLayout(1, 0));
        this.db = db;
        this.conn = db.getDB();
        this.jasperfile = reportpath + reportfile;
        this.parameters = new HashMap<String, Object>();
        this.parameters.put("reportpath", reportpath);
        this.parameters.put("SUBREPORT_DIR", reportpath);
        this.parameters.put("orgid", db.getOrgID());
        this.parameters.put("orgwhere", db.getOrgWhere(null));
        this.parameters.put("organd", db.getOrgAnd(null));
        this.parameters.put("entityid", db.getUserID());
        this.parameters.put("entityname", db.getUserName());
        this.viewFilter[0] = null;
        this.viewFilter[1] = null;
        this.printcopies = 1;
    }

    public BReport(BLogHandle logHandle, BDB db, BElement fielddef, String reportpath) {
        super(new GridLayout(1, 0));
        this.db = db;
        this.conn = db.getDB();
        this.jasperfile = reportpath + fielddef.getAttribute("reportfile");
        this.reportname = fielddef.getAttribute("name", "");
        this.auditTable = fielddef.getAttribute("audit");
        this.parameters = new HashMap<String, Object>();
        this.parameters.put("reporttitle", this.reportname);
        this.parameters.put("reportpath", reportpath);
        this.parameters.put("SUBREPORT_DIR", reportpath);
        this.parameters.put("orgid", db.getOrgID());
        this.parameters.put("orgwhere", db.getOrgWhere(fielddef.getAttribute("org.table")));
        this.parameters.put("organd", db.getOrgAnd(fielddef.getAttribute("org.table")));
        this.parameters.put("entityid", db.getUserID());
        this.parameters.put("entityname", db.getUserName());
        this.linkField = fielddef.getAttribute("linkfield", "filterid");
        if (fielddef.getAttribute("user") != null) {
            this.parameters.put(fielddef.getAttribute("user"), db.getUserID());
        }
        this.ischild = false;
        this.linkkey = 0;
        if (!fielddef.getAttribute("linkkey", "").equals("")) {
            this.ischild = true;
            this.linkkey = Integer.valueOf(fielddef.getAttribute("linkkey"));
        }
        this.iscreated = false;
        if (fielddef.getAttribute("filtered", "").equals("true")) {
            this.ischild = true;
        }
        if (fielddef.getAttribute("viewfilter") != null) {
            String[] viewF = fielddef.getAttribute("viewfilter").toLowerCase().split("=");
            if (viewF.length == 2) {
                this.viewFilter[0] = viewF[0];
                this.viewFilter[1] = viewF[1];
            } else {
                this.viewFilter[0] = null;
                this.viewFilter[1] = null;
            }
        } else {
            this.viewFilter[0] = null;
            this.viewFilter[1] = null;
        }
        this.printcopies = Integer.valueOf(fielddef.getAttribute("printcopies", "1"));
    }

    public void showReport() {
        if (!this.ischild) {
            try {
                if (this.jasperfile.startsWith("http")) {
                    URL url = new URL(this.jasperfile);
                    InputStream in = url.openStream();
                    this.rd = JasperFillManager.fillReport((InputStream)in, this.parameters, (Connection)this.conn);
                } else {
                    this.rd = JasperFillManager.fillReport((String)this.jasperfile, this.parameters, (Connection)this.conn);
                }
                String keyData = "";
                if (this.parameters.get("filterid") != null) {
                    keyData = this.parameters.get("filterid").toString();
                }
                if (this.iscreated) {
                    this.rp.loadReport(this.rd, keyData);
                    this.rp.refreshPage();
                } else {
                    this.rp = new BReportViewer(this.rd, this.db, this.auditTable, keyData);
                    super.add((Component)((Object)this.rp));
                    this.iscreated = true;
                }
            }
            catch (JRException ex) {
                this.log.severe("Jasper Compile error : " + (Object)((Object)ex));
            }
            catch (MalformedURLException ex) {
                this.log.severe("HTML Error : " + ex);
            }
            catch (IOException ex) {
                this.log.severe("IO Error : " + ex);
            }
        }
    }

    public boolean printReport(String filtername, String filterid) {
        boolean printed = false;
        this.log.fine("Filter = " + filtername + " key = " + filterid);
        this.parameters.put(filtername, filterid);
        try {
            if (this.jasperfile.startsWith("http")) {
                URL url = new URL(this.jasperfile);
                InputStream in = url.openStream();
                this.rd = JasperFillManager.fillReport((InputStream)in, this.parameters, (Connection)this.conn);
            } else {
                this.rd = JasperFillManager.fillReport((String)this.jasperfile, this.parameters, (Connection)this.conn);
            }
            for (int i = 0; i < this.printcopies; ++i) {
                JasperPrintManager.printReport((JasperPrint)this.rd, (boolean)false);
                if (this.auditTable == null) continue;
                String insSQL = "INSERT INTO " + this.auditTable + "(entity_id, ip_address, link_key) VALUES ('";
                insSQL = insSQL + this.db.getUserID() + "', '" + this.db.getUserIP() + "', '" + this.parameters.get("filterid") + "');";
                this.db.executeQuery(insSQL);
            }
            this.log.fine("Printed : " + filterid);
            printed = true;
        }
        catch (JRException ex) {
            this.log.severe("Jasper Compile error : " + (Object)((Object)ex));
        }
        catch (MalformedURLException ex) {
            this.log.severe("HTML Error : " + ex);
        }
        catch (IOException ex) {
            this.log.severe("IO Error : " + ex);
        }
        return printed;
    }

    public void putLink(String filterId) {
        this.parameters.put(this.linkField, filterId);
        this.log.fine("Filter = " + this.linkField + " key = " + filterId);
    }

    public void putparams(String filterName, String filterId) {
        this.parameters.put(filterName, filterId);
        this.log.fine("Filter = " + filterName + " key = " + filterId);
    }

    public void putparams(Map<String, String> param) {
        this.parameters.putAll(param);
        this.drillReport();
        this.log.fine("Param filter Done Filter.");
    }

    public void drillReport() {
        try {
            if (this.jasperfile.startsWith("http")) {
                URL url = new URL(this.jasperfile);
                InputStream in = url.openStream();
                this.rd = JasperFillManager.fillReport((InputStream)in, this.parameters, (Connection)this.conn);
            } else {
                this.rd = JasperFillManager.fillReport((String)this.jasperfile, this.parameters, (Connection)this.conn);
            }
            String keyData = "";
            if (this.parameters.get("filterid") != null) {
                keyData = this.parameters.get("filterid").toString();
            }
            if (this.iscreated) {
                this.rp.loadReport(this.rd, keyData);
                this.rp.refreshPage();
            } else {
                this.rp = new BReportViewer(this.rd, this.db, this.auditTable, keyData);
                this.add((Component)((Object)this.rp));
                this.rp.setVisible(false);
                this.rp.setVisible(true);
                this.iscreated = true;
            }
        }
        catch (JRException ex) {
            this.log.severe("Jasper Compile error : " + (Object)((Object)ex));
        }
        catch (MalformedURLException ex) {
            this.log.severe("HTML Error : " + ex);
        }
        catch (IOException ex) {
            this.log.severe("IO Error : " + ex);
        }
    }

    public String[] getViewFilter() {
        return this.viewFilter;
    }
}

