/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.reports;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BReportFile {
    Logger log = Logger.getLogger(BReportFile.class.getName());
    int processdelay = 10000;
    String outputPath = "";
    Map<String, Object> parameters;
    BDB db;
    BElement root;

    public BReportFile(BDB db, BLogHandle logHandle) {
        this.db = db;
        logHandle.config(this.log);
        this.outputPath = "./report.pdf";
        this.parameters = new HashMap<String, Object>();
    }

    public BReportFile(BDB db, BElement root, BLogHandle logHandle) {
        this.db = db;
        this.root = root;
        logHandle.config(this.log);
        this.parameters = new HashMap<String, Object>();
        this.parameters.put("reportpath", root.getAttribute("reportpath"));
        this.parameters.put("SUBREPORT_DIR", root.getAttribute("reportpath"));
        this.parameters.put("orgid", db.getOrgID());
        this.processdelay = Integer.valueOf(root.getAttribute("delay", "1")) * 60 * 1000;
    }

    public int getDelay() {
        return this.processdelay;
    }

    public int process() {
        this.log.info("---------- Report Thread Running.");
        for (BElement el : this.root.getElements()) {
            boolean isPdf = true;
            if (el.getAttribute("html", "false").equals("true")) {
                isPdf = false;
            }
            if (el.getName().equals("JASPER")) {
                this.outputPath = this.root.getAttribute("output") + el.getAttribute("output");
                this.parameters.put("orgwhere", this.db.getOrgWhere(el.getAttribute("org.table")));
                this.parameters.put("organd", this.db.getOrgAnd(el.getAttribute("org.table")));
                this.getReport(this.root.getAttribute("reportpath"), el.getAttribute("reportfile"), isPdf);
                continue;
            }
            if (!el.getName().equals("GRID")) continue;
            String where = "(" + el.getAttribute("marker") + " = false)";
            BQuery rs = new BQuery(this.db, el, where, el.getAttribute("keyfield"), false);
            while (rs.moveNext()) {
                for (BElement ell : el.getElements()) {
                    this.parameters.put(ell.getAttribute("filtername", "filterid"), rs.getString(ell.getValue()));
                    this.outputPath = this.root.getAttribute("output") + rs.getString(ell.getValue()) + ".pdf";
                }
                this.getReport(this.root.getAttribute("reportpath"), el.getAttribute("reportfile"), isPdf);
            }
            String mysql = el.getAttribute("psql", "");
            mysql = mysql + "\nUPDATE " + el.getAttribute("table") + " SET " + el.getAttribute("marker") + " = true";
            mysql = mysql + " WHERE " + el.getAttribute("marker") + " = false;";
            this.db.executeQuery(mysql);
        }
        this.log.info("---------- Report Thread Completed.");
        return this.processdelay;
    }

    public void setOutput(String reportOutput) {
        this.outputPath = "./" + reportOutput + ".pdf";
    }

    public boolean getReport(String reportpath, String reportname, String keyfield, Map<String, String> rptParams) {
        this.parameters.put("reportpath", reportpath);
        this.parameters.put("SUBREPORT_DIR", reportpath);
        this.parameters.put("filterid", keyfield);
        this.parameters.put("orgid", this.db.getOrgID());
        this.parameters.put("orgwhere", this.db.getOrgWhere(null));
        this.parameters.put("organd", this.db.getOrgAnd(null));
        for (String rptParam : rptParams.keySet()) {
            this.parameters.put(rptParam, rptParams.get(rptParam));
        }
        return this.getReport(reportpath, reportname, true);
    }

    public boolean getReport(String reportpath, String reportname, boolean isPdf) {
        JasperPrint rd = null;
        boolean gotreport = false;
        try {
            if (reportpath.startsWith("http")) {
                URL url = new URL(reportpath + reportname);
                InputStream in = url.openStream();
                rd = JasperFillManager.fillReport((InputStream)in, this.parameters, (Connection)this.db.getDB());
            } else {
                rd = JasperFillManager.fillReport((String)(reportpath + reportname), this.parameters, (Connection)this.db.getDB());
            }
            if (rd != null) {
                if (isPdf) {
                    JasperExportManager.exportReportToPdfFile((JasperPrint)rd, (String)this.outputPath);
                } else {
                    JasperExportManager.exportReportToHtmlFile((JasperPrint)rd, (String)this.outputPath);
                }
            }
            gotreport = true;
            this.log.info("Report generation - Done");
        }
        catch (JRException ex) {
            System.out.println("Jasper Compile error : " + (Object)((Object)ex) + "\n");
        }
        catch (MalformedURLException ex) {
            System.out.println("HTML Error : " + ex + "\n");
        }
        catch (IOException ex) {
            System.out.println("IO Error : " + ex + "\n");
        }
        return gotreport;
    }

    public void close() {
        this.db.close();
    }
}

