/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.reports;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterConfiguration;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import net.sf.jasperreports.web.util.WebHtmlResourceHandler;
import org.baraza.DB.BDB;
import org.baraza.DB.BUser;
import org.baraza.xml.BElement;

public class BWebReport {
    Logger log = Logger.getLogger(BWebReport.class.getName());
    String name;
    String reportfile;
    String fileName;
    String filterkey;
    String filtervalue;
    String fileSql = null;
    boolean showpdf = false;
    String userid;
    String userfilter;
    String groupid;
    String groupfilter;
    String linkField;
    String orgTable = null;
    Map<String, Object> parameters;

    public BWebReport() {
        this.parameters = new HashMap<String, Object>();
    }

    public BWebReport(BElement view, String userid, String groupid, HttpServletRequest request) {
        this.userid = userid;
        this.groupid = groupid;
        this.parameters = new HashMap<String, Object>();
        this.parameters.put("ReportTitle", this.name);
        this.name = view.getAttribute("name");
        this.reportfile = view.getAttribute("reportfile");
        this.fileName = view.getAttribute("file.name", "report");
        this.fileSql = view.getAttribute("file.sql");
        this.userfilter = view.getAttribute("user", "entityid");
        this.groupfilter = view.getAttribute("group");
        this.filterkey = view.getAttribute("filterkey");
        this.filtervalue = request.getParameter("filtervalue");
        this.orgTable = view.getAttribute("org.table");
        this.linkField = view.getAttribute("linkfield", "filterid");
    }

    public String getReport(BDB db, BUser user, String linkValue, HttpServletRequest request, String reportPath) {
        StringBuffer sbuffer = new StringBuffer();
        try {
            File reportFile = new File(reportPath + this.reportfile);
            if (!reportFile.exists()) {
                System.out.println("Report access error");
                sbuffer.append("REPORT ACCESS ERROR");
                return sbuffer.toString();
            }
            JasperReport jasperReport = (JasperReport)JRLoader.loadObjectFromFile((String)reportFile.getPath());
            HttpSession session = request.getSession(true);
            session.setAttribute("reportfile", (Object)reportFile.getAbsolutePath());
            session.setAttribute("reportname", (Object)this.name);
            this.parameters.put("reportpath", reportFile.getParent() + "/");
            this.parameters.put("SUBREPORT_DIR", reportFile.getParent() + "/");
            this.parameters.put("orgid", db.getOrgID());
            this.parameters.put("orgwhere", user.getOrgWhere(this.orgTable));
            this.parameters.put("organd", user.getOrgAnd(this.orgTable));
            session.setAttribute("userfield", (Object)"");
            session.setAttribute("groupfield", (Object)"");
            if (this.userfilter != null && this.userid != null) {
                this.log.info(this.userfilter + " | " + this.userid);
                this.parameters.put(this.userfilter, this.userid);
                this.parameters.put("entityname", user.getUserName());
                session.setAttribute("userfield", (Object)this.userfilter);
                session.setAttribute("uservalue", (Object)this.userid);
            }
            if (this.groupfilter != null && this.groupid != null) {
                this.parameters.put(this.groupfilter, this.groupid);
                session.setAttribute("groupfield", (Object)this.groupfilter);
                session.setAttribute("groupvalue", (Object)this.groupid);
            }
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.parameters, (Connection)db.getDB());
            session.setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
            int pageIndex = 0;
            int lastPageIndex = 0;
            if (jasperPrint.getPages() != null) {
                lastPageIndex = jasperPrint.getPages().size() - 1;
            }
            if (request.getParameter("page") != null) {
                pageIndex = Integer.parseInt(request.getParameter("page"));
            }
            if (request.getParameter("reportmove") != null) {
                String reportmove = request.getParameter("reportmove");
                if (reportmove.equals("<<")) {
                    pageIndex = 0;
                }
                if (reportmove.equals("<")) {
                    --pageIndex;
                }
                if (reportmove.equals(">")) {
                    ++pageIndex;
                }
                if (reportmove.equals(">>")) {
                    pageIndex = lastPageIndex;
                }
            }
            if (pageIndex < 0) {
                pageIndex = 0;
            }
            if (pageIndex > lastPageIndex) {
                pageIndex = lastPageIndex;
            }
            StringBuffer rbuffer = new StringBuffer();
            HtmlExporter exporterHTML = new HtmlExporter();
            exporterHTML.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
            SimpleHtmlExporterOutput exporterOutput = new SimpleHtmlExporterOutput(rbuffer);
            exporterOutput.setImageHandler((HtmlResourceHandler)new WebHtmlResourceHandler("image?image={0}"));
            exporterHTML.setExporterOutput((ExporterOutput)exporterOutput);
            SimpleHtmlExporterConfiguration exporterConfig = new SimpleHtmlExporterConfiguration();
            exporterConfig.setHtmlHeader("");
            exporterConfig.setHtmlFooter("");
            exporterConfig.setBetweenPagesHtml("");
            exporterHTML.setConfiguration((ExporterConfiguration)exporterConfig);
            SimpleHtmlReportConfiguration reportConfig = new SimpleHtmlReportConfiguration();
            reportConfig.setWhitePageBackground(Boolean.valueOf(false));
            reportConfig.setPageIndex(Integer.valueOf(pageIndex));
            exporterHTML.setConfiguration((ReportExportConfiguration)reportConfig);
            exporterHTML.exportReport();
            sbuffer.append("<div id='reports'>\n");
            sbuffer.append(rbuffer);
            sbuffer.append("\n</div>\n");
            sbuffer.append("<div id='reportfooter'>\n");
            sbuffer.append("<table style='width: 597px; border-collapse: collapse'><tr>\n");
            sbuffer.append("<td width='55'><button class='i_triangle_double_left icon' name='reportmove' type='submit' value='<<'>First</button></td>\n");
            sbuffer.append("<td width='55'><button class='i_triangle_left icon' name='reportmove' type='submit' value='<'>Previous</button></td>\n");
            sbuffer.append("<td width='155'>Page :" + Integer.toString(pageIndex + 1) + " of " + Integer.toString(lastPageIndex + 1) + "</td>\n");
            sbuffer.append("<input name='page' type='hidden' value='" + Integer.toString(pageIndex) + "'/>\n");
            sbuffer.append("<td width='55'><button class='i_triangle_right icon' name='reportmove' type='submit' value='>'>Next</button></td>\n");
            sbuffer.append("<td width='55'><button class='i_triangle_double_right icon' name='reportmove' type='submit' value='>>'>Last</button></td>\n");
            sbuffer.append("<td width='55'><button class='i_excel_document icon' name='excelexport' type='submit' value='excel'>excel</button></td>\n");
            sbuffer.append("<td width='55'><button class='i_pdf_document icon' name='reportexport' type='submit' value='pdf'>pdf</button></td>\n");
            sbuffer.append("</tr><table>");
            sbuffer.append("\n</div>\n");
        }
        catch (JRException ex) {
            System.out.println("Jasper exception : " + (Object)((Object)ex));
        }
        return sbuffer.toString();
    }

    public void getReport(BDB db, BUser user, HttpServletRequest request, HttpServletResponse response, int reportType) {
        try {
            JRPdfExporter exporter;
            HttpSession session = request.getSession(true);
            this.reportfile = (String)session.getAttribute("reportfile");
            this.name = (String)session.getAttribute("reportname");
            File reportFile = new File(this.reportfile);
            if (!reportFile.exists()) {
                this.log.severe("Report access error : " + this.reportfile);
                return;
            }
            JasperReport jasperReport = (JasperReport)JRLoader.loadObjectFromFile((String)reportFile.getPath());
            this.parameters.put("reportpath", reportFile.getParent() + "/");
            this.parameters.put("SUBREPORT_DIR", reportFile.getParent() + "/");
            this.parameters.put("orgid", db.getOrgID());
            this.parameters.put("orgwhere", user.getOrgWhere(this.orgTable));
            this.parameters.put("organd", user.getOrgAnd(this.orgTable));
            this.parameters.put("entityid", user.getUserID());
            this.parameters.put("entityname", user.getUserName());
            this.setParams(session);
            String linkField = (String)session.getAttribute("linkfield");
            String linkValue = (String)session.getAttribute("linkvalue");
            if (linkField != null && linkValue != null) {
                this.parameters.put(linkField, linkValue);
                this.log.info(linkField + " | " + linkValue);
            }
            this.userfilter = (String)session.getAttribute("userfield");
            this.userid = (String)session.getAttribute("uservalue");
            if (this.userfilter != null && this.userid != null) {
                this.parameters.put(this.userfilter, this.userid);
                this.log.info(this.userfilter + " | " + this.userid);
            }
            this.groupfilter = (String)session.getAttribute("groupfield");
            this.groupid = (String)session.getAttribute("groupvalue");
            if (this.groupfilter != null && this.groupid != null) {
                this.parameters.put(this.groupfilter, this.groupid);
            }
            if (this.fileSql != null && this.parameters.size() > 0) {
                this.fileName = db.executeFunction(this.fileSql + this.parameters.get("filterid"));
                if (this.fileName == null) {
                    this.fileName = "report";
                }
                this.fileName = this.fileName.replaceAll(" ", "_");
            }
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.parameters, (Connection)db.getDB());
            if (reportType == 0) {
                response.setCharacterEncoding("ISO-8859-1");
                response.setContentType("application/pdf");
                response.setHeader("Content-Disposition", "attachment; filename=" + this.fileName + ".pdf");
                exporter = new JRPdfExporter();
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)response.getOutputStream()));
                exporter.exportReport();
            }
            if (reportType == 1) {
                response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                response.setHeader("Content-Disposition", "attachment; filename=" + this.fileName + ".xlsx");
                exporter = new JRXlsxExporter();
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)response.getOutputStream()));
                SimpleXlsxReportConfiguration configuration = new SimpleXlsxReportConfiguration();
                configuration.setOnePagePerSheet(Boolean.valueOf(false));
                configuration.setDetectCellType(Boolean.valueOf(true));
                configuration.setCollapseRowSpan(Boolean.valueOf(false));
                exporter.setConfiguration((ReportExportConfiguration)configuration);
                exporter.exportReport();
            }
        }
        catch (JRException ex) {
            this.log.severe("jasper exception " + (Object)((Object)ex));
        }
        catch (IOException ex) {
            this.log.severe("Web Print Writer Error : " + ex);
        }
    }

    public void getDirectReport(BDB db, BUser user, HttpServletRequest request, HttpServletResponse response, String reportPath, String reportName) {
        try {
            this.reportfile = reportPath + reportName;
            File reportFile = new File(this.reportfile);
            if (!reportFile.exists()) {
                this.log.info("Report access error : " + this.reportfile);
                return;
            }
            JasperReport jasperReport = (JasperReport)JRLoader.loadObjectFromFile((String)reportFile.getPath());
            this.parameters.put("reportpath", reportPath);
            this.parameters.put("SUBREPORT_DIR", reportPath);
            this.parameters.put("orgid", db.getOrgID());
            this.parameters.put("orgwhere", user.getOrgWhere(this.orgTable));
            this.parameters.put("organd", user.getOrgAnd(this.orgTable));
            this.parameters.put("entityid", user.getUserID());
            this.parameters.put("entityname", user.getUserName());
            String reportFilters = request.getParameter("reportfilters");
            String[] reportFilter = reportFilters.split(",");
            for (int i = 0; i < reportFilter.length; ++i) {
                String filterValue = request.getParameter(reportFilter[i]);
                this.parameters.put(reportFilter[i], filterValue);
            }
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.parameters, (Connection)db.getDB());
            byte[] pdfdata = JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
            response.setCharacterEncoding("ISO-8859-1");
            response.setContentType("application/pdf");
            response.setHeader("Content-Disposition", "attachment; filename=report.pdf");
            response.setContentLength(pdfdata.length);
            response.getOutputStream().write(pdfdata);
            response.getOutputStream().flush();
        }
        catch (JRException ex) {
            this.log.severe("jasper exception " + (Object)((Object)ex));
        }
        catch (IOException ex) {
            this.log.severe("Web Print Writer Error : " + ex);
        }
    }

    public void setParams(HttpSession session) {
        if (session.getAttribute("reportfilters") != null) {
            List reportFilters = (List)session.getAttribute("reportfilters");
            for (String reportFilter : reportFilters) {
                String filterValue = (String)session.getAttribute(reportFilter);
                this.parameters.put(reportFilter, filterValue);
                this.log.info("Filter = " + reportFilter + " key = " + filterValue);
            }
        }
    }

    public void setParams(String filterName, String filterValue) {
        this.parameters.put(filterName, filterValue);
        this.log.info("Filter = " + filterName + " key = " + filterValue);
    }

    public void setParams(Map<String, String> params) {
        this.parameters.putAll(params);
        this.log.info("Param filter Done Filter.");
    }
}

