/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.baraza.server.BServerThread;
import org.baraza.server.BServerTimed;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;
import org.baraza.xml.BXML;

public class BServer
extends Thread {
    Logger log = Logger.getLogger(BServer.class.getName());
    boolean listening = true;
    String configDir;
    BElement root;
    ServerSocket serverSocket = null;
    List<BServerTimed> stl = null;
    String greeting;
    Integer portNumber;
    BLogHandle logHandle;

    public BServer(String configDir) {
        this.configDir = configDir;
        BXML xml = new BXML(configDir + "config.xml", false);
        this.root = xml.getRoot();
        this.greeting = this.root.getAttribute("greeting");
        this.portNumber = new Integer(this.root.getAttribute("port", "7777"));
        this.logHandle = new BLogHandle(this.root);
        this.logHandle.config(this.log);
        this.stl = new ArrayList<BServerTimed>();
        for (BElement el : this.root.getElements()) {
            if (!el.getName().equals("SERVER") || !el.getAttribute("disable", "false").equals("false")) continue;
            BServerTimed st = new BServerTimed(configDir, el, this.logHandle);
            st.start();
            this.stl.add(st);
        }
        try {
            this.serverSocket = new ServerSocket(this.portNumber);
            this.log.info("Server started");
        }
        catch (IOException e) {
            this.log.severe("Could not listen on port: " + this.portNumber.toString());
        }
    }

    @Override
    public void run() {
        try {
            while (this.listening) {
                Socket socket = this.serverSocket.accept();
                BServerThread sst = new BServerThread(socket, this, this.greeting, this.logHandle);
                sst.start();
                BServer.sleep(100L);
                if (this.listening) continue;
                break;
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (IOException ex) {
            this.log.severe("Could not connect client on port: 7777. : " + ex);
        }
        catch (InterruptedException ex) {
            this.log.severe("Sending sleep error : " + ex);
        }
    }

    public void close() {
        this.listening = false;
        for (BServerTimed st : this.stl) {
            st.close();
        }
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
        }
        catch (IOException ex) {
            this.log.severe("Could not close server on port: 7777. : " + ex);
        }
    }
}

