/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.comm;

import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.utils.BLogHandle;
import org.baraza.utils.BNumberFormat;
import org.baraza.xml.BElement;

public class BComm {
    Logger log = Logger.getLogger(BComm.class.getName());
    BElement node;
    BDB db = null;
    BDB rdb = null;
    boolean newDB = false;
    String orgID = null;

    public BComm(BDB db, BElement node, BLogHandle logHandle) {
        this.node = node;
        this.db = db;
        this.orgID = node.getAttribute("orgid");
        logHandle.config(this.log);
    }

    public void process() {
        this.newDB = false;
        if (this.node.getAttribute("dbpath") == null) {
            this.rdb = this.db;
        } else {
            this.newDB = true;
            this.rdb = new BDB(this.node);
        }
        if (!this.db.isValid()) {
            this.db.reconnect();
        } else if (!this.rdb.isValid()) {
            this.rdb.reconnect();
        } else {
            for (BElement el : this.node.getElements()) {
                if (!el.getName().equals("PROCESS")) continue;
                this.process(el);
            }
        }
        this.close();
    }

    public void process(BElement el) {
        String mysql = el.getAttribute("sql");
        String where = el.getAttribute("where");
        String orderby = el.getAttribute("orderby");
        String update = el.getAttribute("update");
        String errorSQL = el.getAttribute("error");
        if (where != null) {
            mysql = mysql + " WHERE " + where;
        }
        if (orderby != null) {
            mysql = mysql + " ORDER BY " + orderby;
        }
        BQuery rs = new BQuery(this.rdb, mysql);
        while (rs.moveNext()) {
            int sNl;
            String smsNumber = rs.readField(2);
            if (smsNumber == null) {
                smsNumber = "";
            }
            if ((sNl = (smsNumber = smsNumber.replace(" ", "").replace("-", "").replace(",", "").replace("/", "").replace("\\", "").replace("+", "").trim()).length()) == 10 && smsNumber.startsWith("0")) {
                smsNumber = "254" + smsNumber.substring(1, 10);
            }
            BNumberFormat nf = new BNumberFormat();
            nf.getNumber(smsNumber);
            sNl = smsNumber.length();
            String msg = rs.readField(3);
            msg = msg == null ? "" : msg.replace("'", "''");
            System.out.println("BASE 3040 : " + sNl + " : " + nf.getError());
            if (sNl == 12 && nf.getError() == 0 && BNumberFormat.isNumeric(smsNumber)) {
                mysql = "INSERT INTO sms (message_ready, folder_id, org_id, link_id, sms_number, message) VALUES (";
                mysql = mysql + "true, 0, " + this.orgID + ", ";
                mysql = mysql + rs.readField(1) + ", '" + smsNumber + "',  '" + msg + "');";
                this.db.executeQuery(mysql);
                System.out.println("BASE 3050 : " + mysql);
                mysql = update + rs.readField(1);
                this.rdb.executeQuery(mysql);
                System.out.println("BASE 3070 : " + mysql);
                continue;
            }
            mysql = errorSQL + rs.readField(1);
            this.rdb.executeQuery(mysql);
            System.out.println("BASE 4070 : SMS Import error : " + smsNumber);
        }
        rs.close();
    }

    public void close() {
        if (this.newDB) {
            this.rdb.close();
            this.rdb = null;
        }
    }
}

