/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.data;

import java.util.logging.Logger;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BData {
    Logger log = Logger.getLogger(BData.class.getName());
    BDB db;
    BDB rdb = null;
    BElement root;
    boolean executing = false;
    boolean runserver = true;
    int processdelay = 10000;

    public BData(BDB db, BElement root, BLogHandle logHandle) {
        this.db = db;
        this.root = root;
        logHandle.config(this.log);
        this.processdelay = Integer.valueOf(root.getAttribute("processdelay", "1")) * 60 * 1000;
        this.rdb = new BDB(root);
        this.rdb.logConfig(logHandle);
    }

    public int process() {
        this.log.info("---------- Transfer Thread Started");
        this.executing = true;
        System.out.println("BASE is valid : " + this.rdb.isValid());
        if (!this.db.isValid()) {
            this.db.reconnect();
        } else if (!this.rdb.isValid()) {
            this.rdb.reconnect();
        } else {
            for (BElement el : this.root.getElements()) {
                if (el.getName().equals("EXPORT")) {
                    this.process(el);
                    continue;
                }
                if (!el.getName().equals("FUNCTION")) continue;
                this.function(el);
            }
        }
        this.log.info("---------- Transfer Thread completed");
        this.executing = false;
        return this.processdelay;
    }

    public void process(BElement el) {
        BElement rel = el.getElementByName("INTO");
        String where = el.getAttribute("marker");
        BQuery rs = new BQuery(this.db, el, where, el.getAttribute("keyfield"));
        BQuery rrs = new BQuery(this.rdb, rel, null, null);
        rrs.importData(rs.getData());
        rs.beforeFirst();
        while (rs.moveNext()) {
            String update = el.getAttribute("update");
            if (update == null) {
                update = el.getAttribute("table");
            }
            String mysql = el.getAttribute("psql", "");
            mysql = mysql + "\nUPDATE " + update + " SET " + el.getAttribute("marked");
            mysql = mysql + " WHERE (" + el.getAttribute("marker") + ") AND (";
            mysql = mysql + rs.getKeyFieldName() + " = '" + rs.getKeyField() + "');";
            this.db.executeQuery(mysql);
        }
        rs.close();
        rrs.close();
    }

    public void function(BElement el) {
        String rsql;
        String lsql = el.getAttribute("lsql");
        if (lsql != null) {
            this.db.executeQuery(lsql);
        }
        if ((rsql = el.getAttribute("rsql")) != null) {
            this.rdb.executeQuery(rsql);
        }
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public void close() {
        this.db.close();
        this.rdb.close();
    }
}

