/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.mail;

import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPAddressSucceededException;
import com.sun.mail.smtp.SMTPSendFailedException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.baraza.utils.BLogHandle;
import org.baraza.xml.BElement;

public class BMail {
    Logger log = Logger.getLogger(BMail.class.getName());
    Session session = null;
    Store store = null;
    Transport trans = null;
    private boolean mailActive = false;
    private String mailFrom = null;
    private String sentbox = null;
    private String inbox = null;
    private String attachFile = null;
    private String attachDir = null;
    private boolean saveAttachments = false;
    private int attnum = 1;

    public BMail(BElement root, BLogHandle logHandle) {
        logHandle.config(this.log);
        String mailuser = root.getAttribute("mailuser", "");
        String mailpassword = root.getAttribute("mailpassword", "");
        String host = root.getAttribute("host", "");
        String imaphost = root.getAttribute("imaphost", host);
        int imapPort = 143;
        String maildomain = root.getAttribute("maildomain");
        if (maildomain != null) {
            mailuser = mailuser + "@" + maildomain;
        }
        this.mailFrom = root.getAttribute("mailfrom", "root");
        this.inbox = root.getAttribute("inbox", "INBOX");
        this.sentbox = root.getAttribute("sentbox", "Sent");
        String smtppauth = root.getAttribute("smtpauth", "false");
        smtppauth = root.getAttribute("smtppauth", smtppauth);
        smtppauth = root.getAttribute("smtp.auth", smtppauth);
        String smtptls = root.getAttribute("smtptls", "false");
        String ntlm = root.getAttribute("ntlm", "false");
        String imapssl = root.getAttribute("imapssl", "false");
        String smtpPort = root.getAttribute("smtp.port");
        String googleAuth = root.getAttribute("googleauth", "false");
        String imapType = "imap";
        try {
            String mPassword;
            String mUser;
            Properties props = System.getProperties();
            props.setProperty("mail.smtp.host", host);
            props.setProperty("mail.smtp.connectiontimeout", "15000");
            props.setProperty("mail.smtp.timeout", "15000");
            props.setProperty("mail.smtp.writetimeout", "15000");
            if (ntlm.equals("true")) {
                props.setProperty("mail.imap.auth.plain.disable", "true");
                props.setProperty("mail.imap.auth.ntlm.disable", "true");
                props.setProperty("mail.imaps.auth.ntlm.domain", "true");
            } else {
                System.clearProperty("mail.imap.auth.plain.disable");
                System.clearProperty("mail.imap.auth.ntlm.disable");
                System.clearProperty("mail.imaps.auth.ntlm.domain");
            }
            if (smtptls.equals("true")) {
                props.put("mail.smtp.auth", "true");
                props.put("mail.smtp.starttls.enable", "true");
                props.put("mail.smtp.port", "587");
                mUser = mailuser;
                mPassword = mailpassword;
                this.session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(mUser, mPassword);
                    }
                });
            } else {
                props.setProperty("mail.transport.protocol", "smtp");
                System.clearProperty("mail.smtp.starttls.enable");
                System.clearProperty("mail.smtp.auth");
                System.clearProperty("mail.smtp.port");
                System.clearProperty("mail.smtp.ssl.socketFactory");
            }
            if (imapssl.equals("true")) {
                props.setProperty("mail.store.protocol", "imaps");
                props.setProperty("mail.imap.host", host);
                props.setProperty("mail.imap.port", "993");
                props.setProperty("mail.imap.connectiontimeout", "15000");
                props.setProperty("mail.imap.timeout", "15000");
                props.setProperty("mail.imap.writetimeout", "15000");
                props.setProperty("mail.imaps.ssl.socketFactory", "javax.net.ssl.SSLSocketFactory");
                props.setProperty("mail.imap.auth.plain.disable", "true");
                props.setProperty("mail.imap.starttls.enable", "true");
                imapType = "imaps";
                imapPort = 993;
            } else {
                props.setProperty("mail.store.protocol", "imap");
                props.setProperty("mail.imap.host", host);
                props.setProperty("mail.imap.port", "143");
                props.setProperty("mail.imap.connectiontimeout", "15000");
                props.setProperty("mail.imap.timeout", "15000");
                props.setProperty("mail.imap.writetimeout", "15000");
                System.clearProperty("mail.imap.auth.plain.disable");
                System.clearProperty("mail.imap.starttls.enable");
                System.clearProperty("ssl.SocketFactory.provider");
                System.clearProperty("mail.imap.socketFactory.class");
            }
            if (smtpPort != null) {
                props.setProperty("mail.smtp.port", smtpPort);
            }
            if (googleAuth.equals("true")) {
                mUser = mailuser;
                mPassword = mailpassword;
                this.session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(mUser, mPassword);
                    }
                });
            } else {
                this.session = Session.getInstance((Properties)props, null);
            }
            this.session.setDebug(false);
            this.store = this.session.getStore(imapType);
            this.store.connect(imaphost, imapPort, mailuser, mailpassword);
            if (smtppauth.equals("true")) {
                props.setProperty("mail.smtp.auth", "true");
                this.trans = this.session.getTransport("smtp");
                this.trans.connect(host, mailuser, mailpassword);
            } else if (smtptls.equals("true")) {
                this.trans = this.session.getTransport();
                this.trans.connect(host, mailuser, mailpassword);
            } else {
                System.clearProperty("mail.smtp.auth");
                this.trans = this.session.getTransport("smtp");
                this.trans.connect();
            }
            this.mailActive = true;
        }
        catch (Exception ex) {
            this.mailActive = false;
            this.log.severe("Mail User " + mailuser);
            this.log.severe("Mail exception! " + ex);
        }
    }

    public void setAttachFile(String fileDir, String fileName) {
        this.attachDir = fileDir;
        this.attachFile = fileName;
    }

    public boolean sendMail(String messageTo, String ccTo, String replyTo, String subject, String myMail, boolean infile, Map<String, String> headers, Map<String, String> reports, Map<String, String> files) {
        boolean sent = false;
        if (messageTo == null) {
            this.log.severe("The email has no recepient address");
            return true;
        }
        if (messageTo.equals("null")) {
            this.log.severe("The email has no recepient address");
            return true;
        }
        try {
            Object fromAddress;
            MimeMessage message = new MimeMessage(this.session);
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart eheader = new MimeBodyPart();
            eheader.setContent((Object)myMail, "text/html");
            mp.addBodyPart((BodyPart)eheader);
            if (infile) {
                MimeBodyPart attachreport = new MimeBodyPart();
                if (this.attachFile == null) {
                    this.attachFile = "report.pdf";
                }
                if (this.attachDir == null) {
                    this.attachDir = "./";
                }
                attachreport.attachFile(this.attachDir + this.attachFile);
                attachreport.setFileName(this.attachFile);
                mp.addBodyPart((BodyPart)attachreport);
            }
            for (String report : reports.keySet()) {
                MimeBodyPart attachreport = new MimeBodyPart();
                this.attachFile = report + ".pdf";
                if (this.attachDir == null) {
                    this.attachDir = "./";
                }
                attachreport.attachFile(this.attachDir + this.attachFile);
                attachreport.setFileName(this.attachFile);
                mp.addBodyPart((BodyPart)attachreport);
            }
            for (String file : files.keySet()) {
                MimeBodyPart attachment = new MimeBodyPart();
                String fileName = files.get(file);
                attachment.attachFile(fileName);
                attachment.setFileName(file);
                mp.addBodyPart((BodyPart)attachment);
            }
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)messageTo, (boolean)false));
            if (ccTo != null) {
                message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)ccTo, (boolean)false));
            }
            if (replyTo == null) {
                fromAddress = new InternetAddress(this.mailFrom);
                message.setFrom((Address)fromAddress);
            } else {
                fromAddress = new InternetAddress(replyTo);
                message.setFrom((Address)fromAddress);
                message.setReplyTo((Address[])InternetAddress.parse((String)replyTo, (boolean)false));
            }
            message.setSubject(subject);
            message.setContent((Multipart)mp);
            message.setHeader("X-Mailer", "Baraza Java Mailer");
            for (String key : headers.keySet()) {
                message.setHeader(key, headers.get(key));
            }
            message.setSentDate(new Date());
            this.log.fine("Sending Message to : " + messageTo);
            this.trans.sendMessage((Message)message, message.getAllRecipients());
            Folder folder = this.store.getFolder(this.sentbox);
            if (folder == null) {
                this.log.severe("Can't get record folder.");
                return false;
            }
            if (!folder.exists()) {
                folder.create(1);
            }
            Message[] messages = new Message[]{message};
            folder.appendMessages(messages);
            this.log.fine("Mail was recorded successfully.");
            sent = true;
        }
        catch (Exception ex) {
            this.mailActive = false;
            if (ex instanceof SendFailedException) {
                MessagingException sfe = (MessagingException)ex;
                if (sfe instanceof SMTPSendFailedException) {
                    SMTPSendFailedException ssfe = (SMTPSendFailedException)sfe;
                    String errMsg = "SMTP SEND FAILED : " + ssfe.toString();
                    errMsg = errMsg + "\n  Command: " + ssfe.getCommand();
                    errMsg = errMsg + "\n  RetCode: " + ssfe.getReturnCode();
                    errMsg = errMsg + "\n  Response: " + ssfe.getMessage();
                    this.log.severe(errMsg);
                } else {
                    this.log.severe("Send failed: " + sfe.toString());
                }
                Exception ne = sfe.getNextException();
                if (ne != null && ne instanceof MessagingException) {
                    SMTPAddressFailedException ssfe;
                    sfe = (MessagingException)ne;
                    if (sfe instanceof SMTPAddressFailedException) {
                        ssfe = (SMTPAddressFailedException)sfe;
                        String errMsg = "ADDRESS FAILED : " + ssfe.toString();
                        errMsg = errMsg + "\n  Address: " + ssfe.getAddress();
                        errMsg = errMsg + "\n  Command: " + ssfe.getCommand();
                        errMsg = errMsg + "\n  RetCode: " + ssfe.getReturnCode();
                        errMsg = errMsg + "\n  Response: " + ssfe.getMessage();
                        this.log.severe(errMsg);
                    } else if (sfe instanceof SMTPAddressSucceededException) {
                        ssfe = (SMTPAddressSucceededException)sfe;
                        String errMsg = "ADDRESS SUCCEEDED : " + ssfe.toString();
                        errMsg = errMsg + "\n  Address: " + ssfe.getAddress();
                        errMsg = errMsg + "\n  Command: " + ssfe.getCommand();
                        errMsg = errMsg + "\n  RetCode: " + ssfe.getReturnCode();
                        errMsg = errMsg + "\n  Response: " + ssfe.getMessage();
                        this.log.fine(errMsg);
                    }
                }
            }
            this.log.severe("Got Exception: " + ex);
        }
        return sent;
    }

    public boolean getmail(boolean readmail) {
        return this.getmail(this.inbox, readmail);
    }

    public boolean getmail(String mailbox, boolean readmail) {
        boolean mailstatus;
        block5: {
            mailstatus = false;
            try {
                Folder folder = this.store.getDefaultFolder();
                if (folder == null) break block5;
                folder = folder.getFolder(mailbox);
                try {
                    folder.open(2);
                }
                catch (MessagingException ex) {
                    folder.open(1);
                }
                int totalMessages = folder.getMessageCount();
                int newMessages = folder.getNewMessageCount();
                mailstatus = true;
                if (readmail) {
                    this.readmail(folder);
                }
                folder.close(false);
            }
            catch (Exception ex) {
                this.mailActive = false;
                this.log.severe("Oops, got mail exception! " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return mailstatus;
    }

    public void readmail(Folder folder) {
        try {
            Message[] msgs = folder.getMessages();
            FetchProfile fp = new FetchProfile();
            fp.add(FetchProfile.Item.ENVELOPE);
            fp.add(FetchProfile.Item.FLAGS);
            fp.add("X-Mailer");
            folder.fetch(msgs, fp);
            for (int i = 0; i < msgs.length; ++i) {
                this.log.info("MESSAGE #" + (i + 1) + ":");
                this.dumpEnvelope(msgs[i]);
                this.dumpPart((Part)msgs[i]);
            }
        }
        catch (Exception ex) {
            this.mailActive = false;
            this.log.severe("Oops, got mail exception! " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void dumpEnvelope(Message m) {
        try {
            int j;
            this.log.info("This is the message envelope");
            Address[] a = m.getFrom();
            if (a != null) {
                for (j = 0; j < a.length; ++j) {
                    System.out.println("FROM: " + a[j].toString());
                }
            }
            if ((a = m.getRecipients(Message.RecipientType.TO)) != null) {
                for (j = 0; j < a.length; ++j) {
                    System.out.println("TO: " + a[j].toString());
                    InternetAddress ia = (InternetAddress)a[j];
                    if (!ia.isGroup()) continue;
                    InternetAddress[] aa = ia.getGroup(false);
                    for (int k = 0; k < aa.length; ++k) {
                        System.out.println("  GROUP: " + aa[k].toString());
                    }
                }
            }
            System.out.println("SUBJECT: " + m.getSubject());
            Date d = m.getSentDate();
            if (d != null) {
                System.out.println("SendDate: " + d.toString());
            }
            Flags flags = m.getFlags();
            StringBuffer sb = new StringBuffer();
            Flags.Flag[] sf = flags.getSystemFlags();
            boolean first = true;
            for (int i = 0; i < sf.length; ++i) {
                String s;
                Flags.Flag f = sf[i];
                if (f == Flags.Flag.ANSWERED) {
                    s = "\\Answered";
                } else if (f == Flags.Flag.DELETED) {
                    s = "\\Deleted";
                } else if (f == Flags.Flag.DRAFT) {
                    s = "\\Draft";
                } else if (f == Flags.Flag.FLAGGED) {
                    s = "\\Flagged";
                } else if (f == Flags.Flag.RECENT) {
                    s = "\\Recent";
                } else {
                    if (f != Flags.Flag.SEEN) continue;
                    s = "\\Seen";
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
                sb.append(s);
            }
            String[] uf = flags.getUserFlags();
            for (int i = 0; i < uf.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
                sb.append(uf[i]);
            }
            System.out.println("FLAGS: " + sb.toString());
            String[] hdrs = m.getHeader("X-Mailer");
            if (hdrs != null) {
                System.out.println("X-Mailer: " + hdrs[0]);
            } else {
                System.out.println("X-Mailer NOT available");
            }
        }
        catch (MessagingException ex) {
            this.mailActive = false;
            System.out.println("Message reading error " + (Object)((Object)ex));
        }
    }

    public void dumpPart(Part p) {
        block25: {
            try {
                String disp;
                if (p instanceof Message) {
                    this.dumpEnvelope((Message)p);
                }
                String ct = p.getContentType();
                try {
                    System.out.println("CONTENT-TYPE: " + new ContentType(ct).toString());
                }
                catch (ParseException pex) {
                    System.out.println("BAD CONTENT-TYPE: " + ct);
                }
                String filename = p.getFileName();
                if (filename != null) {
                    System.out.println("FILENAME: " + filename);
                }
                if (p.isMimeType("text/plain")) {
                    System.out.println("This is plain text");
                    System.out.println("---------------------------");
                    if (!this.saveAttachments) {
                        System.out.println((String)p.getContent());
                    }
                } else if (p.isMimeType("multipart/*")) {
                    System.out.println("This is a Multipart");
                    System.out.println("---------------------------");
                    Multipart mp = (Multipart)p.getContent();
                    int count = mp.getCount();
                    for (int i = 0; i < count; ++i) {
                        this.dumpPart((Part)mp.getBodyPart(i));
                    }
                } else if (p.isMimeType("message/rfc822")) {
                    System.out.println("This is a Nested Message");
                    System.out.println("---------------------------");
                    this.dumpPart((Part)p.getContent());
                } else if (this.saveAttachments) {
                    Object o = p.getContent();
                    if (o instanceof String) {
                        System.out.println("This is a string");
                        System.out.println("---------------------------");
                        System.out.println((String)o);
                    } else if (o instanceof InputStream) {
                        int c;
                        System.out.println("This is just an input stream");
                        System.out.println("---------------------------");
                        InputStream is = (InputStream)o;
                        while ((c = is.read()) != -1) {
                            System.out.write(c);
                        }
                    } else {
                        System.out.println("This is an unknown type");
                        System.out.println("---------------------------");
                        System.out.println(o.toString());
                    }
                } else {
                    System.out.println("---------------------------");
                }
                if (!this.saveAttachments || p.isMimeType("multipart/*") || (disp = p.getDisposition()) != null && !disp.equalsIgnoreCase("attachment")) break block25;
                if (filename == null) {
                    filename = "Attachment" + this.attnum++;
                }
                System.out.println("Saving attachment to file " + filename);
                try {
                    File f = new File(filename);
                    if (f.exists()) {
                        throw new IOException("file exists");
                    }
                    ((MimeBodyPart)p).saveFile(f);
                }
                catch (IOException ex) {
                    System.out.println("Failed to save attachment: " + ex);
                }
                System.out.println("---------------------------");
            }
            catch (Exception ex) {
                this.mailActive = false;
                System.out.println("Read message error " + ex);
            }
        }
    }

    public boolean getActive() {
        return this.mailActive;
    }

    public void close() {
        try {
            if (this.trans != null) {
                this.trans.close();
            }
            if (this.store != null) {
                this.store.close();
            }
            this.mailActive = false;
        }
        catch (MessagingException ex) {
            this.log.severe("Mail System closing error : " + (Object)((Object)ex));
        }
    }
}

