/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.sms;

import gnu.io.CommPortIdentifier;
import gnu.io.CommPortOwnershipListener;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.baraza.utils.BLogHandle;

public class BSMSConnection
implements CommPortOwnershipListener {
    Logger log = Logger.getLogger(BSMSConnection.class.getName());
    SerialPort port = null;

    public BSMSConnection(String wantedPortName, String datarate, BLogHandle logHandle) throws IOException, RuntimeException, Exception {
        logHandle.config(this.log);
        Enumeration portIdentifiers = CommPortIdentifier.getPortIdentifiers();
        CommPortIdentifier portId = null;
        while (portIdentifiers.hasMoreElements()) {
            CommPortIdentifier pid;
            CommPortIdentifier cpid = (CommPortIdentifier)portIdentifiers.nextElement();
            if (!cpid.getName().equals(wantedPortName) || (pid = CommPortIdentifier.getPortIdentifier((String)wantedPortName)).getPortType() != 1) continue;
            portId = pid;
            this.log.info("Connected : " + pid.getName());
        }
        if (portId != null) {
            int rd = Integer.valueOf(datarate);
            try {
                this.port = (SerialPort)portId.open(this.getClass().getName(), 100);
                this.port.setSerialPortParams(rd, 8, 1, 0);
            }
            catch (PortInUseException ex) {
                this.log.severe("Port already in use : " + (Object)((Object)ex));
            }
            catch (UnsupportedCommOperationException ex) {
                this.log.severe("Port error: " + (Object)((Object)ex));
            }
        } else {
            this.log.info("Could not find serial port " + wantedPortName);
        }
    }

    public SerialPort getPort() {
        return this.port;
    }

    public void close() {
        this.sleep(2000);
        if (this.port != null) {
            this.port.close();
        }
        this.sleep(2000);
    }

    public void sleep(int st) {
        try {
            Thread.sleep(st);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ownershipChange(int type) {
        if (type == 3) {
            this.log.info("PORT_OWNERSHIP_REQUESTED received : Your port has been requested by an other application...");
        } else if (type == 1) {
            this.log.info("PORT_OWNED received!");
        } else if (type == 2) {
            this.log.info("PORT_UNOWNED received!");
        }
    }
}

