/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.server.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.baraza.server.ssh.BUserInfo;

public class Bssh {
    Logger log = Logger.getLogger(Bssh.class.getName());

    public Bssh(String shost, String sftp, String suser, String spasswd, String lfile) {
        try {
            int len;
            JSch jsch = new JSch();
            jsch.setKnownHosts(shost);
            Session session = jsch.getSession(suser, sftp, 22);
            BUserInfo ui = new BUserInfo();
            ui.setPassword(spasswd);
            session.setUserInfo((UserInfo)ui);
            session.connect();
            FileInputStream fis = null;
            String command = "scp -p -t " + lfile;
            Channel channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            OutputStream out = channel.getOutputStream();
            InputStream in = channel.getInputStream();
            channel.connect();
            if (this.checkAck(in) != 0) {
                System.exit(0);
            }
            long filesize = new File(lfile).length();
            command = "C0644 " + filesize + " ";
            command = lfile.lastIndexOf(47) > 0 ? command + lfile.substring(lfile.lastIndexOf(47) + 1) : command + lfile;
            command = command + "\n";
            out.write(command.getBytes());
            out.flush();
            if (this.checkAck(in) != 0) {
                System.exit(0);
            }
            fis = new FileInputStream(lfile);
            byte[] buf = new byte[1024];
            while ((len = fis.read(buf, 0, buf.length)) > 0) {
                out.write(buf, 0, len);
            }
            fis.close();
            fis = null;
            buf[0] = 0;
            out.write(buf, 0, 1);
            out.flush();
            if (this.checkAck(in) != 0) {
                System.exit(0);
            }
            out.close();
            channel.disconnect();
            session.disconnect();
        }
        catch (JSchException ex) {
            this.log.severe("Session Error : " + (Object)((Object)ex));
        }
        catch (IOException ex) {
            this.log.severe("IO Error : " + ex);
        }
    }

    int checkAck(InputStream in) {
        int b = 1;
        try {
            b = in.read();
            if (b == 0) {
                return b;
            }
            if (b == -1) {
                return b;
            }
            if (b == 1 || b == 2) {
                int c;
                StringBuffer sb = new StringBuffer();
                do {
                    c = in.read();
                    sb.append((char)c);
                } while (c != 10);
                if (b == 1) {
                    this.log.severe(sb.toString());
                }
                if (b == 2) {
                    this.log.severe(sb.toString());
                }
            }
        }
        catch (IOException ex) {
            this.log.severe("IO Error : " + ex);
        }
        return b;
    }
}

