/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.utils;

import java.text.DecimalFormat;
import java.text.ParseException;

public class BAmountInWords {
    static final String[] units = new String[]{"", "One ", "Two ", "Three ", "Four ", "Five ", "Six ", "Seven ", "Eight ", "Nine ", "Ten ", "Eleven ", "Twelve ", "Thirteen ", "Fourteen ", "Fifteen ", "Sixteen ", "Seventeen ", "Eighteen ", "Nineteen "};
    static final String[] tens = new String[]{"", "Ten ", "Twenty ", "Thirty ", "Forty ", "Fifty ", "Sixty ", "Seventy ", "Eighty ", "Ninety "};

    public static String convertCurrency(Float amount, String main, String part) {
        int cba = amount.intValue();
        String resp = BAmountInWords.convert(cba) + " " + main;
        Float bal = Float.valueOf((amount.floatValue() - (float)cba) * 100.0f);
        if (bal.floatValue() > 1.0f) {
            int cbc = bal.intValue();
            resp = resp + " and " + BAmountInWords.convert(cbc) + " " + part;
        }
        return resp;
    }

    public static String convert(String amount) {
        String words = "";
        try {
            DecimalFormat df = new DecimalFormat();
            Number d = df.parse(amount);
            words = BAmountInWords.convert(d.intValue());
        }
        catch (NumberFormatException ex) {
            System.out.println("Number error : " + ex);
        }
        catch (ParseException ex) {
            System.out.println("Amount Conversion error : " + ex);
        }
        return words;
    }

    public static String convert(int amount) {
        int thousands;
        String words = "";
        int millions = amount / 1000000;
        String tword = BAmountInWords.threeDigits(millions);
        if (tword.length() > 1) {
            words = tword + "Million ";
        }
        if ((tword = BAmountInWords.threeDigits(thousands = (amount -= millions * 1000000) / 1000)).length() > 1) {
            words = words + tword + "Thousand ";
        }
        words = words + BAmountInWords.threeDigits(amount -= thousands * 1000);
        return words;
    }

    public static String threeDigits(int digits) {
        int ten;
        String digWord = "";
        int hnd = digits / 100;
        if (hnd > 0) {
            digWord = digWord + units[hnd] + "Hundred ";
        }
        if ((ten = digits - hnd * 100) < 20) {
            digWord = digWord + units[ten];
        } else {
            int tenth = ten / 10;
            digWord = digWord + tens[tenth];
            int last = ten - tenth * 10;
            digWord = digWord + units[last];
        }
        return digWord;
    }
}

