/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.baraza.DB.BDB;
import org.baraza.DB.BQuery;
import org.baraza.DB.BUser;
import org.baraza.reports.BWebReport;
import org.baraza.utils.BWebUtils;
import org.baraza.xml.BElement;
import org.json.JSONArray;
import org.json.JSONObject;

public class BDataOps {
    Logger log = Logger.getLogger(BDataOps.class.getName());
    BElement root = null;
    BElement menuXml = null;
    BDB db = null;
    Map<String, BUser> users = new HashMap<String, BUser>();

    public BDataOps(BElement root, BDB db) {
        this.db = db;
        this.root = root;
        this.menuXml = root.getFirst();
    }

    public JSONObject authenticate(HttpServletRequest request) {
        JSONObject jResp = new JSONObject();
        String authUser = request.getHeader("authuser");
        String authPass = request.getHeader("authpass");
        if (authUser == null || authPass == null) {
            jResp.put("ResultCode", 1);
            jResp.put("ResultDesc", (Object)"Wrong username or password");
            return jResp;
        }
        authUser = new String(Base64.getDecoder().decode(authUser));
        authPass = new String(Base64.getDecoder().decode(authPass));
        String authFunction = this.root.getAttribute("authentication", "password_validate");
        String userId = this.db.executeFunction("SELECT " + authFunction + "('" + authUser + "', '" + authPass + "')");
        if (userId == null) {
            userId = "-1";
        }
        System.out.println("BASE 2010 : " + authUser + " : " + authPass + " : " + userId);
        if (userId.equals("-1")) {
            jResp.put("ResultCode", 1);
            jResp.put("ResultDesc", (Object)"Wrong username or password");
        } else {
            String token = BWebUtils.createToken(userId);
            System.out.println("BASE 3010 : " + token);
            this.users.put(userId, new BUser(this.db, request.getRemoteAddr(), authUser, userId));
            jResp.put("ResultCode", 0);
            jResp.put("access_token", (Object)token);
            jResp.put("expires_in", (Object)"15");
        }
        return jResp;
    }

    public JSONObject reAuthenticate(String token) {
        JSONObject jResp = new JSONObject();
        String userId = BWebUtils.decodeToken(token);
        System.out.println("BASE 3030 : " + userId);
        if (userId == null) {
            jResp.put("ResultCode", 1);
            jResp.put("access_error", (Object)"Wrong token");
        } else {
            jResp.put("ResultCode", 0);
            jResp.put("userId", (Object)userId);
        }
        return jResp;
    }

    public JSONObject unsecuredData(HttpServletRequest request) {
        JSONObject jResp = new JSONObject();
        String body = BWebUtils.requestBody(request);
        JSONObject jParams = new JSONObject(body);
        String viewKey = request.getParameter("view");
        BElement view = this.getView(viewKey);
        if (!view.getName().equals("FORM")) {
            jResp.put("ResultCode", 2);
            jResp.put("ResultDesc", (Object)"Wrong object");
            return jResp;
        }
        String linkData = request.getParameter("linkdata");
        if (view.getAttribute("secured", "true").equals("false")) {
            String saveMsg = this.postData(view, request.getRemoteAddr(), jParams, null, null, linkData);
            if (saveMsg.equals("")) {
                jResp.put("ResultCode", 0);
                jResp.put("ResultDesc", (Object)"Data posted");
            } else {
                jResp.put("ResultCode", 2);
                jResp.put("ResultDesc", (Object)saveMsg);
            }
        } else {
            jResp.put("ResultCode", 1);
            jResp.put("ResultDesc", (Object)"Security issue");
        }
        return jResp;
    }

    public JSONObject getUForm(HttpServletRequest request) {
        System.out.println("BASE 5010 : Start form");
        JSONObject jResp = new JSONObject();
        String viewKey = request.getParameter("view");
        BElement view = this.getView(viewKey);
        if (!view.getName().equals("FORM")) {
            jResp.put("ResultCode", 2);
            jResp.put("ResultDesc", (Object)"Wrong object");
            return jResp;
        }
        if (view.getAttribute("secured", "true").equals("false")) {
            jResp = this.getForm(request, null);
        } else {
            jResp.put("ResultCode", 1);
            jResp.put("ResultDesc", (Object)"Security issue");
        }
        return jResp;
    }

    public JSONObject getMenu(HttpServletRequest request, String userId) {
        JSONObject jResp = new JSONObject();
        BUser user = null;
        if (userId != null) {
            user = this.users.get(userId);
        }
        JSONArray jTable = new JSONArray();
        for (BElement el : this.menuXml.getElements()) {
            Integer mKey = new Integer(el.getValue());
            boolean hasAccess = user.checkAccess(el.getAttribute("role"), el.getAttribute("access"));
            if (!hasAccess) continue;
            JSONObject jField = new JSONObject();
            jField.put("key", (Object)mKey);
            jField.put("name", (Object)el.getAttribute("name"));
            if (el.getAttribute("dashboard") != null) {
                jField.put("dashboard", (Object)el.getAttribute("dashboard"));
            }
            jTable.put((Object)jField);
        }
        jResp.put("menu", (Object)jTable);
        return jResp;
    }

    public JSONObject getView(HttpServletRequest request, String userId) {
        JSONObject jResp = new JSONObject();
        BUser user = null;
        if (userId != null) {
            user = this.users.get(userId);
        }
        String viewKey = request.getParameter("view");
        BElement view = this.getView(viewKey);
        jResp.put("type", (Object)view.getName());
        jResp.put("typeId", BWebUtils.getViewType(view.getName()));
        jResp.put("name", (Object)view.getAttribute("name"));
        return jResp;
    }

    public JSONObject getForm(HttpServletRequest request, String userId) {
        JSONObject jResp = new JSONObject();
        JSONArray jTable = new JSONArray();
        String linkData = request.getParameter("linkdata");
        String viewKey = request.getParameter("view");
        BElement view = this.getView(viewKey);
        BUser user = null;
        if (userId != null) {
            user = this.users.get(userId);
        }
        if (!view.getName().equals("FORM")) {
            return jResp;
        }
        for (BElement el : view.getElements()) {
            if (!BWebUtils.canDisplayField(el.getName())) continue;
            int fieldType = BWebUtils.getFieldType(el.getName());
            JSONObject jField = new JSONObject();
            jField.put("type", fieldType);
            jField.put("name", (Object)el.getValue());
            if (el.getAttribute("title") != null) {
                jField.put("title", (Object)el.getAttribute("title"));
            }
            if (el.getAttribute("tab") != null) {
                jField.put("tab", (Object)el.getAttribute("tab"));
            }
            if (el.getName().equals("COMBOBOX")) {
                String comboboxSQL = BWebUtils.comboboxSQL(el, user, this.db.getOrgID(), linkData);
                String listId = el.getAttribute("lpkey", el.getValue());
                jField.put("list_id", (Object)listId);
                jField.put("list_value", (Object)el.getAttribute("lpfield"));
                BQuery cmbrs = new BQuery(this.db, comboboxSQL);
                jField.put("list", (Object)cmbrs.getJSON());
                cmbrs.close();
            } else if (el.getName().equals("COMBOLIST")) {
                JSONArray jComboList = new JSONArray();
                for (BElement ell : el.getElements()) {
                    String mykey = ell.getAttribute("key", ell.getValue());
                    JSONObject jItem = new JSONObject();
                    jItem.put("id", (Object)mykey);
                    jItem.put("value", (Object)ell.getValue());
                    jComboList.put((Object)jItem);
                }
                jField.put("list_id", (Object)"id");
                jField.put("list_value", (Object)"value");
                jField.put("list", (Object)jComboList);
            }
            jTable.put((Object)jField);
        }
        jResp.put("form", (Object)jTable);
        if (view.getAttribute("location", "false").equals("true")) {
            JSONObject jField = new JSONObject();
            jField.put("longitude", (Object)"longitude");
            jField.put("latitude", (Object)"latitude");
            jResp.put("location", (Object)jField);
        }
        String keyField = view.getAttribute("keyfield");
        String keyData = request.getParameter("keydata");
        if (keyData != null && keyField != null) {
            String whereSql = keyField + "='" + keyData + "'";
            BQuery rs = new BQuery(this.db, view, whereSql, null, user, false);
            if (rs.moveNext()) {
                JSONArray jData = new JSONArray(rs.getJSON());
                jResp.put("data", (Object)jData);
            }
            rs.close();
        }
        return jResp;
    }

    public JSONObject securedData(HttpServletRequest request, String userId) {
        JSONObject jResp = new JSONObject();
        String body = BWebUtils.requestBody(request);
        if (body == null) {
            body = "{}";
        }
        String viewKey = request.getParameter("view");
        String keyData = request.getParameter("keydata");
        String linkData = request.getParameter("linkdata");
        BElement view = this.getView(viewKey);
        BUser user = this.users.get(userId);
        System.out.println("BASE 2010 : linkData " + linkData);
        System.out.println("BASE 2020 : keyData " + keyData);
        System.out.println("BASE 2020 : body " + body);
        if (!view.getName().equals("FORM")) {
            return jResp;
        }
        JSONObject jParams = new JSONObject(body);
        String saveMsg = this.postData(view, request.getRemoteAddr(), jParams, user, keyData, linkData);
        if (saveMsg.equals("")) {
            jResp.put("ResultCode", 0);
            jResp.put("ResultDesc", (Object)"Data posted");
        } else {
            jResp.put("ResultCode", 2);
            jResp.put("ResultDesc", (Object)saveMsg);
        }
        return jResp;
    }

    public JSONObject getGridDef(HttpServletRequest request, String userId) {
        JSONObject jResp = new JSONObject();
        String viewKey = request.getParameter("view");
        BElement view = this.getView(viewKey);
        BUser user = this.users.get(userId);
        if (view.getName().equals("FORM")) {
            return jResp;
        }
        JSONArray jGrid = new JSONArray();
        JSONArray jViews = new JSONArray();
        for (BElement el : view.getElements()) {
            int viewType = BWebUtils.getViewType(el.getName());
            int fieldType = BWebUtils.getFieldType(el.getName());
            if (viewType == 0) {
                if (el.getAttribute("title") == null) continue;
                JSONObject jField = new JSONObject();
                jField.put("type", fieldType);
                jField.put("name", (Object)el.getValue());
                jField.put("title", (Object)el.getAttribute("title"));
                jGrid.put((Object)jField);
                continue;
            }
            JSONObject jView = new JSONObject();
            jView.put("type", (Object)el.getName());
            jView.put("typeId", viewType);
            jView.put("name", (Object)el.getAttribute("name"));
            if (viewType == 7) {
                if (el.getAttribute("new", "true").equals("true")) {
                    jView.put("new", true);
                }
                if (el.getAttribute("edit", "true").equals("true")) {
                    jView.put("edit", true);
                }
            }
            jViews.put((Object)jView);
        }
        jResp.put("grid", (Object)jGrid);
        jResp.put("views", (Object)jViews);
        String opList = this.getActions(view, user);
        if (opList != null) {
            JSONArray jAList = new JSONArray(opList);
            jResp.put("actions", (Object)jAList);
        }
        return jResp;
    }

    public JSONObject readData(HttpServletRequest request, String userId) {
        BQuery rs;
        JSONObject jResp = new JSONObject();
        String linkData = request.getParameter("linkdata");
        String viewKey = request.getParameter("view");
        BElement view = this.getView(viewKey);
        BUser user = this.users.get(userId);
        if (view.getName().equals("FORM")) {
            return jResp;
        }
        String whereSql = request.getParameter("where");
        if (BWebUtils.checkInjection(whereSql)) {
            whereSql = null;
        }
        System.out.println("BASE 3020 WHERE : " + whereSql);
        if (view.getAttribute("linkfield") != null) {
            whereSql = whereSql == null ? "(" + view.getAttribute("linkfield") + " = '" + linkData + "')" : " AND (" + view.getAttribute("linkfield") + " = '" + linkData + "')";
        }
        if ((rs = new BQuery(this.db, view, whereSql, null, user, false)).moveNext()) {
            JSONArray jTable = new JSONArray(rs.getJSON());
            jResp.put("data", (Object)jTable);
        }
        rs.close();
        return jResp;
    }

    public String getActions(BElement view, BUser user) {
        String opList = null;
        BElement opt = view.getElementByName("ACTIONS");
        if (opt != null) {
            Integer i = 0;
            for (BElement el : opt.getElements()) {
                boolean hasAccess = user.checkAccess(el.getAttribute("role"), el.getAttribute("access"));
                if (hasAccess) {
                    opList = opList == null ? "{aid:" + i.toString() + ", action:\"" + el.getValue() + "\"}" : opList + ",{aid:" + i.toString() + ", action:\"" + el.getValue() + "\"}";
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        if (opList != null) {
            opList = "[" + opList + "]";
        }
        return opList;
    }

    public JSONObject doActions(HttpServletRequest request, String userId) {
        JSONObject jResp = new JSONObject();
        String body = BWebUtils.requestBody(request);
        if (body == null) {
            body = "{}";
        }
        String viewKey = request.getParameter("view");
        String action = request.getParameter("action");
        System.out.println("BASE 3350 : " + action);
        System.out.println("BASE 3360 : " + body);
        BElement view = this.getView(viewKey);
        BUser user = this.users.get(userId);
        if (!view.getName().equals("GRID")) {
            return jResp;
        }
        JSONArray jIds = new JSONArray(body);
        String saveMsg = this.doActions(view, action, request.getRemoteAddr(), jIds, user, null);
        jResp.put("ResultCode", 0);
        jResp.put("ResultMsg", (Object)saveMsg);
        return jResp;
    }

    public String getReport(HttpServletRequest request, String userId, String reportPath) {
        JSONObject jResp = new JSONObject();
        String body = BWebUtils.requestBody(request);
        if (body == null) {
            body = "{}";
        }
        String linkData = request.getParameter("linkdata");
        String viewKey = request.getParameter("view");
        BElement view = this.getView(viewKey);
        BUser user = this.users.get(userId);
        System.out.println("BASE 4040 : " + linkData);
        if (!view.getName().equals("JASPER")) {
            return "";
        }
        BWebReport webReport = new BWebReport(view, user.getUserID(), user.getGroupID(), request);
        if (linkData != null) {
            webReport.setParams("filterid", linkData);
        }
        String reportHtml = "<html><head></head><body>\n";
        reportHtml = reportHtml + webReport.getReport(this.db, user, linkData, request, reportPath);
        reportHtml = reportHtml + "\n</body>";
        return reportHtml;
    }

    public BElement getView(String viewKey) {
        String[] sv;
        System.out.println("BASE 4040 : " + viewKey);
        ArrayList<BElement> views = new ArrayList<BElement>();
        ArrayList<String> viewKeys = new ArrayList<String>();
        for (String svs : sv = viewKey.split(":")) {
            viewKeys.add(svs);
        }
        views.add(this.root.getElementByKey(sv[0]));
        for (int i = 1; i < sv.length; ++i) {
            int subNo = Integer.valueOf(sv[i]);
            views.add(((BElement)views.get(i - 1)).getSub(subNo));
        }
        BElement view = (BElement)views.get(views.size() - 1);
        System.out.println("BASE 4070 : " + view.toString());
        return view;
    }

    public String postData(BElement view, String remoteAddr, JSONObject jParams, BUser user, String keyData, String linkData) {
        BQuery rs;
        String fWhere;
        ArrayList<String> viewData = new ArrayList<String>();
        HashMap<String, String[]> newParams = new HashMap<String, String[]>();
        for (String paramName : jParams.keySet()) {
            String[] pArray = new String[]{jParams.getString(paramName)};
            newParams.put(paramName, pArray);
        }
        String saveMsg = null;
        if (keyData == null) {
            fWhere = view.getAttribute("keyfield") + " = null";
            rs = new BQuery(this.db, view, fWhere, null, user, true);
            rs.recAdd();
            if (view.getAttribute("linkfield") != null && linkData != null) {
                rs.updateField(view.getAttribute("linkfield"), linkData);
            }
            saveMsg = rs.updateFields(newParams, viewData, remoteAddr, linkData);
            rs.close();
        } else {
            fWhere = view.getAttribute("keyfield") + "='" + keyData + "'";
            rs = new BQuery(this.db, view, fWhere, null, user, true);
            rs.moveFirst();
            rs.recEdit();
            if (view.getAttribute("linkfield") != null && linkData != null) {
                rs.updateField(view.getAttribute("linkfield"), linkData);
            }
            saveMsg = rs.updateFields(newParams, viewData, remoteAddr, linkData);
            rs.close();
        }
        return saveMsg;
    }

    public String doActions(BElement view, String action, String remoteAddr, JSONArray jIds, BUser user, String linkData) {
        Integer aPos = new Integer(action);
        BElement el = view.getElementByName("ACTIONS").getElement(aPos);
        String mySql = "";
        String saveMsg = "";
        if (el != null) {
            for (int i = 0; i < jIds.length(); ++i) {
                JSONObject jId = jIds.getJSONObject(i);
                String value = jId.getString("id");
                String auditSql = user.insAudit(el.getAttribute("fnct"), value, "FUNCTION");
                String autoKeyID = this.db.executeAutoKey(auditSql);
                mySql = "SELECT " + el.getAttribute("fnct") + "('" + value + "', '" + user.getUserID();
                if (el.getAttribute("approval") != null) {
                    mySql = mySql + "', '" + el.getAttribute("approval");
                }
                mySql = el.getAttribute("phase") != null ? mySql + "', '" + el.getAttribute("phase") : mySql + "', '" + linkData;
                if (el.getAttribute("auditid") != null) {
                    mySql = mySql + "', '" + autoKeyID;
                }
                mySql = mySql + "') ";
                if (el.getAttribute("from") != null) {
                    mySql = mySql + " " + el.getAttribute("from");
                }
                this.log.info(mySql);
                System.out.println("BASE 5050 : " + mySql);
                String exans = this.db.executeFunction(mySql);
                saveMsg = exans == null ? saveMsg + this.db.getLastErrorMsg() + "; " : saveMsg + exans + "; ";
            }
        }
        return saveMsg;
    }
}

