/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.baraza.DB.BDB;
import org.baraza.utils.BWebUtils;
import org.baraza.web.BDataOps;
import org.baraza.xml.BElement;
import org.baraza.xml.BXML;
import org.json.JSONObject;

public class BDataServer
extends HttpServlet {
    Logger log = Logger.getLogger(BDataServer.class.getName());
    BElement root = null;
    BDB db = null;
    BDataOps dataOps = null;
    String reportPath = "./";

    public void init(ServletConfig config) throws ServletException {
        BXML xml;
        super.init(config);
        ServletContext context = config.getServletContext();
        String xmlCnf = config.getInitParameter("xmlfile");
        String projectDir = context.getInitParameter("projectDir");
        String ps = System.getProperty("file.separator");
        String xmlFile = context.getRealPath("WEB-INF") + ps + "configs" + ps + xmlCnf;
        this.reportPath = context.getRealPath("reports") + ps;
        if (projectDir != null) {
            xmlFile = projectDir + ps + "configs" + ps + xmlCnf;
            this.reportPath = projectDir + ps + "reports" + ps;
        }
        if ((xml = new BXML(xmlFile, false)).getDocument() != null) {
            this.root = xml.getRoot();
            String dbconfig = "java:/comp/env/jdbc/database";
            this.db = new BDB(dbconfig);
            this.db.setOrgID(this.root.getAttribute("org"));
            this.dataOps = new BDataOps(this.root, this.db);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String resp = "";
        this.log.info("Start Data Server");
        BWebUtils.showHeaders(request);
        BWebUtils.showParameters(request);
        String action = request.getHeader("action");
        if (action == null) {
            return;
        }
        System.out.println("BASE 2010 : " + action);
        int contentType = 1;
        JSONObject jResp = new JSONObject();
        if (action.equals("authorization")) {
            jResp = this.dataOps.authenticate(request);
        } else if (action.equals("udata")) {
            jResp = this.dataOps.unsecuredData(request);
        } else if (action.equals("uform")) {
            jResp = this.dataOps.getUForm(request);
        } else {
            jResp = this.dataOps.reAuthenticate(request.getHeader("authorization"));
            if (jResp.has("ResultCode") && jResp.getInt("ResultCode") == 0) {
                String userId = jResp.getString("userId");
                System.out.println("BASE userId : " + userId);
                if (action.equals("menu")) {
                    jResp = this.dataOps.getMenu(request, userId);
                } else if (action.equals("view")) {
                    jResp = this.dataOps.getView(request, userId);
                } else if (action.equals("form")) {
                    jResp = this.dataOps.getForm(request, userId);
                } else if (action.equals("grid")) {
                    jResp = this.dataOps.getGridDef(request, userId);
                } else if (action.equals("data")) {
                    jResp = this.dataOps.securedData(request, userId);
                } else if (action.equals("read")) {
                    jResp = this.dataOps.readData(request, userId);
                } else if (action.equals("actions")) {
                    jResp = this.dataOps.doActions(request, userId);
                } else if (action.equals("report")) {
                    resp = this.dataOps.getReport(request, userId, this.reportPath);
                    contentType = 2;
                } else {
                    jResp.put("ResultCode", 10);
                    jResp.put("userId", (Object)"-1");
                    jResp.put("message", (Object)"Make right action call");
                }
            }
        }
        if (contentType == 1) {
            resp = jResp.toString();
            response.setContentType("application/json;charset=\"utf-8\"");
            System.out.println("BASE jRETURN : " + resp);
        } else if (contentType == 2) {
            response.setContentType("text/html");
        }
        PrintWriter out = null;
        try {
            out = response.getWriter();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        out.println(resp);
        this.log.info("End Data Server");
    }

    public void destroy() {
        this.db.close();
    }
}

