/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.baraza.utils.Bio;
import org.baraza.xml.BElement;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class BXML {
    Logger log = Logger.getLogger(BXML.class.getName());
    String xmlFile = null;
    BElement root = null;

    public BXML(String xml, boolean isText) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = null;
            if (isText) {
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                document = builder.parse(in);
            } else {
                document = builder.parse(xml);
                this.xmlFile = xml;
            }
            this.root = new BElement(document);
        }
        catch (SAXParseException ex) {
            this.log.severe("XML Error : " + ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            this.log.severe("File IO error : " + ex);
        }
        catch (SAXException ex) {
            this.log.severe("File IO error : " + ex);
        }
        catch (IOException ex) {
            this.log.severe("File IO error : " + ex);
        }
        catch (Exception ex) {
            this.log.severe("File createtion error");
        }
    }

    public BXML(InputStream inXml) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inXml);
            this.root = new BElement(document);
        }
        catch (SAXParseException ex) {
            this.log.severe("XML Error : " + ex.getMessage());
        }
        catch (ParserConfigurationException ex) {
            this.log.severe("File IO error : " + ex);
        }
        catch (SAXException ex) {
            this.log.severe("File IO error : " + ex);
        }
        catch (IOException ex) {
            this.log.severe("File IO error : " + ex);
        }
        catch (Exception ex) {
            this.log.severe("File createtion error");
        }
    }

    public BElement getDocument() {
        return this.root;
    }

    public BElement getRoot() {
        return this.root.getFirst();
    }

    public void saveFile() {
        if (this.xmlFile != null) {
            BElement el = this.root.getFirst();
            Bio io = new Bio();
            io.saveFile(this.xmlFile, el.toString());
        }
    }

    public void saveFile(String fileName) {
        if (fileName != null) {
            BElement el = this.root.getFirst();
            Bio io = new Bio();
            io.saveFile(fileName, el.toString());
        }
    }
}

