/*
 * Decompiled with CFR 0.152.
 */
package org.baraza.xml;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;
import org.baraza.xml.BElement;
import org.baraza.xml.BTreeNode;

public class BXMLTable
extends AbstractTableModel {
    BElement element;
    BTreeNode node;
    DefaultTreeModel treemodel;
    Vector<String> titles;

    public BXMLTable(BTreeNode node, DefaultTreeModel treemodel) {
        this.node = node;
        this.treemodel = treemodel;
        this.element = node.getKey();
        this.titles = new Vector();
        this.titles.add("Name");
        this.titles.add("Value");
    }

    @Override
    public int getColumnCount() {
        return this.titles.size();
    }

    @Override
    public int getRowCount() {
        return this.element.getSize() + 1;
    }

    @Override
    public String getColumnName(int aCol) {
        return this.titles.get(aCol);
    }

    @Override
    public Object getValueAt(int aRow, int aCol) {
        return this.element.getValueAt(aRow, aCol);
    }

    public Class getColumnClass(int aCol) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int aRow, int aCol) {
        return true;
    }

    public void refresh() {
        this.fireTableChanged(null);
    }

    public void insertRow() {
        this.element.insertAttribute("", "");
        this.refresh();
    }

    public void removeRow(int aRow) {
        String key = this.element.getValueAt(aRow, 0);
        this.element.delAttribute(key);
        this.refresh();
    }

    @Override
    public void setValueAt(Object value, int aRow, int aCol) {
        this.element.setValueAt(value.toString().replaceAll("<", "&lt;"), aRow, aCol);
        String title = this.element.getName() + " : ";
        if (this.element.getAttribute("title") != null) {
            title = title + this.element.getAttribute("title");
        } else if (this.element.getAttribute("name") != null) {
            title = title + this.element.getAttribute("name");
        }
        this.node.setUserObject(title);
        this.treemodel.reload(this.node);
        this.fireTableCellUpdated(aRow, aCol);
    }
}

